/* spek-ruler.c generated by valac 0.10.4, the Vala compiler
 * generated from spek-ruler.vala, do not modify */

/* spek-ruler.vala
 *
 * Copyright (C) 2010,2011  Alexander Kojevnikov <alexander@kojevnikov.com>
 *
 * Spek is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Spek is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Spek.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <cairo.h>
#include <pango/pango.h>
#include <pango/pangocairo.h>


#define SPEK_TYPE_RULER (spek_ruler_get_type ())
#define SPEK_RULER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPEK_TYPE_RULER, SpekRuler))
#define SPEK_RULER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPEK_TYPE_RULER, SpekRulerClass))
#define SPEK_IS_RULER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPEK_TYPE_RULER))
#define SPEK_IS_RULER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPEK_TYPE_RULER))
#define SPEK_RULER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPEK_TYPE_RULER, SpekRulerClass))

typedef struct _SpekRuler SpekRuler;
typedef struct _SpekRulerClass SpekRulerClass;
typedef struct _SpekRulerPrivate SpekRulerPrivate;

#define SPEK_RULER_TYPE_POSITION (spek_ruler_position_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))

struct _SpekRuler {
	GObject parent_instance;
	SpekRulerPrivate * priv;
};

struct _SpekRulerClass {
	GObjectClass parent_class;
};

typedef enum  {
	SPEK_RULER_POSITION_TOP,
	SPEK_RULER_POSITION_RIGHT,
	SPEK_RULER_POSITION_BOTTOM,
	SPEK_RULER_POSITION_LEFT
} SpekRulerPosition;

typedef double (*SpekRulerMeasure) (gint unit, void* user_data);
typedef double (*SpekRulerPlace) (double p, void* user_data);
typedef char* (*SpekRulerFormatTick) (gint unit, void* user_data);
struct _SpekRulerPrivate {
	SpekRulerPosition pos;
	char* sample_label;
	gint* factors;
	gint factors_length1;
	gint _factors_size_;
	gint units;
	double spacing;
	SpekRulerMeasure measure;
	gpointer measure_target;
	GDestroyNotify measure_target_destroy_notify;
	SpekRulerPlace place;
	gpointer place_target;
	GDestroyNotify place_target_destroy_notify;
	SpekRulerFormatTick format_tick;
	gpointer format_tick_target;
	GDestroyNotify format_tick_target_destroy_notify;
};


static gpointer spek_ruler_parent_class = NULL;

GType spek_ruler_get_type (void) G_GNUC_CONST;
GType spek_ruler_position_get_type (void) G_GNUC_CONST;
#define SPEK_RULER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SPEK_TYPE_RULER, SpekRulerPrivate))
enum  {
	SPEK_RULER_DUMMY_PROPERTY
};
SpekRuler* spek_ruler_new (SpekRulerPosition pos, const char* sample_label, gint* factors, int factors_length1, gint units, double spacing, SpekRulerMeasure measure, void* measure_target, SpekRulerPlace place, void* place_target, SpekRulerFormatTick format_tick, void* format_tick_target);
SpekRuler* spek_ruler_construct (GType object_type, SpekRulerPosition pos, const char* sample_label, gint* factors, int factors_length1, gint units, double spacing, SpekRulerMeasure measure, void* measure_target, SpekRulerPlace place, void* place_target, SpekRulerFormatTick format_tick, void* format_tick_target);
static gint* _vala_array_dup1 (gint* self, int length);
void spek_ruler_draw (SpekRuler* self, cairo_t* cr, PangoLayout* layout);
static void _vala_array_add6 (gint** array, int* length, int* size, gint value);
static void spek_ruler_finalize (GObject* obj);



GType spek_ruler_position_get_type (void) {
	static volatile gsize spek_ruler_position_type_id__volatile = 0;
	if (g_once_init_enter (&spek_ruler_position_type_id__volatile)) {
		static const GEnumValue values[] = {{SPEK_RULER_POSITION_TOP, "SPEK_RULER_POSITION_TOP", "top"}, {SPEK_RULER_POSITION_RIGHT, "SPEK_RULER_POSITION_RIGHT", "right"}, {SPEK_RULER_POSITION_BOTTOM, "SPEK_RULER_POSITION_BOTTOM", "bottom"}, {SPEK_RULER_POSITION_LEFT, "SPEK_RULER_POSITION_LEFT", "left"}, {0, NULL, NULL}};
		GType spek_ruler_position_type_id;
		spek_ruler_position_type_id = g_enum_register_static ("SpekRulerPosition", values);
		g_once_init_leave (&spek_ruler_position_type_id__volatile, spek_ruler_position_type_id);
	}
	return spek_ruler_position_type_id__volatile;
}


static gint* _vala_array_dup1 (gint* self, int length) {
	return g_memdup (self, length * sizeof (gint));
}


SpekRuler* spek_ruler_construct (GType object_type, SpekRulerPosition pos, const char* sample_label, gint* factors, int factors_length1, gint units, double spacing, SpekRulerMeasure measure, void* measure_target, SpekRulerPlace place, void* place_target, SpekRulerFormatTick format_tick, void* format_tick_target) {
	SpekRuler * self = NULL;
	char* _tmp0_;
	gint* _tmp1_;
	gint* _tmp2_;
	SpekRulerMeasure _tmp3_;
	SpekRulerPlace _tmp4_;
	SpekRulerFormatTick _tmp5_;
	g_return_val_if_fail (sample_label != NULL, NULL);
	self = (SpekRuler*) g_object_new (object_type, NULL);
	self->priv->pos = pos;
	self->priv->sample_label = (_tmp0_ = g_strdup (sample_label), _g_free0 (self->priv->sample_label), _tmp0_);
	self->priv->factors = (_tmp2_ = (_tmp1_ = factors, (_tmp1_ == NULL) ? ((gpointer) _tmp1_) : _vala_array_dup1 (_tmp1_, factors_length1)), self->priv->factors = (g_free (self->priv->factors), NULL), self->priv->factors_length1 = factors_length1, self->priv->_factors_size_ = self->priv->factors_length1, _tmp2_);
	self->priv->units = units;
	self->priv->spacing = spacing;
	self->priv->measure = (_tmp3_ = measure, ((self->priv->measure_target_destroy_notify == NULL) ? NULL : (self->priv->measure_target_destroy_notify (self->priv->measure_target), NULL), self->priv->measure = NULL, self->priv->measure_target = NULL, self->priv->measure_target_destroy_notify = NULL), self->priv->measure_target = measure_target, self->priv->measure_target_destroy_notify = NULL, _tmp3_);
	self->priv->place = (_tmp4_ = place, ((self->priv->place_target_destroy_notify == NULL) ? NULL : (self->priv->place_target_destroy_notify (self->priv->place_target), NULL), self->priv->place = NULL, self->priv->place_target = NULL, self->priv->place_target_destroy_notify = NULL), self->priv->place_target = place_target, self->priv->place_target_destroy_notify = NULL, _tmp4_);
	self->priv->format_tick = (_tmp5_ = format_tick, ((self->priv->format_tick_target_destroy_notify == NULL) ? NULL : (self->priv->format_tick_target_destroy_notify (self->priv->format_tick_target), NULL), self->priv->format_tick = NULL, self->priv->format_tick_target = NULL, self->priv->format_tick_target_destroy_notify = NULL), self->priv->format_tick_target = format_tick_target, self->priv->format_tick_target_destroy_notify = NULL, _tmp5_);
	return self;
}


SpekRuler* spek_ruler_new (SpekRulerPosition pos, const char* sample_label, gint* factors, int factors_length1, gint units, double spacing, SpekRulerMeasure measure, void* measure_target, SpekRulerPlace place, void* place_target, SpekRulerFormatTick format_tick, void* format_tick_target) {
	return spek_ruler_construct (SPEK_TYPE_RULER, pos, sample_label, factors, factors_length1, units, spacing, measure, measure_target, place, place_target, format_tick, format_tick_target);
}


static void _vala_array_add6 (gint** array, int* length, int* size, gint value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gint, *array, *size);
	}
	(*array)[(*length)++] = value;
}


void spek_ruler_draw (SpekRuler* self, cairo_t* cr, PangoLayout* layout) {
	gint w = 0;
	gint h = 0;
	gint _tmp0_ = 0;
	gboolean _tmp1_ = FALSE;
	gint size;
	gint factor;
	gint ticks_length1;
	gint _ticks_size_;
	gint* _tmp3_;
	gint* _tmp2_ = NULL;
	gint* ticks;
	double GAP;
	double TICK_LEN;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	g_return_if_fail (layout != NULL);
	pango_layout_set_text (layout, self->priv->sample_label, -1);
	pango_layout_get_pixel_size (layout, &w, &h);
	if (self->priv->pos == SPEK_RULER_POSITION_TOP) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = self->priv->pos == SPEK_RULER_POSITION_BOTTOM;
	}
	if (_tmp1_) {
		_tmp0_ = w;
	} else {
		_tmp0_ = h;
	}
	size = _tmp0_;
	factor = 0;
	{
		gint* f_collection;
		int f_collection_length1;
		int f_it;
		f_collection = self->priv->factors;
		f_collection_length1 = self->priv->factors_length1;
		for (f_it = 0; f_it < self->priv->factors_length1; f_it = f_it + 1) {
			gint f;
			f = f_collection[f_it];
			{
				if (self->priv->measure (f, self->priv->measure_target) >= (self->priv->spacing * size)) {
					factor = f;
					break;
				}
			}
		}
	}
	ticks = (_tmp3_ = (_tmp2_ = g_new0 (gint, 2), _tmp2_[0] = 0, _tmp2_[1] = self->priv->units, _tmp2_), ticks_length1 = 2, _ticks_size_ = ticks_length1, _tmp3_);
	if (factor > 0) {
		{
			gint tick;
			tick = factor;
			{
				gboolean _tmp4_;
				_tmp4_ = TRUE;
				while (TRUE) {
					if (!_tmp4_) {
						tick = tick + factor;
					}
					_tmp4_ = FALSE;
					if (!(tick < self->priv->units)) {
						break;
					}
					if (self->priv->measure (self->priv->units - tick, self->priv->measure_target) < (size * 1.2)) {
						break;
					}
					_vala_array_add6 (&ticks, &ticks_length1, &_ticks_size_, tick);
				}
			}
		}
	}
	GAP = (double) 10;
	TICK_LEN = (double) 4;
	{
		gint* tick_collection;
		int tick_collection_length1;
		int tick_it;
		tick_collection = ticks;
		tick_collection_length1 = ticks_length1;
		for (tick_it = 0; tick_it < ticks_length1; tick_it = tick_it + 1) {
			gint tick;
			tick = tick_collection[tick_it];
			{
				char* label;
				gint _tmp5_ = 0;
				gboolean _tmp6_ = FALSE;
				double p;
				label = self->priv->format_tick (tick, self->priv->format_tick_target);
				if (self->priv->pos == SPEK_RULER_POSITION_TOP) {
					_tmp6_ = TRUE;
				} else {
					_tmp6_ = self->priv->pos == SPEK_RULER_POSITION_BOTTOM;
				}
				if (_tmp6_) {
					_tmp5_ = tick;
				} else {
					_tmp5_ = self->priv->units - tick;
				}
				p = self->priv->place (self->priv->measure (_tmp5_, self->priv->measure_target), self->priv->place_target);
				pango_layout_set_text (layout, label, -1);
				pango_layout_get_pixel_size (layout, &w, &h);
				if (self->priv->pos == SPEK_RULER_POSITION_TOP) {
					cairo_move_to (cr, p - (w / 2), (-GAP) - h);
				} else {
					if (self->priv->pos == SPEK_RULER_POSITION_RIGHT) {
						cairo_move_to (cr, GAP, p + (h / 4));
					} else {
						if (self->priv->pos == SPEK_RULER_POSITION_BOTTOM) {
							cairo_move_to (cr, p - (w / 2), GAP + h);
						} else {
							if (self->priv->pos == SPEK_RULER_POSITION_LEFT) {
								cairo_move_to (cr, (-w) - GAP, p + (h / 4));
							}
						}
					}
				}
				pango_cairo_show_layout_line (cr, pango_layout_get_line (layout, 0));
				if (self->priv->pos == SPEK_RULER_POSITION_TOP) {
					cairo_move_to (cr, p, (double) 0);
					cairo_rel_line_to (cr, (double) 0, -TICK_LEN);
				} else {
					if (self->priv->pos == SPEK_RULER_POSITION_RIGHT) {
						cairo_move_to (cr, (double) 0, p);
						cairo_rel_line_to (cr, TICK_LEN, (double) 0);
					} else {
						if (self->priv->pos == SPEK_RULER_POSITION_BOTTOM) {
							cairo_move_to (cr, p, (double) 0);
							cairo_rel_line_to (cr, (double) 0, TICK_LEN);
						} else {
							if (self->priv->pos == SPEK_RULER_POSITION_LEFT) {
								cairo_move_to (cr, (double) 0, p);
								cairo_rel_line_to (cr, -TICK_LEN, (double) 0);
							}
						}
					}
				}
				cairo_stroke (cr);
				_g_free0 (label);
			}
		}
	}
	ticks = (g_free (ticks), NULL);
}


static void spek_ruler_class_init (SpekRulerClass * klass) {
	spek_ruler_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SpekRulerPrivate));
	G_OBJECT_CLASS (klass)->finalize = spek_ruler_finalize;
}


static void spek_ruler_instance_init (SpekRuler * self) {
	self->priv = SPEK_RULER_GET_PRIVATE (self);
}


static void spek_ruler_finalize (GObject* obj) {
	SpekRuler * self;
	self = SPEK_RULER (obj);
	_g_free0 (self->priv->sample_label);
	self->priv->factors = (g_free (self->priv->factors), NULL);
	(self->priv->measure_target_destroy_notify == NULL) ? NULL : (self->priv->measure_target_destroy_notify (self->priv->measure_target), NULL);
	self->priv->measure = NULL;
	self->priv->measure_target = NULL;
	self->priv->measure_target_destroy_notify = NULL;
	(self->priv->place_target_destroy_notify == NULL) ? NULL : (self->priv->place_target_destroy_notify (self->priv->place_target), NULL);
	self->priv->place = NULL;
	self->priv->place_target = NULL;
	self->priv->place_target_destroy_notify = NULL;
	(self->priv->format_tick_target_destroy_notify == NULL) ? NULL : (self->priv->format_tick_target_destroy_notify (self->priv->format_tick_target), NULL);
	self->priv->format_tick = NULL;
	self->priv->format_tick_target = NULL;
	self->priv->format_tick_target_destroy_notify = NULL;
	G_OBJECT_CLASS (spek_ruler_parent_class)->finalize (obj);
}


GType spek_ruler_get_type (void) {
	static volatile gsize spek_ruler_type_id__volatile = 0;
	if (g_once_init_enter (&spek_ruler_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SpekRulerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) spek_ruler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SpekRuler), 0, (GInstanceInitFunc) spek_ruler_instance_init, NULL };
		GType spek_ruler_type_id;
		spek_ruler_type_id = g_type_register_static (G_TYPE_OBJECT, "SpekRuler", &g_define_type_info, 0);
		g_once_init_leave (&spek_ruler_type_id__volatile, spek_ruler_type_id);
	}
	return spek_ruler_type_id__volatile;
}




