// Global vars
var gPref = Components.classes["@mozilla.org/preferences-service;1"]
               .getService(Components.interfaces.nsIPrefService)
               .QueryInterface(Components.interfaces.nsIPrefBranch2);
var updateTimer = null;
var numGroups = 0;

function Startup() {
  refreshGroupsList();
  SpeedDialPrefObserver.addPrefObserver();
}

function Unload() {
  SpeedDialPrefObserver.removePrefObserver();
}

function refreshGroupsList() {
  var list = document.getElementById("groupsList");
  var oldSelectedItems = new Array();
  
  for (var c=0; c<list.selectedItems.length; c++) {
    oldSelectedItems[list.selectedItems[c].getAttribute("groupnumber")] = true;
  }
  
  list.clearSelection();

  while (list.firstChild) {
    list.removeChild(list.firstChild);
  }

  numGroups = gPref.getIntPref("extensions.speeddial.numGroups");
  var speedDialBundle = document.getElementById("bundle_speeddial");

  for (var b=1; b<=numGroups; b++) {
    var row = document.createElement("listitem");
    row.id = "";
    row.setAttribute("groupnumber", b);
    if (gPref.prefHasUserValue("extensions.speeddial.group-" + b + "-title")) {
      row.setAttribute("label", gPref.getComplexValue("extensions.speeddial.group-" + b + "-title", Components.interfaces.nsISupportsString).data);
    } else {
      row.setAttribute("label", speedDialBundle.getFormattedString("untitledGroup.label", [b]));
    }
    list.appendChild(row);
    
    if (oldSelectedItems["" + b]) {
      list.addItemToSelection(row);
    }
  }
}

function groupsListSelect(e) {
  var moveUpButton = document.getElementById("moveUpButton");
  var moveDownButton = document.getElementById("moveDownButton");
  var editButton = document.getElementById("editButton");
  var removeButton = document.getElementById("removeButton");
  var list = document.getElementById("groupsList");

  if (list.selectedCount > 1) {
    moveUpButton.setAttribute("disabled", "true");
    moveDownButton.setAttribute("disabled", "true");
    editButton.setAttribute("disabled", "true");
    removeButton.setAttribute("disabled", "false");
  } else if (list.selectedItem) {
    if (list.selectedIndex == 0) {
      moveUpButton.setAttribute("disabled", "true");
    } else {
      moveUpButton.setAttribute("disabled", "false");
    }
    if (list.selectedIndex == (numGroups - 1)) {
      moveDownButton.setAttribute("disabled", "true");
    } else {
      moveDownButton.setAttribute("disabled", "false");
    }
    editButton.setAttribute("disabled", "false");
    removeButton.setAttribute("disabled", "false");
  } else {
    moveUpButton.setAttribute("disabled", "true");
    moveDownButton.setAttribute("disabled", "true");
    editButton.setAttribute("disabled", "true");
    removeButton.setAttribute("disabled", "true");
  }
}

function moveUpGroup() {
  var list = document.getElementById("groupsList");
  var currentIndex = list.selectedIndex;
  list.selectedIndex--;
  SpeedDialUtils.swapGroup(currentIndex, (currentIndex + 1));
  var list = document.getElementById("groupsList");
  setTimeout(function() { list.focus(); }, 0);
}

function moveDownGroup() {
  var list = document.getElementById("groupsList");
  var currentIndex = list.selectedIndex;
  list.selectedIndex++;
  SpeedDialUtils.swapGroup((currentIndex + 1), (currentIndex + 2));
  var list = document.getElementById("groupsList");
  setTimeout(function() { list.focus(); }, 0);
}

function editCurrentGroup() {
  var list = document.getElementById("groupsList");
  openDialog("chrome://speeddial/content/editGroup.xul", "",
             "centerscreen,chrome,dialog,resizable,dependent", [ (list.selectedIndex + 1) ]);
}

function removeCurrentGroup() {
  var list = document.getElementById("groupsList");
  var selectedItems = list.selectedItems;
  var targetIndexes = new Array(selectedItems.length);
  
  for (var c=0; c<selectedItems.length; c++) {
    targetIndexes[c] = parseInt(selectedItems[c].getAttribute("groupnumber"));
  }
  
  targetIndexes.sort(function(a,b){return b - a});
  
  var canceled = false;
  for (var c=0; (c<targetIndexes.length)&&!canceled; c++) {
    canceled = !SpeedDialUtils.removeGroup(targetIndexes[c], (c == 0));
  }
}

function addNewGroup() {
  openDialog("chrome://speeddial/content/editGroup.xul", "",
             "centerscreen,chrome,dialog,resizable,dependent", [ -1 ]);
}

var SpeedDialPrefObserver = 
{
  prefObserver : {
    observe: function(subject, topic, data) {
      // subject is the nsIPrefBranch we're observing (after appropriate QI)
      // data is the name of the pref that's been changed (relative to subject)
      if (topic == "nsPref:changed") {
        if ((data.indexOf("extensions.speeddial.group-") == 0) ||
            (data.indexOf("extensions.speeddial.numGroups") == 0)) {
          if (updateTimer == null) {
            updateTimer = Components.classes["@mozilla.org/timer;1"].createInstance(Components.interfaces.nsITimer);
          }
          updateTimer.cancel();
          updateTimer.initWithCallback(SpeedDialPrefObserver.prefObserver, 100, Components.interfaces.nsITimer.TYPE_ONE_SHOT);
        }
      }
    },
  
    QueryInterface : function (aIID) {
      if (aIID.equals(Components.interfaces.nsIObserver) || 
      aIID.equals(Components.interfaces.nsITimerCallback) ||
      aIID.equals(Components.interfaces.nsISupports) ||
      aIID.equals(Components.interfaces.nsISupportsWeakReference))
        return this;
      throw Components.results.NS_NOINTERFACE;
    },
  
    notify: function(timer) {
      refreshGroupsList();
    }
  },
  
  addPrefObserver : function () {
    if (!gPref) return;
    try {
      gPref.addObserver("extensions.speeddial.", SpeedDialPrefObserver.prefObserver, true);
    } catch (e) { }
  },

  removePrefObserver : function () {
    if (!gPref) return;
    try {
      gPref.removeObserver("extensions.speeddial.", SpeedDialPrefObserver.prefObserver);
    } catch (e) { }
  }
};
