/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg_ext" on Tue Jul 14 19:02:34 2020

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#if defined(_WIN32) && !defined(__MINGW32__)
#include "config-msvc.h"
#else
#include "config.h"
#endif

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_39 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def_ex (filter, first, last, 7625, "epsg", 7625,
        "NAD83(2011) / WISCRS Polk (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.66111111111111 +lon_0=-92.63333333");
    add_proj4text (p, 1,
        "333334 +k=1.0000433849 +x_0=141732.2822453645 +y_0=0.005");
    add_proj4text (p, 2,
        "791211582423164 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Polk (ftUS)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syst");
    add_srs_wkt (p, 2,
        "em_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",44.66");
    add_srs_wkt (p, 8,
        "11111111111],PARAMETER[\"central_meridian\",-92.63333333");
    add_srs_wkt (p, 9,
        "33333],PARAMETER[\"scale_factor\",1.0000433849],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_easting\",464999.996],PARAMETER[\"false_northi");
    add_srs_wkt (p, 11,
        "ng\",0.019],UNIT[\"US survey foot\",0.304800609601219,AU");
    add_srs_wkt (p, 12,
        "THORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 13,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7625\"]]");
    p = add_epsg_def_ex (filter, first, last, 7626, "epsg", 7626,
        "NAD83(2011) / WISCRS Portage (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.41682397527777 +lat_0=44.41682397527");
    add_proj4text (p, 1,
        "777 +lon_0=-89.5 +k_0=1.000039936 +x_0=56388.11277622555");
    add_proj4text (p, 2,
        " +y_0=50022.1874523749 +ellps=GRS80 +units=us-ft +no_def");
    add_proj4text (p, 3,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Portage (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"La");
    add_srs_wkt (p, 7,
        "mbert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_ori");
    add_srs_wkt (p, 8,
        "gin\",44.4168239752778],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 9,
        "89.5],PARAMETER[\"scale_factor\",1.000039936],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_easting\",185000],PARAMETER[\"false_northing\",1");
    add_srs_wkt (p, 11,
        "64114.46],UNIT[\"US survey foot\",0.304800609601219,AUTH");
    add_srs_wkt (p, 12,
        "ORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 13,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"7626\"]]");
    p = add_epsg_def_ex (filter, first, last, 7627, "epsg", 7627,
        "NAD83(2011) / WISCRS Price (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.55555555555555 +lon_0=-90.48888888");
    add_proj4text (p, 1,
        "888889 +k=1.0000649554 +x_0=227990.8544577089 +y_0=0.010");
    add_proj4text (p, 2,
        "97282194564389 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Price (ftUS)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sys");
    add_srs_wkt (p, 2,
        "tem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",44.5");
    add_srs_wkt (p, 8,
        "555555555556],PARAMETER[\"central_meridian\",-90.4888888");
    add_srs_wkt (p, 9,
        "888889],PARAMETER[\"scale_factor\",1.0000649554],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_easting\",747999.995],PARAMETER[\"false_north");
    add_srs_wkt (p, 11,
        "ing\",0.036],UNIT[\"US survey foot\",0.304800609601219,A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 13,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7627\"]]");
    p = add_epsg_def_ex (filter, first, last, 7628, "epsg", 7628,
        "NAD83(2011) / WISCRS Richland (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.3223129275 +lat_0=43.3223129275 +lon");
    add_proj4text (p, 1,
        "_0=-90.43055555555556 +k_0=1.0000375653 +x_0=202387.6047");
    add_proj4text (p, 2,
        "752095 +y_0=134255.4254508509 +ellps=GRS80 +units=us-ft ");
    add_proj4text (p, 3,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Richland (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"La");
    add_srs_wkt (p, 7,
        "mbert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_ori");
    add_srs_wkt (p, 8,
        "gin\",43.3223129275],PARAMETER[\"central_meridian\",-90.");
    add_srs_wkt (p, 9,
        "4305555555556],PARAMETER[\"scale_factor\",1.0000375653],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_easting\",664000],PARAMETER[\"false_no");
    add_srs_wkt (p, 11,
        "rthing\",440469.675],UNIT[\"US survey foot\",0.304800609");
    add_srs_wkt (p, 12,
        "601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 13,
        "ST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7628\"");
    add_srs_wkt (p, 14,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 7629, "epsg", 7629,
        "NAD83(2011) / WISCRS Rock (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.94444444444444 +lon_0=-89.07222222");
    add_proj4text (p, 1,
        "222222 +k=1.0000337311 +x_0=146304.2926085852 +y_0=0.006");
    add_proj4text (p, 2,
        "705613411226822 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Rock (ftUS)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syst");
    add_srs_wkt (p, 2,
        "em_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",41.94");
    add_srs_wkt (p, 8,
        "44444444444],PARAMETER[\"central_meridian\",-89.07222222");
    add_srs_wkt (p, 9,
        "22222],PARAMETER[\"scale_factor\",1.0000337311],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_easting\",480000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",0.022],UNIT[\"US survey foot\",0.304800609601219,AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 13,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"7629\"]]");
    p = add_epsg_def_ex (filter, first, last, 7630, "epsg", 7630,
        "NAD83(2011) / WISCRS Rusk (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.91944444444444 +lon_0=-91.06666666");
    add_proj4text (p, 1,
        "666666 +k=1.0000495976 +x_0=250546.1013970028 +y_0=0.023");
    add_proj4text (p, 2,
        "46964693929388 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Rusk (ftUS)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syst");
    add_srs_wkt (p, 2,
        "em_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",43.91");
    add_srs_wkt (p, 8,
        "94444444444],PARAMETER[\"central_meridian\",-91.06666666");
    add_srs_wkt (p, 9,
        "66667],PARAMETER[\"scale_factor\",1.0000495976],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_easting\",822000.001],PARAMETER[\"false_northi");
    add_srs_wkt (p, 11,
        "ng\",0.077],UNIT[\"US survey foot\",0.304800609601219,AU");
    add_srs_wkt (p, 12,
        "THORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 13,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7630\"]]");
    p = add_epsg_def_ex (filter, first, last, 7631, "epsg", 7631,
        "NAD83(2011) / WISCRS Sauk (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.81944444444445 +lon_0=-89.90000000");
    add_proj4text (p, 1,
        "000001 +k=1.0000373868 +x_0=185623.5715519431 +y_0=0.005");
    add_proj4text (p, 2,
        "181610363220727 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Sauk (ftUS)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syst");
    add_srs_wkt (p, 2,
        "em_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",42.81");
    add_srs_wkt (p, 8,
        "94444444444],PARAMETER[\"central_meridian\",-89.9],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",1.0000373868],PARAMETER[\"false_ea");
    add_srs_wkt (p, 10,
        "sting\",609000.001],PARAMETER[\"false_northing\",0.017],");
    add_srs_wkt (p, 11,
        "UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"EP");
    add_srs_wkt (p, 12,
        "SG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"7631\"]]");
    p = add_epsg_def_ex (filter, first, last, 7632, "epsg", 7632,
        "NAD83(2011) / WISCRS Sawyer (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.90009913138888 +lat_0=45.90009913138");
    add_proj4text (p, 1,
        "888 +lon_0=-91.11666666666666 +k_0=1.0000573461 +x_0=216");
    add_proj4text (p, 2,
        "713.2337312675 +y_0=120734.1631699263 +ellps=GRS80 +unit");
    add_proj4text (p, 3,
        "s=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Sawyer (ftUS)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sy");
    add_srs_wkt (p, 2,
        "stem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lamb");
    add_srs_wkt (p, 7,
        "ert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",45.9000991313889],PARAMETER[\"central_meridian\",-91");
    add_srs_wkt (p, 9,
        ".1166666666667],PARAMETER[\"scale_factor\",1.0000573461]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",711000.001],PARAMETER[\"fal");
    add_srs_wkt (p, 11,
        "se_northing\",396108.667],UNIT[\"US survey foot\",0.3048");
    add_srs_wkt (p, 12,
        "00609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting");
    add_srs_wkt (p, 13,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 14,
        "632\"]]");
    p = add_epsg_def_ex (filter, first, last, 7633, "epsg", 7633,
        "NAD83(2011) / WISCRS Shawano (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.03611111111111 +lon_0=-88.60555555");
    add_proj4text (p, 1,
        "555555 +k=1.000032144 +x_0=262433.3251714504 +y_0=0.0094");
    add_proj4text (p, 2,
        "48818897637795 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Shawano (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Tr");
    add_srs_wkt (p, 7,
        "ansverse_Mercator\"],PARAMETER[\"latitude_of_origin\",44");
    add_srs_wkt (p, 8,
        ".0361111111111],PARAMETER[\"central_meridian\",-88.60555");
    add_srs_wkt (p, 9,
        "55555556],PARAMETER[\"scale_factor\",1.000032144],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_easting\",861000.001],PARAMETER[\"false_nort");
    add_srs_wkt (p, 11,
        "hing\",0.031],UNIT[\"US survey foot\",0.304800609601219,");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXI");
    add_srs_wkt (p, 13,
        "S[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7633\"]]");
    p = add_epsg_def_ex (filter, first, last, 7634, "epsg", 7634,
        "NAD83(2011) / WISCRS St. Croix (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.03611111111111 +lon_0=-92.63333333");
    add_proj4text (p, 1,
        "333334 +k=1.0000381803 +x_0=165506.7300990602 +y_0=0.010");
    add_proj4text (p, 2,
        "36322072644145 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS St. Croix (ftUS)\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference");
    add_srs_wkt (p, 2,
        "_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.2572221");
    add_srs_wkt (p, 3,
        "01,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"11");
    add_srs_wkt (p, 4,
        "16\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",4");
    add_srs_wkt (p, 8,
        "4.0361111111111],PARAMETER[\"central_meridian\",-92.6333");
    add_srs_wkt (p, 9,
        "333333333],PARAMETER[\"scale_factor\",1.0000381803],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_easting\",542999.997],PARAMETER[\"false_no");
    add_srs_wkt (p, 11,
        "rthing\",0.034],UNIT[\"US survey foot\",0.30480060960121");
    add_srs_wkt (p, 12,
        "9,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 13,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7634\"]]");
    p = add_epsg_def_ex (filter, first, last, 7635, "epsg", 7635,
        "NAD83(2011) / WISCRS Taylor (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.17782208583333 +lat_0=45.17782208583");
    add_proj4text (p, 1,
        "333 +lon_0=-90.48333333333333 +k_0=1.0000597566 +x_0=187");
    add_proj4text (p, 2,
        "147.5742951486 +y_0=107746.7521463043 +ellps=GRS80 +unit");
    add_proj4text (p, 3,
        "s=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Taylor (ftUS)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sy");
    add_srs_wkt (p, 2,
        "stem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lamb");
    add_srs_wkt (p, 7,
        "ert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",45.1778220858333],PARAMETER[\"central_meridian\",-90");
    add_srs_wkt (p, 9,
        ".4833333333333],PARAMETER[\"scale_factor\",1.0000597566]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",614000],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",353499.136],UNIT[\"US survey foot\",0.30480060");
    add_srs_wkt (p, 12,
        "9601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",E");
    add_srs_wkt (p, 13,
        "AST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7635\"");
    add_srs_wkt (p, 14,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 7636, "epsg", 7636,
        "NAD83(2011) / WISCRS Trempealeau (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.16111111111111 +lon_0=-91.36666666");
    add_proj4text (p, 1,
        "666666 +k=1.0000361538 +x_0=256946.9138938278 +y_0=0.003");
    add_proj4text (p, 2,
        "962407924815849 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Trempealeau (ftUS)\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Referen");
    add_srs_wkt (p, 2,
        "ce_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.25722");
    add_srs_wkt (p, 3,
        "2101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",43.1611111111111],PARAMETER[\"central_meridian\",-91.36");
    add_srs_wkt (p, 9,
        "66666666667],PARAMETER[\"scale_factor\",1.0000361538],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_easting\",843000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 11,
        "hing\",0.013],UNIT[\"US survey foot\",0.304800609601219,");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXI");
    add_srs_wkt (p, 13,
        "S[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7636\"]]");
    p = add_epsg_def_ex (filter, first, last, 7637, "epsg", 7637,
        "NAD83(2011) / WISCRS Vernon (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.57503293972223 +lat_0=43.57503293972");
    add_proj4text (p, 1,
        "223 +lon_0=-90.78333333333333 +k_0=1.0000408158 +x_0=222");
    add_proj4text (p, 2,
        "504.44500889 +y_0=47532.0603505207 +ellps=GRS80 +units=u");
    add_proj4text (p, 3,
        "s-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Vernon (ftUS)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sy");
    add_srs_wkt (p, 2,
        "stem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lamb");
    add_srs_wkt (p, 7,
        "ert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",43.5750329397222],PARAMETER[\"central_meridian\",-90");
    add_srs_wkt (p, 9,
        ".7833333333333],PARAMETER[\"scale_factor\",1.0000408158]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",730000],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",155944.768],UNIT[\"US survey foot\",0.30480060");
    add_srs_wkt (p, 12,
        "9601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",E");
    add_srs_wkt (p, 13,
        "AST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7637\"");
    add_srs_wkt (p, 14,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 7638, "epsg", 7638,
        "NAD83(2011) / WISCRS Vilas (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46.07784409055556 +lat_0=46.07784409055");
    add_proj4text (p, 1,
        "556 +lon_0=-89.48888888888889 +k_0=1.0000730142 +x_0=134");
    add_proj4text (p, 2,
        "417.0688341377 +y_0=50337.10927101854 +ellps=GRS80 +unit");
    add_proj4text (p, 3,
        "s=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Vilas (ftUS)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sys");
    add_srs_wkt (p, 2,
        "tem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lamb");
    add_srs_wkt (p, 7,
        "ert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",46.0778440905556],PARAMETER[\"central_meridian\",-89");
    add_srs_wkt (p, 9,
        ".4888888888889],PARAMETER[\"scale_factor\",1.0000730142]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",441000],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",165147.666],UNIT[\"US survey foot\",0.30480060");
    add_srs_wkt (p, 12,
        "9601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",E");
    add_srs_wkt (p, 13,
        "AST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7638\"");
    add_srs_wkt (p, 14,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 7639, "epsg", 7639,
        "NAD83(2011) / WISCRS Walworth (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=42.66946209694444 +lat_0=42.66946209694");
    add_proj4text (p, 1,
        "444 +lon_0=-88.54166666666667 +k_0=1.0000367192 +x_0=232");
    add_proj4text (p, 2,
        "562.8651257302 +y_0=111088.2224028448 +ellps=GRS80 +unit");
    add_proj4text (p, 3,
        "s=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Walworth (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"La");
    add_srs_wkt (p, 7,
        "mbert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_ori");
    add_srs_wkt (p, 8,
        "gin\",42.6694620969444],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 9,
        "88.5416666666667],PARAMETER[\"scale_factor\",1.000036719");
    add_srs_wkt (p, 10,
        "2],PARAMETER[\"false_easting\",763000],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_northing\",364461.943],UNIT[\"US survey foot\",0.304800");
    add_srs_wkt (p, 12,
        "609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 13,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"763");
    add_srs_wkt (p, 14,
        "9\"]]");
    p = add_epsg_def_ex (filter, first, last, 7640, "epsg", 7640,
        "NAD83(2011) / WISCRS Washburn (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.96121983333334 +lat_0=45.96121983333");
    add_proj4text (p, 1,
        "334 +lon_0=-91.78333333333333 +k_0=1.0000475376 +x_0=234");
    add_proj4text (p, 2,
        "086.8681737363 +y_0=188358.6059436119 +ellps=GRS80 +unit");
    add_proj4text (p, 3,
        "s=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Washburn (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"La");
    add_srs_wkt (p, 7,
        "mbert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_ori");
    add_srs_wkt (p, 8,
        "gin\",45.9612198333333],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 9,
        "91.7833333333333],PARAMETER[\"scale_factor\",1.000047537");
    add_srs_wkt (p, 10,
        "6],PARAMETER[\"false_easting\",768000],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_northing\",617973.193],UNIT[\"US survey foot\",0.304800");
    add_srs_wkt (p, 12,
        "609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 13,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"764");
    add_srs_wkt (p, 14,
        "0\"]]");
    p = add_epsg_def_ex (filter, first, last, 7641, "epsg", 7641,
        "NAD83(2011) / WISCRS Washington (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.91805555555555 +lon_0=-88.06388888");
    add_proj4text (p, 1,
        "888888 +k=1.00003738 +x_0=120091.4414020828 +y_0=0.00304");
    add_proj4text (p, 2,
        "8006096012192 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Washington (ftUS)\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Referenc");
    add_srs_wkt (p, 2,
        "e_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1");
    add_srs_wkt (p, 4,
        "116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"");
    add_srs_wkt (p, 7,
        "Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 8,
        "42.9180555555556],PARAMETER[\"central_meridian\",-88.063");
    add_srs_wkt (p, 9,
        "8888888889],PARAMETER[\"scale_factor\",1.00003738],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_easting\",394000.004],PARAMETER[\"false_nor");
    add_srs_wkt (p, 11,
        "thing\",0.01],UNIT[\"US survey foot\",0.304800609601219,");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXI");
    add_srs_wkt (p, 13,
        "S[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7641\"]]");
    p = add_epsg_def_ex (filter, first, last, 7642, "epsg", 7642,
        "NAD83(2011) / WISCRS Waukesha (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.56944444444445 +lon_0=-88.22499999");
    add_proj4text (p, 1,
        "999999 +k=1.0000346179 +x_0=208788.4178816358 +y_0=0.003");
    add_proj4text (p, 2,
        "352806705613411 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Waukesha (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Tr");
    add_srs_wkt (p, 7,
        "ansverse_Mercator\"],PARAMETER[\"latitude_of_origin\",42");
    add_srs_wkt (p, 8,
        ".5694444444444],PARAMETER[\"central_meridian\",-88.225],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"scale_factor\",1.0000346179],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",685000.001],PARAMETER[\"false_northing\",0.");
    add_srs_wkt (p, 11,
        "011],UNIT[\"US survey foot\",0.304800609601219,AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 13,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"7642\"]]");
    p = add_epsg_def_ex (filter, first, last, 7643, "epsg", 7643,
        "NAD83(2011) / WISCRS Waupaca (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.42027777777778 +lon_0=-88.81666666");
    add_proj4text (p, 1,
        "666666 +k=1.0000333645 +x_0=185013.9709423419 +y_0=0.007");
    add_proj4text (p, 2,
        "010414020828041 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Waupaca (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Tr");
    add_srs_wkt (p, 7,
        "ansverse_Mercator\"],PARAMETER[\"latitude_of_origin\",43");
    add_srs_wkt (p, 8,
        ".4202777777778],PARAMETER[\"central_meridian\",-88.81666");
    add_srs_wkt (p, 9,
        "66666667],PARAMETER[\"scale_factor\",1.0000333645],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_easting\",607000.003],PARAMETER[\"false_nor");
    add_srs_wkt (p, 11,
        "thing\",0.023],UNIT[\"US survey foot\",0.304800609601219");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AX");
    add_srs_wkt (p, 13,
        "IS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7643\"]]");
    p = add_epsg_def_ex (filter, first, last, 7644, "epsg", 7644,
        "NAD83(2011) / WISCRS Waushara (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.11394404583334 +lat_0=44.11394404583");
    add_proj4text (p, 1,
        "334 +lon_0=-89.24166666666667 +k_0=1.0000392096 +x_0=120");
    add_proj4text (p, 2,
        "091.4401828804 +y_0=45069.7588011176 +ellps=GRS80 +units");
    add_proj4text (p, 3,
        "=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Waushara (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"La");
    add_srs_wkt (p, 7,
        "mbert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_ori");
    add_srs_wkt (p, 8,
        "gin\",44.1139440458333],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 9,
        "89.2416666666667],PARAMETER[\"scale_factor\",1.000039209");
    add_srs_wkt (p, 10,
        "6],PARAMETER[\"false_easting\",394000],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_northing\",147866.367],UNIT[\"US survey foot\",0.304800");
    add_srs_wkt (p, 12,
        "609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 13,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"764");
    add_srs_wkt (p, 14,
        "4\"]]");
    p = add_epsg_def_ex (filter, first, last, 7645, "epsg", 7645,
        "NAD83(2011) / WISCRS Wood (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.36259546944444 +lat_0=44.36259546944");
    add_proj4text (p, 1,
        "444 +lon_0=-90 +k_0=1.0000421209 +x_0=208483.6172720346 ");
    add_proj4text (p, 2,
        "+y_0=134589.7539243078 +ellps=GRS80 +units=us-ft +no_def");
    add_proj4text (p, 3,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Wood (ftUS)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syst");
    add_srs_wkt (p, 2,
        "em_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambe");
    add_srs_wkt (p, 7,
        "rt_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin");
    add_srs_wkt (p, 8,
        "\",44.3625954694444],PARAMETER[\"central_meridian\",-90]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"scale_factor\",1.0000421209],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_easting\",684000.001],PARAMETER[\"false_northing\",4");
    add_srs_wkt (p, 11,
        "41566.551],UNIT[\"US survey foot\",0.304800609601219,AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 13,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"7645\"]]");
    p = add_epsg_def_ex (filter, first, last, 7657, "epsg", 7657,
        "WGS 84 (G730)", 1, 1,
        "WGS 84", "Greenwich",
        "World_Geodetic_System_1984_G730", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"WGS 84 (G730)\",DATUM[\"World Geodetic System ");
    add_srs_wkt (p, 1,
        "1984 (G730)\",ELLIPSOID[\"WGS 84\",6378137,298.257223563");
    add_srs_wkt (p, 2,
        ",LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEU");
    add_srs_wkt (p, 3,
        "NIT[\"degree\",0.0174532925199433]],CS[ellipsoidal,3],AX");
    add_srs_wkt (p, 4,
        "IS[\"geodetic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433]],AXIS[\"geodetic longitud");
    add_srs_wkt (p, 6,
        "e (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 7,
        "5199433]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LE");
    add_srs_wkt (p, 8,
        "NGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"unknown\"],AREA[\"W");
    add_srs_wkt (p, 9,
        "orld\"],BBOX[-90,-180,90,180]],ID[\"EPSG\",7657]]");
    p = add_epsg_def_ex (filter, first, last, 7659, "epsg", 7659,
        "WGS 84 (G873)", 1, 1,
        "WGS 84", "Greenwich",
        "World_Geodetic_System_1984_G873", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"WGS 84 (G873)\",DATUM[\"World Geodetic System ");
    add_srs_wkt (p, 1,
        "1984 (G873)\",ELLIPSOID[\"WGS 84\",6378137,298.257223563");
    add_srs_wkt (p, 2,
        ",LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEU");
    add_srs_wkt (p, 3,
        "NIT[\"degree\",0.0174532925199433]],CS[ellipsoidal,3],AX");
    add_srs_wkt (p, 4,
        "IS[\"geodetic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433]],AXIS[\"geodetic longitud");
    add_srs_wkt (p, 6,
        "e (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 7,
        "5199433]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LE");
    add_srs_wkt (p, 8,
        "NGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"unknown\"],AREA[\"W");
    add_srs_wkt (p, 9,
        "orld\"],BBOX[-90,-180,90,180]],ID[\"EPSG\",7659]]");
    p = add_epsg_def_ex (filter, first, last, 7661, "epsg", 7661,
        "WGS 84 (G1150)", 1, 1,
        "WGS 84", "Greenwich",
        "World_Geodetic_System_1984_G1150", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"WGS 84 (G1150)\",DATUM[\"World Geodetic System");
    add_srs_wkt (p, 1,
        " 1984 (G1150)\",ELLIPSOID[\"WGS 84\",6378137,298.2572235");
    add_srs_wkt (p, 2,
        "63,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGL");
    add_srs_wkt (p, 3,
        "EUNIT[\"degree\",0.0174532925199433]],CS[ellipsoidal,3],");
    add_srs_wkt (p, 4,
        "AXIS[\"geodetic latitude (Lat)\",north,ORDER[1],ANGLEUNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433]],AXIS[\"geodetic longit");
    add_srs_wkt (p, 6,
        "ude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 7,
        "925199433]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3],");
    add_srs_wkt (p, 8,
        "LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"unknown\"],AREA[\"");
    add_srs_wkt (p, 9,
        "World\"],BBOX[-90,-180,90,180]],ID[\"EPSG\",7661]]");
    p = add_epsg_def_ex (filter, first, last, 7663, "epsg", 7663,
        "WGS 84 (G1674)", 1, 1,
        "WGS 84", "Greenwich",
        "World_Geodetic_System_1984_G1674", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"WGS 84 (G1674)\",DATUM[\"World Geodetic System");
    add_srs_wkt (p, 1,
        " 1984 (G1674)\",ELLIPSOID[\"WGS 84\",6378137,298.2572235");
    add_srs_wkt (p, 2,
        "63,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGL");
    add_srs_wkt (p, 3,
        "EUNIT[\"degree\",0.0174532925199433]],CS[ellipsoidal,3],");
    add_srs_wkt (p, 4,
        "AXIS[\"geodetic latitude (Lat)\",north,ORDER[1],ANGLEUNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433]],AXIS[\"geodetic longit");
    add_srs_wkt (p, 6,
        "ude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 7,
        "925199433]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3],");
    add_srs_wkt (p, 8,
        "LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"unknown\"],AREA[\"");
    add_srs_wkt (p, 9,
        "World\"],BBOX[-90,-180,90,180]],ID[\"EPSG\",7663]]");
    p = add_epsg_def_ex (filter, first, last, 7665, "epsg", 7665,
        "WGS 84 (G1762)", 1, 1,
        "WGS 84", "Greenwich",
        "World_Geodetic_System_1984_G1762", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"WGS 84 (G1762)\",DATUM[\"World Geodetic System");
    add_srs_wkt (p, 1,
        " 1984 (G1762)\",ELLIPSOID[\"WGS 84\",6378137,298.2572235");
    add_srs_wkt (p, 2,
        "63,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGL");
    add_srs_wkt (p, 3,
        "EUNIT[\"degree\",0.0174532925199433]],CS[ellipsoidal,3],");
    add_srs_wkt (p, 4,
        "AXIS[\"geodetic latitude (Lat)\",north,ORDER[1],ANGLEUNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433]],AXIS[\"geodetic longit");
    add_srs_wkt (p, 6,
        "ude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 7,
        "925199433]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3],");
    add_srs_wkt (p, 8,
        "LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"unknown\"],AREA[\"");
    add_srs_wkt (p, 9,
        "World\"],BBOX[-90,-180,90,180]],ID[\"EPSG\",7665]]");
    p = add_epsg_def_ex (filter, first, last, 7678, "epsg", 7678,
        "PZ-90.02", 1, 1,
        "PZ-90", "Greenwich",
        "Parametry_Zemli_1990_02", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378136 +rf=298.257839303 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"PZ-90.02\",DATUM[\"Parametry Zemli 1990.02\",E");
    add_srs_wkt (p, 1,
        "LLIPSOID[\"PZ-90\",6378136,298.257839303,LENGTHUNIT[\"me");
    add_srs_wkt (p, 2,
        "tre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\",0");
    add_srs_wkt (p, 3,
        ".0174532925199433]],CS[ellipsoidal,3],AXIS[\"geodetic la");
    add_srs_wkt (p, 4,
        "titude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433]],AXIS[\"geodetic longitude (Lon)\",east,O");
    add_srs_wkt (p, 6,
        "RDER[2],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"");
    add_srs_wkt (p, 7,
        "ellipsoidal height (h)\",up,ORDER[3],LENGTHUNIT[\"metre\"");
    add_srs_wkt (p, 8,
        ",1]],USAGE[SCOPE[\"unknown\"],AREA[\"World\"],BBOX[-90,-");
    add_srs_wkt (p, 9,
        "180,90,180]],ID[\"EPSG\",7678]]");
    p = add_epsg_def_ex (filter, first, last, 7680, "epsg", 7680,
        "PZ-90.11", 1, 1,
        "PZ-90", "Greenwich",
        "Parametry_Zemli_1990_11", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378136 +rf=298.257839303 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"PZ-90.11\",DATUM[\"Parametry Zemli 1990.11\",E");
    add_srs_wkt (p, 1,
        "LLIPSOID[\"PZ-90\",6378136,298.257839303,LENGTHUNIT[\"me");
    add_srs_wkt (p, 2,
        "tre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\",0");
    add_srs_wkt (p, 3,
        ".0174532925199433]],CS[ellipsoidal,3],AXIS[\"geodetic la");
    add_srs_wkt (p, 4,
        "titude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433]],AXIS[\"geodetic longitude (Lon)\",east,O");
    add_srs_wkt (p, 6,
        "RDER[2],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"");
    add_srs_wkt (p, 7,
        "ellipsoidal height (h)\",up,ORDER[3],LENGTHUNIT[\"metre\"");
    add_srs_wkt (p, 8,
        ",1]],USAGE[SCOPE[\"unknown\"],AREA[\"World\"],BBOX[-90,-");
    add_srs_wkt (p, 9,
        "180,90,180]],ID[\"EPSG\",7680]]");
    p = add_epsg_def_ex (filter, first, last, 7682, "epsg", 7682,
        "GSK-2011", 1, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GSK2011 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"GSK-2011\",DATUM[\"Geodezicheskaya Sistema Koo");
    add_srs_wkt (p, 1,
        "rdinat 2011\",ELLIPSOID[\"GSK-2011\",6378136.5,298.25641");
    add_srs_wkt (p, 2,
        "51,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGL");
    add_srs_wkt (p, 3,
        "EUNIT[\"degree\",0.0174532925199433]],CS[ellipsoidal,3],");
    add_srs_wkt (p, 4,
        "AXIS[\"geodetic latitude (Lat)\",north,ORDER[1],ANGLEUNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433]],AXIS[\"geodetic longit");
    add_srs_wkt (p, 6,
        "ude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 7,
        "925199433]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3],");
    add_srs_wkt (p, 8,
        "LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"unknown\"],AREA[\"");
    add_srs_wkt (p, 9,
        "Russia\"],BBOX[39.87,18.92,85.2,-168.97]],ID[\"EPSG\",76");
    add_srs_wkt (p, 10,
        "82]]");
    p = add_epsg_def_ex (filter, first, last, 7683, "epsg", 7683,
        "GSK-2011", 1, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378136.5 +b=6356751.757955603 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"GSK-2011\",DATUM[\"Geodezicheskaya_Sistema_Koor");
    add_srs_wkt (p, 1,
        "dinat_2011\",SPHEROID[\"GSK-2011\",6378136.5,298.2564151");
    add_srs_wkt (p, 2,
        ",AUTHORITY[\"EPSG\",\"1025\"]],AUTHORITY[\"EPSG\",\"1159");
    add_srs_wkt (p, 3,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 4,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",E");
    add_srs_wkt (p, 6,
        "AST],AUTHORITY[\"EPSG\",\"7683\"]]");
    p = add_epsg_def_ex (filter, first, last, 7685, "epsg", 7685,
        "Kyrg-06", 1, 1,
        "GRS 1980", "Greenwich",
        "Kyrgyzstan_Geodetic_Datum_2006", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"Kyrg-06\",DATUM[\"Kyrgyzstan Geodetic Datum 20");
    add_srs_wkt (p, 1,
        "06\",ELLIPSOID[\"GRS 1980\",6378137,298.257222101,LENGTH");
    add_srs_wkt (p, 2,
        "UNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"d");
    add_srs_wkt (p, 3,
        "egree\",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"ge");
    add_srs_wkt (p, 4,
        "odetic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433]],AXIS[\"geodetic longitude (Lon)");
    add_srs_wkt (p, 6,
        "\",east,ORDER[2],ANGLEUNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 7,
        "]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHUNI");
    add_srs_wkt (p, 8,
        "T[\"metre\",1]],USAGE[SCOPE[\"unknown\"],AREA[\"Kyrgyzst");
    add_srs_wkt (p, 9,
        "an\"],BBOX[39.19,69.24,43.22,80.29]],ID[\"EPSG\",7685]]");
    p = add_epsg_def_ex (filter, first, last, 7686, "epsg", 7686,
        "Kyrg-06", 1, 1,
        "GRS 1980", "Greenwich",
        "Kyrgyzstan_Geodetic_Datum_2006", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Kyrg-06\",DATUM[\"Kyrgyzstan_Geodetic_Datum_200");
    add_srs_wkt (p, 1,
        "6\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 2,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1160\"]],PRIM");
    add_srs_wkt (p, 3,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 4,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 5,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"7686\"]]");
    p = add_epsg_def_ex (filter, first, last, 7692, "epsg", 7692,
        "Kyrg-06 / zone 1", 0, 0,
        "GRS 1980", "Greenwich",
        "Kyrgyzstan_Geodetic_Datum_2006", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=68.51666666666667 +k=1 +x_0=");
    add_proj4text (p, 1,
        "1300000 +y_0=14743.5 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kyrg-06 / zone 1\",GEOGCS[\"Kyrg-06\",DATUM[\"K");
    add_srs_wkt (p, 1,
        "yrgyzstan_Geodetic_Datum_2006\",SPHEROID[\"GRS 1980\",63");
    add_srs_wkt (p, 2,
        "78137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"1160\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"7686\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
        "ude_of_origin\",0],PARAMETER[\"central_meridian\",68.516");
    add_srs_wkt (p, 8,
        "6666666667],PARAMETER[\"scale_factor\",1],PARAMETER[\"fa");
    add_srs_wkt (p, 9,
        "lse_easting\",1300000],PARAMETER[\"false_northing\",1474");
    add_srs_wkt (p, 10,
        "3.5],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS");
    add_srs_wkt (p, 11,
        "[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"7692\"]]");
    p = add_epsg_def_ex (filter, first, last, 7693, "epsg", 7693,
        "Kyrg-06 / zone 2", 0, 0,
        "GRS 1980", "Greenwich",
        "Kyrgyzstan_Geodetic_Datum_2006", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=71.51666666666667 +k=1 +x_0=");
    add_proj4text (p, 1,
        "2300000 +y_0=14743.5 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kyrg-06 / zone 2\",GEOGCS[\"Kyrg-06\",DATUM[\"K");
    add_srs_wkt (p, 1,
        "yrgyzstan_Geodetic_Datum_2006\",SPHEROID[\"GRS 1980\",63");
    add_srs_wkt (p, 2,
        "78137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"1160\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"7686\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
        "ude_of_origin\",0],PARAMETER[\"central_meridian\",71.516");
    add_srs_wkt (p, 8,
        "6666666667],PARAMETER[\"scale_factor\",1],PARAMETER[\"fa");
    add_srs_wkt (p, 9,
        "lse_easting\",2300000],PARAMETER[\"false_northing\",1474");
    add_srs_wkt (p, 10,
        "3.5],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS");
    add_srs_wkt (p, 11,
        "[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"7693\"]]");
    p = add_epsg_def_ex (filter, first, last, 7694, "epsg", 7694,
        "Kyrg-06 / zone 3", 0, 0,
        "GRS 1980", "Greenwich",
        "Kyrgyzstan_Geodetic_Datum_2006", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=74.51666666666667 +k=1 +x_0=");
    add_proj4text (p, 1,
        "3300000 +y_0=14743.5 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kyrg-06 / zone 3\",GEOGCS[\"Kyrg-06\",DATUM[\"K");
    add_srs_wkt (p, 1,
        "yrgyzstan_Geodetic_Datum_2006\",SPHEROID[\"GRS 1980\",63");
    add_srs_wkt (p, 2,
        "78137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"1160\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"7686\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
        "ude_of_origin\",0],PARAMETER[\"central_meridian\",74.516");
    add_srs_wkt (p, 8,
        "6666666667],PARAMETER[\"scale_factor\",1],PARAMETER[\"fa");
    add_srs_wkt (p, 9,
        "lse_easting\",3300000],PARAMETER[\"false_northing\",1474");
    add_srs_wkt (p, 10,
        "3.5],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS");
    add_srs_wkt (p, 11,
        "[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"7694\"]]");
    p = add_epsg_def_ex (filter, first, last, 7695, "epsg", 7695,
        "Kyrg-06 / zone 4", 0, 0,
        "GRS 1980", "Greenwich",
        "Kyrgyzstan_Geodetic_Datum_2006", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=77.51666666666667 +k=1 +x_0=");
    add_proj4text (p, 1,
        "4300000 +y_0=14743.5 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kyrg-06 / zone 4\",GEOGCS[\"Kyrg-06\",DATUM[\"K");
    add_srs_wkt (p, 1,
        "yrgyzstan_Geodetic_Datum_2006\",SPHEROID[\"GRS 1980\",63");
    add_srs_wkt (p, 2,
        "78137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"1160\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"7686\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
        "ude_of_origin\",0],PARAMETER[\"central_meridian\",77.516");
    add_srs_wkt (p, 8,
        "6666666667],PARAMETER[\"scale_factor\",1],PARAMETER[\"fa");
    add_srs_wkt (p, 9,
        "lse_easting\",4300000],PARAMETER[\"false_northing\",1474");
    add_srs_wkt (p, 10,
        "3.5],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS");
    add_srs_wkt (p, 11,
        "[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"7695\"]]");
    p = add_epsg_def_ex (filter, first, last, 7696, "epsg", 7696,
        "Kyrg-06 / zone 5", 0, 0,
        "GRS 1980", "Greenwich",
        "Kyrgyzstan_Geodetic_Datum_2006", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=80.51666666666667 +k=1 +x_0=");
    add_proj4text (p, 1,
        "5300000 +y_0=14743.5 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kyrg-06 / zone 5\",GEOGCS[\"Kyrg-06\",DATUM[\"K");
    add_srs_wkt (p, 1,
        "yrgyzstan_Geodetic_Datum_2006\",SPHEROID[\"GRS 1980\",63");
    add_srs_wkt (p, 2,
        "78137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"1160\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"7686\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
        "ude_of_origin\",0],PARAMETER[\"central_meridian\",80.516");
    add_srs_wkt (p, 8,
        "6666666667],PARAMETER[\"scale_factor\",1],PARAMETER[\"fa");
    add_srs_wkt (p, 9,
        "lse_easting\",5300000],PARAMETER[\"false_northing\",1474");
    add_srs_wkt (p, 10,
        "3.5],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS");
    add_srs_wkt (p, 11,
        "[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"7696\"]]");
    p = add_epsg_def_ex (filter, first, last, 7755, "epsg", 7755,
        "WGS 84 / India NSF LCC", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=12.472955 +lat_2=35.17280444444444 +lat");
    add_proj4text (p, 1,
        "_0=24 +lon_0=80 +x_0=4000000 +y_0=4000000 +datum=WGS84 +");
    add_proj4text (p, 2,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / India NSF LCC\",GEOGCS[\"WGS 84\",DATU");
    add_srs_wkt (p, 1,
        "M[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563");
    add_srs_wkt (p, 2,
        ",AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326");
    add_srs_wkt (p, 3,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 4,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"La");
    add_srs_wkt (p, 6,
        "mbert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_ori");
    add_srs_wkt (p, 7,
        "gin\",24],PARAMETER[\"central_meridian\",80],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "standard_parallel_1\",12.472955],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 9,
        "rallel_2\",35.1728044444444],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
        ",4000000],PARAMETER[\"false_northing\",4000000],UNIT[\"m");
    add_srs_wkt (p, 11,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",");
    add_srs_wkt (p, 12,
        "EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7755");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 7756, "epsg", 7756,
        "WGS 84 / Andhra Pradesh", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=13.75 +lat_2=18.75 +lat_0=16.25543298 +");
    add_proj4text (p, 1,
        "lon_0=80.875 +x_0=1000000 +y_0=1000000 +datum=WGS84 +uni");
    add_proj4text (p, 2,
        "ts=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / Andhra Pradesh\",GEOGCS[\"WGS 84\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.25722356");
    add_srs_wkt (p, 2,
        "3,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"632");
    add_srs_wkt (p, 3,
        "6\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 4,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"L");
    add_srs_wkt (p, 6,
        "ambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 7,
        "igin\",16.25543298],PARAMETER[\"central_meridian\",80.87");
    add_srs_wkt (p, 8,
        "5],PARAMETER[\"standard_parallel_1\",13.75],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "standard_parallel_2\",18.75],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
        ",1000000],PARAMETER[\"false_northing\",1000000],UNIT[\"m");
    add_srs_wkt (p, 11,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",");
    add_srs_wkt (p, 12,
        "EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7756");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 7757, "epsg", 7757,
        "WGS 84 / Arunachal Pradesh", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=27 +lat_2=29 +lat_0=28.00157897 +lon_0=");
    add_proj4text (p, 1,
        "94.5 +x_0=1000000 +y_0=1000000 +datum=WGS84 +units=m +no");
    add_proj4text (p, 2,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / Arunachal Pradesh\",GEOGCS[\"WGS 84\",");
    add_srs_wkt (p, 1,
        "DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.25722");
    add_srs_wkt (p, 2,
        "3563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 4,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[");
    add_srs_wkt (p, 6,
        "\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 7,
        "_origin\",28.00157897],PARAMETER[\"central_meridian\",94");
    add_srs_wkt (p, 8,
        ".5],PARAMETER[\"standard_parallel_1\",27],PARAMETER[\"st");
    add_srs_wkt (p, 9,
        "andard_parallel_2\",29],PARAMETER[\"false_easting\",1000");
    add_srs_wkt (p, 10,
        "000],PARAMETER[\"false_northing\",1000000],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 12,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7757\"]]");
    p = add_epsg_def_ex (filter, first, last, 7758, "epsg", 7758,
        "WGS 84 / Assam", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=24.66666666666667 +lat_2=27.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=26.00257703 +lon_0=92.75 +x_0=1000000 +y_0=10");
    add_proj4text (p, 2,
        "00000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / Assam\",GEOGCS[\"WGS 84\",DATUM[\"WGS_");
    add_srs_wkt (p, 1,
        "1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]],PRI");
    add_srs_wkt (p, 3,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 4,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 5,
        "],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 6,
        "formal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",26.");
    add_srs_wkt (p, 7,
        "00257703],PARAMETER[\"central_meridian\",92.75],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"standard_parallel_1\",24.6666666666667],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "standard_parallel_2\",27.3333333333333],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_easting\",1000000],PARAMETER[\"false_northing\",100000");
    add_srs_wkt (p, 11,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"7758\"]]");
    p = add_epsg_def_ex (filter, first, last, 7759, "epsg", 7759,
        "WGS 84 / Bihar", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=24.625 +lat_2=27.125 +lat_0=25.87725247");
    add_proj4text (p, 1,
        " +lon_0=85.875 +x_0=1000000 +y_0=1000000 +datum=WGS84 +u");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / Bihar\",GEOGCS[\"WGS 84\",DATUM[\"WGS_");
    add_srs_wkt (p, 1,
        "1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]],PRI");
    add_srs_wkt (p, 3,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 4,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 5,
        "],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 6,
        "formal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",25.");
    add_srs_wkt (p, 7,
        "87725247],PARAMETER[\"central_meridian\",85.875],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"standard_parallel_1\",24.625],PARAMETER[\"standard_");
    add_srs_wkt (p, 9,
        "parallel_2\",27.125],PARAMETER[\"false_easting\",1000000");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",1000000],UNIT[\"metre\",1");
    add_srs_wkt (p, 11,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AX");
    add_srs_wkt (p, 12,
        "IS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7759\"]]");
    p = add_epsg_def_ex (filter, first, last, 7760, "epsg", 7760,
        "WGS 84 / Delhi", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=28.375 +lat_2=28.875 +lat_0=28.62510126");
    add_proj4text (p, 1,
        " +lon_0=77 +x_0=1000000 +y_0=1000000 +datum=WGS84 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / Delhi\",GEOGCS[\"WGS 84\",DATUM[\"WGS_");
    add_srs_wkt (p, 1,
        "1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]],PRI");
    add_srs_wkt (p, 3,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 4,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 5,
        "],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 6,
        "formal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",28.");
    add_srs_wkt (p, 7,
        "62510126],PARAMETER[\"central_meridian\",77],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "standard_parallel_1\",28.375],PARAMETER[\"standard_paral");
    add_srs_wkt (p, 9,
        "lel_2\",28.875],PARAMETER[\"false_easting\",1000000],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_northing\",1000000],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"7760\"]]");
    p = add_epsg_def_ex (filter, first, last, 7761, "epsg", 7761,
        "WGS 84 / Gujarat", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=20.79166666666667 +lat_2=23.95833333333");
    add_proj4text (p, 1,
        "333 +lat_0=22.37807121 +lon_0=71.375 +x_0=1000000 +y_0=1");
    add_proj4text (p, 2,
        "000000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / Gujarat\",GEOGCS[\"WGS 84\",DATUM[\"WG");
    add_srs_wkt (p, 1,
        "S_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUTHO");
    add_srs_wkt (p, 2,
        "RITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]],P");
    add_srs_wkt (p, 3,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 4,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 5,
        "\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Lambert_");
    add_srs_wkt (p, 6,
        "Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 7,
        "22.37807121],PARAMETER[\"central_meridian\",71.375],PARA");
    add_srs_wkt (p, 8,
        "METER[\"standard_parallel_1\",20.7916666666667],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"standard_parallel_2\",23.9583333333333],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",1000000],PARAMETER[\"false_northing\",10");
    add_srs_wkt (p, 11,
        "00000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"7761\"]]");
    p = add_epsg_def_ex (filter, first, last, 7762, "epsg", 7762,
        "WGS 84 / Haryana", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=28.08333333333333 +lat_2=30.41666666666");
    add_proj4text (p, 1,
        "667 +lat_0=29.25226266 +lon_0=76 +x_0=1000000 +y_0=10000");
    add_proj4text (p, 2,
        "00 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / Haryana\",GEOGCS[\"WGS 84\",DATUM[\"WG");
    add_srs_wkt (p, 1,
        "S_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUTHO");
    add_srs_wkt (p, 2,
        "RITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]],P");
    add_srs_wkt (p, 3,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 4,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 5,
        "\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Lambert_");
    add_srs_wkt (p, 6,
        "Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 7,
        "29.25226266],PARAMETER[\"central_meridian\",76],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"standard_parallel_1\",28.0833333333333],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "standard_parallel_2\",30.4166666666667],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_easting\",1000000],PARAMETER[\"false_northing\",100000");
    add_srs_wkt (p, 11,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"7762\"]]");
    p = add_epsg_def_ex (filter, first, last, 7763, "epsg", 7763,
        "WGS 84 / Himachal Pradesh", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=30.75 +lat_2=32.75 +lat_0=31.75183497 +");
    add_proj4text (p, 1,
        "lon_0=77.375 +x_0=1000000 +y_0=1000000 +datum=WGS84 +uni");
    add_proj4text (p, 2,
        "ts=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / Himachal Pradesh\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",31.75183497],PARAMETER[\"central_meridian\",77.3");
    add_srs_wkt (p, 8,
        "75],PARAMETER[\"standard_parallel_1\",30.75],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "standard_parallel_2\",32.75],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
        ",1000000],PARAMETER[\"false_northing\",1000000],UNIT[\"m");
    add_srs_wkt (p, 11,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",");
    add_srs_wkt (p, 12,
        "EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7763");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 7764, "epsg", 7764,
        "WGS 84 / Jammu and Kashmir", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=33.08333333333334 +lat_2=36.41666666666");
    add_proj4text (p, 1,
        "666 +lat_0=34.75570874 +lon_0=76.5 +x_0=1000000 +y_0=100");
    add_proj4text (p, 2,
        "0000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / Jammu and Kashmir\",GEOGCS[\"WGS 84\",");
    add_srs_wkt (p, 1,
        "DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.25722");
    add_srs_wkt (p, 2,
        "3563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 4,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[");
    add_srs_wkt (p, 6,
        "\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 7,
        "_origin\",34.75570874],PARAMETER[\"central_meridian\",76");
    add_srs_wkt (p, 8,
        ".5],PARAMETER[\"standard_parallel_1\",33.0833333333333],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"standard_parallel_2\",36.4166666666667],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_easting\",1000000],PARAMETER[\"false_north");
    add_srs_wkt (p, 11,
        "ing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 12,
        "1\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 13,
        "THORITY[\"EPSG\",\"7764\"]]");
    p = add_epsg_def_ex (filter, first, last, 7765, "epsg", 7765,
        "WGS 84 / Jharkhand", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=22.54166666666667 +lat_2=24.70833333333");
    add_proj4text (p, 1,
        "333 +lat_0=23.62652682 +lon_0=85.625 +x_0=1000000 +y_0=1");
    add_proj4text (p, 2,
        "000000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / Jharkhand\",GEOGCS[\"WGS 84\",DATUM[\"");
    add_srs_wkt (p, 1,
        "WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUT");
    add_srs_wkt (p, 2,
        "HORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]]");
    add_srs_wkt (p, 3,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 4,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 5,
        "22\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Lamber");
    add_srs_wkt (p, 6,
        "t_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 7,
        ",23.62652682],PARAMETER[\"central_meridian\",85.625],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"standard_parallel_1\",22.5416666666667],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"standard_parallel_2\",24.7083333333333],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",1000000],PARAMETER[\"false_northing\",10");
    add_srs_wkt (p, 11,
        "00000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"7765\"]]");
    p = add_epsg_def_ex (filter, first, last, 7766, "epsg", 7766,
        "WGS 84 / Madhya Pradesh", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=22 +lat_2=26 +lat_0=24.00529821 +lon_0=");
    add_proj4text (p, 1,
        "78.375 +x_0=1000000 +y_0=1000000 +datum=WGS84 +units=m +");
    add_proj4text (p, 2,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / Madhya Pradesh\",GEOGCS[\"WGS 84\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.25722356");
    add_srs_wkt (p, 2,
        "3,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"632");
    add_srs_wkt (p, 3,
        "6\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 4,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"L");
    add_srs_wkt (p, 6,
        "ambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 7,
        "igin\",24.00529821],PARAMETER[\"central_meridian\",78.37");
    add_srs_wkt (p, 8,
        "5],PARAMETER[\"standard_parallel_1\",22],PARAMETER[\"sta");
    add_srs_wkt (p, 9,
        "ndard_parallel_2\",26],PARAMETER[\"false_easting\",10000");
    add_srs_wkt (p, 10,
        "00],PARAMETER[\"false_northing\",1000000],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 12,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7766\"]]");
    p = add_epsg_def_ex (filter, first, last, 7767, "epsg", 7767,
        "WGS 84 / Maharashtra", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=16.625 +lat_2=21.125 +lat_0=18.88015774");
    add_proj4text (p, 1,
        " +lon_0=76.75 +x_0=1000000 +y_0=1000000 +datum=WGS84 +un");
    add_proj4text (p, 2,
        "its=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / Maharashtra\",GEOGCS[\"WGS 84\",DATUM[");
    add_srs_wkt (p, 1,
        "\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,A");
    add_srs_wkt (p, 2,
        "UTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"");
    add_srs_wkt (p, 3,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 4,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Lamb");
    add_srs_wkt (p, 6,
        "ert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 7,
        "n\",18.88015774],PARAMETER[\"central_meridian\",76.75],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"standard_parallel_1\",16.625],PARAMETER[\"sta");
    add_srs_wkt (p, 9,
        "ndard_parallel_2\",21.125],PARAMETER[\"false_easting\",1");
    add_srs_wkt (p, 10,
        "000000],PARAMETER[\"false_northing\",1000000],UNIT[\"met");
    add_srs_wkt (p, 11,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 12,
        "ST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7767\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 7768, "epsg", 7768,
        "WGS 84 / Manipur", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=24.08333333333333 +lat_2=25.41666666666");
    add_proj4text (p, 1,
        "667 +lat_0=24.75060911 +lon_0=94 +x_0=1000000 +y_0=10000");
    add_proj4text (p, 2,
        "00 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / Manipur\",GEOGCS[\"WGS 84\",DATUM[\"WG");
    add_srs_wkt (p, 1,
        "S_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUTHO");
    add_srs_wkt (p, 2,
        "RITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]],P");
    add_srs_wkt (p, 3,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 4,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 5,
        "\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Lambert_");
    add_srs_wkt (p, 6,
        "Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 7,
        "24.75060911],PARAMETER[\"central_meridian\",94],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"standard_parallel_1\",24.0833333333333],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "standard_parallel_2\",25.4166666666667],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_easting\",1000000],PARAMETER[\"false_northing\",100000");
    add_srs_wkt (p, 11,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"7768\"]]");
    p = add_epsg_def_ex (filter, first, last, 7769, "epsg", 7769,
        "WGS 84 / Meghalaya", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=25.20833333333333 +lat_2=26.04166666666");
    add_proj4text (p, 1,
        "667 +lat_0=25.62524747 +lon_0=91.375 +x_0=1000000 +y_0=1");
    add_proj4text (p, 2,
        "000000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / Meghalaya\",GEOGCS[\"WGS 84\",DATUM[\"");
    add_srs_wkt (p, 1,
        "WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUT");
    add_srs_wkt (p, 2,
        "HORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]]");
    add_srs_wkt (p, 3,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 4,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 5,
        "22\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Lamber");
    add_srs_wkt (p, 6,
        "t_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 7,
        ",25.62524747],PARAMETER[\"central_meridian\",91.375],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"standard_parallel_1\",25.2083333333333],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"standard_parallel_2\",26.0416666666667],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",1000000],PARAMETER[\"false_northing\",10");
    add_srs_wkt (p, 11,
        "00000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"7769\"]]");
    p = add_epsg_def_ex (filter, first, last, 7770, "epsg", 7770,
        "WGS 84 / Nagaland", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=25.375 +lat_2=26.875 +lat_0=26.12581974");
    add_proj4text (p, 1,
        " +lon_0=94.375 +x_0=1000000 +y_0=1000000 +datum=WGS84 +u");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / Nagaland\",GEOGCS[\"WGS 84\",DATUM[\"W");
    add_srs_wkt (p, 1,
        "GS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUTH");
    add_srs_wkt (p, 2,
        "ORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]],");
    add_srs_wkt (p, 3,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 4,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 5,
        "2\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Lambert");
    add_srs_wkt (p, 6,
        "_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 7,
        ",26.12581974],PARAMETER[\"central_meridian\",94.375],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"standard_parallel_1\",25.375],PARAMETER[\"stand");
    add_srs_wkt (p, 9,
        "ard_parallel_2\",26.875],PARAMETER[\"false_easting\",100");
    add_srs_wkt (p, 10,
        "0000],PARAMETER[\"false_northing\",1000000],UNIT[\"metre");
    add_srs_wkt (p, 11,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 12,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7770\"]]");
    p = add_epsg_def_ex (filter, first, last, 7771, "epsg", 7771,
        "WGS 84 / India Northeast", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=23.04166666666667 +lat_2=28.20833333333");
    add_proj4text (p, 1,
        "333 +lat_0=25.63452135 +lon_0=93.5 +x_0=1000000 +y_0=100");
    add_proj4text (p, 2,
        "0000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / India Northeast\",GEOGCS[\"WGS 84\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2572235");
    add_srs_wkt (p, 2,
        "63,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"63");
    add_srs_wkt (p, 3,
        "26\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 4,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"L");
    add_srs_wkt (p, 6,
        "ambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 7,
        "igin\",25.63452135],PARAMETER[\"central_meridian\",93.5]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"standard_parallel_1\",23.0416666666667],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"standard_parallel_2\",28.2083333333333],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_easting\",1000000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 11,
        "\",1000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"7771\"]]");
    p = add_epsg_def_ex (filter, first, last, 7772, "epsg", 7772,
        "WGS 84 / Orissa", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=18.58333333333333 +lat_2=21.91666666666");
    add_proj4text (p, 1,
        "667 +lat_0=20.25305174 +lon_0=84.375 +x_0=1000000 +y_0=1");
    add_proj4text (p, 2,
        "000000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / Orissa\",GEOGCS[\"WGS 84\",DATUM[\"WGS");
    add_srs_wkt (p, 1,
        "_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUTHOR");
    add_srs_wkt (p, 2,
        "ITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]],PR");
    add_srs_wkt (p, 3,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 4,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 5,
        "]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Lambert_Co");
    add_srs_wkt (p, 6,
        "nformal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",20");
    add_srs_wkt (p, 7,
        ".25305174],PARAMETER[\"central_meridian\",84.375],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"standard_parallel_1\",18.5833333333333],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"standard_parallel_2\",21.9166666666667],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_easting\",1000000],PARAMETER[\"false_northing\",1000");
    add_srs_wkt (p, 11,
        "000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS");
    add_srs_wkt (p, 12,
        "[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 13,
        "EPSG\",\"7772\"]]");
    p = add_epsg_def_ex (filter, first, last, 7773, "epsg", 7773,
        "WGS 84 / Punjab", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=30 +lat_2=32 +lat_0=31.00178226 +lon_0=");
    add_proj4text (p, 1,
        "75.375 +x_0=1000000 +y_0=1000000 +datum=WGS84 +units=m +");
    add_proj4text (p, 2,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / Punjab\",GEOGCS[\"WGS 84\",DATUM[\"WGS");
    add_srs_wkt (p, 1,
        "_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUTHOR");
    add_srs_wkt (p, 2,
        "ITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]],PR");
    add_srs_wkt (p, 3,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 4,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 5,
        "]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Lambert_Co");
    add_srs_wkt (p, 6,
        "nformal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",31");
    add_srs_wkt (p, 7,
        ".00178226],PARAMETER[\"central_meridian\",75.375],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"standard_parallel_1\",30],PARAMETER[\"standard_par");
    add_srs_wkt (p, 9,
        "allel_2\",32],PARAMETER[\"false_easting\",1000000],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_northing\",1000000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 11,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 12,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"7773\"]]");
    p = add_epsg_def_ex (filter, first, last, 7774, "epsg", 7774,
        "WGS 84 / Rajasthan", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=24.29166666666667 +lat_2=29.45833333333");
    add_proj4text (p, 1,
        "333 +lat_0=26.88505546 +lon_0=73.875 +x_0=1000000 +y_0=1");
    add_proj4text (p, 2,
        "000000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / Rajasthan\",GEOGCS[\"WGS 84\",DATUM[\"");
    add_srs_wkt (p, 1,
        "WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUT");
    add_srs_wkt (p, 2,
        "HORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]]");
    add_srs_wkt (p, 3,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 4,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 5,
        "22\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Lamber");
    add_srs_wkt (p, 6,
        "t_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 7,
        ",26.88505546],PARAMETER[\"central_meridian\",73.875],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"standard_parallel_1\",24.2916666666667],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"standard_parallel_2\",29.4583333333333],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",1000000],PARAMETER[\"false_northing\",10");
    add_srs_wkt (p, 11,
        "00000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"7774\"]]");
    p = add_epsg_def_ex (filter, first, last, 7775, "epsg", 7775,
        "WGS 84 / Uttar Pradesh", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=24.875 +lat_2=29.375 +lat_0=27.13270823");
    add_proj4text (p, 1,
        " +lon_0=80.875 +x_0=1000000 +y_0=1000000 +datum=WGS84 +u");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / Uttar Pradesh\",GEOGCS[\"WGS 84\",DATU");
    add_srs_wkt (p, 1,
        "M[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563");
    add_srs_wkt (p, 2,
        ",AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326");
    add_srs_wkt (p, 3,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 4,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"La");
    add_srs_wkt (p, 6,
        "mbert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_ori");
    add_srs_wkt (p, 7,
        "gin\",27.13270823],PARAMETER[\"central_meridian\",80.875");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"standard_parallel_1\",24.875],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "standard_parallel_2\",29.375],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
        ",1000000],PARAMETER[\"false_northing\",1000000],UNIT[\"m");
    add_srs_wkt (p, 11,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",");
    add_srs_wkt (p, 12,
        "EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7775");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 7776, "epsg", 7776,
        "WGS 84 / Uttaranchal", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=29 +lat_2=31 +lat_0=30.0017132 +lon_0=7");
    add_proj4text (p, 1,
        "9.375 +x_0=1000000 +y_0=1000000 +datum=WGS84 +units=m +n");
    add_proj4text (p, 2,
        "o_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / Uttaranchal\",GEOGCS[\"WGS 84\",DATUM[");
    add_srs_wkt (p, 1,
        "\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,A");
    add_srs_wkt (p, 2,
        "UTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"");
    add_srs_wkt (p, 3,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 4,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Lamb");
    add_srs_wkt (p, 6,
        "ert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 7,
        "n\",30.0017132],PARAMETER[\"central_meridian\",79.375],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"standard_parallel_1\",29],PARAMETER[\"standar");
    add_srs_wkt (p, 9,
        "d_parallel_2\",31],PARAMETER[\"false_easting\",1000000],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_northing\",1000000],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 12,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7776\"]]");
    p = add_epsg_def_ex (filter, first, last, 7777, "epsg", 7777,
        "WGS 84 / Andaman and Nicobar", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=10.25 +lon_0=93.25 +k=0.9999428 +x_0=");
    add_proj4text (p, 1,
        "1000000 +y_0=1000000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / Andaman and Nicobar\",GEOGCS[\"WGS 84\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2572");
    add_srs_wkt (p, 2,
        "23563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 4,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[");
    add_srs_wkt (p, 6,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 7,
        ",10.25],PARAMETER[\"central_meridian\",93.25],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"scale_factor\",0.9999428],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 9,
        "1000000],PARAMETER[\"false_northing\",1000000],UNIT[\"me");
    add_srs_wkt (p, 10,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",E");
    add_srs_wkt (p, 11,
        "AST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7777\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 7778, "epsg", 7778,
        "WGS 84 / Chhattisgarh", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=21 +lon_0=82.25 +k=0.9998332 +x_0=100");
    add_proj4text (p, 1,
        "0000 +y_0=1000000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / Chhattisgarh\",GEOGCS[\"WGS 84\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,");
    add_srs_wkt (p, 2,
        "AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"");
    add_srs_wkt (p, 3,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 4,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 6,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",21],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"central_meridian\",82.25],PARAMETER[\"scale_");
    add_srs_wkt (p, 8,
        "factor\",0.9998332],PARAMETER[\"false_easting\",1000000]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"false_northing\",1000000],UNIT[\"metre\",1,");
    add_srs_wkt (p, 10,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXI");
    add_srs_wkt (p, 11,
        "S[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7778\"]]");
    p = add_epsg_def_ex (filter, first, last, 7779, "epsg", 7779,
        "WGS 84 / Goa", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=15.375 +lon_0=74 +k=0.9999913 +x_0=10");
    add_proj4text (p, 1,
        "00000 +y_0=1000000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / Goa\",GEOGCS[\"WGS 84\",DATUM[\"WGS_19");
    add_srs_wkt (p, 1,
        "84\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUTHORITY");
    add_srs_wkt (p, 2,
        "[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]],PRIME");
    add_srs_wkt (p, 3,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 4,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 6,
        "ercator\"],PARAMETER[\"latitude_of_origin\",15.375],PARA");
    add_srs_wkt (p, 7,
        "METER[\"central_meridian\",74],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 8,
        ",0.9999913],PARAMETER[\"false_easting\",1000000],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"false_northing\",1000000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 10,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 11,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"7779\"]]");
    p = add_epsg_def_ex (filter, first, last, 7780, "epsg", 7780,
        "WGS 84 / Karnataka", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=15.125 +lon_0=76.375 +k=0.99980119999");
    add_proj4text (p, 1,
        "99999 +x_0=1000000 +y_0=1000000 +datum=WGS84 +units=m +n");
    add_proj4text (p, 2,
        "o_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / Karnataka\",GEOGCS[\"WGS 84\",DATUM[\"");
    add_srs_wkt (p, 1,
        "WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUT");
    add_srs_wkt (p, 2,
        "HORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]]");
    add_srs_wkt (p, 3,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 4,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 5,
        "22\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 6,
        "erse_Mercator\"],PARAMETER[\"latitude_of_origin\",15.125");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"central_meridian\",76.375],PARAMETER[\"sca");
    add_srs_wkt (p, 8,
        "le_factor\",0.9998012],PARAMETER[\"false_easting\",10000");
    add_srs_wkt (p, 9,
        "00],PARAMETER[\"false_northing\",1000000],UNIT[\"metre\"");
    add_srs_wkt (p, 10,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7780\"]]");
    p = add_epsg_def_ex (filter, first, last, 7781, "epsg", 7781,
        "WGS 84 / Kerala", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=10.5 +lon_0=76 +k=0.9999177 +x_0=1000");
    add_proj4text (p, 1,
        "000 +y_0=1000000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / Kerala\",GEOGCS[\"WGS 84\",DATUM[\"WGS");
    add_srs_wkt (p, 1,
        "_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUTHOR");
    add_srs_wkt (p, 2,
        "ITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]],PR");
    add_srs_wkt (p, 3,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 4,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 5,
        "]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 6,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",10.5],PARA");
    add_srs_wkt (p, 7,
        "METER[\"central_meridian\",76],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 8,
        ",0.9999177],PARAMETER[\"false_easting\",1000000],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"false_northing\",1000000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 10,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 11,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"7781\"]]");
    p = add_epsg_def_ex (filter, first, last, 7782, "epsg", 7782,
        "WGS 84 / Lakshadweep", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=10 +lon_0=73.125 +k=0.9999536 +x_0=10");
    add_proj4text (p, 1,
        "00000 +y_0=1000000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / Lakshadweep\",GEOGCS[\"WGS 84\",DATUM[");
    add_srs_wkt (p, 1,
        "\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,A");
    add_srs_wkt (p, 2,
        "UTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"");
    add_srs_wkt (p, 3,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 4,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 6,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",10],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"central_meridian\",73.125],PARAMETER[\"scale");
    add_srs_wkt (p, 8,
        "_factor\",0.9999536],PARAMETER[\"false_easting\",1000000");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_northing\",1000000],UNIT[\"metre\",1");
    add_srs_wkt (p, 10,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AX");
    add_srs_wkt (p, 11,
        "IS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7782\"]]");
    p = add_epsg_def_ex (filter, first, last, 7783, "epsg", 7783,
        "WGS 84 / Mizoram", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=23.125 +lon_0=92.75 +k=0.9999821 +x_0");
    add_proj4text (p, 1,
        "=1000000 +y_0=1000000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / Mizoram\",GEOGCS[\"WGS 84\",DATUM[\"WG");
    add_srs_wkt (p, 1,
        "S_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUTHO");
    add_srs_wkt (p, 2,
        "RITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]],P");
    add_srs_wkt (p, 3,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 4,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 5,
        "\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 6,
        "se_Mercator\"],PARAMETER[\"latitude_of_origin\",23.125],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"central_meridian\",92.75],PARAMETER[\"scale_");
    add_srs_wkt (p, 8,
        "factor\",0.9999821],PARAMETER[\"false_easting\",1000000]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"false_northing\",1000000],UNIT[\"metre\",1,");
    add_srs_wkt (p, 10,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXI");
    add_srs_wkt (p, 11,
        "S[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7783\"]]");
    p = add_epsg_def_ex (filter, first, last, 7784, "epsg", 7784,
        "WGS 84 / Sikkim", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=27.625 +lon_0=88.5 +k=0.9999926 +x_0=");
    add_proj4text (p, 1,
        "1000000 +y_0=1000000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / Sikkim\",GEOGCS[\"WGS 84\",DATUM[\"WGS");
    add_srs_wkt (p, 1,
        "_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUTHOR");
    add_srs_wkt (p, 2,
        "ITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]],PR");
    add_srs_wkt (p, 3,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 4,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 5,
        "]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 6,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",27.625],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"central_meridian\",88.5],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 8,
        "tor\",0.9999926],PARAMETER[\"false_easting\",1000000],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"false_northing\",1000000],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 10,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"7784\"]]");
    p = add_epsg_def_ex (filter, first, last, 7785, "epsg", 7785,
        "WGS 84 / Tamil Nadu", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=10.875 +lon_0=78.375 +k=0.9997942 +x_");
    add_proj4text (p, 1,
        "0=1000000 +y_0=1000000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / Tamil Nadu\",GEOGCS[\"WGS 84\",DATUM[\"");
    add_srs_wkt (p, 1,
        "WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUT");
    add_srs_wkt (p, 2,
        "HORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]]");
    add_srs_wkt (p, 3,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 4,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 5,
        "22\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 6,
        "erse_Mercator\"],PARAMETER[\"latitude_of_origin\",10.875");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"central_meridian\",78.375],PARAMETER[\"sca");
    add_srs_wkt (p, 8,
        "le_factor\",0.9997942],PARAMETER[\"false_easting\",10000");
    add_srs_wkt (p, 9,
        "00],PARAMETER[\"false_northing\",1000000],UNIT[\"metre\"");
    add_srs_wkt (p, 10,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7785\"]]");
    p = add_epsg_def_ex (filter, first, last, 7786, "epsg", 7786,
        "WGS 84 / Tripura", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=23.75 +lon_0=91.75 +k=0.9999822 +x_0=");
    add_proj4text (p, 1,
        "1000000 +y_0=1000000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / Tripura\",GEOGCS[\"WGS 84\",DATUM[\"WG");
    add_srs_wkt (p, 1,
        "S_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUTHO");
    add_srs_wkt (p, 2,
        "RITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]],P");
    add_srs_wkt (p, 3,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 4,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 5,
        "\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 6,
        "se_Mercator\"],PARAMETER[\"latitude_of_origin\",23.75],P");
    add_srs_wkt (p, 7,
        "ARAMETER[\"central_meridian\",91.75],PARAMETER[\"scale_f");
    add_srs_wkt (p, 8,
        "actor\",0.9999822],PARAMETER[\"false_easting\",1000000],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"false_northing\",1000000],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 10,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 11,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7786\"]]");
    p = add_epsg_def_ex (filter, first, last, 7787, "epsg", 7787,
        "WGS 84 / West Bengal", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=24.375 +lon_0=87.875 +k=0.9998584 +x_");
    add_proj4text (p, 1,
        "0=1000000 +y_0=1000000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / West Bengal\",GEOGCS[\"WGS 84\",DATUM[");
    add_srs_wkt (p, 1,
        "\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,A");
    add_srs_wkt (p, 2,
        "UTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"");
    add_srs_wkt (p, 3,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 4,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 6,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",24.3");
    add_srs_wkt (p, 7,
        "75],PARAMETER[\"central_meridian\",87.875],PARAMETER[\"s");
    add_srs_wkt (p, 8,
        "cale_factor\",0.9998584],PARAMETER[\"false_easting\",100");
    add_srs_wkt (p, 9,
        "0000],PARAMETER[\"false_northing\",1000000],UNIT[\"metre");
    add_srs_wkt (p, 10,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 11,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7787\"]]");
    p = add_epsg_def_ex (filter, first, last, 7791, "epsg", 7791,
        "RDN2008 / UTM zone 32N", 0, 0,
        "GRS 1980", "Greenwich",
        "Rete_Dinamica_Nazionale_2008", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=32 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RDN2008 / UTM zone 32N\",GEOGCS[\"RDN2008\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Rete_Dinamica_Nazionale_2008\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"1132\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"67");
    add_srs_wkt (p, 6,
        "06\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",9]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_ea");
    add_srs_wkt (p, 9,
        "sting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 10,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",");
    add_srs_wkt (p, 11,
        "EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7791");
    add_srs_wkt (p, 12,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 7792, "epsg", 7792,
        "RDN2008 / UTM zone 33N", 0, 0,
        "GRS 1980", "Greenwich",
        "Rete_Dinamica_Nazionale_2008", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=33 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RDN2008 / UTM zone 33N\",GEOGCS[\"RDN2008\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Rete_Dinamica_Nazionale_2008\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"1132\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"67");
    add_srs_wkt (p, 6,
        "06\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",15");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_e");
    add_srs_wkt (p, 9,
        "asting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"779");
    add_srs_wkt (p, 12,
        "2\"]]");
    p = add_epsg_def_ex (filter, first, last, 7793, "epsg", 7793,
        "RDN2008 / UTM zone 34N", 0, 0,
        "GRS 1980", "Greenwich",
        "Rete_Dinamica_Nazionale_2008", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=34 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RDN2008 / UTM zone 34N\",GEOGCS[\"RDN2008\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Rete_Dinamica_Nazionale_2008\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"1132\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"67");
    add_srs_wkt (p, 6,
        "06\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",21");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_e");
    add_srs_wkt (p, 9,
        "asting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"779");
    add_srs_wkt (p, 12,
        "3\"]]");
    p = add_epsg_def_ex (filter, first, last, 7794, "epsg", 7794,
        "RDN2008 / Italy zone (E-N)", 0, 0,
        "GRS 1980", "Greenwich",
        "Rete_Dinamica_Nazionale_2008", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=12 +k=0.9985000000000001 +x_");
    add_proj4text (p, 1,
        "0=7000000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +un");
    add_proj4text (p, 2,
        "its=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RDN2008 / Italy zone (E-N)\",GEOGCS[\"RDN2008\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Rete_Dinamica_Nazionale_2008\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 2,
        "980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"1132\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"6706\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",12],PARAMETER[\"scale_factor\",0.9985],PARAMETER[\"fa");
    add_srs_wkt (p, 9,
        "lse_easting\",7000000],PARAMETER[\"false_northing\",0],U");
    add_srs_wkt (p, 10,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eas");
    add_srs_wkt (p, 11,
        "ting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"7794\"]]");
    p = add_epsg_def_ex (filter, first, last, 7795, "epsg", 7795,
        "RDN2008 / Zone 12 (E-N)", 0, 0,
        "GRS 1980", "Greenwich",
        "Rete_Dinamica_Nazionale_2008", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=12 +k=1 +x_0=3000000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RDN2008 / Zone 12 (E-N)\",GEOGCS[\"RDN2008\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"Rete_Dinamica_Nazionale_2008\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"1132\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "6706\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "2],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",3000000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 11,
        "ST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7795\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 7797, "epsg", 7797,
        "BGS2005", 1, 1,
        "GRS 1980", "Greenwich",
        "Bulgaria_Geodetic_System_2005", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"BGS2005\",DATUM[\"Bulgaria Geodetic System 200");
    add_srs_wkt (p, 1,
        "5\",ELLIPSOID[\"GRS 1980\",6378137,298.257222101,LENGTHU");
    add_srs_wkt (p, 2,
        "NIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"de");
    add_srs_wkt (p, 3,
        "gree\",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"geo");
    add_srs_wkt (p, 4,
        "detic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433]],AXIS[\"geodetic longitude (Lon)\"");
    add_srs_wkt (p, 6,
        ",east,ORDER[2],ANGLEUNIT[\"degree\",0.0174532925199433]]");
    add_srs_wkt (p, 7,
        ",AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHUNIT[");
    add_srs_wkt (p, 8,
        "\"metre\",1]],USAGE[SCOPE[\"unknown\"],AREA[\"Bulgaria\"");
    add_srs_wkt (p, 9,
        "],BBOX[41.24,22.36,44.23,31.35]],ID[\"EPSG\",7797]]");
    p = add_epsg_def_ex (filter, first, last, 7798, "epsg", 7798,
        "BGS2005", 1, 1,
        "GRS 1980", "Greenwich",
        "Bulgaria_Geodetic_System_2005", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"BGS2005\",DATUM[\"Bulgaria_Geodetic_System_2005");
    add_srs_wkt (p, 1,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 2,
        "[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1167\"]],PRIME");
    add_srs_wkt (p, 3,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 4,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 5,
        ",AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHO");
    add_srs_wkt (p, 6,
        "RITY[\"EPSG\",\"7798\"]]");
    p = add_epsg_def_ex (filter, first, last, 7799, "epsg", 7799,
        "BGS2005 / UTM zone 34N (N-E)", 0, 1,
        "GRS 1980", "Greenwich",
        "Bulgaria_Geodetic_System_2005", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=utm +zone=34 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"BGS2005 / UTM zone 34N (N-E)\",GEOGCS[\"BGS2005");
    add_srs_wkt (p, 1,
        "\",DATUM[\"Bulgaria_Geodetic_System_2005\",SPHEROID[\"GR");
    add_srs_wkt (p, 2,
        "S 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"1167\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"7798\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",21],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"No");
    add_srs_wkt (p, 11,
        "rthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"7799\"]]");
    p = add_epsg_def_ex (filter, first, last, 7800, "epsg", 7800,
        "BGS2005 / UTM zone 35N (N-E)", 0, 1,
        "GRS 1980", "Greenwich",
        "Bulgaria_Geodetic_System_2005", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=utm +zone=35 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"BGS2005 / UTM zone 35N (N-E)\",GEOGCS[\"BGS2005");
    add_srs_wkt (p, 1,
        "\",DATUM[\"Bulgaria_Geodetic_System_2005\",SPHEROID[\"GR");
    add_srs_wkt (p, 2,
        "S 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"1167\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"7798\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",27],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"No");
    add_srs_wkt (p, 11,
        "rthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"7800\"]]");
    p = add_epsg_def_ex (filter, first, last, 7801, "epsg", 7801,
        "BGS2005 / CCS2005", 0, 1,
        "GRS 1980", "Greenwich",
        "Bulgaria_Geodetic_System_2005", "Lambert_Conformal_Conic_2SP", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=42 +lat_2=43.33333333333334 +lat_0=42.6");
    add_proj4text (p, 1,
        "6787568333333 +lon_0=25.5 +x_0=500000 +y_0=4725824.3591 ");
    add_proj4text (p, 2,
        "+ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"BGS2005 / CCS2005\",GEOGCS[\"BGS2005\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Bulgaria_Geodetic_System_2005\",SPHEROID[\"GRS 1980\",63");
    add_srs_wkt (p, 2,
        "78137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"1167\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"7798\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",42.6678756833333],PARAMETER[\"ce");
    add_srs_wkt (p, 8,
        "ntral_meridian\",25.5],PARAMETER[\"standard_parallel_1\"");
    add_srs_wkt (p, 9,
        ",42],PARAMETER[\"standard_parallel_2\",43.3333333333333]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",4725824.3591],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\"");
    add_srs_wkt (p, 13,
        ",EAST],AUTHORITY[\"EPSG\",\"7801\"]]");
    p = add_epsg_def_ex (filter, first, last, 7803, "epsg", 7803,
        "BGS2005 / UTM zone 34N", 0, 0,
        "GRS 1980", "Greenwich",
        "Bulgaria_Geodetic_System_2005", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=34 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"BGS2005 / UTM zone 34N\",GEOGCS[\"BGS2005\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Bulgaria_Geodetic_System_2005\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"1167\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "7798\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",2");
    add_srs_wkt (p, 8,
        "1],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"780");
    add_srs_wkt (p, 12,
        "3\"]]");
    p = add_epsg_def_ex (filter, first, last, 7804, "epsg", 7804,
        "BGS2005 / UTM zone 35N", 0, 0,
        "GRS 1980", "Greenwich",
        "Bulgaria_Geodetic_System_2005", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=34 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"BGS2005 / UTM zone 35N\",GEOGCS[\"BGS2005\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Bulgaria_Geodetic_System_2005\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"1167\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "7798\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",2");
    add_srs_wkt (p, 8,
        "1],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"780");
    add_srs_wkt (p, 12,
        "4\"]]");
    p = add_epsg_def_ex (filter, first, last, 7805, "epsg", 7805,
        "BGS2005 / UTM zone 36N", 0, 0,
        "GRS 1980", "Greenwich",
        "Bulgaria_Geodetic_System_2005", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=36 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"BGS2005 / UTM zone 36N\",GEOGCS[\"BGS2005\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Bulgaria_Geodetic_System_2005\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"1167\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "7798\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",3");
    add_srs_wkt (p, 8,
        "3],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"780");
    add_srs_wkt (p, 12,
        "5\"]]");
    p = add_epsg_def_ex (filter, first, last, 7816, "epsg", 7816,
        "WGS 84 (Transit)", 1, 1,
        "WGS 84", "Greenwich",
        "World_Geodetic_System_1984_Transit", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"WGS 84 (Transit)\",DATUM[\"World Geodetic Syst");
    add_srs_wkt (p, 1,
        "em 1984 (Transit)\",ELLIPSOID[\"WGS 84\",6378137,298.257");
    add_srs_wkt (p, 2,
        "223563,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 3,
        "ANGLEUNIT[\"degree\",0.0174532925199433]],CS[ellipsoidal");
    add_srs_wkt (p, 4,
        ",3],AXIS[\"geodetic latitude (Lat)\",north,ORDER[1],ANGL");
    add_srs_wkt (p, 5,
        "EUNIT[\"degree\",0.0174532925199433]],AXIS[\"geodetic lo");
    add_srs_wkt (p, 6,
        "ngitude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.017");
    add_srs_wkt (p, 7,
        "4532925199433]],AXIS[\"ellipsoidal height (h)\",up,ORDER");
    add_srs_wkt (p, 8,
        "[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"unknown\"],AR");
    add_srs_wkt (p, 9,
        "EA[\"World\"],BBOX[-90,-180,90,180]],ID[\"EPSG\",7816]]");
    p = add_epsg_def_ex (filter, first, last, 7825, "epsg", 7825,
        "Pulkovo 1942 / CS63 zone X1", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0.08333333333333333 +lon_0=23.5 +k=1 ");
    add_proj4text (p, 1,
        "+x_0=1300000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,");
    add_proj4text (p, 2,
        "-80.9,0,0.35,0.82,-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / CS63 zone X1\",GEOGCS[\"Pulkovo ");
    add_srs_wkt (p, 1,
        "1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassowsky 1940");
    add_srs_wkt (p, 2,
        "\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]]");
    add_srs_wkt (p, 6,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 7,
        "e_of_origin\",0.0833333333333333],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",23.5],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",1300000],PARAMETER[\"false_northing\",0]");
    add_srs_wkt (p, 10,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"N");
    add_srs_wkt (p, 11,
        "orthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"7825\"]]");
    p = add_epsg_def_ex (filter, first, last, 7826, "epsg", 7826,
        "Pulkovo 1942 / CS63 zone X2", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0.08333333333333333 +lon_0=26.5 +k=1 ");
    add_proj4text (p, 1,
        "+x_0=2300000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,");
    add_proj4text (p, 2,
        "-80.9,0,0.35,0.82,-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / CS63 zone X2\",GEOGCS[\"Pulkovo ");
    add_srs_wkt (p, 1,
        "1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassowsky 1940");
    add_srs_wkt (p, 2,
        "\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]]");
    add_srs_wkt (p, 6,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 7,
        "e_of_origin\",0.0833333333333333],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",26.5],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",2300000],PARAMETER[\"false_northing\",0]");
    add_srs_wkt (p, 10,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"N");
    add_srs_wkt (p, 11,
        "orthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"7826\"]]");
    p = add_epsg_def_ex (filter, first, last, 7827, "epsg", 7827,
        "Pulkovo 1942 / CS63 zone X3", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0.08333333333333333 +lon_0=29.5 +k=1 ");
    add_proj4text (p, 1,
        "+x_0=3300000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,");
    add_proj4text (p, 2,
        "-80.9,0,0.35,0.82,-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / CS63 zone X3\",GEOGCS[\"Pulkovo ");
    add_srs_wkt (p, 1,
        "1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassowsky 1940");
    add_srs_wkt (p, 2,
        "\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]]");
    add_srs_wkt (p, 6,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 7,
        "e_of_origin\",0.0833333333333333],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",29.5],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",3300000],PARAMETER[\"false_northing\",0]");
    add_srs_wkt (p, 10,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"N");
    add_srs_wkt (p, 11,
        "orthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"7827\"]]");
    p = add_epsg_def_ex (filter, first, last, 7828, "epsg", 7828,
        "Pulkovo 1942 / CS63 zone X4", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0.08333333333333333 +lon_0=32.5 +k=1 ");
    add_proj4text (p, 1,
        "+x_0=4300000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,");
    add_proj4text (p, 2,
        "-80.9,0,0.35,0.82,-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / CS63 zone X4\",GEOGCS[\"Pulkovo ");
    add_srs_wkt (p, 1,
        "1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassowsky 1940");
    add_srs_wkt (p, 2,
        "\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]]");
    add_srs_wkt (p, 6,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 7,
        "e_of_origin\",0.0833333333333333],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",32.5],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",4300000],PARAMETER[\"false_northing\",0]");
    add_srs_wkt (p, 10,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"N");
    add_srs_wkt (p, 11,
        "orthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"7828\"]]");
    p = add_epsg_def_ex (filter, first, last, 7829, "epsg", 7829,
        "Pulkovo 1942 / CS63 zone X5", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0.08333333333333333 +lon_0=35.5 +k=1 ");
    add_proj4text (p, 1,
        "+x_0=5300000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,");
    add_proj4text (p, 2,
        "-80.9,0,0.35,0.82,-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / CS63 zone X5\",GEOGCS[\"Pulkovo ");
    add_srs_wkt (p, 1,
        "1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassowsky 1940");
    add_srs_wkt (p, 2,
        "\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]]");
    add_srs_wkt (p, 6,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 7,
        "e_of_origin\",0.0833333333333333],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",35.5],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",5300000],PARAMETER[\"false_northing\",0]");
    add_srs_wkt (p, 10,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"N");
    add_srs_wkt (p, 11,
        "orthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"7829\"]]");
    p = add_epsg_def_ex (filter, first, last, 7830, "epsg", 7830,
        "Pulkovo 1942 / CS63 zone X6", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0.08333333333333333 +lon_0=38.5 +k=1 ");
    add_proj4text (p, 1,
        "+x_0=6300000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,");
    add_proj4text (p, 2,
        "-80.9,0,0.35,0.82,-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / CS63 zone X6\",GEOGCS[\"Pulkovo ");
    add_srs_wkt (p, 1,
        "1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassowsky 1940");
    add_srs_wkt (p, 2,
        "\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]]");
    add_srs_wkt (p, 6,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 7,
        "e_of_origin\",0.0833333333333333],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",38.5],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",6300000],PARAMETER[\"false_northing\",0]");
    add_srs_wkt (p, 10,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"N");
    add_srs_wkt (p, 11,
        "orthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"7830\"]]");
    p = add_epsg_def_ex (filter, first, last, 7831, "epsg", 7831,
        "Pulkovo 1942 / CS63 zone X7", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0.08333333333333333 +lon_0=41.5 +k=1 ");
    add_proj4text (p, 1,
        "+x_0=7300000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,");
    add_proj4text (p, 2,
        "-80.9,0,0.35,0.82,-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / CS63 zone X7\",GEOGCS[\"Pulkovo ");
    add_srs_wkt (p, 1,
        "1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassowsky 1940");
    add_srs_wkt (p, 2,
        "\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]]");
    add_srs_wkt (p, 6,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 7,
        "e_of_origin\",0.0833333333333333],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",41.5],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",7300000],PARAMETER[\"false_northing\",0]");
    add_srs_wkt (p, 10,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"N");
    add_srs_wkt (p, 11,
        "orthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"7831\"]]");
    p = add_epsg_def_ex (filter, first, last, 7843, "epsg", 7843,
        "GDA2020", 1, 1,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_2020", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"GDA2020\",DATUM[\"Geocentric Datum of Australi");
    add_srs_wkt (p, 1,
        "a 2020\",ELLIPSOID[\"GRS 1980\",6378137,298.257222101,LE");
    add_srs_wkt (p, 2,
        "NGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT");
    add_srs_wkt (p, 3,
        "[\"degree\",0.0174532925199433]],CS[ellipsoidal,3],AXIS[");
    add_srs_wkt (p, 4,
        "\"geodetic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433]],AXIS[\"geodetic longitude (");
    add_srs_wkt (p, 6,
        "Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 7,
        "9433]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LENGT");
    add_srs_wkt (p, 8,
        "HUNIT[\"metre\",1]],USAGE[SCOPE[\"unknown\"],AREA[\"Aust");
    add_srs_wkt (p, 9,
        "ralia - GDA\"],BBOX[-60.56,93.41,-8.47,173.35]],ID[\"EPS");
    add_srs_wkt (p, 10,
        "G\",7843]]");
    p = add_epsg_def_ex (filter, first, last, 7844, "epsg", 7844,
        "GDA2020", 1, 1,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_2020", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"GDA2020\",DATUM[\"Geocentric_Datum_of_Australia");
    add_srs_wkt (p, 1,
        "_2020\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 2,
        "ORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1168\"]],");
    add_srs_wkt (p, 3,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 4,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 5,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"7844\"]]");
    p = add_epsg_def_ex (filter, first, last, 7845, "epsg", 7845,
        "GDA2020 / GA LCC", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_2020", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-18 +lat_2=-36 +lat_0=0 +lon_0=134 +x_0");
    add_proj4text (p, 1,
        "=0 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA2020 / GA LCC\",GEOGCS[\"GDA2020\",DATUM[\"G");
    add_srs_wkt (p, 1,
        "eocentric_Datum_of_Australia_2020\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"1168\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"78");
    add_srs_wkt (p, 6,
        "44\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",134],PARAMETER[\"standard_parallel_1\",-18],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"standard_parallel_2\",-36],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
        "ng\",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1");
    add_srs_wkt (p, 11,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AX");
    add_srs_wkt (p, 12,
        "IS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7845\"]]");
    p = add_epsg_def_ex (filter, first, last, 7846, "epsg", 7846,
        "GDA2020 / MGA zone 46", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_2020", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=46 +south +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA2020 / MGA zone 46\",GEOGCS[\"GDA2020\",DATU");
    add_srs_wkt (p, 1,
        "M[\"Geocentric_Datum_of_Australia_2020\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 2,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"1168\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"7844\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",93],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fa");
    add_srs_wkt (p, 9,
        "lse_easting\",500000],PARAMETER[\"false_northing\",10000");
    add_srs_wkt (p, 10,
        "000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS");
    add_srs_wkt (p, 11,
        "[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"7846\"]]");
    p = add_epsg_def_ex (filter, first, last, 7847, "epsg", 7847,
        "GDA2020 / MGA zone 47", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_2020", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=47 +south +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA2020 / MGA zone 47\",GEOGCS[\"GDA2020\",DATU");
    add_srs_wkt (p, 1,
        "M[\"Geocentric_Datum_of_Australia_2020\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 2,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"1168\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"7844\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",99],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fa");
    add_srs_wkt (p, 9,
        "lse_easting\",500000],PARAMETER[\"false_northing\",10000");
    add_srs_wkt (p, 10,
        "000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS");
    add_srs_wkt (p, 11,
        "[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"7847\"]]");
    p = add_epsg_def_ex (filter, first, last, 7848, "epsg", 7848,
        "GDA2020 / MGA zone 48", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_2020", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=48 +south +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA2020 / MGA zone 48\",GEOGCS[\"GDA2020\",DATU");
    add_srs_wkt (p, 1,
        "M[\"Geocentric_Datum_of_Australia_2020\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 2,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"1168\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"7844\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",105],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"f");
    add_srs_wkt (p, 9,
        "alse_easting\",500000],PARAMETER[\"false_northing\",1000");
    add_srs_wkt (p, 10,
        "0000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 11,
        "S[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"7848\"]]");
    p = add_epsg_def_ex (filter, first, last, 7849, "epsg", 7849,
        "GDA2020 / MGA zone 49", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_2020", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=49 +south +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA2020 / MGA zone 49\",GEOGCS[\"GDA2020\",DATU");
    add_srs_wkt (p, 1,
        "M[\"Geocentric_Datum_of_Australia_2020\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 2,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"1168\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"7844\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",111],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"f");
    add_srs_wkt (p, 9,
        "alse_easting\",500000],PARAMETER[\"false_northing\",1000");
    add_srs_wkt (p, 10,
        "0000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 11,
        "S[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"7849\"]]");
    p = add_epsg_def_ex (filter, first, last, 7850, "epsg", 7850,
        "GDA2020 / MGA zone 50", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_2020", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=50 +south +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA2020 / MGA zone 50\",GEOGCS[\"GDA2020\",DATU");
    add_srs_wkt (p, 1,
        "M[\"Geocentric_Datum_of_Australia_2020\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 2,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"1168\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"7844\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",117],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"f");
    add_srs_wkt (p, 9,
        "alse_easting\",500000],PARAMETER[\"false_northing\",1000");
    add_srs_wkt (p, 10,
        "0000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 11,
        "S[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"7850\"]]");
    p = add_epsg_def_ex (filter, first, last, 7851, "epsg", 7851,
        "GDA2020 / MGA zone 51", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_2020", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=51 +south +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA2020 / MGA zone 51\",GEOGCS[\"GDA2020\",DATU");
    add_srs_wkt (p, 1,
        "M[\"Geocentric_Datum_of_Australia_2020\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 2,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"1168\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"7844\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",123],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"f");
    add_srs_wkt (p, 9,
        "alse_easting\",500000],PARAMETER[\"false_northing\",1000");
    add_srs_wkt (p, 10,
        "0000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 11,
        "S[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"7851\"]]");
    p = add_epsg_def_ex (filter, first, last, 7852, "epsg", 7852,
        "GDA2020 / MGA zone 52", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_2020", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=52 +south +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA2020 / MGA zone 52\",GEOGCS[\"GDA2020\",DATU");
    add_srs_wkt (p, 1,
        "M[\"Geocentric_Datum_of_Australia_2020\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 2,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"1168\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"7844\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",129],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"f");
    add_srs_wkt (p, 9,
        "alse_easting\",500000],PARAMETER[\"false_northing\",1000");
    add_srs_wkt (p, 10,
        "0000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 11,
        "S[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"7852\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

