#ifndef OMIT_EPSG		/* full EPSG initialization enabled */

static void
initialize_epsg_00 (int filter, struct epsg_defs **first,
		    struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def (filter, first, last, 2000, "epsg", 2000,
		      "Anguilla 1957 / British West Indies Grid");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=-62 +k=0.9995000000000001 +x");
    add_proj4text (p, 1, "_0=400000 +y_0=0 +ellps=clrk80 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Anguilla 1957 / British West Indies Grid\",GEOG");
    add_srs_wkt (p, 1,
		 "CS[\"Anguilla 1957\",DATUM[\"Anguilla_1957\",SPHEROID[\"");
    add_srs_wkt (p, 2,
		 "Clarke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
		 "\",\"7012\"]],AUTHORITY[\"EPSG\",\"6600\"]],PRIMEM[\"Gre");
    add_srs_wkt (p, 4,
		 "enwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
		 ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
		 "ITY[\"EPSG\",\"4600\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
		 "\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cent");
    add_srs_wkt (p, 8,
		 "ral_meridian\",-62],PARAMETER[\"scale_factor\",0.9995],P");
    add_srs_wkt (p, 9,
		 "ARAMETER[\"false_easting\",400000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 10,
		 "thing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 11,
		 "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 12, "ITY[\"EPSG\",\"2000\"]]");
    p = add_epsg_def (filter, first, last, 2001, "epsg", 2001,
		      "Antigua 1943 / British West Indies Grid");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=-62 +k=0.9995000000000001 +x");
    add_proj4text (p, 1,
		   "_0=400000 +y_0=0 +ellps=clrk80 +towgs84=-255,-15,71,0,0,");
    add_proj4text (p, 2, "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Antigua 1943 / British West Indies Grid\",GEOGC");
    add_srs_wkt (p, 1,
		 "S[\"Antigua 1943\",DATUM[\"Antigua_1943\",SPHEROID[\"Cla");
    add_srs_wkt (p, 2,
		 "rke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
		 "\"7012\"]],TOWGS84[-255,-15,71,0,0,0,0],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
		 "\",\"6601\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
		 "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 6,
		 "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4601\"]],PROJEC");
    add_srs_wkt (p, 7,
		 "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 8,
		 "igin\",0],PARAMETER[\"central_meridian\",-62],PARAMETER[");
    add_srs_wkt (p, 9,
		 "\"scale_factor\",0.9995],PARAMETER[\"false_easting\",400");
    add_srs_wkt (p, 10,
		 "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
		 "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 12, "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2001\"]]");
    p = add_epsg_def (filter, first, last, 2002, "epsg", 2002,
		      "Dominica 1945 / British West Indies Grid");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=-62 +k=0.9995000000000001 +x");
    add_proj4text (p, 1,
		   "_0=400000 +y_0=0 +ellps=clrk80 +towgs84=725,685,536,0,0,");
    add_proj4text (p, 2, "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Dominica 1945 / British West Indies Grid\",GEOG");
    add_srs_wkt (p, 1,
		 "CS[\"Dominica 1945\",DATUM[\"Dominica_1945\",SPHEROID[\"");
    add_srs_wkt (p, 2,
		 "Clarke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
		 "\",\"7012\"]],TOWGS84[725,685,536,0,0,0,0],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
		 "PSG\",\"6602\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
		 "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
		 "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4602\"]],PRO");
    add_srs_wkt (p, 7,
		 "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
		 "_origin\",0],PARAMETER[\"central_meridian\",-62],PARAMET");
    add_srs_wkt (p, 9,
		 "ER[\"scale_factor\",0.9995],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 10,
		 "400000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1");
    add_srs_wkt (p, 11,
		 ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AX");
    add_srs_wkt (p, 12, "IS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2002\"]]");
    p = add_epsg_def (filter, first, last, 2003, "epsg", 2003,
		      "Grenada 1953 / British West Indies Grid");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=-62 +k=0.9995000000000001 +x");
    add_proj4text (p, 1,
		   "_0=400000 +y_0=0 +ellps=clrk80 +towgs84=72,213.7,93,0,0,");
    add_proj4text (p, 2, "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Grenada 1953 / British West Indies Grid\",GEOGC");
    add_srs_wkt (p, 1,
		 "S[\"Grenada 1953\",DATUM[\"Grenada_1953\",SPHEROID[\"Cla");
    add_srs_wkt (p, 2,
		 "rke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
		 "\"7012\"]],TOWGS84[72,213.7,93,0,0,0,0],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
		 "\",\"6603\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
		 "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 6,
		 "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4603\"]],PROJEC");
    add_srs_wkt (p, 7,
		 "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 8,
		 "igin\",0],PARAMETER[\"central_meridian\",-62],PARAMETER[");
    add_srs_wkt (p, 9,
		 "\"scale_factor\",0.9995],PARAMETER[\"false_easting\",400");
    add_srs_wkt (p, 10,
		 "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
		 "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 12, "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2003\"]]");
    p = add_epsg_def (filter, first, last, 2004, "epsg", 2004,
		      "Montserrat 1958 / British West Indies Grid");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=-62 +k=0.9995000000000001 +x");
    add_proj4text (p, 1,
		   "_0=400000 +y_0=0 +ellps=clrk80 +towgs84=174,359,365,0,0,");
    add_proj4text (p, 2, "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Montserrat 1958 / British West Indies Grid\",GE");
    add_srs_wkt (p, 1,
		 "OGCS[\"Montserrat 1958\",DATUM[\"Montserrat_1958\",SPHER");
    add_srs_wkt (p, 2,
		 "OID[\"Clarke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[");
    add_srs_wkt (p, 3,
		 "\"EPSG\",\"7012\"]],TOWGS84[174,359,365,0,0,0,0],AUTHORI");
    add_srs_wkt (p, 4,
		 "TY[\"EPSG\",\"6604\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 5,
		 "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 6,
		 "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4604\"");
    add_srs_wkt (p, 7,
		 "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 8,
		 "ude_of_origin\",0],PARAMETER[\"central_meridian\",-62],P");
    add_srs_wkt (p, 9,
		 "ARAMETER[\"scale_factor\",0.9995],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
		 "ing\",400000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 11,
		 "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 12,
		 "ST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2004\"");
    add_srs_wkt (p, 13, "]]");
    p = add_epsg_def (filter, first, last, 2005, "epsg", 2005,
		      "St. Kitts 1955 / British West Indies Grid");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=-62 +k=0.9995000000000001 +x");
    add_proj4text (p, 1,
		   "_0=400000 +y_0=0 +ellps=clrk80 +towgs84=9,183,236,0,0,0,");
    add_proj4text (p, 2, "0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"St. Kitts 1955 / British West Indies Grid\",GEO");
    add_srs_wkt (p, 1,
		 "GCS[\"St. Kitts 1955\",DATUM[\"St_Kitts_1955\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Clarke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
		 "SG\",\"7012\"]],TOWGS84[9,183,236,0,0,0,0],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
		 "PSG\",\"6605\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
		 "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
		 "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4605\"]],PRO");
    add_srs_wkt (p, 7,
		 "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
		 "_origin\",0],PARAMETER[\"central_meridian\",-62],PARAMET");
    add_srs_wkt (p, 9,
		 "ER[\"scale_factor\",0.9995],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 10,
		 "400000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1");
    add_srs_wkt (p, 11,
		 ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AX");
    add_srs_wkt (p, 12, "IS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2005\"]]");
    p = add_epsg_def (filter, first, last, 2006, "epsg", 2006,
		      "St. Lucia 1955 / British West Indies Grid");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=-62 +k=0.9995000000000001 +x");
    add_proj4text (p, 1,
		   "_0=400000 +y_0=0 +ellps=clrk80 +towgs84=-149,128,296,0,0");
    add_proj4text (p, 2, ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"St. Lucia 1955 / British West Indies Grid\",GEO");
    add_srs_wkt (p, 1,
		 "GCS[\"St. Lucia 1955\",DATUM[\"St_Lucia_1955\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Clarke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
		 "SG\",\"7012\"]],TOWGS84[-149,128,296,0,0,0,0],AUTHORITY[");
    add_srs_wkt (p, 4,
		 "\"EPSG\",\"6606\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
		 "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
		 "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4606\"]],");
    add_srs_wkt (p, 7,
		 "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
		 "_of_origin\",0],PARAMETER[\"central_meridian\",-62],PARA");
    add_srs_wkt (p, 9,
		 "METER[\"scale_factor\",0.9995],PARAMETER[\"false_easting");
    add_srs_wkt (p, 10,
		 "\",400000],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
		 ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 12,
		 "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2006\"]]");
    p = add_epsg_def (filter, first, last, 2007, "epsg", 2007,
		      "St. Vincent 45 / British West Indies Grid");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=-62 +k=0.9995000000000001 +x");
    add_proj4text (p, 1,
		   "_0=400000 +y_0=0 +ellps=clrk80 +towgs84=195.671,332.517,");
    add_proj4text (p, 2, "274.607,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"St. Vincent 45 / British West Indies Grid\",GEO");
    add_srs_wkt (p, 1,
		 "GCS[\"St. Vincent 1945\",DATUM[\"St_Vincent_1945\",SPHER");
    add_srs_wkt (p, 2,
		 "OID[\"Clarke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[");
    add_srs_wkt (p, 3,
		 "\"EPSG\",\"7012\"]],TOWGS84[195.671,332.517,274.607,0,0,");
    add_srs_wkt (p, 4,
		 "0,0],AUTHORITY[\"EPSG\",\"6607\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 5,
		 "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 6,
		 "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 7,
		 "G\",\"4607\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 8,
		 "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 9,
		 "ian\",-62],PARAMETER[\"scale_factor\",0.9995],PARAMETER[");
    add_srs_wkt (p, 10,
		 "\"false_easting\",400000],PARAMETER[\"false_northing\",0");
    add_srs_wkt (p, 11,
		 "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 12,
		 "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13, "G\",\"2007\"]]");
    p = add_epsg_def (filter, first, last, 2008, "epsg", 2008,
		      "NAD27(CGQ77) / SCoPQ zone 2 (deprecated)");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=-55.5 +k=0.9999 +x_0=304800 ");
    add_proj4text (p, 1, "+y_0=0 +ellps=clrk66 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD27(CGQ77) / SCoPQ zone 2 (deprecated)\",GEOG");
    add_srs_wkt (p, 1,
		 "CS[\"NAD27(CGQ77)\",DATUM[\"North_American_Datum_1927_CG");
    add_srs_wkt (p, 2,
		 "Q77\",SPHEROID[\"Clarke 1866\",6378206.4,294.97869821389");
    add_srs_wkt (p, 3,
		 "82,AUTHORITY[\"EPSG\",\"7008\"]],AUTHORITY[\"EPSG\",\"66");
    add_srs_wkt (p, 4,
		 "09\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
		 "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
		 ",\"9122\"]],AUTHORITY[\"EPSG\",\"4609\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
		 "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 8,
		 "],PARAMETER[\"central_meridian\",-55.5],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
		 "e_factor\",0.9999],PARAMETER[\"false_easting\",304800],P");
    add_srs_wkt (p, 10,
		 "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
		 "Y[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH]");
    add_srs_wkt (p, 12, ",AUTHORITY[\"EPSG\",\"2008\"]]");
    p = add_epsg_def (filter, first, last, 2009, "epsg", 2009,
		      "NAD27(CGQ77) / SCoPQ zone 3");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=-58.5 +k=0.9999 +x_0=304800 ");
    add_proj4text (p, 1, "+y_0=0 +ellps=clrk66 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD27(CGQ77) / SCoPQ zone 3\",GEOGCS[\"NAD27(CG");
    add_srs_wkt (p, 1,
		 "Q77)\",DATUM[\"North_American_Datum_1927_CGQ77\",SPHEROI");
    add_srs_wkt (p, 2,
		 "D[\"Clarke 1866\",6378206.4,294.9786982138982,AUTHORITY[");
    add_srs_wkt (p, 3,
		 "\"EPSG\",\"7008\"]],AUTHORITY[\"EPSG\",\"6609\"]],PRIMEM");
    add_srs_wkt (p, 4,
		 "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
		 "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
		 "AUTHORITY[\"EPSG\",\"4609\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 7,
		 "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 8,
		 "\"central_meridian\",-58.5],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 9,
		 ".9999],PARAMETER[\"false_easting\",304800],PARAMETER[\"f");
    add_srs_wkt (p, 10,
		 "alse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
		 "9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 12, "EPSG\",\"2009\"]]");
    p = add_epsg_def (filter, first, last, 2010, "epsg", 2010,
		      "NAD27(CGQ77) / SCoPQ zone 4");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=-61.5 +k=0.9999 +x_0=304800 ");
    add_proj4text (p, 1, "+y_0=0 +ellps=clrk66 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD27(CGQ77) / SCoPQ zone 4\",GEOGCS[\"NAD27(CG");
    add_srs_wkt (p, 1,
		 "Q77)\",DATUM[\"North_American_Datum_1927_CGQ77\",SPHEROI");
    add_srs_wkt (p, 2,
		 "D[\"Clarke 1866\",6378206.4,294.9786982138982,AUTHORITY[");
    add_srs_wkt (p, 3,
		 "\"EPSG\",\"7008\"]],AUTHORITY[\"EPSG\",\"6609\"]],PRIMEM");
    add_srs_wkt (p, 4,
		 "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
		 "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
		 "AUTHORITY[\"EPSG\",\"4609\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 7,
		 "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 8,
		 "\"central_meridian\",-61.5],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 9,
		 ".9999],PARAMETER[\"false_easting\",304800],PARAMETER[\"f");
    add_srs_wkt (p, 10,
		 "alse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
		 "9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 12, "EPSG\",\"2010\"]]");
    p = add_epsg_def (filter, first, last, 2011, "epsg", 2011,
		      "NAD27(CGQ77) / SCoPQ zone 5");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=-64.5 +k=0.9999 +x_0=304800 ");
    add_proj4text (p, 1, "+y_0=0 +ellps=clrk66 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD27(CGQ77) / SCoPQ zone 5\",GEOGCS[\"NAD27(CG");
    add_srs_wkt (p, 1,
		 "Q77)\",DATUM[\"North_American_Datum_1927_CGQ77\",SPHEROI");
    add_srs_wkt (p, 2,
		 "D[\"Clarke 1866\",6378206.4,294.9786982138982,AUTHORITY[");
    add_srs_wkt (p, 3,
		 "\"EPSG\",\"7008\"]],AUTHORITY[\"EPSG\",\"6609\"]],PRIMEM");
    add_srs_wkt (p, 4,
		 "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
		 "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
		 "AUTHORITY[\"EPSG\",\"4609\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 7,
		 "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 8,
		 "\"central_meridian\",-64.5],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 9,
		 ".9999],PARAMETER[\"false_easting\",304800],PARAMETER[\"f");
    add_srs_wkt (p, 10,
		 "alse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
		 "9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 12, "EPSG\",\"2011\"]]");
    p = add_epsg_def (filter, first, last, 2012, "epsg", 2012,
		      "NAD27(CGQ77) / SCoPQ zone 6");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=-67.5 +k=0.9999 +x_0=304800 ");
    add_proj4text (p, 1, "+y_0=0 +ellps=clrk66 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD27(CGQ77) / SCoPQ zone 6\",GEOGCS[\"NAD27(CG");
    add_srs_wkt (p, 1,
		 "Q77)\",DATUM[\"North_American_Datum_1927_CGQ77\",SPHEROI");
    add_srs_wkt (p, 2,
		 "D[\"Clarke 1866\",6378206.4,294.9786982138982,AUTHORITY[");
    add_srs_wkt (p, 3,
		 "\"EPSG\",\"7008\"]],AUTHORITY[\"EPSG\",\"6609\"]],PRIMEM");
    add_srs_wkt (p, 4,
		 "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
		 "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
		 "AUTHORITY[\"EPSG\",\"4609\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 7,
		 "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 8,
		 "\"central_meridian\",-67.5],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 9,
		 ".9999],PARAMETER[\"false_easting\",304800],PARAMETER[\"f");
    add_srs_wkt (p, 10,
		 "alse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
		 "9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 12, "EPSG\",\"2012\"]]");
    p = add_epsg_def (filter, first, last, 2013, "epsg", 2013,
		      "NAD27(CGQ77) / SCoPQ zone 7");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=-70.5 +k=0.9999 +x_0=304800 ");
    add_proj4text (p, 1, "+y_0=0 +ellps=clrk66 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD27(CGQ77) / SCoPQ zone 7\",GEOGCS[\"NAD27(CG");
    add_srs_wkt (p, 1,
		 "Q77)\",DATUM[\"North_American_Datum_1927_CGQ77\",SPHEROI");
    add_srs_wkt (p, 2,
		 "D[\"Clarke 1866\",6378206.4,294.9786982138982,AUTHORITY[");
    add_srs_wkt (p, 3,
		 "\"EPSG\",\"7008\"]],AUTHORITY[\"EPSG\",\"6609\"]],PRIMEM");
    add_srs_wkt (p, 4,
		 "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
		 "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
		 "AUTHORITY[\"EPSG\",\"4609\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 7,
		 "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 8,
		 "\"central_meridian\",-70.5],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 9,
		 ".9999],PARAMETER[\"false_easting\",304800],PARAMETER[\"f");
    add_srs_wkt (p, 10,
		 "alse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
		 "9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 12, "EPSG\",\"2013\"]]");
    p = add_epsg_def (filter, first, last, 2014, "epsg", 2014,
		      "NAD27(CGQ77) / SCoPQ zone 8");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=-73.5 +k=0.9999 +x_0=304800 ");
    add_proj4text (p, 1, "+y_0=0 +ellps=clrk66 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD27(CGQ77) / SCoPQ zone 8\",GEOGCS[\"NAD27(CG");
    add_srs_wkt (p, 1,
		 "Q77)\",DATUM[\"North_American_Datum_1927_CGQ77\",SPHEROI");
    add_srs_wkt (p, 2,
		 "D[\"Clarke 1866\",6378206.4,294.9786982138982,AUTHORITY[");
    add_srs_wkt (p, 3,
		 "\"EPSG\",\"7008\"]],AUTHORITY[\"EPSG\",\"6609\"]],PRIMEM");
    add_srs_wkt (p, 4,
		 "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
		 "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
		 "AUTHORITY[\"EPSG\",\"4609\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 7,
		 "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 8,
		 "\"central_meridian\",-73.5],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 9,
		 ".9999],PARAMETER[\"false_easting\",304800],PARAMETER[\"f");
    add_srs_wkt (p, 10,
		 "alse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
		 "9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 12, "EPSG\",\"2014\"]]");
    p = add_epsg_def (filter, first, last, 2015, "epsg", 2015,
		      "NAD27(CGQ77) / SCoPQ zone 9");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=-76.5 +k=0.9999 +x_0=304800 ");
    add_proj4text (p, 1, "+y_0=0 +ellps=clrk66 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD27(CGQ77) / SCoPQ zone 9\",GEOGCS[\"NAD27(CG");
    add_srs_wkt (p, 1,
		 "Q77)\",DATUM[\"North_American_Datum_1927_CGQ77\",SPHEROI");
    add_srs_wkt (p, 2,
		 "D[\"Clarke 1866\",6378206.4,294.9786982138982,AUTHORITY[");
    add_srs_wkt (p, 3,
		 "\"EPSG\",\"7008\"]],AUTHORITY[\"EPSG\",\"6609\"]],PRIMEM");
    add_srs_wkt (p, 4,
		 "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
		 "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
		 "AUTHORITY[\"EPSG\",\"4609\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 7,
		 "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 8,
		 "\"central_meridian\",-76.5],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 9,
		 ".9999],PARAMETER[\"false_easting\",304800],PARAMETER[\"f");
    add_srs_wkt (p, 10,
		 "alse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
		 "9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 12, "EPSG\",\"2015\"]]");
    p = add_epsg_def (filter, first, last, 2016, "epsg", 2016,
		      "NAD27(CGQ77) / SCoPQ zone 10");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=-79.5 +k=0.9999 +x_0=304800 ");
    add_proj4text (p, 1, "+y_0=0 +ellps=clrk66 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD27(CGQ77) / SCoPQ zone 10\",GEOGCS[\"NAD27(C");
    add_srs_wkt (p, 1,
		 "GQ77)\",DATUM[\"North_American_Datum_1927_CGQ77\",SPHERO");
    add_srs_wkt (p, 2,
		 "ID[\"Clarke 1866\",6378206.4,294.9786982138982,AUTHORITY");
    add_srs_wkt (p, 3,
		 "[\"EPSG\",\"7008\"]],AUTHORITY[\"EPSG\",\"6609\"]],PRIME");
    add_srs_wkt (p, 4,
		 "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
		 "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
		 ",AUTHORITY[\"EPSG\",\"4609\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 7,
		 "ercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER");
    add_srs_wkt (p, 8,
		 "[\"central_meridian\",-79.5],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 9,
		 "0.9999],PARAMETER[\"false_easting\",304800],PARAMETER[\"");
    add_srs_wkt (p, 10,
		 "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
		 "\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 12, "\"EPSG\",\"2016\"]]");
    p = add_epsg_def (filter, first, last, 2017, "epsg", 2017,
		      "NAD27(76) / MTM zone 8");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=-73.5 +k=0.9999 +x_0=304800 ");
    add_proj4text (p, 1, "+y_0=0 +ellps=clrk66 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD27(76) / MTM zone 8\",GEOGCS[\"NAD27(76)\",D");
    add_srs_wkt (p, 1,
		 "ATUM[\"North_American_Datum_1927_1976\",SPHEROID[\"Clark");
    add_srs_wkt (p, 2,
		 "e 1866\",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
		 "\"7008\"]],AUTHORITY[\"EPSG\",\"6608\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 4,
		 "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 5,
		 "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY");
    add_srs_wkt (p, 6,
		 "[\"EPSG\",\"4608\"]],PROJECTION[\"Transverse_Mercator\"]");
    add_srs_wkt (p, 7,
		 ",PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central");
    add_srs_wkt (p, 8,
		 "_meridian\",-73.5],PARAMETER[\"scale_factor\",0.9999],PA");
    add_srs_wkt (p, 9,
		 "RAMETER[\"false_easting\",304800],PARAMETER[\"false_nort");
    add_srs_wkt (p, 10,
		 "hing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 11,
		 ",AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12, "2017\"]]");
    p = add_epsg_def (filter, first, last, 2018, "epsg", 2018,
		      "NAD27(76) / MTM zone 9");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=-76.5 +k=0.9999 +x_0=304800 ");
    add_proj4text (p, 1, "+y_0=0 +ellps=clrk66 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD27(76) / MTM zone 9\",GEOGCS[\"NAD27(76)\",D");
    add_srs_wkt (p, 1,
		 "ATUM[\"North_American_Datum_1927_1976\",SPHEROID[\"Clark");
    add_srs_wkt (p, 2,
		 "e 1866\",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
		 "\"7008\"]],AUTHORITY[\"EPSG\",\"6608\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 4,
		 "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 5,
		 "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY");
    add_srs_wkt (p, 6,
		 "[\"EPSG\",\"4608\"]],PROJECTION[\"Transverse_Mercator\"]");
    add_srs_wkt (p, 7,
		 ",PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central");
    add_srs_wkt (p, 8,
		 "_meridian\",-76.5],PARAMETER[\"scale_factor\",0.9999],PA");
    add_srs_wkt (p, 9,
		 "RAMETER[\"false_easting\",304800],PARAMETER[\"false_nort");
    add_srs_wkt (p, 10,
		 "hing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 11,
		 ",AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12, "2018\"]]");
    p = add_epsg_def (filter, first, last, 2019, "epsg", 2019,
		      "NAD27(76) / MTM zone 10");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=-79.5 +k=0.9999 +x_0=304800 ");
    add_proj4text (p, 1, "+y_0=0 +ellps=clrk66 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD27(76) / MTM zone 10\",GEOGCS[\"NAD27(76)\",");
    add_srs_wkt (p, 1,
		 "DATUM[\"North_American_Datum_1927_1976\",SPHEROID[\"Clar");
    add_srs_wkt (p, 2,
		 "ke 1866\",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
		 ",\"7008\"]],AUTHORITY[\"EPSG\",\"6608\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
		 "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
		 ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
		 "Y[\"EPSG\",\"4608\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
		 "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
		 "l_meridian\",-79.5],PARAMETER[\"scale_factor\",0.9999],P");
    add_srs_wkt (p, 9,
		 "ARAMETER[\"false_easting\",304800],PARAMETER[\"false_nor");
    add_srs_wkt (p, 10,
		 "thing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 11,
		 "],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12, "\"2019\"]]");
    p = add_epsg_def (filter, first, last, 2020, "epsg", 2020,
		      "NAD27(76) / MTM zone 11");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=-82.5 +k=0.9999 +x_0=304800 ");
    add_proj4text (p, 1, "+y_0=0 +ellps=clrk66 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD27(76) / MTM zone 11\",GEOGCS[\"NAD27(76)\",");
    add_srs_wkt (p, 1,
		 "DATUM[\"North_American_Datum_1927_1976\",SPHEROID[\"Clar");
    add_srs_wkt (p, 2,
		 "ke 1866\",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
		 ",\"7008\"]],AUTHORITY[\"EPSG\",\"6608\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
		 "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
		 ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
		 "Y[\"EPSG\",\"4608\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
		 "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
		 "l_meridian\",-82.5],PARAMETER[\"scale_factor\",0.9999],P");
    add_srs_wkt (p, 9,
		 "ARAMETER[\"false_easting\",304800],PARAMETER[\"false_nor");
    add_srs_wkt (p, 10,
		 "thing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 11,
		 "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 12, "ITY[\"EPSG\",\"2020\"]]");
    p = add_epsg_def (filter, first, last, 2021, "epsg", 2021,
		      "NAD27(76) / MTM zone 12");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=-81 +k=0.9999 +x_0=304800 +y");
    add_proj4text (p, 1, "_0=0 +ellps=clrk66 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD27(76) / MTM zone 12\",GEOGCS[\"NAD27(76)\",");
    add_srs_wkt (p, 1,
		 "DATUM[\"North_American_Datum_1927_1976\",SPHEROID[\"Clar");
    add_srs_wkt (p, 2,
		 "ke 1866\",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
		 ",\"7008\"]],AUTHORITY[\"EPSG\",\"6608\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
		 "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
		 ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
		 "Y[\"EPSG\",\"4608\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
		 "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
		 "l_meridian\",-81],PARAMETER[\"scale_factor\",0.9999],PAR");
    add_srs_wkt (p, 9,
		 "AMETER[\"false_easting\",304800],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
		 "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
		 "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 12, "Y[\"EPSG\",\"2021\"]]");
    p = add_epsg_def (filter, first, last, 2022, "epsg", 2022,
		      "NAD27(76) / MTM zone 13");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=-84 +k=0.9999 +x_0=304800 +y");
    add_proj4text (p, 1, "_0=0 +ellps=clrk66 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD27(76) / MTM zone 13\",GEOGCS[\"NAD27(76)\",");
    add_srs_wkt (p, 1,
		 "DATUM[\"North_American_Datum_1927_1976\",SPHEROID[\"Clar");
    add_srs_wkt (p, 2,
		 "ke 1866\",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
		 ",\"7008\"]],AUTHORITY[\"EPSG\",\"6608\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
		 "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
		 ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
		 "Y[\"EPSG\",\"4608\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
		 "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
		 "l_meridian\",-84],PARAMETER[\"scale_factor\",0.9999],PAR");
    add_srs_wkt (p, 9,
		 "AMETER[\"false_easting\",304800],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
		 "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
		 "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 12, "Y[\"EPSG\",\"2022\"]]");
    p = add_epsg_def (filter, first, last, 2023, "epsg", 2023,
		      "NAD27(76) / MTM zone 14");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=-87 +k=0.9999 +x_0=304800 +y");
    add_proj4text (p, 1, "_0=0 +ellps=clrk66 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD27(76) / MTM zone 14\",GEOGCS[\"NAD27(76)\",");
    add_srs_wkt (p, 1,
		 "DATUM[\"North_American_Datum_1927_1976\",SPHEROID[\"Clar");
    add_srs_wkt (p, 2,
		 "ke 1866\",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
		 ",\"7008\"]],AUTHORITY[\"EPSG\",\"6608\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
		 "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
		 ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
		 "Y[\"EPSG\",\"4608\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
		 "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
		 "l_meridian\",-87],PARAMETER[\"scale_factor\",0.9999],PAR");
    add_srs_wkt (p, 9,
		 "AMETER[\"false_easting\",304800],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
		 "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
		 "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 12, "Y[\"EPSG\",\"2023\"]]");
    p = add_epsg_def (filter, first, last, 2024, "epsg", 2024,
		      "NAD27(76) / MTM zone 15");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=-90 +k=0.9999 +x_0=304800 +y");
    add_proj4text (p, 1, "_0=0 +ellps=clrk66 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD27(76) / MTM zone 15\",GEOGCS[\"NAD27(76)\",");
    add_srs_wkt (p, 1,
		 "DATUM[\"North_American_Datum_1927_1976\",SPHEROID[\"Clar");
    add_srs_wkt (p, 2,
		 "ke 1866\",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
		 ",\"7008\"]],AUTHORITY[\"EPSG\",\"6608\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
		 "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
		 ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
		 "Y[\"EPSG\",\"4608\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
		 "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
		 "l_meridian\",-90],PARAMETER[\"scale_factor\",0.9999],PAR");
    add_srs_wkt (p, 9,
		 "AMETER[\"false_easting\",304800],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
		 "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
		 "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 12, "Y[\"EPSG\",\"2024\"]]");
    p = add_epsg_def (filter, first, last, 2025, "epsg", 2025,
		      "NAD27(76) / MTM zone 16");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=-93 +k=0.9999 +x_0=304800 +y");
    add_proj4text (p, 1, "_0=0 +ellps=clrk66 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD27(76) / MTM zone 16\",GEOGCS[\"NAD27(76)\",");
    add_srs_wkt (p, 1,
		 "DATUM[\"North_American_Datum_1927_1976\",SPHEROID[\"Clar");
    add_srs_wkt (p, 2,
		 "ke 1866\",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
		 ",\"7008\"]],AUTHORITY[\"EPSG\",\"6608\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
		 "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
		 ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
		 "Y[\"EPSG\",\"4608\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
		 "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
		 "l_meridian\",-93],PARAMETER[\"scale_factor\",0.9999],PAR");
    add_srs_wkt (p, 9,
		 "AMETER[\"false_easting\",304800],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
		 "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
		 "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 12, "Y[\"EPSG\",\"2025\"]]");
    p = add_epsg_def (filter, first, last, 2026, "epsg", 2026,
		      "NAD27(76) / MTM zone 17");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=-96 +k=0.9999 +x_0=304800 +y");
    add_proj4text (p, 1, "_0=0 +ellps=clrk66 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD27(76) / MTM zone 17\",GEOGCS[\"NAD27(76)\",");
    add_srs_wkt (p, 1,
		 "DATUM[\"North_American_Datum_1927_1976\",SPHEROID[\"Clar");
    add_srs_wkt (p, 2,
		 "ke 1866\",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
		 ",\"7008\"]],AUTHORITY[\"EPSG\",\"6608\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
		 "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
		 ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
		 "Y[\"EPSG\",\"4608\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
		 "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
		 "l_meridian\",-96],PARAMETER[\"scale_factor\",0.9999],PAR");
    add_srs_wkt (p, 9,
		 "AMETER[\"false_easting\",304800],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
		 "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
		 "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 12, "Y[\"EPSG\",\"2026\"]]");
    p = add_epsg_def (filter, first, last, 2027, "epsg", 2027,
		      "NAD27(76) / UTM zone 15N");
    add_proj4text (p, 0, "+proj=utm +zone=15 +ellps=clrk66 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD27(76) / UTM zone 15N\",GEOGCS[\"NAD27(76)\"");
    add_srs_wkt (p, 1,
		 ",DATUM[\"North_American_Datum_1927_1976\",SPHEROID[\"Cla");
    add_srs_wkt (p, 2,
		 "rke 1866\",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
		 ",\"7008\"]],AUTHORITY[\"EPSG\",\"6608\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
		 "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
		 ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
		 "Y[\"EPSG\",\"4608\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
		 "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
		 "l_meridian\",-93],PARAMETER[\"scale_factor\",0.9996],PAR");
    add_srs_wkt (p, 9,
		 "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
		 "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
		 "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 12, "Y[\"EPSG\",\"2027\"]]");
    p = add_epsg_def (filter, first, last, 2028, "epsg", 2028,
		      "NAD27(76) / UTM zone 16N");
    add_proj4text (p, 0, "+proj=utm +zone=16 +ellps=clrk66 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD27(76) / UTM zone 16N\",GEOGCS[\"NAD27(76)\"");
    add_srs_wkt (p, 1,
		 ",DATUM[\"North_American_Datum_1927_1976\",SPHEROID[\"Cla");
    add_srs_wkt (p, 2,
		 "rke 1866\",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
		 ",\"7008\"]],AUTHORITY[\"EPSG\",\"6608\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
		 "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
		 ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
		 "Y[\"EPSG\",\"4608\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
		 "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
		 "l_meridian\",-87],PARAMETER[\"scale_factor\",0.9996],PAR");
    add_srs_wkt (p, 9,
		 "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
		 "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
		 "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 12, "Y[\"EPSG\",\"2028\"]]");
    p = add_epsg_def (filter, first, last, 2029, "epsg", 2029,
		      "NAD27(76) / UTM zone 17N");
    add_proj4text (p, 0, "+proj=utm +zone=17 +ellps=clrk66 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD27(76) / UTM zone 17N\",GEOGCS[\"NAD27(76)\"");
    add_srs_wkt (p, 1,
		 ",DATUM[\"North_American_Datum_1927_1976\",SPHEROID[\"Cla");
    add_srs_wkt (p, 2,
		 "rke 1866\",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
		 ",\"7008\"]],AUTHORITY[\"EPSG\",\"6608\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
		 "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
		 ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
		 "Y[\"EPSG\",\"4608\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
		 "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
		 "l_meridian\",-81],PARAMETER[\"scale_factor\",0.9996],PAR");
    add_srs_wkt (p, 9,
		 "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
		 "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
		 "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 12, "Y[\"EPSG\",\"2029\"]]");
    p = add_epsg_def (filter, first, last, 2030, "epsg", 2030,
		      "NAD27(76) / UTM zone 18N");
    add_proj4text (p, 0, "+proj=utm +zone=18 +ellps=clrk66 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD27(76) / UTM zone 18N\",GEOGCS[\"NAD27(76)\"");
    add_srs_wkt (p, 1,
		 ",DATUM[\"North_American_Datum_1927_1976\",SPHEROID[\"Cla");
    add_srs_wkt (p, 2,
		 "rke 1866\",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
		 ",\"7008\"]],AUTHORITY[\"EPSG\",\"6608\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
		 "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
		 ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
		 "Y[\"EPSG\",\"4608\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
		 "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
		 "l_meridian\",-75],PARAMETER[\"scale_factor\",0.9996],PAR");
    add_srs_wkt (p, 9,
		 "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
		 "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
		 "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 12, "Y[\"EPSG\",\"2030\"]]");
    p = add_epsg_def (filter, first, last, 2031, "epsg", 2031,
		      "NAD27(CGQ77) / UTM zone 17N");
    add_proj4text (p, 0, "+proj=utm +zone=17 +ellps=clrk66 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD27(CGQ77) / UTM zone 17N\",GEOGCS[\"NAD27(CG");
    add_srs_wkt (p, 1,
		 "Q77)\",DATUM[\"North_American_Datum_1927_CGQ77\",SPHEROI");
    add_srs_wkt (p, 2,
		 "D[\"Clarke 1866\",6378206.4,294.9786982138982,AUTHORITY[");
    add_srs_wkt (p, 3,
		 "\"EPSG\",\"7008\"]],AUTHORITY[\"EPSG\",\"6609\"]],PRIMEM");
    add_srs_wkt (p, 4,
		 "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
		 "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
		 "AUTHORITY[\"EPSG\",\"4609\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 7,
		 "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 8,
		 "\"central_meridian\",-81],PARAMETER[\"scale_factor\",0.9");
    add_srs_wkt (p, 9,
		 "996],PARAMETER[\"false_easting\",500000],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
		 "se_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 11,
		 "001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],");
    add_srs_wkt (p, 12, "AUTHORITY[\"EPSG\",\"2031\"]]");
    p = add_epsg_def (filter, first, last, 2032, "epsg", 2032,
		      "NAD27(CGQ77) / UTM zone 18N");
    add_proj4text (p, 0, "+proj=utm +zone=18 +ellps=clrk66 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD27(CGQ77) / UTM zone 18N\",GEOGCS[\"NAD27(CG");
    add_srs_wkt (p, 1,
		 "Q77)\",DATUM[\"North_American_Datum_1927_CGQ77\",SPHEROI");
    add_srs_wkt (p, 2,
		 "D[\"Clarke 1866\",6378206.4,294.9786982138982,AUTHORITY[");
    add_srs_wkt (p, 3,
		 "\"EPSG\",\"7008\"]],AUTHORITY[\"EPSG\",\"6609\"]],PRIMEM");
    add_srs_wkt (p, 4,
		 "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
		 "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
		 "AUTHORITY[\"EPSG\",\"4609\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 7,
		 "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 8,
		 "\"central_meridian\",-75],PARAMETER[\"scale_factor\",0.9");
    add_srs_wkt (p, 9,
		 "996],PARAMETER[\"false_easting\",500000],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
		 "se_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 11,
		 "001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],");
    add_srs_wkt (p, 12, "AUTHORITY[\"EPSG\",\"2032\"]]");
    p = add_epsg_def (filter, first, last, 2033, "epsg", 2033,
		      "NAD27(CGQ77) / UTM zone 19N");
    add_proj4text (p, 0, "+proj=utm +zone=19 +ellps=clrk66 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD27(CGQ77) / UTM zone 19N\",GEOGCS[\"NAD27(CG");
    add_srs_wkt (p, 1,
		 "Q77)\",DATUM[\"North_American_Datum_1927_CGQ77\",SPHEROI");
    add_srs_wkt (p, 2,
		 "D[\"Clarke 1866\",6378206.4,294.9786982138982,AUTHORITY[");
    add_srs_wkt (p, 3,
		 "\"EPSG\",\"7008\"]],AUTHORITY[\"EPSG\",\"6609\"]],PRIMEM");
    add_srs_wkt (p, 4,
		 "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
		 "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
		 "AUTHORITY[\"EPSG\",\"4609\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 7,
		 "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 8,
		 "\"central_meridian\",-69],PARAMETER[\"scale_factor\",0.9");
    add_srs_wkt (p, 9,
		 "996],PARAMETER[\"false_easting\",500000],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
		 "se_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 11,
		 "001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],");
    add_srs_wkt (p, 12, "AUTHORITY[\"EPSG\",\"2033\"]]");
    p = add_epsg_def (filter, first, last, 2034, "epsg", 2034,
		      "NAD27(CGQ77) / UTM zone 20N");
    add_proj4text (p, 0, "+proj=utm +zone=20 +ellps=clrk66 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD27(CGQ77) / UTM zone 20N\",GEOGCS[\"NAD27(CG");
    add_srs_wkt (p, 1,
		 "Q77)\",DATUM[\"North_American_Datum_1927_CGQ77\",SPHEROI");
    add_srs_wkt (p, 2,
		 "D[\"Clarke 1866\",6378206.4,294.9786982138982,AUTHORITY[");
    add_srs_wkt (p, 3,
		 "\"EPSG\",\"7008\"]],AUTHORITY[\"EPSG\",\"6609\"]],PRIMEM");
    add_srs_wkt (p, 4,
		 "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
		 "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
		 "AUTHORITY[\"EPSG\",\"4609\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 7,
		 "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 8,
		 "\"central_meridian\",-63],PARAMETER[\"scale_factor\",0.9");
    add_srs_wkt (p, 9,
		 "996],PARAMETER[\"false_easting\",500000],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
		 "se_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 11,
		 "001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],");
    add_srs_wkt (p, 12, "AUTHORITY[\"EPSG\",\"2034\"]]");
    p = add_epsg_def (filter, first, last, 2035, "epsg", 2035,
		      "NAD27(CGQ77) / UTM zone 21N");
    add_proj4text (p, 0, "+proj=utm +zone=21 +ellps=clrk66 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD27(CGQ77) / UTM zone 21N\",GEOGCS[\"NAD27(CG");
    add_srs_wkt (p, 1,
		 "Q77)\",DATUM[\"North_American_Datum_1927_CGQ77\",SPHEROI");
    add_srs_wkt (p, 2,
		 "D[\"Clarke 1866\",6378206.4,294.9786982138982,AUTHORITY[");
    add_srs_wkt (p, 3,
		 "\"EPSG\",\"7008\"]],AUTHORITY[\"EPSG\",\"6609\"]],PRIMEM");
    add_srs_wkt (p, 4,
		 "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
		 "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
		 "AUTHORITY[\"EPSG\",\"4609\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 7,
		 "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 8,
		 "\"central_meridian\",-57],PARAMETER[\"scale_factor\",0.9");
    add_srs_wkt (p, 9,
		 "996],PARAMETER[\"false_easting\",500000],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
		 "se_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 11,
		 "001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],");
    add_srs_wkt (p, 12, "AUTHORITY[\"EPSG\",\"2035\"]]");
    p = add_epsg_def (filter, first, last, 2036, "epsg", 2036,
		      "NAD83(CSRS98) / New Brunswick Stereo (deprecated)");
    add_proj4text (p, 0,
		   "+proj=sterea +lat_0=46.5 +lon_0=-66.5 +k=0.999912 +x_0=2");
    add_proj4text (p, 1,
		   "500000 +y_0=7500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 ");
    add_proj4text (p, 2, "+units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83(CSRS98) / New Brunswick Stereo (deprecate");
    add_srs_wkt (p, 1,
		 "d)\",GEOGCS[\"NAD83(CSRS98)\",DATUM[\"NAD83_Canadian_Spa");
    add_srs_wkt (p, 2,
		 "tial_Reference_System\",SPHEROID[\"GRS 1980\",6378137,29");
    add_srs_wkt (p, 3,
		 "8.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,");
    add_srs_wkt (p, 4,
		 "0,0,0,0],AUTHORITY[\"EPSG\",\"6140\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 5,
		 "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 6,
		 "74532925199433,AUTHORITY[\"EPSG\",\"9108\"]],AUTHORITY[\"");
    add_srs_wkt (p, 7,
		 "EPSG\",\"4140\"]],PROJECTION[\"Oblique_Stereographic\"],");
    add_srs_wkt (p, 8,
		 "PARAMETER[\"latitude_of_origin\",46.5],PARAMETER[\"centr");
    add_srs_wkt (p, 9,
		 "al_meridian\",-66.5],PARAMETER[\"scale_factor\",0.999912");
    add_srs_wkt (p, 10,
		 "],PARAMETER[\"false_easting\",2500000],PARAMETER[\"false");
    add_srs_wkt (p, 11,
		 "_northing\",7500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
		 ",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 13, "ST],AUTHORITY[\"EPSG\",\"2036\"]]");
    p = add_epsg_def (filter, first, last, 2037, "epsg", 2037,
		      "NAD83(CSRS98) / UTM zone 19N (deprecated)");
    add_proj4text (p, 0,
		   "+proj=utm +zone=19 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1, "units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83(CSRS98) / UTM zone 19N (deprecated)\",GEO");
    add_srs_wkt (p, 1,
		 "GCS[\"NAD83(CSRS98)\",DATUM[\"NAD83_Canadian_Spatial_Ref");
    add_srs_wkt (p, 2,
		 "erence_System\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
		 "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 4,
		 ",AUTHORITY[\"EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
		 "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
		 "199433,AUTHORITY[\"EPSG\",\"9108\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
		 "\"4140\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 8,
		 "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
		 ",-69],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
		 "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 11,
		 "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 12,
		 "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13, "2037\"]]");
    p = add_epsg_def (filter, first, last, 2038, "epsg", 2038,
		      "NAD83(CSRS98) / UTM zone 20N (deprecated)");
    add_proj4text (p, 0,
		   "+proj=utm +zone=20 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1, "units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83(CSRS98) / UTM zone 20N (deprecated)\",GEO");
    add_srs_wkt (p, 1,
		 "GCS[\"NAD83(CSRS98)\",DATUM[\"NAD83_Canadian_Spatial_Ref");
    add_srs_wkt (p, 2,
		 "erence_System\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
		 "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 4,
		 ",AUTHORITY[\"EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
		 "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
		 "199433,AUTHORITY[\"EPSG\",\"9108\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
		 "\"4140\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 8,
		 "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
		 ",-63],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
		 "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 11,
		 "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 12,
		 "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13, "2038\"]]");
    p = add_epsg_def (filter, first, last, 2039, "epsg", 2039,
		      "Israel / Israeli TM Grid");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=31.73439361111111 +lon_0=35.204516944");
    add_proj4text (p, 1,
		   "44445 +k=1.0000067 +x_0=219529.584 +y_0=626907.39 +ellps");
    add_proj4text (p, 2, "=GRS80 +towgs84=-48,55,52,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Israel / Israeli TM Grid\",GEOGCS[\"Israel\",DA");
    add_srs_wkt (p, 1,
		 "TUM[\"Israel\",SPHEROID[\"GRS 1980\",6378137,298.2572221");
    add_srs_wkt (p, 2,
		 "01,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[-48,55,52,0,0,0");
    add_srs_wkt (p, 3,
		 ",0],AUTHORITY[\"EPSG\",\"6141\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 4,
		 ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 5,
		 "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
		 "\",\"4141\"]],PROJECTION[\"Transverse_Mercator\"],PARAME");
    add_srs_wkt (p, 7,
		 "TER[\"latitude_of_origin\",31.73439361111111],PARAMETER[");
    add_srs_wkt (p, 8,
		 "\"central_meridian\",35.20451694444445],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
		 "e_factor\",1.0000067],PARAMETER[\"false_easting\",219529");
    add_srs_wkt (p, 10,
		 ".584],PARAMETER[\"false_northing\",626907.39],UNIT[\"met");
    add_srs_wkt (p, 11,
		 "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 12,
		 "ST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2039\"");
    add_srs_wkt (p, 13, "]]");
    p = add_epsg_def (filter, first, last, 2040, "epsg", 2040,
		      "Locodjo 1965 / UTM zone 30N");
    add_proj4text (p, 0,
		   "+proj=utm +zone=30 +ellps=clrk80 +towgs84=-125,53,467,0,");
    add_proj4text (p, 1, "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Locodjo 1965 / UTM zone 30N\",GEOGCS[\"Locodjo ");
    add_srs_wkt (p, 1,
		 "1965\",DATUM[\"Locodjo_1965\",SPHEROID[\"Clarke 1880 (RG");
    add_srs_wkt (p, 2,
		 "S)\",6378249.145,293.465,AUTHORITY[\"EPSG\",\"7012\"]],T");
    add_srs_wkt (p, 3,
		 "OWGS84[-125,53,467,0,0,0,0],AUTHORITY[\"EPSG\",\"6142\"]");
    add_srs_wkt (p, 4,
		 "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
		 "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
		 "122\"]],AUTHORITY[\"EPSG\",\"4142\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
		 "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PA");
    add_srs_wkt (p, 8,
		 "RAMETER[\"central_meridian\",-3],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 9,
		 "r\",0.9996],PARAMETER[\"false_easting\",500000],PARAMETE");
    add_srs_wkt (p, 10,
		 "R[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 11,
		 "G\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",");
    add_srs_wkt (p, 12, "NORTH],AUTHORITY[\"EPSG\",\"2040\"]]");
    p = add_epsg_def (filter, first, last, 2041, "epsg", 2041,
		      "Abidjan 1987 / UTM zone 30N");
    add_proj4text (p, 0,
		   "+proj=utm +zone=30 +ellps=clrk80 +towgs84=-124.76,53,466");
    add_proj4text (p, 1, ".79,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Abidjan 1987 / UTM zone 30N\",GEOGCS[\"Abidjan ");
    add_srs_wkt (p, 1,
		 "1987\",DATUM[\"Abidjan_1987\",SPHEROID[\"Clarke 1880 (RG");
    add_srs_wkt (p, 2,
		 "S)\",6378249.145,293.465,AUTHORITY[\"EPSG\",\"7012\"]],T");
    add_srs_wkt (p, 3,
		 "OWGS84[-124.76,53,466.79,0,0,0,0],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 4,
		 "143\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
		 "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
		 "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4143\"]],PROJECTION[\"");
    add_srs_wkt (p, 7,
		 "Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 8,
		 "0],PARAMETER[\"central_meridian\",-3],PARAMETER[\"scale_");
    add_srs_wkt (p, 9,
		 "factor\",0.9996],PARAMETER[\"false_easting\",500000],PAR");
    add_srs_wkt (p, 10,
		 "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 11,
		 "\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northi");
    add_srs_wkt (p, 12, "ng\",NORTH],AUTHORITY[\"EPSG\",\"2041\"]]");
    p = add_epsg_def (filter, first, last, 2042, "epsg", 2042,
		      "Locodjo 1965 / UTM zone 29N");
    add_proj4text (p, 0,
		   "+proj=utm +zone=29 +ellps=clrk80 +towgs84=-125,53,467,0,");
    add_proj4text (p, 1, "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Locodjo 1965 / UTM zone 29N\",GEOGCS[\"Locodjo ");
    add_srs_wkt (p, 1,
		 "1965\",DATUM[\"Locodjo_1965\",SPHEROID[\"Clarke 1880 (RG");
    add_srs_wkt (p, 2,
		 "S)\",6378249.145,293.465,AUTHORITY[\"EPSG\",\"7012\"]],T");
    add_srs_wkt (p, 3,
		 "OWGS84[-125,53,467,0,0,0,0],AUTHORITY[\"EPSG\",\"6142\"]");
    add_srs_wkt (p, 4,
		 "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
		 "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
		 "122\"]],AUTHORITY[\"EPSG\",\"4142\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
		 "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PA");
    add_srs_wkt (p, 8,
		 "RAMETER[\"central_meridian\",-9],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 9,
		 "r\",0.9996],PARAMETER[\"false_easting\",500000],PARAMETE");
    add_srs_wkt (p, 10,
		 "R[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 11,
		 "G\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",");
    add_srs_wkt (p, 12, "NORTH],AUTHORITY[\"EPSG\",\"2042\"]]");
    p = add_epsg_def (filter, first, last, 2043, "epsg", 2043,
		      "Abidjan 1987 / UTM zone 29N");
    add_proj4text (p, 0,
		   "+proj=utm +zone=29 +ellps=clrk80 +towgs84=-124.76,53,466");
    add_proj4text (p, 1, ".79,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Abidjan 1987 / UTM zone 29N\",GEOGCS[\"Abidjan ");
    add_srs_wkt (p, 1,
		 "1987\",DATUM[\"Abidjan_1987\",SPHEROID[\"Clarke 1880 (RG");
    add_srs_wkt (p, 2,
		 "S)\",6378249.145,293.465,AUTHORITY[\"EPSG\",\"7012\"]],T");
    add_srs_wkt (p, 3,
		 "OWGS84[-124.76,53,466.79,0,0,0,0],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 4,
		 "143\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
		 "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
		 "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4143\"]],PROJECTION[\"");
    add_srs_wkt (p, 7,
		 "Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 8,
		 "0],PARAMETER[\"central_meridian\",-9],PARAMETER[\"scale_");
    add_srs_wkt (p, 9,
		 "factor\",0.9996],PARAMETER[\"false_easting\",500000],PAR");
    add_srs_wkt (p, 10,
		 "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 11,
		 "\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northi");
    add_srs_wkt (p, 12, "ng\",NORTH],AUTHORITY[\"EPSG\",\"2043\"]]");
    p = add_epsg_def (filter, first, last, 2044, "epsg", 2044,
		      "Hanoi 1972 / Gauss-Kruger zone 18");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=18500000 +y_0=");
    add_proj4text (p, 1,
		   "0 +ellps=krass +towgs84=-17.51,-108.32,-62.39,0,0,0,0 +u");
    add_proj4text (p, 2, "nits=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Hanoi 1972 / Gauss-Kruger zone 18\",GEOGCS[\"Ha");
    add_srs_wkt (p, 1,
		 "noi 1972\",DATUM[\"Hanoi_1972\",SPHEROID[\"Krassowsky 19");
    add_srs_wkt (p, 2,
		 "40\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TOWGS84");
    add_srs_wkt (p, 3,
		 "[-17.51,-108.32,-62.39,0,0,0,0],AUTHORITY[\"EPSG\",\"614");
    add_srs_wkt (p, 4,
		 "7\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
		 "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
		 ",\"9122\"]],AUTHORITY[\"EPSG\",\"4147\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
		 "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 8,
		 "],PARAMETER[\"central_meridian\",105],PARAMETER[\"scale_");
    add_srs_wkt (p, 9,
		 "factor\",1],PARAMETER[\"false_easting\",18500000],PARAME");
    add_srs_wkt (p, 10,
		 "TER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
		 "PSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTH");
    add_srs_wkt (p, 12, "ORITY[\"EPSG\",\"2044\"]]");
    p = add_epsg_def (filter, first, last, 2045, "epsg", 2045,
		      "Hanoi 1972 / Gauss-Kruger zone 19");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=19500000 +y_0=");
    add_proj4text (p, 1,
		   "0 +ellps=krass +towgs84=-17.51,-108.32,-62.39,0,0,0,0 +u");
    add_proj4text (p, 2, "nits=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Hanoi 1972 / Gauss-Kruger zone 19\",GEOGCS[\"Ha");
    add_srs_wkt (p, 1,
		 "noi 1972\",DATUM[\"Hanoi_1972\",SPHEROID[\"Krassowsky 19");
    add_srs_wkt (p, 2,
		 "40\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TOWGS84");
    add_srs_wkt (p, 3,
		 "[-17.51,-108.32,-62.39,0,0,0,0],AUTHORITY[\"EPSG\",\"614");
    add_srs_wkt (p, 4,
		 "7\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
		 "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
		 ",\"9122\"]],AUTHORITY[\"EPSG\",\"4147\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
		 "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 8,
		 "],PARAMETER[\"central_meridian\",111],PARAMETER[\"scale_");
    add_srs_wkt (p, 9,
		 "factor\",1],PARAMETER[\"false_easting\",19500000],PARAME");
    add_srs_wkt (p, 10,
		 "TER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
		 "PSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTH");
    add_srs_wkt (p, 12, "ORITY[\"EPSG\",\"2045\"]]");
    p = add_epsg_def (filter, first, last, 2046, "epsg", 2046,
		      "Hartebeesthoek94 / Lo15");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=0 +y_0=0 +axis=");
    add_proj4text (p, 1,
		   "wsu +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 2, "s");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Hartebeesthoek94 / Lo15\",GEOGCS[\"Hartebeestho");
    add_srs_wkt (p, 1,
		 "ek94\",DATUM[\"Hartebeesthoek94\",SPHEROID[\"WGS 84\",63");
    add_srs_wkt (p, 2,
		 "78137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS8");
    add_srs_wkt (p, 3,
		 "4[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6148\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
		 "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
		 "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
		 "HORITY[\"EPSG\",\"4148\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
		 "tor_South_Orientated\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
		 ",0],PARAMETER[\"central_meridian\",15],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
		 "_factor\",1],PARAMETER[\"false_easting\",0],PARAMETER[\"");
    add_srs_wkt (p, 10,
		 "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
		 "\"9001\"]],AXIS[\"Y\",WEST],AXIS[\"X\",SOUTH],AUTHORITY[");
    add_srs_wkt (p, 12, "\"EPSG\",\"2046\"]]");
    p = add_epsg_def (filter, first, last, 2047, "epsg", 2047,
		      "Hartebeesthoek94 / Lo17");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=17 +k=1 +x_0=0 +y_0=0 +axis=");
    add_proj4text (p, 1,
		   "wsu +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 2, "s");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Hartebeesthoek94 / Lo17\",GEOGCS[\"Hartebeestho");
    add_srs_wkt (p, 1,
		 "ek94\",DATUM[\"Hartebeesthoek94\",SPHEROID[\"WGS 84\",63");
    add_srs_wkt (p, 2,
		 "78137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS8");
    add_srs_wkt (p, 3,
		 "4[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6148\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
		 "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
		 "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
		 "HORITY[\"EPSG\",\"4148\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
		 "tor_South_Orientated\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
		 ",0],PARAMETER[\"central_meridian\",17],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
		 "_factor\",1],PARAMETER[\"false_easting\",0],PARAMETER[\"");
    add_srs_wkt (p, 10,
		 "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
		 "\"9001\"]],AXIS[\"Y\",WEST],AXIS[\"X\",SOUTH],AUTHORITY[");
    add_srs_wkt (p, 12, "\"EPSG\",\"2047\"]]");
    p = add_epsg_def (filter, first, last, 2048, "epsg", 2048,
		      "Hartebeesthoek94 / Lo19");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=19 +k=1 +x_0=0 +y_0=0 +axis=");
    add_proj4text (p, 1,
		   "wsu +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 2, "s");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Hartebeesthoek94 / Lo19\",GEOGCS[\"Hartebeestho");
    add_srs_wkt (p, 1,
		 "ek94\",DATUM[\"Hartebeesthoek94\",SPHEROID[\"WGS 84\",63");
    add_srs_wkt (p, 2,
		 "78137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS8");
    add_srs_wkt (p, 3,
		 "4[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6148\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
		 "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
		 "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
		 "HORITY[\"EPSG\",\"4148\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
		 "tor_South_Orientated\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
		 ",0],PARAMETER[\"central_meridian\",19],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
		 "_factor\",1],PARAMETER[\"false_easting\",0],PARAMETER[\"");
    add_srs_wkt (p, 10,
		 "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
		 "\"9001\"]],AXIS[\"Y\",WEST],AXIS[\"X\",SOUTH],AUTHORITY[");
    add_srs_wkt (p, 12, "\"EPSG\",\"2048\"]]");
    p = add_epsg_def (filter, first, last, 2049, "epsg", 2049,
		      "Hartebeesthoek94 / Lo21");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=0 +y_0=0 +axis=");
    add_proj4text (p, 1,
		   "wsu +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 2, "s");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Hartebeesthoek94 / Lo21\",GEOGCS[\"Hartebeestho");
    add_srs_wkt (p, 1,
		 "ek94\",DATUM[\"Hartebeesthoek94\",SPHEROID[\"WGS 84\",63");
    add_srs_wkt (p, 2,
		 "78137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS8");
    add_srs_wkt (p, 3,
		 "4[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6148\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
		 "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
		 "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
		 "HORITY[\"EPSG\",\"4148\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
		 "tor_South_Orientated\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
		 ",0],PARAMETER[\"central_meridian\",21],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
		 "_factor\",1],PARAMETER[\"false_easting\",0],PARAMETER[\"");
    add_srs_wkt (p, 10,
		 "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
		 "\"9001\"]],AXIS[\"Y\",WEST],AXIS[\"X\",SOUTH],AUTHORITY[");
    add_srs_wkt (p, 12, "\"EPSG\",\"2049\"]]");
    p = add_epsg_def (filter, first, last, 2050, "epsg", 2050,
		      "Hartebeesthoek94 / Lo23");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=23 +k=1 +x_0=0 +y_0=0 +axis=");
    add_proj4text (p, 1,
		   "wsu +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 2, "s");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Hartebeesthoek94 / Lo23\",GEOGCS[\"Hartebeestho");
    add_srs_wkt (p, 1,
		 "ek94\",DATUM[\"Hartebeesthoek94\",SPHEROID[\"WGS 84\",63");
    add_srs_wkt (p, 2,
		 "78137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS8");
    add_srs_wkt (p, 3,
		 "4[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6148\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
		 "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
		 "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
		 "HORITY[\"EPSG\",\"4148\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
		 "tor_South_Orientated\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
		 ",0],PARAMETER[\"central_meridian\",23],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
		 "_factor\",1],PARAMETER[\"false_easting\",0],PARAMETER[\"");
    add_srs_wkt (p, 10,
		 "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
		 "\"9001\"]],AXIS[\"Y\",WEST],AXIS[\"X\",SOUTH],AUTHORITY[");
    add_srs_wkt (p, 12, "\"EPSG\",\"2050\"]]");
    p = add_epsg_def (filter, first, last, 2051, "epsg", 2051,
		      "Hartebeesthoek94 / Lo25");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=25 +k=1 +x_0=0 +y_0=0 +axis=");
    add_proj4text (p, 1,
		   "wsu +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 2, "s");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Hartebeesthoek94 / Lo25\",GEOGCS[\"Hartebeestho");
    add_srs_wkt (p, 1,
		 "ek94\",DATUM[\"Hartebeesthoek94\",SPHEROID[\"WGS 84\",63");
    add_srs_wkt (p, 2,
		 "78137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS8");
    add_srs_wkt (p, 3,
		 "4[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6148\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
		 "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
		 "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
		 "HORITY[\"EPSG\",\"4148\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
		 "tor_South_Orientated\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
		 ",0],PARAMETER[\"central_meridian\",25],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
		 "_factor\",1],PARAMETER[\"false_easting\",0],PARAMETER[\"");
    add_srs_wkt (p, 10,
		 "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
		 "\"9001\"]],AXIS[\"Y\",WEST],AXIS[\"X\",SOUTH],AUTHORITY[");
    add_srs_wkt (p, 12, "\"EPSG\",\"2051\"]]");
    p = add_epsg_def (filter, first, last, 2052, "epsg", 2052,
		      "Hartebeesthoek94 / Lo27");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=0 +y_0=0 +axis=");
    add_proj4text (p, 1,
		   "wsu +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 2, "s");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Hartebeesthoek94 / Lo27\",GEOGCS[\"Hartebeestho");
    add_srs_wkt (p, 1,
		 "ek94\",DATUM[\"Hartebeesthoek94\",SPHEROID[\"WGS 84\",63");
    add_srs_wkt (p, 2,
		 "78137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS8");
    add_srs_wkt (p, 3,
		 "4[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6148\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
		 "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
		 "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
		 "HORITY[\"EPSG\",\"4148\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
		 "tor_South_Orientated\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
		 ",0],PARAMETER[\"central_meridian\",27],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
		 "_factor\",1],PARAMETER[\"false_easting\",0],PARAMETER[\"");
    add_srs_wkt (p, 10,
		 "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
		 "\"9001\"]],AXIS[\"Y\",WEST],AXIS[\"X\",SOUTH],AUTHORITY[");
    add_srs_wkt (p, 12, "\"EPSG\",\"2052\"]]");
    p = add_epsg_def (filter, first, last, 2053, "epsg", 2053,
		      "Hartebeesthoek94 / Lo29");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=29 +k=1 +x_0=0 +y_0=0 +axis=");
    add_proj4text (p, 1,
		   "wsu +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 2, "s");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Hartebeesthoek94 / Lo29\",GEOGCS[\"Hartebeestho");
    add_srs_wkt (p, 1,
		 "ek94\",DATUM[\"Hartebeesthoek94\",SPHEROID[\"WGS 84\",63");
    add_srs_wkt (p, 2,
		 "78137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS8");
    add_srs_wkt (p, 3,
		 "4[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6148\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
		 "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
		 "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
		 "HORITY[\"EPSG\",\"4148\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
		 "tor_South_Orientated\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
		 ",0],PARAMETER[\"central_meridian\",29],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
		 "_factor\",1],PARAMETER[\"false_easting\",0],PARAMETER[\"");
    add_srs_wkt (p, 10,
		 "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
		 "\"9001\"]],AXIS[\"Y\",WEST],AXIS[\"X\",SOUTH],AUTHORITY[");
    add_srs_wkt (p, 12, "\"EPSG\",\"2053\"]]");
    p = add_epsg_def (filter, first, last, 2054, "epsg", 2054,
		      "Hartebeesthoek94 / Lo31");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=31 +k=1 +x_0=0 +y_0=0 +axis=");
    add_proj4text (p, 1,
		   "wsu +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 2, "s");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Hartebeesthoek94 / Lo31\",GEOGCS[\"Hartebeestho");
    add_srs_wkt (p, 1,
		 "ek94\",DATUM[\"Hartebeesthoek94\",SPHEROID[\"WGS 84\",63");
    add_srs_wkt (p, 2,
		 "78137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS8");
    add_srs_wkt (p, 3,
		 "4[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6148\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
		 "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
		 "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
		 "HORITY[\"EPSG\",\"4148\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
		 "tor_South_Orientated\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
		 ",0],PARAMETER[\"central_meridian\",31],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
		 "_factor\",1],PARAMETER[\"false_easting\",0],PARAMETER[\"");
    add_srs_wkt (p, 10,
		 "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
		 "\"9001\"]],AXIS[\"Y\",WEST],AXIS[\"X\",SOUTH],AUTHORITY[");
    add_srs_wkt (p, 12, "\"EPSG\",\"2054\"]]");
    p = add_epsg_def (filter, first, last, 2055, "epsg", 2055,
		      "Hartebeesthoek94 / Lo33");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=0 +y_0=0 +axis=");
    add_proj4text (p, 1,
		   "wsu +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 2, "s");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Hartebeesthoek94 / Lo33\",GEOGCS[\"Hartebeestho");
    add_srs_wkt (p, 1,
		 "ek94\",DATUM[\"Hartebeesthoek94\",SPHEROID[\"WGS 84\",63");
    add_srs_wkt (p, 2,
		 "78137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS8");
    add_srs_wkt (p, 3,
		 "4[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6148\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
		 "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
		 "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
		 "HORITY[\"EPSG\",\"4148\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
		 "tor_South_Orientated\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
		 ",0],PARAMETER[\"central_meridian\",33],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
		 "_factor\",1],PARAMETER[\"false_easting\",0],PARAMETER[\"");
    add_srs_wkt (p, 10,
		 "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
		 "\"9001\"]],AXIS[\"Y\",WEST],AXIS[\"X\",SOUTH],AUTHORITY[");
    add_srs_wkt (p, 12, "\"EPSG\",\"2055\"]]");
    p = add_epsg_def (filter, first, last, 2056, "epsg", 2056,
		      "CH1903+ / LV95");
    add_proj4text (p, 0,
		   "+proj=somerc +lat_0=46.95240555555556 +lon_0=7.439583333");
    add_proj4text (p, 1,
		   "333333 +k_0=1 +x_0=2600000 +y_0=1200000 +ellps=bessel +t");
    add_proj4text (p, 2,
		   "owgs84=674.374,15.056,405.346,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"CH1903+ / LV95\",GEOGCS[\"CH1903+\",DATUM[\"CH1");
    add_srs_wkt (p, 1,
		 "903+\",SPHEROID[\"Bessel 1841\",6377397.155,299.1528128,");
    add_srs_wkt (p, 2,
		 "AUTHORITY[\"EPSG\",\"7004\"]],TOWGS84[674.374,15.056,405");
    add_srs_wkt (p, 3,
		 ".346,0,0,0,0],AUTHORITY[\"EPSG\",\"6150\"]],PRIMEM[\"Gre");
    add_srs_wkt (p, 4,
		 "enwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
		 ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
		 "ITY[\"EPSG\",\"4150\"]],PROJECTION[\"Hotine_Oblique_Merc");
    add_srs_wkt (p, 7,
		 "ator\"],PARAMETER[\"latitude_of_center\",46.952405555555");
    add_srs_wkt (p, 8,
		 "56],PARAMETER[\"longitude_of_center\",7.439583333333333]");
    add_srs_wkt (p, 9,
		 ",PARAMETER[\"azimuth\",90],PARAMETER[\"rectified_grid_an");
    add_srs_wkt (p, 10,
		 "gle\",90],PARAMETER[\"scale_factor\",1],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
		 "e_easting\",2600000],PARAMETER[\"false_northing\",120000");
    add_srs_wkt (p, 12,
		 "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 13,
		 "Y\",EAST],AXIS[\"X\",NORTH],AUTHORITY[\"EPSG\",\"2056\"]");
    add_srs_wkt (p, 14, "]");
    p = add_epsg_def (filter, first, last, 2057, "epsg", 2057,
		      "Rassadiran / Nakhl e Taqi");
    add_proj4text (p, 0,
		   "+proj=omerc +lat_0=27.51882880555555 +lonc=52.6035391666");
    add_proj4text (p, 1,
		   "6667 +alpha=0.5716611944444444 +k=0.999895934 +x_0=65837");
    add_proj4text (p, 2,
		   "7.437 +y_0=3044969.194 +gamma=0.5716611944444444 +ellps=");
    add_proj4text (p, 3,
		   "intl +towgs84=-133.63,-157.5,-158.62,0,0,0,0 +units=m +n");
    add_proj4text (p, 4, "o_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Rassadiran / Nakhl e Taqi\",GEOGCS[\"Rassadiran");
    add_srs_wkt (p, 1,
		 "\",DATUM[\"Rassadiran\",SPHEROID[\"International 1924\",");
    add_srs_wkt (p, 2,
		 "6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-133.6");
    add_srs_wkt (p, 3,
		 "3,-157.5,-158.62,0,0,0,0],AUTHORITY[\"EPSG\",\"6153\"]],");
    add_srs_wkt (p, 4,
		 "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
		 "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
		 "2\"]],AUTHORITY[\"EPSG\",\"4153\"]],PROJECTION[\"Hotine_");
    add_srs_wkt (p, 7,
		 "Oblique_Mercator\"],PARAMETER[\"latitude_of_center\",27.");
    add_srs_wkt (p, 8,
		 "51882880555555],PARAMETER[\"longitude_of_center\",52.603");
    add_srs_wkt (p, 9,
		 "53916666667],PARAMETER[\"azimuth\",0.5716611944444444],P");
    add_srs_wkt (p, 10,
		 "ARAMETER[\"rectified_grid_angle\",0.5716611944444444],PA");
    add_srs_wkt (p, 11,
		 "RAMETER[\"scale_factor\",0.999895934],PARAMETER[\"false_");
    add_srs_wkt (p, 12,
		 "easting\",658377.437],PARAMETER[\"false_northing\",30449");
    add_srs_wkt (p, 13,
		 "69.194],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 14,
		 "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 15, "[\"EPSG\",\"2057\"]]");
    p = add_epsg_def (filter, first, last, 2058, "epsg", 2058,
		      "ED50(ED77) / UTM zone 38N");
    add_proj4text (p, 0,
		   "+proj=utm +zone=38 +ellps=intl +towgs84=-117,-132,-164,0");
    add_proj4text (p, 1, ",0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"ED50(ED77) / UTM zone 38N\",GEOGCS[\"ED50(ED77)");
    add_srs_wkt (p, 1,
		 "\",DATUM[\"European_Datum_1950_1977\",SPHEROID[\"Interna");
    add_srs_wkt (p, 2,
		 "tional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],");
    add_srs_wkt (p, 3,
		 "TOWGS84[-117,-132,-164,0,0,0,0],AUTHORITY[\"EPSG\",\"615");
    add_srs_wkt (p, 4,
		 "4\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
		 "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
		 ",\"9122\"]],AUTHORITY[\"EPSG\",\"4154\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
		 "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 8,
		 "],PARAMETER[\"central_meridian\",45],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
		 "actor\",0.9996],PARAMETER[\"false_easting\",500000],PARA");
    add_srs_wkt (p, 10,
		 "METER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
		 "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 12, "\",NORTH],AUTHORITY[\"EPSG\",\"2058\"]]");
    p = add_epsg_def (filter, first, last, 2059, "epsg", 2059,
		      "ED50(ED77) / UTM zone 39N");
    add_proj4text (p, 0,
		   "+proj=utm +zone=39 +ellps=intl +towgs84=-117,-132,-164,0");
    add_proj4text (p, 1, ",0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"ED50(ED77) / UTM zone 39N\",GEOGCS[\"ED50(ED77)");
    add_srs_wkt (p, 1,
		 "\",DATUM[\"European_Datum_1950_1977\",SPHEROID[\"Interna");
    add_srs_wkt (p, 2,
		 "tional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],");
    add_srs_wkt (p, 3,
		 "TOWGS84[-117,-132,-164,0,0,0,0],AUTHORITY[\"EPSG\",\"615");
    add_srs_wkt (p, 4,
		 "4\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
		 "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
		 ",\"9122\"]],AUTHORITY[\"EPSG\",\"4154\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
		 "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 8,
		 "],PARAMETER[\"central_meridian\",51],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
		 "actor\",0.9996],PARAMETER[\"false_easting\",500000],PARA");
    add_srs_wkt (p, 10,
		 "METER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
		 "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 12, "\",NORTH],AUTHORITY[\"EPSG\",\"2059\"]]");
    p = add_epsg_def (filter, first, last, 2060, "epsg", 2060,
		      "ED50(ED77) / UTM zone 40N");
    add_proj4text (p, 0,
		   "+proj=utm +zone=40 +ellps=intl +towgs84=-117,-132,-164,0");
    add_proj4text (p, 1, ",0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"ED50(ED77) / UTM zone 40N\",GEOGCS[\"ED50(ED77)");
    add_srs_wkt (p, 1,
		 "\",DATUM[\"European_Datum_1950_1977\",SPHEROID[\"Interna");
    add_srs_wkt (p, 2,
		 "tional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],");
    add_srs_wkt (p, 3,
		 "TOWGS84[-117,-132,-164,0,0,0,0],AUTHORITY[\"EPSG\",\"615");
    add_srs_wkt (p, 4,
		 "4\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
		 "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
		 ",\"9122\"]],AUTHORITY[\"EPSG\",\"4154\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
		 "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 8,
		 "],PARAMETER[\"central_meridian\",57],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
		 "actor\",0.9996],PARAMETER[\"false_easting\",500000],PARA");
    add_srs_wkt (p, 10,
		 "METER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
		 "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 12, "\",NORTH],AUTHORITY[\"EPSG\",\"2060\"]]");
    p = add_epsg_def (filter, first, last, 2061, "epsg", 2061,
		      "ED50(ED77) / UTM zone 41N");
    add_proj4text (p, 0,
		   "+proj=utm +zone=41 +ellps=intl +towgs84=-117,-132,-164,0");
    add_proj4text (p, 1, ",0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"ED50(ED77) / UTM zone 41N\",GEOGCS[\"ED50(ED77)");
    add_srs_wkt (p, 1,
		 "\",DATUM[\"European_Datum_1950_1977\",SPHEROID[\"Interna");
    add_srs_wkt (p, 2,
		 "tional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],");
    add_srs_wkt (p, 3,
		 "TOWGS84[-117,-132,-164,0,0,0,0],AUTHORITY[\"EPSG\",\"615");
    add_srs_wkt (p, 4,
		 "4\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
		 "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
		 ",\"9122\"]],AUTHORITY[\"EPSG\",\"4154\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
		 "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 8,
		 "],PARAMETER[\"central_meridian\",63],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
		 "actor\",0.9996],PARAMETER[\"false_easting\",500000],PARA");
    add_srs_wkt (p, 10,
		 "METER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
		 "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 12, "\",NORTH],AUTHORITY[\"EPSG\",\"2061\"]]");
    p = add_epsg_def (filter, first, last, 2062, "epsg", 2062,
		      "Madrid 1870 (Madrid) / Spain");
    add_proj4text (p, 0,
		   "+proj=lcc +lat_1=40 +lat_0=40 +lon_0=0 +k_0=0.9988085293");
    add_proj4text (p, 1,
		   " +x_0=600000 +y_0=600000 +a=6378298.3 +b=6356657.1426695");
    add_proj4text (p, 2, "62 +pm=madrid +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Madrid 1870 (Madrid) / Spain\",GEOGCS[\"Madrid ");
    add_srs_wkt (p, 1,
		 "1870 (Madrid)\",DATUM[\"Madrid_1870_Madrid\",SPHEROID[\"");
    add_srs_wkt (p, 2,
		 "Struve 1860\",6378298.3,294.73,AUTHORITY[\"EPSG\",\"7028");
    add_srs_wkt (p, 3,
		 "\"]],AUTHORITY[\"EPSG\",\"6903\"]],PRIMEM[\"Madrid\",-3.");
    add_srs_wkt (p, 4,
		 "687938888888889,AUTHORITY[\"EPSG\",\"8905\"]],UNIT[\"deg");
    add_srs_wkt (p, 5,
		 "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 6,
		 "UTHORITY[\"EPSG\",\"4903\"]],PROJECTION[\"Lambert_Confor");
    add_srs_wkt (p, 7,
		 "mal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",40],PA");
    add_srs_wkt (p, 8,
		 "RAMETER[\"central_meridian\",0],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 9,
		 "\",0.9988085293],PARAMETER[\"false_easting\",600000],PAR");
    add_srs_wkt (p, 10,
		 "AMETER[\"false_northing\",600000],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 11,
		 "RITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NOR");
    add_srs_wkt (p, 12, "TH],AUTHORITY[\"EPSG\",\"2062\"]]");
    p = add_epsg_def (filter, first, last, 2063, "epsg", 2063,
		      "Dabola 1981 / UTM zone 28N (deprecated)");
    add_proj4text (p, 0,
		   "+proj=utm +zone=28 +a=6378249.2 +b=6356515 +towgs84=-23,");
    add_proj4text (p, 1, "259,-9,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Dabola 1981 / UTM zone 28N (deprecated)\",GEOGC");
    add_srs_wkt (p, 1,
		 "S[\"Conakry 1905\",DATUM[\"Conakry_1905\",SPHEROID[\"Cla");
    add_srs_wkt (p, 2,
		 "rke 1880 (IGN)\",6378249.2,293.4660212936269,AUTHORITY[\"");
    add_srs_wkt (p, 3,
		 "EPSG\",\"7011\"]],TOWGS84[-23,259,-9,0,0,0,0],AUTHORITY[");
    add_srs_wkt (p, 4,
		 "\"EPSG\",\"6315\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
		 "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
		 "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4315\"]],");
    add_srs_wkt (p, 7,
		 "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
		 "_of_origin\",0],PARAMETER[\"central_meridian\",-15],PARA");
    add_srs_wkt (p, 9,
		 "METER[\"scale_factor\",0.9996],PARAMETER[\"false_easting");
    add_srs_wkt (p, 10,
		 "\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
		 ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 12,
		 "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2063\"]]");
    p = add_epsg_def (filter, first, last, 2064, "epsg", 2064,
		      "Dabola 1981 / UTM zone 29N (deprecated)");
    add_proj4text (p, 0,
		   "+proj=utm +zone=29 +a=6378249.2 +b=6356515 +towgs84=-23,");
    add_proj4text (p, 1, "259,-9,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Dabola 1981 / UTM zone 29N (deprecated)\",GEOGC");
    add_srs_wkt (p, 1,
		 "S[\"Conakry 1905\",DATUM[\"Conakry_1905\",SPHEROID[\"Cla");
    add_srs_wkt (p, 2,
		 "rke 1880 (IGN)\",6378249.2,293.4660212936269,AUTHORITY[\"");
    add_srs_wkt (p, 3,
		 "EPSG\",\"7011\"]],TOWGS84[-23,259,-9,0,0,0,0],AUTHORITY[");
    add_srs_wkt (p, 4,
		 "\"EPSG\",\"6315\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
		 "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
		 "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4315\"]],");
    add_srs_wkt (p, 7,
		 "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
		 "_of_origin\",0],PARAMETER[\"central_meridian\",-9],PARAM");
    add_srs_wkt (p, 9,
		 "ETER[\"scale_factor\",0.9996],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
		 ",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 11,
		 "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 12,
		 "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2064\"]]");
    p = add_epsg_def (filter, first, last, 2065, "epsg", 2065,
		      "S-JTSK (Ferro) / Krovak");
    add_proj4text (p, 0,
		   "+proj=krovak +lat_0=49.5 +lon_0=42.5 +alpha=30.288139722");
    add_proj4text (p, 1,
		   "22222 +k=0.9999 +x_0=0 +y_0=0 +ellps=bessel +towgs84=589");
    add_proj4text (p, 2, ",76,480,0,0,0,0 +pm=ferro +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"S-JTSK (Ferro) / Krovak\",GEOGCS[\"S-JTSK (Ferr");
    add_srs_wkt (p, 1,
		 "o)\",DATUM[\"System_Jednotne_Trigonometricke_Site_Katast");
    add_srs_wkt (p, 2,
		 "ralni_Ferro\",SPHEROID[\"Bessel 1841\",6377397.155,299.1");
    add_srs_wkt (p, 3,
		 "528128,AUTHORITY[\"EPSG\",\"7004\"]],TOWGS84[589,76,480,");
    add_srs_wkt (p, 4,
		 "0,0,0,0],AUTHORITY[\"EPSG\",\"6818\"]],PRIMEM[\"Ferro\",");
    add_srs_wkt (p, 5,
		 "-17.66666666666667,AUTHORITY[\"EPSG\",\"8909\"]],UNIT[\"");
    add_srs_wkt (p, 6,
		 "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 7,
		 "],AUTHORITY[\"EPSG\",\"4818\"]],PROJECTION[\"Krovak\"],P");
    add_srs_wkt (p, 8,
		 "ARAMETER[\"latitude_of_center\",49.5],PARAMETER[\"longit");
    add_srs_wkt (p, 9,
		 "ude_of_center\",42.5],PARAMETER[\"azimuth\",30.288139722");
    add_srs_wkt (p, 10,
		 "22222],PARAMETER[\"pseudo_standard_parallel_1\",78.5],PA");
    add_srs_wkt (p, 11,
		 "RAMETER[\"scale_factor\",0.9999],PARAMETER[\"false_easti");
    add_srs_wkt (p, 12,
		 "ng\",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1");
    add_srs_wkt (p, 13,
		 ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",SOUTH],AXIS[\"");
    add_srs_wkt (p, 14, "Y\",WEST],AUTHORITY[\"EPSG\",\"2065\"]]");
    p = add_epsg_def (filter, first, last, 2066, "epsg", 2066,
		      "Mount Dillon / Tobago Grid");
    add_proj4text (p, 0,
		   "+proj=cass +lat_0=11.25217861111111 +lon_0=-60.686008888");
    add_proj4text (p, 1,
		   "88889 +x_0=37718.66159325 +y_0=36209.91512952 +a=6378293");
    add_proj4text (p, 2,
		   ".645208759 +b=6356617.987679838 +to_meter=0.201166195164");
    add_proj4text (p, 3, " +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Mount Dillon / Tobago Grid\",GEOGCS[\"Mount Dil");
    add_srs_wkt (p, 1,
		 "lon\",DATUM[\"Mount_Dillon\",SPHEROID[\"Clarke 1858\",63");
    add_srs_wkt (p, 2,
		 "78293.645208759,294.2606763692654,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "007\"]],AUTHORITY[\"EPSG\",\"6157\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
		 "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
		 "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
		 "EPSG\",\"4157\"]],PROJECTION[\"Cassini_Soldner\"],PARAME");
    add_srs_wkt (p, 7,
		 "TER[\"latitude_of_origin\",11.25217861111111],PARAMETER[");
    add_srs_wkt (p, 8,
		 "\"central_meridian\",-60.68600888888889],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
		 "se_easting\",187500],PARAMETER[\"false_northing\",180000");
    add_srs_wkt (p, 10,
		 "],UNIT[\"Clarke's link\",0.201166195164,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 11,
		 "\",\"9039\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",N");
    add_srs_wkt (p, 12, "ORTH],AUTHORITY[\"EPSG\",\"2066\"]]");
    p = add_epsg_def (filter, first, last, 2067, "epsg", 2067,
		      "Naparima 1955 / UTM zone 20N");
    add_proj4text (p, 0,
		   "+proj=utm +zone=20 +ellps=intl +towgs84=-0.465,372.095,1");
    add_proj4text (p, 1, "71.736,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Naparima 1955 / UTM zone 20N\",GEOGCS[\"Naparim");
    add_srs_wkt (p, 1,
		 "a 1955\",DATUM[\"Naparima_1955\",SPHEROID[\"Internationa");
    add_srs_wkt (p, 2,
		 "l 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS");
    add_srs_wkt (p, 3,
		 "84[-0.465,372.095,171.736,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
		 "6158\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
		 "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
		 "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4158\"]],PROJECTION[");
    add_srs_wkt (p, 7,
		 "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
		 ",0],PARAMETER[\"central_meridian\",-63],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
		 "e_factor\",0.9996],PARAMETER[\"false_easting\",500000],P");
    add_srs_wkt (p, 10,
		 "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
		 "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 12, "hing\",NORTH],AUTHORITY[\"EPSG\",\"2067\"]]");
    p = add_epsg_def (filter, first, last, 2068, "epsg", 2068,
		      "ELD79 / Libya zone 5");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=9 +k=0.9999 +x_0=200000 +y_0");
    add_proj4text (p, 1,
		   "=0 +ellps=intl +towgs84=-115.854,-99.0583,-152.462,0,0,0");
    add_proj4text (p, 2, ",0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"ELD79 / Libya zone 5\",GEOGCS[\"ELD79\",DATUM[\"");
    add_srs_wkt (p, 1,
		 "European_Libyan_Datum_1979\",SPHEROID[\"International 19");
    add_srs_wkt (p, 2,
		 "24\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-");
    add_srs_wkt (p, 3,
		 "115.854,-99.0583,-152.462,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
		 "6159\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
		 "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
		 "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4159\"]],PROJECTION[");
    add_srs_wkt (p, 7,
		 "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
		 ",0],PARAMETER[\"central_meridian\",9],PARAMETER[\"scale_");
    add_srs_wkt (p, 9,
		 "factor\",0.9999],PARAMETER[\"false_easting\",200000],PAR");
    add_srs_wkt (p, 10,
		 "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 11,
		 "\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],A");
    add_srs_wkt (p, 12, "UTHORITY[\"EPSG\",\"2068\"]]");
    p = add_epsg_def (filter, first, last, 2069, "epsg", 2069,
		      "ELD79 / Libya zone 6");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=11 +k=0.9999 +x_0=200000 +y_");
    add_proj4text (p, 1,
		   "0=0 +ellps=intl +towgs84=-115.854,-99.0583,-152.462,0,0,");
    add_proj4text (p, 2, "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"ELD79 / Libya zone 6\",GEOGCS[\"ELD79\",DATUM[\"");
    add_srs_wkt (p, 1,
		 "European_Libyan_Datum_1979\",SPHEROID[\"International 19");
    add_srs_wkt (p, 2,
		 "24\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-");
    add_srs_wkt (p, 3,
		 "115.854,-99.0583,-152.462,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
		 "6159\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
		 "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
		 "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4159\"]],PROJECTION[");
    add_srs_wkt (p, 7,
		 "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
		 ",0],PARAMETER[\"central_meridian\",11],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
		 "_factor\",0.9999],PARAMETER[\"false_easting\",200000],PA");
    add_srs_wkt (p, 10,
		 "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
		 "[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],");
    add_srs_wkt (p, 12, "AUTHORITY[\"EPSG\",\"2069\"]]");
    p = add_epsg_def (filter, first, last, 2070, "epsg", 2070,
		      "ELD79 / Libya zone 7");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=13 +k=0.9999 +x_0=200000 +y_");
    add_proj4text (p, 1,
		   "0=0 +ellps=intl +towgs84=-115.854,-99.0583,-152.462,0,0,");
    add_proj4text (p, 2, "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"ELD79 / Libya zone 7\",GEOGCS[\"ELD79\",DATUM[\"");
    add_srs_wkt (p, 1,
		 "European_Libyan_Datum_1979\",SPHEROID[\"International 19");
    add_srs_wkt (p, 2,
		 "24\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-");
    add_srs_wkt (p, 3,
		 "115.854,-99.0583,-152.462,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
		 "6159\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
		 "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
		 "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4159\"]],PROJECTION[");
    add_srs_wkt (p, 7,
		 "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
		 ",0],PARAMETER[\"central_meridian\",13],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
		 "_factor\",0.9999],PARAMETER[\"false_easting\",200000],PA");
    add_srs_wkt (p, 10,
		 "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
		 "[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],");
    add_srs_wkt (p, 12, "AUTHORITY[\"EPSG\",\"2070\"]]");
    p = add_epsg_def (filter, first, last, 2071, "epsg", 2071,
		      "ELD79 / Libya zone 8");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=15 +k=0.9999 +x_0=200000 +y_");
    add_proj4text (p, 1,
		   "0=0 +ellps=intl +towgs84=-115.854,-99.0583,-152.462,0,0,");
    add_proj4text (p, 2, "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"ELD79 / Libya zone 8\",GEOGCS[\"ELD79\",DATUM[\"");
    add_srs_wkt (p, 1,
		 "European_Libyan_Datum_1979\",SPHEROID[\"International 19");
    add_srs_wkt (p, 2,
		 "24\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-");
    add_srs_wkt (p, 3,
		 "115.854,-99.0583,-152.462,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
		 "6159\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
		 "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
		 "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4159\"]],PROJECTION[");
    add_srs_wkt (p, 7,
		 "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
		 ",0],PARAMETER[\"central_meridian\",15],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
		 "_factor\",0.9999],PARAMETER[\"false_easting\",200000],PA");
    add_srs_wkt (p, 10,
		 "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
		 "[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],");
    add_srs_wkt (p, 12, "AUTHORITY[\"EPSG\",\"2071\"]]");
    p = add_epsg_def (filter, first, last, 2072, "epsg", 2072,
		      "ELD79 / Libya zone 9");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=17 +k=0.9999 +x_0=200000 +y_");
    add_proj4text (p, 1,
		   "0=0 +ellps=intl +towgs84=-115.854,-99.0583,-152.462,0,0,");
    add_proj4text (p, 2, "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"ELD79 / Libya zone 9\",GEOGCS[\"ELD79\",DATUM[\"");
    add_srs_wkt (p, 1,
		 "European_Libyan_Datum_1979\",SPHEROID[\"International 19");
    add_srs_wkt (p, 2,
		 "24\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-");
    add_srs_wkt (p, 3,
		 "115.854,-99.0583,-152.462,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
		 "6159\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
		 "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
		 "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4159\"]],PROJECTION[");
    add_srs_wkt (p, 7,
		 "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
		 ",0],PARAMETER[\"central_meridian\",17],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
		 "_factor\",0.9999],PARAMETER[\"false_easting\",200000],PA");
    add_srs_wkt (p, 10,
		 "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
		 "[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],");
    add_srs_wkt (p, 12, "AUTHORITY[\"EPSG\",\"2072\"]]");
    p = add_epsg_def (filter, first, last, 2073, "epsg", 2073,
		      "ELD79 / Libya zone 10");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=19 +k=0.9999 +x_0=200000 +y_");
    add_proj4text (p, 1,
		   "0=0 +ellps=intl +towgs84=-115.854,-99.0583,-152.462,0,0,");
    add_proj4text (p, 2, "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"ELD79 / Libya zone 10\",GEOGCS[\"ELD79\",DATUM[");
    add_srs_wkt (p, 1,
		 "\"European_Libyan_Datum_1979\",SPHEROID[\"International ");
    add_srs_wkt (p, 2,
		 "1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84");
    add_srs_wkt (p, 3,
		 "[-115.854,-99.0583,-152.462,0,0,0,0],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
		 "\"6159\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
		 "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
		 "PSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4159\"]],PROJECTIO");
    add_srs_wkt (p, 7,
		 "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
		 "n\",0],PARAMETER[\"central_meridian\",19],PARAMETER[\"sc");
    add_srs_wkt (p, 9,
		 "ale_factor\",0.9999],PARAMETER[\"false_easting\",200000]");
    add_srs_wkt (p, 10,
		 ",PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 11,
		 "ITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORT");
    add_srs_wkt (p, 12, "H],AUTHORITY[\"EPSG\",\"2073\"]]");
    p = add_epsg_def (filter, first, last, 2074, "epsg", 2074,
		      "ELD79 / Libya zone 11");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=21 +k=0.9999 +x_0=200000 +y_");
    add_proj4text (p, 1,
		   "0=0 +ellps=intl +towgs84=-115.854,-99.0583,-152.462,0,0,");
    add_proj4text (p, 2, "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"ELD79 / Libya zone 11\",GEOGCS[\"ELD79\",DATUM[");
    add_srs_wkt (p, 1,
		 "\"European_Libyan_Datum_1979\",SPHEROID[\"International ");
    add_srs_wkt (p, 2,
		 "1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84");
    add_srs_wkt (p, 3,
		 "[-115.854,-99.0583,-152.462,0,0,0,0],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
		 "\"6159\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
		 "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
		 "PSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4159\"]],PROJECTIO");
    add_srs_wkt (p, 7,
		 "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
		 "n\",0],PARAMETER[\"central_meridian\",21],PARAMETER[\"sc");
    add_srs_wkt (p, 9,
		 "ale_factor\",0.9999],PARAMETER[\"false_easting\",200000]");
    add_srs_wkt (p, 10,
		 ",PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 11,
		 "ITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORT");
    add_srs_wkt (p, 12, "H],AUTHORITY[\"EPSG\",\"2074\"]]");
    p = add_epsg_def (filter, first, last, 2075, "epsg", 2075,
		      "ELD79 / Libya zone 12");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=23 +k=0.9999 +x_0=200000 +y_");
    add_proj4text (p, 1,
		   "0=0 +ellps=intl +towgs84=-115.854,-99.0583,-152.462,0,0,");
    add_proj4text (p, 2, "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"ELD79 / Libya zone 12\",GEOGCS[\"ELD79\",DATUM[");
    add_srs_wkt (p, 1,
		 "\"European_Libyan_Datum_1979\",SPHEROID[\"International ");
    add_srs_wkt (p, 2,
		 "1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84");
    add_srs_wkt (p, 3,
		 "[-115.854,-99.0583,-152.462,0,0,0,0],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
		 "\"6159\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
		 "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
		 "PSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4159\"]],PROJECTIO");
    add_srs_wkt (p, 7,
		 "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
		 "n\",0],PARAMETER[\"central_meridian\",23],PARAMETER[\"sc");
    add_srs_wkt (p, 9,
		 "ale_factor\",0.9999],PARAMETER[\"false_easting\",200000]");
    add_srs_wkt (p, 10,
		 ",PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 11,
		 "ITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORT");
    add_srs_wkt (p, 12, "H],AUTHORITY[\"EPSG\",\"2075\"]]");
    p = add_epsg_def (filter, first, last, 2076, "epsg", 2076,
		      "ELD79 / Libya zone 13");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=25 +k=0.9999 +x_0=200000 +y_");
    add_proj4text (p, 1,
		   "0=0 +ellps=intl +towgs84=-115.854,-99.0583,-152.462,0,0,");
    add_proj4text (p, 2, "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"ELD79 / Libya zone 13\",GEOGCS[\"ELD79\",DATUM[");
    add_srs_wkt (p, 1,
		 "\"European_Libyan_Datum_1979\",SPHEROID[\"International ");
    add_srs_wkt (p, 2,
		 "1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84");
    add_srs_wkt (p, 3,
		 "[-115.854,-99.0583,-152.462,0,0,0,0],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
		 "\"6159\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
		 "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
		 "PSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4159\"]],PROJECTIO");
    add_srs_wkt (p, 7,
		 "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
		 "n\",0],PARAMETER[\"central_meridian\",25],PARAMETER[\"sc");
    add_srs_wkt (p, 9,
		 "ale_factor\",0.9999],PARAMETER[\"false_easting\",200000]");
    add_srs_wkt (p, 10,
		 ",PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 11,
		 "ITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORT");
    add_srs_wkt (p, 12, "H],AUTHORITY[\"EPSG\",\"2076\"]]");
    p = add_epsg_def (filter, first, last, 2077, "epsg", 2077,
		      "ELD79 / UTM zone 32N");
    add_proj4text (p, 0,
		   "+proj=utm +zone=32 +ellps=intl +towgs84=-115.854,-99.058");
    add_proj4text (p, 1, "3,-152.462,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"ELD79 / UTM zone 32N\",GEOGCS[\"ELD79\",DATUM[\"");
    add_srs_wkt (p, 1,
		 "European_Libyan_Datum_1979\",SPHEROID[\"International 19");
    add_srs_wkt (p, 2,
		 "24\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-");
    add_srs_wkt (p, 3,
		 "115.854,-99.0583,-152.462,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
		 "6159\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
		 "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
		 "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4159\"]],PROJECTION[");
    add_srs_wkt (p, 7,
		 "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
		 ",0],PARAMETER[\"central_meridian\",9],PARAMETER[\"scale_");
    add_srs_wkt (p, 9,
		 "factor\",0.9996],PARAMETER[\"false_easting\",500000],PAR");
    add_srs_wkt (p, 10,
		 "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 11,
		 "\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northi");
    add_srs_wkt (p, 12, "ng\",NORTH],AUTHORITY[\"EPSG\",\"2077\"]]");
    p = add_epsg_def (filter, first, last, 2078, "epsg", 2078,
		      "ELD79 / UTM zone 33N");
    add_proj4text (p, 0,
		   "+proj=utm +zone=33 +ellps=intl +towgs84=-115.854,-99.058");
    add_proj4text (p, 1, "3,-152.462,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"ELD79 / UTM zone 33N\",GEOGCS[\"ELD79\",DATUM[\"");
    add_srs_wkt (p, 1,
		 "European_Libyan_Datum_1979\",SPHEROID[\"International 19");
    add_srs_wkt (p, 2,
		 "24\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-");
    add_srs_wkt (p, 3,
		 "115.854,-99.0583,-152.462,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
		 "6159\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
		 "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
		 "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4159\"]],PROJECTION[");
    add_srs_wkt (p, 7,
		 "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
		 ",0],PARAMETER[\"central_meridian\",15],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
		 "_factor\",0.9996],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 10,
		 "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
		 "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 12, "ing\",NORTH],AUTHORITY[\"EPSG\",\"2078\"]]");
    p = add_epsg_def (filter, first, last, 2079, "epsg", 2079,
		      "ELD79 / UTM zone 34N");
    add_proj4text (p, 0,
		   "+proj=utm +zone=34 +ellps=intl +towgs84=-115.854,-99.058");
    add_proj4text (p, 1, "3,-152.462,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"ELD79 / UTM zone 34N\",GEOGCS[\"ELD79\",DATUM[\"");
    add_srs_wkt (p, 1,
		 "European_Libyan_Datum_1979\",SPHEROID[\"International 19");
    add_srs_wkt (p, 2,
		 "24\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-");
    add_srs_wkt (p, 3,
		 "115.854,-99.0583,-152.462,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
		 "6159\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
		 "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
		 "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4159\"]],PROJECTION[");
    add_srs_wkt (p, 7,
		 "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
		 ",0],PARAMETER[\"central_meridian\",21],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
		 "_factor\",0.9996],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 10,
		 "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
		 "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 12, "ing\",NORTH],AUTHORITY[\"EPSG\",\"2079\"]]");
    p = add_epsg_def (filter, first, last, 2080, "epsg", 2080,
		      "ELD79 / UTM zone 35N");
    add_proj4text (p, 0,
		   "+proj=utm +zone=35 +ellps=intl +towgs84=-115.854,-99.058");
    add_proj4text (p, 1, "3,-152.462,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"ELD79 / UTM zone 35N\",GEOGCS[\"ELD79\",DATUM[\"");
    add_srs_wkt (p, 1,
		 "European_Libyan_Datum_1979\",SPHEROID[\"International 19");
    add_srs_wkt (p, 2,
		 "24\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-");
    add_srs_wkt (p, 3,
		 "115.854,-99.0583,-152.462,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
		 "6159\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
		 "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
		 "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4159\"]],PROJECTION[");
    add_srs_wkt (p, 7,
		 "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
		 ",0],PARAMETER[\"central_meridian\",27],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
		 "_factor\",0.9996],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 10,
		 "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
		 "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 12, "ing\",NORTH],AUTHORITY[\"EPSG\",\"2080\"]]");
    p = add_epsg_def (filter, first, last, 2081, "epsg", 2081,
		      "Chos Malal 1914 / Argentina 2");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=-90 +lon_0=-69 +k=1 +x_0=2500000 +y_0");
    add_proj4text (p, 1, "=0 +ellps=intl +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Chos Malal 1914 / Argentina 2\",GEOGCS[\"Chos M");
    add_srs_wkt (p, 1,
		 "alal 1914\",DATUM[\"Chos_Malal_1914\",SPHEROID[\"Interna");
    add_srs_wkt (p, 2,
		 "tional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],");
    add_srs_wkt (p, 3,
		 "AUTHORITY[\"EPSG\",\"6160\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
		 "4160\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
		 "latitude_of_origin\",-90],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
		 ",-69],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_ea");
    add_srs_wkt (p, 9,
		 "sting\",2500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
		 "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH");
    add_srs_wkt (p, 11, "],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2081\"]]");
    p = add_epsg_def (filter, first, last, 2082, "epsg", 2082,
		      "Pampa del Castillo / Argentina 2");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=-90 +lon_0=-69 +k=1 +x_0=2500000 +y_0");
    add_proj4text (p, 1,
		   "=0 +ellps=intl +towgs84=27.5,14,186.4,0,0,0,0 +units=m +");
    add_proj4text (p, 2, "no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pampa del Castillo / Argentina 2\",GEOGCS[\"Pam");
    add_srs_wkt (p, 1,
		 "pa del Castillo\",DATUM[\"Pampa_del_Castillo\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
		 "7022\"]],TOWGS84[27.5,14,186.4,0,0,0,0],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
		 "\",\"6161\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
		 "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 6,
		 "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4161\"]],PROJEC");
    add_srs_wkt (p, 7,
		 "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 8,
		 "igin\",-90],PARAMETER[\"central_meridian\",-69],PARAMETE");
    add_srs_wkt (p, 9,
		 "R[\"scale_factor\",1],PARAMETER[\"false_easting\",250000");
    add_srs_wkt (p, 10,
		 "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
		 "ORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",E");
    add_srs_wkt (p, 12, "AST],AUTHORITY[\"EPSG\",\"2082\"]]");
    p = add_epsg_def (filter, first, last, 2083, "epsg", 2083,
		      "Hito XVIII 1963 / Argentina 2");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=-90 +lon_0=-69 +k=1 +x_0=2500000 +y_0");
    add_proj4text (p, 1,
		   "=0 +ellps=intl +towgs84=16,196,93,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 2, "efs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Hito XVIII 1963 / Argentina 2\",GEOGCS[\"Hito X");
    add_srs_wkt (p, 1,
		 "VIII 1963\",DATUM[\"Hito_XVIII_1963\",SPHEROID[\"Interna");
    add_srs_wkt (p, 2,
		 "tional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],");
    add_srs_wkt (p, 3,
		 "TOWGS84[16,196,93,0,0,0,0],AUTHORITY[\"EPSG\",\"6254\"]]");
    add_srs_wkt (p, 4,
		 ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
		 "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
		 "22\"]],AUTHORITY[\"EPSG\",\"4254\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 7,
		 "erse_Mercator\"],PARAMETER[\"latitude_of_origin\",-90],P");
    add_srs_wkt (p, 8,
		 "ARAMETER[\"central_meridian\",-69],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
		 "tor\",1],PARAMETER[\"false_easting\",2500000],PARAMETER[");
    add_srs_wkt (p, 10,
		 "\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 11,
		 ",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY");
    add_srs_wkt (p, 12, "[\"EPSG\",\"2083\"]]");
    p = add_epsg_def (filter, first, last, 2084, "epsg", 2084,
		      "Hito XVIII 1963 / UTM zone 19S");
    add_proj4text (p, 0,
		   "+proj=utm +zone=19 +south +ellps=intl +towgs84=16,196,93");
    add_proj4text (p, 1, ",0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Hito XVIII 1963 / UTM zone 19S\",GEOGCS[\"Hito ");
    add_srs_wkt (p, 1,
		 "XVIII 1963\",DATUM[\"Hito_XVIII_1963\",SPHEROID[\"Intern");
    add_srs_wkt (p, 2,
		 "ational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]]");
    add_srs_wkt (p, 3,
		 ",TOWGS84[16,196,93,0,0,0,0],AUTHORITY[\"EPSG\",\"6254\"]");
    add_srs_wkt (p, 4,
		 "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
		 "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
		 "122\"]],AUTHORITY[\"EPSG\",\"4254\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
		 "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PA");
    add_srs_wkt (p, 8,
		 "RAMETER[\"central_meridian\",-69],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
		 "or\",0.9996],PARAMETER[\"false_easting\",500000],PARAMET");
    add_srs_wkt (p, 10,
		 "ER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
		 "TY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nor");
    add_srs_wkt (p, 12, "thing\",NORTH],AUTHORITY[\"EPSG\",\"2084\"]]");
    p = add_epsg_def (filter, first, last, 2085, "epsg", 2085,
		      "NAD27 / Cuba Norte (deprecated)");
    add_proj4text (p, 0,
		   "+proj=lcc +lat_1=22.35 +lat_0=22.35 +lon_0=-81 +k_0=0.99");
    add_proj4text (p, 1,
		   "993602 +x_0=500000 +y_0=280296.016 +datum=NAD27 +units=m");
    add_proj4text (p, 2, " +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD27 / Cuba Norte (deprecated)\",GEOGCS[\"NAD2");
    add_srs_wkt (p, 1,
		 "7\",DATUM[\"North_American_Datum_1927\",SPHEROID[\"Clark");
    add_srs_wkt (p, 2,
		 "e 1866\",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
		 "\"7008\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 4,
		 "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 5,
		 "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY");
    add_srs_wkt (p, 6,
		 "[\"EPSG\",\"4267\"]],PROJECTION[\"Lambert_Conformal_Coni");
    add_srs_wkt (p, 7,
		 "c_1SP\"],PARAMETER[\"latitude_of_origin\",22.35],PARAMET");
    add_srs_wkt (p, 8,
		 "ER[\"central_meridian\",-81],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 9,
		 "0.99993602],PARAMETER[\"false_easting\",500000],PARAMETE");
    add_srs_wkt (p, 10,
		 "R[\"false_northing\",280296.016],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 11,
		 "ITY[\"EPSG\",\"9001\"]],AXIS[\"Y\",NORTH],AXIS[\"X\",EAS");
    add_srs_wkt (p, 12, "T],AUTHORITY[\"EPSG\",\"2085\"]]");
    p = add_epsg_def (filter, first, last, 2086, "epsg", 2086,
		      "NAD27 / Cuba Sur (deprecated)");
    add_proj4text (p, 0,
		   "+proj=lcc +lat_1=20.71666666666667 +lat_0=20.71666666666");
    add_proj4text (p, 1,
		   "667 +lon_0=-76.83333333333333 +k_0=0.99994848 +x_0=50000");
    add_proj4text (p, 2, "0 +y_0=229126.939 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD27 / Cuba Sur (deprecated)\",GEOGCS[\"NAD27\"");
    add_srs_wkt (p, 1,
		 ",DATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1");
    add_srs_wkt (p, 2,
		 "866\",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "008\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
		 "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
		 "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
		 "EPSG\",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_1");
    add_srs_wkt (p, 7,
		 "SP\"],PARAMETER[\"latitude_of_origin\",20.71666666666667");
    add_srs_wkt (p, 8,
		 "],PARAMETER[\"central_meridian\",-76.83333333333333],PAR");
    add_srs_wkt (p, 9,
		 "AMETER[\"scale_factor\",0.99994848],PARAMETER[\"false_ea");
    add_srs_wkt (p, 10,
		 "sting\",500000],PARAMETER[\"false_northing\",229126.939]");
    add_srs_wkt (p, 11,
		 ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Y");
    add_srs_wkt (p, 12,
		 "\",NORTH],AXIS[\"X\",EAST],AUTHORITY[\"EPSG\",\"2086\"]]");
    p = add_epsg_def (filter, first, last, 2087, "epsg", 2087,
		      "ELD79 / TM 12 NE");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=12 +k=0.9996 +x_0=500000 +y_");
    add_proj4text (p, 1,
		   "0=0 +ellps=intl +towgs84=-115.854,-99.0583,-152.462,0,0,");
    add_proj4text (p, 2, "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"ELD79 / TM 12 NE\",GEOGCS[\"ELD79\",DATUM[\"Eur");
    add_srs_wkt (p, 1,
		 "opean_Libyan_Datum_1979\",SPHEROID[\"International 1924\"");
    add_srs_wkt (p, 2,
		 ",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-115.");
    add_srs_wkt (p, 3,
		 "854,-99.0583,-152.462,0,0,0,0],AUTHORITY[\"EPSG\",\"6159");
    add_srs_wkt (p, 4,
		 "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
		 "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
		 "\"9122\"]],AUTHORITY[\"EPSG\",\"4159\"]],PROJECTION[\"Tr");
    add_srs_wkt (p, 7,
		 "ansverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0]");
    add_srs_wkt (p, 8,
		 ",PARAMETER[\"central_meridian\",12],PARAMETER[\"scale_fa");
    add_srs_wkt (p, 9,
		 "ctor\",0.9996],PARAMETER[\"false_easting\",500000],PARAM");
    add_srs_wkt (p, 10,
		 "ETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
		 "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 12, "\",NORTH],AUTHORITY[\"EPSG\",\"2087\"]]");
    p = add_epsg_def (filter, first, last, 2088, "epsg", 2088,
		      "Carthage / TM 11 NE");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=11 +k=0.9996 +x_0=500000 +y_");
    add_proj4text (p, 1,
		   "0=0 +a=6378249.2 +b=6356515 +towgs84=-263,6,431,0,0,0,0 ");
    add_proj4text (p, 2, "+units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Carthage / TM 11 NE\",GEOGCS[\"Carthage\",DATUM");
    add_srs_wkt (p, 1,
		 "[\"Carthage\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,2");
    add_srs_wkt (p, 2,
		 "93.4660212936269,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84[-");
    add_srs_wkt (p, 3,
		 "263,6,431,0,0,0,0],AUTHORITY[\"EPSG\",\"6223\"]],PRIMEM[");
    add_srs_wkt (p, 4,
		 "\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"deg");
    add_srs_wkt (p, 5,
		 "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 6,
		 "UTHORITY[\"EPSG\",\"4223\"]],PROJECTION[\"Transverse_Mer");
    add_srs_wkt (p, 7,
		 "cator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "central_meridian\",11],PARAMETER[\"scale_factor\",0.9996");
    add_srs_wkt (p, 9,
		 "],PARAMETER[\"false_easting\",500000],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
		 "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 11,
		 "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 12, "HORITY[\"EPSG\",\"2088\"]]");
    p = add_epsg_def (filter, first, last, 2089, "epsg", 2089,
		      "Yemen NGN96 / UTM zone 38N");
    add_proj4text (p, 0,
		   "+proj=utm +zone=38 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1, "units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Yemen NGN96 / UTM zone 38N\",GEOGCS[\"Yemen NGN");
    add_srs_wkt (p, 1,
		 "96\",DATUM[\"Yemen_National_Geodetic_Network_1996\",SPHE");
    add_srs_wkt (p, 2,
		 "ROID[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
		 ",\"7030\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
		 "6163\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
		 "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
		 "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4163\"]],PROJECTION[");
    add_srs_wkt (p, 7,
		 "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
		 ",0],PARAMETER[\"central_meridian\",45],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
		 "_factor\",0.9996],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 10,
		 "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
		 "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 12, "ing\",NORTH],AUTHORITY[\"EPSG\",\"2089\"]]");
    p = add_epsg_def (filter, first, last, 2090, "epsg", 2090,
		      "Yemen NGN96 / UTM zone 39N");
    add_proj4text (p, 0,
		   "+proj=utm +zone=39 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1, "units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Yemen NGN96 / UTM zone 39N\",GEOGCS[\"Yemen NGN");
    add_srs_wkt (p, 1,
		 "96\",DATUM[\"Yemen_National_Geodetic_Network_1996\",SPHE");
    add_srs_wkt (p, 2,
		 "ROID[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
		 ",\"7030\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
		 "6163\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
		 "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
		 "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4163\"]],PROJECTION[");
    add_srs_wkt (p, 7,
		 "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
		 ",0],PARAMETER[\"central_meridian\",51],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
		 "_factor\",0.9996],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 10,
		 "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
		 "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 12, "ing\",NORTH],AUTHORITY[\"EPSG\",\"2090\"]]");
    p = add_epsg_def (filter, first, last, 2091, "epsg", 2091,
		      "South Yemen / Gauss Kruger zone 8 (deprecated)");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=8500000 +y_0=0 ");
    add_proj4text (p, 1,
		   "+ellps=krass +towgs84=-76,-138,67,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 2, "efs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"South Yemen / Gauss Kruger zone 8 (deprecated)\"");
    add_srs_wkt (p, 1,
		 ",GEOGCS[\"South Yemen\",DATUM[\"South_Yemen\",SPHEROID[\"");
    add_srs_wkt (p, 2,
		 "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
		 "4\"]],TOWGS84[-76,-138,67,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
		 "6164\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
		 "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
		 "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4164\"]],PROJECTION[");
    add_srs_wkt (p, 7,
		 "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
		 ",0],PARAMETER[\"central_meridian\",45],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
		 "_factor\",1],PARAMETER[\"false_easting\",8500000],PARAME");
    add_srs_wkt (p, 10,
		 "TER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
		 "PSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTH");
    add_srs_wkt (p, 12, "ORITY[\"EPSG\",\"2091\"]]");
    p = add_epsg_def (filter, first, last, 2092, "epsg", 2092,
		      "South Yemen / Gauss Kruger zone 9 (deprecated)");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=51 +k=1 +x_0=9500000 +y_0=0 ");
    add_proj4text (p, 1,
		   "+ellps=krass +towgs84=-76,-138,67,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 2, "efs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"South Yemen / Gauss Kruger zone 9 (deprecated)\"");
    add_srs_wkt (p, 1,
		 ",GEOGCS[\"South Yemen\",DATUM[\"South_Yemen\",SPHEROID[\"");
    add_srs_wkt (p, 2,
		 "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
		 "4\"]],TOWGS84[-76,-138,67,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
		 "6164\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
		 "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
		 "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4164\"]],PROJECTION[");
    add_srs_wkt (p, 7,
		 "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
		 ",0],PARAMETER[\"central_meridian\",51],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
		 "_factor\",1],PARAMETER[\"false_easting\",9500000],PARAME");
    add_srs_wkt (p, 10,
		 "TER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
		 "PSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTH");
    add_srs_wkt (p, 12, "ORITY[\"EPSG\",\"2092\"]]");
    p = add_epsg_def (filter, first, last, 2093, "epsg", 2093,
		      "Hanoi 1972 / GK 106 NE");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=106 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
		   "+ellps=krass +towgs84=-17.51,-108.32,-62.39,0,0,0,0 +uni");
    add_proj4text (p, 2, "ts=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Hanoi 1972 / GK 106 NE\",GEOGCS[\"Hanoi 1972\",");
    add_srs_wkt (p, 1,
		 "DATUM[\"Hanoi_1972\",SPHEROID[\"Krassowsky 1940\",637824");
    add_srs_wkt (p, 2,
		 "5,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TOWGS84[-17.51,-10");
    add_srs_wkt (p, 3,
		 "8.32,-62.39,0,0,0,0],AUTHORITY[\"EPSG\",\"6147\"]],PRIME");
    add_srs_wkt (p, 4,
		 "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
		 "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
		 ",AUTHORITY[\"EPSG\",\"4147\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 7,
		 "ercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER");
    add_srs_wkt (p, 8,
		 "[\"central_meridian\",106],PARAMETER[\"scale_factor\",1]");
    add_srs_wkt (p, 9,
		 ",PARAMETER[\"false_easting\",500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 10,
		 "orthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 11,
		 "]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12, ",\"2093\"]]");
    p = add_epsg_def (filter, first, last, 2094, "epsg", 2094,
		      "WGS 72BE / TM 106 NE");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=106 +k=0.9996 +x_0=500000 +y");
    add_proj4text (p, 1,
		   "_0=0 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +unit");
    add_proj4text (p, 2, "s=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"WGS 72BE / TM 106 NE\",GEOGCS[\"WGS 72BE\",DATU");
    add_srs_wkt (p, 1,
		 "M[\"WGS_1972_Transit_Broadcast_Ephemeris\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
		 "S 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],TOWG");
    add_srs_wkt (p, 3,
		 "S84[0,0,1.9,0,0,0.814,-0.38],AUTHORITY[\"EPSG\",\"6324\"");
    add_srs_wkt (p, 4,
		 "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
		 "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
		 "9122\"]],AUTHORITY[\"EPSG\",\"4324\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
		 "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
		 "ARAMETER[\"central_meridian\",106],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
		 "tor\",0.9996],PARAMETER[\"false_easting\",500000],PARAME");
    add_srs_wkt (p, 10,
		 "TER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
		 "PSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12, ",NORTH],AUTHORITY[\"EPSG\",\"2094\"]]");
    p = add_epsg_def (filter, first, last, 2095, "epsg", 2095,
		      "Bissau / UTM zone 28N");
    add_proj4text (p, 0,
		   "+proj=utm +zone=28 +ellps=intl +towgs84=-173,253,27,0,0,");
    add_proj4text (p, 1, "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Bissau / UTM zone 28N\",GEOGCS[\"Bissau\",DATUM");
    add_srs_wkt (p, 1,
		 "[\"Bissau\",SPHEROID[\"International 1924\",6378388,297,");
    add_srs_wkt (p, 2,
		 "AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-173,253,27,0,0,0,");
    add_srs_wkt (p, 3,
		 "0],AUTHORITY[\"EPSG\",\"6165\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
		 "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
		 ",\"4165\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
		 "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
		 "\",-15],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"f");
    add_srs_wkt (p, 9,
		 "alse_easting\",500000],PARAMETER[\"false_northing\",0],U");
    add_srs_wkt (p, 10,
		 "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eas");
    add_srs_wkt (p, 11,
		 "ting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12, ",\"2095\"]]");
    p = add_epsg_def (filter, first, last, 2096, "epsg", 2096,
		      "Korean 1985 / East Belt");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=38 +lon_0=129 +k=1 +x_0=200000 +y_0=5");
    add_proj4text (p, 1, "00000 +ellps=bessel +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Korean 1985 / East Belt\",GEOGCS[\"Korean 1985\"");
    add_srs_wkt (p, 1,
		 ",DATUM[\"Korean_Datum_1985\",SPHEROID[\"Bessel 1841\",63");
    add_srs_wkt (p, 2,
		 "77397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],AUTH");
    add_srs_wkt (p, 3,
		 "ORITY[\"EPSG\",\"6162\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
		 "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
		 "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"416");
    add_srs_wkt (p, 6,
		 "2\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 7,
		 "titude_of_origin\",38],PARAMETER[\"central_meridian\",12");
    add_srs_wkt (p, 8,
		 "9],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
		 "ng\",200000],PARAMETER[\"false_northing\",500000],UNIT[\"");
    add_srs_wkt (p, 10,
		 "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH");
    add_srs_wkt (p, 11, "],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2096\"]]");
    p = add_epsg_def (filter, first, last, 2097, "epsg", 2097,
		      "Korean 1985 / Central Belt");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=38 +lon_0=127 +k=1 +x_0=200000 +y_0=5");
    add_proj4text (p, 1, "00000 +ellps=bessel +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Korean 1985 / Central Belt\",GEOGCS[\"Korean 19");
    add_srs_wkt (p, 1,
		 "85\",DATUM[\"Korean_Datum_1985\",SPHEROID[\"Bessel 1841\"");
    add_srs_wkt (p, 2,
		 ",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],A");
    add_srs_wkt (p, 3,
		 "UTHORITY[\"EPSG\",\"6162\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
		 "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
		 "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
		 "4162\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
		 "latitude_of_origin\",38],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 8,
		 "127],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eas");
    add_srs_wkt (p, 9,
		 "ting\",200000],PARAMETER[\"false_northing\",500000],UNIT");
    add_srs_wkt (p, 10,
		 "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NO");
    add_srs_wkt (p, 11, "RTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2097\"]]");
    p = add_epsg_def (filter, first, last, 2098, "epsg", 2098,
		      "Korean 1985 / West Belt");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=38 +lon_0=125 +k=1 +x_0=200000 +y_0=5");
    add_proj4text (p, 1, "00000 +ellps=bessel +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Korean 1985 / West Belt\",GEOGCS[\"Korean 1985\"");
    add_srs_wkt (p, 1,
		 ",DATUM[\"Korean_Datum_1985\",SPHEROID[\"Bessel 1841\",63");
    add_srs_wkt (p, 2,
		 "77397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],AUTH");
    add_srs_wkt (p, 3,
		 "ORITY[\"EPSG\",\"6162\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
		 "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
		 "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"416");
    add_srs_wkt (p, 6,
		 "2\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 7,
		 "titude_of_origin\",38],PARAMETER[\"central_meridian\",12");
    add_srs_wkt (p, 8,
		 "5],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
		 "ng\",200000],PARAMETER[\"false_northing\",500000],UNIT[\"");
    add_srs_wkt (p, 10,
		 "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH");
    add_srs_wkt (p, 11, "],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2098\"]]");
    p = add_epsg_def (filter, first, last, 2099, "epsg", 2099,
		      "Qatar 1948 / Qatar Grid");
    add_proj4text (p, 0,
		   "+proj=cass +lat_0=25.38236111111111 +lon_0=50.7613888888");
    add_proj4text (p, 1,
		   "8889 +x_0=100000 +y_0=100000 +ellps=helmert +units=m +no");
    add_proj4text (p, 2, "_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Qatar 1948 / Qatar Grid\",GEOGCS[\"Qatar 1948\"");
    add_srs_wkt (p, 1,
		 ",DATUM[\"Qatar_1948\",SPHEROID[\"Helmert 1906\",6378200,");
    add_srs_wkt (p, 2,
		 "298.3,AUTHORITY[\"EPSG\",\"7020\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
		 "6286\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 4,
		 "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
		 "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4286\"]],PROJECTION[");
    add_srs_wkt (p, 6,
		 "\"Cassini_Soldner\"],PARAMETER[\"latitude_of_origin\",25");
    add_srs_wkt (p, 7,
		 ".38236111111111],PARAMETER[\"central_meridian\",50.76138");
    add_srs_wkt (p, 8,
		 "888888889],PARAMETER[\"false_easting\",100000],PARAMETER");
    add_srs_wkt (p, 9,
		 "[\"false_northing\",100000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 10,
		 "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 11, "\",NORTH],AUTHORITY[\"EPSG\",\"2099\"]]");
    p = add_epsg_def (filter, first, last, 2100, "epsg", 2100,
		      "GGRS87 / Greek Grid");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=24 +k=0.9996 +x_0=500000 +y_");
    add_proj4text (p, 1,
		   "0=0 +ellps=GRS80 +towgs84=-199.87,74.79,246.62,0,0,0,0 +");
    add_proj4text (p, 2, "units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"GGRS87 / Greek Grid\",GEOGCS[\"GGRS87\",DATUM[\"");
    add_srs_wkt (p, 1,
		 "Greek_Geodetic_Reference_System_1987\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 2,
		 "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 3,
		 ",TOWGS84[-199.87,74.79,246.62,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
		 ",\"6121\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
		 "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
		 "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4121\"]],PROJECTI");
    add_srs_wkt (p, 7,
		 "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
		 "in\",0],PARAMETER[\"central_meridian\",24],PARAMETER[\"s");
    add_srs_wkt (p, 9,
		 "cale_factor\",0.9996],PARAMETER[\"false_easting\",500000");
    add_srs_wkt (p, 10,
		 "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 11,
		 "RITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"N");
    add_srs_wkt (p, 12, "orthing\",NORTH],AUTHORITY[\"EPSG\",\"2100\"]]");
}

static void
initialize_epsg_01 (int filter, struct epsg_defs **first,
		    struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def (filter, first, last, 2101, "epsg", 2101,
		      "Lake / Maracaibo Grid M1");
    add_proj4text (p, 0,
		   "+proj=lcc +lat_1=10.16666666666667 +lat_0=10.16666666666");
    add_proj4text (p, 1,
		   "667 +lon_0=-71.60561777777777 +k_0=1 +x_0=0 +y_0=-52684.");
    add_proj4text (p, 2, "972 +ellps=intl +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Lake / Maracaibo Grid M1\",GEOGCS[\"Lake\",DATU");
    add_srs_wkt (p, 1,
		 "M[\"Lake\",SPHEROID[\"International 1924\",6378388,297,A");
    add_srs_wkt (p, 2,
		 "UTHORITY[\"EPSG\",\"7022\"]],AUTHORITY[\"EPSG\",\"6249\"");
    add_srs_wkt (p, 3,
		 "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 4,
		 "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
		 "9122\"]],AUTHORITY[\"EPSG\",\"4249\"]],PROJECTION[\"Lamb");
    add_srs_wkt (p, 6,
		 "ert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 7,
		 "n\",10.16666666666667],PARAMETER[\"central_meridian\",-7");
    add_srs_wkt (p, 8,
		 "1.60561777777777],PARAMETER[\"scale_factor\",1],PARAMETE");
    add_srs_wkt (p, 9,
		 "R[\"false_easting\",0],PARAMETER[\"false_northing\",-526");
    add_srs_wkt (p, 10,
		 "84.972],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
		 "XIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"2");
    add_srs_wkt (p, 12, "101\"]]");
    p = add_epsg_def (filter, first, last, 2102, "epsg", 2102,
		      "Lake / Maracaibo Grid");
    add_proj4text (p, 0,
		   "+proj=lcc +lat_1=10.16666666666667 +lat_0=10.16666666666");
    add_proj4text (p, 1,
		   "667 +lon_0=-71.60561777777777 +k_0=1 +x_0=200000 +y_0=14");
    add_proj4text (p, 2, "7315.028 +ellps=intl +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Lake / Maracaibo Grid\",GEOGCS[\"Lake\",DATUM[\"");
    add_srs_wkt (p, 1,
		 "Lake\",SPHEROID[\"International 1924\",6378388,297,AUTHO");
    add_srs_wkt (p, 2,
		 "RITY[\"EPSG\",\"7022\"]],AUTHORITY[\"EPSG\",\"6249\"]],P");
    add_srs_wkt (p, 3,
		 "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 4,
		 "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 5,
		 "\"]],AUTHORITY[\"EPSG\",\"4249\"]],PROJECTION[\"Lambert_");
    add_srs_wkt (p, 6,
		 "Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 7,
		 "10.16666666666667],PARAMETER[\"central_meridian\",-71.60");
    add_srs_wkt (p, 8,
		 "561777777777],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 9,
		 "false_easting\",200000],PARAMETER[\"false_northing\",147");
    add_srs_wkt (p, 10,
		 "315.028],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
		 "AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12, "2102\"]]");
    p = add_epsg_def (filter, first, last, 2103, "epsg", 2103,
		      "Lake / Maracaibo Grid M3");
    add_proj4text (p, 0,
		   "+proj=lcc +lat_1=10.16666666666667 +lat_0=10.16666666666");
    add_proj4text (p, 1,
		   "667 +lon_0=-71.60561777777777 +k_0=1 +x_0=500000 +y_0=44");
    add_proj4text (p, 2, "7315.028 +ellps=intl +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Lake / Maracaibo Grid M3\",GEOGCS[\"Lake\",DATU");
    add_srs_wkt (p, 1,
		 "M[\"Lake\",SPHEROID[\"International 1924\",6378388,297,A");
    add_srs_wkt (p, 2,
		 "UTHORITY[\"EPSG\",\"7022\"]],AUTHORITY[\"EPSG\",\"6249\"");
    add_srs_wkt (p, 3,
		 "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 4,
		 "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
		 "9122\"]],AUTHORITY[\"EPSG\",\"4249\"]],PROJECTION[\"Lamb");
    add_srs_wkt (p, 6,
		 "ert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 7,
		 "n\",10.16666666666667],PARAMETER[\"central_meridian\",-7");
    add_srs_wkt (p, 8,
		 "1.60561777777777],PARAMETER[\"scale_factor\",1],PARAMETE");
    add_srs_wkt (p, 9,
		 "R[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
		 ",447315.028],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 11,
		 "]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12, ",\"2103\"]]");
    p = add_epsg_def (filter, first, last, 2104, "epsg", 2104,
		      "Lake / Maracaibo La Rosa Grid");
    add_proj4text (p, 0,
		   "+proj=lcc +lat_1=10.16666666666667 +lat_0=10.16666666666");
    add_proj4text (p, 1,
		   "667 +lon_0=-71.60561777777777 +k_0=1 +x_0=-17044 +y_0=-2");
    add_proj4text (p, 2, "3139.97 +ellps=intl +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Lake / Maracaibo La Rosa Grid\",GEOGCS[\"Lake\"");
    add_srs_wkt (p, 1,
		 ",DATUM[\"Lake\",SPHEROID[\"International 1924\",6378388,");
    add_srs_wkt (p, 2,
		 "297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
		 "249\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
		 "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
		 "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4249\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
		 "Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
		 "rigin\",10.16666666666667],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
		 ",-71.60561777777777],PARAMETER[\"scale_factor\",1],PARAM");
    add_srs_wkt (p, 9,
		 "ETER[\"false_easting\",-17044],PARAMETER[\"false_northin");
    add_srs_wkt (p, 10,
		 "g\",-23139.97],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 11,
		 "1\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12, "G\",\"2104\"]]");
    p = add_epsg_def (filter, first, last, 2105, "epsg", 2105,
		      "NZGD2000 / Mount Eden 2000");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=-36.87972222222222 +lon_0=174.7641666");
    add_proj4text (p, 1,
		   "666667 +k=0.9999 +x_0=400000 +y_0=800000 +ellps=GRS80 +t");
    add_proj4text (p, 2, "owgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NZGD2000 / Mount Eden 2000\",GEOGCS[\"NZGD2000\"");
    add_srs_wkt (p, 1,
		 ",DATUM[\"New_Zealand_Geodetic_Datum_2000\",SPHEROID[\"GR");
    add_srs_wkt (p, 2,
		 "S 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019");
    add_srs_wkt (p, 3,
		 "\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6167\"]");
    add_srs_wkt (p, 4,
		 "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
		 "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
		 "122\"]],AUTHORITY[\"EPSG\",\"4167\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
		 "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",-36.8");
    add_srs_wkt (p, 8,
		 "7972222222222],PARAMETER[\"central_meridian\",174.764166");
    add_srs_wkt (p, 9,
		 "6666667],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"");
    add_srs_wkt (p, 10,
		 "false_easting\",400000],PARAMETER[\"false_northing\",800");
    add_srs_wkt (p, 11,
		 "000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS");
    add_srs_wkt (p, 12,
		 "[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"");
    add_srs_wkt (p, 13, "EPSG\",\"2105\"]]");
    p = add_epsg_def (filter, first, last, 2106, "epsg", 2106,
		      "NZGD2000 / Bay of Plenty 2000");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=-37.76111111111111 +lon_0=176.4661111");
    add_proj4text (p, 1,
		   "111111 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs8");
    add_proj4text (p, 2, "4=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NZGD2000 / Bay of Plenty 2000\",GEOGCS[\"NZGD20");
    add_srs_wkt (p, 1,
		 "00\",DATUM[\"New_Zealand_Geodetic_Datum_2000\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
		 "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"616");
    add_srs_wkt (p, 4,
		 "7\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
		 "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
		 ",\"9122\"]],AUTHORITY[\"EPSG\",\"4167\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
		 "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",-");
    add_srs_wkt (p, 8,
		 "37.76111111111111],PARAMETER[\"central_meridian\",176.46");
    add_srs_wkt (p, 9,
		 "61111111111],PARAMETER[\"scale_factor\",1],PARAMETER[\"f");
    add_srs_wkt (p, 10,
		 "alse_easting\",400000],PARAMETER[\"false_northing\",8000");
    add_srs_wkt (p, 11,
		 "00],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 12,
		 "\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 13, "PSG\",\"2106\"]]");
    p = add_epsg_def (filter, first, last, 2107, "epsg", 2107,
		      "NZGD2000 / Poverty Bay 2000");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=-38.62444444444444 +lon_0=177.8855555");
    add_proj4text (p, 1,
		   "555556 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs8");
    add_proj4text (p, 2, "4=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NZGD2000 / Poverty Bay 2000\",GEOGCS[\"NZGD2000");
    add_srs_wkt (p, 1,
		 "\",DATUM[\"New_Zealand_Geodetic_Datum_2000\",SPHEROID[\"");
    add_srs_wkt (p, 2,
		 "GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
		 "19\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6167\"");
    add_srs_wkt (p, 4,
		 "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
		 "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
		 "9122\"]],AUTHORITY[\"EPSG\",\"4167\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
		 "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",-38.");
    add_srs_wkt (p, 8,
		 "62444444444444],PARAMETER[\"central_meridian\",177.88555");
    add_srs_wkt (p, 9,
		 "55555556],PARAMETER[\"scale_factor\",1],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
		 "e_easting\",400000],PARAMETER[\"false_northing\",800000]");
    add_srs_wkt (p, 11,
		 ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"N");
    add_srs_wkt (p, 12,
		 "orthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13, "\",\"2107\"]]");
    p = add_epsg_def (filter, first, last, 2108, "epsg", 2108,
		      "NZGD2000 / Hawkes Bay 2000");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=-39.65083333333333 +lon_0=176.6736111");
    add_proj4text (p, 1,
		   "111111 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs8");
    add_proj4text (p, 2, "4=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NZGD2000 / Hawkes Bay 2000\",GEOGCS[\"NZGD2000\"");
    add_srs_wkt (p, 1,
		 ",DATUM[\"New_Zealand_Geodetic_Datum_2000\",SPHEROID[\"GR");
    add_srs_wkt (p, 2,
		 "S 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019");
    add_srs_wkt (p, 3,
		 "\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6167\"]");
    add_srs_wkt (p, 4,
		 "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
		 "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
		 "122\"]],AUTHORITY[\"EPSG\",\"4167\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
		 "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",-39.6");
    add_srs_wkt (p, 8,
		 "5083333333333],PARAMETER[\"central_meridian\",176.673611");
    add_srs_wkt (p, 9,
		 "1111111],PARAMETER[\"scale_factor\",1],PARAMETER[\"false");
    add_srs_wkt (p, 10,
		 "_easting\",400000],PARAMETER[\"false_northing\",800000],");
    add_srs_wkt (p, 11,
		 "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"No");
    add_srs_wkt (p, 12,
		 "rthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13, ",\"2108\"]]");
    p = add_epsg_def (filter, first, last, 2109, "epsg", 2109,
		      "NZGD2000 / Taranaki 2000");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=-39.13555555555556 +lon_0=174.2277777");
    add_proj4text (p, 1,
		   "777778 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs8");
    add_proj4text (p, 2, "4=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NZGD2000 / Taranaki 2000\",GEOGCS[\"NZGD2000\",");
    add_srs_wkt (p, 1,
		 "DATUM[\"New_Zealand_Geodetic_Datum_2000\",SPHEROID[\"GRS");
    add_srs_wkt (p, 2,
		 " 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
		 "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6167\"]],");
    add_srs_wkt (p, 4,
		 "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
		 "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
		 "2\"]],AUTHORITY[\"EPSG\",\"4167\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
		 "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",-39.135");
    add_srs_wkt (p, 8,
		 "55555555556],PARAMETER[\"central_meridian\",174.22777777");
    add_srs_wkt (p, 9,
		 "77778],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_e");
    add_srs_wkt (p, 10,
		 "asting\",400000],PARAMETER[\"false_northing\",800000],UN");
    add_srs_wkt (p, 11,
		 "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Nort");
    add_srs_wkt (p, 12,
		 "hing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13, "\"2109\"]]");
    p = add_epsg_def (filter, first, last, 2110, "epsg", 2110,
		      "NZGD2000 / Tuhirangi 2000");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=-39.51222222222222 +lon_0=175.64 +k=1");
    add_proj4text (p, 1,
		   " +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0");
    add_proj4text (p, 2, ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NZGD2000 / Tuhirangi 2000\",GEOGCS[\"NZGD2000\"");
    add_srs_wkt (p, 1,
		 ",DATUM[\"New_Zealand_Geodetic_Datum_2000\",SPHEROID[\"GR");
    add_srs_wkt (p, 2,
		 "S 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019");
    add_srs_wkt (p, 3,
		 "\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6167\"]");
    add_srs_wkt (p, 4,
		 "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
		 "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
		 "122\"]],AUTHORITY[\"EPSG\",\"4167\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
		 "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",-39.5");
    add_srs_wkt (p, 8,
		 "1222222222222],PARAMETER[\"central_meridian\",175.64],PA");
    add_srs_wkt (p, 9,
		 "RAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 10,
		 "400000],PARAMETER[\"false_northing\",800000],UNIT[\"metr");
    add_srs_wkt (p, 11,
		 "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NO");
    add_srs_wkt (p, 12,
		 "RTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2110\"]");
    add_srs_wkt (p, 13, "]");
    p = add_epsg_def (filter, first, last, 2111, "epsg", 2111,
		      "NZGD2000 / Wanganui 2000");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=-40.24194444444444 +lon_0=175.4880555");
    add_proj4text (p, 1,
		   "555555 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs8");
    add_proj4text (p, 2, "4=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NZGD2000 / Wanganui 2000\",GEOGCS[\"NZGD2000\",");
    add_srs_wkt (p, 1,
		 "DATUM[\"New_Zealand_Geodetic_Datum_2000\",SPHEROID[\"GRS");
    add_srs_wkt (p, 2,
		 " 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
		 "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6167\"]],");
    add_srs_wkt (p, 4,
		 "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
		 "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
		 "2\"]],AUTHORITY[\"EPSG\",\"4167\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
		 "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",-40.241");
    add_srs_wkt (p, 8,
		 "94444444444],PARAMETER[\"central_meridian\",175.48805555");
    add_srs_wkt (p, 9,
		 "55555],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_e");
    add_srs_wkt (p, 10,
		 "asting\",400000],PARAMETER[\"false_northing\",800000],UN");
    add_srs_wkt (p, 11,
		 "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Nort");
    add_srs_wkt (p, 12,
		 "hing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13, "\"2111\"]]");
    p = add_epsg_def (filter, first, last, 2112, "epsg", 2112,
		      "NZGD2000 / Wairarapa 2000");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=-40.92527777777777 +lon_0=175.6472222");
    add_proj4text (p, 1,
		   "222222 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs8");
    add_proj4text (p, 2, "4=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NZGD2000 / Wairarapa 2000\",GEOGCS[\"NZGD2000\"");
    add_srs_wkt (p, 1,
		 ",DATUM[\"New_Zealand_Geodetic_Datum_2000\",SPHEROID[\"GR");
    add_srs_wkt (p, 2,
		 "S 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019");
    add_srs_wkt (p, 3,
		 "\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6167\"]");
    add_srs_wkt (p, 4,
		 "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
		 "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
		 "122\"]],AUTHORITY[\"EPSG\",\"4167\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
		 "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",-40.9");
    add_srs_wkt (p, 8,
		 "2527777777777],PARAMETER[\"central_meridian\",175.647222");
    add_srs_wkt (p, 9,
		 "2222222],PARAMETER[\"scale_factor\",1],PARAMETER[\"false");
    add_srs_wkt (p, 10,
		 "_easting\",400000],PARAMETER[\"false_northing\",800000],");
    add_srs_wkt (p, 11,
		 "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"No");
    add_srs_wkt (p, 12,
		 "rthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13, ",\"2112\"]]");
    p = add_epsg_def (filter, first, last, 2113, "epsg", 2113,
		      "NZGD2000 / Wellington 2000");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=-41.3011111111111 +lon_0=174.77638888");
    add_proj4text (p, 1,
		   "88889 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84");
    add_proj4text (p, 2, "=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NZGD2000 / Wellington 2000\",GEOGCS[\"NZGD2000\"");
    add_srs_wkt (p, 1,
		 ",DATUM[\"New_Zealand_Geodetic_Datum_2000\",SPHEROID[\"GR");
    add_srs_wkt (p, 2,
		 "S 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019");
    add_srs_wkt (p, 3,
		 "\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6167\"]");
    add_srs_wkt (p, 4,
		 "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
		 "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
		 "122\"]],AUTHORITY[\"EPSG\",\"4167\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
		 "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",-41.3");
    add_srs_wkt (p, 8,
		 "011111111111],PARAMETER[\"central_meridian\",174.7763888");
    add_srs_wkt (p, 9,
		 "888889],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
		 "easting\",400000],PARAMETER[\"false_northing\",800000],U");
    add_srs_wkt (p, 11,
		 "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Nor");
    add_srs_wkt (p, 12,
		 "thing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13, ",\"2113\"]]");
    p = add_epsg_def (filter, first, last, 2114, "epsg", 2114,
		      "NZGD2000 / Collingwood 2000");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=-40.71472222222223 +lon_0=172.6719444");
    add_proj4text (p, 1,
		   "444444 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs8");
    add_proj4text (p, 2, "4=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NZGD2000 / Collingwood 2000\",GEOGCS[\"NZGD2000");
    add_srs_wkt (p, 1,
		 "\",DATUM[\"New_Zealand_Geodetic_Datum_2000\",SPHEROID[\"");
    add_srs_wkt (p, 2,
		 "GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
		 "19\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6167\"");
    add_srs_wkt (p, 4,
		 "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
		 "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
		 "9122\"]],AUTHORITY[\"EPSG\",\"4167\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
		 "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",-40.");
    add_srs_wkt (p, 8,
		 "71472222222223],PARAMETER[\"central_meridian\",172.67194");
    add_srs_wkt (p, 9,
		 "44444444],PARAMETER[\"scale_factor\",1],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
		 "e_easting\",400000],PARAMETER[\"false_northing\",800000]");
    add_srs_wkt (p, 11,
		 ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"N");
    add_srs_wkt (p, 12,
		 "orthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13, "\",\"2114\"]]");
    p = add_epsg_def (filter, first, last, 2115, "epsg", 2115,
		      "NZGD2000 / Nelson 2000");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=-41.27444444444444 +lon_0=173.2991666");
    add_proj4text (p, 1,
		   "666667 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs8");
    add_proj4text (p, 2, "4=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NZGD2000 / Nelson 2000\",GEOGCS[\"NZGD2000\",DA");
    add_srs_wkt (p, 1,
		 "TUM[\"New_Zealand_Geodetic_Datum_2000\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 2,
		 "980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]");
    add_srs_wkt (p, 3,
		 "],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6167\"]],P");
    add_srs_wkt (p, 4,
		 "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
		 "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
		 "\"]],AUTHORITY[\"EPSG\",\"4167\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 7,
		 "se_Mercator\"],PARAMETER[\"latitude_of_origin\",-41.2744");
    add_srs_wkt (p, 8,
		 "4444444444],PARAMETER[\"central_meridian\",173.299166666");
    add_srs_wkt (p, 9,
		 "6667],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_ea");
    add_srs_wkt (p, 10,
		 "sting\",400000],PARAMETER[\"false_northing\",800000],UNI");
    add_srs_wkt (p, 11,
		 "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"North");
    add_srs_wkt (p, 12,
		 "ing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13, "2115\"]]");
    p = add_epsg_def (filter, first, last, 2116, "epsg", 2116,
		      "NZGD2000 / Karamea 2000");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=-41.28972222222222 +lon_0=172.1088888");
    add_proj4text (p, 1,
		   "888889 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs8");
    add_proj4text (p, 2, "4=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NZGD2000 / Karamea 2000\",GEOGCS[\"NZGD2000\",D");
    add_srs_wkt (p, 1,
		 "ATUM[\"New_Zealand_Geodetic_Datum_2000\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 2,
		 "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
		 "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6167\"]],");
    add_srs_wkt (p, 4,
		 "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
		 "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
		 "2\"]],AUTHORITY[\"EPSG\",\"4167\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
		 "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",-41.289");
    add_srs_wkt (p, 8,
		 "72222222222],PARAMETER[\"central_meridian\",172.10888888");
    add_srs_wkt (p, 9,
		 "88889],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_e");
    add_srs_wkt (p, 10,
		 "asting\",400000],PARAMETER[\"false_northing\",800000],UN");
    add_srs_wkt (p, 11,
		 "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Nort");
    add_srs_wkt (p, 12,
		 "hing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13, "\"2116\"]]");
    p = add_epsg_def (filter, first, last, 2117, "epsg", 2117,
		      "NZGD2000 / Buller 2000");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=-41.81055555555555 +lon_0=171.5811111");
    add_proj4text (p, 1,
		   "111111 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs8");
    add_proj4text (p, 2, "4=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NZGD2000 / Buller 2000\",GEOGCS[\"NZGD2000\",DA");
    add_srs_wkt (p, 1,
		 "TUM[\"New_Zealand_Geodetic_Datum_2000\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 2,
		 "980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]");
    add_srs_wkt (p, 3,
		 "],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6167\"]],P");
    add_srs_wkt (p, 4,
		 "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
		 "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
		 "\"]],AUTHORITY[\"EPSG\",\"4167\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 7,
		 "se_Mercator\"],PARAMETER[\"latitude_of_origin\",-41.8105");
    add_srs_wkt (p, 8,
		 "5555555555],PARAMETER[\"central_meridian\",171.581111111");
    add_srs_wkt (p, 9,
		 "1111],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_ea");
    add_srs_wkt (p, 10,
		 "sting\",400000],PARAMETER[\"false_northing\",800000],UNI");
    add_srs_wkt (p, 11,
		 "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"North");
    add_srs_wkt (p, 12,
		 "ing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13, "2117\"]]");
    p = add_epsg_def (filter, first, last, 2118, "epsg", 2118,
		      "NZGD2000 / Grey 2000");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=-42.33361111111111 +lon_0=171.5497222");
    add_proj4text (p, 1,
		   "222222 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs8");
    add_proj4text (p, 2, "4=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NZGD2000 / Grey 2000\",GEOGCS[\"NZGD2000\",DATU");
    add_srs_wkt (p, 1,
		 "M[\"New_Zealand_Geodetic_Datum_2000\",SPHEROID[\"GRS 198");
    add_srs_wkt (p, 2,
		 "0\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],");
    add_srs_wkt (p, 3,
		 "TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6167\"]],PRI");
    add_srs_wkt (p, 4,
		 "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
		 "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
		 "],AUTHORITY[\"EPSG\",\"4167\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
		 "Mercator\"],PARAMETER[\"latitude_of_origin\",-42.3336111");
    add_srs_wkt (p, 8,
		 "1111111],PARAMETER[\"central_meridian\",171.549722222222");
    add_srs_wkt (p, 9,
		 "2],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
		 "ng\",400000],PARAMETER[\"false_northing\",800000],UNIT[\"");
    add_srs_wkt (p, 11,
		 "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
		 ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2118");
    add_srs_wkt (p, 13, "\"]]");
    p = add_epsg_def (filter, first, last, 2119, "epsg", 2119,
		      "NZGD2000 / Amuri 2000");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=-42.68888888888888 +lon_0=173.01 +k=1");
    add_proj4text (p, 1,
		   " +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0");
    add_proj4text (p, 2, ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NZGD2000 / Amuri 2000\",GEOGCS[\"NZGD2000\",DAT");
    add_srs_wkt (p, 1,
		 "UM[\"New_Zealand_Geodetic_Datum_2000\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 2,
		 "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 3,
		 ",TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6167\"]],PR");
    add_srs_wkt (p, 4,
		 "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
		 "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
		 "]],AUTHORITY[\"EPSG\",\"4167\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 7,
		 "_Mercator\"],PARAMETER[\"latitude_of_origin\",-42.688888");
    add_srs_wkt (p, 8,
		 "88888888],PARAMETER[\"central_meridian\",173.01],PARAMET");
    add_srs_wkt (p, 9,
		 "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",40000");
    add_srs_wkt (p, 10,
		 "0],PARAMETER[\"false_northing\",800000],UNIT[\"metre\",1");
    add_srs_wkt (p, 11,
		 ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],");
    add_srs_wkt (p, 12, "AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2119\"]]");
    p = add_epsg_def (filter, first, last, 2120, "epsg", 2120,
		      "NZGD2000 / Marlborough 2000");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=-41.54444444444444 +lon_0=173.8019444");
    add_proj4text (p, 1,
		   "444444 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs8");
    add_proj4text (p, 2, "4=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NZGD2000 / Marlborough 2000\",GEOGCS[\"NZGD2000");
    add_srs_wkt (p, 1,
		 "\",DATUM[\"New_Zealand_Geodetic_Datum_2000\",SPHEROID[\"");
    add_srs_wkt (p, 2,
		 "GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
		 "19\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6167\"");
    add_srs_wkt (p, 4,
		 "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
		 "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
		 "9122\"]],AUTHORITY[\"EPSG\",\"4167\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
		 "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",-41.");
    add_srs_wkt (p, 8,
		 "54444444444444],PARAMETER[\"central_meridian\",173.80194");
    add_srs_wkt (p, 9,
		 "44444444],PARAMETER[\"scale_factor\",1],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
		 "e_easting\",400000],PARAMETER[\"false_northing\",800000]");
    add_srs_wkt (p, 11,
		 ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"N");
    add_srs_wkt (p, 12,
		 "orthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13, "\",\"2120\"]]");
    p = add_epsg_def (filter, first, last, 2121, "epsg", 2121,
		      "NZGD2000 / Hokitika 2000");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=-42.88611111111111 +lon_0=170.9797222");
    add_proj4text (p, 1,
		   "222222 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs8");
    add_proj4text (p, 2, "4=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NZGD2000 / Hokitika 2000\",GEOGCS[\"NZGD2000\",");
    add_srs_wkt (p, 1,
		 "DATUM[\"New_Zealand_Geodetic_Datum_2000\",SPHEROID[\"GRS");
    add_srs_wkt (p, 2,
		 " 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
		 "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6167\"]],");
    add_srs_wkt (p, 4,
		 "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
		 "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
		 "2\"]],AUTHORITY[\"EPSG\",\"4167\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
		 "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",-42.886");
    add_srs_wkt (p, 8,
		 "11111111111],PARAMETER[\"central_meridian\",170.97972222");
    add_srs_wkt (p, 9,
		 "22222],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_e");
    add_srs_wkt (p, 10,
		 "asting\",400000],PARAMETER[\"false_northing\",800000],UN");
    add_srs_wkt (p, 11,
		 "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Nort");
    add_srs_wkt (p, 12,
		 "hing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13, "\"2121\"]]");
    p = add_epsg_def (filter, first, last, 2122, "epsg", 2122,
		      "NZGD2000 / Okarito 2000");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=-43.11 +lon_0=170.2608333333333 +k=1 ");
    add_proj4text (p, 1,
		   "+x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,");
    add_proj4text (p, 2, "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NZGD2000 / Okarito 2000\",GEOGCS[\"NZGD2000\",D");
    add_srs_wkt (p, 1,
		 "ATUM[\"New_Zealand_Geodetic_Datum_2000\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 2,
		 "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
		 "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6167\"]],");
    add_srs_wkt (p, 4,
		 "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
		 "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
		 "2\"]],AUTHORITY[\"EPSG\",\"4167\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
		 "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",-43.11]");
    add_srs_wkt (p, 8,
		 ",PARAMETER[\"central_meridian\",170.2608333333333],PARAM");
    add_srs_wkt (p, 9,
		 "ETER[\"scale_factor\",1],PARAMETER[\"false_easting\",400");
    add_srs_wkt (p, 10,
		 "000],PARAMETER[\"false_northing\",800000],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
		 ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH");
    add_srs_wkt (p, 12,
		 "],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2122\"]]");
    p = add_epsg_def (filter, first, last, 2123, "epsg", 2123,
		      "NZGD2000 / Jacksons Bay 2000");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=-43.97777777777778 +lon_0=168.6061111");
    add_proj4text (p, 1,
		   "111111 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs8");
    add_proj4text (p, 2, "4=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NZGD2000 / Jacksons Bay 2000\",GEOGCS[\"NZGD200");
    add_srs_wkt (p, 1,
		 "0\",DATUM[\"New_Zealand_Geodetic_Datum_2000\",SPHEROID[\"");
    add_srs_wkt (p, 2,
		 "GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
		 "19\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6167\"");
    add_srs_wkt (p, 4,
		 "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
		 "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
		 "9122\"]],AUTHORITY[\"EPSG\",\"4167\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
		 "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",-43.");
    add_srs_wkt (p, 8,
		 "97777777777778],PARAMETER[\"central_meridian\",168.60611");
    add_srs_wkt (p, 9,
		 "11111111],PARAMETER[\"scale_factor\",1],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
		 "e_easting\",400000],PARAMETER[\"false_northing\",800000]");
    add_srs_wkt (p, 11,
		 ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"N");
    add_srs_wkt (p, 12,
		 "orthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13, "\",\"2123\"]]");
    p = add_epsg_def (filter, first, last, 2124, "epsg", 2124,
		      "NZGD2000 / Mount Pleasant 2000");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=-43.59055555555556 +lon_0=172.7269444");
    add_proj4text (p, 1,
		   "444445 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs8");
    add_proj4text (p, 2, "4=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NZGD2000 / Mount Pleasant 2000\",GEOGCS[\"NZGD2");
    add_srs_wkt (p, 1,
		 "000\",DATUM[\"New_Zealand_Geodetic_Datum_2000\",SPHEROID");
    add_srs_wkt (p, 2,
		 "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
		 "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"616");
    add_srs_wkt (p, 4,
		 "7\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
		 "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
		 ",\"9122\"]],AUTHORITY[\"EPSG\",\"4167\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
		 "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",-");
    add_srs_wkt (p, 8,
		 "43.59055555555556],PARAMETER[\"central_meridian\",172.72");
    add_srs_wkt (p, 9,
		 "69444444445],PARAMETER[\"scale_factor\",1],PARAMETER[\"f");
    add_srs_wkt (p, 10,
		 "alse_easting\",400000],PARAMETER[\"false_northing\",8000");
    add_srs_wkt (p, 11,
		 "00],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 12,
		 "\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 13, "PSG\",\"2124\"]]");
    p = add_epsg_def (filter, first, last, 2125, "epsg", 2125,
		      "NZGD2000 / Gawler 2000");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=-43.74861111111111 +lon_0=171.3605555");
    add_proj4text (p, 1,
		   "555555 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs8");
    add_proj4text (p, 2, "4=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NZGD2000 / Gawler 2000\",GEOGCS[\"NZGD2000\",DA");
    add_srs_wkt (p, 1,
		 "TUM[\"New_Zealand_Geodetic_Datum_2000\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 2,
		 "980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]");
    add_srs_wkt (p, 3,
		 "],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6167\"]],P");
    add_srs_wkt (p, 4,
		 "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
		 "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
		 "\"]],AUTHORITY[\"EPSG\",\"4167\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 7,
		 "se_Mercator\"],PARAMETER[\"latitude_of_origin\",-43.7486");
    add_srs_wkt (p, 8,
		 "1111111111],PARAMETER[\"central_meridian\",171.360555555");
    add_srs_wkt (p, 9,
		 "5555],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_ea");
    add_srs_wkt (p, 10,
		 "sting\",400000],PARAMETER[\"false_northing\",800000],UNI");
    add_srs_wkt (p, 11,
		 "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"North");
    add_srs_wkt (p, 12,
		 "ing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13, "2125\"]]");
    p = add_epsg_def (filter, first, last, 2126, "epsg", 2126,
		      "NZGD2000 / Timaru 2000");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=-44.40194444444445 +lon_0=171.0572222");
    add_proj4text (p, 1,
		   "222222 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs8");
    add_proj4text (p, 2, "4=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NZGD2000 / Timaru 2000\",GEOGCS[\"NZGD2000\",DA");
    add_srs_wkt (p, 1,
		 "TUM[\"New_Zealand_Geodetic_Datum_2000\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 2,
		 "980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]");
    add_srs_wkt (p, 3,
		 "],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6167\"]],P");
    add_srs_wkt (p, 4,
		 "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
		 "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
		 "\"]],AUTHORITY[\"EPSG\",\"4167\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 7,
		 "se_Mercator\"],PARAMETER[\"latitude_of_origin\",-44.4019");
    add_srs_wkt (p, 8,
		 "4444444445],PARAMETER[\"central_meridian\",171.057222222");
    add_srs_wkt (p, 9,
		 "2222],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_ea");
    add_srs_wkt (p, 10,
		 "sting\",400000],PARAMETER[\"false_northing\",800000],UNI");
    add_srs_wkt (p, 11,
		 "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"North");
    add_srs_wkt (p, 12,
		 "ing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13, "2126\"]]");
    p = add_epsg_def (filter, first, last, 2127, "epsg", 2127,
		      "NZGD2000 / Lindis Peak 2000");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=-44.735 +lon_0=169.4675 +k=1 +x_0=400");
    add_proj4text (p, 1,
		   "000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +uni");
    add_proj4text (p, 2, "ts=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NZGD2000 / Lindis Peak 2000\",GEOGCS[\"NZGD2000");
    add_srs_wkt (p, 1,
		 "\",DATUM[\"New_Zealand_Geodetic_Datum_2000\",SPHEROID[\"");
    add_srs_wkt (p, 2,
		 "GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
		 "19\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6167\"");
    add_srs_wkt (p, 4,
		 "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
		 "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
		 "9122\"]],AUTHORITY[\"EPSG\",\"4167\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
		 "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",-44.");
    add_srs_wkt (p, 8,
		 "735],PARAMETER[\"central_meridian\",169.4675],PARAMETER[");
    add_srs_wkt (p, 9,
		 "\"scale_factor\",1],PARAMETER[\"false_easting\",400000],");
    add_srs_wkt (p, 10,
		 "PARAMETER[\"false_northing\",800000],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
		 "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXI");
    add_srs_wkt (p, 12, "S[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2127\"]]");
    p = add_epsg_def (filter, first, last, 2128, "epsg", 2128,
		      "NZGD2000 / Mount Nicholas 2000");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=-45.13277777777778 +lon_0=168.3986111");
    add_proj4text (p, 1,
		   "111111 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs8");
    add_proj4text (p, 2, "4=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NZGD2000 / Mount Nicholas 2000\",GEOGCS[\"NZGD2");
    add_srs_wkt (p, 1,
		 "000\",DATUM[\"New_Zealand_Geodetic_Datum_2000\",SPHEROID");
    add_srs_wkt (p, 2,
		 "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
		 "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"616");
    add_srs_wkt (p, 4,
		 "7\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
		 "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
		 ",\"9122\"]],AUTHORITY[\"EPSG\",\"4167\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
		 "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",-");
    add_srs_wkt (p, 8,
		 "45.13277777777778],PARAMETER[\"central_meridian\",168.39");
    add_srs_wkt (p, 9,
		 "86111111111],PARAMETER[\"scale_factor\",1],PARAMETER[\"f");
    add_srs_wkt (p, 10,
		 "alse_easting\",400000],PARAMETER[\"false_northing\",8000");
    add_srs_wkt (p, 11,
		 "00],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 12,
		 "\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 13, "PSG\",\"2128\"]]");
    p = add_epsg_def (filter, first, last, 2129, "epsg", 2129,
		      "NZGD2000 / Mount York 2000");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=-45.56361111111111 +lon_0=167.7386111");
    add_proj4text (p, 1,
		   "111111 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs8");
    add_proj4text (p, 2, "4=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NZGD2000 / Mount York 2000\",GEOGCS[\"NZGD2000\"");
    add_srs_wkt (p, 1,
		 ",DATUM[\"New_Zealand_Geodetic_Datum_2000\",SPHEROID[\"GR");
    add_srs_wkt (p, 2,
		 "S 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019");
    add_srs_wkt (p, 3,
		 "\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6167\"]");
    add_srs_wkt (p, 4,
		 "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
		 "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
		 "122\"]],AUTHORITY[\"EPSG\",\"4167\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
		 "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",-45.5");
    add_srs_wkt (p, 8,
		 "6361111111111],PARAMETER[\"central_meridian\",167.738611");
    add_srs_wkt (p, 9,
		 "1111111],PARAMETER[\"scale_factor\",1],PARAMETER[\"false");
    add_srs_wkt (p, 10,
		 "_easting\",400000],PARAMETER[\"false_northing\",800000],");
    add_srs_wkt (p, 11,
		 "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"No");
    add_srs_wkt (p, 12,
		 "rthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13, ",\"2129\"]]");
    p = add_epsg_def (filter, first, last, 2130, "epsg", 2130,
		      "NZGD2000 / Observation Point 2000");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=-45.81611111111111 +lon_0=170.6283333");
    add_proj4text (p, 1,
		   "333333 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs8");
    add_proj4text (p, 2, "4=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NZGD2000 / Observation Point 2000\",GEOGCS[\"NZ");
    add_srs_wkt (p, 1,
		 "GD2000\",DATUM[\"New_Zealand_Geodetic_Datum_2000\",SPHER");
    add_srs_wkt (p, 2,
		 "OID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
		 ",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
		 "6167\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
		 "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
		 "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4167\"]],PROJECTION[");
    add_srs_wkt (p, 7,
		 "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
		 ",-45.81611111111111],PARAMETER[\"central_meridian\",170.");
    add_srs_wkt (p, 9,
		 "6283333333333],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 10,
		 "false_easting\",400000],PARAMETER[\"false_northing\",800");
    add_srs_wkt (p, 11,
		 "000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS");
    add_srs_wkt (p, 12,
		 "[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"");
    add_srs_wkt (p, 13, "EPSG\",\"2130\"]]");
    p = add_epsg_def (filter, first, last, 2131, "epsg", 2131,
		      "NZGD2000 / North Taieri 2000");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=-45.86138888888889 +lon_0=170.2825 +k");
    add_proj4text (p, 1,
		   "=0.99996 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0");
    add_proj4text (p, 2, ",0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NZGD2000 / North Taieri 2000\",GEOGCS[\"NZGD200");
    add_srs_wkt (p, 1,
		 "0\",DATUM[\"New_Zealand_Geodetic_Datum_2000\",SPHEROID[\"");
    add_srs_wkt (p, 2,
		 "GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
		 "19\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6167\"");
    add_srs_wkt (p, 4,
		 "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
		 "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
		 "9122\"]],AUTHORITY[\"EPSG\",\"4167\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
		 "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",-45.");
    add_srs_wkt (p, 8,
		 "86138888888889],PARAMETER[\"central_meridian\",170.2825]");
    add_srs_wkt (p, 9,
		 ",PARAMETER[\"scale_factor\",0.99996],PARAMETER[\"false_e");
    add_srs_wkt (p, 10,
		 "asting\",400000],PARAMETER[\"false_northing\",800000],UN");
    add_srs_wkt (p, 11,
		 "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Nort");
    add_srs_wkt (p, 12,
		 "hing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13, "\"2131\"]]");
    p = add_epsg_def (filter, first, last, 2132, "epsg", 2132,
		      "NZGD2000 / Bluff 2000");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=-46.6 +lon_0=168.3427777777778 +k=1 +");
    add_proj4text (p, 1,
		   "x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0");
    add_proj4text (p, 2, ",0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NZGD2000 / Bluff 2000\",GEOGCS[\"NZGD2000\",DAT");
    add_srs_wkt (p, 1,
		 "UM[\"New_Zealand_Geodetic_Datum_2000\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 2,
		 "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 3,
		 ",TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6167\"]],PR");
    add_srs_wkt (p, 4,
		 "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
		 "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
		 "]],AUTHORITY[\"EPSG\",\"4167\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 7,
		 "_Mercator\"],PARAMETER[\"latitude_of_origin\",-46.6],PAR");
    add_srs_wkt (p, 8,
		 "AMETER[\"central_meridian\",168.3427777777778],PARAMETER");
    add_srs_wkt (p, 9,
		 "[\"scale_factor\",1],PARAMETER[\"false_easting\",400000]");
    add_srs_wkt (p, 10,
		 ",PARAMETER[\"false_northing\",800000],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
		 "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AX");
    add_srs_wkt (p, 12, "IS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2132\"]]");
    p = add_epsg_def (filter, first, last, 2133, "epsg", 2133,
		      "NZGD2000 / UTM zone 58S");
    add_proj4text (p, 0,
		   "+proj=utm +zone=58 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1, "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NZGD2000 / UTM zone 58S\",GEOGCS[\"NZGD2000\",D");
    add_srs_wkt (p, 1,
		 "ATUM[\"New_Zealand_Geodetic_Datum_2000\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 2,
		 "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
		 "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6167\"]],");
    add_srs_wkt (p, 4,
		 "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
		 "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
		 "2\"]],AUTHORITY[\"EPSG\",\"4167\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
		 "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
		 "METER[\"central_meridian\",165],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 9,
		 "\",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER");
    add_srs_wkt (p, 10,
		 "[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
		 "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 12, "ing\",NORTH],AUTHORITY[\"EPSG\",\"2133\"]]");
    p = add_epsg_def (filter, first, last, 2134, "epsg", 2134,
		      "NZGD2000 / UTM zone 59S");
    add_proj4text (p, 0,
		   "+proj=utm +zone=59 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1, "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NZGD2000 / UTM zone 59S\",GEOGCS[\"NZGD2000\",D");
    add_srs_wkt (p, 1,
		 "ATUM[\"New_Zealand_Geodetic_Datum_2000\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 2,
		 "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
		 "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6167\"]],");
    add_srs_wkt (p, 4,
		 "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
		 "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
		 "2\"]],AUTHORITY[\"EPSG\",\"4167\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
		 "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
		 "METER[\"central_meridian\",171],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 9,
		 "\",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER");
    add_srs_wkt (p, 10,
		 "[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
		 "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 12, "ing\",NORTH],AUTHORITY[\"EPSG\",\"2134\"]]");
    p = add_epsg_def (filter, first, last, 2135, "epsg", 2135,
		      "NZGD2000 / UTM zone 60S");
    add_proj4text (p, 0,
		   "+proj=utm +zone=60 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1, "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NZGD2000 / UTM zone 60S\",GEOGCS[\"NZGD2000\",D");
    add_srs_wkt (p, 1,
		 "ATUM[\"New_Zealand_Geodetic_Datum_2000\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 2,
		 "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
		 "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6167\"]],");
    add_srs_wkt (p, 4,
		 "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
		 "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
		 "2\"]],AUTHORITY[\"EPSG\",\"4167\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
		 "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
		 "METER[\"central_meridian\",177],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 9,
		 "\",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER");
    add_srs_wkt (p, 10,
		 "[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
		 "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 12, "ing\",NORTH],AUTHORITY[\"EPSG\",\"2135\"]]");
    p = add_epsg_def (filter, first, last, 2136, "epsg", 2136,
		      "Accra / Ghana National Grid");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=4.666666666666667 +lon_0=-1 +k=0.9997");
    add_proj4text (p, 1,
		   "5 +x_0=274319.7391633579 +y_0=0 +a=6378300 +b=6356751.68");
    add_proj4text (p, 2,
		   "9189189 +towgs84=-199,32,322,0,0,0,0 +to_meter=0.3047997");
    add_proj4text (p, 3, "101815088 +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Accra / Ghana National Grid\",GEOGCS[\"Accra\",");
    add_srs_wkt (p, 1,
		 "DATUM[\"Accra\",SPHEROID[\"War Office\",6378300,296,AUTH");
    add_srs_wkt (p, 2,
		 "ORITY[\"EPSG\",\"7029\"]],TOWGS84[-199,32,322,0,0,0,0],A");
    add_srs_wkt (p, 3,
		 "UTHORITY[\"EPSG\",\"6168\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
		 "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
		 "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
		 "4168\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
		 "latitude_of_origin\",4.666666666666667],PARAMETER[\"cent");
    add_srs_wkt (p, 8,
		 "ral_meridian\",-1],PARAMETER[\"scale_factor\",0.99975],P");
    add_srs_wkt (p, 9,
		 "ARAMETER[\"false_easting\",900000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 10,
		 "thing\",0],UNIT[\"Gold Coast foot\",0.3047997101815088,A");
    add_srs_wkt (p, 11,
		 "UTHORITY[\"EPSG\",\"9094\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 12, "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2136\"]]");
    p = add_epsg_def (filter, first, last, 2137, "epsg", 2137,
		      "Accra / TM 1 NW");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=-1 +k=0.9996 +x_0=500000 +y_");
    add_proj4text (p, 1,
		   "0=0 +a=6378300 +b=6356751.689189189 +towgs84=-199,32,322");
    add_proj4text (p, 2, ",0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Accra / TM 1 NW\",GEOGCS[\"Accra\",DATUM[\"Accr");
    add_srs_wkt (p, 1,
		 "a\",SPHEROID[\"War Office\",6378300,296,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 2,
		 "\",\"7029\"]],TOWGS84[-199,32,322,0,0,0,0],AUTHORITY[\"E");
    add_srs_wkt (p, 3,
		 "PSG\",\"6168\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
		 "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 5,
		 "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4168\"]],PRO");
    add_srs_wkt (p, 6,
		 "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 7,
		 "_origin\",0],PARAMETER[\"central_meridian\",-1],PARAMETE");
    add_srs_wkt (p, 8,
		 "R[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",5");
    add_srs_wkt (p, 9,
		 "00000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 10,
		 "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXI");
    add_srs_wkt (p, 11, "S[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2137\"]]");
    p = add_epsg_def (filter, first, last, 2138, "epsg", 2138,
		      "NAD27(CGQ77) / Quebec Lambert");
    add_proj4text (p, 0,
		   "+proj=lcc +lat_1=60 +lat_2=46 +lat_0=44 +lon_0=-68.5 +x_");
    add_proj4text (p, 1, "0=0 +y_0=0 +ellps=clrk66 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD27(CGQ77) / Quebec Lambert\",GEOGCS[\"NAD27(");
    add_srs_wkt (p, 1,
		 "CGQ77)\",DATUM[\"North_American_Datum_1927_CGQ77\",SPHER");
    add_srs_wkt (p, 2,
		 "OID[\"Clarke 1866\",6378206.4,294.9786982138982,AUTHORIT");
    add_srs_wkt (p, 3,
		 "Y[\"EPSG\",\"7008\"]],AUTHORITY[\"EPSG\",\"6609\"]],PRIM");
    add_srs_wkt (p, 4,
		 "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
		 "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
		 "],AUTHORITY[\"EPSG\",\"4609\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 7,
		 "formal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",60");
    add_srs_wkt (p, 8,
		 "],PARAMETER[\"standard_parallel_2\",46],PARAMETER[\"lati");
    add_srs_wkt (p, 9,
		 "tude_of_origin\",44],PARAMETER[\"central_meridian\",-68.");
    add_srs_wkt (p, 10,
		 "5],PARAMETER[\"false_easting\",0],PARAMETER[\"false_nort");
    add_srs_wkt (p, 11,
		 "hing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 12,
		 ",AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13, "2138\"]]");
    p = add_epsg_def (filter, first, last, 2139, "epsg", 2139,
		      "NAD83(CSRS98) / SCoPQ zone 2 (deprecated)");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=-55.5 +k=0.9999 +x_0=304800 ");
    add_proj4text (p, 1,
		   "+y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2, "defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83(CSRS98) / SCoPQ zone 2 (deprecated)\",GEO");
    add_srs_wkt (p, 1,
		 "GCS[\"NAD83(CSRS98)\",DATUM[\"NAD83_Canadian_Spatial_Ref");
    add_srs_wkt (p, 2,
		 "erence_System\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
		 "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 4,
		 ",AUTHORITY[\"EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
		 "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
		 "199433,AUTHORITY[\"EPSG\",\"9108\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
		 "\"4140\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 8,
		 "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
		 ",-55.5],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"f");
    add_srs_wkt (p, 10,
		 "alse_easting\",304800],PARAMETER[\"false_northing\",0],U");
    add_srs_wkt (p, 11,
		 "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\"");
    add_srs_wkt (p, 12,
		 ",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"2139\"]]");
    p = add_epsg_def (filter, first, last, 2140, "epsg", 2140,
		      "NAD83(CSRS98) / MTM zone 3 (deprecated)");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=-58.5 +k=0.9999 +x_0=304800 ");
    add_proj4text (p, 1,
		   "+y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2, "defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83(CSRS98) / MTM zone 3 (deprecated)\",GEOGC");
    add_srs_wkt (p, 1,
		 "S[\"NAD83(CSRS98)\",DATUM[\"NAD83_Canadian_Spatial_Refer");
    add_srs_wkt (p, 2,
		 "ence_System\",SPHEROID[\"GRS 1980\",6378137,298.25722210");
    add_srs_wkt (p, 3,
		 "1,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],A");
    add_srs_wkt (p, 4,
		 "UTHORITY[\"EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
		 "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
		 "9433,AUTHORITY[\"EPSG\",\"9108\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4140\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 9,
		 "58.5],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
		 "se_easting\",304800],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 11,
		 "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E(X)\"");
    add_srs_wkt (p, 12,
		 ",EAST],AXIS[\"N(Y)\",NORTH],AUTHORITY[\"EPSG\",\"2140\"]");
    add_srs_wkt (p, 13, "]");
    p = add_epsg_def (filter, first, last, 2141, "epsg", 2141,
		      "NAD83(CSRS98) / MTM zone 4 (deprecated)");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=-61.5 +k=0.9999 +x_0=304800 ");
    add_proj4text (p, 1,
		   "+y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2, "defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83(CSRS98) / MTM zone 4 (deprecated)\",GEOGC");
    add_srs_wkt (p, 1,
		 "S[\"NAD83(CSRS98)\",DATUM[\"NAD83_Canadian_Spatial_Refer");
    add_srs_wkt (p, 2,
		 "ence_System\",SPHEROID[\"GRS 1980\",6378137,298.25722210");
    add_srs_wkt (p, 3,
		 "1,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],A");
    add_srs_wkt (p, 4,
		 "UTHORITY[\"EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
		 "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
		 "9433,AUTHORITY[\"EPSG\",\"9108\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4140\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 9,
		 "61.5],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
		 "se_easting\",304800],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 11,
		 "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E(X)\"");
    add_srs_wkt (p, 12,
		 ",EAST],AXIS[\"N(Y)\",NORTH],AUTHORITY[\"EPSG\",\"2141\"]");
    add_srs_wkt (p, 13, "]");
    p = add_epsg_def (filter, first, last, 2142, "epsg", 2142,
		      "NAD83(CSRS98) / MTM zone 5 (deprecated)");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=-64.5 +k=0.9999 +x_0=304800 ");
    add_proj4text (p, 1,
		   "+y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2, "defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83(CSRS98) / MTM zone 5 (deprecated)\",GEOGC");
    add_srs_wkt (p, 1,
		 "S[\"NAD83(CSRS98)\",DATUM[\"NAD83_Canadian_Spatial_Refer");
    add_srs_wkt (p, 2,
		 "ence_System\",SPHEROID[\"GRS 1980\",6378137,298.25722210");
    add_srs_wkt (p, 3,
		 "1,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],A");
    add_srs_wkt (p, 4,
		 "UTHORITY[\"EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
		 "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
		 "9433,AUTHORITY[\"EPSG\",\"9108\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4140\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 9,
		 "64.5],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
		 "se_easting\",304800],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 11,
		 "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E(X)\"");
    add_srs_wkt (p, 12,
		 ",EAST],AXIS[\"N(Y)\",NORTH],AUTHORITY[\"EPSG\",\"2142\"]");
    add_srs_wkt (p, 13, "]");
    p = add_epsg_def (filter, first, last, 2143, "epsg", 2143,
		      "NAD83(CSRS98) / MTM zone 6 (deprecated)");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=-67.5 +k=0.9999 +x_0=304800 ");
    add_proj4text (p, 1,
		   "+y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2, "defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83(CSRS98) / MTM zone 6 (deprecated)\",GEOGC");
    add_srs_wkt (p, 1,
		 "S[\"NAD83(CSRS98)\",DATUM[\"NAD83_Canadian_Spatial_Refer");
    add_srs_wkt (p, 2,
		 "ence_System\",SPHEROID[\"GRS 1980\",6378137,298.25722210");
    add_srs_wkt (p, 3,
		 "1,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],A");
    add_srs_wkt (p, 4,
		 "UTHORITY[\"EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
		 "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
		 "9433,AUTHORITY[\"EPSG\",\"9108\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4140\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 9,
		 "67.5],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
		 "se_easting\",304800],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 11,
		 "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E(X)\"");
    add_srs_wkt (p, 12,
		 ",EAST],AXIS[\"N(Y)\",NORTH],AUTHORITY[\"EPSG\",\"2143\"]");
    add_srs_wkt (p, 13, "]");
    p = add_epsg_def (filter, first, last, 2144, "epsg", 2144,
		      "NAD83(CSRS98) / MTM zone 7 (deprecated)");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=-70.5 +k=0.9999 +x_0=304800 ");
    add_proj4text (p, 1,
		   "+y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2, "defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83(CSRS98) / MTM zone 7 (deprecated)\",GEOGC");
    add_srs_wkt (p, 1,
		 "S[\"NAD83(CSRS98)\",DATUM[\"NAD83_Canadian_Spatial_Refer");
    add_srs_wkt (p, 2,
		 "ence_System\",SPHEROID[\"GRS 1980\",6378137,298.25722210");
    add_srs_wkt (p, 3,
		 "1,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],A");
    add_srs_wkt (p, 4,
		 "UTHORITY[\"EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
		 "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
		 "9433,AUTHORITY[\"EPSG\",\"9108\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4140\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 9,
		 "70.5],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
		 "se_easting\",304800],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 11,
		 "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E(X)\"");
    add_srs_wkt (p, 12,
		 ",EAST],AXIS[\"N(Y)\",NORTH],AUTHORITY[\"EPSG\",\"2144\"]");
    add_srs_wkt (p, 13, "]");
    p = add_epsg_def (filter, first, last, 2145, "epsg", 2145,
		      "NAD83(CSRS98) / MTM zone 8 (deprecated)");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=-73.5 +k=0.9999 +x_0=304800 ");
    add_proj4text (p, 1,
		   "+y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2, "defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83(CSRS98) / MTM zone 8 (deprecated)\",GEOGC");
    add_srs_wkt (p, 1,
		 "S[\"NAD83(CSRS98)\",DATUM[\"NAD83_Canadian_Spatial_Refer");
    add_srs_wkt (p, 2,
		 "ence_System\",SPHEROID[\"GRS 1980\",6378137,298.25722210");
    add_srs_wkt (p, 3,
		 "1,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],A");
    add_srs_wkt (p, 4,
		 "UTHORITY[\"EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
		 "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
		 "9433,AUTHORITY[\"EPSG\",\"9108\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4140\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 9,
		 "73.5],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
		 "se_easting\",304800],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 11,
		 "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E(X)\"");
    add_srs_wkt (p, 12,
		 ",EAST],AXIS[\"N(Y)\",NORTH],AUTHORITY[\"EPSG\",\"2145\"]");
    add_srs_wkt (p, 13, "]");
    p = add_epsg_def (filter, first, last, 2146, "epsg", 2146,
		      "NAD83(CSRS98) / MTM zone 9 (deprecated)");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=-76.5 +k=0.9999 +x_0=304800 ");
    add_proj4text (p, 1,
		   "+y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2, "defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83(CSRS98) / MTM zone 9 (deprecated)\",GEOGC");
    add_srs_wkt (p, 1,
		 "S[\"NAD83(CSRS98)\",DATUM[\"NAD83_Canadian_Spatial_Refer");
    add_srs_wkt (p, 2,
		 "ence_System\",SPHEROID[\"GRS 1980\",6378137,298.25722210");
    add_srs_wkt (p, 3,
		 "1,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],A");
    add_srs_wkt (p, 4,
		 "UTHORITY[\"EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
		 "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
		 "9433,AUTHORITY[\"EPSG\",\"9108\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4140\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 9,
		 "76.5],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
		 "se_easting\",304800],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 11,
		 "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E(X)\"");
    add_srs_wkt (p, 12,
		 ",EAST],AXIS[\"N(Y)\",NORTH],AUTHORITY[\"EPSG\",\"2146\"]");
    add_srs_wkt (p, 13, "]");
    p = add_epsg_def (filter, first, last, 2147, "epsg", 2147,
		      "NAD83(CSRS98) / MTM zone 10 (deprecated)");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=-79.5 +k=0.9999 +x_0=304800 ");
    add_proj4text (p, 1,
		   "+y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2, "defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83(CSRS98) / MTM zone 10 (deprecated)\",GEOG");
    add_srs_wkt (p, 1,
		 "CS[\"NAD83(CSRS98)\",DATUM[\"NAD83_Canadian_Spatial_Refe");
    add_srs_wkt (p, 2,
		 "rence_System\",SPHEROID[\"GRS 1980\",6378137,298.2572221");
    add_srs_wkt (p, 3,
		 "01,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9108\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4140\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 9,
		 "79.5],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
		 "se_easting\",304800],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 11,
		 "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E(X)\"");
    add_srs_wkt (p, 12,
		 ",EAST],AXIS[\"N(Y)\",NORTH],AUTHORITY[\"EPSG\",\"2147\"]");
    add_srs_wkt (p, 13, "]");
    p = add_epsg_def (filter, first, last, 2148, "epsg", 2148,
		      "NAD83(CSRS98) / UTM zone 21N (deprecated)");
    add_proj4text (p, 0,
		   "+proj=utm +zone=21 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1, "units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83(CSRS98) / UTM zone 21N (deprecated)\",GEO");
    add_srs_wkt (p, 1,
		 "GCS[\"NAD83(CSRS98)\",DATUM[\"NAD83_Canadian_Spatial_Ref");
    add_srs_wkt (p, 2,
		 "erence_System\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
		 "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 4,
		 ",AUTHORITY[\"EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
		 "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
		 "199433,AUTHORITY[\"EPSG\",\"9108\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
		 "\"4140\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 8,
		 "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
		 ",-57],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
		 "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 11,
		 "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 12,
		 "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13, "2148\"]]");
    p = add_epsg_def (filter, first, last, 2149, "epsg", 2149,
		      "NAD83(CSRS98) / UTM zone 18N (deprecated)");
    add_proj4text (p, 0,
		   "+proj=utm +zone=18 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1, "units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83(CSRS98) / UTM zone 18N (deprecated)\",GEO");
    add_srs_wkt (p, 1,
		 "GCS[\"NAD83(CSRS98)\",DATUM[\"NAD83_Canadian_Spatial_Ref");
    add_srs_wkt (p, 2,
		 "erence_System\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
		 "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 4,
		 ",AUTHORITY[\"EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
		 "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
		 "199433,AUTHORITY[\"EPSG\",\"9108\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
		 "\"4140\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 8,
		 "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
		 ",-75],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
		 "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 11,
		 "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 12,
		 "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13, "2149\"]]");
    p = add_epsg_def (filter, first, last, 2150, "epsg", 2150,
		      "NAD83(CSRS98) / UTM zone 17N (deprecated)");
    add_proj4text (p, 0,
		   "+proj=utm +zone=17 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1, "units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83(CSRS98) / UTM zone 17N (deprecated)\",GEO");
    add_srs_wkt (p, 1,
		 "GCS[\"NAD83(CSRS98)\",DATUM[\"NAD83_Canadian_Spatial_Ref");
    add_srs_wkt (p, 2,
		 "erence_System\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
		 "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 4,
		 ",AUTHORITY[\"EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
		 "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
		 "199433,AUTHORITY[\"EPSG\",\"9108\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
		 "\"4140\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 8,
		 "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
		 ",-81],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
		 "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 11,
		 "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 12,
		 "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13, "2150\"]]");
    p = add_epsg_def (filter, first, last, 2151, "epsg", 2151,
		      "NAD83(CSRS98) / UTM zone 13N (deprecated)");
    add_proj4text (p, 0,
		   "+proj=utm +zone=13 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1, "units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83(CSRS98) / UTM zone 13N (deprecated)\",GEO");
    add_srs_wkt (p, 1,
		 "GCS[\"NAD83(CSRS98)\",DATUM[\"NAD83_Canadian_Spatial_Ref");
    add_srs_wkt (p, 2,
		 "erence_System\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
		 "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 4,
		 ",AUTHORITY[\"EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
		 "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
		 "199433,AUTHORITY[\"EPSG\",\"9108\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
		 "\"4140\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 8,
		 "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
		 ",-105],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
		 "lse_easting\",500000],PARAMETER[\"false_northing\",0],UN");
    add_srs_wkt (p, 11,
		 "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"East");
    add_srs_wkt (p, 12,
		 "ing\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13, "\"2151\"]]");
    p = add_epsg_def (filter, first, last, 2152, "epsg", 2152,
		      "NAD83(CSRS98) / UTM zone 12N (deprecated)");
    add_proj4text (p, 0,
		   "+proj=utm +zone=12 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1, "units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83(CSRS98) / UTM zone 12N (deprecated)\",GEO");
    add_srs_wkt (p, 1,
		 "GCS[\"NAD83(CSRS98)\",DATUM[\"NAD83_Canadian_Spatial_Ref");
    add_srs_wkt (p, 2,
		 "erence_System\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
		 "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 4,
		 ",AUTHORITY[\"EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
		 "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
		 "199433,AUTHORITY[\"EPSG\",\"9108\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
		 "\"4140\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 8,
		 "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
		 ",-111],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
		 "lse_easting\",500000],PARAMETER[\"false_northing\",0],UN");
    add_srs_wkt (p, 11,
		 "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"East");
    add_srs_wkt (p, 12,
		 "ing\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13, "\"2152\"]]");
    p = add_epsg_def (filter, first, last, 2153, "epsg", 2153,
		      "NAD83(CSRS98) / UTM zone 11N (deprecated)");
    add_proj4text (p, 0,
		   "+proj=utm +zone=11 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1, "units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83(CSRS98) / UTM zone 11N (deprecated)\",GEO");
    add_srs_wkt (p, 1,
		 "GCS[\"NAD83(CSRS98)\",DATUM[\"NAD83_Canadian_Spatial_Ref");
    add_srs_wkt (p, 2,
		 "erence_System\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
		 "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 4,
		 ",AUTHORITY[\"EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
		 "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
		 "199433,AUTHORITY[\"EPSG\",\"9108\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
		 "\"4140\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 8,
		 "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
		 ",-117],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
		 "lse_easting\",500000],PARAMETER[\"false_northing\",0],UN");
    add_srs_wkt (p, 11,
		 "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"East");
    add_srs_wkt (p, 12,
		 "ing\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13, "\"2153\"]]");
    p = add_epsg_def (filter, first, last, 2154, "epsg", 2154,
		      "RGF93 / Lambert-93");
    add_proj4text (p, 0,
		   "+proj=lcc +lat_1=49 +lat_2=44 +lat_0=46.5 +lon_0=3 +x_0=");
    add_proj4text (p, 1,
		   "700000 +y_0=6600000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 ");
    add_proj4text (p, 2, "+units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"RGF93 / Lambert-93\",GEOGCS[\"RGF93\",DATUM[\"R");
    add_srs_wkt (p, 1,
		 "eseau_Geodesique_Francais_1993\",SPHEROID[\"GRS 1980\",6");
    add_srs_wkt (p, 2,
		 "378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS");
    add_srs_wkt (p, 3,
		 "84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6171\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
		 "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
		 "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
		 "HORITY[\"EPSG\",\"4171\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 7,
		 "l_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",49],PAR");
    add_srs_wkt (p, 8,
		 "AMETER[\"standard_parallel_2\",44],PARAMETER[\"latitude_");
    add_srs_wkt (p, 9,
		 "of_origin\",46.5],PARAMETER[\"central_meridian\",3],PARA");
    add_srs_wkt (p, 10,
		 "METER[\"false_easting\",700000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 11,
		 "ng\",6600000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
		 "\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13, "\",\"2154\"]]");
    p = add_epsg_def (filter, first, last, 2155, "epsg", 2155,
		      "American Samoa 1962 / American Samoa Lambert (deprecated)");
    add_proj4text (p, 0,
		   "+proj=lcc +lat_1=-14.26666666666667 +lat_0=-14.266666666");
    add_proj4text (p, 1,
		   "66667 +lon_0=170 +k_0=1 +x_0=152400.3048006096 +y_0=0 +e");
    add_proj4text (p, 2,
		   "llps=clrk66 +towgs84=-115,118,426,0,0,0,0 +units=us-ft +");
    add_proj4text (p, 3, "no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"American Samoa 1962 / American Samoa Lambert (d");
    add_srs_wkt (p, 1,
		 "eprecated)\",GEOGCS[\"American Samoa 1962\",DATUM[\"Amer");
    add_srs_wkt (p, 2,
		 "ican_Samoa_1962\",SPHEROID[\"Clarke 1866\",6378206.4,294");
    add_srs_wkt (p, 3,
		 ".9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],TOWGS84[-11");
    add_srs_wkt (p, 4,
		 "5,118,426,0,0,0,0],AUTHORITY[\"EPSG\",\"6169\"]],PRIMEM[");
    add_srs_wkt (p, 5,
		 "\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"deg");
    add_srs_wkt (p, 6,
		 "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 7,
		 "UTHORITY[\"EPSG\",\"4169\"]],PROJECTION[\"Lambert_Confor");
    add_srs_wkt (p, 8,
		 "mal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",-14.26");
    add_srs_wkt (p, 9,
		 "666666666667],PARAMETER[\"central_meridian\",170],PARAME");
    add_srs_wkt (p, 10,
		 "TER[\"scale_factor\",1],PARAMETER[\"false_easting\",5000");
    add_srs_wkt (p, 11,
		 "00],PARAMETER[\"false_northing\",0],UNIT[\"US survey foo");
    add_srs_wkt (p, 12,
		 "t\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXI");
    add_srs_wkt (p, 13,
		 "S[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"215");
    add_srs_wkt (p, 14, "5\"]]");
    p = add_epsg_def (filter, first, last, 2156, "epsg", 2156,
		      "NAD83(HARN) / UTM zone 59S (deprecated)");
    add_proj4text (p, 0,
		   "+proj=utm +zone=59 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1, "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83(HARN) / UTM zone 59S (deprecated)\",GEOGC");
    add_srs_wkt (p, 1,
		 "S[\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_");
    add_srs_wkt (p, 2,
		 "Network\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
		 "THORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHO");
    add_srs_wkt (p, 4,
		 "RITY[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
		 "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
		 ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152");
    add_srs_wkt (p, 7,
		 "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 8,
		 "itude_of_origin\",0],PARAMETER[\"central_meridian\",171]");
    add_srs_wkt (p, 9,
		 ",PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_ea");
    add_srs_wkt (p, 10,
		 "sting\",500000],PARAMETER[\"false_northing\",10000000],U");
    add_srs_wkt (p, 11,
		 "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eas");
    add_srs_wkt (p, 12,
		 "ting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13, ",\"2156\"]]");
    p = add_epsg_def (filter, first, last, 2157, "epsg", 2157,
		      "IRENET95 / Irish Transverse Mercator");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=53.5 +lon_0=-8 +k=0.99982 +x_0=600000");
    add_proj4text (p, 1,
		   " +y_0=750000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 2, "m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"IRENET95 / Irish Transverse Mercator\",GEOGCS[\"");
    add_srs_wkt (p, 1,
		 "IRENET95\",DATUM[\"IRENET95\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
		 "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[");
    add_srs_wkt (p, 3,
		 "0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6173\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
		 "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
		 ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
		 "ITY[\"EPSG\",\"4173\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
		 "\"],PARAMETER[\"latitude_of_origin\",53.5],PARAMETER[\"c");
    add_srs_wkt (p, 8,
		 "entral_meridian\",-8],PARAMETER[\"scale_factor\",0.99982");
    add_srs_wkt (p, 9,
		 "],PARAMETER[\"false_easting\",600000],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
		 "northing\",750000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
		 "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 12, ",AUTHORITY[\"EPSG\",\"2157\"]]");
    p = add_epsg_def (filter, first, last, 2158, "epsg", 2158,
		      "IRENET95 / UTM zone 29N");
    add_proj4text (p, 0,
		   "+proj=utm +zone=29 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1, "units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"IRENET95 / UTM zone 29N\",GEOGCS[\"IRENET95\",D");
    add_srs_wkt (p, 1,
		 "ATUM[\"IRENET95\",SPHEROID[\"GRS 1980\",6378137,298.2572");
    add_srs_wkt (p, 2,
		 "22101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,");
    add_srs_wkt (p, 3,
		 "0],AUTHORITY[\"EPSG\",\"6173\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
		 "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
		 ",\"4173\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
		 "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
		 "\",-9],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fa");
    add_srs_wkt (p, 9,
		 "lse_easting\",500000],PARAMETER[\"false_northing\",0],UN");
    add_srs_wkt (p, 10,
		 "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"East");
    add_srs_wkt (p, 11,
		 "ing\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12, "\"2158\"]]");
    p = add_epsg_def (filter, first, last, 2159, "epsg", 2159,
		      "Sierra Leone 1924 / New Colony Grid");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=6.666666666666667 +lon_0=-12 +k=1 +x_");
    add_proj4text (p, 1,
		   "0=152399.8550907544 +y_0=0 +a=6378300 +b=6356751.6891891");
    add_proj4text (p, 2, "89 +to_meter=0.3047997101815088 +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Sierra Leone 1924 / New Colony Grid\",GEOGCS[\"");
    add_srs_wkt (p, 1,
		 "Sierra Leone 1924\",DATUM[\"Sierra_Leone_Colony_1924\",S");
    add_srs_wkt (p, 2,
		 "PHEROID[\"War Office\",6378300,296,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
		 "7029\"]],AUTHORITY[\"EPSG\",\"6174\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
		 "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
		 "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
		 "EPSG\",\"4174\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
		 "RAMETER[\"latitude_of_origin\",6.666666666666667],PARAME");
    add_srs_wkt (p, 8,
		 "TER[\"central_meridian\",-12],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 9,
		 ",1],PARAMETER[\"false_easting\",500000],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
		 "e_northing\",0],UNIT[\"Gold Coast foot\",0.3047997101815");
    add_srs_wkt (p, 11,
		 "088,AUTHORITY[\"EPSG\",\"9094\"]],AXIS[\"Easting\",EAST]");
    add_srs_wkt (p, 12,
		 ",AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2159\"]]");
    p = add_epsg_def (filter, first, last, 2160, "epsg", 2160,
		      "Sierra Leone 1924 / New War Office Grid");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=6.666666666666667 +lon_0=-12 +k=1 +x_");
    add_proj4text (p, 1,
		   "0=243839.7681452071 +y_0=182879.8261089053 +a=6378300 +b");
    add_proj4text (p, 2,
		   "=6356751.689189189 +to_meter=0.3047997101815088 +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Sierra Leone 1924 / New War Office Grid\",GEOGC");
    add_srs_wkt (p, 1,
		 "S[\"Sierra Leone 1924\",DATUM[\"Sierra_Leone_Colony_1924");
    add_srs_wkt (p, 2,
		 "\",SPHEROID[\"War Office\",6378300,296,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
		 ",\"7029\"]],AUTHORITY[\"EPSG\",\"6174\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
		 "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
		 ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
		 "Y[\"EPSG\",\"4174\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
		 "],PARAMETER[\"latitude_of_origin\",6.666666666666667],PA");
    add_srs_wkt (p, 8,
		 "RAMETER[\"central_meridian\",-12],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
		 "or\",1],PARAMETER[\"false_easting\",800000],PARAMETER[\"");
    add_srs_wkt (p, 10,
		 "false_northing\",600000],UNIT[\"Gold Coast foot\",0.3047");
    add_srs_wkt (p, 11,
		 "997101815088,AUTHORITY[\"EPSG\",\"9094\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 12,
		 "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13, "2160\"]]");
    p = add_epsg_def (filter, first, last, 2161, "epsg", 2161,
		      "Sierra Leone 1968 / UTM zone 28N");
    add_proj4text (p, 0,
		   "+proj=utm +zone=28 +ellps=clrk80 +towgs84=-88,4,101,0,0,");
    add_proj4text (p, 1, "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Sierra Leone 1968 / UTM zone 28N\",GEOGCS[\"Sie");
    add_srs_wkt (p, 1,
		 "rra Leone 1968\",DATUM[\"Sierra_Leone_1968\",SPHEROID[\"");
    add_srs_wkt (p, 2,
		 "Clarke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
		 "\",\"7012\"]],TOWGS84[-88,4,101,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
		 "G\",\"6175\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
		 ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
		 "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4175\"]],PROJE");
    add_srs_wkt (p, 7,
		 "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
		 "rigin\",0],PARAMETER[\"central_meridian\",-15],PARAMETER");
    add_srs_wkt (p, 9,
		 "[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 10,
		 "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
		 "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 12, "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2161\"]]");
    p = add_epsg_def (filter, first, last, 2162, "epsg", 2162,
		      "Sierra Leone 1968 / UTM zone 29N");
    add_proj4text (p, 0,
		   "+proj=utm +zone=29 +ellps=clrk80 +towgs84=-88,4,101,0,0,");
    add_proj4text (p, 1, "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Sierra Leone 1968 / UTM zone 29N\",GEOGCS[\"Sie");
    add_srs_wkt (p, 1,
		 "rra Leone 1968\",DATUM[\"Sierra_Leone_1968\",SPHEROID[\"");
    add_srs_wkt (p, 2,
		 "Clarke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
		 "\",\"7012\"]],TOWGS84[-88,4,101,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
		 "G\",\"6175\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
		 ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
		 "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4175\"]],PROJE");
    add_srs_wkt (p, 7,
		 "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
		 "rigin\",0],PARAMETER[\"central_meridian\",-9],PARAMETER[");
    add_srs_wkt (p, 9,
		 "\"scale_factor\",0.9996],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 10,
		 "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
		 "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 12, "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2162\"]]");
    p = add_epsg_def (filter, first, last, 2163, "epsg", 2163,
		      "US National Atlas Equal Area");
    add_proj4text (p, 0,
		   "+proj=laea +lat_0=45 +lon_0=-100 +x_0=0 +y_0=0 +a=637099");
    add_proj4text (p, 1, "7 +b=6370997 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"US National Atlas Equal Area\",GEOGCS[\"Unspeci");
    add_srs_wkt (p, 1,
		 "fied datum based upon the Clarke 1866 Authalic Sphere\",");
    add_srs_wkt (p, 2,
		 "DATUM[\"Not_specified_based_on_Clarke_1866_Authalic_Sphe");
    add_srs_wkt (p, 3,
		 "re\",SPHEROID[\"Clarke 1866 Authalic Sphere\",6370997,0,");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"7052\"]],AUTHORITY[\"EPSG\",\"6052\"");
    add_srs_wkt (p, 5,
		 "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 6,
		 "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "9122\"]],AUTHORITY[\"EPSG\",\"4052\"]],PROJECTION[\"Lamb");
    add_srs_wkt (p, 8,
		 "ert_Azimuthal_Equal_Area\"],PARAMETER[\"latitude_of_cent");
    add_srs_wkt (p, 9,
		 "er\",45],PARAMETER[\"longitude_of_center\",-100],PARAMET");
    add_srs_wkt (p, 10,
		 "ER[\"false_easting\",0],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 11,
		 "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\"");
    add_srs_wkt (p, 12,
		 ",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"2163\"]]");
    p = add_epsg_def (filter, first, last, 2164, "epsg", 2164,
		      "Locodjo 1965 / TM 5 NW");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=-5 +k=0.9996 +x_0=500000 +y_");
    add_proj4text (p, 1,
		   "0=0 +ellps=clrk80 +towgs84=-125,53,467,0,0,0,0 +units=m ");
    add_proj4text (p, 2, "+no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Locodjo 1965 / TM 5 NW\",GEOGCS[\"Locodjo 1965\"");
    add_srs_wkt (p, 1,
		 ",DATUM[\"Locodjo_1965\",SPHEROID[\"Clarke 1880 (RGS)\",6");
    add_srs_wkt (p, 2,
		 "378249.145,293.465,AUTHORITY[\"EPSG\",\"7012\"]],TOWGS84");
    add_srs_wkt (p, 3,
		 "[-125,53,467,0,0,0,0],AUTHORITY[\"EPSG\",\"6142\"]],PRIM");
    add_srs_wkt (p, 4,
		 "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
		 "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
		 "],AUTHORITY[\"EPSG\",\"4142\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
		 "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 8,
		 "R[\"central_meridian\",-5],PARAMETER[\"scale_factor\",0.");
    add_srs_wkt (p, 9,
		 "9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
		 "lse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
		 "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 12, ",AUTHORITY[\"EPSG\",\"2164\"]]");
    p = add_epsg_def (filter, first, last, 2165, "epsg", 2165,
		      "Abidjan 1987 / TM 5 NW");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=-5 +k=0.9996 +x_0=500000 +y_");
    add_proj4text (p, 1,
		   "0=0 +ellps=clrk80 +towgs84=-124.76,53,466.79,0,0,0,0 +un");
    add_proj4text (p, 2, "its=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Abidjan 1987 / TM 5 NW\",GEOGCS[\"Abidjan 1987\"");
    add_srs_wkt (p, 1,
		 ",DATUM[\"Abidjan_1987\",SPHEROID[\"Clarke 1880 (RGS)\",6");
    add_srs_wkt (p, 2,
		 "378249.145,293.465,AUTHORITY[\"EPSG\",\"7012\"]],TOWGS84");
    add_srs_wkt (p, 3,
		 "[-124.76,53,466.79,0,0,0,0],AUTHORITY[\"EPSG\",\"6143\"]");
    add_srs_wkt (p, 4,
		 "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
		 "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
		 "122\"]],AUTHORITY[\"EPSG\",\"4143\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
		 "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PA");
    add_srs_wkt (p, 8,
		 "RAMETER[\"central_meridian\",-5],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 9,
		 "r\",0.9996],PARAMETER[\"false_easting\",500000],PARAMETE");
    add_srs_wkt (p, 10,
		 "R[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 11,
		 "G\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",");
    add_srs_wkt (p, 12, "NORTH],AUTHORITY[\"EPSG\",\"2165\"]]");
    p = add_epsg_def (filter, first, last, 2166, "epsg", 2166,
		      "Pulkovo 1942(83) / Gauss Kruger zone 3 (deprecated)");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=9 +k=1 +x_0=3500000 +y_0=0 +");
    add_proj4text (p, 1,
		   "ellps=krass +towgs84=26,-121,-78,0,0,0,0 +units=m +no_de");
    add_proj4text (p, 2, "fs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942(83) / Gauss Kruger zone 3 (depreca");
    add_srs_wkt (p, 1,
		 "ted)\",GEOGCS[\"Pulkovo 1942(83)\",DATUM[\"Pulkovo_1942_");
    add_srs_wkt (p, 2,
		 "83\",SPHEROID[\"Krassowsky 1940\",6378245,298.3,AUTHORIT");
    add_srs_wkt (p, 3,
		 "Y[\"EPSG\",\"7024\"]],TOWGS84[26,-121,-78,0,0,0,0],AUTHO");
    add_srs_wkt (p, 4,
		 "RITY[\"EPSG\",\"6178\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
		 "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
		 ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4178");
    add_srs_wkt (p, 7,
		 "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 8,
		 "itude_of_origin\",0],PARAMETER[\"central_meridian\",9],P");
    add_srs_wkt (p, 9,
		 "ARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
		 ",3500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
		 ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[");
    add_srs_wkt (p, 12, "\"Y\",EAST],AUTHORITY[\"EPSG\",\"2166\"]]");
    p = add_epsg_def (filter, first, last, 2167, "epsg", 2167,
		      "Pulkovo 1942(83) / Gauss Kruger zone 4 (deprecated)");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=12 +k=1 +x_0=4500000 +y_0=0 ");
    add_proj4text (p, 1,
		   "+ellps=krass +towgs84=26,-121,-78,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 2, "efs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942(83) / Gauss Kruger zone 4 (depreca");
    add_srs_wkt (p, 1,
		 "ted)\",GEOGCS[\"Pulkovo 1942(83)\",DATUM[\"Pulkovo_1942_");
    add_srs_wkt (p, 2,
		 "83\",SPHEROID[\"Krassowsky 1940\",6378245,298.3,AUTHORIT");
    add_srs_wkt (p, 3,
		 "Y[\"EPSG\",\"7024\"]],TOWGS84[26,-121,-78,0,0,0,0],AUTHO");
    add_srs_wkt (p, 4,
		 "RITY[\"EPSG\",\"6178\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
		 "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
		 ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4178");
    add_srs_wkt (p, 7,
		 "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 8,
		 "itude_of_origin\",0],PARAMETER[\"central_meridian\",12],");
    add_srs_wkt (p, 9,
		 "PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
		 ",4500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
		 ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[");
    add_srs_wkt (p, 12, "\"Y\",EAST],AUTHORITY[\"EPSG\",\"2167\"]]");
    p = add_epsg_def (filter, first, last, 2168, "epsg", 2168,
		      "Pulkovo 1942(83) / Gauss Kruger zone 5 (deprecated)");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=5500000 +y_0=0 ");
    add_proj4text (p, 1,
		   "+ellps=krass +towgs84=26,-121,-78,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 2, "efs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942(83) / Gauss Kruger zone 5 (depreca");
    add_srs_wkt (p, 1,
		 "ted)\",GEOGCS[\"Pulkovo 1942(83)\",DATUM[\"Pulkovo_1942_");
    add_srs_wkt (p, 2,
		 "83\",SPHEROID[\"Krassowsky 1940\",6378245,298.3,AUTHORIT");
    add_srs_wkt (p, 3,
		 "Y[\"EPSG\",\"7024\"]],TOWGS84[26,-121,-78,0,0,0,0],AUTHO");
    add_srs_wkt (p, 4,
		 "RITY[\"EPSG\",\"6178\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
		 "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
		 ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4178");
    add_srs_wkt (p, 7,
		 "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 8,
		 "itude_of_origin\",0],PARAMETER[\"central_meridian\",15],");
    add_srs_wkt (p, 9,
		 "PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
		 ",5500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
		 ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[");
    add_srs_wkt (p, 12, "\"Y\",EAST],AUTHORITY[\"EPSG\",\"2168\"]]");
    p = add_epsg_def (filter, first, last, 2169, "epsg", 2169,
		      "Luxembourg 1930 / Gauss");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=49.83333333333334 +lon_0=6.1666666666");
    add_proj4text (p, 1,
		   "66667 +k=1 +x_0=80000 +y_0=100000 +ellps=intl +towgs84=-");
    add_proj4text (p, 2,
		   "189.681,18.3463,-42.7695,-0.33746,-3.09264,2.53861,0.459");
    add_proj4text (p, 3, "8 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Luxembourg 1930 / Gauss\",GEOGCS[\"Luxembourg 1");
    add_srs_wkt (p, 1,
		 "930\",DATUM[\"Luxembourg_1930\",SPHEROID[\"International");
    add_srs_wkt (p, 2,
		 " 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS8");
    add_srs_wkt (p, 3,
		 "4[-189.681,18.3463,-42.7695,-0.33746,-3.09264,2.53861,0.");
    add_srs_wkt (p, 4,
		 "4598],AUTHORITY[\"EPSG\",\"6181\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 5,
		 ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 6,
		 "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 7,
		 "SG\",\"4181\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 8,
		 "METER[\"latitude_of_origin\",49.83333333333334],PARAMETE");
    add_srs_wkt (p, 9,
		 "R[\"central_meridian\",6.166666666666667],PARAMETER[\"sc");
    add_srs_wkt (p, 10,
		 "ale_factor\",1],PARAMETER[\"false_easting\",80000],PARAM");
    add_srs_wkt (p, 11,
		 "ETER[\"false_northing\",100000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 12,
		 "TY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST");
    add_srs_wkt (p, 13, "],AUTHORITY[\"EPSG\",\"2169\"]]");
    p = add_epsg_def (filter, first, last, 2170, "epsg", 2170,
		      "MGI / Slovenia Grid (deprecated)");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=15 +k=0.9999 +x_0=500000 +y_");
    add_proj4text (p, 1,
		   "0=0 +ellps=bessel +towgs84=577.326,90.129,463.919,5.137,");
    add_proj4text (p, 2, "1.474,5.297,2.4232 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"MGI / Slovenia Grid (deprecated)\",GEOGCS[\"MGI");
    add_srs_wkt (p, 1,
		 "\",DATUM[\"Militar_Geographische_Institute\",SPHEROID[\"");
    add_srs_wkt (p, 2,
		 "Bessel 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
		 ",\"7004\"]],TOWGS84[577.326,90.129,463.919,5.137,1.474,5");
    add_srs_wkt (p, 4,
		 ".297,2.4232],AUTHORITY[\"EPSG\",\"6312\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 5,
		 "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 6,
		 "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 7,
		 "TY[\"EPSG\",\"4312\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 8,
		 "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 9,
		 "l_meridian\",15],PARAMETER[\"scale_factor\",0.9999],PARA");
    add_srs_wkt (p, 10,
		 "METER[\"false_easting\",500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 11,
		 "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 12,
		 "XIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2");
    add_srs_wkt (p, 13, "170\"]]");
    p = add_epsg_def (filter, first, last, 2171, "epsg", 2171,
		      "Pulkovo 1942(58) / Poland zone I (deprecated)");
    add_proj4text (p, 0,
		   "+proj=sterea +lat_0=50.625 +lon_0=21.08333333333333 +k=0");
    add_proj4text (p, 1,
		   ".9998 +x_0=4637000 +y_0=5647000 +ellps=krass +towgs84=33");
    add_proj4text (p, 2,
		   ".4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84 +units=m +no_d");
    add_proj4text (p, 3, "efs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942(58) / Poland zone I (deprecated)\"");
    add_srs_wkt (p, 1,
		 ",GEOGCS[\"Pulkovo 1942(58)\",DATUM[\"Pulkovo_1942_58\",S");
    add_srs_wkt (p, 2,
		 "PHEROID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
		 "SG\",\"7024\"]],TOWGS84[33.4,-146.6,-76.3,-0.359,-0.053,");
    add_srs_wkt (p, 4,
		 "0.844,-0.84],AUTHORITY[\"EPSG\",\"6179\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 5,
		 "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 6,
		 "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 7,
		 "TY[\"EPSG\",\"4179\"]],PROJECTION[\"Oblique_Stereographi");
    add_srs_wkt (p, 8,
		 "c\"],PARAMETER[\"latitude_of_origin\",50.625],PARAMETER[");
    add_srs_wkt (p, 9,
		 "\"central_meridian\",21.08333333333333],PARAMETER[\"scal");
    add_srs_wkt (p, 10,
		 "e_factor\",0.9998],PARAMETER[\"false_easting\",4637000],");
    add_srs_wkt (p, 11,
		 "PARAMETER[\"false_northing\",5647000],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 12,
		 "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 13, ",EAST],AUTHORITY[\"EPSG\",\"2171\"]]");
    p = add_epsg_def (filter, first, last, 2172, "epsg", 2172,
		      "Pulkovo 1942(58) / Poland zone II");
    add_proj4text (p, 0,
		   "+proj=sterea +lat_0=53.00194444444445 +lon_0=21.50277777");
    add_proj4text (p, 1,
		   "777778 +k=0.9998 +x_0=4603000 +y_0=5806000 +ellps=krass ");
    add_proj4text (p, 2,
		   "+towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84 +un");
    add_proj4text (p, 3, "its=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942(58) / Poland zone II\",GEOGCS[\"Pu");
    add_srs_wkt (p, 1,
		 "lkovo 1942(58)\",DATUM[\"Pulkovo_1942_58\",SPHEROID[\"Kr");
    add_srs_wkt (p, 2,
		 "assowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"");
    add_srs_wkt (p, 3,
		 "]],TOWGS84[33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6179\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4179\"]],PROJECTION[\"Oblique_Stereographic\"],PARAMETER");
    add_srs_wkt (p, 8,
		 "[\"latitude_of_origin\",53.00194444444445],PARAMETER[\"c");
    add_srs_wkt (p, 9,
		 "entral_meridian\",21.50277777777778],PARAMETER[\"scale_f");
    add_srs_wkt (p, 10,
		 "actor\",0.9998],PARAMETER[\"false_easting\",4603000],PAR");
    add_srs_wkt (p, 11,
		 "AMETER[\"false_northing\",5806000],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 12,
		 "ORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",E");
    add_srs_wkt (p, 13, "AST],AUTHORITY[\"EPSG\",\"2172\"]]");
    p = add_epsg_def (filter, first, last, 2173, "epsg", 2173,
		      "Pulkovo 1942(58) / Poland zone III");
    add_proj4text (p, 0,
		   "+proj=sterea +lat_0=53.58333333333334 +lon_0=17.00833333");
    add_proj4text (p, 1,
		   "333333 +k=0.9998 +x_0=3501000 +y_0=5999000 +ellps=krass ");
    add_proj4text (p, 2,
		   "+towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84 +un");
    add_proj4text (p, 3, "its=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942(58) / Poland zone III\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
		 "ulkovo 1942(58)\",DATUM[\"Pulkovo_1942_58\",SPHEROID[\"K");
    add_srs_wkt (p, 2,
		 "rassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024");
    add_srs_wkt (p, 3,
		 "\"]],TOWGS84[33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84");
    add_srs_wkt (p, 4,
		 "],AUTHORITY[\"EPSG\",\"6179\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 5,
		 "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 6,
		 "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
		 ",\"4179\"]],PROJECTION[\"Oblique_Stereographic\"],PARAME");
    add_srs_wkt (p, 8,
		 "TER[\"latitude_of_origin\",53.58333333333334],PARAMETER[");
    add_srs_wkt (p, 9,
		 "\"central_meridian\",17.00833333333333],PARAMETER[\"scal");
    add_srs_wkt (p, 10,
		 "e_factor\",0.9998],PARAMETER[\"false_easting\",3501000],");
    add_srs_wkt (p, 11,
		 "PARAMETER[\"false_northing\",5999000],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 12,
		 "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 13, ",EAST],AUTHORITY[\"EPSG\",\"2173\"]]");
    p = add_epsg_def (filter, first, last, 2174, "epsg", 2174,
		      "Pulkovo 1942(58) / Poland zone IV");
    add_proj4text (p, 0,
		   "+proj=sterea +lat_0=51.67083333333333 +lon_0=16.67222222");
    add_proj4text (p, 1,
		   "222222 +k=0.9998 +x_0=3703000 +y_0=5627000 +ellps=krass ");
    add_proj4text (p, 2,
		   "+towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84 +un");
    add_proj4text (p, 3, "its=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942(58) / Poland zone IV\",GEOGCS[\"Pu");
    add_srs_wkt (p, 1,
		 "lkovo 1942(58)\",DATUM[\"Pulkovo_1942_58\",SPHEROID[\"Kr");
    add_srs_wkt (p, 2,
		 "assowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"");
    add_srs_wkt (p, 3,
		 "]],TOWGS84[33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6179\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4179\"]],PROJECTION[\"Oblique_Stereographic\"],PARAMETER");
    add_srs_wkt (p, 8,
		 "[\"latitude_of_origin\",51.67083333333333],PARAMETER[\"c");
    add_srs_wkt (p, 9,
		 "entral_meridian\",16.67222222222222],PARAMETER[\"scale_f");
    add_srs_wkt (p, 10,
		 "actor\",0.9998],PARAMETER[\"false_easting\",3703000],PAR");
    add_srs_wkt (p, 11,
		 "AMETER[\"false_northing\",5627000],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 12,
		 "ORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",E");
    add_srs_wkt (p, 13, "AST],AUTHORITY[\"EPSG\",\"2174\"]]");
    p = add_epsg_def (filter, first, last, 2175, "epsg", 2175,
		      "Pulkovo 1942(58) / Poland zone V");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=18.95833333333333 +k=0.99998");
    add_proj4text (p, 1,
		   "3 +x_0=237000 +y_0=-4700000 +ellps=krass +towgs84=33.4,-");
    add_proj4text (p, 2,
		   "146.6,-76.3,-0.359,-0.053,0.844,-0.84 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942(58) / Poland zone V\",GEOGCS[\"Pul");
    add_srs_wkt (p, 1,
		 "kovo 1942(58)\",DATUM[\"Pulkovo_1942_58\",SPHEROID[\"Kra");
    add_srs_wkt (p, 2,
		 "ssowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"");
    add_srs_wkt (p, 3,
		 "]],TOWGS84[33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6179\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4179\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
		 "8.95833333333333],PARAMETER[\"scale_factor\",0.999983],P");
    add_srs_wkt (p, 10,
		 "ARAMETER[\"false_easting\",237000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 11,
		 "thing\",-4700000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
		 "9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"");
    add_srs_wkt (p, 13, "EPSG\",\"2175\"]]");
    p = add_epsg_def (filter, first, last, 2176, "epsg", 2176,
		      "ETRS89 / Poland CS2000 zone 5");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=15 +k=0.999923 +x_0=5500000 ");
    add_proj4text (p, 1,
		   "+y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2, "defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"ETRS89 / Poland CS2000 zone 5\",GEOGCS[\"ETRS89");
    add_srs_wkt (p, 1,
		 "\",DATUM[\"European_Terrestrial_Reference_System_1989\",");
    add_srs_wkt (p, 2,
		 "SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
		 "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
		 "G\",\"6258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
		 ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
		 "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJE");
    add_srs_wkt (p, 7,
		 "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
		 "rigin\",0],PARAMETER[\"central_meridian\",15],PARAMETER[");
    add_srs_wkt (p, 9,
		 "\"scale_factor\",0.999923],PARAMETER[\"false_easting\",5");
    add_srs_wkt (p, 10,
		 "500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1");
    add_srs_wkt (p, 11,
		 ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"x\",NORTH],AXIS[\"");
    add_srs_wkt (p, 12, "y\",EAST],AUTHORITY[\"EPSG\",\"2176\"]]");
    p = add_epsg_def (filter, first, last, 2177, "epsg", 2177,
		      "ETRS89 / Poland CS2000 zone 6");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=18 +k=0.999923 +x_0=6500000 ");
    add_proj4text (p, 1,
		   "+y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2, "defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"ETRS89 / Poland CS2000 zone 6\",GEOGCS[\"ETRS89");
    add_srs_wkt (p, 1,
		 "\",DATUM[\"European_Terrestrial_Reference_System_1989\",");
    add_srs_wkt (p, 2,
		 "SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
		 "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
		 "G\",\"6258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
		 ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
		 "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJE");
    add_srs_wkt (p, 7,
		 "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
		 "rigin\",0],PARAMETER[\"central_meridian\",18],PARAMETER[");
    add_srs_wkt (p, 9,
		 "\"scale_factor\",0.999923],PARAMETER[\"false_easting\",6");
    add_srs_wkt (p, 10,
		 "500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1");
    add_srs_wkt (p, 11,
		 ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"x\",NORTH],AXIS[\"");
    add_srs_wkt (p, 12, "y\",EAST],AUTHORITY[\"EPSG\",\"2177\"]]");
    p = add_epsg_def (filter, first, last, 2178, "epsg", 2178,
		      "ETRS89 / Poland CS2000 zone 7");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=21 +k=0.999923 +x_0=7500000 ");
    add_proj4text (p, 1,
		   "+y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2, "defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"ETRS89 / Poland CS2000 zone 7\",GEOGCS[\"ETRS89");
    add_srs_wkt (p, 1,
		 "\",DATUM[\"European_Terrestrial_Reference_System_1989\",");
    add_srs_wkt (p, 2,
		 "SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
		 "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
		 "G\",\"6258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
		 ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
		 "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJE");
    add_srs_wkt (p, 7,
		 "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
		 "rigin\",0],PARAMETER[\"central_meridian\",21],PARAMETER[");
    add_srs_wkt (p, 9,
		 "\"scale_factor\",0.999923],PARAMETER[\"false_easting\",7");
    add_srs_wkt (p, 10,
		 "500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1");
    add_srs_wkt (p, 11,
		 ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"x\",NORTH],AXIS[\"");
    add_srs_wkt (p, 12, "y\",EAST],AUTHORITY[\"EPSG\",\"2178\"]]");
    p = add_epsg_def (filter, first, last, 2179, "epsg", 2179,
		      "ETRS89 / Poland CS2000 zone 8");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=24 +k=0.999923 +x_0=8500000 ");
    add_proj4text (p, 1,
		   "+y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2, "defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"ETRS89 / Poland CS2000 zone 8\",GEOGCS[\"ETRS89");
    add_srs_wkt (p, 1,
		 "\",DATUM[\"European_Terrestrial_Reference_System_1989\",");
    add_srs_wkt (p, 2,
		 "SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
		 "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
		 "G\",\"6258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
		 ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
		 "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJE");
    add_srs_wkt (p, 7,
		 "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
		 "rigin\",0],PARAMETER[\"central_meridian\",24],PARAMETER[");
    add_srs_wkt (p, 9,
		 "\"scale_factor\",0.999923],PARAMETER[\"false_easting\",8");
    add_srs_wkt (p, 10,
		 "500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1");
    add_srs_wkt (p, 11,
		 ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"x\",NORTH],AXIS[\"");
    add_srs_wkt (p, 12, "y\",EAST],AUTHORITY[\"EPSG\",\"2179\"]]");
    p = add_epsg_def (filter, first, last, 2180, "epsg", 2180,
		      "ETRS89 / Poland CS92");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=19 +k=0.9993 +x_0=500000 +y_");
    add_proj4text (p, 1,
		   "0=-5300000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m ");
    add_proj4text (p, 2, "+no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"ETRS89 / Poland CS92\",GEOGCS[\"ETRS89\",DATUM[");
    add_srs_wkt (p, 1,
		 "\"European_Terrestrial_Reference_System_1989\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
		 "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"625");
    add_srs_wkt (p, 4,
		 "8\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
		 "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
		 ",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
		 "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 8,
		 "],PARAMETER[\"central_meridian\",19],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
		 "actor\",0.9993],PARAMETER[\"false_easting\",500000],PARA");
    add_srs_wkt (p, 10,
		 "METER[\"false_northing\",-5300000],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
		 "ORITY[\"EPSG\",\"9001\"]],AXIS[\"x\",NORTH],AXIS[\"y\",E");
    add_srs_wkt (p, 12, "AST],AUTHORITY[\"EPSG\",\"2180\"]]");
    p = add_epsg_def (filter, first, last, 2188, "epsg", 2188,
		      "Azores Occidental 1939 / UTM zone 25N");
    add_proj4text (p, 0,
		   "+proj=utm +zone=25 +ellps=intl +towgs84=-425,-169,81,0,0");
    add_proj4text (p, 1, ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Azores Occidental 1939 / UTM zone 25N\",GEOGCS[");
    add_srs_wkt (p, 1,
		 "\"Azores Occidental 1939\",DATUM[\"Azores_Occidental_Isl");
    add_srs_wkt (p, 2,
		 "ands_1939\",SPHEROID[\"International 1924\",6378388,297,");
    add_srs_wkt (p, 3,
		 "AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-425,-169,81,0,0,0");
    add_srs_wkt (p, 4,
		 ",0],AUTHORITY[\"EPSG\",\"6182\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 5,
		 ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
		 "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
		 "\",\"4182\"]],PROJECTION[\"Transverse_Mercator\"],PARAME");
    add_srs_wkt (p, 8,
		 "TER[\"latitude_of_origin\",0],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 9,
		 "an\",-33],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"");
    add_srs_wkt (p, 10,
		 "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 11,
		 "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Ea");
    add_srs_wkt (p, 12,
		 "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13, ",\"2188\"]]");
    p = add_epsg_def (filter, first, last, 2189, "epsg", 2189,
		      "Azores Central 1948 / UTM zone 26N");
    add_proj4text (p, 0,
		   "+proj=utm +zone=26 +ellps=intl +towgs84=-104,167,-38,0,0");
    add_proj4text (p, 1, ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Azores Central 1948 / UTM zone 26N\",GEOGCS[\"A");
    add_srs_wkt (p, 1,
		 "zores Central 1948\",DATUM[\"Azores_Central_Islands_1948");
    add_srs_wkt (p, 2,
		 "\",SPHEROID[\"International 1924\",6378388,297,AUTHORITY");
    add_srs_wkt (p, 3,
		 "[\"EPSG\",\"7022\"]],TOWGS84[-104,167,-38,0,0,0,0],AUTHO");
    add_srs_wkt (p, 4,
		 "RITY[\"EPSG\",\"6183\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
		 "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
		 ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4183");
    add_srs_wkt (p, 7,
		 "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 8,
		 "itude_of_origin\",0],PARAMETER[\"central_meridian\",-27]");
    add_srs_wkt (p, 9,
		 ",PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_ea");
    add_srs_wkt (p, 10,
		 "sting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
		 "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",");
    add_srs_wkt (p, 12,
		 "EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2189");
    add_srs_wkt (p, 13, "\"]]");
    p = add_epsg_def (filter, first, last, 2190, "epsg", 2190,
		      "Azores Oriental 1940 / UTM zone 26N");
    add_proj4text (p, 0,
		   "+proj=utm +zone=26 +ellps=intl +towgs84=-203,141,53,0,0,");
    add_proj4text (p, 1, "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Azores Oriental 1940 / UTM zone 26N\",GEOGCS[\"");
    add_srs_wkt (p, 1,
		 "Azores Oriental 1940\",DATUM[\"Azores_Oriental_Islands_1");
    add_srs_wkt (p, 2,
		 "940\",SPHEROID[\"International 1924\",6378388,297,AUTHOR");
    add_srs_wkt (p, 3,
		 "ITY[\"EPSG\",\"7022\"]],TOWGS84[-203,141,53,0,0,0,0],AUT");
    add_srs_wkt (p, 4,
		 "HORITY[\"EPSG\",\"6184\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
		 "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
		 "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"41");
    add_srs_wkt (p, 7,
		 "84\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
		 "atitude_of_origin\",0],PARAMETER[\"central_meridian\",-2");
    add_srs_wkt (p, 9,
		 "7],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
		 "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 11,
		 "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
		 ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"219");
    add_srs_wkt (p, 13, "0\"]]");
    p = add_epsg_def (filter, first, last, 2191, "epsg", 2191,
		      "Madeira 1936 / UTM zone 28N (deprecated)");
    add_proj4text (p, 0, "+proj=utm +zone=28 +ellps=intl +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Madeira 1936 / UTM zone 28N (deprecated)\",GEOG");
    add_srs_wkt (p, 1,
		 "CS[\"Madeira 1936\",DATUM[\"Madeira_1936\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
		 "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
		 "\"]],AUTHORITY[\"EPSG\",\"6185\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
		 "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
		 "2925199433,AUTHORITY[\"EPSG\",\"9108\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
		 "G\",\"4185\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
		 "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
		 "ian\",-15],PARAMETER[\"scale_factor\",0.9996],PARAMETER[");
    add_srs_wkt (p, 9,
		 "\"false_easting\",500000],PARAMETER[\"false_northing\",0");
    add_srs_wkt (p, 10,
		 "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
		 "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12, "G\",\"2191\"]]");
    p = add_epsg_def (filter, first, last, 2192, "epsg", 2192,
		      "ED50 / France EuroLambert");
    add_proj4text (p, 0,
		   "+proj=lcc +lat_1=46.8 +lat_0=46.8 +lon_0=2.3372291666666");
    add_proj4text (p, 1,
		   "67 +k_0=0.99987742 +x_0=600000 +y_0=2200000 +ellps=intl ");
    add_proj4text (p, 2, "+towgs84=-87,-98,-121,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"ED50 / France EuroLambert\",GEOGCS[\"ED50\",DAT");
    add_srs_wkt (p, 1,
		 "UM[\"European_Datum_1950\",SPHEROID[\"International 1924");
    add_srs_wkt (p, 2,
		 "\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-87");
    add_srs_wkt (p, 3,
		 ",-98,-121,0,0,0,0],AUTHORITY[\"EPSG\",\"6230\"]],PRIMEM[");
    add_srs_wkt (p, 4,
		 "\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"deg");
    add_srs_wkt (p, 5,
		 "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 6,
		 "UTHORITY[\"EPSG\",\"4230\"]],PROJECTION[\"Lambert_Confor");
    add_srs_wkt (p, 7,
		 "mal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",46.8],");
    add_srs_wkt (p, 8,
		 "PARAMETER[\"central_meridian\",2.337229166666667],PARAME");
    add_srs_wkt (p, 9,
		 "TER[\"scale_factor\",0.99987742],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
		 "ng\",600000],PARAMETER[\"false_northing\",2200000],UNIT[");
    add_srs_wkt (p, 11,
		 "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAS");
    add_srs_wkt (p, 12, "T],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"2192\"]]");
    p = add_epsg_def (filter, first, last, 2193, "epsg", 2193,
		      "NZGD2000 / New Zealand Transverse Mercator 2000");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=173 +k=0.9996 +x_0=1600000 +");
    add_proj4text (p, 1,
		   "y_0=10000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 2, "m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NZGD2000 / New Zealand Transverse Mercator 2000");
    add_srs_wkt (p, 1,
		 "\",GEOGCS[\"NZGD2000\",DATUM[\"New_Zealand_Geodetic_Datu");
    add_srs_wkt (p, 2,
		 "m_2000\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
		 "HORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHOR");
    add_srs_wkt (p, 4,
		 "ITY[\"EPSG\",\"6167\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 5,
		 "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 6,
		 "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4167\"");
    add_srs_wkt (p, 7,
		 "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 8,
		 "ude_of_origin\",0],PARAMETER[\"central_meridian\",173],P");
    add_srs_wkt (p, 9,
		 "ARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
		 "ing\",1600000],PARAMETER[\"false_northing\",10000000],UN");
    add_srs_wkt (p, 11,
		 "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Nort");
    add_srs_wkt (p, 12,
		 "hing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13, "\"2193\"]]");
    p = add_epsg_def (filter, first, last, 2194, "epsg", 2194,
		      "American Samoa 1962 / American Samoa Lambert (deprecated)");
    add_proj4text (p, 0,
		   "+proj=lcc +lat_1=-14.26666666666667 +lat_0=-14.266666666");
    add_proj4text (p, 1,
		   "66667 +lon_0=-170 +k_0=1 +x_0=152400.3048006096 +y_0=0 +");
    add_proj4text (p, 2,
		   "ellps=clrk66 +towgs84=-115,118,426,0,0,0,0 +units=us-ft ");
    add_proj4text (p, 3, "+no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"American Samoa 1962 / American Samoa Lambert (d");
    add_srs_wkt (p, 1,
		 "eprecated)\",GEOGCS[\"American Samoa 1962\",DATUM[\"Amer");
    add_srs_wkt (p, 2,
		 "ican_Samoa_1962\",SPHEROID[\"Clarke 1866\",6378206.4,294");
    add_srs_wkt (p, 3,
		 ".9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],TOWGS84[-11");
    add_srs_wkt (p, 4,
		 "5,118,426,0,0,0,0],AUTHORITY[\"EPSG\",\"6169\"]],PRIMEM[");
    add_srs_wkt (p, 5,
		 "\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"deg");
    add_srs_wkt (p, 6,
		 "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 7,
		 "UTHORITY[\"EPSG\",\"4169\"]],PROJECTION[\"Lambert_Confor");
    add_srs_wkt (p, 8,
		 "mal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",-14.26");
    add_srs_wkt (p, 9,
		 "666666666667],PARAMETER[\"central_meridian\",-170],PARAM");
    add_srs_wkt (p, 10,
		 "ETER[\"scale_factor\",1],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 11,
		 "000],PARAMETER[\"false_northing\",0],UNIT[\"US survey fo");
    add_srs_wkt (p, 12,
		 "ot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AX");
    add_srs_wkt (p, 13,
		 "IS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"21");
    add_srs_wkt (p, 14, "94\"]]");
    p = add_epsg_def (filter, first, last, 2195, "epsg", 2195,
		      "NAD83(HARN) / UTM zone 2S");
    add_proj4text (p, 0,
		   "+proj=utm +zone=2 +south +ellps=GRS80 +towgs84=0,0,0,0,0");
    add_proj4text (p, 1, ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83(HARN) / UTM zone 2S\",GEOGCS[\"NAD83(HARN");
    add_srs_wkt (p, 1,
		 ")\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",SPHE");
    add_srs_wkt (p, 2,
		 "ROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
		 "\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
		 "\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
		 "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
		 "PSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTIO");
    add_srs_wkt (p, 7,
		 "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
		 "n\",0],PARAMETER[\"central_meridian\",-171],PARAMETER[\"");
    add_srs_wkt (p, 9,
		 "scale_factor\",0.9996],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
		 "0],PARAMETER[\"false_northing\",10000000],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
		 ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 12,
		 "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2195\"]]");
    p = add_epsg_def (filter, first, last, 2196, "epsg", 2196,
		      "ETRS89 / Kp2000 Jutland");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=9.5 +k=0.99995 +x_0=200000 +");
    add_proj4text (p, 1,
		   "y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 2, "efs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"ETRS89 / Kp2000 Jutland\",GEOGCS[\"ETRS89\",DAT");
    add_srs_wkt (p, 1,
		 "UM[\"European_Terrestrial_Reference_System_1989\",SPHERO");
    add_srs_wkt (p, 2,
		 "ID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
		 ",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
		 "6258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
		 "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
		 "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[");
    add_srs_wkt (p, 7,
		 "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
		 ",0],PARAMETER[\"central_meridian\",9.5],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
		 "e_factor\",0.99995],PARAMETER[\"false_easting\",200000],");
    add_srs_wkt (p, 10,
		 "PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
		 "TY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nor");
    add_srs_wkt (p, 12, "thing\",NORTH],AUTHORITY[\"EPSG\",\"2196\"]]");
    p = add_epsg_def (filter, first, last, 2197, "epsg", 2197,
		      "ETRS89 / Kp2000 Zealand");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=12 +k=0.99995 +x_0=500000 +y");
    add_proj4text (p, 1,
		   "_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_de");
    add_proj4text (p, 2, "fs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"ETRS89 / Kp2000 Zealand\",GEOGCS[\"ETRS89\",DAT");
    add_srs_wkt (p, 1,
		 "UM[\"European_Terrestrial_Reference_System_1989\",SPHERO");
    add_srs_wkt (p, 2,
		 "ID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
		 ",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
		 "6258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
		 "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
		 "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[");
    add_srs_wkt (p, 7,
		 "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
		 ",0],PARAMETER[\"central_meridian\",12],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
		 "_factor\",0.99995],PARAMETER[\"false_easting\",500000],P");
    add_srs_wkt (p, 10,
		 "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
		 "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 12, "hing\",NORTH],AUTHORITY[\"EPSG\",\"2197\"]]");
    p = add_epsg_def (filter, first, last, 2198, "epsg", 2198,
		      "ETRS89 / Kp2000 Bornholm");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=900000 +y_0=0 +");
    add_proj4text (p, 1,
		   "ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"ETRS89 / Kp2000 Bornholm\",GEOGCS[\"ETRS89\",DA");
    add_srs_wkt (p, 1,
		 "TUM[\"European_Terrestrial_Reference_System_1989\",SPHER");
    add_srs_wkt (p, 2,
		 "OID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
		 ",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
		 "6258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
		 "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
		 "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[");
    add_srs_wkt (p, 7,
		 "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
		 ",0],PARAMETER[\"central_meridian\",15],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
		 "_factor\",1],PARAMETER[\"false_easting\",900000],PARAMET");
    add_srs_wkt (p, 10,
		 "ER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 11,
		 "SG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12, ",NORTH],AUTHORITY[\"EPSG\",\"2198\"]]");
    p = add_epsg_def (filter, first, last, 2199, "epsg", 2199,
		      "Albanian 1987 / Gauss Kruger zone 4 (deprecated)");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=4500000 +y_0=0 ");
    add_proj4text (p, 1, "+ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Albanian 1987 / Gauss Kruger zone 4 (deprecated");
    add_srs_wkt (p, 1,
		 ")\",GEOGCS[\"Albanian 1987\",DATUM[\"Albanian_1987\",SPH");
    add_srs_wkt (p, 2,
		 "EROID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
		 "\",\"7024\"]],AUTHORITY[\"EPSG\",\"6191\"]],PRIMEM[\"Gre");
    add_srs_wkt (p, 4,
		 "enwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
		 ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
		 "ITY[\"EPSG\",\"4191\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
		 "\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cent");
    add_srs_wkt (p, 8,
		 "ral_meridian\",21],PARAMETER[\"scale_factor\",1],PARAMET");
    add_srs_wkt (p, 9,
		 "ER[\"false_easting\",4500000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 10,
		 "\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 11,
		 "S[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"219");
    add_srs_wkt (p, 12, "9\"]]");
    p = add_epsg_def (filter, first, last, 2200, "epsg", 2200,
		      "ATS77 / New Brunswick Stereographic (ATS77)");
    add_proj4text (p, 0,
		   "+proj=sterea +lat_0=46.5 +lon_0=-66.5 +k=0.999912 +x_0=3");
    add_proj4text (p, 1,
		   "00000 +y_0=800000 +a=6378135 +b=6356750.304921594 +units");
    add_proj4text (p, 2, "=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"ATS77 / New Brunswick Stereographic (ATS77)\",G");
    add_srs_wkt (p, 1,
		 "EOGCS[\"ATS77\",DATUM[\"Average_Terrestrial_System_1977\"");
    add_srs_wkt (p, 2,
		 ",SPHEROID[\"Average Terrestrial System 1977\",6378135,29");
    add_srs_wkt (p, 3,
		 "8.257,AUTHORITY[\"EPSG\",\"7041\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
		 "6122\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
		 "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
		 "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4122\"]],PROJECTION[");
    add_srs_wkt (p, 7,
		 "\"Oblique_Stereographic\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
		 "n\",46.5],PARAMETER[\"central_meridian\",-66.5],PARAMETE");
    add_srs_wkt (p, 9,
		 "R[\"scale_factor\",0.999912],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
		 ",300000],PARAMETER[\"false_northing\",800000],UNIT[\"met");
    add_srs_wkt (p, 11,
		 "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 12,
		 "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2200\"");
    add_srs_wkt (p, 13, "]]");
    p = add_epsg_def (filter, first, last, 2201, "epsg", 2201,
		      "REGVEN / UTM zone 18N");
    add_proj4text (p, 0,
		   "+proj=utm +zone=18 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1, "units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"REGVEN / UTM zone 18N\",GEOGCS[\"REGVEN\",DATUM");
    add_srs_wkt (p, 1,
		 "[\"Red_Geodesica_Venezolana\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
		 "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[");
    add_srs_wkt (p, 3,
		 "0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6189\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
		 "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
		 ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
		 "ITY[\"EPSG\",\"4189\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
		 "\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cent");
    add_srs_wkt (p, 8,
		 "ral_meridian\",-75],PARAMETER[\"scale_factor\",0.9996],P");
    add_srs_wkt (p, 9,
		 "ARAMETER[\"false_easting\",500000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 10,
		 "thing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 11,
		 "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 12, "ITY[\"EPSG\",\"2201\"]]");
    p = add_epsg_def (filter, first, last, 2202, "epsg", 2202,
		      "REGVEN / UTM zone 19N");
    add_proj4text (p, 0,
		   "+proj=utm +zone=19 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1, "units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"REGVEN / UTM zone 19N\",GEOGCS[\"REGVEN\",DATUM");
    add_srs_wkt (p, 1,
		 "[\"Red_Geodesica_Venezolana\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
		 "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[");
    add_srs_wkt (p, 3,
		 "0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6189\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
		 "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
		 ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
		 "ITY[\"EPSG\",\"4189\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
		 "\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cent");
    add_srs_wkt (p, 8,
		 "ral_meridian\",-69],PARAMETER[\"scale_factor\",0.9996],P");
    add_srs_wkt (p, 9,
		 "ARAMETER[\"false_easting\",500000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 10,
		 "thing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 11,
		 "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 12, "ITY[\"EPSG\",\"2202\"]]");
    p = add_epsg_def (filter, first, last, 2203, "epsg", 2203,
		      "REGVEN / UTM zone 20N");
    add_proj4text (p, 0,
		   "+proj=utm +zone=20 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1, "units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"REGVEN / UTM zone 20N\",GEOGCS[\"REGVEN\",DATUM");
    add_srs_wkt (p, 1,
		 "[\"Red_Geodesica_Venezolana\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
		 "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[");
    add_srs_wkt (p, 3,
		 "0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6189\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
		 "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
		 ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
		 "ITY[\"EPSG\",\"4189\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
		 "\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cent");
    add_srs_wkt (p, 8,
		 "ral_meridian\",-63],PARAMETER[\"scale_factor\",0.9996],P");
    add_srs_wkt (p, 9,
		 "ARAMETER[\"false_easting\",500000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 10,
		 "thing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 11,
		 "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 12, "ITY[\"EPSG\",\"2203\"]]");
    p = add_epsg_def (filter, first, last, 2204, "epsg", 2204,
		      "NAD27 / Tennessee");
    add_proj4text (p, 0,
		   "+proj=lcc +lat_1=35.25 +lat_2=36.41666666666666 +lat_0=3");
    add_proj4text (p, 1,
		   "4.66666666666666 +lon_0=-86 +x_0=609601.2192024384 +y_0=");
    add_proj4text (p, 2,
		   "30480.06096012192 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD27 / Tennessee\",GEOGCS[\"NAD27\",DATUM[\"No");
    add_srs_wkt (p, 1,
		 "rth_American_Datum_1927\",SPHEROID[\"Clarke 1866\",63782");
    add_srs_wkt (p, 2,
		 "06.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],AUT");
    add_srs_wkt (p, 3,
		 "HORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
		 "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
		 "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 6,
		 "67\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAM");
    add_srs_wkt (p, 7,
		 "ETER[\"standard_parallel_1\",35.25],PARAMETER[\"standard");
    add_srs_wkt (p, 8,
		 "_parallel_2\",36.41666666666666],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 9,
		 "_origin\",34.66666666666666],PARAMETER[\"central_meridia");
    add_srs_wkt (p, 10,
		 "n\",-86],PARAMETER[\"false_easting\",2000000],PARAMETER[");
    add_srs_wkt (p, 11,
		 "\"false_northing\",100000],UNIT[\"US survey foot\",0.304");
    add_srs_wkt (p, 12,
		 "8006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",E");
    add_srs_wkt (p, 13, "AST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"2204\"]]");
    p = add_epsg_def (filter, first, last, 2205, "epsg", 2205,
		      "NAD83 / Kentucky North");
    add_proj4text (p, 0,
		   "+proj=lcc +lat_1=37.96666666666667 +lat_2=38.96666666666");
    add_proj4text (p, 1,
		   "667 +lat_0=37.5 +lon_0=-84.25 +x_0=500000 +y_0=0 +ellps=");
    add_proj4text (p, 2, "GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83 / Kentucky North\",GEOGCS[\"NAD83\",DATUM");
    add_srs_wkt (p, 1,
		 "[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637");
    add_srs_wkt (p, 2,
		 "8137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84");
    add_srs_wkt (p, 3,
		 "[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
		 "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
		 "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 6,
		 "ORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal");
    add_srs_wkt (p, 7,
		 "_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",37.96666");
    add_srs_wkt (p, 8,
		 "666666667],PARAMETER[\"standard_parallel_2\",38.96666666");
    add_srs_wkt (p, 9,
		 "666667],PARAMETER[\"latitude_of_origin\",37.5],PARAMETER");
    add_srs_wkt (p, 10,
		 "[\"central_meridian\",-84.25],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 11,
		 ",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 12,
		 "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"");
    add_srs_wkt (p, 13, "Y\",NORTH],AUTHORITY[\"EPSG\",\"2205\"]]");
    p = add_epsg_def (filter, first, last, 2206, "epsg", 2206,
		      "ED50 / 3-degree Gauss-Kruger zone 9");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=9500000 +y_0=0 ");
    add_proj4text (p, 1,
		   "+ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 2, "efs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"ED50 / 3-degree Gauss-Kruger zone 9\",GEOGCS[\"");
    add_srs_wkt (p, 1,
		 "ED50\",DATUM[\"European_Datum_1950\",SPHEROID[\"Internat");
    add_srs_wkt (p, 2,
		 "ional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],T");
    add_srs_wkt (p, 3,
		 "OWGS84[-87,-98,-121,0,0,0,0],AUTHORITY[\"EPSG\",\"6230\"");
    add_srs_wkt (p, 4,
		 "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
		 "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
		 "9122\"]],AUTHORITY[\"EPSG\",\"4230\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
		 "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
		 "ARAMETER[\"central_meridian\",27],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
		 "or\",1],PARAMETER[\"false_easting\",9500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
		 "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
		 "\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[");
    add_srs_wkt (p, 12, "\"EPSG\",\"2206\"]]");
    p = add_epsg_def (filter, first, last, 2207, "epsg", 2207,
		      "ED50 / 3-degree Gauss-Kruger zone 10");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=30 +k=1 +x_0=10500000 +y_0=0");
    add_proj4text (p, 1,
		   " +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2, "defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"ED50 / 3-degree Gauss-Kruger zone 10\",GEOGCS[\"");
    add_srs_wkt (p, 1,
		 "ED50\",DATUM[\"European_Datum_1950\",SPHEROID[\"Internat");
    add_srs_wkt (p, 2,
		 "ional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],T");
    add_srs_wkt (p, 3,
		 "OWGS84[-87,-98,-121,0,0,0,0],AUTHORITY[\"EPSG\",\"6230\"");
    add_srs_wkt (p, 4,
		 "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
		 "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
		 "9122\"]],AUTHORITY[\"EPSG\",\"4230\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
		 "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
		 "ARAMETER[\"central_meridian\",30],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
		 "or\",1],PARAMETER[\"false_easting\",10500000],PARAMETER[");
    add_srs_wkt (p, 10,
		 "\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 11,
		 ",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY");
    add_srs_wkt (p, 12, "[\"EPSG\",\"2207\"]]");
    p = add_epsg_def (filter, first, last, 2208, "epsg", 2208,
		      "ED50 / 3-degree Gauss-Kruger zone 11");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=11500000 +y_0=0");
    add_proj4text (p, 1,
		   " +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2, "defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"ED50 / 3-degree Gauss-Kruger zone 11\",GEOGCS[\"");
    add_srs_wkt (p, 1,
		 "ED50\",DATUM[\"European_Datum_1950\",SPHEROID[\"Internat");
    add_srs_wkt (p, 2,
		 "ional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],T");
    add_srs_wkt (p, 3,
		 "OWGS84[-87,-98,-121,0,0,0,0],AUTHORITY[\"EPSG\",\"6230\"");
    add_srs_wkt (p, 4,
		 "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
		 "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
		 "9122\"]],AUTHORITY[\"EPSG\",\"4230\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
		 "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
		 "ARAMETER[\"central_meridian\",33],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
		 "or\",1],PARAMETER[\"false_easting\",11500000],PARAMETER[");
    add_srs_wkt (p, 10,
		 "\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 11,
		 ",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY");
    add_srs_wkt (p, 12, "[\"EPSG\",\"2208\"]]");
}

static void
initialize_epsg_02 (int filter, struct epsg_defs **first,
		    struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def (filter, first, last, 2209, "epsg", 2209,
		      "ED50 / 3-degree Gauss-Kruger zone 12");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=36 +k=1 +x_0=12500000 +y_0=0");
    add_proj4text (p, 1,
		   " +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2, "defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"ED50 / 3-degree Gauss-Kruger zone 12\",GEOGCS[\"");
    add_srs_wkt (p, 1,
		 "ED50\",DATUM[\"European_Datum_1950\",SPHEROID[\"Internat");
    add_srs_wkt (p, 2,
		 "ional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],T");
    add_srs_wkt (p, 3,
		 "OWGS84[-87,-98,-121,0,0,0,0],AUTHORITY[\"EPSG\",\"6230\"");
    add_srs_wkt (p, 4,
		 "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
		 "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
		 "9122\"]],AUTHORITY[\"EPSG\",\"4230\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
		 "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
		 "ARAMETER[\"central_meridian\",36],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
		 "or\",1],PARAMETER[\"false_easting\",12500000],PARAMETER[");
    add_srs_wkt (p, 10,
		 "\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 11,
		 ",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY");
    add_srs_wkt (p, 12, "[\"EPSG\",\"2209\"]]");
    p = add_epsg_def (filter, first, last, 2210, "epsg", 2210,
		      "ED50 / 3-degree Gauss-Kruger zone 13");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=13500000 +y_0=0");
    add_proj4text (p, 1,
		   " +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2, "defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"ED50 / 3-degree Gauss-Kruger zone 13\",GEOGCS[\"");
    add_srs_wkt (p, 1,
		 "ED50\",DATUM[\"European_Datum_1950\",SPHEROID[\"Internat");
    add_srs_wkt (p, 2,
		 "ional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],T");
    add_srs_wkt (p, 3,
		 "OWGS84[-87,-98,-121,0,0,0,0],AUTHORITY[\"EPSG\",\"6230\"");
    add_srs_wkt (p, 4,
		 "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
		 "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
		 "9122\"]],AUTHORITY[\"EPSG\",\"4230\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
		 "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
		 "ARAMETER[\"central_meridian\",39],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
		 "or\",1],PARAMETER[\"false_easting\",13500000],PARAMETER[");
    add_srs_wkt (p, 10,
		 "\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 11,
		 ",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY");
    add_srs_wkt (p, 12, "[\"EPSG\",\"2210\"]]");
    p = add_epsg_def (filter, first, last, 2211, "epsg", 2211,
		      "ED50 / 3-degree Gauss-Kruger zone 14");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=42 +k=1 +x_0=14500000 +y_0=0");
    add_proj4text (p, 1,
		   " +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2, "defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"ED50 / 3-degree Gauss-Kruger zone 14\",GEOGCS[\"");
    add_srs_wkt (p, 1,
		 "ED50\",DATUM[\"European_Datum_1950\",SPHEROID[\"Internat");
    add_srs_wkt (p, 2,
		 "ional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],T");
    add_srs_wkt (p, 3,
		 "OWGS84[-87,-98,-121,0,0,0,0],AUTHORITY[\"EPSG\",\"6230\"");
    add_srs_wkt (p, 4,
		 "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
		 "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
		 "9122\"]],AUTHORITY[\"EPSG\",\"4230\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
		 "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
		 "ARAMETER[\"central_meridian\",42],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
		 "or\",1],PARAMETER[\"false_easting\",14500000],PARAMETER[");
    add_srs_wkt (p, 10,
		 "\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 11,
		 ",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY");
    add_srs_wkt (p, 12, "[\"EPSG\",\"2211\"]]");
    p = add_epsg_def (filter, first, last, 2212, "epsg", 2212,
		      "ED50 / 3-degree Gauss-Kruger zone 15");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=15500000 +y_0=0");
    add_proj4text (p, 1,
		   " +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2, "defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"ED50 / 3-degree Gauss-Kruger zone 15\",GEOGCS[\"");
    add_srs_wkt (p, 1,
		 "ED50\",DATUM[\"European_Datum_1950\",SPHEROID[\"Internat");
    add_srs_wkt (p, 2,
		 "ional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],T");
    add_srs_wkt (p, 3,
		 "OWGS84[-87,-98,-121,0,0,0,0],AUTHORITY[\"EPSG\",\"6230\"");
    add_srs_wkt (p, 4,
		 "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
		 "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
		 "9122\"]],AUTHORITY[\"EPSG\",\"4230\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
		 "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
		 "ARAMETER[\"central_meridian\",45],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
		 "or\",1],PARAMETER[\"false_easting\",15500000],PARAMETER[");
    add_srs_wkt (p, 10,
		 "\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 11,
		 ",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY");
    add_srs_wkt (p, 12, "[\"EPSG\",\"2212\"]]");
    p = add_epsg_def (filter, first, last, 2213, "epsg", 2213,
		      "ETRS89 / TM 30 NE");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=30 +k=0.9996 +x_0=500000 +y_");
    add_proj4text (p, 1,
		   "0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 2, "s");
    add_srs_wkt (p, 0,
		 "PROJCS[\"ETRS89 / TM 30 NE\",GEOGCS[\"ETRS89\",DATUM[\"E");
    add_srs_wkt (p, 1,
		 "uropean_Terrestrial_Reference_System_1989\",SPHEROID[\"G");
    add_srs_wkt (p, 2,
		 "RS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"701");
    add_srs_wkt (p, 3,
		 "9\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"");
    add_srs_wkt (p, 4,
		 "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
		 "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
		 "9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
		 "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
		 "ARAMETER[\"central_meridian\",30],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
		 "or\",0.9996],PARAMETER[\"false_easting\",500000],PARAMET");
    add_srs_wkt (p, 10,
		 "ER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 11,
		 "SG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12, ",NORTH],AUTHORITY[\"EPSG\",\"2213\"]]");
    p = add_epsg_def (filter, first, last, 2214, "epsg", 2214,
		      "Douala 1948 / AOF west (deprecated)");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=10.5 +k=0.999 +x_0=1000000 +");
    add_proj4text (p, 1,
		   "y_0=1000000 +ellps=intl +towgs84=-206.1,-174.7,-87.7,0,0");
    add_proj4text (p, 2, ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Douala 1948 / AOF west (deprecated)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
		 "Douala 1948\",DATUM[\"Douala_1948\",SPHEROID[\"Internati");
    add_srs_wkt (p, 2,
		 "onal 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TO");
    add_srs_wkt (p, 3,
		 "WGS84[-206.1,-174.7,-87.7,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
		 "6192\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
		 "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
		 "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4192\"]],PROJECTION[");
    add_srs_wkt (p, 7,
		 "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
		 ",0],PARAMETER[\"central_meridian\",10.5],PARAMETER[\"sca");
    add_srs_wkt (p, 9,
		 "le_factor\",0.999],PARAMETER[\"false_easting\",1000000],");
    add_srs_wkt (p, 10,
		 "PARAMETER[\"false_northing\",1000000],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
		 "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 12, "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2214\"]]");
    p = add_epsg_def (filter, first, last, 2215, "epsg", 2215,
		      "Manoca 1962 / UTM zone 32N");
    add_proj4text (p, 0,
		   "+proj=utm +zone=32 +a=6378249.2 +b=6356515 +towgs84=-70.");
    add_proj4text (p, 1, "9,-151.8,-41.4,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Manoca 1962 / UTM zone 32N\",GEOGCS[\"Manoca 19");
    add_srs_wkt (p, 1,
		 "62\",DATUM[\"Manoca_1962\",SPHEROID[\"Clarke 1880 (IGN)\"");
    add_srs_wkt (p, 2,
		 ",6378249.2,293.4660212936269,AUTHORITY[\"EPSG\",\"7011\"");
    add_srs_wkt (p, 3,
		 "]],TOWGS84[-70.9,-151.8,-41.4,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
		 ",\"6193\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
		 "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
		 "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4193\"]],PROJECTI");
    add_srs_wkt (p, 7,
		 "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
		 "in\",0],PARAMETER[\"central_meridian\",9],PARAMETER[\"sc");
    add_srs_wkt (p, 9,
		 "ale_factor\",0.9996],PARAMETER[\"false_easting\",500000]");
    add_srs_wkt (p, 10,
		 ",PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 11,
		 "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 12, "rthing\",NORTH],AUTHORITY[\"EPSG\",\"2215\"]]");
    p = add_epsg_def (filter, first, last, 2216, "epsg", 2216,
		      "Qornoq 1927 / UTM zone 22N");
    add_proj4text (p, 0,
		   "+proj=utm +zone=22 +ellps=intl +towgs84=164,138,-189,0,0");
    add_proj4text (p, 1, ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Qornoq 1927 / UTM zone 22N\",GEOGCS[\"Qornoq 19");
    add_srs_wkt (p, 1,
		 "27\",DATUM[\"Qornoq_1927\",SPHEROID[\"International 1924");
    add_srs_wkt (p, 2,
		 "\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[164");
    add_srs_wkt (p, 3,
		 ",138,-189,0,0,0,0],AUTHORITY[\"EPSG\",\"6194\"]],PRIMEM[");
    add_srs_wkt (p, 4,
		 "\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"deg");
    add_srs_wkt (p, 5,
		 "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 6,
		 "UTHORITY[\"EPSG\",\"4194\"]],PROJECTION[\"Transverse_Mer");
    add_srs_wkt (p, 7,
		 "cator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "central_meridian\",-51],PARAMETER[\"scale_factor\",0.999");
    add_srs_wkt (p, 9,
		 "6],PARAMETER[\"false_easting\",500000],PARAMETER[\"false");
    add_srs_wkt (p, 10,
		 "_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 11,
		 "1\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 12, "THORITY[\"EPSG\",\"2216\"]]");
    p = add_epsg_def (filter, first, last, 2217, "epsg", 2217,
		      "Qornoq 1927 / UTM zone 23N");
    add_proj4text (p, 0,
		   "+proj=utm +zone=23 +ellps=intl +towgs84=164,138,-189,0,0");
    add_proj4text (p, 1, ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Qornoq 1927 / UTM zone 23N\",GEOGCS[\"Qornoq 19");
    add_srs_wkt (p, 1,
		 "27\",DATUM[\"Qornoq_1927\",SPHEROID[\"International 1924");
    add_srs_wkt (p, 2,
		 "\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[164");
    add_srs_wkt (p, 3,
		 ",138,-189,0,0,0,0],AUTHORITY[\"EPSG\",\"6194\"]],PRIMEM[");
    add_srs_wkt (p, 4,
		 "\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"deg");
    add_srs_wkt (p, 5,
		 "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 6,
		 "UTHORITY[\"EPSG\",\"4194\"]],PROJECTION[\"Transverse_Mer");
    add_srs_wkt (p, 7,
		 "cator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "central_meridian\",-45],PARAMETER[\"scale_factor\",0.999");
    add_srs_wkt (p, 9,
		 "6],PARAMETER[\"false_easting\",500000],PARAMETER[\"false");
    add_srs_wkt (p, 10,
		 "_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 11,
		 "1\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 12, "THORITY[\"EPSG\",\"2217\"]]");
    p = add_epsg_def (filter, first, last, 2219, "epsg", 2219,
		      "ATS77 / UTM zone 19N");
    add_proj4text (p, 0,
		   "+proj=utm +zone=19 +a=6378135 +b=6356750.304921594 +unit");
    add_proj4text (p, 1, "s=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"ATS77 / UTM zone 19N\",GEOGCS[\"ATS77\",DATUM[\"");
    add_srs_wkt (p, 1,
		 "Average_Terrestrial_System_1977\",SPHEROID[\"Average Ter");
    add_srs_wkt (p, 2,
		 "restrial System 1977\",6378135,298.257,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
		 ",\"7041\"]],AUTHORITY[\"EPSG\",\"6122\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
		 "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
		 ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
		 "Y[\"EPSG\",\"4122\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
		 "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
		 "l_meridian\",-69],PARAMETER[\"scale_factor\",0.9996],PAR");
    add_srs_wkt (p, 9,
		 "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
		 "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
		 "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 12, "Y[\"EPSG\",\"2219\"]]");
    p = add_epsg_def (filter, first, last, 2220, "epsg", 2220,
		      "ATS77 / UTM zone 20N");
    add_proj4text (p, 0,
		   "+proj=utm +zone=20 +a=6378135 +b=6356750.304921594 +unit");
    add_proj4text (p, 1, "s=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"ATS77 / UTM zone 20N\",GEOGCS[\"ATS77\",DATUM[\"");
    add_srs_wkt (p, 1,
		 "Average_Terrestrial_System_1977\",SPHEROID[\"Average Ter");
    add_srs_wkt (p, 2,
		 "restrial System 1977\",6378135,298.257,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
		 ",\"7041\"]],AUTHORITY[\"EPSG\",\"6122\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
		 "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
		 ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
		 "Y[\"EPSG\",\"4122\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
		 "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
		 "l_meridian\",-63],PARAMETER[\"scale_factor\",0.9996],PAR");
    add_srs_wkt (p, 9,
		 "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
		 "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
		 "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 12, "Y[\"EPSG\",\"2220\"]]");
    p = add_epsg_def (filter, first, last, 2222, "epsg", 2222,
		      "NAD83 / Arizona East (ft)");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=31 +lon_0=-110.1666666666667 +k=0.999");
    add_proj4text (p, 1,
		   "9 +x_0=213360 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0");
    add_proj4text (p, 2, " +units=ft +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83 / Arizona East (ft)\",GEOGCS[\"NAD83\",DA");
    add_srs_wkt (p, 1,
		 "TUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",");
    add_srs_wkt (p, 2,
		 "6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWG");
    add_srs_wkt (p, 3,
		 "S84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[");
    add_srs_wkt (p, 4,
		 "\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"deg");
    add_srs_wkt (p, 5,
		 "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 6,
		 "UTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mer");
    add_srs_wkt (p, 7,
		 "cator\"],PARAMETER[\"latitude_of_origin\",31],PARAMETER[");
    add_srs_wkt (p, 8,
		 "\"central_meridian\",-110.1666666666667],PARAMETER[\"sca");
    add_srs_wkt (p, 9,
		 "le_factor\",0.9999],PARAMETER[\"false_easting\",700000],");
    add_srs_wkt (p, 10,
		 "PARAMETER[\"false_northing\",0],UNIT[\"foot\",0.3048,AUT");
    add_srs_wkt (p, 11,
		 "HORITY[\"EPSG\",\"9002\"]],AXIS[\"X\",EAST],AXIS[\"Y\",N");
    add_srs_wkt (p, 12, "ORTH],AUTHORITY[\"EPSG\",\"2222\"]]");
    p = add_epsg_def (filter, first, last, 2223, "epsg", 2223,
		      "NAD83 / Arizona Central (ft)");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=31 +lon_0=-111.9166666666667 +k=0.999");
    add_proj4text (p, 1,
		   "9 +x_0=213360 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0");
    add_proj4text (p, 2, " +units=ft +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83 / Arizona Central (ft)\",GEOGCS[\"NAD83\"");
    add_srs_wkt (p, 1,
		 ",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
		 "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
		 "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIM");
    add_srs_wkt (p, 4,
		 "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
		 "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
		 "],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
		 "Mercator\"],PARAMETER[\"latitude_of_origin\",31],PARAMET");
    add_srs_wkt (p, 8,
		 "ER[\"central_meridian\",-111.9166666666667],PARAMETER[\"");
    add_srs_wkt (p, 9,
		 "scale_factor\",0.9999],PARAMETER[\"false_easting\",70000");
    add_srs_wkt (p, 10,
		 "0],PARAMETER[\"false_northing\",0],UNIT[\"foot\",0.3048,");
    add_srs_wkt (p, 11,
		 "AUTHORITY[\"EPSG\",\"9002\"]],AXIS[\"X\",EAST],AXIS[\"Y\"");
    add_srs_wkt (p, 12, ",NORTH],AUTHORITY[\"EPSG\",\"2223\"]]");
    p = add_epsg_def (filter, first, last, 2224, "epsg", 2224,
		      "NAD83 / Arizona West (ft)");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=31 +lon_0=-113.75 +k=0.999933333 +x_0");
    add_proj4text (p, 1,
		   "=213360 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +unit");
    add_proj4text (p, 2, "s=ft +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83 / Arizona West (ft)\",GEOGCS[\"NAD83\",DA");
    add_srs_wkt (p, 1,
		 "TUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",");
    add_srs_wkt (p, 2,
		 "6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWG");
    add_srs_wkt (p, 3,
		 "S84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[");
    add_srs_wkt (p, 4,
		 "\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"deg");
    add_srs_wkt (p, 5,
		 "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 6,
		 "UTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mer");
    add_srs_wkt (p, 7,
		 "cator\"],PARAMETER[\"latitude_of_origin\",31],PARAMETER[");
    add_srs_wkt (p, 8,
		 "\"central_meridian\",-113.75],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 9,
		 ",0.999933333],PARAMETER[\"false_easting\",700000],PARAME");
    add_srs_wkt (p, 10,
		 "TER[\"false_northing\",0],UNIT[\"foot\",0.3048,AUTHORITY");
    add_srs_wkt (p, 11,
		 "[\"EPSG\",\"9002\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],");
    add_srs_wkt (p, 12, "AUTHORITY[\"EPSG\",\"2224\"]]");
    p = add_epsg_def (filter, first, last, 2225, "epsg", 2225,
		      "NAD83 / California zone 1 (ftUS)");
    add_proj4text (p, 0,
		   "+proj=lcc +lat_1=41.66666666666666 +lat_2=40 +lat_0=39.3");
    add_proj4text (p, 1,
		   "3333333333334 +lon_0=-122 +x_0=2000000.0001016 +y_0=5000");
    add_proj4text (p, 2,
		   "00.0001016001 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units");
    add_proj4text (p, 3, "=us-ft +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83 / California zone 1 (ftUS)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
		 "83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 2,
		 "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
		 "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],");
    add_srs_wkt (p, 4,
		 "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
		 "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
		 "2\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert");
    add_srs_wkt (p, 7,
		 "_Conformal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\"");
    add_srs_wkt (p, 8,
		 ",41.66666666666666],PARAMETER[\"standard_parallel_2\",40");
    add_srs_wkt (p, 9,
		 "],PARAMETER[\"latitude_of_origin\",39.33333333333334],PA");
    add_srs_wkt (p, 10,
		 "RAMETER[\"central_meridian\",-122],PARAMETER[\"false_eas");
    add_srs_wkt (p, 11,
		 "ting\",6561666.667],PARAMETER[\"false_northing\",1640416");
    add_srs_wkt (p, 12,
		 ".667],UNIT[\"US survey foot\",0.3048006096012192,AUTHORI");
    add_srs_wkt (p, 13,
		 "TY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH");
    add_srs_wkt (p, 14, "],AUTHORITY[\"EPSG\",\"2225\"]]");
    p = add_epsg_def (filter, first, last, 2226, "epsg", 2226,
		      "NAD83 / California zone 2 (ftUS)");
    add_proj4text (p, 0,
		   "+proj=lcc +lat_1=39.83333333333334 +lat_2=38.33333333333");
    add_proj4text (p, 1,
		   "334 +lat_0=37.66666666666666 +lon_0=-122 +x_0=2000000.00");
    add_proj4text (p, 2,
		   "01016 +y_0=500000.0001016001 +ellps=GRS80 +towgs84=0,0,0");
    add_proj4text (p, 3, ",0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83 / California zone 2 (ftUS)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
		 "83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 2,
		 "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
		 "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],");
    add_srs_wkt (p, 4,
		 "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
		 "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
		 "2\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert");
    add_srs_wkt (p, 7,
		 "_Conformal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\"");
    add_srs_wkt (p, 8,
		 ",39.83333333333334],PARAMETER[\"standard_parallel_2\",38");
    add_srs_wkt (p, 9,
		 ".33333333333334],PARAMETER[\"latitude_of_origin\",37.666");
    add_srs_wkt (p, 10,
		 "66666666666],PARAMETER[\"central_meridian\",-122],PARAME");
    add_srs_wkt (p, 11,
		 "TER[\"false_easting\",6561666.667],PARAMETER[\"false_nor");
    add_srs_wkt (p, 12,
		 "thing\",1640416.667],UNIT[\"US survey foot\",0.304800609");
    add_srs_wkt (p, 13,
		 "6012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],A");
    add_srs_wkt (p, 14, "XIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"2226\"]]");
    p = add_epsg_def (filter, first, last, 2227, "epsg", 2227,
		      "NAD83 / California zone 3 (ftUS)");
    add_proj4text (p, 0,
		   "+proj=lcc +lat_1=38.43333333333333 +lat_2=37.06666666666");
    add_proj4text (p, 1,
		   "667 +lat_0=36.5 +lon_0=-120.5 +x_0=2000000.0001016 +y_0=");
    add_proj4text (p, 2,
		   "500000.0001016001 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +u");
    add_proj4text (p, 3, "nits=us-ft +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83 / California zone 3 (ftUS)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
		 "83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 2,
		 "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
		 "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],");
    add_srs_wkt (p, 4,
		 "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
		 "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
		 "2\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert");
    add_srs_wkt (p, 7,
		 "_Conformal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\"");
    add_srs_wkt (p, 8,
		 ",38.43333333333333],PARAMETER[\"standard_parallel_2\",37");
    add_srs_wkt (p, 9,
		 ".06666666666667],PARAMETER[\"latitude_of_origin\",36.5],");
    add_srs_wkt (p, 10,
		 "PARAMETER[\"central_meridian\",-120.5],PARAMETER[\"false");
    add_srs_wkt (p, 11,
		 "_easting\",6561666.667],PARAMETER[\"false_northing\",164");
    add_srs_wkt (p, 12,
		 "0416.667],UNIT[\"US survey foot\",0.3048006096012192,AUT");
    add_srs_wkt (p, 13,
		 "HORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",N");
    add_srs_wkt (p, 14, "ORTH],AUTHORITY[\"EPSG\",\"2227\"]]");
    p = add_epsg_def (filter, first, last, 2228, "epsg", 2228,
		      "NAD83 / California zone 4 (ftUS)");
    add_proj4text (p, 0,
		   "+proj=lcc +lat_1=37.25 +lat_2=36 +lat_0=35.3333333333333");
    add_proj4text (p, 1,
		   "4 +lon_0=-119 +x_0=2000000.0001016 +y_0=500000.000101600");
    add_proj4text (p, 2,
		   "1 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_d");
    add_proj4text (p, 3, "efs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83 / California zone 4 (ftUS)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
		 "83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 2,
		 "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
		 "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],");
    add_srs_wkt (p, 4,
		 "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
		 "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
		 "2\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert");
    add_srs_wkt (p, 7,
		 "_Conformal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\"");
    add_srs_wkt (p, 8,
		 ",37.25],PARAMETER[\"standard_parallel_2\",36],PARAMETER[");
    add_srs_wkt (p, 9,
		 "\"latitude_of_origin\",35.33333333333334],PARAMETER[\"ce");
    add_srs_wkt (p, 10,
		 "ntral_meridian\",-119],PARAMETER[\"false_easting\",65616");
    add_srs_wkt (p, 11,
		 "66.667],PARAMETER[\"false_northing\",1640416.667],UNIT[\"");
    add_srs_wkt (p, 12,
		 "US survey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
		 "9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 14, "EPSG\",\"2228\"]]");
    p = add_epsg_def (filter, first, last, 2229, "epsg", 2229,
		      "NAD83 / California zone 5 (ftUS)");
    add_proj4text (p, 0,
		   "+proj=lcc +lat_1=35.46666666666667 +lat_2=34.03333333333");
    add_proj4text (p, 1,
		   "333 +lat_0=33.5 +lon_0=-118 +x_0=2000000.0001016 +y_0=50");
    add_proj4text (p, 2,
		   "0000.0001016001 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +uni");
    add_proj4text (p, 3, "ts=us-ft +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83 / California zone 5 (ftUS)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
		 "83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 2,
		 "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
		 "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],");
    add_srs_wkt (p, 4,
		 "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
		 "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
		 "2\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert");
    add_srs_wkt (p, 7,
		 "_Conformal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\"");
    add_srs_wkt (p, 8,
		 ",35.46666666666667],PARAMETER[\"standard_parallel_2\",34");
    add_srs_wkt (p, 9,
		 ".03333333333333],PARAMETER[\"latitude_of_origin\",33.5],");
    add_srs_wkt (p, 10,
		 "PARAMETER[\"central_meridian\",-118],PARAMETER[\"false_e");
    add_srs_wkt (p, 11,
		 "asting\",6561666.667],PARAMETER[\"false_northing\",16404");
    add_srs_wkt (p, 12,
		 "16.667],UNIT[\"US survey foot\",0.3048006096012192,AUTHO");
    add_srs_wkt (p, 13,
		 "RITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NOR");
    add_srs_wkt (p, 14, "TH],AUTHORITY[\"EPSG\",\"2229\"]]");
    p = add_epsg_def (filter, first, last, 2230, "epsg", 2230,
		      "NAD83 / California zone 6 (ftUS)");
    add_proj4text (p, 0,
		   "+proj=lcc +lat_1=33.88333333333333 +lat_2=32.78333333333");
    add_proj4text (p, 1,
		   "333 +lat_0=32.16666666666666 +lon_0=-116.25 +x_0=2000000");
    add_proj4text (p, 2,
		   ".0001016 +y_0=500000.0001016001 +ellps=GRS80 +towgs84=0,");
    add_proj4text (p, 3, "0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83 / California zone 6 (ftUS)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
		 "83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 2,
		 "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
		 "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],");
    add_srs_wkt (p, 4,
		 "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
		 "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
		 "2\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert");
    add_srs_wkt (p, 7,
		 "_Conformal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\"");
    add_srs_wkt (p, 8,
		 ",33.88333333333333],PARAMETER[\"standard_parallel_2\",32");
    add_srs_wkt (p, 9,
		 ".78333333333333],PARAMETER[\"latitude_of_origin\",32.166");
    add_srs_wkt (p, 10,
		 "66666666666],PARAMETER[\"central_meridian\",-116.25],PAR");
    add_srs_wkt (p, 11,
		 "AMETER[\"false_easting\",6561666.667],PARAMETER[\"false_");
    add_srs_wkt (p, 12,
		 "northing\",1640416.667],UNIT[\"US survey foot\",0.304800");
    add_srs_wkt (p, 13,
		 "6096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST");
    add_srs_wkt (p, 14, "],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"2230\"]]");
    p = add_epsg_def (filter, first, last, 2231, "epsg", 2231,
		      "NAD83 / Colorado North (ftUS)");
    add_proj4text (p, 0,
		   "+proj=lcc +lat_1=40.78333333333333 +lat_2=39.71666666666");
    add_proj4text (p, 1,
		   "667 +lat_0=39.33333333333334 +lon_0=-105.5 +x_0=914401.8");
    add_proj4text (p, 2,
		   "288036576 +y_0=304800.6096012192 +ellps=GRS80 +towgs84=0");
    add_proj4text (p, 3, ",0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83 / Colorado North (ftUS)\",GEOGCS[\"NAD83\"");
    add_srs_wkt (p, 1,
		 ",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
		 "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
		 "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIM");
    add_srs_wkt (p, 4,
		 "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
		 "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
		 "],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 7,
		 "formal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",40");
    add_srs_wkt (p, 8,
		 ".78333333333333],PARAMETER[\"standard_parallel_2\",39.71");
    add_srs_wkt (p, 9,
		 "666666666667],PARAMETER[\"latitude_of_origin\",39.333333");
    add_srs_wkt (p, 10,
		 "33333334],PARAMETER[\"central_meridian\",-105.5],PARAMET");
    add_srs_wkt (p, 11,
		 "ER[\"false_easting\",3000000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 12,
		 "\",1000000],UNIT[\"US survey foot\",0.3048006096012192,A");
    add_srs_wkt (p, 13,
		 "UTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\"");
    add_srs_wkt (p, 14, ",NORTH],AUTHORITY[\"EPSG\",\"2231\"]]");
    p = add_epsg_def (filter, first, last, 2232, "epsg", 2232,
		      "NAD83 / Colorado Central (ftUS)");
    add_proj4text (p, 0,
		   "+proj=lcc +lat_1=39.75 +lat_2=38.45 +lat_0=37.8333333333");
    add_proj4text (p, 1,
		   "3334 +lon_0=-105.5 +x_0=914401.8288036576 +y_0=304800.60");
    add_proj4text (p, 2,
		   "96012192 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-f");
    add_proj4text (p, 3, "t +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83 / Colorado Central (ftUS)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
		 "3\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 2,
		 "980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]");
    add_srs_wkt (p, 3,
		 "],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],P");
    add_srs_wkt (p, 4,
		 "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
		 "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
		 "\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_");
    add_srs_wkt (p, 7,
		 "Conformal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\"");
    add_srs_wkt (p, 8,
		 ",39.75],PARAMETER[\"standard_parallel_2\",38.45],PARAMET");
    add_srs_wkt (p, 9,
		 "ER[\"latitude_of_origin\",37.83333333333334],PARAMETER[\"");
    add_srs_wkt (p, 10,
		 "central_meridian\",-105.5],PARAMETER[\"false_easting\",3");
    add_srs_wkt (p, 11,
		 "000000],PARAMETER[\"false_northing\",1000000],UNIT[\"US ");
    add_srs_wkt (p, 12,
		 "survey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 13,
		 "03\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EP");
    add_srs_wkt (p, 14, "SG\",\"2232\"]]");
    p = add_epsg_def (filter, first, last, 2233, "epsg", 2233,
		      "NAD83 / Colorado South (ftUS)");
    add_proj4text (p, 0,
		   "+proj=lcc +lat_1=38.43333333333333 +lat_2=37.23333333333");
    add_proj4text (p, 1,
		   "333 +lat_0=36.66666666666666 +lon_0=-105.5 +x_0=914401.8");
    add_proj4text (p, 2,
		   "288036576 +y_0=304800.6096012192 +ellps=GRS80 +towgs84=0");
    add_proj4text (p, 3, ",0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83 / Colorado South (ftUS)\",GEOGCS[\"NAD83\"");
    add_srs_wkt (p, 1,
		 ",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
		 "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
		 "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIM");
    add_srs_wkt (p, 4,
		 "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
		 "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
		 "],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 7,
		 "formal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",38");
    add_srs_wkt (p, 8,
		 ".43333333333333],PARAMETER[\"standard_parallel_2\",37.23");
    add_srs_wkt (p, 9,
		 "333333333333],PARAMETER[\"latitude_of_origin\",36.666666");
    add_srs_wkt (p, 10,
		 "66666666],PARAMETER[\"central_meridian\",-105.5],PARAMET");
    add_srs_wkt (p, 11,
		 "ER[\"false_easting\",3000000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 12,
		 "\",1000000],UNIT[\"US survey foot\",0.3048006096012192,A");
    add_srs_wkt (p, 13,
		 "UTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\"");
    add_srs_wkt (p, 14, ",NORTH],AUTHORITY[\"EPSG\",\"2233\"]]");
    p = add_epsg_def (filter, first, last, 2234, "epsg", 2234,
		      "NAD83 / Connecticut (ftUS)");
    add_proj4text (p, 0,
		   "+proj=lcc +lat_1=41.86666666666667 +lat_2=41.2 +lat_0=40");
    add_proj4text (p, 1,
		   ".83333333333334 +lon_0=-72.75 +x_0=304800.6096012192 +y_");
    add_proj4text (p, 2,
		   "0=152400.3048006096 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 ");
    add_proj4text (p, 3, "+units=us-ft +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83 / Connecticut (ftUS)\",GEOGCS[\"NAD83\",D");
    add_srs_wkt (p, 1,
		 "ATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
		 ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOW");
    add_srs_wkt (p, 3,
		 "GS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM");
    add_srs_wkt (p, 4,
		 "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
		 "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
		 "AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Confo");
    add_srs_wkt (p, 7,
		 "rmal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",41.8");
    add_srs_wkt (p, 8,
		 "6666666666667],PARAMETER[\"standard_parallel_2\",41.2],P");
    add_srs_wkt (p, 9,
		 "ARAMETER[\"latitude_of_origin\",40.83333333333334],PARAM");
    add_srs_wkt (p, 10,
		 "ETER[\"central_meridian\",-72.75],PARAMETER[\"false_east");
    add_srs_wkt (p, 11,
		 "ing\",1000000],PARAMETER[\"false_northing\",500000],UNIT");
    add_srs_wkt (p, 12,
		 "[\"US survey foot\",0.3048006096012192,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
		 ",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY");
    add_srs_wkt (p, 14, "[\"EPSG\",\"2234\"]]");
    p = add_epsg_def (filter, first, last, 2235, "epsg", 2235,
		      "NAD83 / Delaware (ftUS)");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=38 +lon_0=-75.41666666666667 +k=0.999");
    add_proj4text (p, 1,
		   "995 +x_0=200000.0001016002 +y_0=0 +ellps=GRS80 +towgs84=");
    add_proj4text (p, 2, "0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83 / Delaware (ftUS)\",GEOGCS[\"NAD83\",DATU");
    add_srs_wkt (p, 1,
		 "M[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",63");
    add_srs_wkt (p, 2,
		 "78137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS8");
    add_srs_wkt (p, 3,
		 "4[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
		 "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
		 "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
		 "HORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
		 "tor\"],PARAMETER[\"latitude_of_origin\",38],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "central_meridian\",-75.41666666666667],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
		 "_factor\",0.999995],PARAMETER[\"false_easting\",656166.6");
    add_srs_wkt (p, 10,
		 "67],PARAMETER[\"false_northing\",0],UNIT[\"US survey foo");
    add_srs_wkt (p, 11,
		 "t\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXI");
    add_srs_wkt (p, 12,
		 "S[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"223");
    add_srs_wkt (p, 13, "5\"]]");
    p = add_epsg_def (filter, first, last, 2236, "epsg", 2236,
		      "NAD83 / Florida East (ftUS)");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=24.33333333333333 +lon_0=-81 +k=0.999");
    add_proj4text (p, 1,
		   "941177 +x_0=200000.0001016002 +y_0=0 +ellps=GRS80 +towgs");
    add_proj4text (p, 2, "84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83 / Florida East (ftUS)\",GEOGCS[\"NAD83\",");
    add_srs_wkt (p, 1,
		 "DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
		 ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOW");
    add_srs_wkt (p, 3,
		 "GS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM");
    add_srs_wkt (p, 4,
		 "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
		 "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
		 "AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 7,
		 "rcator\"],PARAMETER[\"latitude_of_origin\",24.3333333333");
    add_srs_wkt (p, 8,
		 "3333],PARAMETER[\"central_meridian\",-81],PARAMETER[\"sc");
    add_srs_wkt (p, 9,
		 "ale_factor\",0.999941177],PARAMETER[\"false_easting\",65");
    add_srs_wkt (p, 10,
		 "6166.667],PARAMETER[\"false_northing\",0],UNIT[\"US surv");
    add_srs_wkt (p, 11,
		 "ey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"");
    add_srs_wkt (p, 12,
		 "]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13, ",\"2236\"]]");
    p = add_epsg_def (filter, first, last, 2237, "epsg", 2237,
		      "NAD83 / Florida West (ftUS)");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=24.33333333333333 +lon_0=-82 +k=0.999");
    add_proj4text (p, 1,
		   "941177 +x_0=200000.0001016002 +y_0=0 +ellps=GRS80 +towgs");
    add_proj4text (p, 2, "84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83 / Florida West (ftUS)\",GEOGCS[\"NAD83\",");
    add_srs_wkt (p, 1,
		 "DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
		 ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOW");
    add_srs_wkt (p, 3,
		 "GS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM");
    add_srs_wkt (p, 4,
		 "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
		 "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
		 "AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 7,
		 "rcator\"],PARAMETER[\"latitude_of_origin\",24.3333333333");
    add_srs_wkt (p, 8,
		 "3333],PARAMETER[\"central_meridian\",-82],PARAMETER[\"sc");
    add_srs_wkt (p, 9,
		 "ale_factor\",0.999941177],PARAMETER[\"false_easting\",65");
    add_srs_wkt (p, 10,
		 "6166.667],PARAMETER[\"false_northing\",0],UNIT[\"US surv");
    add_srs_wkt (p, 11,
		 "ey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"");
    add_srs_wkt (p, 12,
		 "]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13, ",\"2237\"]]");
    p = add_epsg_def (filter, first, last, 2238, "epsg", 2238,
		      "NAD83 / Florida North (ftUS)");
    add_proj4text (p, 0,
		   "+proj=lcc +lat_1=30.75 +lat_2=29.58333333333333 +lat_0=2");
    add_proj4text (p, 1,
		   "9 +lon_0=-84.5 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=");
    add_proj4text (p, 2, "0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83 / Florida North (ftUS)\",GEOGCS[\"NAD83\"");
    add_srs_wkt (p, 1,
		 ",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
		 "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
		 "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIM");
    add_srs_wkt (p, 4,
		 "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
		 "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
		 "],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 7,
		 "formal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",30");
    add_srs_wkt (p, 8,
		 ".75],PARAMETER[\"standard_parallel_2\",29.58333333333333");
    add_srs_wkt (p, 9,
		 "],PARAMETER[\"latitude_of_origin\",29],PARAMETER[\"centr");
    add_srs_wkt (p, 10,
		 "al_meridian\",-84.5],PARAMETER[\"false_easting\",1968500");
    add_srs_wkt (p, 11,
		 "],PARAMETER[\"false_northing\",0],UNIT[\"US survey foot\"");
    add_srs_wkt (p, 12,
		 ",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"");
    add_srs_wkt (p, 13,
		 "X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"2238\"]");
    add_srs_wkt (p, 14, "]");
    p = add_epsg_def (filter, first, last, 2239, "epsg", 2239,
		      "NAD83 / Georgia East (ftUS)");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=30 +lon_0=-82.16666666666667 +k=0.999");
    add_proj4text (p, 1,
		   "9 +x_0=200000.0001016002 +y_0=0 +ellps=GRS80 +towgs84=0,");
    add_proj4text (p, 2, "0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83 / Georgia East (ftUS)\",GEOGCS[\"NAD83\",");
    add_srs_wkt (p, 1,
		 "DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
		 ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOW");
    add_srs_wkt (p, 3,
		 "GS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM");
    add_srs_wkt (p, 4,
		 "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
		 "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
		 "AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 7,
		 "rcator\"],PARAMETER[\"latitude_of_origin\",30],PARAMETER");
    add_srs_wkt (p, 8,
		 "[\"central_meridian\",-82.16666666666667],PARAMETER[\"sc");
    add_srs_wkt (p, 9,
		 "ale_factor\",0.9999],PARAMETER[\"false_easting\",656166.");
    add_srs_wkt (p, 10,
		 "667],PARAMETER[\"false_northing\",0],UNIT[\"US survey fo");
    add_srs_wkt (p, 11,
		 "ot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AX");
    add_srs_wkt (p, 12,
		 "IS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"22");
    add_srs_wkt (p, 13, "39\"]]");
    p = add_epsg_def (filter, first, last, 2240, "epsg", 2240,
		      "NAD83 / Georgia West (ftUS)");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=30 +lon_0=-84.16666666666667 +k=0.999");
    add_proj4text (p, 1,
		   "9 +x_0=699999.9998983998 +y_0=0 +ellps=GRS80 +towgs84=0,");
    add_proj4text (p, 2, "0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83 / Georgia West (ftUS)\",GEOGCS[\"NAD83\",");
    add_srs_wkt (p, 1,
		 "DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
		 ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOW");
    add_srs_wkt (p, 3,
		 "GS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM");
    add_srs_wkt (p, 4,
		 "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
		 "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
		 "AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 7,
		 "rcator\"],PARAMETER[\"latitude_of_origin\",30],PARAMETER");
    add_srs_wkt (p, 8,
		 "[\"central_meridian\",-84.16666666666667],PARAMETER[\"sc");
    add_srs_wkt (p, 9,
		 "ale_factor\",0.9999],PARAMETER[\"false_easting\",2296583");
    add_srs_wkt (p, 10,
		 ".333],PARAMETER[\"false_northing\",0],UNIT[\"US survey f");
    add_srs_wkt (p, 11,
		 "oot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],A");
    add_srs_wkt (p, 12,
		 "XIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"2");
    add_srs_wkt (p, 13, "240\"]]");
    p = add_epsg_def (filter, first, last, 2241, "epsg", 2241,
		      "NAD83 / Idaho East (ftUS)");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=41.66666666666666 +lon_0=-112.1666666");
    add_proj4text (p, 1,
		   "666667 +k=0.9999473679999999 +x_0=200000.0001016002 +y_0");
    add_proj4text (p, 2,
		   "=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_");
    add_proj4text (p, 3, "defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83 / Idaho East (ftUS)\",GEOGCS[\"NAD83\",DA");
    add_srs_wkt (p, 1,
		 "TUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",");
    add_srs_wkt (p, 2,
		 "6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWG");
    add_srs_wkt (p, 3,
		 "S84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[");
    add_srs_wkt (p, 4,
		 "\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"deg");
    add_srs_wkt (p, 5,
		 "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 6,
		 "UTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mer");
    add_srs_wkt (p, 7,
		 "cator\"],PARAMETER[\"latitude_of_origin\",41.66666666666");
    add_srs_wkt (p, 8,
		 "666],PARAMETER[\"central_meridian\",-112.1666666666667],");
    add_srs_wkt (p, 9,
		 "PARAMETER[\"scale_factor\",0.999947368],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
		 "e_easting\",656166.667],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 11,
		 "UNIT[\"US survey foot\",0.3048006096012192,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
		 "PSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTH");
    add_srs_wkt (p, 13, "ORITY[\"EPSG\",\"2241\"]]");
    p = add_epsg_def (filter, first, last, 2242, "epsg", 2242,
		      "NAD83 / Idaho Central (ftUS)");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=41.66666666666666 +lon_0=-114 +k=0.99");
    add_proj4text (p, 1,
		   "99473679999999 +x_0=500000.0001016001 +y_0=0 +ellps=GRS8");
    add_proj4text (p, 2, "0 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83 / Idaho Central (ftUS)\",GEOGCS[\"NAD83\"");
    add_srs_wkt (p, 1,
		 ",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
		 "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
		 "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIM");
    add_srs_wkt (p, 4,
		 "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
		 "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
		 "],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
		 "Mercator\"],PARAMETER[\"latitude_of_origin\",41.66666666");
    add_srs_wkt (p, 8,
		 "666666],PARAMETER[\"central_meridian\",-114],PARAMETER[\"");
    add_srs_wkt (p, 9,
		 "scale_factor\",0.999947368],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 10,
		 "1640416.667],PARAMETER[\"false_northing\",0],UNIT[\"US s");
    add_srs_wkt (p, 11,
		 "urvey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 12,
		 "3\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13, "G\",\"2242\"]]");
    p = add_epsg_def (filter, first, last, 2243, "epsg", 2243,
		      "NAD83 / Idaho West (ftUS)");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=41.66666666666666 +lon_0=-115.75 +k=0");
    add_proj4text (p, 1,
		   ".999933333 +x_0=800000.0001016001 +y_0=0 +ellps=GRS80 +t");
    add_proj4text (p, 2, "owgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83 / Idaho West (ftUS)\",GEOGCS[\"NAD83\",DA");
    add_srs_wkt (p, 1,
		 "TUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",");
    add_srs_wkt (p, 2,
		 "6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWG");
    add_srs_wkt (p, 3,
		 "S84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[");
    add_srs_wkt (p, 4,
		 "\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"deg");
    add_srs_wkt (p, 5,
		 "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 6,
		 "UTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mer");
    add_srs_wkt (p, 7,
		 "cator\"],PARAMETER[\"latitude_of_origin\",41.66666666666");
    add_srs_wkt (p, 8,
		 "666],PARAMETER[\"central_meridian\",-115.75],PARAMETER[\"");
    add_srs_wkt (p, 9,
		 "scale_factor\",0.999933333],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 10,
		 "2624666.667],PARAMETER[\"false_northing\",0],UNIT[\"US s");
    add_srs_wkt (p, 11,
		 "urvey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 12,
		 "3\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13, "G\",\"2243\"]]");
    p = add_epsg_def (filter, first, last, 2244, "epsg", 2244,
		      "NAD83 / Indiana East (ftUS) (deprecated)");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=37.5 +lon_0=-85.66666666666667 +k=0.9");
    add_proj4text (p, 1,
		   "99966667 +x_0=99999.99989839978 +y_0=249364.9987299975 +");
    add_proj4text (p, 2,
		   "ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83 / Indiana East (ftUS) (deprecated)\",GEOG");
    add_srs_wkt (p, 1,
		 "CS[\"NAD83\",DATUM[\"North_American_Datum_1983\",SPHEROI");
    add_srs_wkt (p, 2,
		 "D[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
		 "\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 4,
		 "269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
		 "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
		 "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"");
    add_srs_wkt (p, 7,
		 "Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 8,
		 "37.5],PARAMETER[\"central_meridian\",-85.66666666666667]");
    add_srs_wkt (p, 9,
		 ",PARAMETER[\"scale_factor\",0.999966667],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
		 "se_easting\",328083.333],PARAMETER[\"false_northing\",81");
    add_srs_wkt (p, 11,
		 "8125],UNIT[\"US survey foot\",0.3048006096012192,AUTHORI");
    add_srs_wkt (p, 12,
		 "TY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH");
    add_srs_wkt (p, 13, "],AUTHORITY[\"EPSG\",\"2244\"]]");
    p = add_epsg_def (filter, first, last, 2245, "epsg", 2245,
		      "NAD83 / Indiana West (ftUS) (deprecated)");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=37.5 +lon_0=-87.08333333333333 +k=0.9");
    add_proj4text (p, 1,
		   "99966667 +x_0=900000 +y_0=249364.9987299975 +ellps=GRS80");
    add_proj4text (p, 2, " +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83 / Indiana West (ftUS) (deprecated)\",GEOG");
    add_srs_wkt (p, 1,
		 "CS[\"NAD83\",DATUM[\"North_American_Datum_1983\",SPHEROI");
    add_srs_wkt (p, 2,
		 "D[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
		 "\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 4,
		 "269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
		 "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
		 "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"");
    add_srs_wkt (p, 7,
		 "Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 8,
		 "37.5],PARAMETER[\"central_meridian\",-87.08333333333333]");
    add_srs_wkt (p, 9,
		 ",PARAMETER[\"scale_factor\",0.999966667],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
		 "se_easting\",2952750],PARAMETER[\"false_northing\",81812");
    add_srs_wkt (p, 11,
		 "5],UNIT[\"US survey foot\",0.3048006096012192,AUTHORITY[");
    add_srs_wkt (p, 12,
		 "\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],A");
    add_srs_wkt (p, 13, "UTHORITY[\"EPSG\",\"2245\"]]");
    p = add_epsg_def (filter, first, last, 2246, "epsg", 2246,
		      "NAD83 / Kentucky North (ftUS)");
    add_proj4text (p, 0,
		   "+proj=lcc +lat_1=37.96666666666667 +lat_2=38.96666666666");
    add_proj4text (p, 1,
		   "667 +lat_0=37.5 +lon_0=-84.25 +x_0=500000.0001016001 +y_");
    add_proj4text (p, 2,
		   "0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no");
    add_proj4text (p, 3, "_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83 / Kentucky North (ftUS)\",GEOGCS[\"NAD83\"");
    add_srs_wkt (p, 1,
		 ",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
		 "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
		 "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIM");
    add_srs_wkt (p, 4,
		 "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
		 "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
		 "],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 7,
		 "formal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",37");
    add_srs_wkt (p, 8,
		 ".96666666666667],PARAMETER[\"standard_parallel_2\",38.96");
    add_srs_wkt (p, 9,
		 "666666666667],PARAMETER[\"latitude_of_origin\",37.5],PAR");
    add_srs_wkt (p, 10,
		 "AMETER[\"central_meridian\",-84.25],PARAMETER[\"false_ea");
    add_srs_wkt (p, 11,
		 "sting\",1640416.667],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 12,
		 "T[\"US survey foot\",0.3048006096012192,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
		 "\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORI");
    add_srs_wkt (p, 14, "TY[\"EPSG\",\"2246\"]]");
    p = add_epsg_def (filter, first, last, 2247, "epsg", 2247,
		      "NAD83 / Kentucky South (ftUS)");
    add_proj4text (p, 0,
		   "+proj=lcc +lat_1=37.93333333333333 +lat_2=36.73333333333");
    add_proj4text (p, 1,
		   "333 +lat_0=36.33333333333334 +lon_0=-85.75 +x_0=500000.0");
    add_proj4text (p, 2,
		   "001016001 +y_0=500000.0001016001 +ellps=GRS80 +towgs84=0");
    add_proj4text (p, 3, ",0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83 / Kentucky South (ftUS)\",GEOGCS[\"NAD83\"");
    add_srs_wkt (p, 1,
		 ",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
		 "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
		 "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIM");
    add_srs_wkt (p, 4,
		 "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
		 "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
		 "],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 7,
		 "formal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",37");
    add_srs_wkt (p, 8,
		 ".93333333333333],PARAMETER[\"standard_parallel_2\",36.73");
    add_srs_wkt (p, 9,
		 "333333333333],PARAMETER[\"latitude_of_origin\",36.333333");
    add_srs_wkt (p, 10,
		 "33333334],PARAMETER[\"central_meridian\",-85.75],PARAMET");
    add_srs_wkt (p, 11,
		 "ER[\"false_easting\",1640416.667],PARAMETER[\"false_nort");
    add_srs_wkt (p, 12,
		 "hing\",1640416.667],UNIT[\"US survey foot\",0.3048006096");
    add_srs_wkt (p, 13,
		 "012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AX");
    add_srs_wkt (p, 14, "IS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"2247\"]]");
    p = add_epsg_def (filter, first, last, 2248, "epsg", 2248,
		      "NAD83 / Maryland (ftUS)");
    add_proj4text (p, 0,
		   "+proj=lcc +lat_1=39.45 +lat_2=38.3 +lat_0=37.66666666666");
    add_proj4text (p, 1,
		   "666 +lon_0=-77 +x_0=399999.9998983998 +y_0=0 +ellps=GRS8");
    add_proj4text (p, 2, "0 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83 / Maryland (ftUS)\",GEOGCS[\"NAD83\",DATU");
    add_srs_wkt (p, 1,
		 "M[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",63");
    add_srs_wkt (p, 2,
		 "78137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS8");
    add_srs_wkt (p, 3,
		 "4[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
		 "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
		 "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
		 "HORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 7,
		 "l_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",39.45],");
    add_srs_wkt (p, 8,
		 "PARAMETER[\"standard_parallel_2\",38.3],PARAMETER[\"lati");
    add_srs_wkt (p, 9,
		 "tude_of_origin\",37.66666666666666],PARAMETER[\"central_");
    add_srs_wkt (p, 10,
		 "meridian\",-77],PARAMETER[\"false_easting\",1312333.333]");
    add_srs_wkt (p, 11,
		 ",PARAMETER[\"false_northing\",0],UNIT[\"US survey foot\"");
    add_srs_wkt (p, 12,
		 ",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"");
    add_srs_wkt (p, 13,
		 "X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"2248\"]");
    add_srs_wkt (p, 14, "]");
    p = add_epsg_def (filter, first, last, 2249, "epsg", 2249,
		      "NAD83 / Massachusetts Mainland (ftUS)");
    add_proj4text (p, 0,
		   "+proj=lcc +lat_1=42.68333333333333 +lat_2=41.71666666666");
    add_proj4text (p, 1,
		   "667 +lat_0=41 +lon_0=-71.5 +x_0=200000.0001016002 +y_0=7");
    add_proj4text (p, 2,
		   "50000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +");
    add_proj4text (p, 3, "no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83 / Massachusetts Mainland (ftUS)\",GEOGCS[");
    add_srs_wkt (p, 1,
		 "\"NAD83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"");
    add_srs_wkt (p, 2,
		 "GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
		 "19\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"");
    add_srs_wkt (p, 4,
		 "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
		 "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
		 "9122\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lamb");
    add_srs_wkt (p, 7,
		 "ert_Conformal_Conic_2SP\"],PARAMETER[\"standard_parallel");
    add_srs_wkt (p, 8,
		 "_1\",42.68333333333333],PARAMETER[\"standard_parallel_2\"");
    add_srs_wkt (p, 9,
		 ",41.71666666666667],PARAMETER[\"latitude_of_origin\",41]");
    add_srs_wkt (p, 10,
		 ",PARAMETER[\"central_meridian\",-71.5],PARAMETER[\"false");
    add_srs_wkt (p, 11,
		 "_easting\",656166.667],PARAMETER[\"false_northing\",2460");
    add_srs_wkt (p, 12,
		 "625],UNIT[\"US survey foot\",0.3048006096012192,AUTHORIT");
    add_srs_wkt (p, 13,
		 "Y[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH]");
    add_srs_wkt (p, 14, ",AUTHORITY[\"EPSG\",\"2249\"]]");
    p = add_epsg_def (filter, first, last, 2250, "epsg", 2250,
		      "NAD83 / Massachusetts Island (ftUS)");
    add_proj4text (p, 0,
		   "+proj=lcc +lat_1=41.48333333333333 +lat_2=41.28333333333");
    add_proj4text (p, 1,
		   "333 +lat_0=41 +lon_0=-70.5 +x_0=500000.0001016001 +y_0=0");
    add_proj4text (p, 2,
		   " +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_de");
    add_proj4text (p, 3, "fs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83 / Massachusetts Island (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
		 "NAD83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"G");
    add_srs_wkt (p, 2,
		 "RS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"701");
    add_srs_wkt (p, 3,
		 "9\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"");
    add_srs_wkt (p, 4,
		 "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
		 "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
		 "9122\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lamb");
    add_srs_wkt (p, 7,
		 "ert_Conformal_Conic_2SP\"],PARAMETER[\"standard_parallel");
    add_srs_wkt (p, 8,
		 "_1\",41.48333333333333],PARAMETER[\"standard_parallel_2\"");
    add_srs_wkt (p, 9,
		 ",41.28333333333333],PARAMETER[\"latitude_of_origin\",41]");
    add_srs_wkt (p, 10,
		 ",PARAMETER[\"central_meridian\",-70.5],PARAMETER[\"false");
    add_srs_wkt (p, 11,
		 "_easting\",1640416.667],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 12,
		 "UNIT[\"US survey foot\",0.3048006096012192,AUTHORITY[\"E");
    add_srs_wkt (p, 13,
		 "PSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTH");
    add_srs_wkt (p, 14, "ORITY[\"EPSG\",\"2250\"]]");
    p = add_epsg_def (filter, first, last, 2251, "epsg", 2251,
		      "NAD83 / Michigan North (ft)");
    add_proj4text (p, 0,
		   "+proj=lcc +lat_1=47.08333333333334 +lat_2=45.48333333333");
    add_proj4text (p, 1,
		   "333 +lat_0=44.78333333333333 +lon_0=-87 +x_0=7999999.999");
    add_proj4text (p, 2,
		   "968001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units");
    add_proj4text (p, 3, "=ft +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83 / Michigan North (ft)\",GEOGCS[\"NAD83\",");
    add_srs_wkt (p, 1,
		 "DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
		 ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOW");
    add_srs_wkt (p, 3,
		 "GS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM");
    add_srs_wkt (p, 4,
		 "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
		 "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
		 "AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Confo");
    add_srs_wkt (p, 7,
		 "rmal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",47.0");
    add_srs_wkt (p, 8,
		 "8333333333334],PARAMETER[\"standard_parallel_2\",45.4833");
    add_srs_wkt (p, 9,
		 "3333333333],PARAMETER[\"latitude_of_origin\",44.78333333");
    add_srs_wkt (p, 10,
		 "333333],PARAMETER[\"central_meridian\",-87],PARAMETER[\"");
    add_srs_wkt (p, 11,
		 "false_easting\",26246719.16],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 12,
		 ",0],UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"9002\"]],A");
    add_srs_wkt (p, 13,
		 "XIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"2");
    add_srs_wkt (p, 14, "251\"]]");
    p = add_epsg_def (filter, first, last, 2252, "epsg", 2252,
		      "NAD83 / Michigan Central (ft)");
    add_proj4text (p, 0,
		   "+proj=lcc +lat_1=45.7 +lat_2=44.18333333333333 +lat_0=43");
    add_proj4text (p, 1,
		   ".31666666666667 +lon_0=-84.36666666666666 +x_0=5999999.9");
    add_proj4text (p, 2,
		   "99976001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +uni");
    add_proj4text (p, 3, "ts=ft +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83 / Michigan Central (ft)\",GEOGCS[\"NAD83\"");
    add_srs_wkt (p, 1,
		 ",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
		 "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
		 "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIM");
    add_srs_wkt (p, 4,
		 "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
		 "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
		 "],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 7,
		 "formal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",45");
    add_srs_wkt (p, 8,
		 ".7],PARAMETER[\"standard_parallel_2\",44.18333333333333]");
    add_srs_wkt (p, 9,
		 ",PARAMETER[\"latitude_of_origin\",43.31666666666667],PAR");
    add_srs_wkt (p, 10,
		 "AMETER[\"central_meridian\",-84.36666666666666],PARAMETE");
    add_srs_wkt (p, 11,
		 "R[\"false_easting\",19685039.37],PARAMETER[\"false_north");
    add_srs_wkt (p, 12,
		 "ing\",0],UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"9002\"");
    add_srs_wkt (p, 13,
		 "]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 14, ",\"2252\"]]");
    p = add_epsg_def (filter, first, last, 2253, "epsg", 2253,
		      "NAD83 / Michigan South (ft)");
    add_proj4text (p, 0,
		   "+proj=lcc +lat_1=43.66666666666666 +lat_2=42.1 +lat_0=41");
    add_proj4text (p, 1,
		   ".5 +lon_0=-84.36666666666666 +x_0=3999999.999984 +y_0=0 ");
    add_proj4text (p, 2,
		   "+ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83 / Michigan South (ft)\",GEOGCS[\"NAD83\",");
    add_srs_wkt (p, 1,
		 "DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
		 ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOW");
    add_srs_wkt (p, 3,
		 "GS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM");
    add_srs_wkt (p, 4,
		 "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
		 "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
		 "AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Confo");
    add_srs_wkt (p, 7,
		 "rmal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",43.6");
    add_srs_wkt (p, 8,
		 "6666666666666],PARAMETER[\"standard_parallel_2\",42.1],P");
    add_srs_wkt (p, 9,
		 "ARAMETER[\"latitude_of_origin\",41.5],PARAMETER[\"centra");
    add_srs_wkt (p, 10,
		 "l_meridian\",-84.36666666666666],PARAMETER[\"false_easti");
    add_srs_wkt (p, 11,
		 "ng\",13123359.58],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 12,
		 "foot\",0.3048,AUTHORITY[\"EPSG\",\"9002\"]],AXIS[\"X\",E");
    add_srs_wkt (p, 13, "AST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"2253\"]]");
    p = add_epsg_def (filter, first, last, 2254, "epsg", 2254,
		      "NAD83 / Mississippi East (ftUS)");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=29.5 +lon_0=-88.83333333333333 +k=0.9");
    add_proj4text (p, 1,
		   "9995 +x_0=300000.0000000001 +y_0=0 +ellps=GRS80 +towgs84");
    add_proj4text (p, 2, "=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83 / Mississippi East (ftUS)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
		 "3\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 2,
		 "980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]");
    add_srs_wkt (p, 3,
		 "],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],P");
    add_srs_wkt (p, 4,
		 "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
		 "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
		 "\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 7,
		 "se_Mercator\"],PARAMETER[\"latitude_of_origin\",29.5],PA");
    add_srs_wkt (p, 8,
		 "RAMETER[\"central_meridian\",-88.83333333333333],PARAMET");
    add_srs_wkt (p, 9,
		 "ER[\"scale_factor\",0.99995],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
		 ",984250.0000000002],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 11,
		 "[\"US survey foot\",0.3048006096012192,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
		 ",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY");
    add_srs_wkt (p, 13, "[\"EPSG\",\"2254\"]]");
    p = add_epsg_def (filter, first, last, 2255, "epsg", 2255,
		      "NAD83 / Mississippi West (ftUS)");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=29.5 +lon_0=-90.33333333333333 +k=0.9");
    add_proj4text (p, 1,
		   "9995 +x_0=699999.9998983998 +y_0=0 +ellps=GRS80 +towgs84");
    add_proj4text (p, 2, "=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83 / Mississippi West (ftUS)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
		 "3\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 2,
		 "980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]");
    add_srs_wkt (p, 3,
		 "],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],P");
    add_srs_wkt (p, 4,
		 "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
		 "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
		 "\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 7,
		 "se_Mercator\"],PARAMETER[\"latitude_of_origin\",29.5],PA");
    add_srs_wkt (p, 8,
		 "RAMETER[\"central_meridian\",-90.33333333333333],PARAMET");
    add_srs_wkt (p, 9,
		 "ER[\"scale_factor\",0.99995],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
		 ",2296583.333],PARAMETER[\"false_northing\",0],UNIT[\"US ");
    add_srs_wkt (p, 11,
		 "survey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 12,
		 "03\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EP");
    add_srs_wkt (p, 13, "SG\",\"2255\"]]");
    p = add_epsg_def (filter, first, last, 2256, "epsg", 2256,
		      "NAD83 / Montana (ft)");
    add_proj4text (p, 0,
		   "+proj=lcc +lat_1=49 +lat_2=45 +lat_0=44.25 +lon_0=-109.5");
    add_proj4text (p, 1,
		   " +x_0=599999.9999976 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,");
    add_proj4text (p, 2, "0,0,0,0 +units=ft +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83 / Montana (ft)\",GEOGCS[\"NAD83\",DATUM[\"");
    add_srs_wkt (p, 1,
		 "North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
		 "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
		 "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
		 "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
		 "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
		 "TY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Co");
    add_srs_wkt (p, 7,
		 "nic_2SP\"],PARAMETER[\"standard_parallel_1\",49],PARAMET");
    add_srs_wkt (p, 8,
		 "ER[\"standard_parallel_2\",45],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 9,
		 "rigin\",44.25],PARAMETER[\"central_meridian\",-109.5],PA");
    add_srs_wkt (p, 10,
		 "RAMETER[\"false_easting\",1968503.937],PARAMETER[\"false");
    add_srs_wkt (p, 11,
		 "_northing\",0],UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
		 "9002\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 13, "EPSG\",\"2256\"]]");
    p = add_epsg_def (filter, first, last, 2257, "epsg", 2257,
		      "NAD83 / New Mexico East (ftUS)");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=31 +lon_0=-104.3333333333333 +k=0.999");
    add_proj4text (p, 1,
		   "909091 +x_0=165000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 2, "0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83 / New Mexico East (ftUS)\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
		 "\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 2,
		 "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 3,
		 ",TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PR");
    add_srs_wkt (p, 4,
		 "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
		 "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
		 "]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 7,
		 "_Mercator\"],PARAMETER[\"latitude_of_origin\",31],PARAME");
    add_srs_wkt (p, 8,
		 "TER[\"central_meridian\",-104.3333333333333],PARAMETER[\"");
    add_srs_wkt (p, 9,
		 "scale_factor\",0.999909091],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 10,
		 "541337.5],PARAMETER[\"false_northing\",0],UNIT[\"US surv");
    add_srs_wkt (p, 11,
		 "ey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"");
    add_srs_wkt (p, 12,
		 "]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13, ",\"2257\"]]");
    p = add_epsg_def (filter, first, last, 2258, "epsg", 2258,
		      "NAD83 / New Mexico Central (ftUS)");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=31 +lon_0=-106.25 +k=0.9999 +x_0=5000");
    add_proj4text (p, 1,
		   "00.0001016001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0");
    add_proj4text (p, 2, " +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83 / New Mexico Central (ftUS)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
		 "D83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS");
    add_srs_wkt (p, 2,
		 " 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
		 "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],");
    add_srs_wkt (p, 4,
		 "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
		 "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
		 "2\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
		 "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",31],PAR");
    add_srs_wkt (p, 8,
		 "AMETER[\"central_meridian\",-106.25],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
		 "actor\",0.9999],PARAMETER[\"false_easting\",1640416.667]");
    add_srs_wkt (p, 10,
		 ",PARAMETER[\"false_northing\",0],UNIT[\"US survey foot\"");
    add_srs_wkt (p, 11,
		 ",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"");
    add_srs_wkt (p, 12,
		 "X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"2258\"]");
    add_srs_wkt (p, 13, "]");
    p = add_epsg_def (filter, first, last, 2259, "epsg", 2259,
		      "NAD83 / New Mexico West (ftUS)");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=31 +lon_0=-107.8333333333333 +k=0.999");
    add_proj4text (p, 1,
		   "916667 +x_0=830000.0001016001 +y_0=0 +ellps=GRS80 +towgs");
    add_proj4text (p, 2, "84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83 / New Mexico West (ftUS)\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
		 "\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 2,
		 "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 3,
		 ",TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PR");
    add_srs_wkt (p, 4,
		 "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
		 "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
		 "]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 7,
		 "_Mercator\"],PARAMETER[\"latitude_of_origin\",31],PARAME");
    add_srs_wkt (p, 8,
		 "TER[\"central_meridian\",-107.8333333333333],PARAMETER[\"");
    add_srs_wkt (p, 9,
		 "scale_factor\",0.999916667],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 10,
		 "2723091.667],PARAMETER[\"false_northing\",0],UNIT[\"US s");
    add_srs_wkt (p, 11,
		 "urvey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 12,
		 "3\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13, "G\",\"2259\"]]");
    p = add_epsg_def (filter, first, last, 2260, "epsg", 2260,
		      "NAD83 / New York East (ftUS)");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=38.83333333333334 +lon_0=-74.5 +k=0.9");
    add_proj4text (p, 1,
		   "999 +x_0=150000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0");
    add_proj4text (p, 2, ",0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83 / New York East (ftUS)\",GEOGCS[\"NAD83\"");
    add_srs_wkt (p, 1,
		 ",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
		 "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
		 "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIM");
    add_srs_wkt (p, 4,
		 "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
		 "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
		 "],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
		 "Mercator\"],PARAMETER[\"latitude_of_origin\",38.83333333");
    add_srs_wkt (p, 8,
		 "333334],PARAMETER[\"central_meridian\",-74.5],PARAMETER[");
    add_srs_wkt (p, 9,
		 "\"scale_factor\",0.9999],PARAMETER[\"false_easting\",492");
    add_srs_wkt (p, 10,
		 "125],PARAMETER[\"false_northing\",0],UNIT[\"US survey fo");
    add_srs_wkt (p, 11,
		 "ot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AX");
    add_srs_wkt (p, 12,
		 "IS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"22");
    add_srs_wkt (p, 13, "60\"]]");
    p = add_epsg_def (filter, first, last, 2261, "epsg", 2261,
		      "NAD83 / New York Central (ftUS)");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=40 +lon_0=-76.58333333333333 +k=0.999");
    add_proj4text (p, 1,
		   "9375 +x_0=249999.9998983998 +y_0=0 +ellps=GRS80 +towgs84");
    add_proj4text (p, 2, "=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83 / New York Central (ftUS)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
		 "3\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 2,
		 "980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]");
    add_srs_wkt (p, 3,
		 "],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],P");
    add_srs_wkt (p, 4,
		 "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
		 "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
		 "\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 7,
		 "se_Mercator\"],PARAMETER[\"latitude_of_origin\",40],PARA");
    add_srs_wkt (p, 8,
		 "METER[\"central_meridian\",-76.58333333333333],PARAMETER");
    add_srs_wkt (p, 9,
		 "[\"scale_factor\",0.9999375],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
		 ",820208.3330000002],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 11,
		 "[\"US survey foot\",0.3048006096012192,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
		 ",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY");
    add_srs_wkt (p, 13, "[\"EPSG\",\"2261\"]]");
    p = add_epsg_def (filter, first, last, 2262, "epsg", 2262,
		      "NAD83 / New York West (ftUS)");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=40 +lon_0=-78.58333333333333 +k=0.999");
    add_proj4text (p, 1,
		   "9375 +x_0=350000.0001016001 +y_0=0 +ellps=GRS80 +towgs84");
    add_proj4text (p, 2, "=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83 / New York West (ftUS)\",GEOGCS[\"NAD83\"");
    add_srs_wkt (p, 1,
		 ",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
		 "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
		 "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIM");
    add_srs_wkt (p, 4,
		 "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
		 "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
		 "],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
		 "Mercator\"],PARAMETER[\"latitude_of_origin\",40],PARAMET");
    add_srs_wkt (p, 8,
		 "ER[\"central_meridian\",-78.58333333333333],PARAMETER[\"");
    add_srs_wkt (p, 9,
		 "scale_factor\",0.9999375],PARAMETER[\"false_easting\",11");
    add_srs_wkt (p, 10,
		 "48291.667],PARAMETER[\"false_northing\",0],UNIT[\"US sur");
    add_srs_wkt (p, 11,
		 "vey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"");
    add_srs_wkt (p, 12,
		 "]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13, ",\"2262\"]]");
    p = add_epsg_def (filter, first, last, 2263, "epsg", 2263,
		      "NAD83 / New York Long Island (ftUS)");
    add_proj4text (p, 0,
		   "+proj=lcc +lat_1=41.03333333333333 +lat_2=40.66666666666");
    add_proj4text (p, 1,
		   "666 +lat_0=40.16666666666666 +lon_0=-74 +x_0=300000.0000");
    add_proj4text (p, 2,
		   "000001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units");
    add_proj4text (p, 3, "=us-ft +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83 / New York Long Island (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
		 "NAD83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"G");
    add_srs_wkt (p, 2,
		 "RS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"701");
    add_srs_wkt (p, 3,
		 "9\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"");
    add_srs_wkt (p, 4,
		 "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
		 "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
		 "9122\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lamb");
    add_srs_wkt (p, 7,
		 "ert_Conformal_Conic_2SP\"],PARAMETER[\"standard_parallel");
    add_srs_wkt (p, 8,
		 "_1\",41.03333333333333],PARAMETER[\"standard_parallel_2\"");
    add_srs_wkt (p, 9,
		 ",40.66666666666666],PARAMETER[\"latitude_of_origin\",40.");
    add_srs_wkt (p, 10,
		 "16666666666666],PARAMETER[\"central_meridian\",-74],PARA");
    add_srs_wkt (p, 11,
		 "METER[\"false_easting\",984250.0000000002],PARAMETER[\"f");
    add_srs_wkt (p, 12,
		 "alse_northing\",0],UNIT[\"US survey foot\",0.30480060960");
    add_srs_wkt (p, 13,
		 "12192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXI");
    add_srs_wkt (p, 14, "S[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"2263\"]]");
    p = add_epsg_def (filter, first, last, 2264, "epsg", 2264,
		      "NAD83 / North Carolina (ftUS)");
    add_proj4text (p, 0,
		   "+proj=lcc +lat_1=36.16666666666666 +lat_2=34.33333333333");
    add_proj4text (p, 1,
		   "334 +lat_0=33.75 +lon_0=-79 +x_0=609601.2192024384 +y_0=");
    add_proj4text (p, 2,
		   "0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_d");
    add_proj4text (p, 3, "efs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83 / North Carolina (ftUS)\",GEOGCS[\"NAD83\"");
    add_srs_wkt (p, 1,
		 ",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
		 "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
		 "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIM");
    add_srs_wkt (p, 4,
		 "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
		 "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
		 "],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 7,
		 "formal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",36");
    add_srs_wkt (p, 8,
		 ".16666666666666],PARAMETER[\"standard_parallel_2\",34.33");
    add_srs_wkt (p, 9,
		 "333333333334],PARAMETER[\"latitude_of_origin\",33.75],PA");
    add_srs_wkt (p, 10,
		 "RAMETER[\"central_meridian\",-79],PARAMETER[\"false_east");
    add_srs_wkt (p, 11,
		 "ing\",2000000],PARAMETER[\"false_northing\",0],UNIT[\"US");
    add_srs_wkt (p, 12,
		 " survey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 13,
		 "003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 14, "PSG\",\"2264\"]]");
    p = add_epsg_def (filter, first, last, 2265, "epsg", 2265,
		      "NAD83 / North Dakota North (ft)");
    add_proj4text (p, 0,
		   "+proj=lcc +lat_1=48.73333333333333 +lat_2=47.43333333333");
    add_proj4text (p, 1,
		   "333 +lat_0=47 +lon_0=-100.5 +x_0=599999.9999976 +y_0=0 +");
    add_proj4text (p, 2,
		   "ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83 / North Dakota North (ft)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
		 "3\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 2,
		 "980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]");
    add_srs_wkt (p, 3,
		 "],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],P");
    add_srs_wkt (p, 4,
		 "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
		 "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
		 "\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_");
    add_srs_wkt (p, 7,
		 "Conformal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\"");
    add_srs_wkt (p, 8,
		 ",48.73333333333333],PARAMETER[\"standard_parallel_2\",47");
    add_srs_wkt (p, 9,
		 ".43333333333333],PARAMETER[\"latitude_of_origin\",47],PA");
    add_srs_wkt (p, 10,
		 "RAMETER[\"central_meridian\",-100.5],PARAMETER[\"false_e");
    add_srs_wkt (p, 11,
		 "asting\",1968503.937],PARAMETER[\"false_northing\",0],UN");
    add_srs_wkt (p, 12,
		 "IT[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"9002\"]],AXIS[\"");
    add_srs_wkt (p, 13,
		 "X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"2265\"]");
    add_srs_wkt (p, 14, "]");
    p = add_epsg_def (filter, first, last, 2266, "epsg", 2266,
		      "NAD83 / North Dakota South (ft)");
    add_proj4text (p, 0,
		   "+proj=lcc +lat_1=47.48333333333333 +lat_2=46.18333333333");
    add_proj4text (p, 1,
		   "333 +lat_0=45.66666666666666 +lon_0=-100.5 +x_0=599999.9");
    add_proj4text (p, 2,
		   "999976 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units");
    add_proj4text (p, 3, "=ft +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83 / North Dakota South (ft)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
		 "3\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 2,
		 "980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]");
    add_srs_wkt (p, 3,
		 "],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],P");
    add_srs_wkt (p, 4,
		 "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
		 "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
		 "\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_");
    add_srs_wkt (p, 7,
		 "Conformal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\"");
    add_srs_wkt (p, 8,
		 ",47.48333333333333],PARAMETER[\"standard_parallel_2\",46");
    add_srs_wkt (p, 9,
		 ".18333333333333],PARAMETER[\"latitude_of_origin\",45.666");
    add_srs_wkt (p, 10,
		 "66666666666],PARAMETER[\"central_meridian\",-100.5],PARA");
    add_srs_wkt (p, 11,
		 "METER[\"false_easting\",1968503.937],PARAMETER[\"false_n");
    add_srs_wkt (p, 12,
		 "orthing\",0],UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 13,
		 "002\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 14, "PSG\",\"2266\"]]");
    p = add_epsg_def (filter, first, last, 2267, "epsg", 2267,
		      "NAD83 / Oklahoma North (ftUS)");
    add_proj4text (p, 0,
		   "+proj=lcc +lat_1=36.76666666666667 +lat_2=35.56666666666");
    add_proj4text (p, 1,
		   "667 +lat_0=35 +lon_0=-98 +x_0=600000 +y_0=0 +ellps=GRS80");
    add_proj4text (p, 2, " +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83 / Oklahoma North (ftUS)\",GEOGCS[\"NAD83\"");
    add_srs_wkt (p, 1,
		 ",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
		 "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
		 "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIM");
    add_srs_wkt (p, 4,
		 "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
		 "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
		 "],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 7,
		 "formal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",36");
    add_srs_wkt (p, 8,
		 ".76666666666667],PARAMETER[\"standard_parallel_2\",35.56");
    add_srs_wkt (p, 9,
		 "666666666667],PARAMETER[\"latitude_of_origin\",35],PARAM");
    add_srs_wkt (p, 10,
		 "ETER[\"central_meridian\",-98],PARAMETER[\"false_easting");
    add_srs_wkt (p, 11,
		 "\",1968500],PARAMETER[\"false_northing\",0],UNIT[\"US su");
    add_srs_wkt (p, 12,
		 "rvey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003");
    add_srs_wkt (p, 13,
		 "\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 14, "\",\"2267\"]]");
    p = add_epsg_def (filter, first, last, 2268, "epsg", 2268,
		      "NAD83 / Oklahoma South (ftUS)");
    add_proj4text (p, 0,
		   "+proj=lcc +lat_1=35.23333333333333 +lat_2=33.93333333333");
    add_proj4text (p, 1,
		   "333 +lat_0=33.33333333333334 +lon_0=-98 +x_0=600000 +y_0");
    add_proj4text (p, 2,
		   "=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_");
    add_proj4text (p, 3, "defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83 / Oklahoma South (ftUS)\",GEOGCS[\"NAD83\"");
    add_srs_wkt (p, 1,
		 ",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
		 "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
		 "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIM");
    add_srs_wkt (p, 4,
		 "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
		 "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
		 "],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 7,
		 "formal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",35");
    add_srs_wkt (p, 8,
		 ".23333333333333],PARAMETER[\"standard_parallel_2\",33.93");
    add_srs_wkt (p, 9,
		 "333333333333],PARAMETER[\"latitude_of_origin\",33.333333");
    add_srs_wkt (p, 10,
		 "33333334],PARAMETER[\"central_meridian\",-98],PARAMETER[");
    add_srs_wkt (p, 11,
		 "\"false_easting\",1968500],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 12,
		 "0],UNIT[\"US survey foot\",0.3048006096012192,AUTHORITY[");
    add_srs_wkt (p, 13,
		 "\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],A");
    add_srs_wkt (p, 14, "UTHORITY[\"EPSG\",\"2268\"]]");
    p = add_epsg_def (filter, first, last, 2269, "epsg", 2269,
		      "NAD83 / Oregon North (ft)");
    add_proj4text (p, 0,
		   "+proj=lcc +lat_1=46 +lat_2=44.33333333333334 +lat_0=43.6");
    add_proj4text (p, 1,
		   "6666666666666 +lon_0=-120.5 +x_0=2500000.0001424 +y_0=0 ");
    add_proj4text (p, 2,
		   "+ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83 / Oregon North (ft)\",GEOGCS[\"NAD83\",DA");
    add_srs_wkt (p, 1,
		 "TUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",");
    add_srs_wkt (p, 2,
		 "6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWG");
    add_srs_wkt (p, 3,
		 "S84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[");
    add_srs_wkt (p, 4,
		 "\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"deg");
    add_srs_wkt (p, 5,
		 "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 6,
		 "UTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Confor");
    add_srs_wkt (p, 7,
		 "mal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",46],P");
    add_srs_wkt (p, 8,
		 "ARAMETER[\"standard_parallel_2\",44.33333333333334],PARA");
    add_srs_wkt (p, 9,
		 "METER[\"latitude_of_origin\",43.66666666666666],PARAMETE");
    add_srs_wkt (p, 10,
		 "R[\"central_meridian\",-120.5],PARAMETER[\"false_easting");
    add_srs_wkt (p, 11,
		 "\",8202099.738],PARAMETER[\"false_northing\",0],UNIT[\"f");
    add_srs_wkt (p, 12,
		 "oot\",0.3048,AUTHORITY[\"EPSG\",\"9002\"]],AXIS[\"X\",EA");
    add_srs_wkt (p, 13, "ST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"2269\"]]");
    p = add_epsg_def (filter, first, last, 2270, "epsg", 2270,
		      "NAD83 / Oregon South (ft)");
    add_proj4text (p, 0,
		   "+proj=lcc +lat_1=44 +lat_2=42.33333333333334 +lat_0=41.6");
    add_proj4text (p, 1,
		   "6666666666666 +lon_0=-120.5 +x_0=1500000.0001464 +y_0=0 ");
    add_proj4text (p, 2,
		   "+ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83 / Oregon South (ft)\",GEOGCS[\"NAD83\",DA");
    add_srs_wkt (p, 1,
		 "TUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",");
    add_srs_wkt (p, 2,
		 "6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWG");
    add_srs_wkt (p, 3,
		 "S84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[");
    add_srs_wkt (p, 4,
		 "\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"deg");
    add_srs_wkt (p, 5,
		 "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 6,
		 "UTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Confor");
    add_srs_wkt (p, 7,
		 "mal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",44],P");
    add_srs_wkt (p, 8,
		 "ARAMETER[\"standard_parallel_2\",42.33333333333334],PARA");
    add_srs_wkt (p, 9,
		 "METER[\"latitude_of_origin\",41.66666666666666],PARAMETE");
    add_srs_wkt (p, 10,
		 "R[\"central_meridian\",-120.5],PARAMETER[\"false_easting");
    add_srs_wkt (p, 11,
		 "\",4921259.843],PARAMETER[\"false_northing\",0],UNIT[\"f");
    add_srs_wkt (p, 12,
		 "oot\",0.3048,AUTHORITY[\"EPSG\",\"9002\"]],AXIS[\"X\",EA");
    add_srs_wkt (p, 13, "ST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"2270\"]]");
    p = add_epsg_def (filter, first, last, 2271, "epsg", 2271,
		      "NAD83 / Pennsylvania North (ftUS)");
    add_proj4text (p, 0,
		   "+proj=lcc +lat_1=41.95 +lat_2=40.88333333333333 +lat_0=4");
    add_proj4text (p, 1,
		   "0.16666666666666 +lon_0=-77.75 +x_0=600000 +y_0=0 +ellps");
    add_proj4text (p, 2, "=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83 / Pennsylvania North (ftUS)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
		 "D83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS");
    add_srs_wkt (p, 2,
		 " 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
		 "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],");
    add_srs_wkt (p, 4,
		 "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
		 "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
		 "2\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert");
    add_srs_wkt (p, 7,
		 "_Conformal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\"");
    add_srs_wkt (p, 8,
		 ",41.95],PARAMETER[\"standard_parallel_2\",40.88333333333");
    add_srs_wkt (p, 9,
		 "333],PARAMETER[\"latitude_of_origin\",40.16666666666666]");
    add_srs_wkt (p, 10,
		 ",PARAMETER[\"central_meridian\",-77.75],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
		 "e_easting\",1968500],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 12,
		 "T[\"US survey foot\",0.3048006096012192,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
		 "\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORI");
    add_srs_wkt (p, 14, "TY[\"EPSG\",\"2271\"]]");
    p = add_epsg_def (filter, first, last, 2272, "epsg", 2272,
		      "NAD83 / Pennsylvania South (ftUS)");
    add_proj4text (p, 0,
		   "+proj=lcc +lat_1=40.96666666666667 +lat_2=39.93333333333");
    add_proj4text (p, 1,
		   "333 +lat_0=39.33333333333334 +lon_0=-77.75 +x_0=600000 +");
    add_proj4text (p, 2,
		   "y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +");
    add_proj4text (p, 3, "no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83 / Pennsylvania South (ftUS)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
		 "D83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS");
    add_srs_wkt (p, 2,
		 " 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
		 "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],");
    add_srs_wkt (p, 4,
		 "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
		 "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
		 "2\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert");
    add_srs_wkt (p, 7,
		 "_Conformal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\"");
    add_srs_wkt (p, 8,
		 ",40.96666666666667],PARAMETER[\"standard_parallel_2\",39");
    add_srs_wkt (p, 9,
		 ".93333333333333],PARAMETER[\"latitude_of_origin\",39.333");
    add_srs_wkt (p, 10,
		 "33333333334],PARAMETER[\"central_meridian\",-77.75],PARA");
    add_srs_wkt (p, 11,
		 "METER[\"false_easting\",1968500],PARAMETER[\"false_north");
    add_srs_wkt (p, 12,
		 "ing\",0],UNIT[\"US survey foot\",0.3048006096012192,AUTH");
    add_srs_wkt (p, 13,
		 "ORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NO");
    add_srs_wkt (p, 14, "RTH],AUTHORITY[\"EPSG\",\"2272\"]]");
    p = add_epsg_def (filter, first, last, 2273, "epsg", 2273,
		      "NAD83 / South Carolina (ft)");
    add_proj4text (p, 0,
		   "+proj=lcc +lat_1=34.83333333333334 +lat_2=32.5 +lat_0=31");
    add_proj4text (p, 1,
		   ".83333333333333 +lon_0=-81 +x_0=609600 +y_0=0 +ellps=GRS");
    add_proj4text (p, 2, "80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83 / South Carolina (ft)\",GEOGCS[\"NAD83\",");
    add_srs_wkt (p, 1,
		 "DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
		 ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOW");
    add_srs_wkt (p, 3,
		 "GS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM");
    add_srs_wkt (p, 4,
		 "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
		 "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
		 "AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Confo");
    add_srs_wkt (p, 7,
		 "rmal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",34.8");
    add_srs_wkt (p, 8,
		 "3333333333334],PARAMETER[\"standard_parallel_2\",32.5],P");
    add_srs_wkt (p, 9,
		 "ARAMETER[\"latitude_of_origin\",31.83333333333333],PARAM");
    add_srs_wkt (p, 10,
		 "ETER[\"central_meridian\",-81],PARAMETER[\"false_easting");
    add_srs_wkt (p, 11,
		 "\",2000000],PARAMETER[\"false_northing\",0],UNIT[\"foot\"");
    add_srs_wkt (p, 12,
		 ",0.3048,AUTHORITY[\"EPSG\",\"9002\"]],AXIS[\"X\",EAST],A");
    add_srs_wkt (p, 13, "XIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"2273\"]]");
    p = add_epsg_def (filter, first, last, 2274, "epsg", 2274,
		      "NAD83 / Tennessee (ftUS)");
    add_proj4text (p, 0,
		   "+proj=lcc +lat_1=36.41666666666666 +lat_2=35.25 +lat_0=3");
    add_proj4text (p, 1,
		   "4.33333333333334 +lon_0=-86 +x_0=600000 +y_0=0 +ellps=GR");
    add_proj4text (p, 2, "S80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83 / Tennessee (ftUS)\",GEOGCS[\"NAD83\",DAT");
    add_srs_wkt (p, 1,
		 "UM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6");
    add_srs_wkt (p, 2,
		 "378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS");
    add_srs_wkt (p, 3,
		 "84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
		 "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
		 "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
		 "HORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 7,
		 "l_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",36.4166");
    add_srs_wkt (p, 8,
		 "6666666666],PARAMETER[\"standard_parallel_2\",35.25],PAR");
    add_srs_wkt (p, 9,
		 "AMETER[\"latitude_of_origin\",34.33333333333334],PARAMET");
    add_srs_wkt (p, 10,
		 "ER[\"central_meridian\",-86],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 11,
		 ",1968500],PARAMETER[\"false_northing\",0],UNIT[\"US surv");
    add_srs_wkt (p, 12,
		 "ey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"");
    add_srs_wkt (p, 13,
		 "]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 14, ",\"2274\"]]");
    p = add_epsg_def (filter, first, last, 2275, "epsg", 2275,
		      "NAD83 / Texas North (ftUS)");
    add_proj4text (p, 0,
		   "+proj=lcc +lat_1=36.18333333333333 +lat_2=34.65 +lat_0=3");
    add_proj4text (p, 1,
		   "4 +lon_0=-101.5 +x_0=200000.0001016002 +y_0=999999.99989");
    add_proj4text (p, 2,
		   "83998 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +");
    add_proj4text (p, 3, "no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83 / Texas North (ftUS)\",GEOGCS[\"NAD83\",D");
    add_srs_wkt (p, 1,
		 "ATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
		 ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOW");
    add_srs_wkt (p, 3,
		 "GS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM");
    add_srs_wkt (p, 4,
		 "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
		 "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
		 "AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Confo");
    add_srs_wkt (p, 7,
		 "rmal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",36.1");
    add_srs_wkt (p, 8,
		 "8333333333333],PARAMETER[\"standard_parallel_2\",34.65],");
    add_srs_wkt (p, 9,
		 "PARAMETER[\"latitude_of_origin\",34],PARAMETER[\"central");
    add_srs_wkt (p, 10,
		 "_meridian\",-101.5],PARAMETER[\"false_easting\",656166.6");
    add_srs_wkt (p, 11,
		 "67],PARAMETER[\"false_northing\",3280833.333],UNIT[\"US ");
    add_srs_wkt (p, 12,
		 "survey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 13,
		 "03\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EP");
    add_srs_wkt (p, 14, "SG\",\"2275\"]]");
    p = add_epsg_def (filter, first, last, 2276, "epsg", 2276,
		      "NAD83 / Texas North Central (ftUS)");
    add_proj4text (p, 0,
		   "+proj=lcc +lat_1=33.96666666666667 +lat_2=32.13333333333");
    add_proj4text (p, 1,
		   "333 +lat_0=31.66666666666667 +lon_0=-98.5 +x_0=600000 +y");
    add_proj4text (p, 2,
		   "_0=2000000.0001016 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 3, "units=us-ft +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83 / Texas North Central (ftUS)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
		 "AD83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GR");
    add_srs_wkt (p, 2,
		 "S 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019");
    add_srs_wkt (p, 3,
		 "\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]");
    add_srs_wkt (p, 4,
		 "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
		 "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
		 "122\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambe");
    add_srs_wkt (p, 7,
		 "rt_Conformal_Conic_2SP\"],PARAMETER[\"standard_parallel_");
    add_srs_wkt (p, 8,
		 "1\",33.96666666666667],PARAMETER[\"standard_parallel_2\"");
    add_srs_wkt (p, 9,
		 ",32.13333333333333],PARAMETER[\"latitude_of_origin\",31.");
    add_srs_wkt (p, 10,
		 "66666666666667],PARAMETER[\"central_meridian\",-98.5],PA");
    add_srs_wkt (p, 11,
		 "RAMETER[\"false_easting\",1968500],PARAMETER[\"false_nor");
    add_srs_wkt (p, 12,
		 "thing\",6561666.667],UNIT[\"US survey foot\",0.304800609");
    add_srs_wkt (p, 13,
		 "6012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],A");
    add_srs_wkt (p, 14, "XIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"2276\"]]");
    p = add_epsg_def (filter, first, last, 2277, "epsg", 2277,
		      "NAD83 / Texas Central (ftUS)");
    add_proj4text (p, 0,
		   "+proj=lcc +lat_1=31.88333333333333 +lat_2=30.11666666666");
    add_proj4text (p, 1,
		   "667 +lat_0=29.66666666666667 +lon_0=-100.3333333333333 +");
    add_proj4text (p, 2,
		   "x_0=699999.9998983998 +y_0=3000000 +ellps=GRS80 +towgs84");
    add_proj4text (p, 3, "=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83 / Texas Central (ftUS)\",GEOGCS[\"NAD83\"");
    add_srs_wkt (p, 1,
		 ",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
		 "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
		 "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIM");
    add_srs_wkt (p, 4,
		 "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
		 "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
		 "],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 7,
		 "formal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",31");
    add_srs_wkt (p, 8,
		 ".88333333333333],PARAMETER[\"standard_parallel_2\",30.11");
    add_srs_wkt (p, 9,
		 "666666666667],PARAMETER[\"latitude_of_origin\",29.666666");
    add_srs_wkt (p, 10,
		 "66666667],PARAMETER[\"central_meridian\",-100.3333333333");
    add_srs_wkt (p, 11,
		 "333],PARAMETER[\"false_easting\",2296583.333],PARAMETER[");
    add_srs_wkt (p, 12,
		 "\"false_northing\",9842500.000000002],UNIT[\"US survey f");
    add_srs_wkt (p, 13,
		 "oot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],A");
    add_srs_wkt (p, 14,
		 "XIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"2");
    add_srs_wkt (p, 15, "277\"]]");
    p = add_epsg_def (filter, first, last, 2278, "epsg", 2278,
		      "NAD83 / Texas South Central (ftUS)");
    add_proj4text (p, 0,
		   "+proj=lcc +lat_1=30.28333333333333 +lat_2=28.38333333333");
    add_proj4text (p, 1,
		   "333 +lat_0=27.83333333333333 +lon_0=-99 +x_0=600000 +y_0");
    add_proj4text (p, 2,
		   "=3999999.9998984 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +un");
    add_proj4text (p, 3, "its=us-ft +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83 / Texas South Central (ftUS)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
		 "AD83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GR");
    add_srs_wkt (p, 2,
		 "S 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019");
    add_srs_wkt (p, 3,
		 "\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]");
    add_srs_wkt (p, 4,
		 "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
		 "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
		 "122\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambe");
    add_srs_wkt (p, 7,
		 "rt_Conformal_Conic_2SP\"],PARAMETER[\"standard_parallel_");
    add_srs_wkt (p, 8,
		 "1\",30.28333333333333],PARAMETER[\"standard_parallel_2\"");
    add_srs_wkt (p, 9,
		 ",28.38333333333333],PARAMETER[\"latitude_of_origin\",27.");
    add_srs_wkt (p, 10,
		 "83333333333333],PARAMETER[\"central_meridian\",-99],PARA");
    add_srs_wkt (p, 11,
		 "METER[\"false_easting\",1968500],PARAMETER[\"false_north");
    add_srs_wkt (p, 12,
		 "ing\",13123333.333],UNIT[\"US survey foot\",0.3048006096");
    add_srs_wkt (p, 13,
		 "012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AX");
    add_srs_wkt (p, 14, "IS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"2278\"]]");
    p = add_epsg_def (filter, first, last, 2279, "epsg", 2279,
		      "NAD83 / Texas South (ftUS)");
    add_proj4text (p, 0,
		   "+proj=lcc +lat_1=27.83333333333333 +lat_2=26.16666666666");
    add_proj4text (p, 1,
		   "667 +lat_0=25.66666666666667 +lon_0=-98.5 +x_0=300000.00");
    add_proj4text (p, 2,
		   "00000001 +y_0=5000000.0001016 +ellps=GRS80 +towgs84=0,0,");
    add_proj4text (p, 3, "0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83 / Texas South (ftUS)\",GEOGCS[\"NAD83\",D");
    add_srs_wkt (p, 1,
		 "ATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
		 ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOW");
    add_srs_wkt (p, 3,
		 "GS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM");
    add_srs_wkt (p, 4,
		 "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
		 "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
		 "AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Confo");
    add_srs_wkt (p, 7,
		 "rmal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",27.8");
    add_srs_wkt (p, 8,
		 "3333333333333],PARAMETER[\"standard_parallel_2\",26.1666");
    add_srs_wkt (p, 9,
		 "6666666667],PARAMETER[\"latitude_of_origin\",25.66666666");
    add_srs_wkt (p, 10,
		 "666667],PARAMETER[\"central_meridian\",-98.5],PARAMETER[");
    add_srs_wkt (p, 11,
		 "\"false_easting\",984250.0000000002],PARAMETER[\"false_n");
    add_srs_wkt (p, 12,
		 "orthing\",16404166.667],UNIT[\"US survey foot\",0.304800");
    add_srs_wkt (p, 13,
		 "6096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST");
    add_srs_wkt (p, 14, "],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"2279\"]]");
    p = add_epsg_def (filter, first, last, 2280, "epsg", 2280,
		      "NAD83 / Utah North (ft)");
    add_proj4text (p, 0,
		   "+proj=lcc +lat_1=41.78333333333333 +lat_2=40.71666666666");
    add_proj4text (p, 1,
		   "667 +lat_0=40.33333333333334 +lon_0=-111.5 +x_0=500000.0");
    add_proj4text (p, 2,
		   "001504 +y_0=999999.9999960001 +ellps=GRS80 +towgs84=0,0,");
    add_proj4text (p, 3, "0,0,0,0,0 +units=ft +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83 / Utah North (ft)\",GEOGCS[\"NAD83\",DATU");
    add_srs_wkt (p, 1,
		 "M[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",63");
    add_srs_wkt (p, 2,
		 "78137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS8");
    add_srs_wkt (p, 3,
		 "4[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
		 "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
		 "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
		 "HORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 7,
		 "l_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",41.7833");
    add_srs_wkt (p, 8,
		 "3333333333],PARAMETER[\"standard_parallel_2\",40.7166666");
    add_srs_wkt (p, 9,
		 "6666667],PARAMETER[\"latitude_of_origin\",40.33333333333");
    add_srs_wkt (p, 10,
		 "334],PARAMETER[\"central_meridian\",-111.5],PARAMETER[\"");
    add_srs_wkt (p, 11,
		 "false_easting\",1640419.948],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 12,
		 ",3280839.895],UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
		 "9002\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 14, "EPSG\",\"2280\"]]");
    p = add_epsg_def (filter, first, last, 2281, "epsg", 2281,
		      "NAD83 / Utah Central (ft)");
    add_proj4text (p, 0,
		   "+proj=lcc +lat_1=40.65 +lat_2=39.01666666666667 +lat_0=3");
    add_proj4text (p, 1,
		   "8.33333333333334 +lon_0=-111.5 +x_0=500000.0001504 +y_0=");
    add_proj4text (p, 2,
		   "1999999.999992 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +unit");
    add_proj4text (p, 3, "s=ft +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83 / Utah Central (ft)\",GEOGCS[\"NAD83\",DA");
    add_srs_wkt (p, 1,
		 "TUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",");
    add_srs_wkt (p, 2,
		 "6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWG");
    add_srs_wkt (p, 3,
		 "S84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[");
    add_srs_wkt (p, 4,
		 "\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"deg");
    add_srs_wkt (p, 5,
		 "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 6,
		 "UTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Confor");
    add_srs_wkt (p, 7,
		 "mal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",40.65");
    add_srs_wkt (p, 8,
		 "],PARAMETER[\"standard_parallel_2\",39.01666666666667],P");
    add_srs_wkt (p, 9,
		 "ARAMETER[\"latitude_of_origin\",38.33333333333334],PARAM");
    add_srs_wkt (p, 10,
		 "ETER[\"central_meridian\",-111.5],PARAMETER[\"false_east");
    add_srs_wkt (p, 11,
		 "ing\",1640419.948],PARAMETER[\"false_northing\",6561679.");
    add_srs_wkt (p, 12,
		 "79],UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"9002\"]],A");
    add_srs_wkt (p, 13,
		 "XIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"2");
    add_srs_wkt (p, 14, "281\"]]");
    p = add_epsg_def (filter, first, last, 2282, "epsg", 2282,
		      "NAD83 / Utah South (ft)");
    add_proj4text (p, 0,
		   "+proj=lcc +lat_1=38.35 +lat_2=37.21666666666667 +lat_0=3");
    add_proj4text (p, 1,
		   "6.66666666666666 +lon_0=-111.5 +x_0=500000.0001504 +y_0=");
    add_proj4text (p, 2,
		   "2999999.999988 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +unit");
    add_proj4text (p, 3, "s=ft +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83 / Utah South (ft)\",GEOGCS[\"NAD83\",DATU");
    add_srs_wkt (p, 1,
		 "M[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",63");
    add_srs_wkt (p, 2,
		 "78137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS8");
    add_srs_wkt (p, 3,
		 "4[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
		 "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
		 "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
		 "HORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 7,
		 "l_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",38.35],");
    add_srs_wkt (p, 8,
		 "PARAMETER[\"standard_parallel_2\",37.21666666666667],PAR");
    add_srs_wkt (p, 9,
		 "AMETER[\"latitude_of_origin\",36.66666666666666],PARAMET");
    add_srs_wkt (p, 10,
		 "ER[\"central_meridian\",-111.5],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 11,
		 "g\",1640419.948],PARAMETER[\"false_northing\",9842519.68");
    add_srs_wkt (p, 12,
		 "5],UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"9002\"]],AX");
    add_srs_wkt (p, 13,
		 "IS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"22");
    add_srs_wkt (p, 14, "82\"]]");
    p = add_epsg_def (filter, first, last, 2283, "epsg", 2283,
		      "NAD83 / Virginia North (ftUS)");
    add_proj4text (p, 0,
		   "+proj=lcc +lat_1=39.2 +lat_2=38.03333333333333 +lat_0=37");
    add_proj4text (p, 1,
		   ".66666666666666 +lon_0=-78.5 +x_0=3500000.0001016 +y_0=2");
    add_proj4text (p, 2,
		   "000000.0001016 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +unit");
    add_proj4text (p, 3, "s=us-ft +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83 / Virginia North (ftUS)\",GEOGCS[\"NAD83\"");
    add_srs_wkt (p, 1,
		 ",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
		 "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
		 "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIM");
    add_srs_wkt (p, 4,
		 "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
		 "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
		 "],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 7,
		 "formal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",39");
    add_srs_wkt (p, 8,
		 ".2],PARAMETER[\"standard_parallel_2\",38.03333333333333]");
    add_srs_wkt (p, 9,
		 ",PARAMETER[\"latitude_of_origin\",37.66666666666666],PAR");
    add_srs_wkt (p, 10,
		 "AMETER[\"central_meridian\",-78.5],PARAMETER[\"false_eas");
    add_srs_wkt (p, 11,
		 "ting\",11482916.667],PARAMETER[\"false_northing\",656166");
    add_srs_wkt (p, 12,
		 "6.667],UNIT[\"US survey foot\",0.3048006096012192,AUTHOR");
    add_srs_wkt (p, 13,
		 "ITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORT");
    add_srs_wkt (p, 14, "H],AUTHORITY[\"EPSG\",\"2283\"]]");
    p = add_epsg_def (filter, first, last, 2284, "epsg", 2284,
		      "NAD83 / Virginia South (ftUS)");
    add_proj4text (p, 0,
		   "+proj=lcc +lat_1=37.96666666666667 +lat_2=36.76666666666");
    add_proj4text (p, 1,
		   "667 +lat_0=36.33333333333334 +lon_0=-78.5 +x_0=3500000.0");
    add_proj4text (p, 2,
		   "001016 +y_0=999999.9998983998 +ellps=GRS80 +towgs84=0,0,");
    add_proj4text (p, 3, "0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83 / Virginia South (ftUS)\",GEOGCS[\"NAD83\"");
    add_srs_wkt (p, 1,
		 ",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
		 "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
		 "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIM");
    add_srs_wkt (p, 4,
		 "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
		 "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
		 "],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 7,
		 "formal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",37");
    add_srs_wkt (p, 8,
		 ".96666666666667],PARAMETER[\"standard_parallel_2\",36.76");
    add_srs_wkt (p, 9,
		 "666666666667],PARAMETER[\"latitude_of_origin\",36.333333");
    add_srs_wkt (p, 10,
		 "33333334],PARAMETER[\"central_meridian\",-78.5],PARAMETE");
    add_srs_wkt (p, 11,
		 "R[\"false_easting\",11482916.667],PARAMETER[\"false_nort");
    add_srs_wkt (p, 12,
		 "hing\",3280833.333],UNIT[\"US survey foot\",0.3048006096");
    add_srs_wkt (p, 13,
		 "012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AX");
    add_srs_wkt (p, 14, "IS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"2284\"]]");
    p = add_epsg_def (filter, first, last, 2285, "epsg", 2285,
		      "NAD83 / Washington North (ftUS)");
    add_proj4text (p, 0,
		   "+proj=lcc +lat_1=48.73333333333333 +lat_2=47.5 +lat_0=47");
    add_proj4text (p, 1,
		   " +lon_0=-120.8333333333333 +x_0=500000.0001016001 +y_0=0");
    add_proj4text (p, 2,
		   " +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_de");
    add_proj4text (p, 3, "fs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83 / Washington North (ftUS)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
		 "3\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 2,
		 "980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]");
    add_srs_wkt (p, 3,
		 "],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],P");
    add_srs_wkt (p, 4,
		 "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
		 "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
		 "\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_");
    add_srs_wkt (p, 7,
		 "Conformal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\"");
    add_srs_wkt (p, 8,
		 ",48.73333333333333],PARAMETER[\"standard_parallel_2\",47");
    add_srs_wkt (p, 9,
		 ".5],PARAMETER[\"latitude_of_origin\",47],PARAMETER[\"cen");
    add_srs_wkt (p, 10,
		 "tral_meridian\",-120.8333333333333],PARAMETER[\"false_ea");
    add_srs_wkt (p, 11,
		 "sting\",1640416.667],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 12,
		 "T[\"US survey foot\",0.3048006096012192,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
		 "\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORI");
    add_srs_wkt (p, 14, "TY[\"EPSG\",\"2285\"]]");
    p = add_epsg_def (filter, first, last, 2286, "epsg", 2286,
		      "NAD83 / Washington South (ftUS)");
    add_proj4text (p, 0,
		   "+proj=lcc +lat_1=47.33333333333334 +lat_2=45.83333333333");
    add_proj4text (p, 1,
		   "334 +lat_0=45.33333333333334 +lon_0=-120.5 +x_0=500000.0");
    add_proj4text (p, 2,
		   "001016001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +un");
    add_proj4text (p, 3, "its=us-ft +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83 / Washington South (ftUS)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
		 "3\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 2,
		 "980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]");
    add_srs_wkt (p, 3,
		 "],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],P");
    add_srs_wkt (p, 4,
		 "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
		 "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
		 "\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_");
    add_srs_wkt (p, 7,
		 "Conformal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\"");
    add_srs_wkt (p, 8,
		 ",47.33333333333334],PARAMETER[\"standard_parallel_2\",45");
    add_srs_wkt (p, 9,
		 ".83333333333334],PARAMETER[\"latitude_of_origin\",45.333");
    add_srs_wkt (p, 10,
		 "33333333334],PARAMETER[\"central_meridian\",-120.5],PARA");
    add_srs_wkt (p, 11,
		 "METER[\"false_easting\",1640416.667],PARAMETER[\"false_n");
    add_srs_wkt (p, 12,
		 "orthing\",0],UNIT[\"US survey foot\",0.3048006096012192,");
    add_srs_wkt (p, 13,
		 "AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\"");
    add_srs_wkt (p, 14, ",NORTH],AUTHORITY[\"EPSG\",\"2286\"]]");
    p = add_epsg_def (filter, first, last, 2287, "epsg", 2287,
		      "NAD83 / Wisconsin North (ftUS)");
    add_proj4text (p, 0,
		   "+proj=lcc +lat_1=46.76666666666667 +lat_2=45.56666666666");
    add_proj4text (p, 1,
		   "667 +lat_0=45.16666666666666 +lon_0=-90 +x_0=600000 +y_0");
    add_proj4text (p, 2,
		   "=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_");
    add_proj4text (p, 3, "defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83 / Wisconsin North (ftUS)\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
		 "\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 2,
		 "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 3,
		 ",TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PR");
    add_srs_wkt (p, 4,
		 "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
		 "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
		 "]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Co");
    add_srs_wkt (p, 7,
		 "nformal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",4");
    add_srs_wkt (p, 8,
		 "6.76666666666667],PARAMETER[\"standard_parallel_2\",45.5");
    add_srs_wkt (p, 9,
		 "6666666666667],PARAMETER[\"latitude_of_origin\",45.16666");
    add_srs_wkt (p, 10,
		 "666666666],PARAMETER[\"central_meridian\",-90],PARAMETER");
    add_srs_wkt (p, 11,
		 "[\"false_easting\",1968500],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 12,
		 ",0],UNIT[\"US survey foot\",0.3048006096012192,AUTHORITY");
    add_srs_wkt (p, 13,
		 "[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],");
    add_srs_wkt (p, 14, "AUTHORITY[\"EPSG\",\"2287\"]]");
    p = add_epsg_def (filter, first, last, 2288, "epsg", 2288,
		      "NAD83 / Wisconsin Central (ftUS)");
    add_proj4text (p, 0,
		   "+proj=lcc +lat_1=45.5 +lat_2=44.25 +lat_0=43.83333333333");
    add_proj4text (p, 1,
		   "334 +lon_0=-90 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=");
    add_proj4text (p, 2, "0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83 / Wisconsin Central (ftUS)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
		 "83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 2,
		 "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
		 "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],");
    add_srs_wkt (p, 4,
		 "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
		 "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
		 "2\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert");
    add_srs_wkt (p, 7,
		 "_Conformal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\"");
    add_srs_wkt (p, 8,
		 ",45.5],PARAMETER[\"standard_parallel_2\",44.25],PARAMETE");
    add_srs_wkt (p, 9,
		 "R[\"latitude_of_origin\",43.83333333333334],PARAMETER[\"");
    add_srs_wkt (p, 10,
		 "central_meridian\",-90],PARAMETER[\"false_easting\",1968");
    add_srs_wkt (p, 11,
		 "500],PARAMETER[\"false_northing\",0],UNIT[\"US survey fo");
    add_srs_wkt (p, 12,
		 "ot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AX");
    add_srs_wkt (p, 13,
		 "IS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"22");
    add_srs_wkt (p, 14, "88\"]]");
    p = add_epsg_def (filter, first, last, 2289, "epsg", 2289,
		      "NAD83 / Wisconsin South (ftUS)");
    add_proj4text (p, 0,
		   "+proj=lcc +lat_1=44.06666666666667 +lat_2=42.73333333333");
    add_proj4text (p, 1,
		   "333 +lat_0=42 +lon_0=-90 +x_0=600000 +y_0=0 +ellps=GRS80");
    add_proj4text (p, 2, " +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83 / Wisconsin South (ftUS)\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
		 "\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 2,
		 "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 3,
		 ",TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PR");
    add_srs_wkt (p, 4,
		 "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
		 "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
		 "]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Co");
    add_srs_wkt (p, 7,
		 "nformal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",4");
    add_srs_wkt (p, 8,
		 "4.06666666666667],PARAMETER[\"standard_parallel_2\",42.7");
    add_srs_wkt (p, 9,
		 "3333333333333],PARAMETER[\"latitude_of_origin\",42],PARA");
    add_srs_wkt (p, 10,
		 "METER[\"central_meridian\",-90],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 11,
		 "g\",1968500],PARAMETER[\"false_northing\",0],UNIT[\"US s");
    add_srs_wkt (p, 12,
		 "urvey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 13,
		 "3\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 14, "G\",\"2289\"]]");
    p = add_epsg_def (filter, first, last, 2290, "epsg", 2290,
		      "ATS77 / Prince Edward Isl. Stereographic (ATS77)");
    add_proj4text (p, 0,
		   "+proj=sterea +lat_0=47.25 +lon_0=-63 +k=0.999912 +x_0=70");
    add_proj4text (p, 1,
		   "0000 +y_0=400000 +a=6378135 +b=6356750.304921594 +units=");
    add_proj4text (p, 2, "m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"ATS77 / Prince Edward Isl. Stereographic (ATS77");
    add_srs_wkt (p, 1,
		 ")\",GEOGCS[\"ATS77\",DATUM[\"Average_Terrestrial_System_");
    add_srs_wkt (p, 2,
		 "1977\",SPHEROID[\"Average Terrestrial System 1977\",6378");
    add_srs_wkt (p, 3,
		 "135,298.257,AUTHORITY[\"EPSG\",\"7041\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 4,
		 "SG\",\"6122\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
		 ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
		 "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4122\"]],PROJE");
    add_srs_wkt (p, 7,
		 "CTION[\"Oblique_Stereographic\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
		 "_origin\",47.25],PARAMETER[\"central_meridian\",-63],PAR");
    add_srs_wkt (p, 9,
		 "AMETER[\"scale_factor\",0.999912],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
		 "ing\",700000],PARAMETER[\"false_northing\",400000],UNIT[");
    add_srs_wkt (p, 11,
		 "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E(X)\",");
    add_srs_wkt (p, 12,
		 "EAST],AXIS[\"N(Y)\",NORTH],AUTHORITY[\"EPSG\",\"2290\"]]");
    p = add_epsg_def (filter, first, last, 2291, "epsg", 2291,
		      "NAD83(CSRS98) / Prince Edward Isl. Stereographic (NAD83) (deprecated)");
    add_proj4text (p, 0,
		   "+proj=sterea +lat_0=47.25 +lon_0=-63 +k=0.999912 +x_0=40");
    add_proj4text (p, 1,
		   "0000 +y_0=800000 +a=6378135 +b=6356750.304921594 +units=");
    add_proj4text (p, 2, "m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83(CSRS98) / Prince Edward Isl. Stereographi");
    add_srs_wkt (p, 1,
		 "c (NAD83) (deprecated)\",GEOGCS[\"ATS77\",DATUM[\"Averag");
    add_srs_wkt (p, 2,
		 "e_Terrestrial_System_1977\",SPHEROID[\"Average Terrestri");
    add_srs_wkt (p, 3,
		 "al System 1977\",6378135,298.257,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 4,
		 "41\"]],AUTHORITY[\"EPSG\",\"6122\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 5,
		 ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 6,
		 "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 7,
		 "SG\",\"4122\"]],PROJECTION[\"Oblique_Stereographic\"],PA");
    add_srs_wkt (p, 8,
		 "RAMETER[\"latitude_of_origin\",47.25],PARAMETER[\"centra");
    add_srs_wkt (p, 9,
		 "l_meridian\",-63],PARAMETER[\"scale_factor\",0.999912],P");
    add_srs_wkt (p, 10,
		 "ARAMETER[\"false_easting\",400000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 11,
		 "thing\",800000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 12,
		 "01\"]],AXIS[\"E(X)\",EAST],AXIS[\"N(Y)\",NORTH],AUTHORIT");
    add_srs_wkt (p, 13, "Y[\"EPSG\",\"2291\"]]");
    p = add_epsg_def (filter, first, last, 2292, "epsg", 2292,
		      "NAD83(CSRS98) / Prince Edward Isl. Stereographic (NAD83) (deprecated)");
    add_proj4text (p, 0,
		   "+proj=sterea +lat_0=47.25 +lon_0=-63 +k=0.999912 +x_0=40");
    add_proj4text (p, 1,
		   "0000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +un");
    add_proj4text (p, 2, "its=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"NAD83(CSRS98) / Prince Edward Isl. Stereographi");
    add_srs_wkt (p, 1,
		 "c (NAD83) (deprecated)\",GEOGCS[\"NAD83(CSRS98)\",DATUM[");
    add_srs_wkt (p, 2,
		 "\"NAD83_Canadian_Spatial_Reference_System\",SPHEROID[\"G");
    add_srs_wkt (p, 3,
		 "RS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"701");
    add_srs_wkt (p, 4,
		 "9\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6140\"");
    add_srs_wkt (p, 5,
		 "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 6,
		 "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "9108\"]],AUTHORITY[\"EPSG\",\"4140\"]],PROJECTION[\"Obli");
    add_srs_wkt (p, 8,
		 "que_Stereographic\"],PARAMETER[\"latitude_of_origin\",47");
    add_srs_wkt (p, 9,
		 ".25],PARAMETER[\"central_meridian\",-63],PARAMETER[\"sca");
    add_srs_wkt (p, 10,
		 "le_factor\",0.999912],PARAMETER[\"false_easting\",400000");
    add_srs_wkt (p, 11,
		 "],PARAMETER[\"false_northing\",800000],UNIT[\"metre\",1,");
    add_srs_wkt (p, 12,
		 "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E(X)\",EAST],AXIS[\"");
    add_srs_wkt (p, 13, "N(Y)\",NORTH],AUTHORITY[\"EPSG\",\"2292\"]]");
    p = add_epsg_def (filter, first, last, 2294, "epsg", 2294,
		      "ATS77 / MTM Nova Scotia zone 4");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=-61.5 +k=0.9999 +x_0=4500000");
    add_proj4text (p, 1,
		   " +y_0=0 +a=6378135 +b=6356750.304921594 +units=m +no_def");
    add_proj4text (p, 2, "s");
    add_srs_wkt (p, 0,
		 "PROJCS[\"ATS77 / MTM Nova Scotia zone 4\",GEOGCS[\"ATS77");
    add_srs_wkt (p, 1,
		 "\",DATUM[\"Average_Terrestrial_System_1977\",SPHEROID[\"");
    add_srs_wkt (p, 2,
		 "Average Terrestrial System 1977\",6378135,298.257,AUTHOR");
    add_srs_wkt (p, 3,
		 "ITY[\"EPSG\",\"7041\"]],AUTHORITY[\"EPSG\",\"6122\"]],PR");
    add_srs_wkt (p, 4,
		 "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
		 "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
		 "]],AUTHORITY[\"EPSG\",\"4122\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 7,
		 "_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMET");
    add_srs_wkt (p, 8,
		 "ER[\"central_meridian\",-61.5],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 9,
		 ",0.9999],PARAMETER[\"false_easting\",4500000],PARAMETER[");
    add_srs_wkt (p, 10,
		 "\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 11,
		 ",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 12, "TH],AUTHORITY[\"EPSG\",\"2294\"]]");
    p = add_epsg_def (filter, first, last, 2295, "epsg", 2295,
		      "ATS77 / MTM Nova Scotia zone 5");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=-64.5 +k=0.9999 +x_0=5500000");
    add_proj4text (p, 1,
		   " +y_0=0 +a=6378135 +b=6356750.304921594 +units=m +no_def");
    add_proj4text (p, 2, "s");
    add_srs_wkt (p, 0,
		 "PROJCS[\"ATS77 / MTM Nova Scotia zone 5\",GEOGCS[\"ATS77");
    add_srs_wkt (p, 1,
		 "\",DATUM[\"Average_Terrestrial_System_1977\",SPHEROID[\"");
    add_srs_wkt (p, 2,
		 "Average Terrestrial System 1977\",6378135,298.257,AUTHOR");
    add_srs_wkt (p, 3,
		 "ITY[\"EPSG\",\"7041\"]],AUTHORITY[\"EPSG\",\"6122\"]],PR");
    add_srs_wkt (p, 4,
		 "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
		 "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
		 "]],AUTHORITY[\"EPSG\",\"4122\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 7,
		 "_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMET");
    add_srs_wkt (p, 8,
		 "ER[\"central_meridian\",-64.5],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 9,
		 ",0.9999],PARAMETER[\"false_easting\",5500000],PARAMETER[");
    add_srs_wkt (p, 10,
		 "\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 11,
		 ",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 12, "TH],AUTHORITY[\"EPSG\",\"2295\"]]");
    p = add_epsg_def (filter, first, last, 2308, "epsg", 2308,
		      "Batavia / TM 109 SE");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=109 +k=0.9996 +x_0=500000 +y");
    add_proj4text (p, 1,
		   "_0=10000000 +ellps=bessel +towgs84=-377,681,-50,0,0,0,0 ");
    add_proj4text (p, 2, "+units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Batavia / TM 109 SE\",GEOGCS[\"Batavia\",DATUM[");
    add_srs_wkt (p, 1,
		 "\"Batavia\",SPHEROID[\"Bessel 1841\",6377397.155,299.152");
    add_srs_wkt (p, 2,
		 "8128,AUTHORITY[\"EPSG\",\"7004\"]],TOWGS84[-377,681,-50,");
    add_srs_wkt (p, 3,
		 "0,0,0,0],AUTHORITY[\"EPSG\",\"6211\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
		 "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
		 "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
		 "EPSG\",\"4211\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
		 "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
		 "ridian\",109],PARAMETER[\"scale_factor\",0.9996],PARAMET");
    add_srs_wkt (p, 9,
		 "ER[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
		 ",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 11,
		 "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 12, "ITY[\"EPSG\",\"2308\"]]");
    p = add_epsg_def (filter, first, last, 2309, "epsg", 2309,
		      "WGS 84 / TM 116 SE");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=116 +k=0.9996 +x_0=500000 +y");
    add_proj4text (p, 1, "_0=10000000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"WGS 84 / TM 116 SE\",GEOGCS[\"WGS 84\",DATUM[\"");
    add_srs_wkt (p, 1,
		 "WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUT");
    add_srs_wkt (p, 2,
		 "HORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]]");
    add_srs_wkt (p, 3,
		 ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 4,
		 "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 5,
		 "22\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 6,
		 "erse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PAR");
    add_srs_wkt (p, 7,
		 "AMETER[\"central_meridian\",116],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 8,
		 "r\",0.9996],PARAMETER[\"false_easting\",500000],PARAMETE");
    add_srs_wkt (p, 9,
		 "R[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 10,
		 "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 11, "hing\",NORTH],AUTHORITY[\"EPSG\",\"2309\"]]");
    p = add_epsg_def (filter, first, last, 2310, "epsg", 2310,
		      "WGS 84 / TM 132 SE");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=132 +k=0.9996 +x_0=500000 +y");
    add_proj4text (p, 1, "_0=10000000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"WGS 84 / TM 132 SE\",GEOGCS[\"WGS 84\",DATUM[\"");
    add_srs_wkt (p, 1,
		 "WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUT");
    add_srs_wkt (p, 2,
		 "HORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]]");
    add_srs_wkt (p, 3,
		 ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 4,
		 "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 5,
		 "22\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 6,
		 "erse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PAR");
    add_srs_wkt (p, 7,
		 "AMETER[\"central_meridian\",132],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 8,
		 "r\",0.9996],PARAMETER[\"false_easting\",500000],PARAMETE");
    add_srs_wkt (p, 9,
		 "R[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 10,
		 "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 11, "hing\",NORTH],AUTHORITY[\"EPSG\",\"2310\"]]");
    p = add_epsg_def (filter, first, last, 2311, "epsg", 2311,
		      "WGS 84 / TM 6 NE");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=6 +k=0.9996 +x_0=500000 +y_0");
    add_proj4text (p, 1, "=0 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"WGS 84 / TM 6 NE\",GEOGCS[\"WGS 84\",DATUM[\"WG");
    add_srs_wkt (p, 1,
		 "S_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUTHO");
    add_srs_wkt (p, 2,
		 "RITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]],P");
    add_srs_wkt (p, 3,
		 "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 4,
		 "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 5,
		 "\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 6,
		 "se_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAM");
    add_srs_wkt (p, 7,
		 "ETER[\"central_meridian\",6],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 8,
		 "0.9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 9,
		 "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 10,
		 "\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 11, "H],AUTHORITY[\"EPSG\",\"2311\"]]");
    p = add_epsg_def (filter, first, last, 2312, "epsg", 2312,
		      "Garoua / UTM zone 33N");
    add_proj4text (p, 0, "+proj=utm +zone=33 +ellps=clrk80 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Garoua / UTM zone 33N\",GEOGCS[\"Garoua\",DATUM");
    add_srs_wkt (p, 1,
		 "[\"Garoua\",SPHEROID[\"Clarke 1880 (RGS)\",6378249.145,2");
    add_srs_wkt (p, 2,
		 "93.465,AUTHORITY[\"EPSG\",\"7012\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
		 "\"6197\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 4,
		 "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
		 "PSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4197\"]],PROJECTIO");
    add_srs_wkt (p, 6,
		 "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 7,
		 "n\",0],PARAMETER[\"central_meridian\",15],PARAMETER[\"sc");
    add_srs_wkt (p, 8,
		 "ale_factor\",0.9996],PARAMETER[\"false_easting\",500000]");
    add_srs_wkt (p, 9,
		 ",PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 10,
		 "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 11, "rthing\",NORTH],AUTHORITY[\"EPSG\",\"2312\"]]");
    p = add_epsg_def (filter, first, last, 2313, "epsg", 2313,
		      "Kousseri / UTM zone 33N");
    add_proj4text (p, 0, "+proj=utm +zone=33 +ellps=clrk80 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Kousseri / UTM zone 33N\",GEOGCS[\"Kousseri\",D");
    add_srs_wkt (p, 1,
		 "ATUM[\"Kousseri\",SPHEROID[\"Clarke 1880 (RGS)\",6378249");
    add_srs_wkt (p, 2,
		 ".145,293.465,AUTHORITY[\"EPSG\",\"7012\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 3,
		 "PSG\",\"6198\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
		 "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 5,
		 "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4198\"]],PRO");
    add_srs_wkt (p, 6,
		 "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 7,
		 "_origin\",0],PARAMETER[\"central_meridian\",15],PARAMETE");
    add_srs_wkt (p, 8,
		 "R[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",5");
    add_srs_wkt (p, 9,
		 "00000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 10,
		 "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXI");
    add_srs_wkt (p, 11, "S[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2313\"]]");
    p = add_epsg_def (filter, first, last, 2314, "epsg", 2314,
		      "Trinidad 1903 / Trinidad Grid (ftCla)");
    add_proj4text (p, 0,
		   "+proj=cass +lat_0=10.44166666666667 +lon_0=-61.333333333");
    add_proj4text (p, 1,
		   "33334 +x_0=86501.46392052001 +y_0=65379.0134283 +a=63782");
    add_proj4text (p, 2,
		   "93.645208759 +b=6356617.987679838 +towgs84=-61.702,284.4");
    add_proj4text (p, 3, "88,472.052,0,0,0,0 +to_meter=0.3047972654 +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Trinidad 1903 / Trinidad Grid (ftCla)\",GEOGCS[");
    add_srs_wkt (p, 1,
		 "\"Trinidad 1903\",DATUM[\"Trinidad_1903\",SPHEROID[\"Cla");
    add_srs_wkt (p, 2,
		 "rke 1858\",6378293.645208759,294.2606763692654,AUTHORITY");
    add_srs_wkt (p, 3,
		 "[\"EPSG\",\"7007\"]],TOWGS84[-61.702,284.488,472.052,0,0");
    add_srs_wkt (p, 4,
		 ",0,0],AUTHORITY[\"EPSG\",\"6302\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 5,
		 ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 6,
		 "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 7,
		 "SG\",\"4302\"]],PROJECTION[\"Cassini_Soldner\"],PARAMETE");
    add_srs_wkt (p, 8,
		 "R[\"latitude_of_origin\",10.44166666666667],PARAMETER[\"");
    add_srs_wkt (p, 9,
		 "central_meridian\",-61.33333333333334],PARAMETER[\"false");
    add_srs_wkt (p, 10,
		 "_easting\",283800],PARAMETER[\"false_northing\",214500],");
    add_srs_wkt (p, 11,
		 "UNIT[\"Clarke's foot\",0.3047972654,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
		 "9005\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 13, ",AUTHORITY[\"EPSG\",\"2314\"]]");
    p = add_epsg_def (filter, first, last, 2315, "epsg", 2315,
		      "Campo Inchauspe / UTM zone 19S");
    add_proj4text (p, 0,
		   "+proj=utm +zone=19 +south +ellps=intl +towgs84=-148,136,");
    add_proj4text (p, 1, "90,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Campo Inchauspe / UTM zone 19S\",GEOGCS[\"Campo");
    add_srs_wkt (p, 1,
		 " Inchauspe\",DATUM[\"Campo_Inchauspe\",SPHEROID[\"Intern");
    add_srs_wkt (p, 2,
		 "ational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]]");
    add_srs_wkt (p, 3,
		 ",TOWGS84[-148,136,90,0,0,0,0],AUTHORITY[\"EPSG\",\"6221\"");
    add_srs_wkt (p, 4,
		 "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
		 "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
		 "9122\"]],AUTHORITY[\"EPSG\",\"4221\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
		 "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
		 "ARAMETER[\"central_meridian\",-69],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
		 "tor\",0.9996],PARAMETER[\"false_easting\",500000],PARAME");
    add_srs_wkt (p, 10,
		 "TER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 11,
		 "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 12, "rthing\",NORTH],AUTHORITY[\"EPSG\",\"2315\"]]");
    p = add_epsg_def (filter, first, last, 2316, "epsg", 2316,
		      "Campo Inchauspe / UTM zone 20S");
    add_proj4text (p, 0,
		   "+proj=utm +zone=20 +south +ellps=intl +towgs84=-148,136,");
    add_proj4text (p, 1, "90,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Campo Inchauspe / UTM zone 20S\",GEOGCS[\"Campo");
    add_srs_wkt (p, 1,
		 " Inchauspe\",DATUM[\"Campo_Inchauspe\",SPHEROID[\"Intern");
    add_srs_wkt (p, 2,
		 "ational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]]");
    add_srs_wkt (p, 3,
		 ",TOWGS84[-148,136,90,0,0,0,0],AUTHORITY[\"EPSG\",\"6221\"");
    add_srs_wkt (p, 4,
		 "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
		 "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
		 "9122\"]],AUTHORITY[\"EPSG\",\"4221\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
		 "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
		 "ARAMETER[\"central_meridian\",-63],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
		 "tor\",0.9996],PARAMETER[\"false_easting\",500000],PARAME");
    add_srs_wkt (p, 10,
		 "TER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 11,
		 "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 12, "rthing\",NORTH],AUTHORITY[\"EPSG\",\"2316\"]]");
    p = add_epsg_def (filter, first, last, 2317, "epsg", 2317,
		      "PSAD56 / ICN Regional");
    add_proj4text (p, 0,
		   "+proj=lcc +lat_1=9 +lat_2=3 +lat_0=6 +lon_0=-66 +x_0=100");
    add_proj4text (p, 1,
		   "0000 +y_0=1000000 +ellps=intl +towgs84=-288,175,-376,0,0");
    add_proj4text (p, 2, ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"PSAD56 / ICN Regional\",GEOGCS[\"PSAD56\",DATUM");
    add_srs_wkt (p, 1,
		 "[\"Provisional_South_American_Datum_1956\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
		 "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
		 "\"]],TOWGS84[-288,175,-376,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
		 "6248\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
		 "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
		 "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4248\"]],PROJECTION[");
    add_srs_wkt (p, 7,
		 "\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 8,
		 "rallel_1\",9],PARAMETER[\"standard_parallel_2\",3],PARAM");
    add_srs_wkt (p, 9,
		 "ETER[\"latitude_of_origin\",6],PARAMETER[\"central_merid");
    add_srs_wkt (p, 10,
		 "ian\",-66],PARAMETER[\"false_easting\",1000000],PARAMETE");
    add_srs_wkt (p, 11,
		 "R[\"false_northing\",1000000],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 12,
		 "[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],");
    add_srs_wkt (p, 13, "AUTHORITY[\"EPSG\",\"2317\"]]");
    p = add_epsg_def (filter, first, last, 2318, "epsg", 2318,
		      "Ain el Abd / Aramco Lambert");
    add_proj4text (p, 0,
		   "+proj=lcc +lat_1=17 +lat_2=33 +lat_0=25.08951 +lon_0=48 ");
    add_proj4text (p, 1,
		   "+x_0=0 +y_0=0 +ellps=intl +towgs84=-143,-236,7,0,0,0,0 +");
    add_proj4text (p, 2, "units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Ain el Abd / Aramco Lambert\",GEOGCS[\"Ain el A");
    add_srs_wkt (p, 1,
		 "bd\",DATUM[\"Ain_el_Abd_1970\",SPHEROID[\"International ");
    add_srs_wkt (p, 2,
		 "1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84");
    add_srs_wkt (p, 3,
		 "[-143,-236,7,0,0,0,0],AUTHORITY[\"EPSG\",\"6204\"]],PRIM");
    add_srs_wkt (p, 4,
		 "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
		 "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
		 "],AUTHORITY[\"EPSG\",\"4204\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 7,
		 "formal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",17");
    add_srs_wkt (p, 8,
		 "],PARAMETER[\"standard_parallel_2\",33],PARAMETER[\"lati");
    add_srs_wkt (p, 9,
		 "tude_of_origin\",25.08951],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 10,
		 ",48],PARAMETER[\"false_easting\",0],PARAMETER[\"false_no");
    add_srs_wkt (p, 11,
		 "rthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
		 "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13, "RITY[\"EPSG\",\"2318\"]]");
    p = add_epsg_def (filter, first, last, 2319, "epsg", 2319, "ED50 / TM27");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
		   "ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_de");
    add_proj4text (p, 2, "fs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"ED50 / TM27\",GEOGCS[\"ED50\",DATUM[\"European_");
    add_srs_wkt (p, 1,
		 "Datum_1950\",SPHEROID[\"International 1924\",6378388,297");
    add_srs_wkt (p, 2,
		 ",AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-87,-98,-121,0,0,");
    add_srs_wkt (p, 3,
		 "0,0],AUTHORITY[\"EPSG\",\"6230\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
		 "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
		 "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
		 "G\",\"4230\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
		 "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
		 "ian\",27],PARAMETER[\"scale_factor\",1],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
		 "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
		 "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NO");
    add_srs_wkt (p, 11, "RTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2319\"]]");
    p = add_epsg_def (filter, first, last, 2320, "epsg", 2320, "ED50 / TM30");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=30 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
		   "ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_de");
    add_proj4text (p, 2, "fs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"ED50 / TM30\",GEOGCS[\"ED50\",DATUM[\"European_");
    add_srs_wkt (p, 1,
		 "Datum_1950\",SPHEROID[\"International 1924\",6378388,297");
    add_srs_wkt (p, 2,
		 ",AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-87,-98,-121,0,0,");
    add_srs_wkt (p, 3,
		 "0,0],AUTHORITY[\"EPSG\",\"6230\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
		 "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
		 "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
		 "G\",\"4230\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
		 "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
		 "ian\",30],PARAMETER[\"scale_factor\",1],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
		 "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
		 "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NO");
    add_srs_wkt (p, 11, "RTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2320\"]]");
    p = add_epsg_def (filter, first, last, 2321, "epsg", 2321, "ED50 / TM33");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
		   "ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_de");
    add_proj4text (p, 2, "fs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"ED50 / TM33\",GEOGCS[\"ED50\",DATUM[\"European_");
    add_srs_wkt (p, 1,
		 "Datum_1950\",SPHEROID[\"International 1924\",6378388,297");
    add_srs_wkt (p, 2,
		 ",AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-87,-98,-121,0,0,");
    add_srs_wkt (p, 3,
		 "0,0],AUTHORITY[\"EPSG\",\"6230\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
		 "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
		 "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
		 "G\",\"4230\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
		 "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
		 "ian\",33],PARAMETER[\"scale_factor\",1],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
		 "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
		 "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NO");
    add_srs_wkt (p, 11, "RTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2321\"]]");
    p = add_epsg_def (filter, first, last, 2322, "epsg", 2322, "ED50 / TM36");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=36 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
		   "ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_de");
    add_proj4text (p, 2, "fs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"ED50 / TM36\",GEOGCS[\"ED50\",DATUM[\"European_");
    add_srs_wkt (p, 1,
		 "Datum_1950\",SPHEROID[\"International 1924\",6378388,297");
    add_srs_wkt (p, 2,
		 ",AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-87,-98,-121,0,0,");
    add_srs_wkt (p, 3,
		 "0,0],AUTHORITY[\"EPSG\",\"6230\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
		 "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
		 "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
		 "G\",\"4230\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
		 "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
		 "ian\",36],PARAMETER[\"scale_factor\",1],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
		 "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
		 "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NO");
    add_srs_wkt (p, 11, "RTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2322\"]]");
    p = add_epsg_def (filter, first, last, 2323, "epsg", 2323, "ED50 / TM39");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
		   "ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_de");
    add_proj4text (p, 2, "fs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"ED50 / TM39\",GEOGCS[\"ED50\",DATUM[\"European_");
    add_srs_wkt (p, 1,
		 "Datum_1950\",SPHEROID[\"International 1924\",6378388,297");
    add_srs_wkt (p, 2,
		 ",AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-87,-98,-121,0,0,");
    add_srs_wkt (p, 3,
		 "0,0],AUTHORITY[\"EPSG\",\"6230\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
		 "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
		 "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
		 "G\",\"4230\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
		 "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
		 "ian\",39],PARAMETER[\"scale_factor\",1],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
		 "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
		 "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NO");
    add_srs_wkt (p, 11, "RTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2323\"]]");
    p = add_epsg_def (filter, first, last, 2324, "epsg", 2324, "ED50 / TM42");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=42 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
		   "ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_de");
    add_proj4text (p, 2, "fs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"ED50 / TM42\",GEOGCS[\"ED50\",DATUM[\"European_");
    add_srs_wkt (p, 1,
		 "Datum_1950\",SPHEROID[\"International 1924\",6378388,297");
    add_srs_wkt (p, 2,
		 ",AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-87,-98,-121,0,0,");
    add_srs_wkt (p, 3,
		 "0,0],AUTHORITY[\"EPSG\",\"6230\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
		 "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
		 "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
		 "G\",\"4230\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
		 "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
		 "ian\",42],PARAMETER[\"scale_factor\",1],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
		 "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
		 "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NO");
    add_srs_wkt (p, 11, "RTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2324\"]]");
}

static void
initialize_epsg_03 (int filter, struct epsg_defs **first,
		    struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def (filter, first, last, 2325, "epsg", 2325, "ED50 / TM45");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
		   "ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_de");
    add_proj4text (p, 2, "fs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"ED50 / TM45\",GEOGCS[\"ED50\",DATUM[\"European_");
    add_srs_wkt (p, 1,
		 "Datum_1950\",SPHEROID[\"International 1924\",6378388,297");
    add_srs_wkt (p, 2,
		 ",AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-87,-98,-121,0,0,");
    add_srs_wkt (p, 3,
		 "0,0],AUTHORITY[\"EPSG\",\"6230\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
		 "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
		 "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
		 "G\",\"4230\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
		 "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
		 "ian\",45],PARAMETER[\"scale_factor\",1],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
		 "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
		 "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NO");
    add_srs_wkt (p, 11, "RTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2325\"]]");
    p = add_epsg_def (filter, first, last, 2326, "epsg", 2326,
		      "Hong Kong 1980 Grid System");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=22.31213333333334 +lon_0=114.17855555");
    add_proj4text (p, 1,
		   "55556 +k=1 +x_0=836694.05 +y_0=819069.8 +ellps=intl +tow");
    add_proj4text (p, 2,
		   "gs84=-162.619,-276.959,-161.764,0.067753,-2.24365,-1.158");
    add_proj4text (p, 3, "83,-1.09425 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Hong Kong 1980 Grid System\",GEOGCS[\"Hong Kong");
    add_srs_wkt (p, 1,
		 " 1980\",DATUM[\"Hong_Kong_1980\",SPHEROID[\"Internationa");
    add_srs_wkt (p, 2,
		 "l 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS");
    add_srs_wkt (p, 3,
		 "84[-162.619,-276.959,-161.764,0.067753,-2.24365,-1.15883");
    add_srs_wkt (p, 4,
		 ",-1.09425],AUTHORITY[\"EPSG\",\"6611\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 5,
		 "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 6,
		 "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY");
    add_srs_wkt (p, 7,
		 "[\"EPSG\",\"4611\"]],PROJECTION[\"Transverse_Mercator\"]");
    add_srs_wkt (p, 8,
		 ",PARAMETER[\"latitude_of_origin\",22.31213333333334],PAR");
    add_srs_wkt (p, 9,
		 "AMETER[\"central_meridian\",114.1785555555556],PARAMETER");
    add_srs_wkt (p, 10,
		 "[\"scale_factor\",1],PARAMETER[\"false_easting\",836694.");
    add_srs_wkt (p, 11,
		 "05],PARAMETER[\"false_northing\",819069.8],UNIT[\"metre\"");
    add_srs_wkt (p, 12,
		 ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH");
    add_srs_wkt (p, 13,
		 "],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2326\"]]");
    p = add_epsg_def (filter, first, last, 2327, "epsg", 2327,
		      "Xian 1980 / Gauss-Kruger zone 13");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=13500000 +y_0=0");
    add_proj4text (p, 1, " +a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Xian 1980 / Gauss-Kruger zone 13\",GEOGCS[\"Xia");
    add_srs_wkt (p, 1,
		 "n 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 1975\",63781");
    add_srs_wkt (p, 2,
		 "40,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
		 "G\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
		 ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
		 "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4610\"]],PROJE");
    add_srs_wkt (p, 6,
		 "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
		 "rigin\",0],PARAMETER[\"central_meridian\",75],PARAMETER[");
    add_srs_wkt (p, 8,
		 "\"scale_factor\",1],PARAMETER[\"false_easting\",13500000");
    add_srs_wkt (p, 9,
		 "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 10,
		 "RITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EA");
    add_srs_wkt (p, 11, "ST],AUTHORITY[\"EPSG\",\"2327\"]]");
    p = add_epsg_def (filter, first, last, 2328, "epsg", 2328,
		      "Xian 1980 / Gauss-Kruger zone 14");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=14500000 +y_0=0");
    add_proj4text (p, 1, " +a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Xian 1980 / Gauss-Kruger zone 14\",GEOGCS[\"Xia");
    add_srs_wkt (p, 1,
		 "n 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 1975\",63781");
    add_srs_wkt (p, 2,
		 "40,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
		 "G\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
		 ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
		 "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4610\"]],PROJE");
    add_srs_wkt (p, 6,
		 "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
		 "rigin\",0],PARAMETER[\"central_meridian\",81],PARAMETER[");
    add_srs_wkt (p, 8,
		 "\"scale_factor\",1],PARAMETER[\"false_easting\",14500000");
    add_srs_wkt (p, 9,
		 "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 10,
		 "RITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EA");
    add_srs_wkt (p, 11, "ST],AUTHORITY[\"EPSG\",\"2328\"]]");
    p = add_epsg_def (filter, first, last, 2329, "epsg", 2329,
		      "Xian 1980 / Gauss-Kruger zone 15");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=15500000 +y_0=0");
    add_proj4text (p, 1, " +a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Xian 1980 / Gauss-Kruger zone 15\",GEOGCS[\"Xia");
    add_srs_wkt (p, 1,
		 "n 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 1975\",63781");
    add_srs_wkt (p, 2,
		 "40,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
		 "G\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
		 ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
		 "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4610\"]],PROJE");
    add_srs_wkt (p, 6,
		 "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
		 "rigin\",0],PARAMETER[\"central_meridian\",87],PARAMETER[");
    add_srs_wkt (p, 8,
		 "\"scale_factor\",1],PARAMETER[\"false_easting\",15500000");
    add_srs_wkt (p, 9,
		 "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 10,
		 "RITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EA");
    add_srs_wkt (p, 11, "ST],AUTHORITY[\"EPSG\",\"2329\"]]");
    p = add_epsg_def (filter, first, last, 2330, "epsg", 2330,
		      "Xian 1980 / Gauss-Kruger zone 16");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=16500000 +y_0=0");
    add_proj4text (p, 1, " +a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Xian 1980 / Gauss-Kruger zone 16\",GEOGCS[\"Xia");
    add_srs_wkt (p, 1,
		 "n 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 1975\",63781");
    add_srs_wkt (p, 2,
		 "40,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
		 "G\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
		 ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
		 "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4610\"]],PROJE");
    add_srs_wkt (p, 6,
		 "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
		 "rigin\",0],PARAMETER[\"central_meridian\",93],PARAMETER[");
    add_srs_wkt (p, 8,
		 "\"scale_factor\",1],PARAMETER[\"false_easting\",16500000");
    add_srs_wkt (p, 9,
		 "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 10,
		 "RITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EA");
    add_srs_wkt (p, 11, "ST],AUTHORITY[\"EPSG\",\"2330\"]]");
    p = add_epsg_def (filter, first, last, 2331, "epsg", 2331,
		      "Xian 1980 / Gauss-Kruger zone 17");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=17500000 +y_0=0");
    add_proj4text (p, 1, " +a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Xian 1980 / Gauss-Kruger zone 17\",GEOGCS[\"Xia");
    add_srs_wkt (p, 1,
		 "n 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 1975\",63781");
    add_srs_wkt (p, 2,
		 "40,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
		 "G\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
		 ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
		 "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4610\"]],PROJE");
    add_srs_wkt (p, 6,
		 "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
		 "rigin\",0],PARAMETER[\"central_meridian\",99],PARAMETER[");
    add_srs_wkt (p, 8,
		 "\"scale_factor\",1],PARAMETER[\"false_easting\",17500000");
    add_srs_wkt (p, 9,
		 "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 10,
		 "RITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EA");
    add_srs_wkt (p, 11, "ST],AUTHORITY[\"EPSG\",\"2331\"]]");
    p = add_epsg_def (filter, first, last, 2332, "epsg", 2332,
		      "Xian 1980 / Gauss-Kruger zone 18");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=18500000 +y_0=");
    add_proj4text (p, 1, "0 +a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Xian 1980 / Gauss-Kruger zone 18\",GEOGCS[\"Xia");
    add_srs_wkt (p, 1,
		 "n 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 1975\",63781");
    add_srs_wkt (p, 2,
		 "40,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
		 "G\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
		 ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
		 "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4610\"]],PROJE");
    add_srs_wkt (p, 6,
		 "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
		 "rigin\",0],PARAMETER[\"central_meridian\",105],PARAMETER");
    add_srs_wkt (p, 8,
		 "[\"scale_factor\",1],PARAMETER[\"false_easting\",1850000");
    add_srs_wkt (p, 9,
		 "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 10,
		 "ORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",E");
    add_srs_wkt (p, 11, "AST],AUTHORITY[\"EPSG\",\"2332\"]]");
    p = add_epsg_def (filter, first, last, 2333, "epsg", 2333,
		      "Xian 1980 / Gauss-Kruger zone 19");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=19500000 +y_0=");
    add_proj4text (p, 1, "0 +a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Xian 1980 / Gauss-Kruger zone 19\",GEOGCS[\"Xia");
    add_srs_wkt (p, 1,
		 "n 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 1975\",63781");
    add_srs_wkt (p, 2,
		 "40,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
		 "G\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
		 ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
		 "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4610\"]],PROJE");
    add_srs_wkt (p, 6,
		 "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
		 "rigin\",0],PARAMETER[\"central_meridian\",111],PARAMETER");
    add_srs_wkt (p, 8,
		 "[\"scale_factor\",1],PARAMETER[\"false_easting\",1950000");
    add_srs_wkt (p, 9,
		 "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 10,
		 "ORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",E");
    add_srs_wkt (p, 11, "AST],AUTHORITY[\"EPSG\",\"2333\"]]");
    p = add_epsg_def (filter, first, last, 2334, "epsg", 2334,
		      "Xian 1980 / Gauss-Kruger zone 20");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=20500000 +y_0=");
    add_proj4text (p, 1, "0 +a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Xian 1980 / Gauss-Kruger zone 20\",GEOGCS[\"Xia");
    add_srs_wkt (p, 1,
		 "n 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 1975\",63781");
    add_srs_wkt (p, 2,
		 "40,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
		 "G\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
		 ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
		 "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4610\"]],PROJE");
    add_srs_wkt (p, 6,
		 "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
		 "rigin\",0],PARAMETER[\"central_meridian\",117],PARAMETER");
    add_srs_wkt (p, 8,
		 "[\"scale_factor\",1],PARAMETER[\"false_easting\",2050000");
    add_srs_wkt (p, 9,
		 "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 10,
		 "ORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",E");
    add_srs_wkt (p, 11, "AST],AUTHORITY[\"EPSG\",\"2334\"]]");
    p = add_epsg_def (filter, first, last, 2335, "epsg", 2335,
		      "Xian 1980 / Gauss-Kruger zone 21");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=21500000 +y_0=");
    add_proj4text (p, 1, "0 +a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Xian 1980 / Gauss-Kruger zone 21\",GEOGCS[\"Xia");
    add_srs_wkt (p, 1,
		 "n 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 1975\",63781");
    add_srs_wkt (p, 2,
		 "40,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
		 "G\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
		 ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
		 "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4610\"]],PROJE");
    add_srs_wkt (p, 6,
		 "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
		 "rigin\",0],PARAMETER[\"central_meridian\",123],PARAMETER");
    add_srs_wkt (p, 8,
		 "[\"scale_factor\",1],PARAMETER[\"false_easting\",2150000");
    add_srs_wkt (p, 9,
		 "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 10,
		 "ORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",E");
    add_srs_wkt (p, 11, "AST],AUTHORITY[\"EPSG\",\"2335\"]]");
    p = add_epsg_def (filter, first, last, 2336, "epsg", 2336,
		      "Xian 1980 / Gauss-Kruger zone 22");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=22500000 +y_0=");
    add_proj4text (p, 1, "0 +a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Xian 1980 / Gauss-Kruger zone 22\",GEOGCS[\"Xia");
    add_srs_wkt (p, 1,
		 "n 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 1975\",63781");
    add_srs_wkt (p, 2,
		 "40,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
		 "G\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
		 ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
		 "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4610\"]],PROJE");
    add_srs_wkt (p, 6,
		 "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
		 "rigin\",0],PARAMETER[\"central_meridian\",129],PARAMETER");
    add_srs_wkt (p, 8,
		 "[\"scale_factor\",1],PARAMETER[\"false_easting\",2250000");
    add_srs_wkt (p, 9,
		 "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 10,
		 "ORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",E");
    add_srs_wkt (p, 11, "AST],AUTHORITY[\"EPSG\",\"2336\"]]");
    p = add_epsg_def (filter, first, last, 2337, "epsg", 2337,
		      "Xian 1980 / Gauss-Kruger zone 23");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=23500000 +y_0=");
    add_proj4text (p, 1, "0 +a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Xian 1980 / Gauss-Kruger zone 23\",GEOGCS[\"Xia");
    add_srs_wkt (p, 1,
		 "n 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 1975\",63781");
    add_srs_wkt (p, 2,
		 "40,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
		 "G\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
		 ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
		 "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4610\"]],PROJE");
    add_srs_wkt (p, 6,
		 "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
		 "rigin\",0],PARAMETER[\"central_meridian\",135],PARAMETER");
    add_srs_wkt (p, 8,
		 "[\"scale_factor\",1],PARAMETER[\"false_easting\",2350000");
    add_srs_wkt (p, 9,
		 "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 10,
		 "ORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",E");
    add_srs_wkt (p, 11, "AST],AUTHORITY[\"EPSG\",\"2337\"]]");
    p = add_epsg_def (filter, first, last, 2338, "epsg", 2338,
		      "Xian 1980 / Gauss-Kruger CM 75E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1, "a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Xian 1980 / Gauss-Kruger CM 75E\",GEOGCS[\"Xian");
    add_srs_wkt (p, 1,
		 " 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 1975\",637814");
    add_srs_wkt (p, 2,
		 "0,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
		 "\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
		 "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 5,
		 "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4610\"]],PROJEC");
    add_srs_wkt (p, 6,
		 "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 7,
		 "igin\",0],PARAMETER[\"central_meridian\",75],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "scale_factor\",1],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 9,
		 "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 10,
		 "[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],");
    add_srs_wkt (p, 11, "AUTHORITY[\"EPSG\",\"2338\"]]");
    p = add_epsg_def (filter, first, last, 2339, "epsg", 2339,
		      "Xian 1980 / Gauss-Kruger CM 81E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1, "a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Xian 1980 / Gauss-Kruger CM 81E\",GEOGCS[\"Xian");
    add_srs_wkt (p, 1,
		 " 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 1975\",637814");
    add_srs_wkt (p, 2,
		 "0,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
		 "\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
		 "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 5,
		 "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4610\"]],PROJEC");
    add_srs_wkt (p, 6,
		 "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 7,
		 "igin\",0],PARAMETER[\"central_meridian\",81],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "scale_factor\",1],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 9,
		 "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 10,
		 "[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],");
    add_srs_wkt (p, 11, "AUTHORITY[\"EPSG\",\"2339\"]]");
    p = add_epsg_def (filter, first, last, 2340, "epsg", 2340,
		      "Xian 1980 / Gauss-Kruger CM 87E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1, "a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Xian 1980 / Gauss-Kruger CM 87E\",GEOGCS[\"Xian");
    add_srs_wkt (p, 1,
		 " 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 1975\",637814");
    add_srs_wkt (p, 2,
		 "0,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
		 "\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
		 "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 5,
		 "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4610\"]],PROJEC");
    add_srs_wkt (p, 6,
		 "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 7,
		 "igin\",0],PARAMETER[\"central_meridian\",87],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "scale_factor\",1],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 9,
		 "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 10,
		 "[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],");
    add_srs_wkt (p, 11, "AUTHORITY[\"EPSG\",\"2340\"]]");
    p = add_epsg_def (filter, first, last, 2341, "epsg", 2341,
		      "Xian 1980 / Gauss-Kruger CM 93E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1, "a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Xian 1980 / Gauss-Kruger CM 93E\",GEOGCS[\"Xian");
    add_srs_wkt (p, 1,
		 " 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 1975\",637814");
    add_srs_wkt (p, 2,
		 "0,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
		 "\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
		 "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 5,
		 "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4610\"]],PROJEC");
    add_srs_wkt (p, 6,
		 "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 7,
		 "igin\",0],PARAMETER[\"central_meridian\",93],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "scale_factor\",1],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 9,
		 "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 10,
		 "[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],");
    add_srs_wkt (p, 11, "AUTHORITY[\"EPSG\",\"2341\"]]");
    p = add_epsg_def (filter, first, last, 2342, "epsg", 2342,
		      "Xian 1980 / Gauss-Kruger CM 99E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1, "a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Xian 1980 / Gauss-Kruger CM 99E\",GEOGCS[\"Xian");
    add_srs_wkt (p, 1,
		 " 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 1975\",637814");
    add_srs_wkt (p, 2,
		 "0,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
		 "\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
		 "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 5,
		 "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4610\"]],PROJEC");
    add_srs_wkt (p, 6,
		 "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 7,
		 "igin\",0],PARAMETER[\"central_meridian\",99],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "scale_factor\",1],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 9,
		 "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 10,
		 "[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],");
    add_srs_wkt (p, 11, "AUTHORITY[\"EPSG\",\"2342\"]]");
    p = add_epsg_def (filter, first, last, 2343, "epsg", 2343,
		      "Xian 1980 / Gauss-Kruger CM 105E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1, "+a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Xian 1980 / Gauss-Kruger CM 105E\",GEOGCS[\"Xia");
    add_srs_wkt (p, 1,
		 "n 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 1975\",63781");
    add_srs_wkt (p, 2,
		 "40,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
		 "G\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
		 ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
		 "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4610\"]],PROJE");
    add_srs_wkt (p, 6,
		 "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
		 "rigin\",0],PARAMETER[\"central_meridian\",105],PARAMETER");
    add_srs_wkt (p, 8,
		 "[\"scale_factor\",1],PARAMETER[\"false_easting\",500000]");
    add_srs_wkt (p, 9,
		 ",PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 10,
		 "ITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAS");
    add_srs_wkt (p, 11, "T],AUTHORITY[\"EPSG\",\"2343\"]]");
    p = add_epsg_def (filter, first, last, 2344, "epsg", 2344,
		      "Xian 1980 / Gauss-Kruger CM 111E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1, "+a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Xian 1980 / Gauss-Kruger CM 111E\",GEOGCS[\"Xia");
    add_srs_wkt (p, 1,
		 "n 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 1975\",63781");
    add_srs_wkt (p, 2,
		 "40,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
		 "G\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
		 ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
		 "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4610\"]],PROJE");
    add_srs_wkt (p, 6,
		 "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
		 "rigin\",0],PARAMETER[\"central_meridian\",111],PARAMETER");
    add_srs_wkt (p, 8,
		 "[\"scale_factor\",1],PARAMETER[\"false_easting\",500000]");
    add_srs_wkt (p, 9,
		 ",PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 10,
		 "ITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAS");
    add_srs_wkt (p, 11, "T],AUTHORITY[\"EPSG\",\"2344\"]]");
    p = add_epsg_def (filter, first, last, 2345, "epsg", 2345,
		      "Xian 1980 / Gauss-Kruger CM 117E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1, "+a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Xian 1980 / Gauss-Kruger CM 117E\",GEOGCS[\"Xia");
    add_srs_wkt (p, 1,
		 "n 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 1975\",63781");
    add_srs_wkt (p, 2,
		 "40,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
		 "G\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
		 ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
		 "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4610\"]],PROJE");
    add_srs_wkt (p, 6,
		 "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
		 "rigin\",0],PARAMETER[\"central_meridian\",117],PARAMETER");
    add_srs_wkt (p, 8,
		 "[\"scale_factor\",1],PARAMETER[\"false_easting\",500000]");
    add_srs_wkt (p, 9,
		 ",PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 10,
		 "ITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAS");
    add_srs_wkt (p, 11, "T],AUTHORITY[\"EPSG\",\"2345\"]]");
    p = add_epsg_def (filter, first, last, 2346, "epsg", 2346,
		      "Xian 1980 / Gauss-Kruger CM 123E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1, "+a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Xian 1980 / Gauss-Kruger CM 123E\",GEOGCS[\"Xia");
    add_srs_wkt (p, 1,
		 "n 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 1975\",63781");
    add_srs_wkt (p, 2,
		 "40,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
		 "G\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
		 ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
		 "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4610\"]],PROJE");
    add_srs_wkt (p, 6,
		 "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
		 "rigin\",0],PARAMETER[\"central_meridian\",123],PARAMETER");
    add_srs_wkt (p, 8,
		 "[\"scale_factor\",1],PARAMETER[\"false_easting\",500000]");
    add_srs_wkt (p, 9,
		 ",PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 10,
		 "ITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAS");
    add_srs_wkt (p, 11, "T],AUTHORITY[\"EPSG\",\"2346\"]]");
    p = add_epsg_def (filter, first, last, 2347, "epsg", 2347,
		      "Xian 1980 / Gauss-Kruger CM 129E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1, "+a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Xian 1980 / Gauss-Kruger CM 129E\",GEOGCS[\"Xia");
    add_srs_wkt (p, 1,
		 "n 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 1975\",63781");
    add_srs_wkt (p, 2,
		 "40,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
		 "G\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
		 ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
		 "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4610\"]],PROJE");
    add_srs_wkt (p, 6,
		 "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
		 "rigin\",0],PARAMETER[\"central_meridian\",129],PARAMETER");
    add_srs_wkt (p, 8,
		 "[\"scale_factor\",1],PARAMETER[\"false_easting\",500000]");
    add_srs_wkt (p, 9,
		 ",PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 10,
		 "ITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAS");
    add_srs_wkt (p, 11, "T],AUTHORITY[\"EPSG\",\"2347\"]]");
    p = add_epsg_def (filter, first, last, 2348, "epsg", 2348,
		      "Xian 1980 / Gauss-Kruger CM 135E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1, "+a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Xian 1980 / Gauss-Kruger CM 135E\",GEOGCS[\"Xia");
    add_srs_wkt (p, 1,
		 "n 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 1975\",63781");
    add_srs_wkt (p, 2,
		 "40,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
		 "G\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
		 ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
		 "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4610\"]],PROJE");
    add_srs_wkt (p, 6,
		 "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
		 "rigin\",0],PARAMETER[\"central_meridian\",135],PARAMETER");
    add_srs_wkt (p, 8,
		 "[\"scale_factor\",1],PARAMETER[\"false_easting\",500000]");
    add_srs_wkt (p, 9,
		 ",PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 10,
		 "ITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAS");
    add_srs_wkt (p, 11, "T],AUTHORITY[\"EPSG\",\"2348\"]]");
    p = add_epsg_def (filter, first, last, 2349, "epsg", 2349,
		      "Xian 1980 / 3-degree Gauss-Kruger zone 25");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=25500000 +y_0=0");
    add_proj4text (p, 1, " +a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Xian 1980 / 3-degree Gauss-Kruger zone 25\",GEO");
    add_srs_wkt (p, 1,
		 "GCS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 197");
    add_srs_wkt (p, 2,
		 "5\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHOR");
    add_srs_wkt (p, 3,
		 "ITY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
		 "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
		 "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4610\"");
    add_srs_wkt (p, 6,
		 "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
		 "ude_of_origin\",0],PARAMETER[\"central_meridian\",75],PA");
    add_srs_wkt (p, 8,
		 "RAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 9,
		 "25500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 10,
		 ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[");
    add_srs_wkt (p, 11, "\"Y\",EAST],AUTHORITY[\"EPSG\",\"2349\"]]");
    p = add_epsg_def (filter, first, last, 2350, "epsg", 2350,
		      "Xian 1980 / 3-degree Gauss-Kruger zone 26");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=78 +k=1 +x_0=26500000 +y_0=0");
    add_proj4text (p, 1, " +a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Xian 1980 / 3-degree Gauss-Kruger zone 26\",GEO");
    add_srs_wkt (p, 1,
		 "GCS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 197");
    add_srs_wkt (p, 2,
		 "5\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHOR");
    add_srs_wkt (p, 3,
		 "ITY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
		 "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
		 "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4610\"");
    add_srs_wkt (p, 6,
		 "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
		 "ude_of_origin\",0],PARAMETER[\"central_meridian\",78],PA");
    add_srs_wkt (p, 8,
		 "RAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 9,
		 "26500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 10,
		 ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[");
    add_srs_wkt (p, 11, "\"Y\",EAST],AUTHORITY[\"EPSG\",\"2350\"]]");
    p = add_epsg_def (filter, first, last, 2351, "epsg", 2351,
		      "Xian 1980 / 3-degree Gauss-Kruger zone 27");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=27500000 +y_0=0");
    add_proj4text (p, 1, " +a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Xian 1980 / 3-degree Gauss-Kruger zone 27\",GEO");
    add_srs_wkt (p, 1,
		 "GCS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 197");
    add_srs_wkt (p, 2,
		 "5\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHOR");
    add_srs_wkt (p, 3,
		 "ITY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
		 "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
		 "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4610\"");
    add_srs_wkt (p, 6,
		 "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
		 "ude_of_origin\",0],PARAMETER[\"central_meridian\",81],PA");
    add_srs_wkt (p, 8,
		 "RAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 9,
		 "27500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 10,
		 ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[");
    add_srs_wkt (p, 11, "\"Y\",EAST],AUTHORITY[\"EPSG\",\"2351\"]]");
    p = add_epsg_def (filter, first, last, 2352, "epsg", 2352,
		      "Xian 1980 / 3-degree Gauss-Kruger zone 28");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=84 +k=1 +x_0=28500000 +y_0=0");
    add_proj4text (p, 1, " +a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Xian 1980 / 3-degree Gauss-Kruger zone 28\",GEO");
    add_srs_wkt (p, 1,
		 "GCS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 197");
    add_srs_wkt (p, 2,
		 "5\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHOR");
    add_srs_wkt (p, 3,
		 "ITY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
		 "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
		 "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4610\"");
    add_srs_wkt (p, 6,
		 "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
		 "ude_of_origin\",0],PARAMETER[\"central_meridian\",84],PA");
    add_srs_wkt (p, 8,
		 "RAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 9,
		 "28500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 10,
		 ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[");
    add_srs_wkt (p, 11, "\"Y\",EAST],AUTHORITY[\"EPSG\",\"2352\"]]");
    p = add_epsg_def (filter, first, last, 2353, "epsg", 2353,
		      "Xian 1980 / 3-degree Gauss-Kruger zone 29");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=29500000 +y_0=0");
    add_proj4text (p, 1, " +a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Xian 1980 / 3-degree Gauss-Kruger zone 29\",GEO");
    add_srs_wkt (p, 1,
		 "GCS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 197");
    add_srs_wkt (p, 2,
		 "5\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHOR");
    add_srs_wkt (p, 3,
		 "ITY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
		 "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
		 "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4610\"");
    add_srs_wkt (p, 6,
		 "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
		 "ude_of_origin\",0],PARAMETER[\"central_meridian\",87],PA");
    add_srs_wkt (p, 8,
		 "RAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 9,
		 "29500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 10,
		 ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[");
    add_srs_wkt (p, 11, "\"Y\",EAST],AUTHORITY[\"EPSG\",\"2353\"]]");
    p = add_epsg_def (filter, first, last, 2354, "epsg", 2354,
		      "Xian 1980 / 3-degree Gauss-Kruger zone 30");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=90 +k=1 +x_0=30500000 +y_0=0");
    add_proj4text (p, 1, " +a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Xian 1980 / 3-degree Gauss-Kruger zone 30\",GEO");
    add_srs_wkt (p, 1,
		 "GCS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 197");
    add_srs_wkt (p, 2,
		 "5\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHOR");
    add_srs_wkt (p, 3,
		 "ITY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
		 "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
		 "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4610\"");
    add_srs_wkt (p, 6,
		 "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
		 "ude_of_origin\",0],PARAMETER[\"central_meridian\",90],PA");
    add_srs_wkt (p, 8,
		 "RAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 9,
		 "30500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 10,
		 ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[");
    add_srs_wkt (p, 11, "\"Y\",EAST],AUTHORITY[\"EPSG\",\"2354\"]]");
    p = add_epsg_def (filter, first, last, 2355, "epsg", 2355,
		      "Xian 1980 / 3-degree Gauss-Kruger zone 31");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=31500000 +y_0=0");
    add_proj4text (p, 1, " +a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Xian 1980 / 3-degree Gauss-Kruger zone 31\",GEO");
    add_srs_wkt (p, 1,
		 "GCS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 197");
    add_srs_wkt (p, 2,
		 "5\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHOR");
    add_srs_wkt (p, 3,
		 "ITY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
		 "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
		 "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4610\"");
    add_srs_wkt (p, 6,
		 "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
		 "ude_of_origin\",0],PARAMETER[\"central_meridian\",93],PA");
    add_srs_wkt (p, 8,
		 "RAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 9,
		 "31500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 10,
		 ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[");
    add_srs_wkt (p, 11, "\"Y\",EAST],AUTHORITY[\"EPSG\",\"2355\"]]");
    p = add_epsg_def (filter, first, last, 2356, "epsg", 2356,
		      "Xian 1980 / 3-degree Gauss-Kruger zone 32");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=96 +k=1 +x_0=32500000 +y_0=0");
    add_proj4text (p, 1, " +a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Xian 1980 / 3-degree Gauss-Kruger zone 32\",GEO");
    add_srs_wkt (p, 1,
		 "GCS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 197");
    add_srs_wkt (p, 2,
		 "5\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHOR");
    add_srs_wkt (p, 3,
		 "ITY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
		 "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
		 "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4610\"");
    add_srs_wkt (p, 6,
		 "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
		 "ude_of_origin\",0],PARAMETER[\"central_meridian\",96],PA");
    add_srs_wkt (p, 8,
		 "RAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 9,
		 "32500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 10,
		 ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[");
    add_srs_wkt (p, 11, "\"Y\",EAST],AUTHORITY[\"EPSG\",\"2356\"]]");
    p = add_epsg_def (filter, first, last, 2357, "epsg", 2357,
		      "Xian 1980 / 3-degree Gauss-Kruger zone 33");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=33500000 +y_0=0");
    add_proj4text (p, 1, " +a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Xian 1980 / 3-degree Gauss-Kruger zone 33\",GEO");
    add_srs_wkt (p, 1,
		 "GCS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 197");
    add_srs_wkt (p, 2,
		 "5\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHOR");
    add_srs_wkt (p, 3,
		 "ITY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
		 "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
		 "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4610\"");
    add_srs_wkt (p, 6,
		 "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
		 "ude_of_origin\",0],PARAMETER[\"central_meridian\",99],PA");
    add_srs_wkt (p, 8,
		 "RAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 9,
		 "33500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 10,
		 ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[");
    add_srs_wkt (p, 11, "\"Y\",EAST],AUTHORITY[\"EPSG\",\"2357\"]]");
    p = add_epsg_def (filter, first, last, 2358, "epsg", 2358,
		      "Xian 1980 / 3-degree Gauss-Kruger zone 34");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=102 +k=1 +x_0=34500000 +y_0=");
    add_proj4text (p, 1, "0 +a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Xian 1980 / 3-degree Gauss-Kruger zone 34\",GEO");
    add_srs_wkt (p, 1,
		 "GCS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 197");
    add_srs_wkt (p, 2,
		 "5\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHOR");
    add_srs_wkt (p, 3,
		 "ITY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
		 "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
		 "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4610\"");
    add_srs_wkt (p, 6,
		 "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
		 "ude_of_origin\",0],PARAMETER[\"central_meridian\",102],P");
    add_srs_wkt (p, 8,
		 "ARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 9,
		 ",34500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 10,
		 ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[");
    add_srs_wkt (p, 11, "\"Y\",EAST],AUTHORITY[\"EPSG\",\"2358\"]]");
    p = add_epsg_def (filter, first, last, 2359, "epsg", 2359,
		      "Xian 1980 / 3-degree Gauss-Kruger zone 35");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=35500000 +y_0=");
    add_proj4text (p, 1, "0 +a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Xian 1980 / 3-degree Gauss-Kruger zone 35\",GEO");
    add_srs_wkt (p, 1,
		 "GCS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 197");
    add_srs_wkt (p, 2,
		 "5\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHOR");
    add_srs_wkt (p, 3,
		 "ITY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
		 "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
		 "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4610\"");
    add_srs_wkt (p, 6,
		 "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
		 "ude_of_origin\",0],PARAMETER[\"central_meridian\",105],P");
    add_srs_wkt (p, 8,
		 "ARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 9,
		 ",35500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 10,
		 ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[");
    add_srs_wkt (p, 11, "\"Y\",EAST],AUTHORITY[\"EPSG\",\"2359\"]]");
    p = add_epsg_def (filter, first, last, 2360, "epsg", 2360,
		      "Xian 1980 / 3-degree Gauss-Kruger zone 36");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=108 +k=1 +x_0=36500000 +y_0=");
    add_proj4text (p, 1, "0 +a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Xian 1980 / 3-degree Gauss-Kruger zone 36\",GEO");
    add_srs_wkt (p, 1,
		 "GCS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 197");
    add_srs_wkt (p, 2,
		 "5\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHOR");
    add_srs_wkt (p, 3,
		 "ITY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
		 "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
		 "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4610\"");
    add_srs_wkt (p, 6,
		 "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
		 "ude_of_origin\",0],PARAMETER[\"central_meridian\",108],P");
    add_srs_wkt (p, 8,
		 "ARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 9,
		 ",36500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 10,
		 ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[");
    add_srs_wkt (p, 11, "\"Y\",EAST],AUTHORITY[\"EPSG\",\"2360\"]]");
    p = add_epsg_def (filter, first, last, 2361, "epsg", 2361,
		      "Xian 1980 / 3-degree Gauss-Kruger zone 37");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=37500000 +y_0=");
    add_proj4text (p, 1, "0 +a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Xian 1980 / 3-degree Gauss-Kruger zone 37\",GEO");
    add_srs_wkt (p, 1,
		 "GCS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 197");
    add_srs_wkt (p, 2,
		 "5\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHOR");
    add_srs_wkt (p, 3,
		 "ITY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
		 "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
		 "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4610\"");
    add_srs_wkt (p, 6,
		 "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
		 "ude_of_origin\",0],PARAMETER[\"central_meridian\",111],P");
    add_srs_wkt (p, 8,
		 "ARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 9,
		 ",37500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 10,
		 ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[");
    add_srs_wkt (p, 11, "\"Y\",EAST],AUTHORITY[\"EPSG\",\"2361\"]]");
    p = add_epsg_def (filter, first, last, 2362, "epsg", 2362,
		      "Xian 1980 / 3-degree Gauss-Kruger zone 38");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=114 +k=1 +x_0=38500000 +y_0=");
    add_proj4text (p, 1, "0 +a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Xian 1980 / 3-degree Gauss-Kruger zone 38\",GEO");
    add_srs_wkt (p, 1,
		 "GCS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 197");
    add_srs_wkt (p, 2,
		 "5\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHOR");
    add_srs_wkt (p, 3,
		 "ITY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
		 "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
		 "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4610\"");
    add_srs_wkt (p, 6,
		 "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
		 "ude_of_origin\",0],PARAMETER[\"central_meridian\",114],P");
    add_srs_wkt (p, 8,
		 "ARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 9,
		 ",38500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 10,
		 ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[");
    add_srs_wkt (p, 11, "\"Y\",EAST],AUTHORITY[\"EPSG\",\"2362\"]]");
    p = add_epsg_def (filter, first, last, 2363, "epsg", 2363,
		      "Xian 1980 / 3-degree Gauss-Kruger zone 39");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=39500000 +y_0=");
    add_proj4text (p, 1, "0 +a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Xian 1980 / 3-degree Gauss-Kruger zone 39\",GEO");
    add_srs_wkt (p, 1,
		 "GCS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 197");
    add_srs_wkt (p, 2,
		 "5\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHOR");
    add_srs_wkt (p, 3,
		 "ITY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
		 "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
		 "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4610\"");
    add_srs_wkt (p, 6,
		 "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
		 "ude_of_origin\",0],PARAMETER[\"central_meridian\",117],P");
    add_srs_wkt (p, 8,
		 "ARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 9,
		 ",39500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 10,
		 ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[");
    add_srs_wkt (p, 11, "\"Y\",EAST],AUTHORITY[\"EPSG\",\"2363\"]]");
    p = add_epsg_def (filter, first, last, 2364, "epsg", 2364,
		      "Xian 1980 / 3-degree Gauss-Kruger zone 40");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=120 +k=1 +x_0=40500000 +y_0=");
    add_proj4text (p, 1, "0 +a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Xian 1980 / 3-degree Gauss-Kruger zone 40\",GEO");
    add_srs_wkt (p, 1,
		 "GCS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 197");
    add_srs_wkt (p, 2,
		 "5\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHOR");
    add_srs_wkt (p, 3,
		 "ITY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
		 "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
		 "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4610\"");
    add_srs_wkt (p, 6,
		 "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
		 "ude_of_origin\",0],PARAMETER[\"central_meridian\",120],P");
    add_srs_wkt (p, 8,
		 "ARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 9,
		 ",40500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 10,
		 ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[");
    add_srs_wkt (p, 11, "\"Y\",EAST],AUTHORITY[\"EPSG\",\"2364\"]]");
    p = add_epsg_def (filter, first, last, 2365, "epsg", 2365,
		      "Xian 1980 / 3-degree Gauss-Kruger zone 41");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=41500000 +y_0=");
    add_proj4text (p, 1, "0 +a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Xian 1980 / 3-degree Gauss-Kruger zone 41\",GEO");
    add_srs_wkt (p, 1,
		 "GCS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 197");
    add_srs_wkt (p, 2,
		 "5\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHOR");
    add_srs_wkt (p, 3,
		 "ITY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
		 "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
		 "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4610\"");
    add_srs_wkt (p, 6,
		 "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
		 "ude_of_origin\",0],PARAMETER[\"central_meridian\",123],P");
    add_srs_wkt (p, 8,
		 "ARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 9,
		 ",41500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 10,
		 ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[");
    add_srs_wkt (p, 11, "\"Y\",EAST],AUTHORITY[\"EPSG\",\"2365\"]]");
    p = add_epsg_def (filter, first, last, 2366, "epsg", 2366,
		      "Xian 1980 / 3-degree Gauss-Kruger zone 42");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=126 +k=1 +x_0=42500000 +y_0=");
    add_proj4text (p, 1, "0 +a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Xian 1980 / 3-degree Gauss-Kruger zone 42\",GEO");
    add_srs_wkt (p, 1,
		 "GCS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 197");
    add_srs_wkt (p, 2,
		 "5\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHOR");
    add_srs_wkt (p, 3,
		 "ITY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
		 "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
		 "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4610\"");
    add_srs_wkt (p, 6,
		 "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
		 "ude_of_origin\",0],PARAMETER[\"central_meridian\",126],P");
    add_srs_wkt (p, 8,
		 "ARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 9,
		 ",42500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 10,
		 ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[");
    add_srs_wkt (p, 11, "\"Y\",EAST],AUTHORITY[\"EPSG\",\"2366\"]]");
    p = add_epsg_def (filter, first, last, 2367, "epsg", 2367,
		      "Xian 1980 / 3-degree Gauss-Kruger zone 43");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=43500000 +y_0=");
    add_proj4text (p, 1, "0 +a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Xian 1980 / 3-degree Gauss-Kruger zone 43\",GEO");
    add_srs_wkt (p, 1,
		 "GCS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 197");
    add_srs_wkt (p, 2,
		 "5\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHOR");
    add_srs_wkt (p, 3,
		 "ITY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
		 "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
		 "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4610\"");
    add_srs_wkt (p, 6,
		 "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
		 "ude_of_origin\",0],PARAMETER[\"central_meridian\",129],P");
    add_srs_wkt (p, 8,
		 "ARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 9,
		 ",43500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 10,
		 ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[");
    add_srs_wkt (p, 11, "\"Y\",EAST],AUTHORITY[\"EPSG\",\"2367\"]]");
    p = add_epsg_def (filter, first, last, 2368, "epsg", 2368,
		      "Xian 1980 / 3-degree Gauss-Kruger zone 44");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=132 +k=1 +x_0=44500000 +y_0=");
    add_proj4text (p, 1, "0 +a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Xian 1980 / 3-degree Gauss-Kruger zone 44\",GEO");
    add_srs_wkt (p, 1,
		 "GCS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 197");
    add_srs_wkt (p, 2,
		 "5\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHOR");
    add_srs_wkt (p, 3,
		 "ITY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
		 "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
		 "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4610\"");
    add_srs_wkt (p, 6,
		 "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
		 "ude_of_origin\",0],PARAMETER[\"central_meridian\",132],P");
    add_srs_wkt (p, 8,
		 "ARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 9,
		 ",44500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 10,
		 ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[");
    add_srs_wkt (p, 11, "\"Y\",EAST],AUTHORITY[\"EPSG\",\"2368\"]]");
    p = add_epsg_def (filter, first, last, 2369, "epsg", 2369,
		      "Xian 1980 / 3-degree Gauss-Kruger zone 45");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=45500000 +y_0=");
    add_proj4text (p, 1, "0 +a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Xian 1980 / 3-degree Gauss-Kruger zone 45\",GEO");
    add_srs_wkt (p, 1,
		 "GCS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 197");
    add_srs_wkt (p, 2,
		 "5\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHOR");
    add_srs_wkt (p, 3,
		 "ITY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
		 "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
		 "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4610\"");
    add_srs_wkt (p, 6,
		 "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
		 "ude_of_origin\",0],PARAMETER[\"central_meridian\",135],P");
    add_srs_wkt (p, 8,
		 "ARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 9,
		 ",45500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 10,
		 ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[");
    add_srs_wkt (p, 11, "\"Y\",EAST],AUTHORITY[\"EPSG\",\"2369\"]]");
    p = add_epsg_def (filter, first, last, 2370, "epsg", 2370,
		      "Xian 1980 / 3-degree Gauss-Kruger CM 75E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1, "a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Xian 1980 / 3-degree Gauss-Kruger CM 75E\",GEOG");
    add_srs_wkt (p, 1,
		 "CS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 1975");
    add_srs_wkt (p, 2,
		 "\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHORI");
    add_srs_wkt (p, 3,
		 "TY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
		 "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
		 "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4610\"");
    add_srs_wkt (p, 6,
		 "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
		 "ude_of_origin\",0],PARAMETER[\"central_meridian\",75],PA");
    add_srs_wkt (p, 8,
		 "RAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 9,
		 "500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1");
    add_srs_wkt (p, 10,
		 ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"");
    add_srs_wkt (p, 11, "Y\",EAST],AUTHORITY[\"EPSG\",\"2370\"]]");
    p = add_epsg_def (filter, first, last, 2371, "epsg", 2371,
		      "Xian 1980 / 3-degree Gauss-Kruger CM 78E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=78 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1, "a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Xian 1980 / 3-degree Gauss-Kruger CM 78E\",GEOG");
    add_srs_wkt (p, 1,
		 "CS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 1975");
    add_srs_wkt (p, 2,
		 "\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHORI");
    add_srs_wkt (p, 3,
		 "TY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
		 "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
		 "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4610\"");
    add_srs_wkt (p, 6,
		 "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
		 "ude_of_origin\",0],PARAMETER[\"central_meridian\",78],PA");
    add_srs_wkt (p, 8,
		 "RAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 9,
		 "500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1");
    add_srs_wkt (p, 10,
		 ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"");
    add_srs_wkt (p, 11, "Y\",EAST],AUTHORITY[\"EPSG\",\"2371\"]]");
    p = add_epsg_def (filter, first, last, 2372, "epsg", 2372,
		      "Xian 1980 / 3-degree Gauss-Kruger CM 81E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1, "a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Xian 1980 / 3-degree Gauss-Kruger CM 81E\",GEOG");
    add_srs_wkt (p, 1,
		 "CS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 1975");
    add_srs_wkt (p, 2,
		 "\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHORI");
    add_srs_wkt (p, 3,
		 "TY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
		 "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
		 "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4610\"");
    add_srs_wkt (p, 6,
		 "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
		 "ude_of_origin\",0],PARAMETER[\"central_meridian\",81],PA");
    add_srs_wkt (p, 8,
		 "RAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 9,
		 "500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1");
    add_srs_wkt (p, 10,
		 ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"");
    add_srs_wkt (p, 11, "Y\",EAST],AUTHORITY[\"EPSG\",\"2372\"]]");
    p = add_epsg_def (filter, first, last, 2373, "epsg", 2373,
		      "Xian 1980 / 3-degree Gauss-Kruger CM 84E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=84 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1, "a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Xian 1980 / 3-degree Gauss-Kruger CM 84E\",GEOG");
    add_srs_wkt (p, 1,
		 "CS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 1975");
    add_srs_wkt (p, 2,
		 "\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHORI");
    add_srs_wkt (p, 3,
		 "TY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
		 "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
		 "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4610\"");
    add_srs_wkt (p, 6,
		 "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
		 "ude_of_origin\",0],PARAMETER[\"central_meridian\",84],PA");
    add_srs_wkt (p, 8,
		 "RAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 9,
		 "500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1");
    add_srs_wkt (p, 10,
		 ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"");
    add_srs_wkt (p, 11, "Y\",EAST],AUTHORITY[\"EPSG\",\"2373\"]]");
    p = add_epsg_def (filter, first, last, 2374, "epsg", 2374,
		      "Xian 1980 / 3-degree Gauss-Kruger CM 87E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1, "a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Xian 1980 / 3-degree Gauss-Kruger CM 87E\",GEOG");
    add_srs_wkt (p, 1,
		 "CS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 1975");
    add_srs_wkt (p, 2,
		 "\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHORI");
    add_srs_wkt (p, 3,
		 "TY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
		 "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
		 "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4610\"");
    add_srs_wkt (p, 6,
		 "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
		 "ude_of_origin\",0],PARAMETER[\"central_meridian\",87],PA");
    add_srs_wkt (p, 8,
		 "RAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 9,
		 "500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1");
    add_srs_wkt (p, 10,
		 ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"");
    add_srs_wkt (p, 11, "Y\",EAST],AUTHORITY[\"EPSG\",\"2374\"]]");
    p = add_epsg_def (filter, first, last, 2375, "epsg", 2375,
		      "Xian 1980 / 3-degree Gauss-Kruger CM 90E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=90 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1, "a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Xian 1980 / 3-degree Gauss-Kruger CM 90E\",GEOG");
    add_srs_wkt (p, 1,
		 "CS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 1975");
    add_srs_wkt (p, 2,
		 "\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHORI");
    add_srs_wkt (p, 3,
		 "TY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
		 "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
		 "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4610\"");
    add_srs_wkt (p, 6,
		 "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
		 "ude_of_origin\",0],PARAMETER[\"central_meridian\",90],PA");
    add_srs_wkt (p, 8,
		 "RAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 9,
		 "500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1");
    add_srs_wkt (p, 10,
		 ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"");
    add_srs_wkt (p, 11, "Y\",EAST],AUTHORITY[\"EPSG\",\"2375\"]]");
    p = add_epsg_def (filter, first, last, 2376, "epsg", 2376,
		      "Xian 1980 / 3-degree Gauss-Kruger CM 93E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1, "a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Xian 1980 / 3-degree Gauss-Kruger CM 93E\",GEOG");
    add_srs_wkt (p, 1,
		 "CS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 1975");
    add_srs_wkt (p, 2,
		 "\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHORI");
    add_srs_wkt (p, 3,
		 "TY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
		 "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
		 "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4610\"");
    add_srs_wkt (p, 6,
		 "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
		 "ude_of_origin\",0],PARAMETER[\"central_meridian\",93],PA");
    add_srs_wkt (p, 8,
		 "RAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 9,
		 "500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1");
    add_srs_wkt (p, 10,
		 ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"");
    add_srs_wkt (p, 11, "Y\",EAST],AUTHORITY[\"EPSG\",\"2376\"]]");
    p = add_epsg_def (filter, first, last, 2377, "epsg", 2377,
		      "Xian 1980 / 3-degree Gauss-Kruger CM 96E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=96 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1, "a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Xian 1980 / 3-degree Gauss-Kruger CM 96E\",GEOG");
    add_srs_wkt (p, 1,
		 "CS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 1975");
    add_srs_wkt (p, 2,
		 "\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHORI");
    add_srs_wkt (p, 3,
		 "TY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
		 "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
		 "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4610\"");
    add_srs_wkt (p, 6,
		 "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
		 "ude_of_origin\",0],PARAMETER[\"central_meridian\",96],PA");
    add_srs_wkt (p, 8,
		 "RAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 9,
		 "500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1");
    add_srs_wkt (p, 10,
		 ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"");
    add_srs_wkt (p, 11, "Y\",EAST],AUTHORITY[\"EPSG\",\"2377\"]]");
    p = add_epsg_def (filter, first, last, 2378, "epsg", 2378,
		      "Xian 1980 / 3-degree Gauss-Kruger CM 99E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1, "a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Xian 1980 / 3-degree Gauss-Kruger CM 99E\",GEOG");
    add_srs_wkt (p, 1,
		 "CS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 1975");
    add_srs_wkt (p, 2,
		 "\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHORI");
    add_srs_wkt (p, 3,
		 "TY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
		 "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
		 "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4610\"");
    add_srs_wkt (p, 6,
		 "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
		 "ude_of_origin\",0],PARAMETER[\"central_meridian\",99],PA");
    add_srs_wkt (p, 8,
		 "RAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 9,
		 "500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1");
    add_srs_wkt (p, 10,
		 ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"");
    add_srs_wkt (p, 11, "Y\",EAST],AUTHORITY[\"EPSG\",\"2378\"]]");
    p = add_epsg_def (filter, first, last, 2379, "epsg", 2379,
		      "Xian 1980 / 3-degree Gauss-Kruger CM 102E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=102 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1, "+a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Xian 1980 / 3-degree Gauss-Kruger CM 102E\",GEO");
    add_srs_wkt (p, 1,
		 "GCS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 197");
    add_srs_wkt (p, 2,
		 "5\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHOR");
    add_srs_wkt (p, 3,
		 "ITY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
		 "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
		 "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4610\"");
    add_srs_wkt (p, 6,
		 "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
		 "ude_of_origin\",0],PARAMETER[\"central_meridian\",102],P");
    add_srs_wkt (p, 8,
		 "ARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 9,
		 ",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 10,
		 "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"");
    add_srs_wkt (p, 11, "Y\",EAST],AUTHORITY[\"EPSG\",\"2379\"]]");
    p = add_epsg_def (filter, first, last, 2380, "epsg", 2380,
		      "Xian 1980 / 3-degree Gauss-Kruger CM 105E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1, "+a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Xian 1980 / 3-degree Gauss-Kruger CM 105E\",GEO");
    add_srs_wkt (p, 1,
		 "GCS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 197");
    add_srs_wkt (p, 2,
		 "5\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHOR");
    add_srs_wkt (p, 3,
		 "ITY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
		 "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
		 "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4610\"");
    add_srs_wkt (p, 6,
		 "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
		 "ude_of_origin\",0],PARAMETER[\"central_meridian\",105],P");
    add_srs_wkt (p, 8,
		 "ARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 9,
		 ",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 10,
		 "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"");
    add_srs_wkt (p, 11, "Y\",EAST],AUTHORITY[\"EPSG\",\"2380\"]]");
    p = add_epsg_def (filter, first, last, 2381, "epsg", 2381,
		      "Xian 1980 / 3-degree Gauss-Kruger CM 108E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=108 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1, "+a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Xian 1980 / 3-degree Gauss-Kruger CM 108E\",GEO");
    add_srs_wkt (p, 1,
		 "GCS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 197");
    add_srs_wkt (p, 2,
		 "5\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHOR");
    add_srs_wkt (p, 3,
		 "ITY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
		 "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
		 "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4610\"");
    add_srs_wkt (p, 6,
		 "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
		 "ude_of_origin\",0],PARAMETER[\"central_meridian\",108],P");
    add_srs_wkt (p, 8,
		 "ARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 9,
		 ",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 10,
		 "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"");
    add_srs_wkt (p, 11, "Y\",EAST],AUTHORITY[\"EPSG\",\"2381\"]]");
    p = add_epsg_def (filter, first, last, 2382, "epsg", 2382,
		      "Xian 1980 / 3-degree Gauss-Kruger CM 111E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1, "+a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Xian 1980 / 3-degree Gauss-Kruger CM 111E\",GEO");
    add_srs_wkt (p, 1,
		 "GCS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 197");
    add_srs_wkt (p, 2,
		 "5\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHOR");
    add_srs_wkt (p, 3,
		 "ITY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
		 "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
		 "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4610\"");
    add_srs_wkt (p, 6,
		 "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
		 "ude_of_origin\",0],PARAMETER[\"central_meridian\",111],P");
    add_srs_wkt (p, 8,
		 "ARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 9,
		 ",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 10,
		 "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"");
    add_srs_wkt (p, 11, "Y\",EAST],AUTHORITY[\"EPSG\",\"2382\"]]");
    p = add_epsg_def (filter, first, last, 2383, "epsg", 2383,
		      "Xian 1980 / 3-degree Gauss-Kruger CM 114E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=114 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1, "+a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Xian 1980 / 3-degree Gauss-Kruger CM 114E\",GEO");
    add_srs_wkt (p, 1,
		 "GCS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 197");
    add_srs_wkt (p, 2,
		 "5\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHOR");
    add_srs_wkt (p, 3,
		 "ITY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
		 "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
		 "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4610\"");
    add_srs_wkt (p, 6,
		 "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
		 "ude_of_origin\",0],PARAMETER[\"central_meridian\",114],P");
    add_srs_wkt (p, 8,
		 "ARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 9,
		 ",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 10,
		 "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"");
    add_srs_wkt (p, 11, "Y\",EAST],AUTHORITY[\"EPSG\",\"2383\"]]");
    p = add_epsg_def (filter, first, last, 2384, "epsg", 2384,
		      "Xian 1980 / 3-degree Gauss-Kruger CM 117E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1, "+a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Xian 1980 / 3-degree Gauss-Kruger CM 117E\",GEO");
    add_srs_wkt (p, 1,
		 "GCS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 197");
    add_srs_wkt (p, 2,
		 "5\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHOR");
    add_srs_wkt (p, 3,
		 "ITY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
		 "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
		 "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4610\"");
    add_srs_wkt (p, 6,
		 "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
		 "ude_of_origin\",0],PARAMETER[\"central_meridian\",117],P");
    add_srs_wkt (p, 8,
		 "ARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 9,
		 ",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 10,
		 "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"");
    add_srs_wkt (p, 11, "Y\",EAST],AUTHORITY[\"EPSG\",\"2384\"]]");
    p = add_epsg_def (filter, first, last, 2385, "epsg", 2385,
		      "Xian 1980 / 3-degree Gauss-Kruger CM 120E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=120 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1, "+a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Xian 1980 / 3-degree Gauss-Kruger CM 120E\",GEO");
    add_srs_wkt (p, 1,
		 "GCS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 197");
    add_srs_wkt (p, 2,
		 "5\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHOR");
    add_srs_wkt (p, 3,
		 "ITY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
		 "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
		 "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4610\"");
    add_srs_wkt (p, 6,
		 "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
		 "ude_of_origin\",0],PARAMETER[\"central_meridian\",120],P");
    add_srs_wkt (p, 8,
		 "ARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 9,
		 ",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 10,
		 "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"");
    add_srs_wkt (p, 11, "Y\",EAST],AUTHORITY[\"EPSG\",\"2385\"]]");
    p = add_epsg_def (filter, first, last, 2386, "epsg", 2386,
		      "Xian 1980 / 3-degree Gauss-Kruger CM 123E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1, "+a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Xian 1980 / 3-degree Gauss-Kruger CM 123E\",GEO");
    add_srs_wkt (p, 1,
		 "GCS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 197");
    add_srs_wkt (p, 2,
		 "5\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHOR");
    add_srs_wkt (p, 3,
		 "ITY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
		 "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
		 "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4610\"");
    add_srs_wkt (p, 6,
		 "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
		 "ude_of_origin\",0],PARAMETER[\"central_meridian\",123],P");
    add_srs_wkt (p, 8,
		 "ARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 9,
		 ",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 10,
		 "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"");
    add_srs_wkt (p, 11, "Y\",EAST],AUTHORITY[\"EPSG\",\"2386\"]]");
    p = add_epsg_def (filter, first, last, 2387, "epsg", 2387,
		      "Xian 1980 / 3-degree Gauss-Kruger CM 126E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=126 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1, "+a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Xian 1980 / 3-degree Gauss-Kruger CM 126E\",GEO");
    add_srs_wkt (p, 1,
		 "GCS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 197");
    add_srs_wkt (p, 2,
		 "5\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHOR");
    add_srs_wkt (p, 3,
		 "ITY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
		 "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
		 "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4610\"");
    add_srs_wkt (p, 6,
		 "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
		 "ude_of_origin\",0],PARAMETER[\"central_meridian\",126],P");
    add_srs_wkt (p, 8,
		 "ARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 9,
		 ",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 10,
		 "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"");
    add_srs_wkt (p, 11, "Y\",EAST],AUTHORITY[\"EPSG\",\"2387\"]]");
    p = add_epsg_def (filter, first, last, 2388, "epsg", 2388,
		      "Xian 1980 / 3-degree Gauss-Kruger CM 129E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1, "+a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Xian 1980 / 3-degree Gauss-Kruger CM 129E\",GEO");
    add_srs_wkt (p, 1,
		 "GCS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 197");
    add_srs_wkt (p, 2,
		 "5\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHOR");
    add_srs_wkt (p, 3,
		 "ITY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
		 "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
		 "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4610\"");
    add_srs_wkt (p, 6,
		 "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
		 "ude_of_origin\",0],PARAMETER[\"central_meridian\",129],P");
    add_srs_wkt (p, 8,
		 "ARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 9,
		 ",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 10,
		 "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"");
    add_srs_wkt (p, 11, "Y\",EAST],AUTHORITY[\"EPSG\",\"2388\"]]");
    p = add_epsg_def (filter, first, last, 2389, "epsg", 2389,
		      "Xian 1980 / 3-degree Gauss-Kruger CM 132E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=132 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1, "+a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Xian 1980 / 3-degree Gauss-Kruger CM 132E\",GEO");
    add_srs_wkt (p, 1,
		 "GCS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 197");
    add_srs_wkt (p, 2,
		 "5\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHOR");
    add_srs_wkt (p, 3,
		 "ITY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
		 "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
		 "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4610\"");
    add_srs_wkt (p, 6,
		 "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
		 "ude_of_origin\",0],PARAMETER[\"central_meridian\",132],P");
    add_srs_wkt (p, 8,
		 "ARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 9,
		 ",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 10,
		 "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"");
    add_srs_wkt (p, 11, "Y\",EAST],AUTHORITY[\"EPSG\",\"2389\"]]");
    p = add_epsg_def (filter, first, last, 2390, "epsg", 2390,
		      "Xian 1980 / 3-degree Gauss-Kruger CM 135E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1, "+a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Xian 1980 / 3-degree Gauss-Kruger CM 135E\",GEO");
    add_srs_wkt (p, 1,
		 "GCS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 197");
    add_srs_wkt (p, 2,
		 "5\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHOR");
    add_srs_wkt (p, 3,
		 "ITY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
		 "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
		 "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4610\"");
    add_srs_wkt (p, 6,
		 "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
		 "ude_of_origin\",0],PARAMETER[\"central_meridian\",135],P");
    add_srs_wkt (p, 8,
		 "ARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 9,
		 ",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 10,
		 "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"");
    add_srs_wkt (p, 11, "Y\",EAST],AUTHORITY[\"EPSG\",\"2390\"]]");
    p = add_epsg_def (filter, first, last, 2391, "epsg", 2391,
		      "KKJ / Finland zone 1");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=1500000 +y_0=0 ");
    add_proj4text (p, 1,
		   "+ellps=intl +towgs84=-96.062,-82.428,-121.753,4.801,0.34");
    add_proj4text (p, 2, "5,-1.376,1.496 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"KKJ / Finland zone 1\",GEOGCS[\"KKJ\",DATUM[\"K");
    add_srs_wkt (p, 1,
		 "artastokoordinaattijarjestelma_1966\",SPHEROID[\"Interna");
    add_srs_wkt (p, 2,
		 "tional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],");
    add_srs_wkt (p, 3,
		 "TOWGS84[-96.062,-82.428,-121.753,4.801,0.345,-1.376,1.49");
    add_srs_wkt (p, 4,
		 "6],AUTHORITY[\"EPSG\",\"6123\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 5,
		 "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 6,
		 "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
		 ",\"4123\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 8,
		 "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 9,
		 "\",21],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_e");
    add_srs_wkt (p, 10,
		 "asting\",1500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 11,
		 "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH");
    add_srs_wkt (p, 12, "],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2391\"]]");
    p = add_epsg_def (filter, first, last, 2392, "epsg", 2392,
		      "KKJ / Finland zone 2");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=24 +k=1 +x_0=2500000 +y_0=0 ");
    add_proj4text (p, 1,
		   "+ellps=intl +towgs84=-96.062,-82.428,-121.753,4.801,0.34");
    add_proj4text (p, 2, "5,-1.376,1.496 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"KKJ / Finland zone 2\",GEOGCS[\"KKJ\",DATUM[\"K");
    add_srs_wkt (p, 1,
		 "artastokoordinaattijarjestelma_1966\",SPHEROID[\"Interna");
    add_srs_wkt (p, 2,
		 "tional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],");
    add_srs_wkt (p, 3,
		 "TOWGS84[-96.062,-82.428,-121.753,4.801,0.345,-1.376,1.49");
    add_srs_wkt (p, 4,
		 "6],AUTHORITY[\"EPSG\",\"6123\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 5,
		 "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 6,
		 "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
		 ",\"4123\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 8,
		 "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 9,
		 "\",24],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_e");
    add_srs_wkt (p, 10,
		 "asting\",2500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 11,
		 "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH");
    add_srs_wkt (p, 12, "],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2392\"]]");
    p = add_epsg_def (filter, first, last, 2393, "epsg", 2393,
		      "KKJ / Finland Uniform Coordinate System");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=3500000 +y_0=0 ");
    add_proj4text (p, 1,
		   "+ellps=intl +towgs84=-96.062,-82.428,-121.753,4.801,0.34");
    add_proj4text (p, 2, "5,-1.376,1.496 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"KKJ / Finland Uniform Coordinate System\",GEOGC");
    add_srs_wkt (p, 1,
		 "S[\"KKJ\",DATUM[\"Kartastokoordinaattijarjestelma_1966\"");
    add_srs_wkt (p, 2,
		 ",SPHEROID[\"International 1924\",6378388,297,AUTHORITY[\"");
    add_srs_wkt (p, 3,
		 "EPSG\",\"7022\"]],TOWGS84[-96.062,-82.428,-121.753,4.801");
    add_srs_wkt (p, 4,
		 ",0.345,-1.376,1.496],AUTHORITY[\"EPSG\",\"6123\"]],PRIME");
    add_srs_wkt (p, 5,
		 "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 6,
		 "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 7,
		 ",AUTHORITY[\"EPSG\",\"4123\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 8,
		 "ercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER");
    add_srs_wkt (p, 9,
		 "[\"central_meridian\",27],PARAMETER[\"scale_factor\",1],");
    add_srs_wkt (p, 10,
		 "PARAMETER[\"false_easting\",3500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
		 "orthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
		 "]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13, ",\"2393\"]]");
    p = add_epsg_def (filter, first, last, 2394, "epsg", 2394,
		      "KKJ / Finland zone 4");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=30 +k=1 +x_0=4500000 +y_0=0 ");
    add_proj4text (p, 1,
		   "+ellps=intl +towgs84=-96.062,-82.428,-121.753,4.801,0.34");
    add_proj4text (p, 2, "5,-1.376,1.496 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"KKJ / Finland zone 4\",GEOGCS[\"KKJ\",DATUM[\"K");
    add_srs_wkt (p, 1,
		 "artastokoordinaattijarjestelma_1966\",SPHEROID[\"Interna");
    add_srs_wkt (p, 2,
		 "tional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],");
    add_srs_wkt (p, 3,
		 "TOWGS84[-96.062,-82.428,-121.753,4.801,0.345,-1.376,1.49");
    add_srs_wkt (p, 4,
		 "6],AUTHORITY[\"EPSG\",\"6123\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 5,
		 "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 6,
		 "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
		 ",\"4123\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 8,
		 "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 9,
		 "\",30],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_e");
    add_srs_wkt (p, 10,
		 "asting\",4500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 11,
		 "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH");
    add_srs_wkt (p, 12, "],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2394\"]]");
    p = add_epsg_def (filter, first, last, 2395, "epsg", 2395,
		      "South Yemen / Gauss-Kruger zone 8");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=8500000 +y_0=0 ");
    add_proj4text (p, 1,
		   "+ellps=krass +towgs84=-76,-138,67,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 2, "efs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"South Yemen / Gauss-Kruger zone 8\",GEOGCS[\"So");
    add_srs_wkt (p, 1,
		 "uth Yemen\",DATUM[\"South_Yemen\",SPHEROID[\"Krassowsky ");
    add_srs_wkt (p, 2,
		 "1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TOWGS");
    add_srs_wkt (p, 3,
		 "84[-76,-138,67,0,0,0,0],AUTHORITY[\"EPSG\",\"6164\"]],PR");
    add_srs_wkt (p, 4,
		 "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
		 "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
		 "]],AUTHORITY[\"EPSG\",\"4164\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 7,
		 "_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMET");
    add_srs_wkt (p, 8,
		 "ER[\"central_meridian\",45],PARAMETER[\"scale_factor\",1");
    add_srs_wkt (p, 9,
		 "],PARAMETER[\"false_easting\",8500000],PARAMETER[\"false");
    add_srs_wkt (p, 10,
		 "_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 11,
		 "1\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12, "G\",\"2395\"]]");
    p = add_epsg_def (filter, first, last, 2396, "epsg", 2396,
		      "South Yemen / Gauss-Kruger zone 9");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=51 +k=1 +x_0=9500000 +y_0=0 ");
    add_proj4text (p, 1,
		   "+ellps=krass +towgs84=-76,-138,67,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 2, "efs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"South Yemen / Gauss-Kruger zone 9\",GEOGCS[\"So");
    add_srs_wkt (p, 1,
		 "uth Yemen\",DATUM[\"South_Yemen\",SPHEROID[\"Krassowsky ");
    add_srs_wkt (p, 2,
		 "1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TOWGS");
    add_srs_wkt (p, 3,
		 "84[-76,-138,67,0,0,0,0],AUTHORITY[\"EPSG\",\"6164\"]],PR");
    add_srs_wkt (p, 4,
		 "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
		 "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
		 "]],AUTHORITY[\"EPSG\",\"4164\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 7,
		 "_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMET");
    add_srs_wkt (p, 8,
		 "ER[\"central_meridian\",51],PARAMETER[\"scale_factor\",1");
    add_srs_wkt (p, 9,
		 "],PARAMETER[\"false_easting\",9500000],PARAMETER[\"false");
    add_srs_wkt (p, 10,
		 "_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 11,
		 "1\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12, "G\",\"2396\"]]");
    p = add_epsg_def (filter, first, last, 2397, "epsg", 2397,
		      "Pulkovo 1942(83) / 3-degree Gauss-Kruger zone 3");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=9 +k=1 +x_0=3500000 +y_0=0 +");
    add_proj4text (p, 1,
		   "ellps=krass +towgs84=26,-121,-78,0,0,0,0 +units=m +no_de");
    add_proj4text (p, 2, "fs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942(83) / 3-degree Gauss-Kruger zone 3");
    add_srs_wkt (p, 1,
		 "\",GEOGCS[\"Pulkovo 1942(83)\",DATUM[\"Pulkovo_1942_83\"");
    add_srs_wkt (p, 2,
		 ",SPHEROID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"");
    add_srs_wkt (p, 3,
		 "EPSG\",\"7024\"]],TOWGS84[26,-121,-78,0,0,0,0],AUTHORITY");
    add_srs_wkt (p, 4,
		 "[\"EPSG\",\"6178\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
		 "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
		 "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4178\"]]");
    add_srs_wkt (p, 7,
		 ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
		 "e_of_origin\",0],PARAMETER[\"central_meridian\",9],PARAM");
    add_srs_wkt (p, 9,
		 "ETER[\"scale_factor\",1],PARAMETER[\"false_easting\",350");
    add_srs_wkt (p, 10,
		 "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
		 "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 12, ",EAST],AUTHORITY[\"EPSG\",\"2397\"]]");
    p = add_epsg_def (filter, first, last, 2398, "epsg", 2398,
		      "Pulkovo 1942(83) / 3-degree Gauss-Kruger zone 4");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=12 +k=1 +x_0=4500000 +y_0=0 ");
    add_proj4text (p, 1,
		   "+ellps=krass +towgs84=26,-121,-78,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 2, "efs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942(83) / 3-degree Gauss-Kruger zone 4");
    add_srs_wkt (p, 1,
		 "\",GEOGCS[\"Pulkovo 1942(83)\",DATUM[\"Pulkovo_1942_83\"");
    add_srs_wkt (p, 2,
		 ",SPHEROID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"");
    add_srs_wkt (p, 3,
		 "EPSG\",\"7024\"]],TOWGS84[26,-121,-78,0,0,0,0],AUTHORITY");
    add_srs_wkt (p, 4,
		 "[\"EPSG\",\"6178\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
		 "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
		 "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4178\"]]");
    add_srs_wkt (p, 7,
		 ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
		 "e_of_origin\",0],PARAMETER[\"central_meridian\",12],PARA");
    add_srs_wkt (p, 9,
		 "METER[\"scale_factor\",1],PARAMETER[\"false_easting\",45");
    add_srs_wkt (p, 10,
		 "00000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 11,
		 "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y");
    add_srs_wkt (p, 12, "\",EAST],AUTHORITY[\"EPSG\",\"2398\"]]");
    p = add_epsg_def (filter, first, last, 2399, "epsg", 2399,
		      "Pulkovo 1942(83) / 3-degree Gauss-Kruger zone 5");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=5500000 +y_0=0 ");
    add_proj4text (p, 1,
		   "+ellps=krass +towgs84=26,-121,-78,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 2, "efs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942(83) / 3-degree Gauss-Kruger zone 5");
    add_srs_wkt (p, 1,
		 "\",GEOGCS[\"Pulkovo 1942(83)\",DATUM[\"Pulkovo_1942_83\"");
    add_srs_wkt (p, 2,
		 ",SPHEROID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"");
    add_srs_wkt (p, 3,
		 "EPSG\",\"7024\"]],TOWGS84[26,-121,-78,0,0,0,0],AUTHORITY");
    add_srs_wkt (p, 4,
		 "[\"EPSG\",\"6178\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
		 "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
		 "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4178\"]]");
    add_srs_wkt (p, 7,
		 ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
		 "e_of_origin\",0],PARAMETER[\"central_meridian\",15],PARA");
    add_srs_wkt (p, 9,
		 "METER[\"scale_factor\",1],PARAMETER[\"false_easting\",55");
    add_srs_wkt (p, 10,
		 "00000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 11,
		 "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y");
    add_srs_wkt (p, 12, "\",EAST],AUTHORITY[\"EPSG\",\"2399\"]]");
    p = add_epsg_def (filter, first, last, 2400, "epsg", 2400,
		      "RT90 2.5 gon W (deprecated)");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=15.80827777777778 +k=1 +x_0=");
    add_proj4text (p, 1,
		   "1500000 +y_0=0 +ellps=bessel +towgs84=414.1,41.3,603.1,-");
    add_proj4text (p, 2, "0.855,2.141,-7.023,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"RT90 2.5 gon W (deprecated)\",GEOGCS[\"RT90\",D");
    add_srs_wkt (p, 1,
		 "ATUM[\"Rikets_koordinatsystem_1990\",SPHEROID[\"Bessel 1");
    add_srs_wkt (p, 2,
		 "841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"");
    add_srs_wkt (p, 3,
		 "]],TOWGS84[414.1,41.3,603.1,-0.855,2.141,-7.023,0],AUTHO");
    add_srs_wkt (p, 4,
		 "RITY[\"EPSG\",\"6124\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
		 "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
		 ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4124");
    add_srs_wkt (p, 7,
		 "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 8,
		 "itude_of_origin\",0],PARAMETER[\"central_meridian\",15.8");
    add_srs_wkt (p, 9,
		 "0827777777778],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 10,
		 "false_easting\",1500000],PARAMETER[\"false_northing\",0]");
    add_srs_wkt (p, 11,
		 ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X");
    add_srs_wkt (p, 12,
		 "\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2400\"]]");
    p = add_epsg_def (filter, first, last, 2401, "epsg", 2401,
		      "Beijing 1954 / 3-degree Gauss-Kruger zone 25");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=25500000 +y_0=0");
    add_proj4text (p, 1,
		   " +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=");
    add_proj4text (p, 2, "m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Beijing 1954 / 3-degree Gauss-Kruger zone 25\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
		 "PSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
		 "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
		 "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4214\"]],PRO");
    add_srs_wkt (p, 7,
		 "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
		 "_origin\",0],PARAMETER[\"central_meridian\",75],PARAMETE");
    add_srs_wkt (p, 9,
		 "R[\"scale_factor\",1],PARAMETER[\"false_easting\",255000");
    add_srs_wkt (p, 10,
		 "00],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 11,
		 "HORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",");
    add_srs_wkt (p, 12, "EAST],AUTHORITY[\"EPSG\",\"2401\"]]");
    p = add_epsg_def (filter, first, last, 2402, "epsg", 2402,
		      "Beijing 1954 / 3-degree Gauss-Kruger zone 26");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=78 +k=1 +x_0=26500000 +y_0=0");
    add_proj4text (p, 1,
		   " +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=");
    add_proj4text (p, 2, "m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Beijing 1954 / 3-degree Gauss-Kruger zone 26\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
		 "PSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
		 "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
		 "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4214\"]],PRO");
    add_srs_wkt (p, 7,
		 "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
		 "_origin\",0],PARAMETER[\"central_meridian\",78],PARAMETE");
    add_srs_wkt (p, 9,
		 "R[\"scale_factor\",1],PARAMETER[\"false_easting\",265000");
    add_srs_wkt (p, 10,
		 "00],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 11,
		 "HORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",");
    add_srs_wkt (p, 12, "EAST],AUTHORITY[\"EPSG\",\"2402\"]]");
    p = add_epsg_def (filter, first, last, 2403, "epsg", 2403,
		      "Beijing 1954 / 3-degree Gauss-Kruger zone 27");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=27500000 +y_0=0");
    add_proj4text (p, 1,
		   " +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=");
    add_proj4text (p, 2, "m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Beijing 1954 / 3-degree Gauss-Kruger zone 27\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
		 "PSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
		 "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
		 "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4214\"]],PRO");
    add_srs_wkt (p, 7,
		 "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
		 "_origin\",0],PARAMETER[\"central_meridian\",81],PARAMETE");
    add_srs_wkt (p, 9,
		 "R[\"scale_factor\",1],PARAMETER[\"false_easting\",275000");
    add_srs_wkt (p, 10,
		 "00],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 11,
		 "HORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",");
    add_srs_wkt (p, 12, "EAST],AUTHORITY[\"EPSG\",\"2403\"]]");
    p = add_epsg_def (filter, first, last, 2404, "epsg", 2404,
		      "Beijing 1954 / 3-degree Gauss-Kruger zone 28");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=84 +k=1 +x_0=28500000 +y_0=0");
    add_proj4text (p, 1,
		   " +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=");
    add_proj4text (p, 2, "m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Beijing 1954 / 3-degree Gauss-Kruger zone 28\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
		 "PSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
		 "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
		 "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4214\"]],PRO");
    add_srs_wkt (p, 7,
		 "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
		 "_origin\",0],PARAMETER[\"central_meridian\",84],PARAMETE");
    add_srs_wkt (p, 9,
		 "R[\"scale_factor\",1],PARAMETER[\"false_easting\",285000");
    add_srs_wkt (p, 10,
		 "00],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 11,
		 "HORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",");
    add_srs_wkt (p, 12, "EAST],AUTHORITY[\"EPSG\",\"2404\"]]");
    p = add_epsg_def (filter, first, last, 2405, "epsg", 2405,
		      "Beijing 1954 / 3-degree Gauss-Kruger zone 29");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=29500000 +y_0=0");
    add_proj4text (p, 1,
		   " +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=");
    add_proj4text (p, 2, "m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Beijing 1954 / 3-degree Gauss-Kruger zone 29\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
		 "PSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
		 "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
		 "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4214\"]],PRO");
    add_srs_wkt (p, 7,
		 "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
		 "_origin\",0],PARAMETER[\"central_meridian\",87],PARAMETE");
    add_srs_wkt (p, 9,
		 "R[\"scale_factor\",1],PARAMETER[\"false_easting\",295000");
    add_srs_wkt (p, 10,
		 "00],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 11,
		 "HORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",");
    add_srs_wkt (p, 12, "EAST],AUTHORITY[\"EPSG\",\"2405\"]]");
    p = add_epsg_def (filter, first, last, 2406, "epsg", 2406,
		      "Beijing 1954 / 3-degree Gauss-Kruger zone 30");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=90 +k=1 +x_0=30500000 +y_0=0");
    add_proj4text (p, 1,
		   " +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=");
    add_proj4text (p, 2, "m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Beijing 1954 / 3-degree Gauss-Kruger zone 30\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
		 "PSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
		 "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
		 "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4214\"]],PRO");
    add_srs_wkt (p, 7,
		 "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
		 "_origin\",0],PARAMETER[\"central_meridian\",90],PARAMETE");
    add_srs_wkt (p, 9,
		 "R[\"scale_factor\",1],PARAMETER[\"false_easting\",305000");
    add_srs_wkt (p, 10,
		 "00],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 11,
		 "HORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",");
    add_srs_wkt (p, 12, "EAST],AUTHORITY[\"EPSG\",\"2406\"]]");
    p = add_epsg_def (filter, first, last, 2407, "epsg", 2407,
		      "Beijing 1954 / 3-degree Gauss-Kruger zone 31");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=31500000 +y_0=0");
    add_proj4text (p, 1,
		   " +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=");
    add_proj4text (p, 2, "m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Beijing 1954 / 3-degree Gauss-Kruger zone 31\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
		 "PSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
		 "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
		 "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4214\"]],PRO");
    add_srs_wkt (p, 7,
		 "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
		 "_origin\",0],PARAMETER[\"central_meridian\",93],PARAMETE");
    add_srs_wkt (p, 9,
		 "R[\"scale_factor\",1],PARAMETER[\"false_easting\",315000");
    add_srs_wkt (p, 10,
		 "00],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 11,
		 "HORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",");
    add_srs_wkt (p, 12, "EAST],AUTHORITY[\"EPSG\",\"2407\"]]");
    p = add_epsg_def (filter, first, last, 2408, "epsg", 2408,
		      "Beijing 1954 / 3-degree Gauss-Kruger zone 32");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=96 +k=1 +x_0=32500000 +y_0=0");
    add_proj4text (p, 1,
		   " +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=");
    add_proj4text (p, 2, "m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Beijing 1954 / 3-degree Gauss-Kruger zone 32\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
		 "PSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
		 "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
		 "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4214\"]],PRO");
    add_srs_wkt (p, 7,
		 "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
		 "_origin\",0],PARAMETER[\"central_meridian\",96],PARAMETE");
    add_srs_wkt (p, 9,
		 "R[\"scale_factor\",1],PARAMETER[\"false_easting\",325000");
    add_srs_wkt (p, 10,
		 "00],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 11,
		 "HORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",");
    add_srs_wkt (p, 12, "EAST],AUTHORITY[\"EPSG\",\"2408\"]]");
    p = add_epsg_def (filter, first, last, 2409, "epsg", 2409,
		      "Beijing 1954 / 3-degree Gauss-Kruger zone 33");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=33500000 +y_0=0");
    add_proj4text (p, 1,
		   " +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=");
    add_proj4text (p, 2, "m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Beijing 1954 / 3-degree Gauss-Kruger zone 33\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
		 "PSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
		 "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
		 "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4214\"]],PRO");
    add_srs_wkt (p, 7,
		 "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
		 "_origin\",0],PARAMETER[\"central_meridian\",99],PARAMETE");
    add_srs_wkt (p, 9,
		 "R[\"scale_factor\",1],PARAMETER[\"false_easting\",335000");
    add_srs_wkt (p, 10,
		 "00],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 11,
		 "HORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",");
    add_srs_wkt (p, 12, "EAST],AUTHORITY[\"EPSG\",\"2409\"]]");
    p = add_epsg_def (filter, first, last, 2410, "epsg", 2410,
		      "Beijing 1954 / 3-degree Gauss-Kruger zone 34");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=102 +k=1 +x_0=34500000 +y_0=");
    add_proj4text (p, 1,
		   "0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units");
    add_proj4text (p, 2, "=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Beijing 1954 / 3-degree Gauss-Kruger zone 34\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
		 "PSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
		 "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
		 "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4214\"]],PRO");
    add_srs_wkt (p, 7,
		 "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
		 "_origin\",0],PARAMETER[\"central_meridian\",102],PARAMET");
    add_srs_wkt (p, 9,
		 "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",34500");
    add_srs_wkt (p, 10,
		 "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
		 "THORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 12, ",EAST],AUTHORITY[\"EPSG\",\"2410\"]]");
    p = add_epsg_def (filter, first, last, 2411, "epsg", 2411,
		      "Beijing 1954 / 3-degree Gauss-Kruger zone 35");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=35500000 +y_0=");
    add_proj4text (p, 1,
		   "0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units");
    add_proj4text (p, 2, "=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Beijing 1954 / 3-degree Gauss-Kruger zone 35\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
		 "PSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
		 "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
		 "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4214\"]],PRO");
    add_srs_wkt (p, 7,
		 "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
		 "_origin\",0],PARAMETER[\"central_meridian\",105],PARAMET");
    add_srs_wkt (p, 9,
		 "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",35500");
    add_srs_wkt (p, 10,
		 "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
		 "THORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 12, ",EAST],AUTHORITY[\"EPSG\",\"2411\"]]");
    p = add_epsg_def (filter, first, last, 2412, "epsg", 2412,
		      "Beijing 1954 / 3-degree Gauss-Kruger zone 36");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=108 +k=1 +x_0=36500000 +y_0=");
    add_proj4text (p, 1,
		   "0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units");
    add_proj4text (p, 2, "=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Beijing 1954 / 3-degree Gauss-Kruger zone 36\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
		 "PSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
		 "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
		 "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4214\"]],PRO");
    add_srs_wkt (p, 7,
		 "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
		 "_origin\",0],PARAMETER[\"central_meridian\",108],PARAMET");
    add_srs_wkt (p, 9,
		 "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",36500");
    add_srs_wkt (p, 10,
		 "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
		 "THORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 12, ",EAST],AUTHORITY[\"EPSG\",\"2412\"]]");
    p = add_epsg_def (filter, first, last, 2413, "epsg", 2413,
		      "Beijing 1954 / 3-degree Gauss-Kruger zone 37");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=37500000 +y_0=");
    add_proj4text (p, 1,
		   "0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units");
    add_proj4text (p, 2, "=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Beijing 1954 / 3-degree Gauss-Kruger zone 37\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
		 "PSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
		 "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
		 "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4214\"]],PRO");
    add_srs_wkt (p, 7,
		 "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
		 "_origin\",0],PARAMETER[\"central_meridian\",111],PARAMET");
    add_srs_wkt (p, 9,
		 "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",37500");
    add_srs_wkt (p, 10,
		 "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
		 "THORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 12, ",EAST],AUTHORITY[\"EPSG\",\"2413\"]]");
    p = add_epsg_def (filter, first, last, 2414, "epsg", 2414,
		      "Beijing 1954 / 3-degree Gauss-Kruger zone 38");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=114 +k=1 +x_0=38500000 +y_0=");
    add_proj4text (p, 1,
		   "0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units");
    add_proj4text (p, 2, "=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Beijing 1954 / 3-degree Gauss-Kruger zone 38\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
		 "PSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
		 "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
		 "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4214\"]],PRO");
    add_srs_wkt (p, 7,
		 "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
		 "_origin\",0],PARAMETER[\"central_meridian\",114],PARAMET");
    add_srs_wkt (p, 9,
		 "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",38500");
    add_srs_wkt (p, 10,
		 "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
		 "THORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 12, ",EAST],AUTHORITY[\"EPSG\",\"2414\"]]");
    p = add_epsg_def (filter, first, last, 2415, "epsg", 2415,
		      "Beijing 1954 / 3-degree Gauss-Kruger zone 39");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=39500000 +y_0=");
    add_proj4text (p, 1,
		   "0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units");
    add_proj4text (p, 2, "=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Beijing 1954 / 3-degree Gauss-Kruger zone 39\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
		 "PSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
		 "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
		 "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4214\"]],PRO");
    add_srs_wkt (p, 7,
		 "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
		 "_origin\",0],PARAMETER[\"central_meridian\",117],PARAMET");
    add_srs_wkt (p, 9,
		 "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",39500");
    add_srs_wkt (p, 10,
		 "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
		 "THORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 12, ",EAST],AUTHORITY[\"EPSG\",\"2415\"]]");
    p = add_epsg_def (filter, first, last, 2416, "epsg", 2416,
		      "Beijing 1954 / 3-degree Gauss-Kruger zone 40");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=120 +k=1 +x_0=40500000 +y_0=");
    add_proj4text (p, 1,
		   "0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units");
    add_proj4text (p, 2, "=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Beijing 1954 / 3-degree Gauss-Kruger zone 40\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
		 "PSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
		 "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
		 "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4214\"]],PRO");
    add_srs_wkt (p, 7,
		 "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
		 "_origin\",0],PARAMETER[\"central_meridian\",120],PARAMET");
    add_srs_wkt (p, 9,
		 "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",40500");
    add_srs_wkt (p, 10,
		 "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
		 "THORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 12, ",EAST],AUTHORITY[\"EPSG\",\"2416\"]]");
    p = add_epsg_def (filter, first, last, 2417, "epsg", 2417,
		      "Beijing 1954 / 3-degree Gauss-Kruger zone 41");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=41500000 +y_0=");
    add_proj4text (p, 1,
		   "0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units");
    add_proj4text (p, 2, "=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Beijing 1954 / 3-degree Gauss-Kruger zone 41\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
		 "PSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
		 "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
		 "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4214\"]],PRO");
    add_srs_wkt (p, 7,
		 "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
		 "_origin\",0],PARAMETER[\"central_meridian\",123],PARAMET");
    add_srs_wkt (p, 9,
		 "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",41500");
    add_srs_wkt (p, 10,
		 "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
		 "THORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 12, ",EAST],AUTHORITY[\"EPSG\",\"2417\"]]");
    p = add_epsg_def (filter, first, last, 2418, "epsg", 2418,
		      "Beijing 1954 / 3-degree Gauss-Kruger zone 42");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=126 +k=1 +x_0=42500000 +y_0=");
    add_proj4text (p, 1,
		   "0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units");
    add_proj4text (p, 2, "=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Beijing 1954 / 3-degree Gauss-Kruger zone 42\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
		 "PSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
		 "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
		 "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4214\"]],PRO");
    add_srs_wkt (p, 7,
		 "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
		 "_origin\",0],PARAMETER[\"central_meridian\",126],PARAMET");
    add_srs_wkt (p, 9,
		 "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",42500");
    add_srs_wkt (p, 10,
		 "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
		 "THORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 12, ",EAST],AUTHORITY[\"EPSG\",\"2418\"]]");
    p = add_epsg_def (filter, first, last, 2419, "epsg", 2419,
		      "Beijing 1954 / 3-degree Gauss-Kruger zone 43");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=43500000 +y_0=");
    add_proj4text (p, 1,
		   "0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units");
    add_proj4text (p, 2, "=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Beijing 1954 / 3-degree Gauss-Kruger zone 43\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
		 "PSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
		 "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
		 "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4214\"]],PRO");
    add_srs_wkt (p, 7,
		 "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
		 "_origin\",0],PARAMETER[\"central_meridian\",129],PARAMET");
    add_srs_wkt (p, 9,
		 "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",43500");
    add_srs_wkt (p, 10,
		 "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
		 "THORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 12, ",EAST],AUTHORITY[\"EPSG\",\"2419\"]]");
    p = add_epsg_def (filter, first, last, 2420, "epsg", 2420,
		      "Beijing 1954 / 3-degree Gauss-Kruger zone 44");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=132 +k=1 +x_0=44500000 +y_0=");
    add_proj4text (p, 1,
		   "0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units");
    add_proj4text (p, 2, "=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Beijing 1954 / 3-degree Gauss-Kruger zone 44\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
		 "PSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
		 "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
		 "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4214\"]],PRO");
    add_srs_wkt (p, 7,
		 "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
		 "_origin\",0],PARAMETER[\"central_meridian\",132],PARAMET");
    add_srs_wkt (p, 9,
		 "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",44500");
    add_srs_wkt (p, 10,
		 "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
		 "THORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 12, ",EAST],AUTHORITY[\"EPSG\",\"2420\"]]");
    p = add_epsg_def (filter, first, last, 2421, "epsg", 2421,
		      "Beijing 1954 / 3-degree Gauss-Kruger zone 45");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=45500000 +y_0=");
    add_proj4text (p, 1,
		   "0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units");
    add_proj4text (p, 2, "=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Beijing 1954 / 3-degree Gauss-Kruger zone 45\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
		 "PSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
		 "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
		 "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4214\"]],PRO");
    add_srs_wkt (p, 7,
		 "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
		 "_origin\",0],PARAMETER[\"central_meridian\",135],PARAMET");
    add_srs_wkt (p, 9,
		 "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",45500");
    add_srs_wkt (p, 10,
		 "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
		 "THORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 12, ",EAST],AUTHORITY[\"EPSG\",\"2421\"]]");
    p = add_epsg_def (filter, first, last, 2422, "epsg", 2422,
		      "Beijing 1954 / 3-degree Gauss-Kruger CM 75E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
		   "ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m ");
    add_proj4text (p, 2, "+no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Beijing 1954 / 3-degree Gauss-Kruger CM 75E\",G");
    add_srs_wkt (p, 1,
		 "EOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"");
    add_srs_wkt (p, 2,
		 "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
		 "4\"]],TOWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
		 "G\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
		 ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
		 "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4214\"]],PROJE");
    add_srs_wkt (p, 7,
		 "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
		 "rigin\",0],PARAMETER[\"central_meridian\",75],PARAMETER[");
    add_srs_wkt (p, 9,
		 "\"scale_factor\",1],PARAMETER[\"false_easting\",500000],");
    add_srs_wkt (p, 10,
		 "PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
		 "TY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST");
    add_srs_wkt (p, 12, "],AUTHORITY[\"EPSG\",\"2422\"]]");
    p = add_epsg_def (filter, first, last, 2423, "epsg", 2423,
		      "Beijing 1954 / 3-degree Gauss-Kruger CM 78E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=78 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
		   "ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m ");
    add_proj4text (p, 2, "+no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Beijing 1954 / 3-degree Gauss-Kruger CM 78E\",G");
    add_srs_wkt (p, 1,
		 "EOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"");
    add_srs_wkt (p, 2,
		 "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
		 "4\"]],TOWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
		 "G\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
		 ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
		 "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4214\"]],PROJE");
    add_srs_wkt (p, 7,
		 "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
		 "rigin\",0],PARAMETER[\"central_meridian\",78],PARAMETER[");
    add_srs_wkt (p, 9,
		 "\"scale_factor\",1],PARAMETER[\"false_easting\",500000],");
    add_srs_wkt (p, 10,
		 "PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
		 "TY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST");
    add_srs_wkt (p, 12, "],AUTHORITY[\"EPSG\",\"2423\"]]");
    p = add_epsg_def (filter, first, last, 2424, "epsg", 2424,
		      "Beijing 1954 / 3-degree Gauss-Kruger CM 81E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
		   "ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m ");
    add_proj4text (p, 2, "+no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Beijing 1954 / 3-degree Gauss-Kruger CM 81E\",G");
    add_srs_wkt (p, 1,
		 "EOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"");
    add_srs_wkt (p, 2,
		 "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
		 "4\"]],TOWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
		 "G\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
		 ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
		 "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4214\"]],PROJE");
    add_srs_wkt (p, 7,
		 "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
		 "rigin\",0],PARAMETER[\"central_meridian\",81],PARAMETER[");
    add_srs_wkt (p, 9,
		 "\"scale_factor\",1],PARAMETER[\"false_easting\",500000],");
    add_srs_wkt (p, 10,
		 "PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
		 "TY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST");
    add_srs_wkt (p, 12, "],AUTHORITY[\"EPSG\",\"2424\"]]");
    p = add_epsg_def (filter, first, last, 2425, "epsg", 2425,
		      "Beijing 1954 / 3-degree Gauss-Kruger CM 84E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=84 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
		   "ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m ");
    add_proj4text (p, 2, "+no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Beijing 1954 / 3-degree Gauss-Kruger CM 84E\",G");
    add_srs_wkt (p, 1,
		 "EOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"");
    add_srs_wkt (p, 2,
		 "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
		 "4\"]],TOWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
		 "G\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
		 ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
		 "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4214\"]],PROJE");
    add_srs_wkt (p, 7,
		 "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
		 "rigin\",0],PARAMETER[\"central_meridian\",84],PARAMETER[");
    add_srs_wkt (p, 9,
		 "\"scale_factor\",1],PARAMETER[\"false_easting\",500000],");
    add_srs_wkt (p, 10,
		 "PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
		 "TY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST");
    add_srs_wkt (p, 12, "],AUTHORITY[\"EPSG\",\"2425\"]]");
}

static void
initialize_epsg_04 (int filter, struct epsg_defs **first,
		    struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def (filter, first, last, 2426, "epsg", 2426,
		      "Beijing 1954 / 3-degree Gauss-Kruger CM 87E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
		   "ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m ");
    add_proj4text (p, 2, "+no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Beijing 1954 / 3-degree Gauss-Kruger CM 87E\",G");
    add_srs_wkt (p, 1,
		 "EOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"");
    add_srs_wkt (p, 2,
		 "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
		 "4\"]],TOWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
		 "G\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
		 ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
		 "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4214\"]],PROJE");
    add_srs_wkt (p, 7,
		 "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
		 "rigin\",0],PARAMETER[\"central_meridian\",87],PARAMETER[");
    add_srs_wkt (p, 9,
		 "\"scale_factor\",1],PARAMETER[\"false_easting\",500000],");
    add_srs_wkt (p, 10,
		 "PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
		 "TY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST");
    add_srs_wkt (p, 12, "],AUTHORITY[\"EPSG\",\"2426\"]]");
    p = add_epsg_def (filter, first, last, 2427, "epsg", 2427,
		      "Beijing 1954 / 3-degree Gauss-Kruger CM 90E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=90 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
		   "ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m ");
    add_proj4text (p, 2, "+no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Beijing 1954 / 3-degree Gauss-Kruger CM 90E\",G");
    add_srs_wkt (p, 1,
		 "EOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"");
    add_srs_wkt (p, 2,
		 "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
		 "4\"]],TOWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
		 "G\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
		 ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
		 "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4214\"]],PROJE");
    add_srs_wkt (p, 7,
		 "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
		 "rigin\",0],PARAMETER[\"central_meridian\",90],PARAMETER[");
    add_srs_wkt (p, 9,
		 "\"scale_factor\",1],PARAMETER[\"false_easting\",500000],");
    add_srs_wkt (p, 10,
		 "PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
		 "TY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST");
    add_srs_wkt (p, 12, "],AUTHORITY[\"EPSG\",\"2427\"]]");
    p = add_epsg_def (filter, first, last, 2428, "epsg", 2428,
		      "Beijing 1954 / 3-degree Gauss-Kruger CM 93E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
		   "ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m ");
    add_proj4text (p, 2, "+no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Beijing 1954 / 3-degree Gauss-Kruger CM 93E\",G");
    add_srs_wkt (p, 1,
		 "EOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"");
    add_srs_wkt (p, 2,
		 "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
		 "4\"]],TOWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
		 "G\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
		 ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
		 "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4214\"]],PROJE");
    add_srs_wkt (p, 7,
		 "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
		 "rigin\",0],PARAMETER[\"central_meridian\",93],PARAMETER[");
    add_srs_wkt (p, 9,
		 "\"scale_factor\",1],PARAMETER[\"false_easting\",500000],");
    add_srs_wkt (p, 10,
		 "PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
		 "TY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST");
    add_srs_wkt (p, 12, "],AUTHORITY[\"EPSG\",\"2428\"]]");
    p = add_epsg_def (filter, first, last, 2429, "epsg", 2429,
		      "Beijing 1954 / 3-degree Gauss-Kruger CM 96E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=96 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
		   "ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m ");
    add_proj4text (p, 2, "+no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Beijing 1954 / 3-degree Gauss-Kruger CM 96E\",G");
    add_srs_wkt (p, 1,
		 "EOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"");
    add_srs_wkt (p, 2,
		 "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
		 "4\"]],TOWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
		 "G\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
		 ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
		 "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4214\"]],PROJE");
    add_srs_wkt (p, 7,
		 "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
		 "rigin\",0],PARAMETER[\"central_meridian\",96],PARAMETER[");
    add_srs_wkt (p, 9,
		 "\"scale_factor\",1],PARAMETER[\"false_easting\",500000],");
    add_srs_wkt (p, 10,
		 "PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
		 "TY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST");
    add_srs_wkt (p, 12, "],AUTHORITY[\"EPSG\",\"2429\"]]");
    p = add_epsg_def (filter, first, last, 2430, "epsg", 2430,
		      "Beijing 1954 / 3-degree Gauss-Kruger CM 99E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
		   "ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m ");
    add_proj4text (p, 2, "+no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Beijing 1954 / 3-degree Gauss-Kruger CM 99E\",G");
    add_srs_wkt (p, 1,
		 "EOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"");
    add_srs_wkt (p, 2,
		 "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
		 "4\"]],TOWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
		 "G\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
		 ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
		 "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4214\"]],PROJE");
    add_srs_wkt (p, 7,
		 "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
		 "rigin\",0],PARAMETER[\"central_meridian\",99],PARAMETER[");
    add_srs_wkt (p, 9,
		 "\"scale_factor\",1],PARAMETER[\"false_easting\",500000],");
    add_srs_wkt (p, 10,
		 "PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
		 "TY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST");
    add_srs_wkt (p, 12, "],AUTHORITY[\"EPSG\",\"2430\"]]");
    p = add_epsg_def (filter, first, last, 2431, "epsg", 2431,
		      "Beijing 1954 / 3-degree Gauss-Kruger CM 102E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=102 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
		   "+ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m");
    add_proj4text (p, 2, " +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Beijing 1954 / 3-degree Gauss-Kruger CM 102E\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
		 "PSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
		 "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
		 "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4214\"]],PRO");
    add_srs_wkt (p, 7,
		 "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
		 "_origin\",0],PARAMETER[\"central_meridian\",102],PARAMET");
    add_srs_wkt (p, 9,
		 "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
		 "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
		 "ORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",E");
    add_srs_wkt (p, 12, "AST],AUTHORITY[\"EPSG\",\"2431\"]]");
    p = add_epsg_def (filter, first, last, 2432, "epsg", 2432,
		      "Beijing 1954 / 3-degree Gauss-Kruger CM 105E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
		   "+ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m");
    add_proj4text (p, 2, " +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Beijing 1954 / 3-degree Gauss-Kruger CM 105E\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
		 "PSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
		 "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
		 "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4214\"]],PRO");
    add_srs_wkt (p, 7,
		 "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
		 "_origin\",0],PARAMETER[\"central_meridian\",105],PARAMET");
    add_srs_wkt (p, 9,
		 "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
		 "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
		 "ORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",E");
    add_srs_wkt (p, 12, "AST],AUTHORITY[\"EPSG\",\"2432\"]]");
    p = add_epsg_def (filter, first, last, 2433, "epsg", 2433,
		      "Beijing 1954 / 3-degree Gauss-Kruger CM 108E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=108 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
		   "+ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m");
    add_proj4text (p, 2, " +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Beijing 1954 / 3-degree Gauss-Kruger CM 108E\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
		 "PSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
		 "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
		 "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4214\"]],PRO");
    add_srs_wkt (p, 7,
		 "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
		 "_origin\",0],PARAMETER[\"central_meridian\",108],PARAMET");
    add_srs_wkt (p, 9,
		 "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
		 "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
		 "ORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",E");
    add_srs_wkt (p, 12, "AST],AUTHORITY[\"EPSG\",\"2433\"]]");
    p = add_epsg_def (filter, first, last, 2434, "epsg", 2434,
		      "Beijing 1954 / 3-degree Gauss-Kruger CM 111E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
		   "+ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m");
    add_proj4text (p, 2, " +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Beijing 1954 / 3-degree Gauss-Kruger CM 111E\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
		 "PSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
		 "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
		 "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4214\"]],PRO");
    add_srs_wkt (p, 7,
		 "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
		 "_origin\",0],PARAMETER[\"central_meridian\",111],PARAMET");
    add_srs_wkt (p, 9,
		 "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
		 "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
		 "ORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",E");
    add_srs_wkt (p, 12, "AST],AUTHORITY[\"EPSG\",\"2434\"]]");
    p = add_epsg_def (filter, first, last, 2435, "epsg", 2435,
		      "Beijing 1954 / 3-degree Gauss-Kruger CM 114E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=114 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
		   "+ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m");
    add_proj4text (p, 2, " +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Beijing 1954 / 3-degree Gauss-Kruger CM 114E\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
		 "PSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
		 "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
		 "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4214\"]],PRO");
    add_srs_wkt (p, 7,
		 "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
		 "_origin\",0],PARAMETER[\"central_meridian\",114],PARAMET");
    add_srs_wkt (p, 9,
		 "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
		 "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
		 "ORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",E");
    add_srs_wkt (p, 12, "AST],AUTHORITY[\"EPSG\",\"2435\"]]");
    p = add_epsg_def (filter, first, last, 2436, "epsg", 2436,
		      "Beijing 1954 / 3-degree Gauss-Kruger CM 117E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
		   "+ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m");
    add_proj4text (p, 2, " +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Beijing 1954 / 3-degree Gauss-Kruger CM 117E\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
		 "PSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
		 "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
		 "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4214\"]],PRO");
    add_srs_wkt (p, 7,
		 "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
		 "_origin\",0],PARAMETER[\"central_meridian\",117],PARAMET");
    add_srs_wkt (p, 9,
		 "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
		 "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
		 "ORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",E");
    add_srs_wkt (p, 12, "AST],AUTHORITY[\"EPSG\",\"2436\"]]");
    p = add_epsg_def (filter, first, last, 2437, "epsg", 2437,
		      "Beijing 1954 / 3-degree Gauss-Kruger CM 120E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=120 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
		   "+ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m");
    add_proj4text (p, 2, " +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Beijing 1954 / 3-degree Gauss-Kruger CM 120E\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
		 "PSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
		 "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
		 "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4214\"]],PRO");
    add_srs_wkt (p, 7,
		 "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
		 "_origin\",0],PARAMETER[\"central_meridian\",120],PARAMET");
    add_srs_wkt (p, 9,
		 "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
		 "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
		 "ORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",E");
    add_srs_wkt (p, 12, "AST],AUTHORITY[\"EPSG\",\"2437\"]]");
    p = add_epsg_def (filter, first, last, 2438, "epsg", 2438,
		      "Beijing 1954 / 3-degree Gauss-Kruger CM 123E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
		   "+ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m");
    add_proj4text (p, 2, " +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Beijing 1954 / 3-degree Gauss-Kruger CM 123E\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
		 "PSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
		 "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
		 "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4214\"]],PRO");
    add_srs_wkt (p, 7,
		 "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
		 "_origin\",0],PARAMETER[\"central_meridian\",123],PARAMET");
    add_srs_wkt (p, 9,
		 "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
		 "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
		 "ORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",E");
    add_srs_wkt (p, 12, "AST],AUTHORITY[\"EPSG\",\"2438\"]]");
    p = add_epsg_def (filter, first, last, 2439, "epsg", 2439,
		      "Beijing 1954 / 3-degree Gauss-Kruger CM 126E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=126 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
		   "+ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m");
    add_proj4text (p, 2, " +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Beijing 1954 / 3-degree Gauss-Kruger CM 126E\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
		 "PSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
		 "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
		 "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4214\"]],PRO");
    add_srs_wkt (p, 7,
		 "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
		 "_origin\",0],PARAMETER[\"central_meridian\",126],PARAMET");
    add_srs_wkt (p, 9,
		 "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
		 "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
		 "ORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",E");
    add_srs_wkt (p, 12, "AST],AUTHORITY[\"EPSG\",\"2439\"]]");
    p = add_epsg_def (filter, first, last, 2440, "epsg", 2440,
		      "Beijing 1954 / 3-degree Gauss-Kruger CM 129E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
		   "+ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m");
    add_proj4text (p, 2, " +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Beijing 1954 / 3-degree Gauss-Kruger CM 129E\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
		 "PSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
		 "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
		 "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4214\"]],PRO");
    add_srs_wkt (p, 7,
		 "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
		 "_origin\",0],PARAMETER[\"central_meridian\",129],PARAMET");
    add_srs_wkt (p, 9,
		 "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
		 "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
		 "ORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",E");
    add_srs_wkt (p, 12, "AST],AUTHORITY[\"EPSG\",\"2440\"]]");
    p = add_epsg_def (filter, first, last, 2441, "epsg", 2441,
		      "Beijing 1954 / 3-degree Gauss-Kruger CM 132E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=132 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
		   "+ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m");
    add_proj4text (p, 2, " +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Beijing 1954 / 3-degree Gauss-Kruger CM 132E\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
		 "PSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
		 "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
		 "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4214\"]],PRO");
    add_srs_wkt (p, 7,
		 "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
		 "_origin\",0],PARAMETER[\"central_meridian\",132],PARAMET");
    add_srs_wkt (p, 9,
		 "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
		 "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
		 "ORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",E");
    add_srs_wkt (p, 12, "AST],AUTHORITY[\"EPSG\",\"2441\"]]");
    p = add_epsg_def (filter, first, last, 2442, "epsg", 2442,
		      "Beijing 1954 / 3-degree Gauss-Kruger CM 135E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
		   "+ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m");
    add_proj4text (p, 2, " +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Beijing 1954 / 3-degree Gauss-Kruger CM 135E\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
		 "PSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
		 "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
		 "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4214\"]],PRO");
    add_srs_wkt (p, 7,
		 "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
		 "_origin\",0],PARAMETER[\"central_meridian\",135],PARAMET");
    add_srs_wkt (p, 9,
		 "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
		 "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
		 "ORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",E");
    add_srs_wkt (p, 12, "AST],AUTHORITY[\"EPSG\",\"2442\"]]");
    p = add_epsg_def (filter, first, last, 2443, "epsg", 2443,
		      "JGD2000 / Japan Plane Rectangular CS I");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=33 +lon_0=129.5 +k=0.9999 +x_0=0 +y_0");
    add_proj4text (p, 1,
		   "=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"JGD2000 / Japan Plane Rectangular CS I\",GEOGCS");
    add_srs_wkt (p, 1,
		 "[\"JGD2000\",DATUM[\"Japanese_Geodetic_Datum_2000\",SPHE");
    add_srs_wkt (p, 2,
		 "ROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
		 "\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
		 "\"6612\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
		 "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
		 "PSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4612\"]],PROJECTIO");
    add_srs_wkt (p, 7,
		 "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
		 "n\",33],PARAMETER[\"central_meridian\",129.5],PARAMETER[");
    add_srs_wkt (p, 9,
		 "\"scale_factor\",0.9999],PARAMETER[\"false_easting\",0],");
    add_srs_wkt (p, 10,
		 "PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
		 "TY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST");
    add_srs_wkt (p, 12, "],AUTHORITY[\"EPSG\",\"2443\"]]");
    p = add_epsg_def (filter, first, last, 2444, "epsg", 2444,
		      "JGD2000 / Japan Plane Rectangular CS II");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=33 +lon_0=131 +k=0.9999 +x_0=0 +y_0=0");
    add_proj4text (p, 1,
		   " +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"JGD2000 / Japan Plane Rectangular CS II\",GEOGC");
    add_srs_wkt (p, 1,
		 "S[\"JGD2000\",DATUM[\"Japanese_Geodetic_Datum_2000\",SPH");
    add_srs_wkt (p, 2,
		 "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
		 "G\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
		 ",\"6612\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
		 "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
		 "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4612\"]],PROJECTI");
    add_srs_wkt (p, 7,
		 "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
		 "in\",33],PARAMETER[\"central_meridian\",131],PARAMETER[\"");
    add_srs_wkt (p, 9,
		 "scale_factor\",0.9999],PARAMETER[\"false_easting\",0],PA");
    add_srs_wkt (p, 10,
		 "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
		 "[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],");
    add_srs_wkt (p, 12, "AUTHORITY[\"EPSG\",\"2444\"]]");
    p = add_epsg_def (filter, first, last, 2445, "epsg", 2445,
		      "JGD2000 / Japan Plane Rectangular CS III");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=36 +lon_0=132.1666666666667 +k=0.9999");
    add_proj4text (p, 1,
		   " +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +unit");
    add_proj4text (p, 2, "s=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"JGD2000 / Japan Plane Rectangular CS III\",GEOG");
    add_srs_wkt (p, 1,
		 "CS[\"JGD2000\",DATUM[\"Japanese_Geodetic_Datum_2000\",SP");
    add_srs_wkt (p, 2,
		 "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
		 "SG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
		 ",\"6612\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
		 "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
		 "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4612\"]],PROJECTI");
    add_srs_wkt (p, 7,
		 "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
		 "in\",36],PARAMETER[\"central_meridian\",132.166666666666");
    add_srs_wkt (p, 9,
		 "7],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
		 "easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 11,
		 "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AX");
    add_srs_wkt (p, 12, "IS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2445\"]]");
    p = add_epsg_def (filter, first, last, 2446, "epsg", 2446,
		      "JGD2000 / Japan Plane Rectangular CS IV");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=33 +lon_0=133.5 +k=0.9999 +x_0=0 +y_0");
    add_proj4text (p, 1,
		   "=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"JGD2000 / Japan Plane Rectangular CS IV\",GEOGC");
    add_srs_wkt (p, 1,
		 "S[\"JGD2000\",DATUM[\"Japanese_Geodetic_Datum_2000\",SPH");
    add_srs_wkt (p, 2,
		 "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
		 "G\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
		 ",\"6612\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
		 "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
		 "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4612\"]],PROJECTI");
    add_srs_wkt (p, 7,
		 "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
		 "in\",33],PARAMETER[\"central_meridian\",133.5],PARAMETER");
    add_srs_wkt (p, 9,
		 "[\"scale_factor\",0.9999],PARAMETER[\"false_easting\",0]");
    add_srs_wkt (p, 10,
		 ",PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 11,
		 "ITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAS");
    add_srs_wkt (p, 12, "T],AUTHORITY[\"EPSG\",\"2446\"]]");
    p = add_epsg_def (filter, first, last, 2447, "epsg", 2447,
		      "JGD2000 / Japan Plane Rectangular CS V");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=36 +lon_0=134.3333333333333 +k=0.9999");
    add_proj4text (p, 1,
		   " +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +unit");
    add_proj4text (p, 2, "s=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"JGD2000 / Japan Plane Rectangular CS V\",GEOGCS");
    add_srs_wkt (p, 1,
		 "[\"JGD2000\",DATUM[\"Japanese_Geodetic_Datum_2000\",SPHE");
    add_srs_wkt (p, 2,
		 "ROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
		 "\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
		 "\"6612\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
		 "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
		 "PSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4612\"]],PROJECTIO");
    add_srs_wkt (p, 7,
		 "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
		 "n\",36],PARAMETER[\"central_meridian\",134.3333333333333");
    add_srs_wkt (p, 9,
		 "],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"false_e");
    add_srs_wkt (p, 10,
		 "asting\",0],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 11,
		 "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXI");
    add_srs_wkt (p, 12, "S[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2447\"]]");
    p = add_epsg_def (filter, first, last, 2448, "epsg", 2448,
		      "JGD2000 / Japan Plane Rectangular CS VI");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=36 +lon_0=136 +k=0.9999 +x_0=0 +y_0=0");
    add_proj4text (p, 1,
		   " +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"JGD2000 / Japan Plane Rectangular CS VI\",GEOGC");
    add_srs_wkt (p, 1,
		 "S[\"JGD2000\",DATUM[\"Japanese_Geodetic_Datum_2000\",SPH");
    add_srs_wkt (p, 2,
		 "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
		 "G\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
		 ",\"6612\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
		 "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
		 "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4612\"]],PROJECTI");
    add_srs_wkt (p, 7,
		 "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
		 "in\",36],PARAMETER[\"central_meridian\",136],PARAMETER[\"");
    add_srs_wkt (p, 9,
		 "scale_factor\",0.9999],PARAMETER[\"false_easting\",0],PA");
    add_srs_wkt (p, 10,
		 "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
		 "[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],");
    add_srs_wkt (p, 12, "AUTHORITY[\"EPSG\",\"2448\"]]");
    p = add_epsg_def (filter, first, last, 2449, "epsg", 2449,
		      "JGD2000 / Japan Plane Rectangular CS VII");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=36 +lon_0=137.1666666666667 +k=0.9999");
    add_proj4text (p, 1,
		   " +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +unit");
    add_proj4text (p, 2, "s=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"JGD2000 / Japan Plane Rectangular CS VII\",GEOG");
    add_srs_wkt (p, 1,
		 "CS[\"JGD2000\",DATUM[\"Japanese_Geodetic_Datum_2000\",SP");
    add_srs_wkt (p, 2,
		 "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
		 "SG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
		 ",\"6612\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
		 "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
		 "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4612\"]],PROJECTI");
    add_srs_wkt (p, 7,
		 "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
		 "in\",36],PARAMETER[\"central_meridian\",137.166666666666");
    add_srs_wkt (p, 9,
		 "7],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
		 "easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 11,
		 "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AX");
    add_srs_wkt (p, 12, "IS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2449\"]]");
    p = add_epsg_def (filter, first, last, 2450, "epsg", 2450,
		      "JGD2000 / Japan Plane Rectangular CS VIII");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=36 +lon_0=138.5 +k=0.9999 +x_0=0 +y_0");
    add_proj4text (p, 1,
		   "=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"JGD2000 / Japan Plane Rectangular CS VIII\",GEO");
    add_srs_wkt (p, 1,
		 "GCS[\"JGD2000\",DATUM[\"Japanese_Geodetic_Datum_2000\",S");
    add_srs_wkt (p, 2,
		 "PHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"E");
    add_srs_wkt (p, 3,
		 "PSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
		 "\",\"6612\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
		 "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 6,
		 "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4612\"]],PROJEC");
    add_srs_wkt (p, 7,
		 "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 8,
		 "igin\",36],PARAMETER[\"central_meridian\",138.5],PARAMET");
    add_srs_wkt (p, 9,
		 "ER[\"scale_factor\",0.9999],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 10,
		 "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
		 "ORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",E");
    add_srs_wkt (p, 12, "AST],AUTHORITY[\"EPSG\",\"2450\"]]");
    p = add_epsg_def (filter, first, last, 2451, "epsg", 2451,
		      "JGD2000 / Japan Plane Rectangular CS IX");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=36 +lon_0=139.8333333333333 +k=0.9999");
    add_proj4text (p, 1,
		   " +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +unit");
    add_proj4text (p, 2, "s=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"JGD2000 / Japan Plane Rectangular CS IX\",GEOGC");
    add_srs_wkt (p, 1,
		 "S[\"JGD2000\",DATUM[\"Japanese_Geodetic_Datum_2000\",SPH");
    add_srs_wkt (p, 2,
		 "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
		 "G\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
		 ",\"6612\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
		 "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
		 "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4612\"]],PROJECTI");
    add_srs_wkt (p, 7,
		 "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
		 "in\",36],PARAMETER[\"central_meridian\",139.833333333333");
    add_srs_wkt (p, 9,
		 "3],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
		 "easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 11,
		 "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AX");
    add_srs_wkt (p, 12, "IS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2451\"]]");
    p = add_epsg_def (filter, first, last, 2452, "epsg", 2452,
		      "JGD2000 / Japan Plane Rectangular CS X");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=40 +lon_0=140.8333333333333 +k=0.9999");
    add_proj4text (p, 1,
		   " +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +unit");
    add_proj4text (p, 2, "s=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"JGD2000 / Japan Plane Rectangular CS X\",GEOGCS");
    add_srs_wkt (p, 1,
		 "[\"JGD2000\",DATUM[\"Japanese_Geodetic_Datum_2000\",SPHE");
    add_srs_wkt (p, 2,
		 "ROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
		 "\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
		 "\"6612\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
		 "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
		 "PSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4612\"]],PROJECTIO");
    add_srs_wkt (p, 7,
		 "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
		 "n\",40],PARAMETER[\"central_meridian\",140.8333333333333");
    add_srs_wkt (p, 9,
		 "],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"false_e");
    add_srs_wkt (p, 10,
		 "asting\",0],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 11,
		 "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXI");
    add_srs_wkt (p, 12, "S[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2452\"]]");
    p = add_epsg_def (filter, first, last, 2453, "epsg", 2453,
		      "JGD2000 / Japan Plane Rectangular CS XI");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=44 +lon_0=140.25 +k=0.9999 +x_0=0 +y_");
    add_proj4text (p, 1,
		   "0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 2, "s");
    add_srs_wkt (p, 0,
		 "PROJCS[\"JGD2000 / Japan Plane Rectangular CS XI\",GEOGC");
    add_srs_wkt (p, 1,
		 "S[\"JGD2000\",DATUM[\"Japanese_Geodetic_Datum_2000\",SPH");
    add_srs_wkt (p, 2,
		 "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
		 "G\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
		 ",\"6612\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
		 "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
		 "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4612\"]],PROJECTI");
    add_srs_wkt (p, 7,
		 "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
		 "in\",44],PARAMETER[\"central_meridian\",140.25],PARAMETE");
    add_srs_wkt (p, 9,
		 "R[\"scale_factor\",0.9999],PARAMETER[\"false_easting\",0");
    add_srs_wkt (p, 10,
		 "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 11,
		 "RITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EA");
    add_srs_wkt (p, 12, "ST],AUTHORITY[\"EPSG\",\"2453\"]]");
    p = add_epsg_def (filter, first, last, 2454, "epsg", 2454,
		      "JGD2000 / Japan Plane Rectangular CS XII");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=44 +lon_0=142.25 +k=0.9999 +x_0=0 +y_");
    add_proj4text (p, 1,
		   "0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 2, "s");
    add_srs_wkt (p, 0,
		 "PROJCS[\"JGD2000 / Japan Plane Rectangular CS XII\",GEOG");
    add_srs_wkt (p, 1,
		 "CS[\"JGD2000\",DATUM[\"Japanese_Geodetic_Datum_2000\",SP");
    add_srs_wkt (p, 2,
		 "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
		 "SG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
		 ",\"6612\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
		 "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
		 "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4612\"]],PROJECTI");
    add_srs_wkt (p, 7,
		 "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
		 "in\",44],PARAMETER[\"central_meridian\",142.25],PARAMETE");
    add_srs_wkt (p, 9,
		 "R[\"scale_factor\",0.9999],PARAMETER[\"false_easting\",0");
    add_srs_wkt (p, 10,
		 "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 11,
		 "RITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EA");
    add_srs_wkt (p, 12, "ST],AUTHORITY[\"EPSG\",\"2454\"]]");
    p = add_epsg_def (filter, first, last, 2455, "epsg", 2455,
		      "JGD2000 / Japan Plane Rectangular CS XIII");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=44 +lon_0=144.25 +k=0.9999 +x_0=0 +y_");
    add_proj4text (p, 1,
		   "0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 2, "s");
    add_srs_wkt (p, 0,
		 "PROJCS[\"JGD2000 / Japan Plane Rectangular CS XIII\",GEO");
    add_srs_wkt (p, 1,
		 "GCS[\"JGD2000\",DATUM[\"Japanese_Geodetic_Datum_2000\",S");
    add_srs_wkt (p, 2,
		 "PHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"E");
    add_srs_wkt (p, 3,
		 "PSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
		 "\",\"6612\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
		 "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 6,
		 "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4612\"]],PROJEC");
    add_srs_wkt (p, 7,
		 "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 8,
		 "igin\",44],PARAMETER[\"central_meridian\",144.25],PARAME");
    add_srs_wkt (p, 9,
		 "TER[\"scale_factor\",0.9999],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
		 ",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 11,
		 "HORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",");
    add_srs_wkt (p, 12, "EAST],AUTHORITY[\"EPSG\",\"2455\"]]");
    p = add_epsg_def (filter, first, last, 2456, "epsg", 2456,
		      "JGD2000 / Japan Plane Rectangular CS XIV");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=26 +lon_0=142 +k=0.9999 +x_0=0 +y_0=0");
    add_proj4text (p, 1,
		   " +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"JGD2000 / Japan Plane Rectangular CS XIV\",GEOG");
    add_srs_wkt (p, 1,
		 "CS[\"JGD2000\",DATUM[\"Japanese_Geodetic_Datum_2000\",SP");
    add_srs_wkt (p, 2,
		 "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
		 "SG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
		 ",\"6612\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
		 "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
		 "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4612\"]],PROJECTI");
    add_srs_wkt (p, 7,
		 "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
		 "in\",26],PARAMETER[\"central_meridian\",142],PARAMETER[\"");
    add_srs_wkt (p, 9,
		 "scale_factor\",0.9999],PARAMETER[\"false_easting\",0],PA");
    add_srs_wkt (p, 10,
		 "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
		 "[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],");
    add_srs_wkt (p, 12, "AUTHORITY[\"EPSG\",\"2456\"]]");
    p = add_epsg_def (filter, first, last, 2457, "epsg", 2457,
		      "JGD2000 / Japan Plane Rectangular CS XV");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=26 +lon_0=127.5 +k=0.9999 +x_0=0 +y_0");
    add_proj4text (p, 1,
		   "=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"JGD2000 / Japan Plane Rectangular CS XV\",GEOGC");
    add_srs_wkt (p, 1,
		 "S[\"JGD2000\",DATUM[\"Japanese_Geodetic_Datum_2000\",SPH");
    add_srs_wkt (p, 2,
		 "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
		 "G\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
		 ",\"6612\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
		 "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
		 "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4612\"]],PROJECTI");
    add_srs_wkt (p, 7,
		 "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
		 "in\",26],PARAMETER[\"central_meridian\",127.5],PARAMETER");
    add_srs_wkt (p, 9,
		 "[\"scale_factor\",0.9999],PARAMETER[\"false_easting\",0]");
    add_srs_wkt (p, 10,
		 ",PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 11,
		 "ITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAS");
    add_srs_wkt (p, 12, "T],AUTHORITY[\"EPSG\",\"2457\"]]");
    p = add_epsg_def (filter, first, last, 2458, "epsg", 2458,
		      "JGD2000 / Japan Plane Rectangular CS XVI");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=26 +lon_0=124 +k=0.9999 +x_0=0 +y_0=0");
    add_proj4text (p, 1,
		   " +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"JGD2000 / Japan Plane Rectangular CS XVI\",GEOG");
    add_srs_wkt (p, 1,
		 "CS[\"JGD2000\",DATUM[\"Japanese_Geodetic_Datum_2000\",SP");
    add_srs_wkt (p, 2,
		 "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
		 "SG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
		 ",\"6612\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
		 "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
		 "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4612\"]],PROJECTI");
    add_srs_wkt (p, 7,
		 "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
		 "in\",26],PARAMETER[\"central_meridian\",124],PARAMETER[\"");
    add_srs_wkt (p, 9,
		 "scale_factor\",0.9999],PARAMETER[\"false_easting\",0],PA");
    add_srs_wkt (p, 10,
		 "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
		 "[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],");
    add_srs_wkt (p, 12, "AUTHORITY[\"EPSG\",\"2458\"]]");
    p = add_epsg_def (filter, first, last, 2459, "epsg", 2459,
		      "JGD2000 / Japan Plane Rectangular CS XVII");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=26 +lon_0=131 +k=0.9999 +x_0=0 +y_0=0");
    add_proj4text (p, 1,
		   " +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"JGD2000 / Japan Plane Rectangular CS XVII\",GEO");
    add_srs_wkt (p, 1,
		 "GCS[\"JGD2000\",DATUM[\"Japanese_Geodetic_Datum_2000\",S");
    add_srs_wkt (p, 2,
		 "PHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"E");
    add_srs_wkt (p, 3,
		 "PSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
		 "\",\"6612\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
		 "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 6,
		 "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4612\"]],PROJEC");
    add_srs_wkt (p, 7,
		 "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 8,
		 "igin\",26],PARAMETER[\"central_meridian\",131],PARAMETER");
    add_srs_wkt (p, 9,
		 "[\"scale_factor\",0.9999],PARAMETER[\"false_easting\",0]");
    add_srs_wkt (p, 10,
		 ",PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 11,
		 "ITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAS");
    add_srs_wkt (p, 12, "T],AUTHORITY[\"EPSG\",\"2459\"]]");
    p = add_epsg_def (filter, first, last, 2460, "epsg", 2460,
		      "JGD2000 / Japan Plane Rectangular CS XVIII");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=20 +lon_0=136 +k=0.9999 +x_0=0 +y_0=0");
    add_proj4text (p, 1,
		   " +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"JGD2000 / Japan Plane Rectangular CS XVIII\",GE");
    add_srs_wkt (p, 1,
		 "OGCS[\"JGD2000\",DATUM[\"Japanese_Geodetic_Datum_2000\",");
    add_srs_wkt (p, 2,
		 "SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
		 "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
		 "G\",\"6612\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
		 ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
		 "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4612\"]],PROJE");
    add_srs_wkt (p, 7,
		 "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
		 "rigin\",20],PARAMETER[\"central_meridian\",136],PARAMETE");
    add_srs_wkt (p, 9,
		 "R[\"scale_factor\",0.9999],PARAMETER[\"false_easting\",0");
    add_srs_wkt (p, 10,
		 "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 11,
		 "RITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EA");
    add_srs_wkt (p, 12, "ST],AUTHORITY[\"EPSG\",\"2460\"]]");
    p = add_epsg_def (filter, first, last, 2461, "epsg", 2461,
		      "JGD2000 / Japan Plane Rectangular CS XIX");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=26 +lon_0=154 +k=0.9999 +x_0=0 +y_0=0");
    add_proj4text (p, 1,
		   " +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"JGD2000 / Japan Plane Rectangular CS XIX\",GEOG");
    add_srs_wkt (p, 1,
		 "CS[\"JGD2000\",DATUM[\"Japanese_Geodetic_Datum_2000\",SP");
    add_srs_wkt (p, 2,
		 "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
		 "SG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
		 ",\"6612\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
		 "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
		 "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4612\"]],PROJECTI");
    add_srs_wkt (p, 7,
		 "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
		 "in\",26],PARAMETER[\"central_meridian\",154],PARAMETER[\"");
    add_srs_wkt (p, 9,
		 "scale_factor\",0.9999],PARAMETER[\"false_easting\",0],PA");
    add_srs_wkt (p, 10,
		 "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
		 "[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],");
    add_srs_wkt (p, 12, "AUTHORITY[\"EPSG\",\"2461\"]]");
    p = add_epsg_def (filter, first, last, 2462, "epsg", 2462,
		      "Albanian 1987 / Gauss-Kruger zone 4");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=4500000 +y_0=0 ");
    add_proj4text (p, 1, "+ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Albanian 1987 / Gauss-Kruger zone 4\",GEOGCS[\"");
    add_srs_wkt (p, 1,
		 "Albanian 1987\",DATUM[\"Albanian_1987\",SPHEROID[\"Krass");
    add_srs_wkt (p, 2,
		 "owsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]]");
    add_srs_wkt (p, 3,
		 ",AUTHORITY[\"EPSG\",\"6191\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
		 "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
		 "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
		 "\"4191\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
		 "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
		 ",21],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eas");
    add_srs_wkt (p, 9,
		 "ting\",4500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 10,
		 "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH]");
    add_srs_wkt (p, 11, ",AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2462\"]]");
    p = add_epsg_def (filter, first, last, 2463, "epsg", 2463,
		      "Pulkovo 1995 / Gauss-Kruger CM 21E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
		   "ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.");
    add_proj4text (p, 2, "22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 21E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
		 "ulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
		 "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 3,
		 "WGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
		 "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
		 "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
		 "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],PR");
    add_srs_wkt (p, 7,
		 "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
		 "f_origin\",0],PARAMETER[\"central_meridian\",21],PARAMET");
    add_srs_wkt (p, 9,
		 "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
		 "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
		 "ORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",E");
    add_srs_wkt (p, 12, "AST],AUTHORITY[\"EPSG\",\"2463\"]]");
    p = add_epsg_def (filter, first, last, 2464, "epsg", 2464,
		      "Pulkovo 1995 / Gauss-Kruger CM 27E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
		   "ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.");
    add_proj4text (p, 2, "22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 27E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
		 "ulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
		 "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 3,
		 "WGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
		 "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
		 "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
		 "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],PR");
    add_srs_wkt (p, 7,
		 "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
		 "f_origin\",0],PARAMETER[\"central_meridian\",27],PARAMET");
    add_srs_wkt (p, 9,
		 "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
		 "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
		 "ORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",E");
    add_srs_wkt (p, 12, "AST],AUTHORITY[\"EPSG\",\"2464\"]]");
    p = add_epsg_def (filter, first, last, 2465, "epsg", 2465,
		      "Pulkovo 1995 / Gauss-Kruger CM 33E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
		   "ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.");
    add_proj4text (p, 2, "22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 33E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
		 "ulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
		 "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 3,
		 "WGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
		 "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
		 "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
		 "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],PR");
    add_srs_wkt (p, 7,
		 "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
		 "f_origin\",0],PARAMETER[\"central_meridian\",33],PARAMET");
    add_srs_wkt (p, 9,
		 "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
		 "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
		 "ORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",E");
    add_srs_wkt (p, 12, "AST],AUTHORITY[\"EPSG\",\"2465\"]]");
    p = add_epsg_def (filter, first, last, 2466, "epsg", 2466,
		      "Pulkovo 1995 / Gauss-Kruger CM 39E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
		   "ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.");
    add_proj4text (p, 2, "22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 39E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
		 "ulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
		 "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 3,
		 "WGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
		 "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
		 "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
		 "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],PR");
    add_srs_wkt (p, 7,
		 "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
		 "f_origin\",0],PARAMETER[\"central_meridian\",39],PARAMET");
    add_srs_wkt (p, 9,
		 "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
		 "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
		 "ORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",E");
    add_srs_wkt (p, 12, "AST],AUTHORITY[\"EPSG\",\"2466\"]]");
    p = add_epsg_def (filter, first, last, 2467, "epsg", 2467,
		      "Pulkovo 1995 / Gauss-Kruger CM 45E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
		   "ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.");
    add_proj4text (p, 2, "22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 45E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
		 "ulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
		 "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 3,
		 "WGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
		 "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
		 "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
		 "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],PR");
    add_srs_wkt (p, 7,
		 "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
		 "f_origin\",0],PARAMETER[\"central_meridian\",45],PARAMET");
    add_srs_wkt (p, 9,
		 "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
		 "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
		 "ORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",E");
    add_srs_wkt (p, 12, "AST],AUTHORITY[\"EPSG\",\"2467\"]]");
    p = add_epsg_def (filter, first, last, 2468, "epsg", 2468,
		      "Pulkovo 1995 / Gauss-Kruger CM 51E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=51 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
		   "ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.");
    add_proj4text (p, 2, "22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 51E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
		 "ulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
		 "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 3,
		 "WGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
		 "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
		 "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
		 "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],PR");
    add_srs_wkt (p, 7,
		 "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
		 "f_origin\",0],PARAMETER[\"central_meridian\",51],PARAMET");
    add_srs_wkt (p, 9,
		 "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
		 "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
		 "ORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",E");
    add_srs_wkt (p, 12, "AST],AUTHORITY[\"EPSG\",\"2468\"]]");
    p = add_epsg_def (filter, first, last, 2469, "epsg", 2469,
		      "Pulkovo 1995 / Gauss-Kruger CM 57E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=57 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
		   "ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.");
    add_proj4text (p, 2, "22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 57E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
		 "ulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
		 "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 3,
		 "WGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
		 "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
		 "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
		 "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],PR");
    add_srs_wkt (p, 7,
		 "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
		 "f_origin\",0],PARAMETER[\"central_meridian\",57],PARAMET");
    add_srs_wkt (p, 9,
		 "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
		 "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
		 "ORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",E");
    add_srs_wkt (p, 12, "AST],AUTHORITY[\"EPSG\",\"2469\"]]");
    p = add_epsg_def (filter, first, last, 2470, "epsg", 2470,
		      "Pulkovo 1995 / Gauss-Kruger CM 63E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=63 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
		   "ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.");
    add_proj4text (p, 2, "22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 63E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
		 "ulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
		 "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 3,
		 "WGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
		 "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
		 "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
		 "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],PR");
    add_srs_wkt (p, 7,
		 "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
		 "f_origin\",0],PARAMETER[\"central_meridian\",63],PARAMET");
    add_srs_wkt (p, 9,
		 "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
		 "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
		 "ORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",E");
    add_srs_wkt (p, 12, "AST],AUTHORITY[\"EPSG\",\"2470\"]]");
    p = add_epsg_def (filter, first, last, 2471, "epsg", 2471,
		      "Pulkovo 1995 / Gauss-Kruger CM 69E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=69 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
		   "ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.");
    add_proj4text (p, 2, "22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 69E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
		 "ulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
		 "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 3,
		 "WGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
		 "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
		 "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
		 "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],PR");
    add_srs_wkt (p, 7,
		 "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
		 "f_origin\",0],PARAMETER[\"central_meridian\",69],PARAMET");
    add_srs_wkt (p, 9,
		 "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
		 "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
		 "ORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",E");
    add_srs_wkt (p, 12, "AST],AUTHORITY[\"EPSG\",\"2471\"]]");
    p = add_epsg_def (filter, first, last, 2472, "epsg", 2472,
		      "Pulkovo 1995 / Gauss-Kruger CM 75E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
		   "ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.");
    add_proj4text (p, 2, "22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 75E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
		 "ulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
		 "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 3,
		 "WGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
		 "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
		 "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
		 "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],PR");
    add_srs_wkt (p, 7,
		 "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
		 "f_origin\",0],PARAMETER[\"central_meridian\",75],PARAMET");
    add_srs_wkt (p, 9,
		 "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
		 "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
		 "ORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",E");
    add_srs_wkt (p, 12, "AST],AUTHORITY[\"EPSG\",\"2472\"]]");
    p = add_epsg_def (filter, first, last, 2473, "epsg", 2473,
		      "Pulkovo 1995 / Gauss-Kruger CM 81E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
		   "ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.");
    add_proj4text (p, 2, "22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 81E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
		 "ulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
		 "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 3,
		 "WGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
		 "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
		 "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
		 "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],PR");
    add_srs_wkt (p, 7,
		 "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
		 "f_origin\",0],PARAMETER[\"central_meridian\",81],PARAMET");
    add_srs_wkt (p, 9,
		 "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
		 "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
		 "ORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",E");
    add_srs_wkt (p, 12, "AST],AUTHORITY[\"EPSG\",\"2473\"]]");
    p = add_epsg_def (filter, first, last, 2474, "epsg", 2474,
		      "Pulkovo 1995 / Gauss-Kruger CM 87E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
		   "ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.");
    add_proj4text (p, 2, "22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 87E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
		 "ulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
		 "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 3,
		 "WGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
		 "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
		 "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
		 "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],PR");
    add_srs_wkt (p, 7,
		 "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
		 "f_origin\",0],PARAMETER[\"central_meridian\",87],PARAMET");
    add_srs_wkt (p, 9,
		 "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
		 "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
		 "ORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",E");
    add_srs_wkt (p, 12, "AST],AUTHORITY[\"EPSG\",\"2474\"]]");
    p = add_epsg_def (filter, first, last, 2475, "epsg", 2475,
		      "Pulkovo 1995 / Gauss-Kruger CM 93E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
		   "ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.");
    add_proj4text (p, 2, "22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 93E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
		 "ulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
		 "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 3,
		 "WGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
		 "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
		 "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
		 "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],PR");
    add_srs_wkt (p, 7,
		 "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
		 "f_origin\",0],PARAMETER[\"central_meridian\",93],PARAMET");
    add_srs_wkt (p, 9,
		 "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
		 "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
		 "ORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",E");
    add_srs_wkt (p, 12, "AST],AUTHORITY[\"EPSG\",\"2475\"]]");
    p = add_epsg_def (filter, first, last, 2476, "epsg", 2476,
		      "Pulkovo 1995 / Gauss-Kruger CM 99E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
		   "ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.");
    add_proj4text (p, 2, "22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 99E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
		 "ulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
		 "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 3,
		 "WGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
		 "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
		 "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
		 "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],PR");
    add_srs_wkt (p, 7,
		 "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
		 "f_origin\",0],PARAMETER[\"central_meridian\",99],PARAMET");
    add_srs_wkt (p, 9,
		 "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
		 "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
		 "ORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",E");
    add_srs_wkt (p, 12, "AST],AUTHORITY[\"EPSG\",\"2476\"]]");
    p = add_epsg_def (filter, first, last, 2477, "epsg", 2477,
		      "Pulkovo 1995 / Gauss-Kruger CM 105E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
		   "+ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0");
    add_proj4text (p, 2, ".22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 105E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
		 "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
		 "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
		 "OWGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],AUTHORITY[");
    add_srs_wkt (p, 4,
		 "\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
		 "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
		 "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],");
    add_srs_wkt (p, 7,
		 "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
		 "_of_origin\",0],PARAMETER[\"central_meridian\",105],PARA");
    add_srs_wkt (p, 9,
		 "METER[\"scale_factor\",1],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 10,
		 "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
		 "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 12, ",EAST],AUTHORITY[\"EPSG\",\"2477\"]]");
    p = add_epsg_def (filter, first, last, 2478, "epsg", 2478,
		      "Pulkovo 1995 / Gauss-Kruger CM 111E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
		   "+ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0");
    add_proj4text (p, 2, ".22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 111E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
		 "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
		 "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
		 "OWGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],AUTHORITY[");
    add_srs_wkt (p, 4,
		 "\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
		 "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
		 "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],");
    add_srs_wkt (p, 7,
		 "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
		 "_of_origin\",0],PARAMETER[\"central_meridian\",111],PARA");
    add_srs_wkt (p, 9,
		 "METER[\"scale_factor\",1],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 10,
		 "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
		 "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 12, ",EAST],AUTHORITY[\"EPSG\",\"2478\"]]");
    p = add_epsg_def (filter, first, last, 2479, "epsg", 2479,
		      "Pulkovo 1995 / Gauss-Kruger CM 117E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
		   "+ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0");
    add_proj4text (p, 2, ".22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 117E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
		 "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
		 "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
		 "OWGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],AUTHORITY[");
    add_srs_wkt (p, 4,
		 "\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
		 "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
		 "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],");
    add_srs_wkt (p, 7,
		 "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
		 "_of_origin\",0],PARAMETER[\"central_meridian\",117],PARA");
    add_srs_wkt (p, 9,
		 "METER[\"scale_factor\",1],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 10,
		 "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
		 "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 12, ",EAST],AUTHORITY[\"EPSG\",\"2479\"]]");
    p = add_epsg_def (filter, first, last, 2480, "epsg", 2480,
		      "Pulkovo 1995 / Gauss-Kruger CM 123E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
		   "+ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0");
    add_proj4text (p, 2, ".22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 123E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
		 "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
		 "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
		 "OWGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],AUTHORITY[");
    add_srs_wkt (p, 4,
		 "\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
		 "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
		 "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],");
    add_srs_wkt (p, 7,
		 "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
		 "_of_origin\",0],PARAMETER[\"central_meridian\",123],PARA");
    add_srs_wkt (p, 9,
		 "METER[\"scale_factor\",1],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 10,
		 "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
		 "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 12, ",EAST],AUTHORITY[\"EPSG\",\"2480\"]]");
    p = add_epsg_def (filter, first, last, 2481, "epsg", 2481,
		      "Pulkovo 1995 / Gauss-Kruger CM 129E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
		   "+ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0");
    add_proj4text (p, 2, ".22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 129E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
		 "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
		 "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
		 "OWGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],AUTHORITY[");
    add_srs_wkt (p, 4,
		 "\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
		 "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
		 "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],");
    add_srs_wkt (p, 7,
		 "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
		 "_of_origin\",0],PARAMETER[\"central_meridian\",129],PARA");
    add_srs_wkt (p, 9,
		 "METER[\"scale_factor\",1],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 10,
		 "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
		 "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 12, ",EAST],AUTHORITY[\"EPSG\",\"2481\"]]");
    p = add_epsg_def (filter, first, last, 2482, "epsg", 2482,
		      "Pulkovo 1995 / Gauss-Kruger CM 135E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
		   "+ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0");
    add_proj4text (p, 2, ".22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 135E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
		 "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
		 "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
		 "OWGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],AUTHORITY[");
    add_srs_wkt (p, 4,
		 "\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
		 "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
		 "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],");
    add_srs_wkt (p, 7,
		 "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
		 "_of_origin\",0],PARAMETER[\"central_meridian\",135],PARA");
    add_srs_wkt (p, 9,
		 "METER[\"scale_factor\",1],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 10,
		 "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
		 "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 12, ",EAST],AUTHORITY[\"EPSG\",\"2482\"]]");
    p = add_epsg_def (filter, first, last, 2483, "epsg", 2483,
		      "Pulkovo 1995 / Gauss-Kruger CM 141E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=141 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
		   "+ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0");
    add_proj4text (p, 2, ".22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 141E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
		 "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
		 "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
		 "OWGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],AUTHORITY[");
    add_srs_wkt (p, 4,
		 "\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
		 "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
		 "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],");
    add_srs_wkt (p, 7,
		 "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
		 "_of_origin\",0],PARAMETER[\"central_meridian\",141],PARA");
    add_srs_wkt (p, 9,
		 "METER[\"scale_factor\",1],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 10,
		 "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
		 "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 12, ",EAST],AUTHORITY[\"EPSG\",\"2483\"]]");
    p = add_epsg_def (filter, first, last, 2484, "epsg", 2484,
		      "Pulkovo 1995 / Gauss-Kruger CM 147E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=147 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
		   "+ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0");
    add_proj4text (p, 2, ".22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 147E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
		 "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
		 "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
		 "OWGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],AUTHORITY[");
    add_srs_wkt (p, 4,
		 "\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
		 "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
		 "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],");
    add_srs_wkt (p, 7,
		 "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
		 "_of_origin\",0],PARAMETER[\"central_meridian\",147],PARA");
    add_srs_wkt (p, 9,
		 "METER[\"scale_factor\",1],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 10,
		 "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
		 "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 12, ",EAST],AUTHORITY[\"EPSG\",\"2484\"]]");
    p = add_epsg_def (filter, first, last, 2485, "epsg", 2485,
		      "Pulkovo 1995 / Gauss-Kruger CM 153E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=153 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
		   "+ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0");
    add_proj4text (p, 2, ".22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 153E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
		 "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
		 "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
		 "OWGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],AUTHORITY[");
    add_srs_wkt (p, 4,
		 "\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
		 "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
		 "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],");
    add_srs_wkt (p, 7,
		 "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
		 "_of_origin\",0],PARAMETER[\"central_meridian\",153],PARA");
    add_srs_wkt (p, 9,
		 "METER[\"scale_factor\",1],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 10,
		 "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
		 "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 12, ",EAST],AUTHORITY[\"EPSG\",\"2485\"]]");
    p = add_epsg_def (filter, first, last, 2486, "epsg", 2486,
		      "Pulkovo 1995 / Gauss-Kruger CM 159E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=159 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
		   "+ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0");
    add_proj4text (p, 2, ".22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 159E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
		 "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
		 "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
		 "OWGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],AUTHORITY[");
    add_srs_wkt (p, 4,
		 "\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
		 "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
		 "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],");
    add_srs_wkt (p, 7,
		 "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
		 "_of_origin\",0],PARAMETER[\"central_meridian\",159],PARA");
    add_srs_wkt (p, 9,
		 "METER[\"scale_factor\",1],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 10,
		 "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
		 "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 12, ",EAST],AUTHORITY[\"EPSG\",\"2486\"]]");
    p = add_epsg_def (filter, first, last, 2487, "epsg", 2487,
		      "Pulkovo 1995 / Gauss-Kruger CM 165E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=165 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
		   "+ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0");
    add_proj4text (p, 2, ".22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 165E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
		 "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
		 "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
		 "OWGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],AUTHORITY[");
    add_srs_wkt (p, 4,
		 "\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
		 "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
		 "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],");
    add_srs_wkt (p, 7,
		 "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
		 "_of_origin\",0],PARAMETER[\"central_meridian\",165],PARA");
    add_srs_wkt (p, 9,
		 "METER[\"scale_factor\",1],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 10,
		 "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
		 "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 12, ",EAST],AUTHORITY[\"EPSG\",\"2487\"]]");
    p = add_epsg_def (filter, first, last, 2488, "epsg", 2488,
		      "Pulkovo 1995 / Gauss-Kruger CM 171E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=171 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
		   "+ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0");
    add_proj4text (p, 2, ".22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 171E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
		 "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
		 "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
		 "OWGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],AUTHORITY[");
    add_srs_wkt (p, 4,
		 "\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
		 "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
		 "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],");
    add_srs_wkt (p, 7,
		 "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
		 "_of_origin\",0],PARAMETER[\"central_meridian\",171],PARA");
    add_srs_wkt (p, 9,
		 "METER[\"scale_factor\",1],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 10,
		 "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
		 "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 12, ",EAST],AUTHORITY[\"EPSG\",\"2488\"]]");
    p = add_epsg_def (filter, first, last, 2489, "epsg", 2489,
		      "Pulkovo 1995 / Gauss-Kruger CM 177E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=177 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
		   "+ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0");
    add_proj4text (p, 2, ".22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 177E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
		 "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
		 "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
		 "OWGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],AUTHORITY[");
    add_srs_wkt (p, 4,
		 "\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
		 "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
		 "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],");
    add_srs_wkt (p, 7,
		 "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
		 "_of_origin\",0],PARAMETER[\"central_meridian\",177],PARA");
    add_srs_wkt (p, 9,
		 "METER[\"scale_factor\",1],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 10,
		 "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
		 "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 12, ",EAST],AUTHORITY[\"EPSG\",\"2489\"]]");
    p = add_epsg_def (filter, first, last, 2490, "epsg", 2490,
		      "Pulkovo 1995 / Gauss-Kruger CM 177W");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=-177 +k=1 +x_0=500000 +y_0=0");
    add_proj4text (p, 1,
		   " +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-");
    add_proj4text (p, 2, "0.22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 177W\",GEOGCS[\"");
    add_srs_wkt (p, 1,
		 "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
		 "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
		 "OWGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],AUTHORITY[");
    add_srs_wkt (p, 4,
		 "\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
		 "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
		 "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],");
    add_srs_wkt (p, 7,
		 "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
		 "_of_origin\",0],PARAMETER[\"central_meridian\",-177],PAR");
    add_srs_wkt (p, 9,
		 "AMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",5");
    add_srs_wkt (p, 10,
		 "00000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 11,
		 "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y");
    add_srs_wkt (p, 12, "\",EAST],AUTHORITY[\"EPSG\",\"2490\"]]");
    p = add_epsg_def (filter, first, last, 2491, "epsg", 2491,
		      "Pulkovo 1995 / Gauss-Kruger CM 171W");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=-171 +k=1 +x_0=500000 +y_0=0");
    add_proj4text (p, 1,
		   " +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-");
    add_proj4text (p, 2, "0.22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 171W\",GEOGCS[\"");
    add_srs_wkt (p, 1,
		 "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
		 "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
		 "OWGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],AUTHORITY[");
    add_srs_wkt (p, 4,
		 "\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
		 "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
		 "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],");
    add_srs_wkt (p, 7,
		 "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
		 "_of_origin\",0],PARAMETER[\"central_meridian\",-171],PAR");
    add_srs_wkt (p, 9,
		 "AMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",5");
    add_srs_wkt (p, 10,
		 "00000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 11,
		 "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y");
    add_srs_wkt (p, 12, "\",EAST],AUTHORITY[\"EPSG\",\"2491\"]]");
    p = add_epsg_def (filter, first, last, 2492, "epsg", 2492,
		      "Pulkovo 1942 / Gauss-Kruger CM 9E (deprecated)");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=9 +k=1 +x_0=500000 +y_0=0 +e");
    add_proj4text (p, 1,
		   "llps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.");
    add_proj4text (p, 2, "12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 9E (deprecated)\"");
    add_srs_wkt (p, 1,
		 ",GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID");
    add_srs_wkt (p, 2,
		 "[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
		 "7024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12]");
    add_srs_wkt (p, 4,
		 ",AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
		 "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
		 "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
		 "\"4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 8,
		 "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
		 ",9],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
		 "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 11,
		 "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],A");
    add_srs_wkt (p, 12, "XIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2492\"]]");
    p = add_epsg_def (filter, first, last, 2493, "epsg", 2493,
		      "Pulkovo 1942 / Gauss-Kruger CM 15E (deprecated)");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
		   "ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0");
    add_proj4text (p, 2, ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 15E (deprecated)");
    add_srs_wkt (p, 1,
		 "\",GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHERO");
    add_srs_wkt (p, 2,
		 "ID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
		 "\"7024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.1");
    add_srs_wkt (p, 4,
		 "2],AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 5,
		 "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 6,
		 "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
		 ",\"4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 8,
		 "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 9,
		 "\",15],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_e");
    add_srs_wkt (p, 10,
		 "asting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 11,
		 "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH");
    add_srs_wkt (p, 12, "],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2493\"]]");
    p = add_epsg_def (filter, first, last, 2494, "epsg", 2494,
		      "Pulkovo 1942 / Gauss-Kruger CM 21E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
		   "ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0");
    add_proj4text (p, 2, ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 21E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
		 "ulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
		 "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 3,
		 "WGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AUTHORITY[");
    add_srs_wkt (p, 4,
		 "\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
		 "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
		 "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]],");
    add_srs_wkt (p, 7,
		 "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
		 "_of_origin\",0],PARAMETER[\"central_meridian\",21],PARAM");
    add_srs_wkt (p, 9,
		 "ETER[\"scale_factor\",1],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 10,
		 "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
		 "THORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 12, ",EAST],AUTHORITY[\"EPSG\",\"2494\"]]");
    p = add_epsg_def (filter, first, last, 2495, "epsg", 2495,
		      "Pulkovo 1942 / Gauss-Kruger CM 27E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
		   "ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0");
    add_proj4text (p, 2, ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 27E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
		 "ulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
		 "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 3,
		 "WGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AUTHORITY[");
    add_srs_wkt (p, 4,
		 "\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
		 "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
		 "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]],");
    add_srs_wkt (p, 7,
		 "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
		 "_of_origin\",0],PARAMETER[\"central_meridian\",27],PARAM");
    add_srs_wkt (p, 9,
		 "ETER[\"scale_factor\",1],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 10,
		 "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
		 "THORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 12, ",EAST],AUTHORITY[\"EPSG\",\"2495\"]]");
    p = add_epsg_def (filter, first, last, 2496, "epsg", 2496,
		      "Pulkovo 1942 / Gauss-Kruger CM 33E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
		   "ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0");
    add_proj4text (p, 2, ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 33E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
		 "ulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
		 "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 3,
		 "WGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AUTHORITY[");
    add_srs_wkt (p, 4,
		 "\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
		 "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
		 "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]],");
    add_srs_wkt (p, 7,
		 "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
		 "_of_origin\",0],PARAMETER[\"central_meridian\",33],PARAM");
    add_srs_wkt (p, 9,
		 "ETER[\"scale_factor\",1],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 10,
		 "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
		 "THORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 12, ",EAST],AUTHORITY[\"EPSG\",\"2496\"]]");
    p = add_epsg_def (filter, first, last, 2497, "epsg", 2497,
		      "Pulkovo 1942 / Gauss-Kruger CM 39E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
		   "ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0");
    add_proj4text (p, 2, ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 39E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
		 "ulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
		 "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 3,
		 "WGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AUTHORITY[");
    add_srs_wkt (p, 4,
		 "\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
		 "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
		 "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]],");
    add_srs_wkt (p, 7,
		 "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
		 "_of_origin\",0],PARAMETER[\"central_meridian\",39],PARAM");
    add_srs_wkt (p, 9,
		 "ETER[\"scale_factor\",1],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 10,
		 "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
		 "THORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 12, ",EAST],AUTHORITY[\"EPSG\",\"2497\"]]");
    p = add_epsg_def (filter, first, last, 2498, "epsg", 2498,
		      "Pulkovo 1942 / Gauss-Kruger CM 45E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
		   "ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0");
    add_proj4text (p, 2, ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 45E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
		 "ulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
		 "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 3,
		 "WGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AUTHORITY[");
    add_srs_wkt (p, 4,
		 "\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
		 "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
		 "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]],");
    add_srs_wkt (p, 7,
		 "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
		 "_of_origin\",0],PARAMETER[\"central_meridian\",45],PARAM");
    add_srs_wkt (p, 9,
		 "ETER[\"scale_factor\",1],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 10,
		 "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
		 "THORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 12, ",EAST],AUTHORITY[\"EPSG\",\"2498\"]]");
    p = add_epsg_def (filter, first, last, 2499, "epsg", 2499,
		      "Pulkovo 1942 / Gauss-Kruger CM 51E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=51 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
		   "ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0");
    add_proj4text (p, 2, ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 51E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
		 "ulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
		 "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 3,
		 "WGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AUTHORITY[");
    add_srs_wkt (p, 4,
		 "\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
		 "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
		 "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]],");
    add_srs_wkt (p, 7,
		 "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
		 "_of_origin\",0],PARAMETER[\"central_meridian\",51],PARAM");
    add_srs_wkt (p, 9,
		 "ETER[\"scale_factor\",1],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 10,
		 "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
		 "THORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 12, ",EAST],AUTHORITY[\"EPSG\",\"2499\"]]");
    p = add_epsg_def (filter, first, last, 2500, "epsg", 2500,
		      "Pulkovo 1942 / Gauss-Kruger CM 57E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=57 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
		   "ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0");
    add_proj4text (p, 2, ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 57E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
		 "ulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
		 "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 3,
		 "WGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AUTHORITY[");
    add_srs_wkt (p, 4,
		 "\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
		 "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
		 "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]],");
    add_srs_wkt (p, 7,
		 "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
		 "_of_origin\",0],PARAMETER[\"central_meridian\",57],PARAM");
    add_srs_wkt (p, 9,
		 "ETER[\"scale_factor\",1],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 10,
		 "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
		 "THORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 12, ",EAST],AUTHORITY[\"EPSG\",\"2500\"]]");
    p = add_epsg_def (filter, first, last, 2501, "epsg", 2501,
		      "Pulkovo 1942 / Gauss-Kruger CM 63E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=63 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
		   "ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0");
    add_proj4text (p, 2, ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 63E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
		 "ulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
		 "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 3,
		 "WGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AUTHORITY[");
    add_srs_wkt (p, 4,
		 "\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
		 "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
		 "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]],");
    add_srs_wkt (p, 7,
		 "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
		 "_of_origin\",0],PARAMETER[\"central_meridian\",63],PARAM");
    add_srs_wkt (p, 9,
		 "ETER[\"scale_factor\",1],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 10,
		 "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
		 "THORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 12, ",EAST],AUTHORITY[\"EPSG\",\"2501\"]]");
    p = add_epsg_def (filter, first, last, 2502, "epsg", 2502,
		      "Pulkovo 1942 / Gauss-Kruger CM 69E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=69 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
		   "ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0");
    add_proj4text (p, 2, ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 69E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
		 "ulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
		 "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 3,
		 "WGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AUTHORITY[");
    add_srs_wkt (p, 4,
		 "\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
		 "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
		 "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]],");
    add_srs_wkt (p, 7,
		 "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
		 "_of_origin\",0],PARAMETER[\"central_meridian\",69],PARAM");
    add_srs_wkt (p, 9,
		 "ETER[\"scale_factor\",1],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 10,
		 "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
		 "THORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 12, ",EAST],AUTHORITY[\"EPSG\",\"2502\"]]");
    p = add_epsg_def (filter, first, last, 2503, "epsg", 2503,
		      "Pulkovo 1942 / Gauss-Kruger CM 75E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
		   "ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0");
    add_proj4text (p, 2, ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 75E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
		 "ulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
		 "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 3,
		 "WGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AUTHORITY[");
    add_srs_wkt (p, 4,
		 "\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
		 "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
		 "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]],");
    add_srs_wkt (p, 7,
		 "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
		 "_of_origin\",0],PARAMETER[\"central_meridian\",75],PARAM");
    add_srs_wkt (p, 9,
		 "ETER[\"scale_factor\",1],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 10,
		 "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
		 "THORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 12, ",EAST],AUTHORITY[\"EPSG\",\"2503\"]]");
    p = add_epsg_def (filter, first, last, 2504, "epsg", 2504,
		      "Pulkovo 1942 / Gauss-Kruger CM 81E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
		   "ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0");
    add_proj4text (p, 2, ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 81E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
		 "ulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
		 "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 3,
		 "WGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AUTHORITY[");
    add_srs_wkt (p, 4,
		 "\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
		 "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
		 "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]],");
    add_srs_wkt (p, 7,
		 "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
		 "_of_origin\",0],PARAMETER[\"central_meridian\",81],PARAM");
    add_srs_wkt (p, 9,
		 "ETER[\"scale_factor\",1],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 10,
		 "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
		 "THORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 12, ",EAST],AUTHORITY[\"EPSG\",\"2504\"]]");
    p = add_epsg_def (filter, first, last, 2505, "epsg", 2505,
		      "Pulkovo 1942 / Gauss-Kruger CM 87E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
		   "ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0");
    add_proj4text (p, 2, ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 87E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
		 "ulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
		 "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 3,
		 "WGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AUTHORITY[");
    add_srs_wkt (p, 4,
		 "\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
		 "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
		 "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]],");
    add_srs_wkt (p, 7,
		 "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
		 "_of_origin\",0],PARAMETER[\"central_meridian\",87],PARAM");
    add_srs_wkt (p, 9,
		 "ETER[\"scale_factor\",1],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 10,
		 "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
		 "THORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 12, ",EAST],AUTHORITY[\"EPSG\",\"2505\"]]");
    p = add_epsg_def (filter, first, last, 2506, "epsg", 2506,
		      "Pulkovo 1942 / Gauss-Kruger CM 93E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
		   "ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0");
    add_proj4text (p, 2, ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 93E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
		 "ulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
		 "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 3,
		 "WGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AUTHORITY[");
    add_srs_wkt (p, 4,
		 "\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
		 "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
		 "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]],");
    add_srs_wkt (p, 7,
		 "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
		 "_of_origin\",0],PARAMETER[\"central_meridian\",93],PARAM");
    add_srs_wkt (p, 9,
		 "ETER[\"scale_factor\",1],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 10,
		 "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
		 "THORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 12, ",EAST],AUTHORITY[\"EPSG\",\"2506\"]]");
    p = add_epsg_def (filter, first, last, 2507, "epsg", 2507,
		      "Pulkovo 1942 / Gauss-Kruger CM 99E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
		   "ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0");
    add_proj4text (p, 2, ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 99E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
		 "ulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
		 "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 3,
		 "WGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AUTHORITY[");
    add_srs_wkt (p, 4,
		 "\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
		 "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
		 "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]],");
    add_srs_wkt (p, 7,
		 "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
		 "_of_origin\",0],PARAMETER[\"central_meridian\",99],PARAM");
    add_srs_wkt (p, 9,
		 "ETER[\"scale_factor\",1],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 10,
		 "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
		 "THORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 12, ",EAST],AUTHORITY[\"EPSG\",\"2507\"]]");
    p = add_epsg_def (filter, first, last, 2508, "epsg", 2508,
		      "Pulkovo 1942 / Gauss-Kruger CM 105E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
		   "+ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-");
    add_proj4text (p, 2, "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 105E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
		 "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
		 "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
		 "OWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AUTHORITY");
    add_srs_wkt (p, 4,
		 "[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
		 "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
		 "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]]");
    add_srs_wkt (p, 7,
		 ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
		 "e_of_origin\",0],PARAMETER[\"central_meridian\",105],PAR");
    add_srs_wkt (p, 9,
		 "AMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",5");
    add_srs_wkt (p, 10,
		 "00000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 11,
		 "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y");
    add_srs_wkt (p, 12, "\",EAST],AUTHORITY[\"EPSG\",\"2508\"]]");
    p = add_epsg_def (filter, first, last, 2509, "epsg", 2509,
		      "Pulkovo 1942 / Gauss-Kruger CM 111E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
		   "+ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-");
    add_proj4text (p, 2, "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 111E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
		 "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
		 "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
		 "OWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AUTHORITY");
    add_srs_wkt (p, 4,
		 "[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
		 "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
		 "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]]");
    add_srs_wkt (p, 7,
		 ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
		 "e_of_origin\",0],PARAMETER[\"central_meridian\",111],PAR");
    add_srs_wkt (p, 9,
		 "AMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",5");
    add_srs_wkt (p, 10,
		 "00000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 11,
		 "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y");
    add_srs_wkt (p, 12, "\",EAST],AUTHORITY[\"EPSG\",\"2509\"]]");
    p = add_epsg_def (filter, first, last, 2510, "epsg", 2510,
		      "Pulkovo 1942 / Gauss-Kruger CM 117E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
		   "+ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-");
    add_proj4text (p, 2, "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 117E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
		 "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
		 "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
		 "OWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AUTHORITY");
    add_srs_wkt (p, 4,
		 "[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
		 "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
		 "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]]");
    add_srs_wkt (p, 7,
		 ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
		 "e_of_origin\",0],PARAMETER[\"central_meridian\",117],PAR");
    add_srs_wkt (p, 9,
		 "AMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",5");
    add_srs_wkt (p, 10,
		 "00000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 11,
		 "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y");
    add_srs_wkt (p, 12, "\",EAST],AUTHORITY[\"EPSG\",\"2510\"]]");
    p = add_epsg_def (filter, first, last, 2511, "epsg", 2511,
		      "Pulkovo 1942 / Gauss-Kruger CM 123E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
		   "+ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-");
    add_proj4text (p, 2, "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 123E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
		 "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
		 "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
		 "OWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AUTHORITY");
    add_srs_wkt (p, 4,
		 "[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
		 "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
		 "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]]");
    add_srs_wkt (p, 7,
		 ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
		 "e_of_origin\",0],PARAMETER[\"central_meridian\",123],PAR");
    add_srs_wkt (p, 9,
		 "AMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",5");
    add_srs_wkt (p, 10,
		 "00000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 11,
		 "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y");
    add_srs_wkt (p, 12, "\",EAST],AUTHORITY[\"EPSG\",\"2511\"]]");
    p = add_epsg_def (filter, first, last, 2512, "epsg", 2512,
		      "Pulkovo 1942 / Gauss-Kruger CM 129E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
		   "+ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-");
    add_proj4text (p, 2, "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 129E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
		 "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
		 "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
		 "OWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AUTHORITY");
    add_srs_wkt (p, 4,
		 "[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
		 "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
		 "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]]");
    add_srs_wkt (p, 7,
		 ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
		 "e_of_origin\",0],PARAMETER[\"central_meridian\",129],PAR");
    add_srs_wkt (p, 9,
		 "AMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",5");
    add_srs_wkt (p, 10,
		 "00000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 11,
		 "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y");
    add_srs_wkt (p, 12, "\",EAST],AUTHORITY[\"EPSG\",\"2512\"]]");
    p = add_epsg_def (filter, first, last, 2513, "epsg", 2513,
		      "Pulkovo 1942 / Gauss-Kruger CM 135E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
		   "+ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-");
    add_proj4text (p, 2, "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 135E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
		 "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
		 "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
		 "OWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AUTHORITY");
    add_srs_wkt (p, 4,
		 "[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
		 "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
		 "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]]");
    add_srs_wkt (p, 7,
		 ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
		 "e_of_origin\",0],PARAMETER[\"central_meridian\",135],PAR");
    add_srs_wkt (p, 9,
		 "AMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",5");
    add_srs_wkt (p, 10,
		 "00000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 11,
		 "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y");
    add_srs_wkt (p, 12, "\",EAST],AUTHORITY[\"EPSG\",\"2513\"]]");
    p = add_epsg_def (filter, first, last, 2514, "epsg", 2514,
		      "Pulkovo 1942 / Gauss-Kruger CM 141E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=141 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
		   "+ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-");
    add_proj4text (p, 2, "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 141E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
		 "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
		 "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
		 "OWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AUTHORITY");
    add_srs_wkt (p, 4,
		 "[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
		 "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
		 "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]]");
    add_srs_wkt (p, 7,
		 ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
		 "e_of_origin\",0],PARAMETER[\"central_meridian\",141],PAR");
    add_srs_wkt (p, 9,
		 "AMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",5");
    add_srs_wkt (p, 10,
		 "00000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 11,
		 "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y");
    add_srs_wkt (p, 12, "\",EAST],AUTHORITY[\"EPSG\",\"2514\"]]");
    p = add_epsg_def (filter, first, last, 2515, "epsg", 2515,
		      "Pulkovo 1942 / Gauss-Kruger CM 147E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=147 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
		   "+ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-");
    add_proj4text (p, 2, "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 147E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
		 "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
		 "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
		 "OWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AUTHORITY");
    add_srs_wkt (p, 4,
		 "[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
		 "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
		 "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]]");
    add_srs_wkt (p, 7,
		 ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
		 "e_of_origin\",0],PARAMETER[\"central_meridian\",147],PAR");
    add_srs_wkt (p, 9,
		 "AMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",5");
    add_srs_wkt (p, 10,
		 "00000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 11,
		 "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y");
    add_srs_wkt (p, 12, "\",EAST],AUTHORITY[\"EPSG\",\"2515\"]]");
    p = add_epsg_def (filter, first, last, 2516, "epsg", 2516,
		      "Pulkovo 1942 / Gauss-Kruger CM 153E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=153 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
		   "+ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-");
    add_proj4text (p, 2, "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 153E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
		 "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
		 "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
		 "OWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AUTHORITY");
    add_srs_wkt (p, 4,
		 "[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
		 "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
		 "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]]");
    add_srs_wkt (p, 7,
		 ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
		 "e_of_origin\",0],PARAMETER[\"central_meridian\",153],PAR");
    add_srs_wkt (p, 9,
		 "AMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",5");
    add_srs_wkt (p, 10,
		 "00000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 11,
		 "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y");
    add_srs_wkt (p, 12, "\",EAST],AUTHORITY[\"EPSG\",\"2516\"]]");
    p = add_epsg_def (filter, first, last, 2517, "epsg", 2517,
		      "Pulkovo 1942 / Gauss-Kruger CM 159E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=159 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
		   "+ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-");
    add_proj4text (p, 2, "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 159E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
		 "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
		 "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
		 "OWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AUTHORITY");
    add_srs_wkt (p, 4,
		 "[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
		 "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
		 "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]]");
    add_srs_wkt (p, 7,
		 ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
		 "e_of_origin\",0],PARAMETER[\"central_meridian\",159],PAR");
    add_srs_wkt (p, 9,
		 "AMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",5");
    add_srs_wkt (p, 10,
		 "00000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 11,
		 "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y");
    add_srs_wkt (p, 12, "\",EAST],AUTHORITY[\"EPSG\",\"2517\"]]");
    p = add_epsg_def (filter, first, last, 2518, "epsg", 2518,
		      "Pulkovo 1942 / Gauss-Kruger CM 165E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=165 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
		   "+ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-");
    add_proj4text (p, 2, "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 165E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
		 "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
		 "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
		 "OWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AUTHORITY");
    add_srs_wkt (p, 4,
		 "[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
		 "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
		 "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]]");
    add_srs_wkt (p, 7,
		 ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
		 "e_of_origin\",0],PARAMETER[\"central_meridian\",165],PAR");
    add_srs_wkt (p, 9,
		 "AMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",5");
    add_srs_wkt (p, 10,
		 "00000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 11,
		 "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y");
    add_srs_wkt (p, 12, "\",EAST],AUTHORITY[\"EPSG\",\"2518\"]]");
    p = add_epsg_def (filter, first, last, 2519, "epsg", 2519,
		      "Pulkovo 1942 / Gauss-Kruger CM 171E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=171 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
		   "+ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-");
    add_proj4text (p, 2, "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 171E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
		 "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
		 "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
		 "OWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AUTHORITY");
    add_srs_wkt (p, 4,
		 "[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
		 "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
		 "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]]");
    add_srs_wkt (p, 7,
		 ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
		 "e_of_origin\",0],PARAMETER[\"central_meridian\",171],PAR");
    add_srs_wkt (p, 9,
		 "AMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",5");
    add_srs_wkt (p, 10,
		 "00000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 11,
		 "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y");
    add_srs_wkt (p, 12, "\",EAST],AUTHORITY[\"EPSG\",\"2519\"]]");
    p = add_epsg_def (filter, first, last, 2520, "epsg", 2520,
		      "Pulkovo 1942 / Gauss-Kruger CM 177E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=177 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
		   "+ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-");
    add_proj4text (p, 2, "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 177E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
		 "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
		 "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
		 "OWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AUTHORITY");
    add_srs_wkt (p, 4,
		 "[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
		 "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
		 "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]]");
    add_srs_wkt (p, 7,
		 ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
		 "e_of_origin\",0],PARAMETER[\"central_meridian\",177],PAR");
    add_srs_wkt (p, 9,
		 "AMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",5");
    add_srs_wkt (p, 10,
		 "00000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 11,
		 "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y");
    add_srs_wkt (p, 12, "\",EAST],AUTHORITY[\"EPSG\",\"2520\"]]");
    p = add_epsg_def (filter, first, last, 2521, "epsg", 2521,
		      "Pulkovo 1942 / Gauss-Kruger CM 177W");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=-177 +k=1 +x_0=500000 +y_0=0");
    add_proj4text (p, 1,
		   " +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,");
    add_proj4text (p, 2, "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 177W\",GEOGCS[\"");
    add_srs_wkt (p, 1,
		 "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
		 "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
		 "OWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AUTHORITY");
    add_srs_wkt (p, 4,
		 "[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
		 "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
		 "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]]");
    add_srs_wkt (p, 7,
		 ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
		 "e_of_origin\",0],PARAMETER[\"central_meridian\",-177],PA");
    add_srs_wkt (p, 9,
		 "RAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 10,
		 "500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1");
    add_srs_wkt (p, 11,
		 ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"");
    add_srs_wkt (p, 12, "Y\",EAST],AUTHORITY[\"EPSG\",\"2521\"]]");
    p = add_epsg_def (filter, first, last, 2522, "epsg", 2522,
		      "Pulkovo 1942 / Gauss-Kruger CM 171W");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=-171 +k=1 +x_0=500000 +y_0=0");
    add_proj4text (p, 1,
		   " +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,");
    add_proj4text (p, 2, "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 171W\",GEOGCS[\"");
    add_srs_wkt (p, 1,
		 "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
		 "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
		 "OWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AUTHORITY");
    add_srs_wkt (p, 4,
		 "[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
		 "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
		 "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]]");
    add_srs_wkt (p, 7,
		 ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
		 "e_of_origin\",0],PARAMETER[\"central_meridian\",-171],PA");
    add_srs_wkt (p, 9,
		 "RAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 10,
		 "500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1");
    add_srs_wkt (p, 11,
		 ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"");
    add_srs_wkt (p, 12, "Y\",EAST],AUTHORITY[\"EPSG\",\"2522\"]]");
    p = add_epsg_def (filter, first, last, 2523, "epsg", 2523,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger zone 7");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=7500000 +y_0=0 ");
    add_proj4text (p, 1,
		   "+ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-");
    add_proj4text (p, 2, "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 7\",G");
    add_srs_wkt (p, 1,
		 "EOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"");
    add_srs_wkt (p, 2,
		 "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
		 "4\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AU");
    add_srs_wkt (p, 4,
		 "THORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 5,
		 "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 6,
		 "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 7,
		 "284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",2");
    add_srs_wkt (p, 9,
		 "1],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
		 "ng\",7500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 11,
		 "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],A");
    add_srs_wkt (p, 12, "XIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2523\"]]");
    p = add_epsg_def (filter, first, last, 2524, "epsg", 2524,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger zone 8");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=24 +k=1 +x_0=8500000 +y_0=0 ");
    add_proj4text (p, 1,
		   "+ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-");
    add_proj4text (p, 2, "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 8\",G");
    add_srs_wkt (p, 1,
		 "EOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"");
    add_srs_wkt (p, 2,
		 "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
		 "4\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AU");
    add_srs_wkt (p, 4,
		 "THORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 5,
		 "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 6,
		 "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 7,
		 "284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",2");
    add_srs_wkt (p, 9,
		 "4],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
		 "ng\",8500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 11,
		 "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],A");
    add_srs_wkt (p, 12, "XIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2524\"]]");
    p = add_epsg_def (filter, first, last, 2525, "epsg", 2525,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger zone 9");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=9500000 +y_0=0 ");
    add_proj4text (p, 1,
		   "+ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-");
    add_proj4text (p, 2, "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 9\",G");
    add_srs_wkt (p, 1,
		 "EOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"");
    add_srs_wkt (p, 2,
		 "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
		 "4\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AU");
    add_srs_wkt (p, 4,
		 "THORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 5,
		 "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 6,
		 "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 7,
		 "284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",2");
    add_srs_wkt (p, 9,
		 "7],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
		 "ng\",9500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 11,
		 "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],A");
    add_srs_wkt (p, 12, "XIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2525\"]]");
    p = add_epsg_def (filter, first, last, 2526, "epsg", 2526,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger zone 10");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=30 +k=1 +x_0=10500000 +y_0=0");
    add_proj4text (p, 1,
		   " +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,");
    add_proj4text (p, 2, "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 10\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",3");
    add_srs_wkt (p, 9,
		 "0],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
		 "ng\",10500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
		 "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],");
    add_srs_wkt (p, 12, "AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2526\"]]");
}

static void
initialize_epsg_05 (int filter, struct epsg_defs **first,
		    struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def (filter, first, last, 2527, "epsg", 2527,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger zone 11");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=11500000 +y_0=0");
    add_proj4text (p, 1,
		   " +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,");
    add_proj4text (p, 2, "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 11\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",3");
    add_srs_wkt (p, 9,
		 "3],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
		 "ng\",11500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
		 "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],");
    add_srs_wkt (p, 12, "AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2527\"]]");
    p = add_epsg_def (filter, first, last, 2528, "epsg", 2528,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger zone 12");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=36 +k=1 +x_0=12500000 +y_0=0");
    add_proj4text (p, 1,
		   " +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,");
    add_proj4text (p, 2, "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 12\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",3");
    add_srs_wkt (p, 9,
		 "6],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
		 "ng\",12500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
		 "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],");
    add_srs_wkt (p, 12, "AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2528\"]]");
    p = add_epsg_def (filter, first, last, 2529, "epsg", 2529,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger zone 13");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=13500000 +y_0=0");
    add_proj4text (p, 1,
		   " +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,");
    add_proj4text (p, 2, "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 13\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",3");
    add_srs_wkt (p, 9,
		 "9],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
		 "ng\",13500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
		 "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],");
    add_srs_wkt (p, 12, "AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2529\"]]");
    p = add_epsg_def (filter, first, last, 2530, "epsg", 2530,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger zone 14");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=42 +k=1 +x_0=14500000 +y_0=0");
    add_proj4text (p, 1,
		   " +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,");
    add_proj4text (p, 2, "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 14\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",4");
    add_srs_wkt (p, 9,
		 "2],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
		 "ng\",14500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
		 "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],");
    add_srs_wkt (p, 12, "AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2530\"]]");
    p = add_epsg_def (filter, first, last, 2531, "epsg", 2531,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger zone 15");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=15500000 +y_0=0");
    add_proj4text (p, 1,
		   " +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,");
    add_proj4text (p, 2, "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 15\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",4");
    add_srs_wkt (p, 9,
		 "5],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
		 "ng\",15500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
		 "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],");
    add_srs_wkt (p, 12, "AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2531\"]]");
    p = add_epsg_def (filter, first, last, 2532, "epsg", 2532,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger zone 16");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=48 +k=1 +x_0=16500000 +y_0=0");
    add_proj4text (p, 1,
		   " +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,");
    add_proj4text (p, 2, "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 16\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",4");
    add_srs_wkt (p, 9,
		 "8],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
		 "ng\",16500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
		 "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],");
    add_srs_wkt (p, 12, "AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2532\"]]");
    p = add_epsg_def (filter, first, last, 2533, "epsg", 2533,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger zone 17");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=51 +k=1 +x_0=17500000 +y_0=0");
    add_proj4text (p, 1,
		   " +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,");
    add_proj4text (p, 2, "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 17\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",5");
    add_srs_wkt (p, 9,
		 "1],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
		 "ng\",17500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
		 "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],");
    add_srs_wkt (p, 12, "AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2533\"]]");
    p = add_epsg_def (filter, first, last, 2534, "epsg", 2534,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger zone 18");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=54 +k=1 +x_0=18500000 +y_0=0");
    add_proj4text (p, 1,
		   " +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,");
    add_proj4text (p, 2, "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 18\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",5");
    add_srs_wkt (p, 9,
		 "4],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
		 "ng\",18500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
		 "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],");
    add_srs_wkt (p, 12, "AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2534\"]]");
    p = add_epsg_def (filter, first, last, 2535, "epsg", 2535,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger zone 19");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=57 +k=1 +x_0=19500000 +y_0=0");
    add_proj4text (p, 1,
		   " +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,");
    add_proj4text (p, 2, "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 19\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",5");
    add_srs_wkt (p, 9,
		 "7],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
		 "ng\",19500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
		 "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],");
    add_srs_wkt (p, 12, "AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2535\"]]");
    p = add_epsg_def (filter, first, last, 2536, "epsg", 2536,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger zone 20");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=60 +k=1 +x_0=20500000 +y_0=0");
    add_proj4text (p, 1,
		   " +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,");
    add_proj4text (p, 2, "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 20\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",6");
    add_srs_wkt (p, 9,
		 "0],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
		 "ng\",20500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
		 "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],");
    add_srs_wkt (p, 12, "AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2536\"]]");
    p = add_epsg_def (filter, first, last, 2537, "epsg", 2537,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger zone 21");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=63 +k=1 +x_0=21500000 +y_0=0");
    add_proj4text (p, 1,
		   " +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,");
    add_proj4text (p, 2, "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 21\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",6");
    add_srs_wkt (p, 9,
		 "3],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
		 "ng\",21500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
		 "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],");
    add_srs_wkt (p, 12, "AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2537\"]]");
    p = add_epsg_def (filter, first, last, 2538, "epsg", 2538,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger zone 22");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=66 +k=1 +x_0=22500000 +y_0=0");
    add_proj4text (p, 1,
		   " +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,");
    add_proj4text (p, 2, "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 22\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",6");
    add_srs_wkt (p, 9,
		 "6],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
		 "ng\",22500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
		 "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],");
    add_srs_wkt (p, 12, "AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2538\"]]");
    p = add_epsg_def (filter, first, last, 2539, "epsg", 2539,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger zone 23");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=69 +k=1 +x_0=23500000 +y_0=0");
    add_proj4text (p, 1,
		   " +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,");
    add_proj4text (p, 2, "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 23\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",6");
    add_srs_wkt (p, 9,
		 "9],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
		 "ng\",23500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
		 "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],");
    add_srs_wkt (p, 12, "AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2539\"]]");
    p = add_epsg_def (filter, first, last, 2540, "epsg", 2540,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger zone 24");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=72 +k=1 +x_0=24500000 +y_0=0");
    add_proj4text (p, 1,
		   " +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,");
    add_proj4text (p, 2, "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 24\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",7");
    add_srs_wkt (p, 9,
		 "2],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
		 "ng\",24500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
		 "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],");
    add_srs_wkt (p, 12, "AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2540\"]]");
    p = add_epsg_def (filter, first, last, 2541, "epsg", 2541,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger zone 25");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=25500000 +y_0=0");
    add_proj4text (p, 1,
		   " +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,");
    add_proj4text (p, 2, "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 25\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",7");
    add_srs_wkt (p, 9,
		 "5],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
		 "ng\",25500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
		 "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],");
    add_srs_wkt (p, 12, "AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2541\"]]");
    p = add_epsg_def (filter, first, last, 2542, "epsg", 2542,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger zone 26");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=78 +k=1 +x_0=26500000 +y_0=0");
    add_proj4text (p, 1,
		   " +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,");
    add_proj4text (p, 2, "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 26\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",7");
    add_srs_wkt (p, 9,
		 "8],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
		 "ng\",26500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
		 "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],");
    add_srs_wkt (p, 12, "AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2542\"]]");
    p = add_epsg_def (filter, first, last, 2543, "epsg", 2543,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger zone 27");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=27500000 +y_0=0");
    add_proj4text (p, 1,
		   " +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,");
    add_proj4text (p, 2, "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 27\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",8");
    add_srs_wkt (p, 9,
		 "1],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
		 "ng\",27500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
		 "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],");
    add_srs_wkt (p, 12, "AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2543\"]]");
    p = add_epsg_def (filter, first, last, 2544, "epsg", 2544,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger zone 28");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=84 +k=1 +x_0=28500000 +y_0=0");
    add_proj4text (p, 1,
		   " +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,");
    add_proj4text (p, 2, "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 28\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",8");
    add_srs_wkt (p, 9,
		 "4],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
		 "ng\",28500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
		 "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],");
    add_srs_wkt (p, 12, "AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2544\"]]");
    p = add_epsg_def (filter, first, last, 2545, "epsg", 2545,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger zone 29");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=29500000 +y_0=0");
    add_proj4text (p, 1,
		   " +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,");
    add_proj4text (p, 2, "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 29\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",8");
    add_srs_wkt (p, 9,
		 "7],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
		 "ng\",29500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
		 "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],");
    add_srs_wkt (p, 12, "AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2545\"]]");
    p = add_epsg_def (filter, first, last, 2546, "epsg", 2546,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger zone 30");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=90 +k=1 +x_0=30500000 +y_0=0");
    add_proj4text (p, 1,
		   " +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,");
    add_proj4text (p, 2, "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 30\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",9");
    add_srs_wkt (p, 9,
		 "0],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
		 "ng\",30500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
		 "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],");
    add_srs_wkt (p, 12, "AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2546\"]]");
    p = add_epsg_def (filter, first, last, 2547, "epsg", 2547,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger zone 31");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=31500000 +y_0=0");
    add_proj4text (p, 1,
		   " +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,");
    add_proj4text (p, 2, "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 31\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",9");
    add_srs_wkt (p, 9,
		 "3],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
		 "ng\",31500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
		 "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],");
    add_srs_wkt (p, 12, "AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2547\"]]");
    p = add_epsg_def (filter, first, last, 2548, "epsg", 2548,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger zone 32");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=96 +k=1 +x_0=32500000 +y_0=0");
    add_proj4text (p, 1,
		   " +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,");
    add_proj4text (p, 2, "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 32\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",9");
    add_srs_wkt (p, 9,
		 "6],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
		 "ng\",32500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
		 "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],");
    add_srs_wkt (p, 12, "AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2548\"]]");
    p = add_epsg_def (filter, first, last, 2549, "epsg", 2549,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger zone 33");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=33500000 +y_0=0");
    add_proj4text (p, 1,
		   " +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,");
    add_proj4text (p, 2, "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 33\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",9");
    add_srs_wkt (p, 9,
		 "9],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
		 "ng\",33500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
		 "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],");
    add_srs_wkt (p, 12, "AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2549\"]]");
    p = add_epsg_def (filter, first, last, 2550, "epsg", 2550,
		      "Samboja / UTM zone 50S (deprecated)");
    add_proj4text (p, 0,
		   "+proj=utm +zone=50 +south +ellps=bessel +towgs84=-404.78");
    add_proj4text (p, 1, ",685.68,45.47,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Samboja / UTM zone 50S (deprecated)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
		 "Samboja\",DATUM[\"Samboja\",SPHEROID[\"Bessel 1841\",637");
    add_srs_wkt (p, 2,
		 "7397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOWGS");
    add_srs_wkt (p, 3,
		 "84[-404.78,685.68,45.47,0,0,0,0],AUTHORITY[\"EPSG\",\"61");
    add_srs_wkt (p, 4,
		 "25\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
		 "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
		 ",\"9108\"]],AUTHORITY[\"EPSG\",\"4125\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
		 "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 8,
		 "],PARAMETER[\"central_meridian\",117],PARAMETER[\"scale_");
    add_srs_wkt (p, 9,
		 "factor\",0.9996],PARAMETER[\"false_easting\",500000],PAR");
    add_srs_wkt (p, 10,
		 "AMETER[\"false_northing\",10000000],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 11,
		 "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 12, "Northing\",NORTH],AUTHORITY[\"EPSG\",\"2550\"]]");
    p = add_epsg_def (filter, first, last, 2551, "epsg", 2551,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger zone 34");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=102 +k=1 +x_0=34500000 +y_0=");
    add_proj4text (p, 1,
		   "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82");
    add_proj4text (p, 2, ",-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 34\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
		 "02],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
		 "ing\",34500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
		 "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH]");
    add_srs_wkt (p, 12, ",AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2551\"]]");
    p = add_epsg_def (filter, first, last, 2552, "epsg", 2552,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger zone 35");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=35500000 +y_0=");
    add_proj4text (p, 1,
		   "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82");
    add_proj4text (p, 2, ",-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 35\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
		 "05],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
		 "ing\",35500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
		 "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH]");
    add_srs_wkt (p, 12, ",AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2552\"]]");
    p = add_epsg_def (filter, first, last, 2553, "epsg", 2553,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger zone 36");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=108 +k=1 +x_0=36500000 +y_0=");
    add_proj4text (p, 1,
		   "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82");
    add_proj4text (p, 2, ",-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 36\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
		 "08],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
		 "ing\",36500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
		 "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH]");
    add_srs_wkt (p, 12, ",AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2553\"]]");
    p = add_epsg_def (filter, first, last, 2554, "epsg", 2554,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger zone 37");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=37500000 +y_0=");
    add_proj4text (p, 1,
		   "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82");
    add_proj4text (p, 2, ",-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 37\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
		 "11],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
		 "ing\",37500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
		 "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH]");
    add_srs_wkt (p, 12, ",AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2554\"]]");
    p = add_epsg_def (filter, first, last, 2555, "epsg", 2555,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger zone 38");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=114 +k=1 +x_0=38500000 +y_0=");
    add_proj4text (p, 1,
		   "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82");
    add_proj4text (p, 2, ",-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 38\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
		 "14],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
		 "ing\",38500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
		 "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH]");
    add_srs_wkt (p, 12, ",AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2555\"]]");
    p = add_epsg_def (filter, first, last, 2556, "epsg", 2556,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger zone 39");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=39500000 +y_0=");
    add_proj4text (p, 1,
		   "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82");
    add_proj4text (p, 2, ",-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 39\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
		 "17],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
		 "ing\",39500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
		 "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH]");
    add_srs_wkt (p, 12, ",AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2556\"]]");
    p = add_epsg_def (filter, first, last, 2557, "epsg", 2557,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger zone 40");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=120 +k=1 +x_0=40500000 +y_0=");
    add_proj4text (p, 1,
		   "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82");
    add_proj4text (p, 2, ",-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 40\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
		 "20],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
		 "ing\",40500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
		 "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH]");
    add_srs_wkt (p, 12, ",AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2557\"]]");
    p = add_epsg_def (filter, first, last, 2558, "epsg", 2558,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger zone 41");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=41500000 +y_0=");
    add_proj4text (p, 1,
		   "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82");
    add_proj4text (p, 2, ",-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 41\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
		 "23],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
		 "ing\",41500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
		 "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH]");
    add_srs_wkt (p, 12, ",AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2558\"]]");
    p = add_epsg_def (filter, first, last, 2559, "epsg", 2559,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger zone 42");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=126 +k=1 +x_0=42500000 +y_0=");
    add_proj4text (p, 1,
		   "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82");
    add_proj4text (p, 2, ",-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 42\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
		 "26],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
		 "ing\",42500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
		 "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH]");
    add_srs_wkt (p, 12, ",AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2559\"]]");
    p = add_epsg_def (filter, first, last, 2560, "epsg", 2560,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger zone 43");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=43500000 +y_0=");
    add_proj4text (p, 1,
		   "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82");
    add_proj4text (p, 2, ",-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 43\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
		 "29],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
		 "ing\",43500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
		 "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH]");
    add_srs_wkt (p, 12, ",AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2560\"]]");
    p = add_epsg_def (filter, first, last, 2561, "epsg", 2561,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger zone 44");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=132 +k=1 +x_0=44500000 +y_0=");
    add_proj4text (p, 1,
		   "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82");
    add_proj4text (p, 2, ",-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 44\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
		 "32],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
		 "ing\",44500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
		 "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH]");
    add_srs_wkt (p, 12, ",AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2561\"]]");
    p = add_epsg_def (filter, first, last, 2562, "epsg", 2562,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger zone 45");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=45500000 +y_0=");
    add_proj4text (p, 1,
		   "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82");
    add_proj4text (p, 2, ",-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 45\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
		 "35],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
		 "ing\",45500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
		 "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH]");
    add_srs_wkt (p, 12, ",AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2562\"]]");
    p = add_epsg_def (filter, first, last, 2563, "epsg", 2563,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger zone 46");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=138 +k=1 +x_0=46500000 +y_0=");
    add_proj4text (p, 1,
		   "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82");
    add_proj4text (p, 2, ",-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 46\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
		 "38],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
		 "ing\",46500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
		 "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH]");
    add_srs_wkt (p, 12, ",AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2563\"]]");
    p = add_epsg_def (filter, first, last, 2564, "epsg", 2564,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger zone 47");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=141 +k=1 +x_0=47500000 +y_0=");
    add_proj4text (p, 1,
		   "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82");
    add_proj4text (p, 2, ",-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 47\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
		 "41],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
		 "ing\",47500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
		 "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH]");
    add_srs_wkt (p, 12, ",AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2564\"]]");
    p = add_epsg_def (filter, first, last, 2565, "epsg", 2565,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger zone 48");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=144 +k=1 +x_0=48500000 +y_0=");
    add_proj4text (p, 1,
		   "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82");
    add_proj4text (p, 2, ",-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 48\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
		 "44],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
		 "ing\",48500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
		 "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH]");
    add_srs_wkt (p, 12, ",AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2565\"]]");
    p = add_epsg_def (filter, first, last, 2566, "epsg", 2566,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger zone 49");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=147 +k=1 +x_0=49500000 +y_0=");
    add_proj4text (p, 1,
		   "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82");
    add_proj4text (p, 2, ",-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 49\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
		 "47],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
		 "ing\",49500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
		 "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH]");
    add_srs_wkt (p, 12, ",AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2566\"]]");
    p = add_epsg_def (filter, first, last, 2567, "epsg", 2567,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger zone 50");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=150 +k=1 +x_0=50500000 +y_0=");
    add_proj4text (p, 1,
		   "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82");
    add_proj4text (p, 2, ",-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 50\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
		 "50],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
		 "ing\",50500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
		 "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH]");
    add_srs_wkt (p, 12, ",AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2567\"]]");
    p = add_epsg_def (filter, first, last, 2568, "epsg", 2568,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger zone 51");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=153 +k=1 +x_0=51500000 +y_0=");
    add_proj4text (p, 1,
		   "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82");
    add_proj4text (p, 2, ",-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 51\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
		 "53],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
		 "ing\",51500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
		 "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH]");
    add_srs_wkt (p, 12, ",AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2568\"]]");
    p = add_epsg_def (filter, first, last, 2569, "epsg", 2569,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger zone 52");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=156 +k=1 +x_0=52500000 +y_0=");
    add_proj4text (p, 1,
		   "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82");
    add_proj4text (p, 2, ",-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 52\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
		 "56],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
		 "ing\",52500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
		 "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH]");
    add_srs_wkt (p, 12, ",AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2569\"]]");
    p = add_epsg_def (filter, first, last, 2570, "epsg", 2570,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger zone 53");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=159 +k=1 +x_0=53500000 +y_0=");
    add_proj4text (p, 1,
		   "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82");
    add_proj4text (p, 2, ",-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 53\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
		 "59],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
		 "ing\",53500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
		 "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH]");
    add_srs_wkt (p, 12, ",AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2570\"]]");
    p = add_epsg_def (filter, first, last, 2571, "epsg", 2571,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger zone 54");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=162 +k=1 +x_0=54500000 +y_0=");
    add_proj4text (p, 1,
		   "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82");
    add_proj4text (p, 2, ",-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 54\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
		 "62],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
		 "ing\",54500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
		 "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH]");
    add_srs_wkt (p, 12, ",AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2571\"]]");
    p = add_epsg_def (filter, first, last, 2572, "epsg", 2572,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger zone 55");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=165 +k=1 +x_0=55500000 +y_0=");
    add_proj4text (p, 1,
		   "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82");
    add_proj4text (p, 2, ",-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 55\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
		 "65],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
		 "ing\",55500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
		 "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH]");
    add_srs_wkt (p, 12, ",AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2572\"]]");
    p = add_epsg_def (filter, first, last, 2573, "epsg", 2573,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger zone 56");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=168 +k=1 +x_0=56500000 +y_0=");
    add_proj4text (p, 1,
		   "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82");
    add_proj4text (p, 2, ",-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 56\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
		 "68],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
		 "ing\",56500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
		 "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH]");
    add_srs_wkt (p, 12, ",AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2573\"]]");
    p = add_epsg_def (filter, first, last, 2574, "epsg", 2574,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger zone 57");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=171 +k=1 +x_0=57500000 +y_0=");
    add_proj4text (p, 1,
		   "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82");
    add_proj4text (p, 2, ",-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 57\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
		 "71],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
		 "ing\",57500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
		 "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH]");
    add_srs_wkt (p, 12, ",AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2574\"]]");
    p = add_epsg_def (filter, first, last, 2575, "epsg", 2575,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger zone 58");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=174 +k=1 +x_0=58500000 +y_0=");
    add_proj4text (p, 1,
		   "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82");
    add_proj4text (p, 2, ",-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 58\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
		 "74],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
		 "ing\",58500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
		 "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH]");
    add_srs_wkt (p, 12, ",AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2575\"]]");
    p = add_epsg_def (filter, first, last, 2576, "epsg", 2576,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger zone 59");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=177 +k=1 +x_0=59500000 +y_0=");
    add_proj4text (p, 1,
		   "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82");
    add_proj4text (p, 2, ",-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 59\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
		 "77],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
		 "ing\",59500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
		 "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH]");
    add_srs_wkt (p, 12, ",AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2576\"]]");
    p = add_epsg_def (filter, first, last, 2577, "epsg", 2577,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger zone 60 (deprecated)");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=180 +k=1 +x_0=60000000 +y_0=");
    add_proj4text (p, 1,
		   "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82");
    add_proj4text (p, 2, ",-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 60 (d");
    add_srs_wkt (p, 1,
		 "eprecated)\",GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_194");
    add_srs_wkt (p, 2,
		 "2\",SPHEROID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY");
    add_srs_wkt (p, 3,
		 "[\"EPSG\",\"7024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35");
    add_srs_wkt (p, 4,
		 ",0.82,-0.12],AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 5,
		 "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 6,
		 "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 7,
		 "TY[\"EPSG\",\"4284\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 8,
		 "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 9,
		 "l_meridian\",180],PARAMETER[\"scale_factor\",1],PARAMETE");
    add_srs_wkt (p, 10,
		 "R[\"false_easting\",60000000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 11,
		 "\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 12,
		 "S[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"257");
    add_srs_wkt (p, 13, "7\"]]");
    p = add_epsg_def (filter, first, last, 2578, "epsg", 2578,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger zone 61");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=-177 +k=1 +x_0=61500000 +y_0");
    add_proj4text (p, 1,
		   "=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.8");
    add_proj4text (p, 2, "2,-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 61\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 9,
		 "177],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eas");
    add_srs_wkt (p, 10,
		 "ting\",61500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 11,
		 "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH");
    add_srs_wkt (p, 12, "],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2578\"]]");
    p = add_epsg_def (filter, first, last, 2579, "epsg", 2579,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger zone 62");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=-174 +k=1 +x_0=62500000 +y_0");
    add_proj4text (p, 1,
		   "=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.8");
    add_proj4text (p, 2, "2,-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 62\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 9,
		 "174],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eas");
    add_srs_wkt (p, 10,
		 "ting\",62500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 11,
		 "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH");
    add_srs_wkt (p, 12, "],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2579\"]]");
    p = add_epsg_def (filter, first, last, 2580, "epsg", 2580,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger zone 63");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=-171 +k=1 +x_0=63500000 +y_0");
    add_proj4text (p, 1,
		   "=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.8");
    add_proj4text (p, 2, "2,-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 63\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 9,
		 "171],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eas");
    add_srs_wkt (p, 10,
		 "ting\",63500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 11,
		 "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH");
    add_srs_wkt (p, 12, "],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2580\"]]");
    p = add_epsg_def (filter, first, last, 2581, "epsg", 2581,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger zone 64");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=-168 +k=1 +x_0=64500000 +y_0");
    add_proj4text (p, 1,
		   "=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.8");
    add_proj4text (p, 2, "2,-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 64\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 9,
		 "168],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eas");
    add_srs_wkt (p, 10,
		 "ting\",64500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 11,
		 "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH");
    add_srs_wkt (p, 12, "],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2581\"]]");
    p = add_epsg_def (filter, first, last, 2582, "epsg", 2582,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger CM 21E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
		   "ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0");
    add_proj4text (p, 2, ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 21E\",G");
    add_srs_wkt (p, 1,
		 "EOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"");
    add_srs_wkt (p, 2,
		 "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
		 "4\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AU");
    add_srs_wkt (p, 4,
		 "THORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 5,
		 "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 6,
		 "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 7,
		 "284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",2");
    add_srs_wkt (p, 9,
		 "1],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
		 "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 11,
		 "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AX");
    add_srs_wkt (p, 12, "IS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2582\"]]");
    p = add_epsg_def (filter, first, last, 2583, "epsg", 2583,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger CM 24E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=24 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
		   "ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0");
    add_proj4text (p, 2, ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 24E\",G");
    add_srs_wkt (p, 1,
		 "EOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"");
    add_srs_wkt (p, 2,
		 "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
		 "4\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AU");
    add_srs_wkt (p, 4,
		 "THORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 5,
		 "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 6,
		 "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 7,
		 "284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",2");
    add_srs_wkt (p, 9,
		 "4],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
		 "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 11,
		 "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AX");
    add_srs_wkt (p, 12, "IS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2583\"]]");
    p = add_epsg_def (filter, first, last, 2584, "epsg", 2584,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger CM 27E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
		   "ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0");
    add_proj4text (p, 2, ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 27E\",G");
    add_srs_wkt (p, 1,
		 "EOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"");
    add_srs_wkt (p, 2,
		 "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
		 "4\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AU");
    add_srs_wkt (p, 4,
		 "THORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 5,
		 "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 6,
		 "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 7,
		 "284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",2");
    add_srs_wkt (p, 9,
		 "7],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
		 "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 11,
		 "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AX");
    add_srs_wkt (p, 12, "IS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2584\"]]");
    p = add_epsg_def (filter, first, last, 2585, "epsg", 2585,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger CM 30E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=30 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
		   "ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0");
    add_proj4text (p, 2, ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 30E\",G");
    add_srs_wkt (p, 1,
		 "EOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"");
    add_srs_wkt (p, 2,
		 "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
		 "4\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AU");
    add_srs_wkt (p, 4,
		 "THORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 5,
		 "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 6,
		 "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 7,
		 "284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",3");
    add_srs_wkt (p, 9,
		 "0],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
		 "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 11,
		 "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AX");
    add_srs_wkt (p, 12, "IS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2585\"]]");
    p = add_epsg_def (filter, first, last, 2586, "epsg", 2586,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger CM 33E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
		   "ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0");
    add_proj4text (p, 2, ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 33E\",G");
    add_srs_wkt (p, 1,
		 "EOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"");
    add_srs_wkt (p, 2,
		 "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
		 "4\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AU");
    add_srs_wkt (p, 4,
		 "THORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 5,
		 "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 6,
		 "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 7,
		 "284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",3");
    add_srs_wkt (p, 9,
		 "3],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
		 "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 11,
		 "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AX");
    add_srs_wkt (p, 12, "IS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2586\"]]");
    p = add_epsg_def (filter, first, last, 2587, "epsg", 2587,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger CM 36E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=36 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
		   "ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0");
    add_proj4text (p, 2, ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 36E\",G");
    add_srs_wkt (p, 1,
		 "EOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"");
    add_srs_wkt (p, 2,
		 "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
		 "4\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AU");
    add_srs_wkt (p, 4,
		 "THORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 5,
		 "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 6,
		 "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 7,
		 "284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",3");
    add_srs_wkt (p, 9,
		 "6],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
		 "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 11,
		 "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AX");
    add_srs_wkt (p, 12, "IS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2587\"]]");
    p = add_epsg_def (filter, first, last, 2588, "epsg", 2588,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger CM 39E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
		   "ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0");
    add_proj4text (p, 2, ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 39E\",G");
    add_srs_wkt (p, 1,
		 "EOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"");
    add_srs_wkt (p, 2,
		 "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
		 "4\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AU");
    add_srs_wkt (p, 4,
		 "THORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 5,
		 "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 6,
		 "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 7,
		 "284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",3");
    add_srs_wkt (p, 9,
		 "9],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
		 "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 11,
		 "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AX");
    add_srs_wkt (p, 12, "IS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2588\"]]");
    p = add_epsg_def (filter, first, last, 2589, "epsg", 2589,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger CM 42E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=42 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
		   "ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0");
    add_proj4text (p, 2, ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 42E\",G");
    add_srs_wkt (p, 1,
		 "EOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"");
    add_srs_wkt (p, 2,
		 "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
		 "4\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AU");
    add_srs_wkt (p, 4,
		 "THORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 5,
		 "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 6,
		 "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 7,
		 "284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",4");
    add_srs_wkt (p, 9,
		 "2],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
		 "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 11,
		 "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AX");
    add_srs_wkt (p, 12, "IS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2589\"]]");
    p = add_epsg_def (filter, first, last, 2590, "epsg", 2590,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger CM 45E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
		   "ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0");
    add_proj4text (p, 2, ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 45E\",G");
    add_srs_wkt (p, 1,
		 "EOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"");
    add_srs_wkt (p, 2,
		 "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
		 "4\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AU");
    add_srs_wkt (p, 4,
		 "THORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 5,
		 "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 6,
		 "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 7,
		 "284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",4");
    add_srs_wkt (p, 9,
		 "5],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
		 "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 11,
		 "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AX");
    add_srs_wkt (p, 12, "IS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2590\"]]");
    p = add_epsg_def (filter, first, last, 2591, "epsg", 2591,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger CM 48E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=48 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
		   "ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0");
    add_proj4text (p, 2, ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 48E\",G");
    add_srs_wkt (p, 1,
		 "EOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"");
    add_srs_wkt (p, 2,
		 "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
		 "4\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AU");
    add_srs_wkt (p, 4,
		 "THORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 5,
		 "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 6,
		 "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 7,
		 "284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",4");
    add_srs_wkt (p, 9,
		 "8],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
		 "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 11,
		 "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AX");
    add_srs_wkt (p, 12, "IS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2591\"]]");
    p = add_epsg_def (filter, first, last, 2592, "epsg", 2592,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger CM 51E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=51 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
		   "ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0");
    add_proj4text (p, 2, ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 51E\",G");
    add_srs_wkt (p, 1,
		 "EOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"");
    add_srs_wkt (p, 2,
		 "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
		 "4\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AU");
    add_srs_wkt (p, 4,
		 "THORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 5,
		 "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 6,
		 "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 7,
		 "284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",5");
    add_srs_wkt (p, 9,
		 "1],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
		 "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 11,
		 "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AX");
    add_srs_wkt (p, 12, "IS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2592\"]]");
    p = add_epsg_def (filter, first, last, 2593, "epsg", 2593,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger CM 54E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=54 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
		   "ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0");
    add_proj4text (p, 2, ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 54E\",G");
    add_srs_wkt (p, 1,
		 "EOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"");
    add_srs_wkt (p, 2,
		 "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
		 "4\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AU");
    add_srs_wkt (p, 4,
		 "THORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 5,
		 "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 6,
		 "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 7,
		 "284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",5");
    add_srs_wkt (p, 9,
		 "4],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
		 "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 11,
		 "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AX");
    add_srs_wkt (p, 12, "IS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2593\"]]");
    p = add_epsg_def (filter, first, last, 2594, "epsg", 2594,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger CM 57E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=57 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
		   "ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0");
    add_proj4text (p, 2, ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 57E\",G");
    add_srs_wkt (p, 1,
		 "EOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"");
    add_srs_wkt (p, 2,
		 "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
		 "4\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AU");
    add_srs_wkt (p, 4,
		 "THORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 5,
		 "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 6,
		 "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 7,
		 "284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",5");
    add_srs_wkt (p, 9,
		 "7],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
		 "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 11,
		 "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AX");
    add_srs_wkt (p, 12, "IS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2594\"]]");
    p = add_epsg_def (filter, first, last, 2595, "epsg", 2595,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger CM 60E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=60 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
		   "ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0");
    add_proj4text (p, 2, ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 60E\",G");
    add_srs_wkt (p, 1,
		 "EOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"");
    add_srs_wkt (p, 2,
		 "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
		 "4\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AU");
    add_srs_wkt (p, 4,
		 "THORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 5,
		 "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 6,
		 "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 7,
		 "284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",6");
    add_srs_wkt (p, 9,
		 "0],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
		 "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 11,
		 "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AX");
    add_srs_wkt (p, 12, "IS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2595\"]]");
    p = add_epsg_def (filter, first, last, 2596, "epsg", 2596,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger CM 63E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=63 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
		   "ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0");
    add_proj4text (p, 2, ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 63E\",G");
    add_srs_wkt (p, 1,
		 "EOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"");
    add_srs_wkt (p, 2,
		 "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
		 "4\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AU");
    add_srs_wkt (p, 4,
		 "THORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 5,
		 "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 6,
		 "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 7,
		 "284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",6");
    add_srs_wkt (p, 9,
		 "3],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
		 "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 11,
		 "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AX");
    add_srs_wkt (p, 12, "IS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2596\"]]");
    p = add_epsg_def (filter, first, last, 2597, "epsg", 2597,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger CM 66E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=66 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
		   "ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0");
    add_proj4text (p, 2, ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 66E\",G");
    add_srs_wkt (p, 1,
		 "EOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"");
    add_srs_wkt (p, 2,
		 "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
		 "4\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AU");
    add_srs_wkt (p, 4,
		 "THORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 5,
		 "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 6,
		 "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 7,
		 "284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",6");
    add_srs_wkt (p, 9,
		 "6],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
		 "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 11,
		 "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AX");
    add_srs_wkt (p, 12, "IS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2597\"]]");
    p = add_epsg_def (filter, first, last, 2598, "epsg", 2598,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger CM 69E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=69 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
		   "ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0");
    add_proj4text (p, 2, ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 69E\",G");
    add_srs_wkt (p, 1,
		 "EOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"");
    add_srs_wkt (p, 2,
		 "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
		 "4\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AU");
    add_srs_wkt (p, 4,
		 "THORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 5,
		 "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 6,
		 "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 7,
		 "284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",6");
    add_srs_wkt (p, 9,
		 "9],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
		 "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 11,
		 "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AX");
    add_srs_wkt (p, 12, "IS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2598\"]]");
    p = add_epsg_def (filter, first, last, 2599, "epsg", 2599,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger CM 72E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=72 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
		   "ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0");
    add_proj4text (p, 2, ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 72E\",G");
    add_srs_wkt (p, 1,
		 "EOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"");
    add_srs_wkt (p, 2,
		 "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
		 "4\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AU");
    add_srs_wkt (p, 4,
		 "THORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 5,
		 "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 6,
		 "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 7,
		 "284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",7");
    add_srs_wkt (p, 9,
		 "2],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
		 "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 11,
		 "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AX");
    add_srs_wkt (p, 12, "IS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2599\"]]");
    p = add_epsg_def (filter, first, last, 2600, "epsg", 2600,
		      "Lietuvos Koordinoei Sistema 1994 (deprecated)");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=24 +k=0.9998 +x_0=500000 +y_");
    add_proj4text (p, 1,
		   "0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 2, "s");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Lietuvos Koordinoei Sistema 1994 (deprecated)\"");
    add_srs_wkt (p, 1,
		 ",GEOGCS[\"LKS94\",DATUM[\"Lithuania_1994_ETRS89\",SPHERO");
    add_srs_wkt (p, 2,
		 "ID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
		 ",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
		 "6126\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
		 "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
		 "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4669\"]],PROJECTION[");
    add_srs_wkt (p, 7,
		 "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
		 ",0],PARAMETER[\"central_meridian\",24],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
		 "_factor\",0.9998],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 10,
		 "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
		 "[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],");
    add_srs_wkt (p, 12, "AUTHORITY[\"EPSG\",\"2600\"]]");
    p = add_epsg_def (filter, first, last, 2601, "epsg", 2601,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger CM 75E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
		   "ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0");
    add_proj4text (p, 2, ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 75E\",G");
    add_srs_wkt (p, 1,
		 "EOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"");
    add_srs_wkt (p, 2,
		 "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
		 "4\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AU");
    add_srs_wkt (p, 4,
		 "THORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 5,
		 "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 6,
		 "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 7,
		 "284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",7");
    add_srs_wkt (p, 9,
		 "5],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
		 "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 11,
		 "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AX");
    add_srs_wkt (p, 12, "IS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2601\"]]");
    p = add_epsg_def (filter, first, last, 2602, "epsg", 2602,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger CM 78E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=78 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
		   "ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0");
    add_proj4text (p, 2, ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 78E\",G");
    add_srs_wkt (p, 1,
		 "EOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"");
    add_srs_wkt (p, 2,
		 "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
		 "4\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AU");
    add_srs_wkt (p, 4,
		 "THORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 5,
		 "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 6,
		 "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 7,
		 "284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",7");
    add_srs_wkt (p, 9,
		 "8],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
		 "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 11,
		 "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AX");
    add_srs_wkt (p, 12, "IS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2602\"]]");
    p = add_epsg_def (filter, first, last, 2603, "epsg", 2603,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger CM 81E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
		   "ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0");
    add_proj4text (p, 2, ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 81E\",G");
    add_srs_wkt (p, 1,
		 "EOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"");
    add_srs_wkt (p, 2,
		 "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
		 "4\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AU");
    add_srs_wkt (p, 4,
		 "THORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 5,
		 "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 6,
		 "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 7,
		 "284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",8");
    add_srs_wkt (p, 9,
		 "1],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
		 "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 11,
		 "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AX");
    add_srs_wkt (p, 12, "IS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2603\"]]");
    p = add_epsg_def (filter, first, last, 2604, "epsg", 2604,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger CM 84E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=84 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
		   "ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0");
    add_proj4text (p, 2, ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 84E\",G");
    add_srs_wkt (p, 1,
		 "EOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"");
    add_srs_wkt (p, 2,
		 "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
		 "4\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AU");
    add_srs_wkt (p, 4,
		 "THORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 5,
		 "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 6,
		 "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 7,
		 "284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",8");
    add_srs_wkt (p, 9,
		 "4],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
		 "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 11,
		 "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AX");
    add_srs_wkt (p, 12, "IS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2604\"]]");
    p = add_epsg_def (filter, first, last, 2605, "epsg", 2605,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger CM 87E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
		   "ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0");
    add_proj4text (p, 2, ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 87E\",G");
    add_srs_wkt (p, 1,
		 "EOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"");
    add_srs_wkt (p, 2,
		 "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
		 "4\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AU");
    add_srs_wkt (p, 4,
		 "THORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 5,
		 "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 6,
		 "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 7,
		 "284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",8");
    add_srs_wkt (p, 9,
		 "7],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
		 "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 11,
		 "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AX");
    add_srs_wkt (p, 12, "IS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2605\"]]");
    p = add_epsg_def (filter, first, last, 2606, "epsg", 2606,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger CM 90E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=90 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
		   "ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0");
    add_proj4text (p, 2, ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 90E\",G");
    add_srs_wkt (p, 1,
		 "EOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"");
    add_srs_wkt (p, 2,
		 "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
		 "4\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AU");
    add_srs_wkt (p, 4,
		 "THORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 5,
		 "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 6,
		 "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 7,
		 "284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",9");
    add_srs_wkt (p, 9,
		 "0],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
		 "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 11,
		 "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AX");
    add_srs_wkt (p, 12, "IS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2606\"]]");
    p = add_epsg_def (filter, first, last, 2607, "epsg", 2607,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger CM 93E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
		   "ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0");
    add_proj4text (p, 2, ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 93E\",G");
    add_srs_wkt (p, 1,
		 "EOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"");
    add_srs_wkt (p, 2,
		 "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
		 "4\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AU");
    add_srs_wkt (p, 4,
		 "THORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 5,
		 "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 6,
		 "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 7,
		 "284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",9");
    add_srs_wkt (p, 9,
		 "3],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
		 "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 11,
		 "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AX");
    add_srs_wkt (p, 12, "IS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2607\"]]");
    p = add_epsg_def (filter, first, last, 2608, "epsg", 2608,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger CM 96E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=96 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
		   "ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0");
    add_proj4text (p, 2, ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 96E\",G");
    add_srs_wkt (p, 1,
		 "EOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"");
    add_srs_wkt (p, 2,
		 "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
		 "4\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AU");
    add_srs_wkt (p, 4,
		 "THORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 5,
		 "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 6,
		 "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 7,
		 "284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",9");
    add_srs_wkt (p, 9,
		 "6],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
		 "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 11,
		 "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AX");
    add_srs_wkt (p, 12, "IS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2608\"]]");
    p = add_epsg_def (filter, first, last, 2609, "epsg", 2609,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger CM 99E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
		   "ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0");
    add_proj4text (p, 2, ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 99E\",G");
    add_srs_wkt (p, 1,
		 "EOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"");
    add_srs_wkt (p, 2,
		 "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
		 "4\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AU");
    add_srs_wkt (p, 4,
		 "THORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 5,
		 "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 6,
		 "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 7,
		 "284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",9");
    add_srs_wkt (p, 9,
		 "9],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
		 "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 11,
		 "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AX");
    add_srs_wkt (p, 12, "IS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2609\"]]");
    p = add_epsg_def (filter, first, last, 2610, "epsg", 2610,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger CM 102E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=102 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
		   "+ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-");
    add_proj4text (p, 2, "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 102E\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
		 "02],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
		 "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 11,
		 "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],A");
    add_srs_wkt (p, 12, "XIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2610\"]]");
    p = add_epsg_def (filter, first, last, 2611, "epsg", 2611,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger CM 105E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
		   "+ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-");
    add_proj4text (p, 2, "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 105E\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
		 "05],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
		 "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 11,
		 "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],A");
    add_srs_wkt (p, 12, "XIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2611\"]]");
    p = add_epsg_def (filter, first, last, 2612, "epsg", 2612,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger CM 108E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=108 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
		   "+ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-");
    add_proj4text (p, 2, "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 108E\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
		 "08],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
		 "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 11,
		 "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],A");
    add_srs_wkt (p, 12, "XIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2612\"]]");
    p = add_epsg_def (filter, first, last, 2613, "epsg", 2613,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger CM 111E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
		   "+ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-");
    add_proj4text (p, 2, "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 111E\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
		 "11],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
		 "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 11,
		 "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],A");
    add_srs_wkt (p, 12, "XIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2613\"]]");
    p = add_epsg_def (filter, first, last, 2614, "epsg", 2614,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger CM 114E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=114 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
		   "+ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-");
    add_proj4text (p, 2, "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 114E\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
		 "14],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
		 "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 11,
		 "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],A");
    add_srs_wkt (p, 12, "XIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2614\"]]");
    p = add_epsg_def (filter, first, last, 2615, "epsg", 2615,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger CM 117E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
		   "+ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-");
    add_proj4text (p, 2, "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 117E\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
		 "17],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
		 "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 11,
		 "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],A");
    add_srs_wkt (p, 12, "XIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2615\"]]");
    p = add_epsg_def (filter, first, last, 2616, "epsg", 2616,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger CM 120E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=120 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
		   "+ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-");
    add_proj4text (p, 2, "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 120E\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
		 "20],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
		 "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 11,
		 "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],A");
    add_srs_wkt (p, 12, "XIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2616\"]]");
    p = add_epsg_def (filter, first, last, 2617, "epsg", 2617,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger CM 123E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
		   "+ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-");
    add_proj4text (p, 2, "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 123E\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
		 "23],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
		 "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 11,
		 "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],A");
    add_srs_wkt (p, 12, "XIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2617\"]]");
    p = add_epsg_def (filter, first, last, 2618, "epsg", 2618,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger CM 126E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=126 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
		   "+ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-");
    add_proj4text (p, 2, "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 126E\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
		 "26],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
		 "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 11,
		 "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],A");
    add_srs_wkt (p, 12, "XIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2618\"]]");
    p = add_epsg_def (filter, first, last, 2619, "epsg", 2619,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger CM 129E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
		   "+ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-");
    add_proj4text (p, 2, "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 129E\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
		 "29],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
		 "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 11,
		 "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],A");
    add_srs_wkt (p, 12, "XIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2619\"]]");
    p = add_epsg_def (filter, first, last, 2620, "epsg", 2620,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger CM 132E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=132 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
		   "+ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-");
    add_proj4text (p, 2, "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 132E\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
		 "32],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
		 "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 11,
		 "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],A");
    add_srs_wkt (p, 12, "XIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2620\"]]");
    p = add_epsg_def (filter, first, last, 2621, "epsg", 2621,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger CM 135E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
		   "+ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-");
    add_proj4text (p, 2, "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 135E\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
		 "35],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
		 "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 11,
		 "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],A");
    add_srs_wkt (p, 12, "XIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2621\"]]");
    p = add_epsg_def (filter, first, last, 2622, "epsg", 2622,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger CM 138E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=138 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
		   "+ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-");
    add_proj4text (p, 2, "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 138E\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
		 "38],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
		 "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 11,
		 "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],A");
    add_srs_wkt (p, 12, "XIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2622\"]]");
    p = add_epsg_def (filter, first, last, 2623, "epsg", 2623,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger CM 141E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=141 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
		   "+ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-");
    add_proj4text (p, 2, "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 141E\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
		 "41],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
		 "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 11,
		 "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],A");
    add_srs_wkt (p, 12, "XIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2623\"]]");
    p = add_epsg_def (filter, first, last, 2624, "epsg", 2624,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger CM 144E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=144 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
		   "+ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-");
    add_proj4text (p, 2, "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 144E\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
		 "44],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
		 "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 11,
		 "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],A");
    add_srs_wkt (p, 12, "XIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2624\"]]");
    p = add_epsg_def (filter, first, last, 2625, "epsg", 2625,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger CM 147E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=147 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
		   "+ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-");
    add_proj4text (p, 2, "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 147E\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
		 "47],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
		 "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 11,
		 "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],A");
    add_srs_wkt (p, 12, "XIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2625\"]]");
    p = add_epsg_def (filter, first, last, 2626, "epsg", 2626,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger CM 150E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=150 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
		   "+ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-");
    add_proj4text (p, 2, "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 150E\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
		 "50],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
		 "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 11,
		 "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],A");
    add_srs_wkt (p, 12, "XIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2626\"]]");
    p = add_epsg_def (filter, first, last, 2627, "epsg", 2627,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger CM 153E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=153 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
		   "+ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-");
    add_proj4text (p, 2, "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 153E\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
		 "53],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
		 "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 11,
		 "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],A");
    add_srs_wkt (p, 12, "XIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2627\"]]");
}

static void
initialize_epsg_06 (int filter, struct epsg_defs **first,
		    struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def (filter, first, last, 2628, "epsg", 2628,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger CM 156E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=156 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
		   "+ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-");
    add_proj4text (p, 2, "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 156E\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
		 "56],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
		 "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 11,
		 "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],A");
    add_srs_wkt (p, 12, "XIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2628\"]]");
    p = add_epsg_def (filter, first, last, 2629, "epsg", 2629,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger CM 159E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=159 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
		   "+ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-");
    add_proj4text (p, 2, "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 159E\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
		 "59],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
		 "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 11,
		 "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],A");
    add_srs_wkt (p, 12, "XIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2629\"]]");
    p = add_epsg_def (filter, first, last, 2630, "epsg", 2630,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger CM 162E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=162 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
		   "+ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-");
    add_proj4text (p, 2, "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 162E\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
		 "62],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
		 "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 11,
		 "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],A");
    add_srs_wkt (p, 12, "XIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2630\"]]");
    p = add_epsg_def (filter, first, last, 2631, "epsg", 2631,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger CM 165E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=165 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
		   "+ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-");
    add_proj4text (p, 2, "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 165E\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
		 "65],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
		 "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 11,
		 "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],A");
    add_srs_wkt (p, 12, "XIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2631\"]]");
    p = add_epsg_def (filter, first, last, 2632, "epsg", 2632,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger CM 168E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=168 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
		   "+ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-");
    add_proj4text (p, 2, "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 168E\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
		 "68],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
		 "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 11,
		 "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],A");
    add_srs_wkt (p, 12, "XIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2632\"]]");
    p = add_epsg_def (filter, first, last, 2633, "epsg", 2633,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger CM 171E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=171 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
		   "+ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-");
    add_proj4text (p, 2, "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 171E\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
		 "71],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
		 "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 11,
		 "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],A");
    add_srs_wkt (p, 12, "XIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2633\"]]");
    p = add_epsg_def (filter, first, last, 2634, "epsg", 2634,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger CM 174E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=174 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
		   "+ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-");
    add_proj4text (p, 2, "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 174E\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
		 "74],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
		 "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 11,
		 "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],A");
    add_srs_wkt (p, 12, "XIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2634\"]]");
    p = add_epsg_def (filter, first, last, 2635, "epsg", 2635,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger CM 177E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=177 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
		   "+ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-");
    add_proj4text (p, 2, "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 177E\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
		 "77],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
		 "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 11,
		 "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],A");
    add_srs_wkt (p, 12, "XIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2635\"]]");
    p = add_epsg_def (filter, first, last, 2636, "epsg", 2636,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger CM 180E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=180 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
		   "+ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-");
    add_proj4text (p, 2, "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 180E\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
		 "80],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
		 "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 11,
		 "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],A");
    add_srs_wkt (p, 12, "XIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2636\"]]");
    p = add_epsg_def (filter, first, last, 2637, "epsg", 2637,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger CM 177W");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=-177 +k=1 +x_0=500000 +y_0=0");
    add_proj4text (p, 1,
		   " +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,");
    add_proj4text (p, 2, "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 177W\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 9,
		 "177],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eas");
    add_srs_wkt (p, 10,
		 "ting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
		 "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],");
    add_srs_wkt (p, 12, "AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2637\"]]");
    p = add_epsg_def (filter, first, last, 2638, "epsg", 2638,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger CM 174W");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=-174 +k=1 +x_0=500000 +y_0=0");
    add_proj4text (p, 1,
		   " +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,");
    add_proj4text (p, 2, "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 174W\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 9,
		 "174],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eas");
    add_srs_wkt (p, 10,
		 "ting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
		 "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],");
    add_srs_wkt (p, 12, "AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2638\"]]");
    p = add_epsg_def (filter, first, last, 2639, "epsg", 2639,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger CM 171W");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=-171 +k=1 +x_0=500000 +y_0=0");
    add_proj4text (p, 1,
		   " +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,");
    add_proj4text (p, 2, "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 171W\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 9,
		 "171],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eas");
    add_srs_wkt (p, 10,
		 "ting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
		 "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],");
    add_srs_wkt (p, 12, "AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2639\"]]");
    p = add_epsg_def (filter, first, last, 2640, "epsg", 2640,
		      "Pulkovo 1942 / 3-degree Gauss-Kruger CM 168W");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=-168 +k=1 +x_0=500000 +y_0=0");
    add_proj4text (p, 1,
		   " +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,");
    add_proj4text (p, 2, "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 168W\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
		 "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
		 "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
		 "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 9,
		 "168],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eas");
    add_srs_wkt (p, 10,
		 "ting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
		 "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],");
    add_srs_wkt (p, 12, "AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2640\"]]");
    p = add_epsg_def (filter, first, last, 2641, "epsg", 2641,
		      "Pulkovo 1995 / 3-degree Gauss-Kruger zone 7");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=7500000 +y_0=0 ");
    add_proj4text (p, 1,
		   "+ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0");
    add_proj4text (p, 2, ".22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger zone 7\",G");
    add_srs_wkt (p, 1,
		 "EOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"");
    add_srs_wkt (p, 2,
		 "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
		 "4\"]],TOWGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],AUT");
    add_srs_wkt (p, 4,
		 "HORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
		 "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
		 "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 7,
		 "00\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
		 "atitude_of_origin\",0],PARAMETER[\"central_meridian\",21");
    add_srs_wkt (p, 9,
		 "],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
		 "g\",7500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 11,
		 "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AX");
    add_srs_wkt (p, 12, "IS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2641\"]]");
    p = add_epsg_def (filter, first, last, 2642, "epsg", 2642,
		      "Pulkovo 1995 / 3-degree Gauss-Kruger zone 8");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=24 +k=1 +x_0=8500000 +y_0=0 ");
    add_proj4text (p, 1,
		   "+ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0");
    add_proj4text (p, 2, ".22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger zone 8\",G");
    add_srs_wkt (p, 1,
		 "EOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"");
    add_srs_wkt (p, 2,
		 "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
		 "4\"]],TOWGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],AUT");
    add_srs_wkt (p, 4,
		 "HORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
		 "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
		 "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 7,
		 "00\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
		 "atitude_of_origin\",0],PARAMETER[\"central_meridian\",24");
    add_srs_wkt (p, 9,
		 "],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
		 "g\",8500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 11,
		 "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AX");
    add_srs_wkt (p, 12, "IS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2642\"]]");
    p = add_epsg_def (filter, first, last, 2643, "epsg", 2643,
		      "Pulkovo 1995 / 3-degree Gauss-Kruger zone 9");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=9500000 +y_0=0 ");
    add_proj4text (p, 1,
		   "+ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0");
    add_proj4text (p, 2, ".22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger zone 9\",G");
    add_srs_wkt (p, 1,
		 "EOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"");
    add_srs_wkt (p, 2,
		 "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
		 "4\"]],TOWGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],AUT");
    add_srs_wkt (p, 4,
		 "HORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
		 "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
		 "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 7,
		 "00\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
		 "atitude_of_origin\",0],PARAMETER[\"central_meridian\",27");
    add_srs_wkt (p, 9,
		 "],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
		 "g\",9500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 11,
		 "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AX");
    add_srs_wkt (p, 12, "IS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2643\"]]");
    p = add_epsg_def (filter, first, last, 2644, "epsg", 2644,
		      "Pulkovo 1995 / 3-degree Gauss-Kruger zone 10");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=30 +k=1 +x_0=10500000 +y_0=0");
    add_proj4text (p, 1,
		   " +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-");
    add_proj4text (p, 2, "0.22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger zone 10\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],A");
    add_srs_wkt (p, 4,
		 "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
		 "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
		 "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",3");
    add_srs_wkt (p, 9,
		 "0],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
		 "ng\",10500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
		 "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],");
    add_srs_wkt (p, 12, "AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2644\"]]");
    p = add_epsg_def (filter, first, last, 2645, "epsg", 2645,
		      "Pulkovo 1995 / 3-degree Gauss-Kruger zone 11");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=11500000 +y_0=0");
    add_proj4text (p, 1,
		   " +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-");
    add_proj4text (p, 2, "0.22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger zone 11\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],A");
    add_srs_wkt (p, 4,
		 "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
		 "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
		 "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",3");
    add_srs_wkt (p, 9,
		 "3],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
		 "ng\",11500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
		 "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],");
    add_srs_wkt (p, 12, "AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2645\"]]");
    p = add_epsg_def (filter, first, last, 2646, "epsg", 2646,
		      "Pulkovo 1995 / 3-degree Gauss-Kruger zone 12");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=36 +k=1 +x_0=12500000 +y_0=0");
    add_proj4text (p, 1,
		   " +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-");
    add_proj4text (p, 2, "0.22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger zone 12\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],A");
    add_srs_wkt (p, 4,
		 "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
		 "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
		 "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",3");
    add_srs_wkt (p, 9,
		 "6],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
		 "ng\",12500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
		 "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],");
    add_srs_wkt (p, 12, "AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2646\"]]");
    p = add_epsg_def (filter, first, last, 2647, "epsg", 2647,
		      "Pulkovo 1995 / 3-degree Gauss-Kruger zone 13");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=13500000 +y_0=0");
    add_proj4text (p, 1,
		   " +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-");
    add_proj4text (p, 2, "0.22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger zone 13\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],A");
    add_srs_wkt (p, 4,
		 "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
		 "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
		 "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",3");
    add_srs_wkt (p, 9,
		 "9],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
		 "ng\",13500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
		 "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],");
    add_srs_wkt (p, 12, "AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2647\"]]");
    p = add_epsg_def (filter, first, last, 2648, "epsg", 2648,
		      "Pulkovo 1995 / 3-degree Gauss-Kruger zone 14");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=42 +k=1 +x_0=14500000 +y_0=0");
    add_proj4text (p, 1,
		   " +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-");
    add_proj4text (p, 2, "0.22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger zone 14\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],A");
    add_srs_wkt (p, 4,
		 "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
		 "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
		 "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",4");
    add_srs_wkt (p, 9,
		 "2],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
		 "ng\",14500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
		 "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],");
    add_srs_wkt (p, 12, "AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2648\"]]");
    p = add_epsg_def (filter, first, last, 2649, "epsg", 2649,
		      "Pulkovo 1995 / 3-degree Gauss-Kruger zone 15");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=15500000 +y_0=0");
    add_proj4text (p, 1,
		   " +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-");
    add_proj4text (p, 2, "0.22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger zone 15\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],A");
    add_srs_wkt (p, 4,
		 "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
		 "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
		 "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",4");
    add_srs_wkt (p, 9,
		 "5],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
		 "ng\",15500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
		 "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],");
    add_srs_wkt (p, 12, "AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2649\"]]");
    p = add_epsg_def (filter, first, last, 2650, "epsg", 2650,
		      "Pulkovo 1995 / 3-degree Gauss-Kruger zone 16");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=48 +k=1 +x_0=16500000 +y_0=0");
    add_proj4text (p, 1,
		   " +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-");
    add_proj4text (p, 2, "0.22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger zone 16\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],A");
    add_srs_wkt (p, 4,
		 "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
		 "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
		 "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",4");
    add_srs_wkt (p, 9,
		 "8],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
		 "ng\",16500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
		 "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],");
    add_srs_wkt (p, 12, "AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2650\"]]");
    p = add_epsg_def (filter, first, last, 2651, "epsg", 2651,
		      "Pulkovo 1995 / 3-degree Gauss-Kruger zone 17");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=51 +k=1 +x_0=17500000 +y_0=0");
    add_proj4text (p, 1,
		   " +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-");
    add_proj4text (p, 2, "0.22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger zone 17\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],A");
    add_srs_wkt (p, 4,
		 "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
		 "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
		 "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",5");
    add_srs_wkt (p, 9,
		 "1],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
		 "ng\",17500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
		 "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],");
    add_srs_wkt (p, 12, "AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2651\"]]");
    p = add_epsg_def (filter, first, last, 2652, "epsg", 2652,
		      "Pulkovo 1995 / 3-degree Gauss-Kruger zone 18");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=54 +k=1 +x_0=18500000 +y_0=0");
    add_proj4text (p, 1,
		   " +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-");
    add_proj4text (p, 2, "0.22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger zone 18\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],A");
    add_srs_wkt (p, 4,
		 "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
		 "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
		 "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",5");
    add_srs_wkt (p, 9,
		 "4],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
		 "ng\",18500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
		 "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],");
    add_srs_wkt (p, 12, "AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2652\"]]");
    p = add_epsg_def (filter, first, last, 2653, "epsg", 2653,
		      "Pulkovo 1995 / 3-degree Gauss-Kruger zone 19");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=57 +k=1 +x_0=19500000 +y_0=0");
    add_proj4text (p, 1,
		   " +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-");
    add_proj4text (p, 2, "0.22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger zone 19\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],A");
    add_srs_wkt (p, 4,
		 "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
		 "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
		 "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",5");
    add_srs_wkt (p, 9,
		 "7],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
		 "ng\",19500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
		 "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],");
    add_srs_wkt (p, 12, "AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2653\"]]");
    p = add_epsg_def (filter, first, last, 2654, "epsg", 2654,
		      "Pulkovo 1995 / 3-degree Gauss-Kruger zone 20");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=60 +k=1 +x_0=20500000 +y_0=0");
    add_proj4text (p, 1,
		   " +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-");
    add_proj4text (p, 2, "0.22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger zone 20\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],A");
    add_srs_wkt (p, 4,
		 "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
		 "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
		 "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",6");
    add_srs_wkt (p, 9,
		 "0],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
		 "ng\",20500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
		 "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],");
    add_srs_wkt (p, 12, "AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2654\"]]");
    p = add_epsg_def (filter, first, last, 2655, "epsg", 2655,
		      "Pulkovo 1995 / 3-degree Gauss-Kruger zone 21");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=63 +k=1 +x_0=21500000 +y_0=0");
    add_proj4text (p, 1,
		   " +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-");
    add_proj4text (p, 2, "0.22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger zone 21\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],A");
    add_srs_wkt (p, 4,
		 "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
		 "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
		 "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",6");
    add_srs_wkt (p, 9,
		 "3],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
		 "ng\",21500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
		 "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],");
    add_srs_wkt (p, 12, "AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2655\"]]");
    p = add_epsg_def (filter, first, last, 2656, "epsg", 2656,
		      "Pulkovo 1995 / 3-degree Gauss-Kruger zone 22");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=66 +k=1 +x_0=22500000 +y_0=0");
    add_proj4text (p, 1,
		   " +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-");
    add_proj4text (p, 2, "0.22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger zone 22\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],A");
    add_srs_wkt (p, 4,
		 "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
		 "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
		 "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",6");
    add_srs_wkt (p, 9,
		 "6],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
		 "ng\",22500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
		 "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],");
    add_srs_wkt (p, 12, "AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2656\"]]");
    p = add_epsg_def (filter, first, last, 2657, "epsg", 2657,
		      "Pulkovo 1995 / 3-degree Gauss-Kruger zone 23");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=69 +k=1 +x_0=23500000 +y_0=0");
    add_proj4text (p, 1,
		   " +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-");
    add_proj4text (p, 2, "0.22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger zone 23\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],A");
    add_srs_wkt (p, 4,
		 "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
		 "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
		 "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",6");
    add_srs_wkt (p, 9,
		 "9],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
		 "ng\",23500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
		 "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],");
    add_srs_wkt (p, 12, "AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2657\"]]");
    p = add_epsg_def (filter, first, last, 2658, "epsg", 2658,
		      "Pulkovo 1995 / 3-degree Gauss-Kruger zone 24");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=72 +k=1 +x_0=24500000 +y_0=0");
    add_proj4text (p, 1,
		   " +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-");
    add_proj4text (p, 2, "0.22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger zone 24\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],A");
    add_srs_wkt (p, 4,
		 "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
		 "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
		 "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",7");
    add_srs_wkt (p, 9,
		 "2],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
		 "ng\",24500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
		 "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],");
    add_srs_wkt (p, 12, "AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2658\"]]");
    p = add_epsg_def (filter, first, last, 2659, "epsg", 2659,
		      "Pulkovo 1995 / 3-degree Gauss-Kruger zone 25");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=25500000 +y_0=0");
    add_proj4text (p, 1,
		   " +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-");
    add_proj4text (p, 2, "0.22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger zone 25\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],A");
    add_srs_wkt (p, 4,
		 "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
		 "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
		 "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",7");
    add_srs_wkt (p, 9,
		 "5],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
		 "ng\",25500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
		 "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],");
    add_srs_wkt (p, 12, "AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2659\"]]");
    p = add_epsg_def (filter, first, last, 2660, "epsg", 2660,
		      "Pulkovo 1995 / 3-degree Gauss-Kruger zone 26");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=78 +k=1 +x_0=26500000 +y_0=0");
    add_proj4text (p, 1,
		   " +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-");
    add_proj4text (p, 2, "0.22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger zone 26\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],A");
    add_srs_wkt (p, 4,
		 "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
		 "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
		 "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",7");
    add_srs_wkt (p, 9,
		 "8],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
		 "ng\",26500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
		 "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],");
    add_srs_wkt (p, 12, "AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2660\"]]");
    p = add_epsg_def (filter, first, last, 2661, "epsg", 2661,
		      "Pulkovo 1995 / 3-degree Gauss-Kruger zone 27");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=27500000 +y_0=0");
    add_proj4text (p, 1,
		   " +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-");
    add_proj4text (p, 2, "0.22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger zone 27\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],A");
    add_srs_wkt (p, 4,
		 "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
		 "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
		 "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",8");
    add_srs_wkt (p, 9,
		 "1],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
		 "ng\",27500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
		 "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],");
    add_srs_wkt (p, 12, "AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2661\"]]");
    p = add_epsg_def (filter, first, last, 2662, "epsg", 2662,
		      "Pulkovo 1995 / 3-degree Gauss-Kruger zone 28");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=84 +k=1 +x_0=28500000 +y_0=0");
    add_proj4text (p, 1,
		   " +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-");
    add_proj4text (p, 2, "0.22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger zone 28\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],A");
    add_srs_wkt (p, 4,
		 "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
		 "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
		 "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",8");
    add_srs_wkt (p, 9,
		 "4],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
		 "ng\",28500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
		 "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],");
    add_srs_wkt (p, 12, "AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2662\"]]");
    p = add_epsg_def (filter, first, last, 2663, "epsg", 2663,
		      "Pulkovo 1995 / 3-degree Gauss-Kruger zone 29");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=29500000 +y_0=0");
    add_proj4text (p, 1,
		   " +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-");
    add_proj4text (p, 2, "0.22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger zone 29\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],A");
    add_srs_wkt (p, 4,
		 "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
		 "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
		 "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",8");
    add_srs_wkt (p, 9,
		 "7],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
		 "ng\",29500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
		 "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],");
    add_srs_wkt (p, 12, "AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2663\"]]");
    p = add_epsg_def (filter, first, last, 2664, "epsg", 2664,
		      "Pulkovo 1995 / 3-degree Gauss-Kruger zone 30");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=90 +k=1 +x_0=30500000 +y_0=0");
    add_proj4text (p, 1,
		   " +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-");
    add_proj4text (p, 2, "0.22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger zone 30\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],A");
    add_srs_wkt (p, 4,
		 "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
		 "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
		 "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",9");
    add_srs_wkt (p, 9,
		 "0],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
		 "ng\",30500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
		 "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],");
    add_srs_wkt (p, 12, "AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2664\"]]");
    p = add_epsg_def (filter, first, last, 2665, "epsg", 2665,
		      "Pulkovo 1995 / 3-degree Gauss-Kruger zone 31");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=31500000 +y_0=0");
    add_proj4text (p, 1,
		   " +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-");
    add_proj4text (p, 2, "0.22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger zone 31\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],A");
    add_srs_wkt (p, 4,
		 "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
		 "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
		 "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",9");
    add_srs_wkt (p, 9,
		 "3],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
		 "ng\",31500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
		 "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],");
    add_srs_wkt (p, 12, "AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2665\"]]");
    p = add_epsg_def (filter, first, last, 2666, "epsg", 2666,
		      "Pulkovo 1995 / 3-degree Gauss-Kruger zone 32");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=96 +k=1 +x_0=32500000 +y_0=0");
    add_proj4text (p, 1,
		   " +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-");
    add_proj4text (p, 2, "0.22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger zone 32\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],A");
    add_srs_wkt (p, 4,
		 "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
		 "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
		 "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",9");
    add_srs_wkt (p, 9,
		 "6],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
		 "ng\",32500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
		 "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],");
    add_srs_wkt (p, 12, "AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2666\"]]");
    p = add_epsg_def (filter, first, last, 2667, "epsg", 2667,
		      "Pulkovo 1995 / 3-degree Gauss-Kruger zone 33");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=33500000 +y_0=0");
    add_proj4text (p, 1,
		   " +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-");
    add_proj4text (p, 2, "0.22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger zone 33\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],A");
    add_srs_wkt (p, 4,
		 "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
		 "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
		 "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",9");
    add_srs_wkt (p, 9,
		 "9],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
		 "ng\",33500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
		 "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],");
    add_srs_wkt (p, 12, "AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2667\"]]");
    p = add_epsg_def (filter, first, last, 2668, "epsg", 2668,
		      "Pulkovo 1995 / 3-degree Gauss-Kruger zone 34");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=102 +k=1 +x_0=34500000 +y_0=");
    add_proj4text (p, 1,
		   "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,");
    add_proj4text (p, 2, "-0.22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger zone 34\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],A");
    add_srs_wkt (p, 4,
		 "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
		 "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
		 "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
		 "02],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
		 "ing\",34500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
		 "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH]");
    add_srs_wkt (p, 12, ",AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2668\"]]");
    p = add_epsg_def (filter, first, last, 2669, "epsg", 2669,
		      "Pulkovo 1995 / 3-degree Gauss-Kruger zone 35");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=35500000 +y_0=");
    add_proj4text (p, 1,
		   "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,");
    add_proj4text (p, 2, "-0.22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger zone 35\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],A");
    add_srs_wkt (p, 4,
		 "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
		 "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
		 "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
		 "05],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
		 "ing\",35500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
		 "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH]");
    add_srs_wkt (p, 12, ",AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2669\"]]");
    p = add_epsg_def (filter, first, last, 2670, "epsg", 2670,
		      "Pulkovo 1995 / 3-degree Gauss-Kruger zone 36");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=108 +k=1 +x_0=36500000 +y_0=");
    add_proj4text (p, 1,
		   "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,");
    add_proj4text (p, 2, "-0.22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger zone 36\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],A");
    add_srs_wkt (p, 4,
		 "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
		 "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
		 "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
		 "08],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
		 "ing\",36500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
		 "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH]");
    add_srs_wkt (p, 12, ",AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2670\"]]");
    p = add_epsg_def (filter, first, last, 2671, "epsg", 2671,
		      "Pulkovo 1995 / 3-degree Gauss-Kruger zone 37");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=37500000 +y_0=");
    add_proj4text (p, 1,
		   "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,");
    add_proj4text (p, 2, "-0.22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger zone 37\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],A");
    add_srs_wkt (p, 4,
		 "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
		 "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
		 "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
		 "11],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
		 "ing\",37500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
		 "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH]");
    add_srs_wkt (p, 12, ",AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2671\"]]");
    p = add_epsg_def (filter, first, last, 2672, "epsg", 2672,
		      "Pulkovo 1995 / 3-degree Gauss-Kruger zone 38");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=114 +k=1 +x_0=38500000 +y_0=");
    add_proj4text (p, 1,
		   "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,");
    add_proj4text (p, 2, "-0.22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger zone 38\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],A");
    add_srs_wkt (p, 4,
		 "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
		 "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
		 "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
		 "14],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
		 "ing\",38500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
		 "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH]");
    add_srs_wkt (p, 12, ",AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2672\"]]");
    p = add_epsg_def (filter, first, last, 2673, "epsg", 2673,
		      "Pulkovo 1995 / 3-degree Gauss-Kruger zone 39");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=39500000 +y_0=");
    add_proj4text (p, 1,
		   "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,");
    add_proj4text (p, 2, "-0.22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger zone 39\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],A");
    add_srs_wkt (p, 4,
		 "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
		 "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
		 "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
		 "17],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
		 "ing\",39500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
		 "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH]");
    add_srs_wkt (p, 12, ",AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2673\"]]");
    p = add_epsg_def (filter, first, last, 2674, "epsg", 2674,
		      "Pulkovo 1995 / 3-degree Gauss-Kruger zone 40");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=120 +k=1 +x_0=40500000 +y_0=");
    add_proj4text (p, 1,
		   "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,");
    add_proj4text (p, 2, "-0.22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger zone 40\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],A");
    add_srs_wkt (p, 4,
		 "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
		 "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
		 "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
		 "20],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
		 "ing\",40500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
		 "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH]");
    add_srs_wkt (p, 12, ",AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2674\"]]");
    p = add_epsg_def (filter, first, last, 2675, "epsg", 2675,
		      "Pulkovo 1995 / 3-degree Gauss-Kruger zone 41");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=41500000 +y_0=");
    add_proj4text (p, 1,
		   "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,");
    add_proj4text (p, 2, "-0.22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger zone 41\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],A");
    add_srs_wkt (p, 4,
		 "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
		 "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
		 "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
		 "23],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
		 "ing\",41500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
		 "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH]");
    add_srs_wkt (p, 12, ",AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2675\"]]");
    p = add_epsg_def (filter, first, last, 2676, "epsg", 2676,
		      "Pulkovo 1995 / 3-degree Gauss-Kruger zone 42");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=126 +k=1 +x_0=42500000 +y_0=");
    add_proj4text (p, 1,
		   "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,");
    add_proj4text (p, 2, "-0.22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger zone 42\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],A");
    add_srs_wkt (p, 4,
		 "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
		 "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
		 "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
		 "26],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
		 "ing\",42500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
		 "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH]");
    add_srs_wkt (p, 12, ",AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2676\"]]");
    p = add_epsg_def (filter, first, last, 2677, "epsg", 2677,
		      "Pulkovo 1995 / 3-degree Gauss-Kruger zone 43");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=43500000 +y_0=");
    add_proj4text (p, 1,
		   "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,");
    add_proj4text (p, 2, "-0.22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger zone 43\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],A");
    add_srs_wkt (p, 4,
		 "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
		 "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
		 "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
		 "29],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
		 "ing\",43500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
		 "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH]");
    add_srs_wkt (p, 12, ",AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2677\"]]");
    p = add_epsg_def (filter, first, last, 2678, "epsg", 2678,
		      "Pulkovo 1995 / 3-degree Gauss-Kruger zone 44");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=132 +k=1 +x_0=44500000 +y_0=");
    add_proj4text (p, 1,
		   "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,");
    add_proj4text (p, 2, "-0.22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger zone 44\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],A");
    add_srs_wkt (p, 4,
		 "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
		 "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
		 "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
		 "32],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
		 "ing\",44500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
		 "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH]");
    add_srs_wkt (p, 12, ",AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2678\"]]");
    p = add_epsg_def (filter, first, last, 2679, "epsg", 2679,
		      "Pulkovo 1995 / 3-degree Gauss-Kruger zone 45");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=45500000 +y_0=");
    add_proj4text (p, 1,
		   "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,");
    add_proj4text (p, 2, "-0.22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger zone 45\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],A");
    add_srs_wkt (p, 4,
		 "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
		 "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
		 "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
		 "35],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
		 "ing\",45500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
		 "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH]");
    add_srs_wkt (p, 12, ",AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2679\"]]");
    p = add_epsg_def (filter, first, last, 2680, "epsg", 2680,
		      "Pulkovo 1995 / 3-degree Gauss-Kruger zone 46");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=138 +k=1 +x_0=46500000 +y_0=");
    add_proj4text (p, 1,
		   "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,");
    add_proj4text (p, 2, "-0.22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger zone 46\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],A");
    add_srs_wkt (p, 4,
		 "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
		 "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
		 "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
		 "38],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
		 "ing\",46500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
		 "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH]");
    add_srs_wkt (p, 12, ",AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2680\"]]");
    p = add_epsg_def (filter, first, last, 2681, "epsg", 2681,
		      "Pulkovo 1995 / 3-degree Gauss-Kruger zone 47");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=141 +k=1 +x_0=47500000 +y_0=");
    add_proj4text (p, 1,
		   "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,");
    add_proj4text (p, 2, "-0.22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger zone 47\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],A");
    add_srs_wkt (p, 4,
		 "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
		 "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
		 "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
		 "41],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
		 "ing\",47500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
		 "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH]");
    add_srs_wkt (p, 12, ",AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2681\"]]");
    p = add_epsg_def (filter, first, last, 2682, "epsg", 2682,
		      "Pulkovo 1995 / 3-degree Gauss-Kruger zone 48");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=144 +k=1 +x_0=48500000 +y_0=");
    add_proj4text (p, 1,
		   "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,");
    add_proj4text (p, 2, "-0.22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger zone 48\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],A");
    add_srs_wkt (p, 4,
		 "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
		 "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
		 "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
		 "44],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
		 "ing\",48500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
		 "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH]");
    add_srs_wkt (p, 12, ",AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2682\"]]");
    p = add_epsg_def (filter, first, last, 2683, "epsg", 2683,
		      "Pulkovo 1995 / 3-degree Gauss-Kruger zone 49");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=147 +k=1 +x_0=49500000 +y_0=");
    add_proj4text (p, 1,
		   "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,");
    add_proj4text (p, 2, "-0.22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger zone 49\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],A");
    add_srs_wkt (p, 4,
		 "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
		 "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
		 "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
		 "47],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
		 "ing\",49500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
		 "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH]");
    add_srs_wkt (p, 12, ",AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2683\"]]");
    p = add_epsg_def (filter, first, last, 2684, "epsg", 2684,
		      "Pulkovo 1995 / 3-degree Gauss-Kruger zone 50");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=150 +k=1 +x_0=50500000 +y_0=");
    add_proj4text (p, 1,
		   "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,");
    add_proj4text (p, 2, "-0.22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger zone 50\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],A");
    add_srs_wkt (p, 4,
		 "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
		 "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
		 "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
		 "50],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
		 "ing\",50500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
		 "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH]");
    add_srs_wkt (p, 12, ",AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2684\"]]");
    p = add_epsg_def (filter, first, last, 2685, "epsg", 2685,
		      "Pulkovo 1995 / 3-degree Gauss-Kruger zone 51");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=153 +k=1 +x_0=51500000 +y_0=");
    add_proj4text (p, 1,
		   "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,");
    add_proj4text (p, 2, "-0.22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger zone 51\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],A");
    add_srs_wkt (p, 4,
		 "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
		 "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
		 "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
		 "53],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
		 "ing\",51500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
		 "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH]");
    add_srs_wkt (p, 12, ",AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2685\"]]");
    p = add_epsg_def (filter, first, last, 2686, "epsg", 2686,
		      "Pulkovo 1995 / 3-degree Gauss-Kruger zone 52");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=156 +k=1 +x_0=52500000 +y_0=");
    add_proj4text (p, 1,
		   "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,");
    add_proj4text (p, 2, "-0.22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger zone 52\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],A");
    add_srs_wkt (p, 4,
		 "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
		 "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
		 "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
		 "56],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
		 "ing\",52500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
		 "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH]");
    add_srs_wkt (p, 12, ",AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2686\"]]");
    p = add_epsg_def (filter, first, last, 2687, "epsg", 2687,
		      "Pulkovo 1995 / 3-degree Gauss-Kruger zone 53");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=159 +k=1 +x_0=53500000 +y_0=");
    add_proj4text (p, 1,
		   "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,");
    add_proj4text (p, 2, "-0.22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger zone 53\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],A");
    add_srs_wkt (p, 4,
		 "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
		 "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
		 "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
		 "59],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
		 "ing\",53500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
		 "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH]");
    add_srs_wkt (p, 12, ",AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2687\"]]");
    p = add_epsg_def (filter, first, last, 2688, "epsg", 2688,
		      "Pulkovo 1995 / 3-degree Gauss-Kruger zone 54");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=162 +k=1 +x_0=54500000 +y_0=");
    add_proj4text (p, 1,
		   "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,");
    add_proj4text (p, 2, "-0.22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger zone 54\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],A");
    add_srs_wkt (p, 4,
		 "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
		 "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
		 "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
		 "62],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
		 "ing\",54500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
		 "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH]");
    add_srs_wkt (p, 12, ",AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2688\"]]");
    p = add_epsg_def (filter, first, last, 2689, "epsg", 2689,
		      "Pulkovo 1995 / 3-degree Gauss-Kruger zone 55");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=165 +k=1 +x_0=55500000 +y_0=");
    add_proj4text (p, 1,
		   "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,");
    add_proj4text (p, 2, "-0.22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger zone 55\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],A");
    add_srs_wkt (p, 4,
		 "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
		 "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
		 "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
		 "65],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
		 "ing\",55500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
		 "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH]");
    add_srs_wkt (p, 12, ",AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2689\"]]");
    p = add_epsg_def (filter, first, last, 2690, "epsg", 2690,
		      "Pulkovo 1995 / 3-degree Gauss-Kruger zone 56");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=168 +k=1 +x_0=56500000 +y_0=");
    add_proj4text (p, 1,
		   "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,");
    add_proj4text (p, 2, "-0.22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger zone 56\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],A");
    add_srs_wkt (p, 4,
		 "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
		 "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
		 "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
		 "68],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
		 "ing\",56500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
		 "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH]");
    add_srs_wkt (p, 12, ",AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2690\"]]");
    p = add_epsg_def (filter, first, last, 2691, "epsg", 2691,
		      "Pulkovo 1995 / 3-degree Gauss-Kruger zone 57");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=171 +k=1 +x_0=57500000 +y_0=");
    add_proj4text (p, 1,
		   "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,");
    add_proj4text (p, 2, "-0.22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger zone 57\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],A");
    add_srs_wkt (p, 4,
		 "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
		 "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
		 "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
		 "71],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
		 "ing\",57500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
		 "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH]");
    add_srs_wkt (p, 12, ",AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2691\"]]");
    p = add_epsg_def (filter, first, last, 2692, "epsg", 2692,
		      "Pulkovo 1995 / 3-degree Gauss-Kruger zone 58");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=174 +k=1 +x_0=58500000 +y_0=");
    add_proj4text (p, 1,
		   "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,");
    add_proj4text (p, 2, "-0.22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger zone 58\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],A");
    add_srs_wkt (p, 4,
		 "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
		 "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
		 "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
		 "74],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
		 "ing\",58500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
		 "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH]");
    add_srs_wkt (p, 12, ",AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2692\"]]");
    p = add_epsg_def (filter, first, last, 2693, "epsg", 2693,
		      "Pulkovo 1995 / 3-degree Gauss-Kruger zone 59");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=177 +k=1 +x_0=59500000 +y_0=");
    add_proj4text (p, 1,
		   "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,");
    add_proj4text (p, 2, "-0.22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger zone 59\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],A");
    add_srs_wkt (p, 4,
		 "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
		 "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
		 "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
		 "77],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
		 "ing\",59500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
		 "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH]");
    add_srs_wkt (p, 12, ",AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2693\"]]");
    p = add_epsg_def (filter, first, last, 2694, "epsg", 2694,
		      "Pulkovo 1995 / 3-degree Gauss-Kruger zone 60 (deprecated)");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=180 +k=1 +x_0=60000000 +y_0=");
    add_proj4text (p, 1,
		   "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,");
    add_proj4text (p, 2, "-0.22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger zone 60 (d");
    add_srs_wkt (p, 1,
		 "eprecated)\",GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_199");
    add_srs_wkt (p, 2,
		 "5\",SPHEROID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY");
    add_srs_wkt (p, 3,
		 "[\"EPSG\",\"7024\"]],TOWGS84[24.47,-130.89,-81.56,-0,-0,");
    add_srs_wkt (p, 4,
		 "0.13,-0.22],AUTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 5,
		 "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 6,
		 ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 7,
		 "Y[\"EPSG\",\"4200\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 8,
		 "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 9,
		 "l_meridian\",180],PARAMETER[\"scale_factor\",1],PARAMETE");
    add_srs_wkt (p, 10,
		 "R[\"false_easting\",60000000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 11,
		 "\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 12,
		 "S[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"269");
    add_srs_wkt (p, 13, "4\"]]");
    p = add_epsg_def (filter, first, last, 2695, "epsg", 2695,
		      "Pulkovo 1995 / 3-degree Gauss-Kruger zone 61");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=-177 +k=1 +x_0=61500000 +y_0");
    add_proj4text (p, 1,
		   "=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13");
    add_proj4text (p, 2, ",-0.22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger zone 61\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],A");
    add_srs_wkt (p, 4,
		 "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
		 "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
		 "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 9,
		 "177],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eas");
    add_srs_wkt (p, 10,
		 "ting\",61500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 11,
		 "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH");
    add_srs_wkt (p, 12, "],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2695\"]]");
    p = add_epsg_def (filter, first, last, 2696, "epsg", 2696,
		      "Pulkovo 1995 / 3-degree Gauss-Kruger zone 62");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=-174 +k=1 +x_0=62500000 +y_0");
    add_proj4text (p, 1,
		   "=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13");
    add_proj4text (p, 2, ",-0.22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger zone 62\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],A");
    add_srs_wkt (p, 4,
		 "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
		 "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
		 "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 9,
		 "174],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eas");
    add_srs_wkt (p, 10,
		 "ting\",62500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 11,
		 "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH");
    add_srs_wkt (p, 12, "],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2696\"]]");
    p = add_epsg_def (filter, first, last, 2697, "epsg", 2697,
		      "Pulkovo 1995 / 3-degree Gauss-Kruger zone 63");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=-171 +k=1 +x_0=63500000 +y_0");
    add_proj4text (p, 1,
		   "=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13");
    add_proj4text (p, 2, ",-0.22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger zone 63\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],A");
    add_srs_wkt (p, 4,
		 "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
		 "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
		 "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 9,
		 "171],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eas");
    add_srs_wkt (p, 10,
		 "ting\",63500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 11,
		 "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH");
    add_srs_wkt (p, 12, "],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2697\"]]");
    p = add_epsg_def (filter, first, last, 2698, "epsg", 2698,
		      "Pulkovo 1995 / 3-degree Gauss-Kruger zone 64");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=-168 +k=1 +x_0=64500000 +y_0");
    add_proj4text (p, 1,
		   "=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13");
    add_proj4text (p, 2, ",-0.22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger zone 64\",");
    add_srs_wkt (p, 1,
		 "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
		 "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
		 "024\"]],TOWGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],A");
    add_srs_wkt (p, 4,
		 "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
		 "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
		 "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
		 "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
		 "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 9,
		 "168],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eas");
    add_srs_wkt (p, 10,
		 "ting\",64500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 11,
		 "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH");
    add_srs_wkt (p, 12, "],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2698\"]]");
    p = add_epsg_def (filter, first, last, 2699, "epsg", 2699,
		      "Pulkovo 1995 / 3-degree Gauss-Kruger CM 21E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
		   "ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.");
    add_proj4text (p, 2, "22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger CM 21E\",G");
    add_srs_wkt (p, 1,
		 "EOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"");
    add_srs_wkt (p, 2,
		 "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
		 "4\"]],TOWGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],AUT");
    add_srs_wkt (p, 4,
		 "HORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
		 "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
		 "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 7,
		 "00\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
		 "atitude_of_origin\",0],PARAMETER[\"central_meridian\",21");
    add_srs_wkt (p, 9,
		 "],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
		 "g\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 11,
		 "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXI");
    add_srs_wkt (p, 12, "S[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2699\"]]");
    p = add_epsg_def (filter, first, last, 2700, "epsg", 2700,
		      "Pulkovo 1995 / 3-degree Gauss-Kruger CM 24E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=24 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
		   "ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.");
    add_proj4text (p, 2, "22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger CM 24E\",G");
    add_srs_wkt (p, 1,
		 "EOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"");
    add_srs_wkt (p, 2,
		 "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
		 "4\"]],TOWGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],AUT");
    add_srs_wkt (p, 4,
		 "HORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
		 "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
		 "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 7,
		 "00\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
		 "atitude_of_origin\",0],PARAMETER[\"central_meridian\",24");
    add_srs_wkt (p, 9,
		 "],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
		 "g\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 11,
		 "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXI");
    add_srs_wkt (p, 12, "S[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2700\"]]");
    p = add_epsg_def (filter, first, last, 2701, "epsg", 2701,
		      "Pulkovo 1995 / 3-degree Gauss-Kruger CM 27E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
		   "ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.");
    add_proj4text (p, 2, "22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger CM 27E\",G");
    add_srs_wkt (p, 1,
		 "EOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"");
    add_srs_wkt (p, 2,
		 "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
		 "4\"]],TOWGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],AUT");
    add_srs_wkt (p, 4,
		 "HORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
		 "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
		 "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 7,
		 "00\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
		 "atitude_of_origin\",0],PARAMETER[\"central_meridian\",27");
    add_srs_wkt (p, 9,
		 "],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
		 "g\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 11,
		 "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXI");
    add_srs_wkt (p, 12, "S[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2701\"]]");
    p = add_epsg_def (filter, first, last, 2702, "epsg", 2702,
		      "Pulkovo 1995 / 3-degree Gauss-Kruger CM 30E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=30 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
		   "ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.");
    add_proj4text (p, 2, "22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger CM 30E\",G");
    add_srs_wkt (p, 1,
		 "EOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"");
    add_srs_wkt (p, 2,
		 "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
		 "4\"]],TOWGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],AUT");
    add_srs_wkt (p, 4,
		 "HORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
		 "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
		 "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 7,
		 "00\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
		 "atitude_of_origin\",0],PARAMETER[\"central_meridian\",30");
    add_srs_wkt (p, 9,
		 "],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
		 "g\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 11,
		 "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXI");
    add_srs_wkt (p, 12, "S[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2702\"]]");
    p = add_epsg_def (filter, first, last, 2703, "epsg", 2703,
		      "Pulkovo 1995 / 3-degree Gauss-Kruger CM 33E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
		   "ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.");
    add_proj4text (p, 2, "22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger CM 33E\",G");
    add_srs_wkt (p, 1,
		 "EOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"");
    add_srs_wkt (p, 2,
		 "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
		 "4\"]],TOWGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],AUT");
    add_srs_wkt (p, 4,
		 "HORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
		 "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
		 "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 7,
		 "00\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
		 "atitude_of_origin\",0],PARAMETER[\"central_meridian\",33");
    add_srs_wkt (p, 9,
		 "],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
		 "g\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 11,
		 "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXI");
    add_srs_wkt (p, 12, "S[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2703\"]]");
    p = add_epsg_def (filter, first, last, 2704, "epsg", 2704,
		      "Pulkovo 1995 / 3-degree Gauss-Kruger CM 36E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=36 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
		   "ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.");
    add_proj4text (p, 2, "22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger CM 36E\",G");
    add_srs_wkt (p, 1,
		 "EOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"");
    add_srs_wkt (p, 2,
		 "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
		 "4\"]],TOWGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],AUT");
    add_srs_wkt (p, 4,
		 "HORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
		 "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
		 "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 7,
		 "00\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
		 "atitude_of_origin\",0],PARAMETER[\"central_meridian\",36");
    add_srs_wkt (p, 9,
		 "],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
		 "g\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 11,
		 "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXI");
    add_srs_wkt (p, 12, "S[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2704\"]]");
    p = add_epsg_def (filter, first, last, 2705, "epsg", 2705,
		      "Pulkovo 1995 / 3-degree Gauss-Kruger CM 39E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
		   "ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.");
    add_proj4text (p, 2, "22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger CM 39E\",G");
    add_srs_wkt (p, 1,
		 "EOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"");
    add_srs_wkt (p, 2,
		 "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
		 "4\"]],TOWGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],AUT");
    add_srs_wkt (p, 4,
		 "HORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
		 "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
		 "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 7,
		 "00\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
		 "atitude_of_origin\",0],PARAMETER[\"central_meridian\",39");
    add_srs_wkt (p, 9,
		 "],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
		 "g\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 11,
		 "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXI");
    add_srs_wkt (p, 12, "S[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2705\"]]");
    p = add_epsg_def (filter, first, last, 2706, "epsg", 2706,
		      "Pulkovo 1995 / 3-degree Gauss-Kruger CM 42E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=42 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
		   "ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.");
    add_proj4text (p, 2, "22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger CM 42E\",G");
    add_srs_wkt (p, 1,
		 "EOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"");
    add_srs_wkt (p, 2,
		 "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
		 "4\"]],TOWGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],AUT");
    add_srs_wkt (p, 4,
		 "HORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
		 "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
		 "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 7,
		 "00\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
		 "atitude_of_origin\",0],PARAMETER[\"central_meridian\",42");
    add_srs_wkt (p, 9,
		 "],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
		 "g\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 11,
		 "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXI");
    add_srs_wkt (p, 12, "S[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2706\"]]");
    p = add_epsg_def (filter, first, last, 2707, "epsg", 2707,
		      "Pulkovo 1995 / 3-degree Gauss-Kruger CM 45E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
		   "ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.");
    add_proj4text (p, 2, "22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger CM 45E\",G");
    add_srs_wkt (p, 1,
		 "EOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"");
    add_srs_wkt (p, 2,
		 "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
		 "4\"]],TOWGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],AUT");
    add_srs_wkt (p, 4,
		 "HORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
		 "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
		 "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 7,
		 "00\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
		 "atitude_of_origin\",0],PARAMETER[\"central_meridian\",45");
    add_srs_wkt (p, 9,
		 "],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
		 "g\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 11,
		 "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXI");
    add_srs_wkt (p, 12, "S[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2707\"]]");
    p = add_epsg_def (filter, first, last, 2708, "epsg", 2708,
		      "Pulkovo 1995 / 3-degree Gauss-Kruger CM 48E");
    add_proj4text (p, 0,
		   "+proj=tmerc +lat_0=0 +lon_0=48 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
		   "ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.");
    add_proj4text (p, 2, "22 +units=m +no_defs");
    add_srs_wkt (p, 0,
		 "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger CM 48E\",G");
    add_srs_wkt (p, 1,
		 "EOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"");
    add_srs_wkt (p, 2,
		 "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt