-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

-- Synopsis
-- This function idnetifies whether a pragma is Interface or Import and whether
-- it is appropriate for the language varaint in use
--------------------------------------------------------------------------------

separate (Sem)
function Is_External_Interface (Pragma_Node : STree.SyntaxNode) return Boolean is
   Child_Pragma_Node : STree.SyntaxNode;
   Result            : Boolean;
begin
   Child_Pragma_Node := Child_Node (Current_Node => Pragma_Node);
   -- ASSUME Child_Pragma_Node = identifier OR assert_pragma
   if Syntax_Node_Type (Node => Child_Pragma_Node) = SP_Symbols.assert_pragma then
      -- ASSUME Child_Pragma_Node = assert_pragma
      Result := False;
   elsif Syntax_Node_Type (Node => Child_Pragma_Node) = SP_Symbols.identifier then
      -- ASSUME Child_Pragma_Node = identifier
      case CommandLineData.Content.Language_Profile is
         when CommandLineData.SPARK83 =>
            Result :=
              LexTokenManager.Lex_String_Case_Insensitive_Compare
              (Lex_Str1 => Node_Lex_String (Node => Child_Pragma_Node),
               Lex_Str2 => LexTokenManager.Interface_Token) =
              LexTokenManager.Str_Eq;
         when CommandLineData.SPARK95 | CommandLineData.SPARK2005 =>
            Result :=
              LexTokenManager.Lex_String_Case_Insensitive_Compare
              (Lex_Str1 => Node_Lex_String (Node => Child_Pragma_Node),
               Lex_Str2 => LexTokenManager.Import_Token) =
              LexTokenManager.Str_Eq;
      end case;
   else
      Result := False;
      SystemErrors.Fatal_Error
        (Sys_Err => SystemErrors.Invalid_Syntax_Tree,
         Msg     => "Expect Child_Pragma_Node = identifier OR assert_pragma in Is_External_Interface");
   end if;
   return Result;
end Is_External_Interface;
