-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (SPParserGoto)
procedure ScanGotoTable
  (StateNo       : in     SPProductions.ValidStates;
   Index         : in out GotoIndex;
   GoalState     :    out SPProductions.SPState;
   ReductionGoal :    out SPSymbols.SPNonTerminal) is
   FeasibleState : SPProductions.SPState;
   TableIndex    : GotoIndex;
begin
   FeasibleState := SPProductions.NoState;
   TableIndex    := Index;
   while TableIndex < GotoIndex'Last and FeasibleState /= StateNo loop
      FeasibleState := SPProductions.SPState (GotoTable (TableIndex) mod StateSize);
      if FeasibleState /= StateNo then
         TableIndex := TableIndex + 1;
      end if;
   end loop;
   if FeasibleState = StateNo then
      GoalState     := SPProductions.SPState ((GotoTable (TableIndex) / StateSize) mod StateSize);
      ReductionGoal := SPSymbols.SPNonTerminal'Val (((GotoTable (TableIndex) / RedGoal) mod RedGoalSize) + FirstNonTerminal);
      Index         := TableIndex + 1;
   else
      GoalState     := SPProductions.NoState;
      ReductionGoal := SPSymbols.SPNonTerminal'First;
      Index         := TableIndex;
   end if;
end ScanGotoTable;
