-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (SPParserActions)
function SPA (CST : SPProductions.ValidStates;
              CSY : SPSymbols.SPTerminal) return SPParseAct is
   IndexPair                         : PackedPATIndexPair;
   Index, MaxIndex                   : PATIndex;
   CSY_POS, NextSymbol, PackedResult : PackedSymActionPair;
   Result                            : SPParseAct;
begin -- SPA
   CSY_POS    := SPSymbols.SPTerminal'Pos (CSY);
   IndexPair  := StateTable (CST);
   Index      := PATIndex (IndexPair mod PATIndexSize);
   MaxIndex   := PATIndex (IndexPair / PATIndexSize);
   NextSymbol := ParseActionTable (Index) mod TermSymLim;
   while NextSymbol /= CSY_POS and then Index < MaxIndex loop
      Index      := Index + 1;
      NextSymbol := ParseActionTable (Index) mod TermSymLim;
   end loop;
   if NextSymbol /= CSY_POS and then NextSymbol /= Default then
      Result := ErrorAction;
   else
      PackedResult := ParseActionTable (Index);
      case SPActionKind'Val ((PackedResult / Act) mod ActLim) is
         when Shift =>
            Result := SPParseAct'(Shift, SPProductions.SPState ((PackedResult / State) mod StateLim), NoSym, NoRed, NoProd);
         when Reduce =>
            Result :=
              SPParseAct'
              (Reduce,
               SPProductions.NoState,
               SPSymbols.SPSymbol'Val ((PackedResult / Symbol) mod SymbolLim + FirstNonTerminal),
               SPProductions.SPRight ((PackedResult / RedBy) mod RedByLim),
               0);
         when Accpt =>
            if NextSymbol = CSY_POS then
               Result := AcceptAction;
            else
               Result := ErrorAction;
            end if;
         when Error =>               -- can never have this option
            Result := ErrorAction;
      end case;
   end if;
   return Result;
end SPA;
