-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (SparkLex.Lex)
procedure HyphIntro (Token : out SPSymbols.SPTerminal) is
   Ch1, Ch2 : Character;
   AnnoKind : Anno_Type;
begin
   -- Hyphen already recognised, but do not accept it in case it introduces the
   -- annotation symbol of an annotation which requires the end_of_annotation
   -- token to inserted infront.
   LineManager.Lookahead_Char (Ch => Ch1);
   if Ch1 = '-' then
      LineManager.Lookahead_Char (Ch => Ch2);

      if Ch2 = CommandLineData.Content.Anno_Char then
         if LineManager.Curr_Line.Anno_Context = Mid_Annotation then
            Check_Anno_Type (Unfinished_Anno => True,
                             Anno_Kind       => AnnoKind);
         else
            Check_Anno_Type (Unfinished_Anno => False,
                             Anno_Kind       => AnnoKind);
         end if;

         case AnnoKind is
            when Hide_Anno =>
               if LineManager.Curr_Line.Context = In_Annotation then
                  LineManager.Reject_Lookahead;
                  Token := SPSymbols.annotation_end;
               else
                  LineManager.Accept_Lookahead;
                  Token := SPSymbols.hide_directive;
               end if;
            when Start_Anno =>
               if LineManager.Curr_Line.Context = In_Annotation then
                  LineManager.Reject_Lookahead;
                  Token := SPSymbols.annotation_end;
               else
                  LineManager.Accept_Lookahead;
                  Token := SPSymbols.annotation_start;
               end if;
            when Proof_Anno =>
               if LineManager.Curr_Line.Context = In_Annotation then
                  LineManager.Reject_Lookahead;
                  Token := SPSymbols.annotation_end;
               else
                  LineManager.Accept_Lookahead;
                  Token := SPSymbols.proof_context;
               end if;
            when Other_Anno =>
               LineManager.Accept_Lookahead;
               -- Making the following assignement means that the if --# is
               -- followed by an identifier (i.e. we have a proof constant declaration)
               -- then the --# will be treated as a beginning a proof context rather
               -- than an annotation.
               Token := SPSymbols.proof_context;
            when No_Anno =>
               LineManager.Accept_Lookahead;
               Token := SPSymbols.comment;
         end case;
      else
         LineManager.Reject_Lookahead;
         LineManager.Accept_Char;
         LineManager.Accept_Char;

         while (Ch2 /= End_Of_Line and Ch2 /= End_Of_Text and Ch2 /= Line_Too_Long and not Format_Effector (Ch => Ch2)) or
           Ch2 = Ada.Characters.Latin_1.HT loop -- Skip comment.
            LineManager.Accept_Char;
            LineManager.Inspect_Char (Ch => Ch2);
         end loop;
         Token := SPSymbols.comment;
      end if;

   elsif Ch1 = '>' then
      LineManager.Accept_Lookahead;
      Token := SPSymbols.implies;
   else
      LineManager.Reject_Lookahead;
      LineManager.Accept_Char;
      Token := SPSymbols.minus;
   end if;
end HyphIntro;
