-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (Sem.CompUnit)
procedure wf_proof_renaming_declaration (Node  : in STree.SyntaxNode;
                                         Scope : in Dictionary.Scopes) is
   pragma Unreferenced (Scope);
begin
   ErrorHandler.Semantic_Error
     (Err_Num   => 315,
      Reference => ErrorHandler.No_Reference,
      Position  => Node_Position (Node => Node),
      Id_Str    => LexTokenManager.Null_String);
   --# accept Flow, 30, Scope, "Left unused for future expansion" &
   --#        Flow, 50, SPARK_IO.File_Sys, Scope, "Left unused for future expansion" &
   --#        Flow, 50, ErrorHandler.Error_Context, Scope, "Left unused for future expansion";
end wf_proof_renaming_declaration; -- unused scope left for future expansion
