-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (Sem.CompUnit)
procedure wf_percent (Node   : in     STree.SyntaxNode;
                      Scope  : in     Dictionary.Scopes;
                      EStack : in out ExpStack.ExpStackType) is
   StackTop : Exp_Record;
   TopSym   : Dictionary.Symbol;

   function InAForLoop return Boolean
   --# global in Dictionary.Dict;
   --#        in Scope;
   is
      -- Search outwards in scope as long as we remain in a loop.
      -- Success is when a for loop is found,
      -- Failure is when anything other than a loop is found.
      CurrentScope : Dictionary.Scopes;
      Result       : Boolean := False;
   begin
      CurrentScope := Scope;
      while Dictionary.IsLoop (Dictionary.GetRegion (CurrentScope)) loop
         if Dictionary.GetLoopParameter (Dictionary.GetRegion (CurrentScope)) /= Dictionary.NullSymbol then
            -- for loop found
            Result := True;
            exit;
         end if;

         CurrentScope := Dictionary.GetEnclosingScope (CurrentScope);
      end loop;
      return Result;
   end InAForLoop;

begin --wf_percent
      -- Percent operator is only allowed in loop invariants of for loops.
   if not InAForLoop then
      ExpStack.Pop (StackTop, EStack);
      StackTop.Errors_In_Expression := True;
      ExpStack.Push (StackTop, EStack);
      ErrorHandler.Semantic_Error
        (Err_Num   => 310,
         Reference => ErrorHandler.No_Reference,
         Position  => Node_Position (Node => Node),
         Id_Str    => LexTokenManager.Null_String);
   else -- Percent may be allowed
      ExpStack.Pop (StackTop, EStack);
      if StackTop.Sort = Is_Object then -- May be ok, further checks required
         TopSym := StackTop.Other_Symbol;
         if not Dictionary.IsVariable (TopSym) then
            StackTop.Errors_In_Expression := True;
            ErrorHandler.Semantic_Error
              (Err_Num   => 318,
               Reference => ErrorHandler.No_Reference,
               Position  => Node_Position (Node => Node),
               Id_Str    => LexTokenManager.Null_String);

         elsif StackTop.Type_Symbol /= Dictionary.GetType (TopSym) then
            -- New check that variable is entire
            StackTop.Errors_In_Expression := True;
            ErrorHandler.Semantic_Error
              (Err_Num   => 320,
               Reference => ErrorHandler.No_Reference,
               Position  => Node_Position (Node => Node),
               Id_Str    => LexTokenManager.Null_String);
         end if;
      else -- not an object so error message needed
         StackTop.Errors_In_Expression := True;
         if not (StackTop.Sort = Is_Unknown) then
            -- Supress error for unknown things
            ErrorHandler.Semantic_Error
              (Err_Num   => 318,
               Reference => ErrorHandler.No_Reference,
               Position  => Node_Position (Node => Node),
               Id_Str    => LexTokenManager.Null_String);
         end if;
      end if;
      ExpStack.Push (StackTop, EStack);
   end if;
end wf_percent;
