-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (Sem.CompUnit.WalkStatements)
procedure wf_condition (Node  : in STree.SyntaxNode;
                        Scope : in Dictionary.Scopes) is
   ConditionResult : Exp_Record;
   RefVar          : SeqAlgebra.Seq;

begin
   SeqAlgebra.CreateSeq (TheHeap, RefVar);
   WalkExpression
     (Exp_Node                => Child_Node (Current_Node => Node),
      Scope                   => Scope,
      Type_Context            => Dictionary.GetPredefinedBooleanType,
      Context_Requires_Static => False,
      Result                  => ConditionResult,
      Ref_Var                 => RefVar,
      Component_Data          => GlobalComponentData);
   if not Dictionary.IsBooleanTypeMark (ConditionResult.Type_Symbol) then
      ErrorHandler.Semantic_Error
        (Err_Num   => 94,
         Reference => ErrorHandler.No_Reference,
         Position  => Node_Position (Node => Node),
         Id_Str    => LexTokenManager.Null_String);
   end if;
   -- add reference variable list to RefList hash table
   RefList.AddRelation (Table, TheHeap, Node, Dictionary.NullSymbol, RefVar);
end wf_condition;
