-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (Sem.CompUnit)
procedure up_wf_positional_association (Node   : in     STree.SyntaxNode;
                                        EStack : in out ExpStack.ExpStackType) is
   NameExp    : Exp_Record;
   ErrorFound : Boolean := False;

   --------------------------------------------------------------

   procedure CheckRecordCompleteness (NameExp : in Exp_Record;
                                      Node    : in STree.SyntaxNode)
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     LexTokenManager.State;
   --#        in     STree.Table;
   --#        in out ErrorFound;
   --#        in out ErrorHandler.Error_Context;
   --#        in out SPARK_IO.File_Sys;
   --# derives ErrorFound                 from *,
   --#                                         Dictionary.Dict,
   --#                                         NameExp &
   --#         ErrorHandler.Error_Context,
   --#         SPARK_IO.File_Sys          from CommandLineData.Content,
   --#                                         Dictionary.Dict,
   --#                                         ErrorHandler.Error_Context,
   --#                                         LexTokenManager.State,
   --#                                         NameExp,
   --#                                         Node,
   --#                                         SPARK_IO.File_Sys,
   --#                                         STree.Table;
   is
      HighestFieldNumber, NumberOfFields : Positive;

      function ErrorPos return  LexTokenManager.Token_Position
      --# global in Node;
      --#        in STree.Table;
      -- Finds the position of the right most expression in an association list
      is
         Result    : LexTokenManager.Token_Position;
         LocalNode : STree.SyntaxNode;
      begin
         if Syntax_Node_Type (Node => Node) = SPSymbols.positional_association
           or else Syntax_Node_Type (Node => Node) = SPSymbols.annotation_positional_association then
            Result := Node_Position (Node => Next_Sibling (Child_Node (Child_Node (Node))));
         else -- it's an record_component_association used for an extension aggregate
            LocalNode := Child_Node (Child_Node (Node));
            if Syntax_Node_Type (Node => LocalNode) = SPSymbols.expression
              or else Syntax_Node_Type (Node => LocalNode) = SPSymbols.annotation_expression then
               Result := Node_Position (Node => LocalNode);
            else
               Result := Node_Position (Node => Next_Sibling (LocalNode));
            end if;
         end if;
         return Result;
      end ErrorPos;

      ----------------------------

   begin
      HighestFieldNumber := NameExp.Param_Count;
      NumberOfFields     := Dictionary.GetNumberOfComponents (NameExp.Type_Symbol);

      for I in Positive range HighestFieldNumber + 1 .. NumberOfFields loop
         ErrorFound := True;
         ErrorHandler.Semantic_Error
           (Err_Num   => 104,
            Reference => ErrorHandler.No_Reference,
            Position  => ErrorPos,
            Id_Str    => Dictionary.GetSimpleName (Dictionary.GetRecordComponent (NameExp.Type_Symbol, I)));
      end loop;
   end CheckRecordCompleteness;

   --------------------------------------------------------------

   function NamedRecordExtensionAggregate return Boolean
   --# global in Node;
   --#        in STree.Table;
   is
   begin
      return Syntax_Node_Type (Node => Child_Node (Node)) = SPSymbols.named_record_component_association
        or else Syntax_Node_Type (Node => Child_Node (Node)) = SPSymbols.annotation_named_record_component_association;
   end NamedRecordExtensionAggregate;

   --------------------------------------------------------------

begin --up_wf_positional_association
   if not NamedRecordExtensionAggregate then
      ExpStack.Pop (NameExp, EStack);
      if Dictionary.TypeIsRecord (NameExp.Type_Symbol) then
         CheckRecordCompleteness (NameExp, Node);
      end if;
      NameExp.Errors_In_Expression := NameExp.Errors_In_Expression or ErrorFound;
      ExpStack.Push (NameExp, EStack);
   end if;
end up_wf_positional_association;
