-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (Sem.CompUnit)
function FindActualNode
  (For_Formal                : in Dictionary.Symbol;
   Named_Argument_Assoc_Node : in STree.SyntaxNode)
  return                      STree.SyntaxNode
is
   It              : STree.Iterator;
   Expression_Node : STree.SyntaxNode;
begin
   -- ASSUME Named_Argument_Assoc_Node = named_argument_association
   SystemErrors.RT_Assert
     (C       => Syntax_Node_Type (Node => Named_Argument_Assoc_Node) = SPSymbols.named_argument_association,
      Sys_Err => SystemErrors.Invalid_Syntax_Tree,
      Msg     => "Expect Named_Argument_Assoc_Node = named_argument_association in FindActualNode");

   Expression_Node := STree.NullNode;

   It := STree.FindFirstFormalParameterNode (FromRoot => Named_Argument_Assoc_Node);
   while not STree.IsNull (It) loop
      -- ASSUME It = identifier
      SystemErrors.RT_Assert
        (C       => Syntax_Node_Type (Node => Get_Node (It => It)) = SPSymbols.identifier,
         Sys_Err => SystemErrors.Invalid_Syntax_Tree,
         Msg     => "Expect It = identifier in FindActualNode");
      if LexTokenManager.Lex_String_Case_Insensitive_Compare
        (Lex_Str1 => Dictionary.GetSimpleName (For_Formal),
         Lex_Str2 => Node_Lex_String (Node => Get_Node (It => It))) =
        LexTokenManager.Str_Eq then
         Expression_Node := Next_Sibling (Current_Node => Parent_Node (Current_Node => Get_Node (It => It)));
         exit;
      end if;
      It := STree.NextNode (It);
   end loop;
   -- ASSUME Expression_Node = expression OR NULL
   SystemErrors.RT_Assert
     (C       => Expression_Node = STree.NullNode or else Syntax_Node_Type (Node => Expression_Node) = SPSymbols.expression,
      Sys_Err => SystemErrors.Invalid_Syntax_Tree,
      Msg     => "Expect Expression_Node = expression OR NULL in FindActualNode");
   return Expression_Node;
end FindActualNode;
