-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (Sem.CompUnit)
procedure down_wf_store
  (Node      : in     STree.SyntaxNode;
   Scope     : in     Dictionary.Scopes;
   EStack    : in out ExpStack.ExpStackType;
   Next_Node :    out STree.SyntaxNode) is
   TypeInfo   : Exp_Record;
   ErrorFound : Boolean := False;

begin
   ExpStack.Pop (TypeInfo, EStack);

   case TypeInfo.Sort is
      when Is_Unknown =>
         TypeInfo  := UnknownSymbolRecord;
         Next_Node := STree.NullNode;

      when Is_Object =>
         if Dictionary.IsArrayTypeMark (TypeInfo.Type_Symbol, Scope) then
            TypeInfo.Param_Count := 0;
            Next_Node            := Child_Node (Current_Node => Node);
         elsif Dictionary.IsRecordTypeMark (TypeInfo.Type_Symbol, Scope) then
            Next_Node := Child_Node (Current_Node => Node);
         else --neither record nor array
            ErrorFound := True;
            ErrorHandler.Semantic_Error
              (Err_Num   => 323,
               Reference => ErrorHandler.No_Reference,
               Position  => Node_Position (Node => Parent_Node (Current_Node => Node)),
               Id_Str    => LexTokenManager.Null_String);
            Next_Node := STree.NullNode;

         end if;

      when others =>
         TypeInfo := UnknownSymbolRecord;
         ErrorHandler.Semantic_Error
           (Err_Num   => 323,
            Reference => ErrorHandler.No_Reference,
            Position  => Node_Position (Node => Parent_Node (Current_Node => Node)),
            Id_Str    => LexTokenManager.Null_String);
         Next_Node := STree.NullNode;
   end case;

   TypeInfo.Errors_In_Expression := TypeInfo.Errors_In_Expression or ErrorFound;
   ExpStack.Push (TypeInfo, EStack);
end down_wf_store;
