-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (Sem.CompUnit)
procedure down_wf_quantifier
  (Node      : in     STree.SyntaxNode;
   Estack    : in out ExpStack.ExpStackType;
   Scope     : in out Dictionary.Scopes;
   Next_Node :    out STree.SyntaxNode) is
   IdentNode, TypeNode    : STree.SyntaxNode;
   QuantifierSym, TypeSym : Dictionary.Symbol;
   IdentStr               : LexTokenManager.Lex_String;

begin
   IdentNode := Next_Sibling (Child_Node (Node));
   IdentStr  := Node_Lex_String (Node => IdentNode);
   TypeNode  := Next_Sibling (IdentNode);
   -- continue tree walk from next node after the type mark; this is either the range
   -- or the predicate
   Next_Node := Next_Sibling (Current_Node => TypeNode);

   -- check type declared and scalar
   Wf_Type_Mark (Node          => TypeNode,
                 Current_Scope => Scope,
                 Context       => Dictionary.ProofContext,
                 Type_Sym      => TypeSym);
   if not Dictionary.TypeIsScalar (TypeSym) then
      ErrorHandler.Semantic_Error
        (Err_Num   => 44,
         Reference => ErrorHandler.No_Reference,
         Position  => Node_Position (Node => TypeNode),
         Id_Str    => LexTokenManager.Null_String);
      TypeSym := Dictionary.GetUnknownTypeMark;
   end if;

   -- check quantified variable is not already declared
   if Dictionary.IsDefined (Name              => IdentStr,
                            Scope             => Scope,
                            Context           => Dictionary.ProofContext,
                            Full_Package_Name => False) then
      Next_Node := STree.NullNode;   --prune walk to prevent error knock on
      ExpStack.Push (UnknownTypeRecord, Estack); --result of whole Q.E. is unknown
      ErrorHandler.Semantic_Error
        (Err_Num   => 10,
         Reference => ErrorHandler.No_Reference,
         Position  => Node_Position (Node => IdentNode),
         Id_Str    => IdentStr);
   else
      Dictionary.AddQuantifiedVariable
        (Name        => IdentStr,
         Comp_Unit   => ContextManager.Ops.Current_Unit,
         Declaration => Dictionary.Location'(Start_Position => Node_Position (Node => IdentNode),
                                             End_Position   => Node_Position (Node => IdentNode)),
         TypeMark    => TypeSym,
         Region      => Dictionary.GetRegion (Scope),
         Variable    => QuantifierSym);

      -- plant quantifier symbol for recovery and use by VCG
      STree.AddNodeSymbol (IdentNode, QuantifierSym);

      -- enter local scope of quantifier
      Scope := Dictionary.LocalScope (QuantifierSym);
   end if;

end down_wf_quantifier;
