-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (Sem.CompUnit)
procedure CheckProtectedModifierConsistency
  (TheType             : in     Dictionary.Symbol;
   ModifierIsProtected : in     Boolean;
   ErrorNode           : in     STree.SyntaxNode;
   Consistent          :    out Boolean) is
   Compatible : Boolean;
begin
   Compatible := True;

   if Dictionary.IsDeclared (TheType) or Dictionary.IsPredefined (TheType) then
      if (Dictionary.TypeIsProtected (TheType) or else Dictionary.IsPredefinedSuspensionObjectType (TheType))
        and then not ModifierIsProtected then

         -- If the announced type is a PO or SO then the protected modifier
         -- should be present.
         --
         Compatible := False;

      elsif ModifierIsProtected and then not Dictionary.IsAtomic (TheType) then

         -- If the announced type is not atomic then the protected modifier
         -- should be not be present.
         --
         Compatible := False;
      end if;
   end if;

   if not Compatible then
      ErrorHandler.Semantic_Error
        (Err_Num   => 855,
         Reference => ErrorHandler.No_Reference,
         Position  => Node_Position (Node => ErrorNode),
         Id_Str    => Node_Lex_String (Node => ErrorNode));
   end if;

   Consistent := Compatible;
end CheckProtectedModifierConsistency;
