-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (Dictionary)
procedure AddRenamingDeclaration
  (Subprogram  : in Symbol;
   Comp_Unit   : in ContextManager.UnitDescriptors;
   Declaration : in Location;
   Scope       : in Scopes) is

   Decl, Region : Symbol;

   --------------------------------------------------------------------------------

   procedure AddRenamingDeclarationToSubprogram (Declaration : in Symbol;
                                                 Subprogram  : in Symbol)
   --# global in out Dict;
   --# derives Dict from *,
   --#                   Declaration,
   --#                   Subprogram;
   is
      Next : Symbol;
   begin
      Next := RawDict.GetSubprogramRenamingDeclarations (Subprogram);
      RawDict.SetNextDeclaration (Declaration, Next);
      RawDict.SetSubprogramRenamingDeclarations (Subprogram, Declaration);
   end AddRenamingDeclarationToSubprogram;

   --------------------------------------------------------------------------------

   procedure AddRenamingDeclarationToPackage (Declaration : in Symbol;
                                              Scope       : in Scopes)
   --# global in out Dict;
   --# derives Dict from *,
   --#                   Declaration,
   --#                   Scope;
   is

      ThePackage : Symbol;

      --------------------------------------------------------------------------------

      procedure AddRenamingDeclarationToPackageSpecification (Declaration, ThePackage : in Symbol)
      --# global in out Dict;
      --# derives Dict from *,
      --#                   Declaration,
      --#                   ThePackage;
      is
      begin
         RawDict.SetNextDeclaration (Declaration, RawDict.GetPackageVisibleRenamingDeclarations (ThePackage));
         RawDict.SetPackageVisibleRenamingDeclarations (ThePackage, Declaration);
      end AddRenamingDeclarationToPackageSpecification;

      --------------------------------------------------------------------------------

      procedure AddRenamingDeclarationToPackageBody (Declaration, ThePackage : in Symbol)
      --# global in out Dict;
      --# derives Dict from *,
      --#                   Declaration,
      --#                   ThePackage;
      is
      begin
         RawDict.SetNextDeclaration (Declaration, RawDict.GetPackageLocalRenamingDeclarations (ThePackage));
         RawDict.SetPackageLocalRenamingDeclarations (ThePackage, Declaration);
      end AddRenamingDeclarationToPackageBody;

      --------------------------------------------------------------------------------

   begin

      ThePackage := GetRegion (Scope);

      case Scope.TypeOfScope is
         when Visible =>
            AddRenamingDeclarationToPackageSpecification (Declaration, ThePackage);
         when Local =>
            AddRenamingDeclarationToPackageBody (Declaration, ThePackage);
         when Privat =>
            null;
      end case;

   end AddRenamingDeclarationToPackage;

   --------------------------------------------------------------------------------

begin

   RawDict.CreateDeclaration
     (Item        => Subprogram,
      Context     => ProgramContext,
      Comp_Unit   => Comp_Unit,
      Loc         => Declaration.Start_Position,
      Declaration => Decl);
   RawDict.SetDeclarationScope (Decl, Scope);
   Region := GetRegion (Scope);

   case RawDict.GetSymbolDiscriminant (Region) is
      when PackageSymbol =>
         AddRenamingDeclarationToPackage (Decl, Scope);
      when others =>
         AddRenamingDeclarationToSubprogram (Decl, Region);
   end case;

end AddRenamingDeclaration;
