///###////////////////////////////////////////////////////////////////////////
//
// Burton Computer Corporation
// http://www.burton-computer.com
// http://www.cooldevtools.com
// $Id: Ptr.h 242 2006-01-04 15:42:29Z brian $
//
// Copyright (C) 2000 Burton Computer Corporation
// ALL RIGHTS RESERVED
//
// This program is open source software; you can redistribute it
// and/or modify it under the terms of the Q Public License (QPL)
// version 1.0. Use of this software in whole or in part, including
// linking it (modified or unmodified) into other programs is
// subject to the terms of the QPL.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// Q Public License for more details.
//
// You should have received a copy of the Q Public License
// along with this program; see the file LICENSE.txt.  If not, visit
// the Burton Computer Corporation or CoolDevTools web site
// QPL pages at:
//
//    http://www.burton-computer.com/qpl.html
//    http://www.cooldevtools.com/qpl.html
//

#ifndef _Ptr_h
#define _Ptr_h

/// Older versions of g++ shipped with incomplete auto_ptr implementations.
/// This class is similar to auto_ptr but does not support implicit transfer
/// of ownership since that can be confusing and error prone.
template<class T>
class Ptr
{
public:
  explicit Ptr(T *p = 0)
    : m_ptr(p)
  {
  }

  ~Ptr()
  {
    delete release();
  }

  T *operator->() const
  {
    assert(m_ptr);
    return m_ptr;
  }

  T &operator*() const
  {
    assert(m_ptr);
    return *m_ptr;
  }


  T *release()
  {
    T *ptr = m_ptr;
    m_ptr = 0;
    return ptr;
  }

  T *get() const
  {
    return m_ptr;
  }

  void set(T *p = 0)
  {
    delete m_ptr;
    m_ptr = p;
  }

  void clear()
  {
    delete release();
  }

  bool isNull() const
  {
      return m_ptr == 0;
  }

  bool isNotNull() const
  {
      return m_ptr != 0;
  }

private:
  /// Not implemented.
  Ptr(const Ptr &);

  /// Not implemented.
  Ptr& operator=(const Ptr &);

  T *m_ptr;
};

#endif // _Ptr_h
