///###////////////////////////////////////////////////////////////////////////
//
// Burton Computer Corporation
// http://www.burton-computer.com
// http://www.cooldevtools.com
// $Id: NewArray.h 92 2004-11-13 13:24:11Z brian $
//
// Copyright (C) 2000 Burton Computer Corporation
// ALL RIGHTS RESERVED
//
// This program is open source software; you can redistribute it
// and/or modify it under the terms of the Q Public License (QPL)
// version 1.0. Use of this software in whole or in part, including
// linking it (modified or unmodified) into other programs is
// subject to the terms of the QPL.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// Q Public License for more details.
//
// You should have received a copy of the Q Public License
// along with this program; see the file LICENSE.txt.  If not, visit
// the Burton Computer Corporation or CoolDevTools web site
// QPL pages at:
//
//    http://www.burton-computer.com/qpl.html
//    http://www.cooldevtools.com/qpl.html
//

#ifndef _NewArray_h
#define _NewArray_h

//
// Older versions of g++ shipped with incomplete auto_ptr implementations.
// This class provides the same basic functionality as auto_ptr.
//
template<class T>
class NewArray
{
public:
  NewArray(T *p = 0)
    : m_ptr(p)
  {
  }

  ~NewArray()
  {
    delete[] release();
  }

  T &operator*() const
  {
    assert(m_ptr);
    return *m_ptr;
  }

  T &operator[](int index) const
  {
    assert(m_ptr);
    return m_ptr[index];
  }

  T *release()
  {
    T *ptr = m_ptr;
    m_ptr = 0;
    return ptr;
  }

  T *get() const
  {
    return m_ptr;
  }

  void set(T *p = 0)
  {
    delete[] m_ptr;
    m_ptr = p;
  }

  void clear()
  {
    delete[] release();
  }

  bool isNull()
  {
      return m_ptr == 0;
  }

  bool isNotNull()
  {
      return m_ptr != 0;
  }

private:
  /// Not implemented.
  NewArray(const NewArray &);

  /// Not implemented.
  NewArray& operator=(const NewArray &);

  T *m_ptr;
};

#endif // _NewArray_h
