///###////////////////////////////////////////////////////////////////////////
//
// Burton Computer Corporation
// http://www.burton-computer.com
// http://www.cooldevtools.com
// $Id: MailMessageDigester.h 56 2004-10-31 23:10:45Z brian $
//
// Copyright (C) 2000 Burton Computer Corporation
// ALL RIGHTS RESERVED
//
// This program is open source software; you can redistribute it
// and/or modify it under the terms of the Q Public License (QPL)
// version 1.0. Use of this software in whole or in part, including
// linking it (modified or unmodified) into other programs is
// subject to the terms of the QPL.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// Q Public License for more details.
//
// You should have received a copy of the Q Public License
// along with this program; see the file LICENSE.txt.  If not, visit
// the Burton Computer Corporation or CoolDevTools web site
// QPL pages at:
//
//    http://www.burton-computer.com/qpl.html
//    http://www.cooldevtools.com/qpl.html
//

#ifndef _MailMessageDigester_h
#define _MailMessageDigester_h

#include "Message.h"
#include "MailMessageList.h"

class MD5Digester;
class MessageHeaderList;

class MailMessageDigester
{
public:
    void assignDigestToMessage(Message *parsed_message,
                               MailMessage *mail_message,
                               const string &existing_digest_header);

    const string &digestMessage(MailMessage *messge,
                                string &buffer);

private:
    void digestLines(MD5Digester &md5,
                     const AbstractMultiLineString *lines);

    void digestHeaderLines(MD5Digester &md5,
                           const MessageHeaderList *header,
                           const string &header_name);

    bool getExistingDigest(const MessageHeaderList *message_headers,
                           const string &header_name,
                           string &buffer);
};

#endif

