///###////////////////////////////////////////////////////////////////////////
//
// Burton Computer Corporation
// http://www.burton-computer.com
// http://www.cooldevtools.com
// $Id: AbstractMultiLineString.h 60 2004-11-03 00:12:15Z brian $
//
// Copyright (C) 2000 Burton Computer Corporation
// ALL RIGHTS RESERVED
//
// This program is open source software; you can redistribute it
// and/or modify it under the terms of the Q Public License (QPL)
// version 1.0. Use of this software in whole or in part, including
// linking it (modified or unmodified) into other programs is
// subject to the terms of the QPL.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// Q Public License for more details.
//
// You should have received a copy of the Q Public License
// along with this program; see the file LICENSE.txt.  If not, visit
// the Burton Computer Corporation or CoolDevTools web site
// QPL pages at:
//
//    http://www.burton-computer.com/qpl.html
//    http://www.cooldevtools.com/qpl.html
//

#ifndef _AbstractMultiLineString_h
#define _AbstractMultiLineString_h

#include "util.h"
#include "RefCountMixin.h"

class AbstractCharReader;

class AbstractMultiLineString : public RefCountMixin
{
public:
    virtual ~AbstractMultiLineString();

    /// returns number of lines in string
    virtual int lineCount() const = 0;

    /// returns the specified line
    virtual const string *line(int index) const = 0;

    /// returns specified char of specified line
    char chr(int lineIndex, int charIndex) const
    {
        assert(line(lineIndex));
        assert(charIndex >= 0);
        assert(charIndex < line(lineIndex)->size());
        return (*line(lineIndex))[charIndex];
    }

    /// returns the specified line as a string reference
    const string &operator[](int index) const
    {
        assert(line(index));
        return *line(index);
    }

    virtual const string &join(string &buffer) const;
    virtual const string &join(string &buffer, const string &terminator) const;

    /// creates a new char reader owned by the caller
    virtual OWNED AbstractCharReader *createCharReader() const;

    /// creates a new char reader owned by the caller
    virtual OWNED AbstractCharReader *createCharReader(const string &terminator) const;
};

#endif

