""" automated unittests for pudding """

__revision__ = '$Revision: 1.1 $'

import sys
import os
import unittest

import soya

class TestBasic(unittest.TestCase):
  def testInit(self):
    import soya.pudding as pudding
    soya.init()
    pudding.init()

class _TextTestResult(unittest._TextTestResult):
  last_suite_name = ''
  
  def getDescription(self, test):
    desc = unittest._TextTestResult.getDescription(self, test)

    try:
      suite_name = test.__class__.klass.__name__
    except AttributeError:
      suite_name = test.__class__.__name__

    if suite_name != self.last_suite_name:
      self.last_suite_name = suite_name

      title = "Testing: %s" % suite_name
      underline = len(title) * '-'

      desc = "\n%s\n%s\n\n%s" % (title, underline, desc)

    return desc

class TextTestRunner(unittest.TextTestRunner):
  def _makeResult(self):
    return _TextTestResult(self.stream, self.descriptions, self.verbosity)

def test(debug = False):
  import soya.pudding as pudding
  import soya.pudding.python_console

  suite = unittest.TestSuite()

  suites  = [TestBasic]

  modules = [
            pudding.core,
            pudding.control,
            pudding.container,
            pudding.idler,
            pudding.python_console,
            pudding.style,
            ]

  import soya.pudding.ext
  from soya.pudding.ext import *
  
  modules_ext = []

  for module in pudding.ext.__all__:
    modules_ext.append(getattr(pudding.ext, module))
  
  all_modules = modules + modules_ext
   
  for module in all_modules:
    for obj in dir(module):
      if obj.startswith('Test'):
        suites.append(getattr(module, obj))

  for isuite in suites:
    suite.addTest(unittest.makeSuite(isuite, sortUsing = None))

  if debug:
    suite.debug()
  else:
    TextTestRunner(verbosity = 2).run(suite) 
    #unittest.TextTestRunner(verbosity = 2).run(suite)
  
if __name__ == '__main__':
  sys.path.insert(0, os.path.join(os.path.dirname(__file__), '..'))
  test('debug' in sys.argv)

   
