

#ifndef OPTIONSEDITOR_H
#define OPTIONSEDITOR_H

#include <kdialogbase.h>
//#include <kpushbutton.h>

class Options;
class Config;
class TagEngine;
class FileList;
class FileListItem;

class KLineEdit;
class KComboBox;
class KIntSpinBox;
class KTextEdit;
class KPushButton;
class QLabel;

/**
 * @short The options edit dialog that can be opened through the file list's context menu
 * @author Daniel Faust <hessijames@gmail.com>
 * @version 0.3
 */
class OptionsEditor : public KDialogBase
{
    Q_OBJECT
public:
    enum Page {
        OptionsPage,
        TagsPage
    };

    /**
     * Constructor
     */
    OptionsEditor( TagEngine*, Config*, FileList* _fileList, QWidget* parent = 0, const char* name=0, Page startPage = OptionsPage );

    /**
     * Destructor
     */
    virtual ~OptionsEditor();

    FileListItem* selectedItem();

private:
    FileList* fileList;
    Config* config;
    TagEngine* tagEngine;

    QFrame* conversionOptions;
    QFrame* tags;

    /** The widget, where we can set our output options */
    Options* options;

    /** A lineedit for entering the title of track */
    QLabel* lTitleLabel;
    KLineEdit* lTitle;
    KPushButton* pTitleEdit;
    /** A spinbox for entering or selecting the track number */
    QLabel* lNumberLabel;
    KIntSpinBox* iNumber;
    KPushButton* pNumberEdit;
    /** A lineedit for entering the artist of a track */
    QLabel* lArtistLabel;
    KLineEdit* lArtist;
    KPushButton* pArtistEdit;
    /** A lineedit for entering the composer of a track */
    QLabel* lComposerLabel;
    KLineEdit* lComposer;
    KPushButton* pComposerEdit;
    /** A lineedit for entering the album name */
    QLabel* lAlbumLabel;
    KLineEdit* lAlbum;
    KPushButton* pAlbumEdit;
    /** A spinbox for entering or selecting the disc number */
    QLabel* lDiscLabel;
    KIntSpinBox* iDisc;
    KPushButton* pDiscEdit;
    /** A spinbox for entering or selecting the year of the album */
    QLabel* lYearLabel;
    KIntSpinBox* iYear;
    KPushButton* pYearEdit;
    /** A combobox for entering or selecting the genre of the album */
    QLabel* lGenreLabel;
    KComboBox* cGenre;
    KPushButton* pGenreEdit;
    /** A textedit for entering a comment for a track */
    QLabel* lCommentLabel;
    KTextEdit* tComment;
    KPushButton* pCommentEdit;

    /** When hitting this button, the options lock (when multiple files are selected) will be deactivated */
    QLabel* lEditOptions;
    KPushButton* pEditOptions;

    /** When hitting this button, the tag lock (when reading tags failed) will be deactivated */
    QLabel* lEditTags;
    KPushButton* pEditTags;

    //FileListItem* currentItem;
    QValueList<FileListItem*> selectedItems;

    void setTagInputEnabled( bool enabled );

private slots:
    void optionsChanged();

    void editTitleClicked();
    void editNumberClicked();
    void editArtistClicked();
    void editComposerClicked();
    void editAlbumClicked();
    void editDiscClicked();
    void editYearClicked();
    void editGenreClicked();
    void editCommentClicked();

    void titleChanged( const QString& text );
    void numberChanged( int value );
    void artistChanged( const QString& text );
    void composerChanged( const QString& text );
    void albumChanged( const QString& text );
    void discChanged( int value );
    void yearChanged( int value );
    void genreChanged( const QString& text );
    void commentChanged();

    void editOptionsClicked();
    void editTagsClicked();

public slots:
    void itemsSelected( QValueList<FileListItem*> );
    void setPreviousEnabled( bool );
    void setNextEnabled( bool );
    //void moveWindow( int x, int y );

signals:
    void previousItem();
    void nextItem();
};

#endif // OPTIONSEDITOR_H
