
#include "configpluginspage.h"
#include "config.h"
#include "convertpluginloader.h"
#include "replaygainpluginloader.h"
#include "ripperpluginloader.h"

#include <qlabel.h>
#include <qlayout.h>
#include <qfile.h>
#include <qfileinfo.h>
#include <qcheckbox.h>
// #include <qevent.h>
// #include <qdragobject.h>
#include <qtooltip.h>
#include <qlocale.h>
// #include <qurl.h>

#include <klocale.h>
#include <kpushbutton.h>
#include <kio/job.h>
#include <kstandarddirs.h>
#include <kmessagebox.h>
#include <kiconloader.h>
#include <kfiledialog.h>
#include <klistbox.h>
//#include <kurl.h>

ConfigPluginsPage::ConfigPluginsPage( Config* _config, QWidget* parent, const char* name )
    : ConfigPageBase( parent, name )
{
    config = _config;

    // create an icon loader object for loading icons
    KIconLoader* iconLoader = new KIconLoader();

    QVBoxLayout* box = new QVBoxLayout( parent, 0, 6 );

    QLabel* lPluginsLabel = new QLabel( i18n("Installed plugins")+":", parent, "lPluginsLabel" );
    box->addWidget( lPluginsLabel );
    QHBoxLayout* pluginsBox = new QHBoxLayout( box );
    lPlugins = new KListBox( parent, "lPlugins" );
    pluginsBox->addWidget(lPlugins);
    connect( lPlugins, SIGNAL(highlighted(int)),
               this, SLOT(pluginsSelectionChanged(int))
             );
    refreshPlugins();

    QVBoxLayout* pluginsRightBox = new QVBoxLayout( pluginsBox );
    pAddPlugin = new KPushButton( iconLoader->loadIcon("add",KIcon::Small), i18n("Add ..."), parent, "pAddPlugin" );
    pluginsRightBox->addWidget( pAddPlugin );
    connect( pAddPlugin, SIGNAL(clicked()),
               this, SLOT(getPlugin())
             );
    pRemovePlugin = new KPushButton( iconLoader->loadIcon("remove",KIcon::Small), i18n("Remove"), parent, "pRemovePlugin" );
    pRemovePlugin->setEnabled( false );
    pluginsRightBox->addWidget( pRemovePlugin );
    connect( pRemovePlugin, SIGNAL(clicked()),
               this, SLOT(removePlugin())
             );
    pluginsRightBox->addStretch();
    pAboutPlugin = new KPushButton( iconLoader->loadIcon("messagebox_info",KIcon::Small), i18n("About"), parent, "pAboutPlugin" );
    pAboutPlugin->setEnabled( false );
    pluginsRightBox->addWidget( pAboutPlugin );
    connect( pAboutPlugin, SIGNAL(clicked()),
               this, SLOT(aboutPlugin())
             );
/* NOTE kaligames.de is down
    box->addSpacing( 5 );

    QLabel* lOnlinePluginsLabel = new QLabel( i18n("Available plugins")+":", parent, "lOnlinePluginsLabel" );
    box->addWidget( lOnlinePluginsLabel );
    QHBoxLayout* onlinePluginsBox = new QHBoxLayout( box );
    lOnlinePlugins = new KListBox( parent, "lOnlinePlugins" );
    onlinePluginsBox->addWidget( lOnlinePlugins );
    connect( lOnlinePlugins, SIGNAL(highlighted(int)),
               this, SLOT(onlinePluginsSelectionChanged(int))
             );
    QVBoxLayout* onlinePluginsRightBox = new QVBoxLayout( onlinePluginsBox );
    pRefreshOnlinePlugins = new KPushButton( iconLoader->loadIcon("reload",KIcon::Small), i18n("Refresh"), parent, "pRefreshOnlinePlugins" );
    QToolTip::add( pRefreshOnlinePlugins, i18n("Download the latest list of available plugins.") );
    onlinePluginsRightBox->addWidget( pRefreshOnlinePlugins );
    connect( pRefreshOnlinePlugins, SIGNAL(clicked()),
               this, SLOT(refreshOnlinePlugins())
             );
    // TODO upgrade button
//     pUpgradeOnlinePlugins = new KPushButton( iconLoader->loadIcon("filesave",KIcon::Small), i18n("Upgrade"), parent, "pUpgradeOnlinePlugins" );
//     pUpgradeOnlinePlugins->setEnabled( false );
//     QToolTip::add( pUpgradeOnlinePlugins, i18n("Download all plugins and install them into the soundKonverter directory.") );
//     onlinePluginsRightBox->addWidget( pUpgradeOnlinePlugins );
//     connect(pInstallAllOnlinePlugins,SIGNAL(clicked()),this,SLOT(upgradeOnlinePlugins()));
    onlinePluginsRightBox->addStretch();
    pInstallOnlinePlugin = new KPushButton( iconLoader->loadIcon("filesave",KIcon::Small), i18n("Install"), parent, "pInstallOnlinePlugin" );
    pInstallOnlinePlugin->setEnabled( false );
    QToolTip::add( pInstallOnlinePlugin, i18n("Download the selected plugin and install it into the soundKonverter directory.") );
    onlinePluginsRightBox->addWidget( pInstallOnlinePlugin );
    connect( pInstallOnlinePlugin, SIGNAL(clicked()),
               this, SLOT(getOnlinePlugin())
             );
    pAboutOnlinePlugin = new KPushButton( iconLoader->loadIcon("messagebox_info",KIcon::Small), i18n("About"), parent, "pAboutOnlinePlugin" );
    pAboutOnlinePlugin->setEnabled( false );
    onlinePluginsRightBox->addWidget( pAboutOnlinePlugin );
    connect( pAboutOnlinePlugin, SIGNAL(clicked()),
               this, SLOT(aboutOnlinePlugin())
             );
    cCheckOnlinePlugins = new QCheckBox( i18n("Check for new plugins on every startup"), parent, "cCheckOnlinePlugins" );
    cCheckOnlinePlugins->setChecked( config->data.plugins.checkForUpdates );
    box->addWidget( cCheckOnlinePlugins );
    connect( cCheckOnlinePlugins, SIGNAL(toggled(bool)),
               this, SLOT(cfgChanged())
             );

//     box->addStretch();

    // delete the icon loader object
    delete iconLoader;

    if( config->data.plugins.checkForUpdates && config->onlinePluginsChanged ) {
        // NOTE copied from below
        QString line;
        bool add;
        QFile file( locateLocal("data","soundkonverter/pluginlist.txt") );
        if( file.open(IO_ReadOnly) ) {
            QTextStream stream( &file );
            while( !stream.atEnd() ) {
                line = stream.readLine(); // line of text excluding '\n'
                line.replace( "&amp;", "&" );
                line.replace( "&auml;", "ä" );
                line.replace( "&Auml;", "Ä" );
                line.replace( "&ouml;", "ö" );
                line.replace( "&Ouml;", "Ö" );
                line.replace( "&uuml;", "ü" );
                line.replace( "&Uuml;", "Ü" );
                line.replace( "&szlig;", "ß" );

                add = true;
                for( uint i=0; i<lPlugins->count(); i++ ) {
                    if( lPlugins->text(i) == line ) {
                        add = false;
                        break;
                    }
                }
                if( add ) lOnlinePlugins->insertItem( line );
            }
            file.close();
        }
    }
*/
}

ConfigPluginsPage::~ConfigPluginsPage()
{}

void ConfigPluginsPage::resetDefaults()
{
//     cCheckOnlinePlugins->setChecked( false );

//     cfgChanged();
}

void ConfigPluginsPage::saveSettings()
{
//     config->data.plugins.checkForUpdates = cCheckOnlinePlugins->isChecked();
}

void ConfigPluginsPage::pluginsSelectionChanged( int index )
{
    QString name = lPlugins->text( index );

    QValueList<ConvertPlugin*> converters = config->allConverters();
    for( QValueList<ConvertPlugin*>::Iterator it = converters.begin(); it != converters.end(); ++it ) {
        if( name == (*it)->info.name + " v. " + QString::number((*it)->info.version) ) {
            QFileInfo file( (*it)->filePathName );
            if( file.isWritable() ) pRemovePlugin->setEnabled( true );
            else pRemovePlugin->setEnabled( false );
            break;
        }
    }

    QValueList<ReplayGainPlugin*> replaygains = config->allReplayGains();
    for( QValueList<ReplayGainPlugin*>::Iterator it = replaygains.begin(); it != replaygains.end(); ++it ) {
        if( name == (*it)->info.name + " v. " + QString::number((*it)->info.version) ) {
            QFileInfo file( (*it)->filePathName );
            if( file.isWritable() ) pRemovePlugin->setEnabled( true );
            else pRemovePlugin->setEnabled( false );
            break;
        }
    }

    QValueList<RipperPlugin*> rippers = config->allRippers();
    for( QValueList<RipperPlugin*>::Iterator it = rippers.begin(); it != rippers.end(); ++it ) {
        if( name == (*it)->info.name + " v. " + QString::number((*it)->info.version) ) {
            QFileInfo file( (*it)->filePathName );
            if( file.isWritable() ) pRemovePlugin->setEnabled( true );
            else pRemovePlugin->setEnabled( false );
            break;
        }
    }

    pAboutPlugin->setEnabled( true );
}

void ConfigPluginsPage::refreshPlugins()
{
    lPlugins->clear();

    QValueList<ConvertPlugin*> converters = config->allConverters();
    for( QValueList<ConvertPlugin*>::Iterator it = converters.begin(); it != converters.end(); ++it ) {
        lPlugins->insertItem( (*it)->info.name + " v. " + QString::number((*it)->info.version) );
        //lPlugins->insertItem( i18n("%1, Version: %2").arg((*it)->info.name).arg((*it)->info.version) );
    }

    QValueList<ReplayGainPlugin*> replaygains = config->allReplayGains();
    for( QValueList<ReplayGainPlugin*>::Iterator it = replaygains.begin(); it != replaygains.end(); ++it ) {
        lPlugins->insertItem( (*it)->info.name + " v. " + QString::number((*it)->info.version) );
        //lPlugins->insertItem( i18n("%1, Version: %2").arg((*it)->info.name).arg((*it)->info.version) );
    }

    QValueList<RipperPlugin*> rippers = config->allRippers();
    for( QValueList<RipperPlugin*>::Iterator it = rippers.begin(); it != rippers.end(); ++it ) {
        lPlugins->insertItem( (*it)->info.name + " v. " + QString::number((*it)->info.version) );
        //lPlugins->insertItem( i18n("%1, Version: %2").arg((*it)->info.name).arg((*it)->info.version) );
    }
}

void ConfigPluginsPage::getPlugin()
{
    QString url = KFileDialog::getOpenFileName( QDir::homeDirPath(), i18n("*.soundkonverter.xml|Plugins (*.soundkonverter.xml)"), this, i18n("Choose a plugin to add!") );
    if( !url.isEmpty() ) {
        QString filePathName = KURL::decode_string( url );
        QString fileName = filePathName.right( filePathName.length() - filePathName.findRev("/") );
        getPluginFilePathName = locateLocal("data","soundkonverter/plugins/") + fileName;
        getPluginJob = KIO::file_copy( url, getPluginFilePathName, -1, true, false, false );
        connect( getPluginJob, SIGNAL(result(KIO::Job*)),
                   this, SLOT(getPluginFinished(KIO::Job*))
                 );
    }
}

void ConfigPluginsPage::getPluginFinished( KIO::Job* job )
{
    if( job->error() == 0 ) {
        ConvertPluginLoader* convertPluginLoader = new ConvertPluginLoader();
        ReplayGainPluginLoader* replaygainPluginLoader = new ReplayGainPluginLoader();
        RipperPluginLoader* ripperPluginLoader = new RipperPluginLoader();

        if( convertPluginLoader->verifyFile(getPluginFilePathName) == -1 &&
            replaygainPluginLoader->verifyFile(getPluginFilePathName) == -1 &&
            ripperPluginLoader->verifyFile(getPluginFilePathName) == -1 )
        {
            KIO::del( getPluginFilePathName, false, false );
            KMessageBox::error( this,
                i18n("The plugin could not be installed. Please ensure that you have selected a valid soundKonverter plugin file."),
                i18n("Error while installing plugin") );
        }
        else
        {
            // TODO reload plugins without restart
//             ConvertPlugin* plugin = convertPluginLoader->loadFile( getPluginFilePathName );
//             if( plugin->info.version != -1 ) {
//                 lPlugins->insertItem( plugin->info.name + " v. " + QString::number(plugin->info.version) + " (" + i18n("restart necessary") + ")" );
//             }
//             else {
//                 delete plugin;
//                 ConvertPlugin* plugin = convertPluginLoader->loadFile( getPluginFilePathName );
//                 if( plugin->info.version != -1 ) {
//                     lPlugins->insertItem( plugin->info.name + " v. " + QString::number(plugin->info.version) + " (" + i18n("restart necessary") + ")" );
//                 }
//                 else {
//                     delete plugin;
//                     ConvertPlugin* plugin = convertPluginLoader->loadFile( getPluginFilePathName );
//                     if( plugin->info.version != -1 ) {
//                         lPlugins->insertItem( plugin->info.name + " v. " + QString::number(plugin->info.version) + " (" + i18n("restart necessary") + ")" );
//                     }
//                 }
//             }
//             delete plugin;
            KMessageBox::information( this,
                i18n("The plugin was installed successfully. Please restart soundKonverter in order to activate it."),
                i18n("Plugin successfully installed") );
            //config->reloadPlugins();
            //refreshPlugins();
            //emit rescanForBackends();
            //emit reloadEnDecoderPage();
        }

        delete convertPluginLoader;
        delete replaygainPluginLoader;
        delete ripperPluginLoader;
    }
    else {
        KMessageBox::error( this,
            i18n("The plugin could not be installed. Please ensure that you have write permission on your whole user directory."),
            i18n("Error while installing plugin") );
    }
}

void ConfigPluginsPage::removePlugin()
{
    // TODO reload plugins without restart

    QString name = lPlugins->currentText();

    QValueList<ConvertPlugin*> converters = config->allConverters();
    for( QValueList<ConvertPlugin*>::Iterator it = converters.begin(); it != converters.end(); ++it ) {
        if( name == (*it)->info.name + " v. " + QString::number((*it)->info.version) ) {
            QFile file( (*it)->filePathName );
            if( file.remove() ) {
                lPlugins->removeItem( lPlugins->currentItem() );
                KMessageBox::information( this,
                    i18n("The plugin was removed successfully. Please restart soundKonverter in order to deactivate it."),
                    i18n("Plugin successfully removed") );
            }
            else {
                KMessageBox::error( this,
                    i18n("The plugin could not be removed. Please ensure that you have write permission on your whole user directory."),
                    i18n("Error while removing plugin") );
            }
            break;
        }
    }

    QValueList<ReplayGainPlugin*> replaygains = config->allReplayGains();
    for( QValueList<ReplayGainPlugin*>::Iterator it = replaygains.begin(); it != replaygains.end(); ++it ) {
        if( name == (*it)->info.name + " v. " + QString::number((*it)->info.version) ) {
            QFile file( (*it)->filePathName );
            if( file.remove() ) {
                lPlugins->removeItem( lPlugins->currentItem() );
                KMessageBox::information( this,
                    i18n("The plugin was removed successfully. Please restart soundKonverter in order to deactivate it."),
                    i18n("Plugin successfully removed") );
            }
            else {
                KMessageBox::error( this,
                    i18n("The plugin could not be removed. Please ensure that you have write permission on your whole user directory."),
                    i18n("Error while removing plugin") );
            }
            break;
        }
    }

    QValueList<RipperPlugin*> rippers = config->allRippers();
    for( QValueList<RipperPlugin*>::Iterator it = rippers.begin(); it != rippers.end(); ++it ) {
        if( name == (*it)->info.name + " v. " + QString::number((*it)->info.version) ) {
            QFile file( (*it)->filePathName );
            if( file.remove() ) {
                lPlugins->removeItem( lPlugins->currentItem() );
                KMessageBox::information( this,
                    i18n("The plugin was removed successfully. Please restart soundKonverter in order to deactivate it."),
                    i18n("Plugin successfully removed") );
            }
            else {
                KMessageBox::error( this,
                    i18n("The plugin could not be removed. Please ensure that you have write permission on your whole user directory."),
                    i18n("Error while removing plugin") );
            }
            break;
        }
    }

/*    backendPlugins.remove(lPlugins->currentText());
    replayGainPlugins.remove(lPlugins->currentText());
    backendPlugins.reload();
    replayGainPlugins.reload();
    lPlugins->clear();
    lPlugins->insertStringList(backendPlugins.loadedPlugins());
    lPlugins->insertStringList(replayGainPlugins.loadedPlugins());
    emit rescanForBackends();
    emit reloadEnDecoderPage();*/
}

void ConfigPluginsPage::aboutPlugin()
{
    // TODO add link support

    QString name = lPlugins->currentText();

    QValueList<ConvertPlugin*> converters = config->allConverters();
    for( QValueList<ConvertPlugin*>::Iterator it = converters.begin(); it != converters.end(); ++it ) {
        if( name == (*it)->info.name + " v. " + QString::number((*it)->info.version) ) {
            KMessageBox::information( this,
                i18n((*it)->info.about) + "\n" +
                i18n("Version") + ": " + QString::number((*it)->info.version) + "\n" +
                i18n("Author") + ": " + (*it)->info.author,
                i18n("About") + ": " + (*it)->info.name );
            break;
        }
    }

    QValueList<ReplayGainPlugin*> replaygains = config->allReplayGains();
    for( QValueList<ReplayGainPlugin*>::Iterator it = replaygains.begin(); it != replaygains.end(); ++it ) {
        if( name == (*it)->info.name + " v. " + QString::number((*it)->info.version) ) {
            KMessageBox::information( this,
                i18n((*it)->info.about) + "\n" +
                i18n("Version") + ": " + QString::number((*it)->info.version) + "\n" +
                i18n("Author") + ": " + (*it)->info.author,
                i18n("About") + ": " + (*it)->info.name );
            break;
        }
    }

    QValueList<RipperPlugin*> rippers = config->allRippers();
    for( QValueList<RipperPlugin*>::Iterator it = rippers.begin(); it != rippers.end(); ++it ) {
        if( name == (*it)->info.name + " v. " + QString::number((*it)->info.version) ) {
            KMessageBox::information( this,
                i18n((*it)->info.about) + "\n" +
                i18n("Version") + ": " + QString::number((*it)->info.version) + "\n" +
                i18n("Author") + ": " + (*it)->info.author,
                i18n("About") + ": " + (*it)->info.name );
            break;
        }
    }
}

void ConfigPluginsPage::onlinePluginsSelectionChanged( int index )
{
    if( lOnlinePlugins->currentText() != i18n("No new plugins available!") ) {
        pInstallOnlinePlugin->setEnabled( true );
        pAboutOnlinePlugin->setEnabled( true );
    }
    else {
        pInstallOnlinePlugin->setEnabled( false );
        pAboutOnlinePlugin->setEnabled( false );
    }
}

void ConfigPluginsPage::refreshOnlinePlugins()
{
    pRefreshOnlinePlugins->setEnabled( false );

    refreshOnlinePluginsJob = KIO::file_copy( "http://kaligames.de/downloads/soundkonverter/plugins/download.php?version=" + QString::number(config->data.app.configVersion),
        locateLocal("data","soundkonverter/pluginlist.txt"), -1, true, false, false );
    connect( refreshOnlinePluginsJob, SIGNAL(result(KIO::Job*)),
               this, SLOT(refreshOnlinePluginsFinished(KIO::Job*))
             );
}

void ConfigPluginsPage::refreshOnlinePluginsFinished( KIO::Job* job )
{
    if( job->error() == 0 ) {
        lOnlinePlugins->clear();

        QString line;
        bool add;
        QFile file( locateLocal("data","soundkonverter/pluginlist.txt") );
        if( file.open(IO_ReadOnly) ) {
            QTextStream stream( &file );
            while( !stream.atEnd() ) {
                line = stream.readLine(); // line of text excluding '\n'
                line.replace( "&amp;", "&" );
                line.replace( "&auml;", "ä" );
                line.replace( "&Auml;", "Ä" );
                line.replace( "&ouml;", "ö" );
                line.replace( "&Ouml;", "Ö" );
                line.replace( "&uuml;", "ü" );
                line.replace( "&Uuml;", "Ü" );
                line.replace( "&szlig;", "ß" );

                add = true;
                for( uint i=0; i<lPlugins->count(); i++ ) {
                    if( lPlugins->text(i) == line ) {
                        add = false;
                        break;
                    }
                }
                if( add ) lOnlinePlugins->insertItem( line );
            }
            file.close();
        }

        if( lOnlinePlugins->count() == 0 ) {
            lOnlinePlugins->insertItem( i18n("No new plugins available!") );
        }
    }
    else {
        KMessageBox::error( this,
            i18n("The plugin list could not be downloaded. Please ensure, that your internet connection works correct.\nMaybe our server is busy at the moment, please try it again later."),
            i18n("Error while loading plugin list") );
    }

    pRefreshOnlinePlugins->setEnabled( true );
}

void ConfigPluginsPage::getOnlinePlugin()
{
    pInstallOnlinePlugin->setEnabled( false );
    QString name;

    for( uint i=0; i<lOnlinePlugins->count(); i++ ) {
        if( lOnlinePlugins->isSelected(i) ) {
            name = lOnlinePlugins->text( i );
            lOnlinePlugins->removeItem( i );
            break;
        }
    }

    name.replace( "&", "&amp;" );
    name.replace( "ä", "&auml;" );
    name.replace( "Ä", "&Auml;" );
    name.replace( "ö", "&ouml;" );
    name.replace( "Ö", "&Ouml;" );
    name.replace( "ü", "&uuml;" );
    name.replace( "Ü", "&Uuml;" );
    name.replace( "ß", "&szlig;" );
    KURL::encode_string( name );
    getOnlinePluginJob = KIO::file_copy( "http://kaligames.de/downloads/soundkonverter/plugins/getfile.php?version=" + QString::number(config->data.app.configVersion) + "&file=" + name,
        locateLocal("data","soundkonverter/plugins/newplugin.xml"), -1, true, false, false );
    connect( getOnlinePluginJob, SIGNAL(result(KIO::Job*)),
               this, SLOT(getOnlinePluginFinished(KIO::Job*))
             );
}

void ConfigPluginsPage::getOnlinePluginFinished( KIO::Job* job )
{
    if( job->error() == 0 ) {
        QString name;
        QString line;
        QFile file( locateLocal("data","soundkonverter/plugins/newplugin.xml") );
        if( file.open(IO_ReadOnly) ) {
            QTextStream stream( &file );
            name = stream.readLine(); // read the file name from the top of the file
            getPluginFilePathName = locateLocal("data","soundkonverter/plugins/") + name;
            QFile newFile( getPluginFilePathName );
            if( newFile.open(IO_WriteOnly) ) {
                QTextStream newStream( &newFile );
                while( !stream.atEnd() ) {
                    line = stream.readLine(); // line of text excluding '\n'
                    newStream << line << "\n";
                }
                newFile.close();
            }
            file.close();
        }
        file.remove();

        ConvertPluginLoader* convertPluginLoader = new ConvertPluginLoader();
        ReplayGainPluginLoader* replaygainPluginLoader = new ReplayGainPluginLoader();
        RipperPluginLoader* ripperPluginLoader = new RipperPluginLoader();

        if( convertPluginLoader->verifyFile(getPluginFilePathName) == -1 &&
            replaygainPluginLoader->verifyFile(getPluginFilePathName) == -1 &&
            ripperPluginLoader->verifyFile(getPluginFilePathName) == -1 )
        {
            KIO::del( getPluginFilePathName, false, false );
            KMessageBox::error( this,
                i18n("The plugin could not be installed. Please ensure that you have selected a valid soundKonverter plugin file."),
                i18n("Error while installing plugin") );
        }
        else
        {
            // TODO reload plugins without restart
//             ConvertPlugin* plugin = convertPluginLoader->loadFile( getPluginFilePathName );
//             if( plugin->info.version != -1 ) {
//                 lPlugins->insertItem( plugin->info.name + " v. " + QString::number(plugin->info.version) + " (" + i18n("restart necessary") + ")" );
//             }
//             else {
//                 delete plugin;
//                 ConvertPlugin* plugin = convertPluginLoader->loadFile( getPluginFilePathName );
//                 if( plugin->info.version != -1 ) {
//                     lPlugins->insertItem( plugin->info.name + " v. " + QString::number(plugin->info.version) + " (" + i18n("restart necessary") + ")" );
//                 }
//                 else {
//                     delete plugin;
//                     ConvertPlugin* plugin = convertPluginLoader->loadFile( getPluginFilePathName );
//                     if( plugin->info.version != -1 ) {
//                         lPlugins->insertItem( plugin->info.name + " v. " + QString::number(plugin->info.version) + " (" + i18n("restart necessary") + ")" );
//                     }
//                 }
//             }
//             delete plugin;
            KMessageBox::information( this,
                i18n("The plugin was installed successfully. Please restart soundKonverter in order to activate it."),
                i18n("Plugin successfully installed") );
            //config->reloadPlugins();
            //refreshPlugins();
            //emit rescanForBackends();
            //emit reloadEnDecoderPage();
        }

        delete convertPluginLoader;
        delete replaygainPluginLoader;
        delete ripperPluginLoader;
    }
    else {
        KMessageBox::error( this,
            i18n("The plugin could not be installed. Please ensure that you have write permission on your whole user directory."),
            i18n("Error while installing plugin") );
    }
}

void ConfigPluginsPage::aboutOnlinePlugin()
{
    pAboutOnlinePlugin->setEnabled( false );

    QString name = lOnlinePlugins->currentText();
    name.replace( "&", "&amp;" );
    name.replace( "ä", "&auml;" );
    name.replace( "Ä", "&Auml;" );
    name.replace( "ö", "&ouml;" );
    name.replace( "Ö", "&Ouml;" );
    name.replace( "ü", "&uuml;" );
    name.replace( "Ü", "&Uuml;" );
    name.replace( "ß", "&szlig;" );
    KURL::encode_string( name );
    aboutOnlinePluginJob = KIO::file_copy( "http://kaligames.de/downloads/soundkonverter/plugins/info.php?file=" + name + "&lang=" + QLocale::languageToString(QLocale::system().language()),
        locateLocal("data","soundkonverter/plugin_info.txt"), -1, true, false, false );
    connect( aboutOnlinePluginJob, SIGNAL(result(KIO::Job*)),
               this, SLOT(aboutOnlinePluginFinished(KIO::Job*))
             );
}

void ConfigPluginsPage::aboutOnlinePluginFinished( KIO::Job* job )
{
    if( job->error() == 0 ) {
        QString name = lOnlinePlugins->currentText();

        QFile file( locateLocal("data","soundkonverter/plugin_info.txt") );
        if( file.open(IO_ReadOnly) ) {
            QTextStream stream( &file );
            QString data = stream.readLine();
            KMessageBox::information( this, i18n(data), i18n("About") + ": " + name,
                QString::null, KMessageBox::Notify | KMessageBox::AllowLink );
        }
        else {
            KMessageBox::error( this,
                i18n("The plugin info could not be downloaded. Please ensure, that your internet connection works correctly."),
                i18n("Error while loading plugin info") );
        }
    }
    else {
        KMessageBox::error( this,
            i18n("The plugin info could not be downloaded. Please ensure, that your internet connection works correctly."),
            i18n("Error while loading plugin info") );
    }

    pAboutOnlinePlugin->setEnabled( true );
}


