

#ifndef CONFIGDIALOG_H
#define CONFIGDIALOG_H

#include <kdialogbase.h>

#include <qmap.h>


class Config;
class ConfigGeneralPage;
class ConfigPluginsPage;
class ConfigEnvironmentPage;
class ConfigBackendsPage;

/**
 * @short Config dialog
 * @author Daniel Faust <hessijames@gmail.com>
 * @version 0.3
 */
class ConfigDialog : public KDialogBase
{
    Q_OBJECT
public:
    enum Page {
        GeneralPage,
        PluginsPage,
        EnvironmentPage,
        BackendsPage
    };

    /**
     * Constructor
     */
    ConfigDialog( Config*, QWidget *parent = 0, const char *name = 0, Page startPage = GeneralPage );

    /**
     * Destructor
     */
    virtual ~ConfigDialog();

private:
    QFrame* addPage( const QString &itemName, const QString &iconName );

    QFrame* generalPage;
    ConfigGeneralPage* configGeneralPage;
    QFrame* pluginsPage;
    ConfigPluginsPage* configPluginsPage;
    QFrame* environmentPage;
    ConfigEnvironmentPage* configEnvironmentPage;
    QFrame* backendsPage;
    ConfigBackendsPage* configBackendsPage;

    void setConfigChanged( const bool );

    Config* config;

    QMap<QString, QString> binaries;

private slots:
    void configChanged();
    void okClickedSlot();
    void applyClickedSlot();
    void defaultClickedSlot();

signals:
    void saveGeneral();
    void savePlugins();
    void saveEnvironment();
    void saveBackends();

    void resetGeneral();
    void resetPlugins();
    void resetEnvironment();
    void resetBackends();
};

#endif // CONFIGDIALOG_H
