

#include "configdialog.h"

#include "config.h"
#include "configgeneralpage.h"
#include "configpluginspage.h"
#include "configenvironmentpage.h"
#include "configbackendspage.h"

/*#include "config_dialogue_interface.h"
#include "config_dialogue_backend_plugins.h"
#include "config_dialogue_backends.h"
#include "config_dialogue_en_decoder.h"
#include "config_dialogue_en_decoder_options.h"

#include "tools.h"
#include "backend_plugins.h"
#include "replaygain_plugins.h"

#include <qlayout.h>
*/
//#include <kconfig.h>
#include <kiconloader.h>
#include <klocale.h>
#include <kpushbutton.h>

ConfigDialog::ConfigDialog( Config* _config, QWidget *parent, const char *name, Page startPage )
    : KDialogBase(
        IconList,
        i18n("Settings"),
        Apply | Cancel | Default | Help | Ok,
        Ok, // default button
        parent,
        name,
        true, // modal
        true // separator
    )
{
    config = _config;

    //resize( 600, 400 );

    binaries = config->binaries;

    connect( this, SIGNAL(applyClicked()),
               this,SLOT(applyClickedSlot())
             );
    connect( this, SIGNAL(okClicked()),
               this,SLOT(okClickedSlot())
             );
    connect( this, SIGNAL(defaultClicked()),
               this,SLOT(defaultClickedSlot())
             );

    generalPage = addPage( i18n("General"), "misc" );
    configGeneralPage = new ConfigGeneralPage( config, generalPage, "configGeneralPage" );
    connect( configGeneralPage, SIGNAL(configChanged()),
               this, SLOT(configChanged())
    );
    connect( this, SIGNAL(saveGeneral()),
               configGeneralPage, SLOT(saveSettings())
    );
    connect( this, SIGNAL(resetGeneral()),
               configGeneralPage, SLOT(resetDefaults())
    );

    pluginsPage = addPage( i18n("Plugins"), "connect_creating" );
    configPluginsPage = new ConfigPluginsPage( config, pluginsPage, "configPluginsPage" );
    connect( configPluginsPage, SIGNAL(configChanged()),
               this, SLOT(configChanged())
    );
    connect( this, SIGNAL(savePlugins()),
               configPluginsPage, SLOT(saveSettings())
    );
    connect( this, SIGNAL(resetPlugins()),
               configPluginsPage, SLOT(resetDefaults())
    );

    environmentPage = addPage( i18n("Environment"), "filefind" );
    configEnvironmentPage = new ConfigEnvironmentPage( config, &binaries, environmentPage, "configEnvironmentPage" );
    connect( configEnvironmentPage, SIGNAL(configChanged()),
               this, SLOT(configChanged())
    );
    connect( this, SIGNAL(saveEnvironment()),
               configEnvironmentPage, SLOT(saveSettings())
    );
    connect( this, SIGNAL(resetEnvironment()),
               configEnvironmentPage, SLOT(resetDefaults())
    );

    backendsPage = addPage( i18n("Backends"), "kcmsystem" );
    configBackendsPage = new ConfigBackendsPage( config, &binaries, backendsPage, "configBackendsPage" );
    connect( configBackendsPage, SIGNAL(configChanged()),
               this, SLOT(configChanged())
    );
    connect( this, SIGNAL(saveBackends()),
               configBackendsPage, SLOT(saveSettings())
    );
    connect( this, SIGNAL(resetBackends()),
               configBackendsPage, SLOT(resetDefaults())
    );
    connect( configEnvironmentPage, SIGNAL(rebuildBackendsPage()),
               configBackendsPage, SLOT(rebuild())
    );

    setConfigChanged( false );

    showPage( startPage );
}

ConfigDialog::~ConfigDialog()
{
}

QFrame *ConfigDialog::addPage(const QString &itemName, const QString &iconName)
{
    return KDialogBase::addPage( itemName, QString::null, MainBarIcon(iconName,32) );
}

void ConfigDialog::setConfigChanged( const bool value )
{
    actionButton( Apply )->setEnabled(value);
}

void ConfigDialog::configChanged()
{
    setConfigChanged( true );
}

void ConfigDialog::applyClickedSlot()
{
    okClickedSlot();
    setConfigChanged( false );
}

void ConfigDialog::okClickedSlot()
{
    emit saveGeneral();
    emit savePlugins();
    emit saveEnvironment();
    emit saveBackends();
    config->write();
}

void ConfigDialog::defaultClickedSlot()
{
    int index = activePageIndex();
    QStringList listDefaults;

    if( index == -1 )
        return;

    if( index == pageIndex(generalPage) )
    {
        emit resetGeneral();
        setConfigChanged( true );
    }
    else if( index == pageIndex(pluginsPage) )
    {
        emit resetPlugins();
        setConfigChanged( true );
    }
    else if( index == pageIndex(environmentPage) )
    {
        emit resetEnvironment();
        setConfigChanged( true );
    }
    else if( index == pageIndex(backendsPage) )
    {
        emit resetBackends();
        setConfigChanged( true );
    }
}
