<?php
/**
 * $Horde: passwd/lib/Passwd.php,v 1.2.2.1 2003/01/21 01:28:32 ericr Exp $
 *
 * Copyright 1999-2003 Chuck Hagenbuch <chuck@horde.org>
 * Copyright 2002-2003 Eric Jon Rostetter <eric.rostetter@physics.utexas.edu>
 * Copyright 2002-2003 Mike Cochrane <mike@graftonhall.co.nz>
 *
 * See the enclosed file COPYING for license information (LGPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/lgpl.html.
 *
 */

require_once PASSWD_BASE . '/lib/base.php';

/**
 * Passwd Base Class.
 *
 * @author Mike Cochrane <mike@graftonhall.co.nz>
 * @version $Revision: 1.2.2.1 $
 * @package passwd
 */
class Passwd {

    /**
     * Determines if the given backend is the "preferred" backend for
     * this web server.  This decision is based on the global 'SERVER_NAME'
     * and 'HTTP_HOST' server variables and the contents of the 'preferred'
     * field in the backend's definition.  The 'preferred' field may
     * take a single value or an array of multiple values.
     *
     * @param array $backend     A complete backend entry from the $backends
     *                            hash.
     *
     * @return boolean  True if this entry is "preferred".
     */
    function isPreferredBackend($backend)
    {
        if (!empty($backend['preferred'])) {
            if (is_array($backend['preferred'])) {
                foreach ($backend['preferred'] as $backend) {
                    if ($backend == $_SERVER['SERVER_NAME'] ||
                        $backend == $_SERVER['HTTP_HOST']) {
                        return true;
                    }
                }
            } elseif ($backend['preferred'] == $_SERVER['SERVER_NAME'] ||
                      $backend['preferred'] == $_SERVER['HTTP_HOST']) {
                return true;
            }
        }

        return false;
    }

}
