<?php
/**
 * $Horde: passwd/lib/Driver/vmailmgr.php,v 1.5.2.1 2003/01/21 01:28:34 ericr Exp $
 *
 * The vmailmgr class attempts to change a user's password on a local
 * vmailmgr daemon
 *
 * @author   Marco Kaiser <bate@php.net>
 * @package  passwd
 */
 class Passwd_Driver_vmailmgr extends Passwd_Driver {

    /** Hash containing configuration parameters. */
    var $_params;

    /**
     * Constructs a new vmailmgr Passwd_Driver object.
     *
     * @param array  $params    A hash containing connection parameters.
     */
    function Passwd_Driver_vmailmgr($params = array())
    {
        $this->_params = $params;
    }

    /**
     * Change the user's password.
     *
     * @param   $username    The user for which to change the password.
     * @param   $oldpassword  The old (current) user password.
     * @param   $newpassword  The new user password to set.
     *
     * @return  boolean    True or false based on success of the change.
     */
    function change_password($username, $oldpassword, $newpassword) 
    {
        if (is_readable($this->_params['vmailinc']) && isset($this->_params['vmailinc'])) {
            @include($this->_params['vmailinc']);
        } else {
            return PEAR::raiseError('vmail.inc not found ! (' . $this->_params['vmailinc'] . ')');
        }
        
        $_splitted = split('@', $username);
        $_username = $_splitted[0];
        $_domain = $_splitted[1];
        $_returnChange = vchpass($_domain, $oldpassword, $_username, $newpassword);
        
        if ($_returnChange[0] == 0) {
            $this->reset_credentials($username, $oldpassword, $newpassword);
            return true;
        }
        
        return PEAR::raiseError(_("Incorect Password"));    
    }
}
