<?php
/**
 * $Horde: accounts/lib/Driver/ldap.php,v 1.5.2.1 2003/01/19 06:53:20 ericr Exp $
 *
 *
 * Copyright 2001-2003 Eric Rostetter <eric.rostetter@physics.utexas.edu>
 *
 * See the enclosed file LICENSE for license information (BSD). If you
 * did not receive this file, see http://www.horde.org/bsdl.php.
 *
 * The ldap class attempts to return user information stored in an ldap
 * directory service.
 *
 * NOTE: This code is probably terrible.  I don't run ldap. I wrote
 * this simply as a template for others to start with.  If you don't
 * like the code, please fix it!  (however, it does work!)
 *
 * @author   Eric Jon Rostetter <eric.rostetter@physics.utexas.edu>
 * @version  $Revision: 1.5.2.1 $
 * @since    Accounts 2.1
 * @package  accounts
 */
class Accounts_Driver_ldap extends Accounts_Driver {

    /** Pointer to the ldap connection. */
    var $_ds;

    /** Hash containing connection parameters. */
    var $_params;

    /**
     * Constructs a new ldap Accounts_Driver object.
     *
     * @param array  $params    A hash containing connection parameters.
     */
    function Accounts_Driver_ldap($params = array())
    {
        $this->_params['host']       = array_key_exists('host', $params)       ? $params['host'] : 'localhost';
        $this->_params['port']       = array_key_exists('port', $params)       ? $params['port'] : 389;
        $this->_params['basedn']     = array_key_exists('basedn', $params)     ? $params['basedn'] : '';
    }



    /**
     * Find the user's fullname
     *
     * @param   $username     The user for which to change the password.
     *
     * @return  mixed         User's Fullname (string) or false (error).
     */
    function getFullname($username) {

        // connect to the ldap server
        $this->_ds = ldap_connect($this->_params['host'],
                                  $this->_params['port']);
        if (!$this->_ds) {
           return PEAR::raiseError(_("Could not connect to ldap server"));
        }

        // bind as anonymous
        $result = @ldap_bind($this->_ds);
        if (!$result) {
          return PEAR::raiseError(_("Could not bind to ldap server"));
        }

        // Get the fullname
        $searchResult = ldap_search($this->_ds, $this->_params['basedn'],
                        'sn=' . $username);
        $information = ldap_get_entries($this->_ds, $searchResult);
        // FIXME: Need to check for errors here if nothing is returned above
        if ($information[0]['cn;lang-es'][0] != '') {
            $name = $information[0]['cn;lang-es'][0];
        } else {
            $name = $information[0]['cn'][0];
        }

        // disconnect from the ldap server
        @ldap_close($this->_ds);

        return (empty($name) ? false : $name);
    }

}
?>
