/*
  Copyright (C) 2000-2005 SKYRIX Software AG

  This file is part of SOPE.

  SOPE is free software; you can redistribute it and/or modify it under
  the terms of the GNU Lesser General Public License as published by the
  Free Software Foundation; either version 2, or (at your option) any
  later version.

  SOPE is distributed in the hope that it will be useful, but WITHOUT ANY
  WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
  License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with SOPE; see the file COPYING.  If not, write to the
  Free Software Foundation, 59 Temple Place - Suite 330, Boston, MA
  02111-1307, USA.
*/

#ifndef __Networking_NGImap4_NGSieveClient_H__
#define __Networking_NGImap4_NGSieveClient_H__

#import <Foundation/NSObject.h>
#include <NGStreams/NGStreams.h>
#include <NGStreams/NGSocketProtocols.h>
#include <NGImap4/NGImap4Support.h>
#include <NGImap4/NGImap4ResponseParser.h>

@class NSMutableArray, NSString, NSNumber, NSDictionary, NSArray;
@class NGSieveResponseParser, EOQualifier, NGHashMap;

typedef enum {
  UnConnected_NGSieveState = 1,
  NonAuthenticated_NGSieveState,
  Authenticated_NGSieveState,
} NGSieveState;

@interface NGSieveClient : NSObject
{
@protected
  id<NGActiveSocket>       socket;
  id<NGExtendedTextStream> text;
  id<NGSocketAddress>      address;
  NGImap4ResponseParser    *parser;

  BOOL     isLogin;

  NSString *login;
  NSString *password;

  BOOL debug;
}

+ (id)clientWithAddress:(id<NGSocketAddress>)_address;
+ (id)clientWithHost:(id)_host;

- (id)initWithHost:(id)_host;
- (id)initWithAddress:(id<NGSocketAddress>)_address;

// equality

- (BOOL)isEqual:(id)_obj;
- (BOOL)isEqualToSieveClient:(NGSieveClient *)_obj;

// accessors

- (id<NGActiveSocket>)socket;
- (id<NGSocketAddress>)address;

// connection

- (NSDictionary *)openConnection;
- (void)closeConnection;
- (NSNumber *)isConnected;
- (void)reconnect;

// commands

- (NSDictionary *)login:(NSString *)_login password:(NSString *)_passwd;
- (NSDictionary *)logout;

- (NSDictionary *)getScript:(NSString *)_scriptName;
- (NSDictionary *)putScript:(NSString *)_name script:(NSString *)_script;
- (NSDictionary *)setActiveScript:(NSString *)_name;
- (NSDictionary *)deleteScript:(NSString *)_script;
- (NSDictionary *)listScript:(NSString *)_script;

- (NSString *)description;

@end
#endif /* __Networking_NGSieve_NGSieveClient_H__ */
