/* 
   EOAdaptorDataSource.h
   
   Copyright (C) SKYRIX Software AG and Helge Hess

   Author: Helge Hess (helge.hess@opengroupware.org)
   Date:   1999-2004

   This file is part of the GNUstep Database Library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef __EOAdaptorGlobalID_H__
#define __EOAdaptorGlobalID_H__

#include <EOControl/EOGlobalID.h>

@class EOKeyGlobalID, NSDictionary;

@interface EOAdaptorGlobalID : EOGlobalID < NSCopying >
{
@protected
  EOGlobalID   *gid;
  NSDictionary *conDict;
}

- (id)initWithGlobalID:(EOGlobalID *)_gid
  connectionDictionary:(NSDictionary *)_conDict;

- (EOGlobalID *)globalID;
- (NSDictionary *)connectionDictionary;

- (BOOL)isEqual:(id)_obj;
- (BOOL)isEqualToEOAdaptorGlobalID:(EOAdaptorGlobalID *)_gid;

@end

#endif /* __EOAdaptorGlobalID_H__ */
