5.2 Iteracja i Pętle

# Iteracja i Pętle

Do tej pory spędziliśmy sporo czasu patrząc na różne dźwięki, które 
możesz zrobić użyciem bloków `play` i `sample`. Nauczyliśmy się również 
w jaki sposób uruchamiać te dźwięki na przestrzeni czasu używając 
polecenia `sleep`. 

Jak zapewne już zauważyłeś, przy korzystaniu z tych kilku podstawowych 
bloków możesz mieć *całą masę frajdy*. Jednakże, kiedy zaczniesz wykorzystywać 
możliwości kodu do porządkowania twojej muzyki i kompozycji, twoim oczom 
ukaże się zupełnie nowy wymiar możliwości i zabawy. W najbliższych 
kilku sekcjach poznasz kilka z tych potężnych narzędzi. Na początek 
zaczniemy od iteracji i pętli. 

## Powtórzenie

Czy zdarzyło ci się napisać kawalek kodu, który chciałbyś powtórzyć 
kilka razy? Przypuścmy, że napisałeś coś w tym stylu:

```
play 50
sleep 0.5
sample :elec_blup
sleep 0.5
play 62
sleep 0.25
```

Co jeśli chciałeś aby powyższy kawałek powtórzył się 3 razy? Najprostsze 
co mógłbyś zrobić to po prostu skopiować i wkleić powyższy kawałek kodu 
trzy razy: 

```
play 50
sleep 0.5
sample :elec_blup
sleep 0.5
play 62
sleep 0.25

play 50
sleep 0.5
sample :elec_blup
sleep 0.5
play 62
sleep 0.25

play 50
sleep 0.5
sample :elec_blup
sleep 0.5
play 62
sleep 0.25
```

Zobacz ile kodu! Pomyśl, co trzeba by było zrobić, gdybys chciał zmienić 
sampel na `:elec_plip`? Musiałbyś wtedy znaleźć w kodzie wszystkie miejca 
gdzie użyłeś oryginalnego sampla `:elec_blup` a zmienić je ręcznie. 
Ale to i tak nic, pomyśl co by było gdybyś chciał powtórzyć oryginalny 
blok kodu 50 albo 1000 razy? Dopiero teraz byłoby to dużo kodu, bardzo 
dużo kodu, który musiałbyś zmienić, gdybyć chciał dokonać tak prostej 
zmiany jak przełączenie się na inny sampel.

## Iteracja

W rzeczywistości, powtórzenie kodu powinno być tak proste jak powiedzenie 
*zrób to trzy razy*. Dobrze, w dużym stopniu tak jest. Pamiętasz naszego 
starego dobrego znajomego - blok kodu? Możemy użyć go aby zaznaczyć 
miejsce początku i końca kodu, który chcielibyśmy powtórzyć 3 razy. Następnie 
wystarczy, że użyjemy specjalnego kawałka kodu `3.times` (3.razy). 
Zamiast więc napisać *zrób to trzy razy*, napiszemy `3.times do` - to nie 
jest zbyt trudne. Pamiętaj tylko aby napisać polecenie `end` na końcu 
bloku kodu, który zamierzać powtórzyć:

```
3.times do
  play 50
  sleep 0.5
  sample :elec_blup
  sleep 0.5
  play 62
  sleep 0.25
end
```

Przyznasz, że takie podejście jest dużo bardziej eleganckie niż kopiowanie 
i wklejanie! Możemy użyć tego specjalnego polecenia to tworzenia wielu fajnych 
powtarzających się struktur:

```
4.times do
  play 50
  sleep 0.5
end

8.times do
  play 55, release: 0.2
  sleep 0.25
end

4.times do
  play 50
  sleep 0.5
end
```

## Zagnieżdżanie Iteracji

Możemy umieszczać jedne iteracje wewnątrz innych iteracji to utworzenia 
ciekawych wzorców. Na przykład: 

```
4.times do
  sample :drum_heavy_kick
  2.times do
    sample :elec_blip2, rate: 2
    sleep 0.25
  end
  sample :elec_snare
  4.times do
    sample :drum_tom_mid_soft
    sleep 0.125
  end
end
```

## Zapętlanie

Jeśli chcesz powtórzyć coś wiele razy, możesz złapać się na tym, że będziesz 
podawał naprawdę bardzo duże liczby jako parametr iteracji, na przykład 
`1000.times do`. W takim przypadku zapewne dużo lepiej byłoby poprosić 
Sonic Pi aby powtarzać dany wzorzec w nieskończoność (a przynajmniej do 
momentu w którym naciśniesz przycisk Stop aby zatrzymać odtwarzanie!). 
Spróbujmy zapętlić w nieskończoność sampel Amen Break: 

```
loop do
  sample :loop_amen
  sleep sample_duration :loop_amen
end
```

Bardzo ważną rzeczą do zapamiętania o pętlach jest to, że dla kodu mają 
one takie same zachowanie jak czarne dziury. Jak tylko kod raz już wejdzie 
w daną pętlę może już jej nigdy nie opuścić, chyba że naciśniesz przycisk 
Stop - nasza pętla będzie się kręcić w kółko w nieskończoność. Oznacza to, 
że jeśli masz jakiś kod, który jest umieszczony po pętli, to *nigdy* go 
nie usłyszysz. Na przykład, talerz, który znajduje się poniżej poniższej 
pętli nie zostanie zagrany nigdy: 

```
loop do
  play 50
  sleep 1
end

sample :drum_cymbal_open
```

A teraz, spróbuj poprawić strukturę twojego kodu za pomocą iteracji i pętli!
