/* Somaplayer - Copyright (C) 2003-4 bakunin - Andrea Marchesini 
 *                                     <bakunin@autistici.org>
 *
 * This source code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published 
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This source code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * Please refer to the GNU Public License for more details.
 *
 * You should have received a copy of the GNU Public License along with
 * this source code; if not, write to:
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This program is released under the GPL with the additional exemption that
 * compiling, linking, and/or using OpenSSL is allowed.
 */

#ifndef SDS_H
#define SDS_H

#include <stdio.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <unistd.h>
#include <fcntl.h>
#include <arpa/inet.h>
#include <netinet/in.h>
#include <netdb.h>
#include <sys/socket.h>

#define SDS_PORT	12321
#define SDS_LISTEN	100

#ifdef __cplusplus
extern "C"
{
#endif

  int sds_open (char *server, int port);
  int sds_set (int fd, int rate, int channels, int bitrate, int volume,
	       int balance, int solo, int mute);
  int sds_read (int fd, void *data, size_t s);
  int sds_write (int fd, void *data, size_t s);
  int sds_close (int fd);
  int sds_monitor (int fd);

#ifdef __cplusplus
}
#endif

#endif
