/* Somaplayer - Copyright (C) 2003-4 bakunin - Andrea Marchesini 
 *                                     <bakunin@autistici.org>
 *
 * This source code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published 
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This source code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * Please refer to the GNU Public License for more details.
 *
 * You should have received a copy of the GNU Public License along with
 * this source code; if not, write to:
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This program is released under the GPL with the additional exemption that
 * compiling, linking, and/or using OpenSSL is allowed.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#else
# error Use configure; make; make install
#endif

#include <sds.h>
#include <string.h>

/* Open function */
int
sds_open (char *server, int port)
{

  int fd;
  struct sockaddr_in sock;
  struct hostent *hp;

  if ((fd = socket (AF_INET, SOCK_STREAM, 0)) < 0)
    return -1;

  if (!server)
    {
      if (!(hp = gethostbyname ("127.0.0.1")))
	return -1;
    }

  else
    {
      if (!(hp = gethostbyname (server)))
	return -1;
    }

  memset ((void *) &sock, 0, sizeof (sock));
  sock.sin_family = AF_INET;
  sock.sin_addr.s_addr = ((struct in_addr *) (hp->h_addr))->s_addr;

  if (!port)
    sock.sin_port = htons (SDS_PORT);

  else
    sock.sin_port = htons (port);

  if (connect (fd, (struct sockaddr *) &sock, sizeof (sock)) < 0)
    {
      close (fd);
      return -1;
    }

  return fd;
}

/* Set your program like SdS Monitor */
int
sds_monitor (int fd)
{
  if (write (fd, "MONITOR "
#ifdef WORDS_BIGENDIAN
	     "1"
#else
	     "0"
#endif
	     "\n", 10) < 0)
    return -1;

  return 0;
}

/* Set your program like SdS Input */
int
sds_set (int fd, int rate, int channels, int bitrate, int volume, int balance,
	 int solo, int mute)
{
  char buf[50];
  int len;

  len =
    snprintf (buf, 50, "%d %d %d %d %d %d %d %d", rate, channels, bitrate,
	      volume, balance, solo, mute,
#ifdef WORDS_BIGENDIAN
	      1
#else
	      0
#endif
    );

  if (write (fd, buf, len) < 0)
    return -1;

  return 0;
}

/* Read, write and close */
int
sds_read (int fd, void *data, size_t s)
{
  return read (fd, data, s);
}

int
sds_write (int fd, void *data, size_t s)
{
  return write (fd, data, s);
}

int
sds_close (int fd)
{
  return close (fd);
}

/* EOF */
