/* Somaplayer - Copyright (C) 2003-4 bakunin - Andrea Marchesini 
 *                                     <bakunin@autistici.org>
 *
 * This source code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published 
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This source code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * Please refer to the GNU Public License for more details.
 *
 * You should have received a copy of the GNU Public License along with
 * this source code; if not, write to:
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This program is released under the GPL with the additional exemption that
 * compiling, linking, and/or using OpenSSL is allowed.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#else
# error Use configure; make; make install
#endif

#ifdef ENABLE_STREAMING
#ifdef ENABLE_ICECAST2

#include "../../player.h"
#include "streaming.h"
#include "../../file.h"
#include "../../util.h"
#include "../../other.h"
#include "../../output.h"
#include "../../ftime.h"

#ifdef ENABLE_LAME
#include "../lame/common.h"
#endif

#ifdef ENABLE_OGG
#include "../vorbis/common.h"
#endif

int
icecast2_start (audio * ao, long rate, int channels, int bitrate)
{
  audio_data_streaming *data = (audio_data_streaming *) ao->data;
  char output[1024];
  int ret;

  if (!data)
    fatal (_("Internal error."));

  if (streaming_connect (ao))
    return 1;

  ret = snprintf (output, 1024, "SOURCE /%s HTTP/1.0\n", data->mount);
  streaming_socket_write (ao, output, ret);

  switch (data->type)
    {

#ifdef ENABLE_LAME
    case OUT_LAME:
      ret = snprintf (output, 1024, "Content-type: audio/mpeg\n");
      break;
#endif

#ifdef ENABLE_OGG
    case OUT_OGG:
      ret = snprintf (output, 1024, "Content-type: application/x-ogg\n");
      break;
#endif
    }

  streaming_socket_write (ao, output, ret);

  ret = snprintf (output, 1024, "Authorization: Basic ");
  streaming_socket_write (ao, output, ret);

  snprintf (output, 1024, "source:%s", data->password);
  ret = snprintf (output, 1024, "%s", base64 (output));
  streaming_socket_write (ao, output, ret);

  streaming_socket_write (ao, "\n", 1);

  ret = snprintf (output, 1024, "User-Agent: %s %s\n", NAME, VERSION);
  streaming_socket_write (ao, output, ret);

  ret = snprintf (output, 1024, "ice-bitrate: %d\n", data->bitrate);
  streaming_socket_write (ao, output, ret);

  ret = snprintf (output, 1024, "ice-public: %d\n", data->public);
  streaming_socket_write (ao, output, ret);

  if (data->name)
    {
      ret = snprintf (output, 1024, "ice-name: %s\n", data->name);
      streaming_socket_write (ao, output, ret);
    }

  if (data->description)
    {
      ret =
	snprintf (output, 1024, "ice-description: %s\n", data->description);
      streaming_socket_write (ao, output, ret);
    }

  if (data->url)
    {
      ret = snprintf (output, 1024, "ice-url: %s\n", data->url);
      streaming_socket_write (ao, output, ret);
    }

  if (data->genre)
    {
      ret = snprintf (output, 1024, "ice-genre: %s\n", data->genre);
      streaming_socket_write (ao, output, ret);
    }

  streaming_socket_write (ao, "\n", 1);

  ret = streaming_socket_read (ao, output, 1024);

  if (ret < strlen ("HTTP/1.0 200")
      || strncmp (output, "HTTP/1.0 200", strlen ("HTTP/1.0 200")))
    {
      msg_error (_("Error icecast2 protocol."));
      streaming_quit (ao);
      return 1;
    }

  if (data->dumpfilelocal)
    {
      char *fl;

      fl = output_check_file (data->dumpfilelocal);

      if (!(data->dumpfile = fopen (fl, "wb")))
	{
	  msg_error (_("Error in write into %s file."), data->mount);
	  streaming_quit (ao);
	  free (fl);
	  return 1;
	}

      free (fl);
    }

  switch (data->type)
    {

#ifdef ENABLE_LAME
    case OUT_LAME:
      if (!
	  (data->lame =
	   lame_config (rate, data->rate, channels, data->channels,
			data->lowpass, data->highpass, data->bitrate,
			data->quality)))
	{
	  streaming_quit (ao);
	  return 1;
	}

      break;
#endif

#ifdef ENABLE_OGG
    case OUT_OGG:
      if (!
	  (data->vorbis =
	   vorbis_config (rate, channels, data->channels, data->quality,
			  data->bitrate, data->lowpass, data->name, ao,
			  streaming_socket_write)))
	{
	  streaming_quit (ao);
	  return 1;
	}
#endif
    }

  data->timer = timer_start ();

  return 0;
}

#endif
#endif
