/* Somaplayer - Copyright (C) 2003-4 bakunin - Andrea Marchesini 
 *                                     <bakunin@autistici.org>
 *
 * This source code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published 
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This source code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * Please refer to the GNU Public License for more details.
 *
 * You should have received a copy of the GNU Public License along with
 * this source code; if not, write to:
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This program is released under the GPL with the additional exemption that
 * compiling, linking, and/or using OpenSSL is allowed.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#else
# error Use configure; make; make install
#endif

#ifdef ENABLE_STREAMING

#include "../../player.h"
#include "streaming.h"
#include "../../file.h"
#include "../../other.h"

int
streaming_read_config (char *file, audio_data_streaming * streaming)
{
  cfg_t *cfg;
  int a;
  char *f, *server;

  cfg_opt_t opts[] = {
    CFG_STR ("type", "M", CFGF_NONE),

    CFG_INT ("rate", 22050, CFGF_NONE),
    CFG_INT ("quality", 8, CFGF_NONE),
    CFG_INT ("bitrate", 24, CFGF_NONE),
    CFG_INT ("channels", OUT_MONO, CFGF_NONE),

    CFG_INT ("lowpass", 0, CFGF_NONE),
    CFG_INT ("highpass", 0, CFGF_NONE),

    CFG_STR ("password", NULL, CFGF_NONE),
    CFG_STR ("server", NULL, CFGF_NONE),
    CFG_INT ("port", 0, CFGF_NONE),
    CFG_STR ("mount", NULL, CFGF_NONE),

    CFG_STR ("genre", NULL, CFGF_NONE),
    CFG_STR ("name", NULL, CFGF_NONE),
    CFG_STR ("description", NULL, CFGF_NONE),
    CFG_STR ("url", NULL, CFGF_NONE),

    CFG_BOOL ("public", cfg_true, CFGF_NONE),

    CFG_STR ("aim", NULL, CFGF_NONE),
    CFG_STR ("icq", NULL, CFGF_NONE),
    CFG_STR ("irc", NULL, CFGF_NONE),

    CFG_STR ("dumpfilelocal", NULL, CFGF_NONE),
    CFG_STR ("dumpfileremote", NULL, CFGF_NONE),
    CFG_END ()
  };

  cfg = cfg_init (opts, CFGF_NOCASE);
  a = cfg_parse (cfg, file);

  memset (streaming, 0, sizeof (audio_data_streaming));

  if (a != 0)
    {
      if (a == CFG_FILE_ERROR)
	msg_error (_("No streaming config file."));
      else if (a == CFG_PARSE_ERROR)
	msg_error (_("Error of parsing streaming file."));

      return 1;
    }

  msg (_("Read streaming config file."));

  if (!strcmp (cfg_getstr (cfg, "type"), "M")
      || !strcmp (cfg_getstr (cfg, "type"), "m"))
    streaming->type = OUT_LAME;
  else if (!strcmp (cfg_getstr (cfg, "type"), "O")
	   || !strcmp (cfg_getstr (cfg, "type"), "o"))
    streaming->type = OUT_OGG;
  else
    streaming->type = 0;

  if (!cfg_getstr (cfg, "server"))
    {
      msg_error (_("No server in streaming config file."));
      return 1;
    }

  server = cfg_getstr (cfg, "server");

  if (!strncmp (server, "http://", 7))
    {
      streaming->connect = HTTP;
      a = 7;
    }
  else if (!strncmp (server, "https://", 8))
    {
      streaming->connect = HTTPS;
      a = 8;
    }
  else
    {
      streaming->connect = HTTP;
      a = 0;
    }

  if (!(streaming->server = strdup (server + a)))
    fatal (_("Error: memory."));

  f = streaming->server;

  while (*f++)
    {
      if (*f == ':')
	{
	  *f = 0;
	  streaming->port = atoi (++f);
	}
      else if (*f == '/')
	{
	  *f = 0;
	  streaming->mount = ++f;
	}

    }

  streaming->rate = cfg_getint (cfg, "rate");
  streaming->quality = cfg_getint (cfg, "quality");
  streaming->bitrate = cfg_getint (cfg, "bitrate");
  streaming->channels = cfg_getint (cfg, "channels");
  streaming->lowpass = cfg_getint (cfg, "lowpass");
  streaming->highpass = cfg_getint (cfg, "highpass");

  if (cfg_getstr (cfg, "password"))
    streaming->password = strdup (cfg_getstr (cfg, "password"));

  if (!streaming->port)
    streaming->port = cfg_getint (cfg, "port");
  if (!streaming->mount && cfg_getstr (cfg, "mount")
      && *(cfg_getstr (cfg, "mount")))
    streaming->mount = strdup (cfg_getstr (cfg, "mount"));

  if (cfg_getstr (cfg, "genre") && *(cfg_getstr (cfg, "genre")))
    streaming->genre = strdup (cfg_getstr (cfg, "genre"));

  if (cfg_getstr (cfg, "name") && *(cfg_getstr (cfg, "name")))
    streaming->name = strdup (cfg_getstr (cfg, "name"));

  if (cfg_getstr (cfg, "description") && *(cfg_getstr (cfg, "description")))
    streaming->description = strdup (cfg_getstr (cfg, "description"));

  if (cfg_getstr (cfg, "url") && *(cfg_getstr (cfg, "url")))
    streaming->url = strdup (cfg_getstr (cfg, "url"));

  switch (cfg_getbool (cfg, "public"))
    {
    case cfg_false:
      streaming->public = 0;
      break;
    case cfg_true:
      streaming->public = 1;
      break;
    }

  if (cfg_getstr (cfg, "aim") && *(cfg_getstr (cfg, "aim")))
    streaming->aim = strdup (cfg_getstr (cfg, "aim"));

  if (cfg_getstr (cfg, "icq") && *(cfg_getstr (cfg, "icq")))
    streaming->icq = strdup (cfg_getstr (cfg, "icq"));

  if (cfg_getstr (cfg, "irc") && *(cfg_getstr (cfg, "irc")))
    streaming->irc = strdup (cfg_getstr (cfg, "irc"));

  if (cfg_getstr (cfg, "dumpfilelocal")
      && *(cfg_getstr (cfg, "dumpfilelocal")))
    streaming->dumpfilelocal = strdup (cfg_getstr (cfg, "dumpfilelocal"));

  if (cfg_getstr (cfg, "dumpfileremote")
      && *(cfg_getstr (cfg, "dumpfileremote")))
    streaming->dumpfileremote = strdup (cfg_getstr (cfg, "dumpfileremote"));

  streaming->dumpfile = NULL;

  streaming->connect = HTTP;
#ifdef ENABLE_OPENSSL
  streaming->bio = NULL;
#endif
  streaming->fd = 0;

#ifdef ENABLE_LAME
  streaming->lame = NULL;
#endif

  cfg_free (cfg);

  return 0;
}

#endif
