/* Somaplayer - Copyright (C) 2003-4 bakunin - Andrea Marchesini 
 *                                     <bakunin@autistici.org>
 *
 * This source code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published 
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This source code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * Please refer to the GNU Public License for more details.
 *
 * You should have received a copy of the GNU Public License along with
 * this source code; if not, write to:
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This program is released under the GPL with the additional exemption that
 * compiling, linking, and/or using OpenSSL is allowed.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#else
# error Use configure; make; make install
#endif
#ifdef ENABLE_MP3
#ifdef ENABLE_ID3

#include "../../player.h"
#include "../../other.h"
#include "mp3.h"

void
id3_read (int fd)
{
  struct id3_file *id3_struct = NULL;
  struct id3_tag *id3_tag = NULL;
  char *str;

  id3_struct = id3_file_fdopen (fd, ID3_FILE_MODE_READONLY);

  if (id3_struct)
    {
      id3_tag = id3_file_tag (id3_struct);

      fprintf (stderr, _("* Read id3 info: %s\n"), playing_file());
      if ((str = id3_show (id3_tag, ID3_FRAME_TITLE)))
	{
	  fprintf (stderr, _("\tTitle: %s\n"), str);
	  free (str);
	}

      if ((str = id3_show (id3_tag, ID3_FRAME_ARTIST)))
	{
	  fprintf (stderr, _("\tArtist: %s\n"), str);
	  free (str);
	}

      if ((str = id3_show (id3_tag, ID3_FRAME_ALBUM)))
	{
	  fprintf (stderr, _("\tAlbum: %s\n"), str);
	  free (str);
	}

      if ((str = id3_show (id3_tag, ID3_FRAME_YEAR)))
	{
	  fprintf (stderr, _("\tYear: %s\n"), str);
	  free (str);
	}

      if ((str = id3_show (id3_tag, ID3_FRAME_COMMENT)))
	{
	  fprintf (stderr, _("\tComment: %s\n"), str);
	  free (str);
	}

      if ((str = id3_show (id3_tag, ID3_FRAME_GENRE)))
	{
	  fprintf (stderr, _("\tGenre: %s\n"), str);
	  free (str);
	}

      free (id3_struct);
    }
}

char *
id3_show (struct id3_tag *tag, const char *what)
{
  struct id3_frame const *frame = NULL;
  union id3_field const *field = NULL;
  id3_ucs4_t const *ucs4 = NULL;
  id3_latin1_t *latin1 = NULL;
  char *str = NULL;
  int n_str, len = 0;
  register int i;

  frame = id3_tag_findframe (tag, what, 0);
  if (!frame)
    return NULL;

  field = &frame->fields[1];
  n_str = id3_field_getnstrings (field);

  for (i = 0; i < n_str; i++)
    {
      ucs4 = id3_field_getstrings (field, i);
      if (!ucs4)
	return NULL;

      latin1 = id3_ucs4_latin1duplicate (ucs4);
      if (!latin1)
	break;

      len += strlen ((char *)latin1);

      if (!str)
	{
	  str = malloc ((len + 1) * sizeof (char));
	  memset (str, 0, (len + 1) * sizeof (char));
	}

      else
	str = realloc (str, (len + 1) * sizeof (char));

      if (!str)
	fatal (_("Error: memory."));

      strncat (str, (char *)latin1, len + 1);

      free (latin1);
    }

  return str;

}
#endif
#endif
