/* Somaplayer - Copyright (C) 2003-4 bakunin - Andrea Marchesini 
 *                                     <bakunin@autistici.org>
 *
 * This source code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published 
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This source code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * Please refer to the GNU Public License for more details.
 *
 * You should have received a copy of the GNU Public License along with
 * this source code; if not, write to:
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This program is released under the GPL with the additional exemption that
 * compiling, linking, and/or using OpenSSL is allowed.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#else
# error Use configure; make; make install
#endif

#include "../player.h"
#include "graphic.h"

void
msg_statusbar (char *what, ...)
{
  va_list va;
  char s[SIZE_BUFFER];
  int ret;

  va_start (va, what);

  ret = vsnprintf (s, SIZE_BUFFER, what, va);

  while (s[ret] == '\n' || s[ret] == '\r')
    ret--;

  s[ret] = 0;

  pthread_mutex_lock (&gmutex);

  gtk_statusbar_pop (GTK_STATUSBAR (statusbar), statusbar_id);
  statusbar_id =
    gtk_statusbar_push (GTK_STATUSBAR (statusbar), statusbar_id, s);

  pthread_mutex_unlock (&gmutex);

  va_end (va);
}

/* EOF */
