/* Somaplayer - Copyright (C) 2003-4 bakunin - Andrea Marchesini 
 *                                     <bakunin@autistici.org>
 *
 * This source code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published 
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This source code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * Please refer to the GNU Public License for more details.
 *
 * You should have received a copy of the GNU Public License along with
 * this source code; if not, write to:
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This program is released under the GPL with the additional exemption that
 * compiling, linking, and/or using OpenSSL is allowed.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#else
# error Use configure; make; make install
#endif

#include "../player.h"
#include "../file.h"
#include "../list.h"
#include "../playlist.h"
#include "graphic.h"

void playlist_select_all (GtkWidget *, gpointer);

void
playlist_add (char *fl)
{

  if (list_add (fl))
    {
      char s[SIZE_BUFFER];

      snprintf (s, SIZE_BUFFER, _("No support for this type of file: %s"),
		fl);
      gtk_dialog_msg (s);
      return;
    }

  playlist_refresh ();
}

void
playlist_select_all (GtkWidget * w, gpointer n)
{
  gtk_tree_selection_select_all (p_selection);
}

void
playlist_select (void)
{
  int k = 0;
  char b[10];
  list *tmp;

  pthread_mutex_lock (&play->m_list);

  tmp = play->first;


  while (tmp)
    {

      if (tmp == play->this)
	break;

      k++;
      tmp = tmp->next;
    }

  pthread_mutex_unlock (&play->m_list);

  if (!tmp)
    return;

  snprintf (b, 10, "%d", k);
  gtk_tree_selection_unselect_all (p_selection);
  gtk_tree_selection_select_path (p_selection,
				  gtk_tree_path_new_from_string (b));
}

void
playlist_refresh (void)
{
  GtkTreeModel *model;
  GtkTreeIter iter;
  list *tmp;
  char *utf8;

  pthread_mutex_lock (&play->m_list);

  tmp = play->first;

  model = gtk_tree_view_get_model (GTK_TREE_VIEW (playlist));
  while (gtk_tree_model_iter_nth_child
	 (GTK_TREE_MODEL (model), &iter, NULL, 0))
    gtk_list_store_remove (GTK_LIST_STORE (model), &iter);

  while (tmp)
    {

      utf8 =
	g_convert (tmp->name, strlen (tmp->name), "UTF-8", "ISO-8859-1", NULL,
		   NULL, NULL);
      gtk_list_store_append (GTK_LIST_STORE (model), &iter);
      gtk_list_store_set (GTK_LIST_STORE (model), &iter, 0, utf8, -1);
      free (utf8);

      tmp = tmp->next;
    }

  pthread_mutex_unlock (&play->m_list);
}

void
on_b_remove_clicked (GtkWidget * widget, GtkTreeSelection * selection)
{
  GtkTreeModel *model;
  GList *list;
  int k;
  int j = 0;

  if (!selection)
    return;

  list = gtk_tree_selection_get_selected_rows (selection, &model);

  while (list)
    {
      k = gtk_tree_path_get_indices (list->data)[0];
      gtk_tree_path_free (list->data);

      list_remove (k - j);
      j++;

      list = list->next;
    }

  g_list_free (list);

  playlist_refresh ();
}

GtkWidget *
add_menu (void)
{
  GtkWidget *menu;
  GtkWidget *file;
  GtkWidget *dir;
#ifdef ENABLE_CDAUDIO
  GtkWidget *cdrom;
#endif
  GtkWidget *stream;
  GtkWidget *pl;

  menu = gtk_menu_new ();

  file = gtk_menu_item_new_with_mnemonic (_("file"));
  gtk_widget_show (file);
  gtk_container_add (GTK_CONTAINER (menu), file);

  g_signal_connect ((gpointer) file, "activate",
		    G_CALLBACK (add_file_activate), NULL);

  dir = gtk_menu_item_new_with_mnemonic (_("directory"));
  gtk_widget_show (dir);
  gtk_container_add (GTK_CONTAINER (menu), dir);

  g_signal_connect ((gpointer) dir, "activate",
		    G_CALLBACK (add_dir_activate), NULL);

#ifdef ENABLE_CDAUDIO
  cdrom = gtk_menu_item_new_with_mnemonic (_("cdaudio"));
  gtk_widget_show (cdrom);
  gtk_container_add (GTK_CONTAINER (menu), cdrom);

  g_signal_connect ((gpointer) cdrom, "activate",
		    G_CALLBACK (add_cdaudio_activate), NULL);
#endif

  stream = gtk_menu_item_new_with_mnemonic (_("stream"));
  gtk_widget_show (stream);
  gtk_container_add (GTK_CONTAINER (menu), stream);

  g_signal_connect ((gpointer) stream, "activate",
		    G_CALLBACK (add_stream_activate), NULL);

  pl = gtk_menu_item_new_with_mnemonic (_("playlist"));
  gtk_widget_show (pl);
  gtk_container_add (GTK_CONTAINER (menu), pl);

  g_signal_connect ((gpointer) pl, "activate",
		    G_CALLBACK (add_pl_activate), NULL);

  return menu;
}

GtkWidget *
playlist_menu (void)
{
  GtkWidget *menu;
  GtkWidget *file;
  GtkWidget *dir;
#ifdef ENABLE_CDAUDIO
  GtkWidget *cdrom;
#endif
  GtkWidget *stream;
  GtkWidget *pl;
  GtkWidget *separator;
  GtkWidget *remove;
  GtkWidget *sep;
  GtkWidget *select_all;
  GtkWidget *cancel;

  menu = gtk_menu_new ();

  file = gtk_menu_item_new_with_mnemonic (_("add file"));
  gtk_widget_show (file);
  gtk_container_add (GTK_CONTAINER (menu), file);

  g_signal_connect ((gpointer) file, "activate",
		    G_CALLBACK (add_file_activate), NULL);

  dir = gtk_menu_item_new_with_mnemonic (_("add directory"));
  gtk_widget_show (dir);
  gtk_container_add (GTK_CONTAINER (menu), dir);

  g_signal_connect ((gpointer) dir, "activate",
		    G_CALLBACK (add_dir_activate), NULL);

#ifdef ENABLE_CDAUDIO
  cdrom = gtk_menu_item_new_with_mnemonic (_("add cdaudio track"));
  gtk_widget_show (cdrom);
  gtk_container_add (GTK_CONTAINER (menu), cdrom);

  g_signal_connect ((gpointer) cdrom, "activate",
		    G_CALLBACK (add_cdaudio_activate), NULL);
#endif

  stream = gtk_menu_item_new_with_mnemonic (_("add stream"));
  gtk_widget_show (stream);
  gtk_container_add (GTK_CONTAINER (menu), stream);

  g_signal_connect ((gpointer) stream, "activate",
		    G_CALLBACK (add_stream_activate), NULL);

  pl = gtk_menu_item_new_with_mnemonic (_("add playlist"));
  gtk_widget_show (pl);
  gtk_container_add (GTK_CONTAINER (menu), pl);

  g_signal_connect ((gpointer) pl, "activate",
		    G_CALLBACK (add_pl_activate), NULL);

  separator = gtk_menu_item_new ();
  gtk_widget_show (separator);
  gtk_container_add (GTK_CONTAINER (menu), separator);
  gtk_widget_set_sensitive (separator, FALSE);

  remove = gtk_menu_item_new_with_mnemonic (_("remove item"));
  gtk_widget_show (remove);
  gtk_container_add (GTK_CONTAINER (menu), remove);

  g_signal_connect ((gpointer) remove, "activate",
		    G_CALLBACK (on_b_remove_clicked), p_selection);

  sep = gtk_menu_item_new ();
  gtk_widget_show (sep);
  gtk_container_add (GTK_CONTAINER (menu), sep);

  select_all = gtk_menu_item_new_with_mnemonic (_("select all"));
  gtk_widget_show (select_all);
  gtk_container_add (GTK_CONTAINER (menu), select_all);

  g_signal_connect ((gpointer) select_all, "activate",
		    G_CALLBACK (playlist_select_all), NULL);

  cancel = gtk_menu_item_new_with_mnemonic (_("cancel"));
  gtk_widget_show (cancel);
  gtk_container_add (GTK_CONTAINER (menu), cancel);

  return menu;
}

gint
playlist_menu_popup (GtkWidget * widget, GdkEventButton * event)
{
  if (event->type == GDK_2BUTTON_PRESS)
    {
      GtkTreeModel *model;
      GList *list;
      int k;

      list = gtk_tree_selection_get_selected_rows (p_selection, &model);

      if (list)
	{
	  k = gtk_tree_path_get_indices (list->data)[0];

	  playlist_selected = k;
	  events.skip = 1;

	  if (events.stop)
	    events.stop = 0;
	  if (events.pause)
	    events.pause = 0;

	  pthread_cond_signal (&play->p_pop);
	}

      g_list_free (list);

    }
  else if (event->button == 3)
    {
      GdkEventButton *bevent = (GdkEventButton *) event;

      gtk_menu_popup (GTK_MENU (widget), NULL, NULL, NULL, NULL,
		      bevent->button, bevent->time);

      return TRUE;
    }

  return FALSE;
}

gint
add_menu_popup (GtkWidget * widget, GdkEventButton * event)
{
  if (event->type == GDK_BUTTON_PRESS)
    {
      GdkEventButton *bevent = (GdkEventButton *) event;

      gtk_menu_popup (GTK_MENU (widget), NULL, NULL, NULL, NULL,
		      bevent->button, bevent->time);

      return TRUE;
    }

  return FALSE;
}

void
playlist_save (char *filename)
{
  struct stat st;
  FILE *fl;
  list *tmp;

  if (!filename)
    return;

  if (!lstat (filename, &st))
    {
      char buf[SIZE_BUFFER];

      snprintf (buf, SIZE_BUFFER, "%s exists! Overwrite?", filename);

      if (gtk_dialog_ask (buf) == GTK_RESPONSE_NO)
	return;

    }

  if (!(fl = fopen (filename, "w")))
    {
      gtk_dialog_msg ("I can't open your playlist.");
      return;
    }

  pthread_mutex_lock (&play->m_list);

  tmp = play->first;
  while (tmp)
    {
      fprintf (fl, "%s\n", tmp->filename);

      tmp = tmp->next;
    }

  pthread_mutex_unlock (&play->m_list);

  fclose (fl);

  gtk_dialog_msg ("Playlist saved.");
}

void
playlist_dump ()
{
  char filename[SIZE_BUFFER];
  FILE *fl;
  list *tmp;

  snprintf (filename, SIZE_BUFFER, "%s/.somaplayer.dump", getenv ("HOME"));

  if (!(fl = fopen (filename, "w")))
    return;

  pthread_mutex_lock (&play->m_list);

  tmp = play->first;

  while (tmp)
    {
      fprintf (fl, "%s\n", tmp->filename);

      tmp = tmp->next;
    }

  pthread_mutex_unlock (&play->m_list);

  fclose (fl);
}

void
playlist_restore (void)
{
  char filename[SIZE_BUFFER];

  if (playing_list ())
    return;

  snprintf (filename, SIZE_BUFFER, "%s/.somaplayer.dump", getenv ("HOME"));

  playlist_read (filename);
}

/* EOF */
