/* Somaplayer - Copyright (C) 2003-4 bakunin - Andrea Marchesini 
 *                                     <bakunin@autistici.org>
 *
 * This source code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published 
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This source code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * Please refer to the GNU Public License for more details.
 *
 * You should have received a copy of the GNU Public License along with
 * this source code; if not, write to:
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This program is released under the GPL with the additional exemption that
 * compiling, linking, and/or using OpenSSL is allowed.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#else
# error Use configure; make; make install
#endif

#ifdef ENABLE_OGG

#include "../player.h"
#include "../audio.h"
#include "graphic.h"
#include "../other.h"

void
on_ogg_show_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  GtkWidget *dialog;
  GtkWidget *box;
  GtkWidget *table;
  GtkWidget *stock;
  GtkWidget *label;

  GtkWidget *rate;
  GtkWidget *quality;
  GtkWidget *bitrate;
  GtkWidget *channels;
  GtkWidget *lowpass;
  GtkWidget *highpass;
  GtkWidget *file;

  audio *ao = (audio *) user_data;
  audio_data_vorbis *vorbis;
  char s[SIZE_BUFFER];

  if (!ao)
    return;

  vorbis = ao->data;
  if (!vorbis)
    return;

  dialog =
    gtk_dialog_new_with_buttons (_("SomaPlayer - ogg/vorbis configuration"),
				 GTK_WINDOW (winmain),
				 GTK_DIALOG_MODAL |
				 GTK_DIALOG_DESTROY_WITH_PARENT,
				 GTK_STOCK_SAVE, 100,
				 GTK_STOCK_OK, GTK_RESPONSE_OK, NULL);

  box = gtk_hbox_new (FALSE, 8);
  gtk_container_set_border_width (GTK_CONTAINER (box), 8);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox), box, FALSE, FALSE,
		      0);

  stock =
    gtk_image_new_from_stock (GTK_STOCK_DIALOG_INFO, GTK_ICON_SIZE_DIALOG);
  gtk_box_pack_start (GTK_BOX (box), stock, FALSE, FALSE, 0);

  table = gtk_table_new (0, 0, FALSE);
  gtk_table_set_row_spacings (GTK_TABLE (table), 4);
  gtk_table_set_col_spacings (GTK_TABLE (table), 4);
  gtk_box_pack_start (GTK_BOX (box), table, TRUE, TRUE, 0);

  label = gtk_label_new_with_mnemonic (_("Rate:"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 0, 1);
  rate = (GtkWidget *) gtk_entry_new ();
  snprintf (s, SIZE_BUFFER, "%d", vorbis->rate);
  gtk_entry_set_text (GTK_ENTRY (rate), s);
  gtk_entry_set_editable (GTK_ENTRY (rate), FALSE);
  gtk_table_attach_defaults (GTK_TABLE (table), rate, 1, 2, 0, 1);

  label = gtk_label_new_with_mnemonic (_("Quality:"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 1, 2);
  quality = gtk_entry_new ();
  snprintf (s, SIZE_BUFFER, "%d", vorbis->quality);
  gtk_entry_set_text (GTK_ENTRY (quality), s);
  gtk_entry_set_editable (GTK_ENTRY (quality), FALSE);
  gtk_table_attach_defaults (GTK_TABLE (table), quality, 1, 2, 1, 2);

  label = gtk_label_new_with_mnemonic (_("Bitrate:"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 2, 3);
  bitrate = gtk_entry_new ();
  snprintf (s, SIZE_BUFFER, "%d", vorbis->bitrate);
  gtk_entry_set_text (GTK_ENTRY (bitrate), s);
  gtk_entry_set_editable (GTK_ENTRY (bitrate), FALSE);
  gtk_table_attach_defaults (GTK_TABLE (table), bitrate, 1, 2, 2, 3);

  label = gtk_label_new_with_mnemonic (_("Channels:"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 3, 4);
  channels = gtk_entry_new ();
  snprintf (s, SIZE_BUFFER, "%s", vorbis->channels == 1 ? "MONO" : "STEREO");
  gtk_entry_set_text (GTK_ENTRY (channels), s);
  gtk_entry_set_editable (GTK_ENTRY (channels), FALSE);
  gtk_table_attach_defaults (GTK_TABLE (table), channels, 1, 2, 3, 4);

  label = gtk_label_new_with_mnemonic (_("LowPass:"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 4, 5);
  lowpass = gtk_entry_new ();
  snprintf (s, SIZE_BUFFER, "%d", vorbis->lowpass);
  gtk_entry_set_text (GTK_ENTRY (lowpass), s);
  gtk_entry_set_editable (GTK_ENTRY (lowpass), FALSE);
  gtk_table_attach_defaults (GTK_TABLE (table), lowpass, 1, 2, 4, 5);

  label = gtk_label_new_with_mnemonic (_("HighPass:"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 5, 6);
  highpass = gtk_entry_new ();
  snprintf (s, SIZE_BUFFER, "%d", vorbis->highpass);
  gtk_entry_set_text (GTK_ENTRY (highpass), s);
  gtk_entry_set_editable (GTK_ENTRY (highpass), FALSE);
  gtk_table_attach_defaults (GTK_TABLE (table), highpass, 1, 2, 5, 6);

  label = gtk_label_new_with_mnemonic (_("File Output:"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 6, 7);
  file = gtk_entry_new ();
  gtk_entry_set_text (GTK_ENTRY (file), vorbis->file);
  gtk_entry_set_editable (GTK_ENTRY (file), FALSE);
  gtk_table_attach_defaults (GTK_TABLE (table), file, 1, 2, 6, 7);

  gtk_widget_show_all (box);

  while (1)
    {
      if (gtk_dialog_run (GTK_DIALOG (dialog)) == 100)
	{
	  GtkWidget *fs;
	  char s[1024];

	  snprintf (s, 1024, "%s %s - Save Ogg config file", NAME, VERSION);
	  fs =
	    gtk_file_chooser_dialog_new (s, GTK_WINDOW (winmain),
					 GTK_FILE_CHOOSER_ACTION_SAVE,
					 GTK_STOCK_CANCEL,
					 GTK_RESPONSE_CANCEL, GTK_STOCK_SAVE,
					 GTK_RESPONSE_ACCEPT, NULL);

	  if (gtk_dialog_run (GTK_DIALOG (fs)) == GTK_RESPONSE_ACCEPT)
	    {
	      FILE *fl;
	      char *file =
		(char *)
		gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (fs));

	      gtk_widget_destroy (fs);

	      if (dialog_test_file (file))
		{
		  free (file);
		  continue;
		}

	      if (!(fl = fopen (file, "w")))
		{
		  msg_error ("I can't open %s", file);
		  free (file);
		  continue;
		}

	      fprintf (fl, "type = M\n");
	      fprintf (fl, "rate = %d\n", vorbis->rate);
	      fprintf (fl, "quality = %d\n", vorbis->quality);
	      fprintf (fl, "bitrate = %d\n", vorbis->bitrate);
	      fprintf (fl, "channels = %d\n", vorbis->channels);
	      fprintf (fl, "lowpass = %d\n", vorbis->lowpass);
	      fprintf (fl, "highpass = %d\n", vorbis->highpass);
	      fprintf (fl, "file = \"%s\"\n", vorbis->file);
	      fclose (fl);
	      free (file);

	      gtk_dialog_msg (_("Ogg config saved!"));
	    }

	  continue;
	}
      else
	break;
    }

  gtk_widget_destroy (dialog);
}

#endif

/* EOF */
