/* Somaplayer - Copyright (C) 2003-4 bakunin - Andrea Marchesini 
 *                                     <bakunin@autistici.org>
 *
 * This source code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published 
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This source code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * Please refer to the GNU Public License for more details.
 *
 * You should have received a copy of the GNU Public License along with
 * this source code; if not, write to:
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This program is released under the GPL with the additional exemption that
 * compiling, linking, and/or using OpenSSL is allowed.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#else
# error Use configure; make; make install
#endif

#ifdef ENABLE_DAEMON

#include "../player.h"
#include "../audio.h"
#include "../output.h"
#include "../other.h"
#include "../output/daemon/daemon.h"
#include "graphic.h"
#include "../sds/sds.h"

struct daemon_e_s
{
  GtkWidget *u;
  GtkWidget *t;
} daemon_e;

void o_daemon_tcp (GtkWidget *, gpointer);
void o_daemon_unix (GtkWidget *, gpointer);

void
on_sds_new_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  GtkWidget *dialog;
  GtkWidget *box;
  GtkWidget *frame;
  GtkWidget *radiobutton;
  GtkWidget *stock;
  GtkWidget *label;
  GSList *group = NULL;

  GtkWidget *socket;

  GtkWidget *server;
  GtkWidget *port;

  GtkAdjustment *port_adj;

  GtkWidget *box_unix;
  GtkWidget *table_tcp;

  audio *tmp;

  char buf[SIZE_BUFFER];

  dialog =
    gtk_dialog_new_with_buttons (_("SomaPlayer - SdS configuration"),
				 GTK_WINDOW (winmain),
				 GTK_DIALOG_MODAL |
				 GTK_DIALOG_DESTROY_WITH_PARENT, GTK_STOCK_OK,
				 GTK_RESPONSE_OK, GTK_STOCK_CANCEL,
				 GTK_RESPONSE_CANCEL, NULL);

  box = gtk_hbox_new (FALSE, 8);
  gtk_container_set_border_width (GTK_CONTAINER (box), 8);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox), box, FALSE, FALSE,
		      0);

  stock =
    gtk_image_new_from_stock (GTK_STOCK_DIALOG_QUESTION,
			      GTK_ICON_SIZE_DIALOG);
  gtk_box_pack_start (GTK_BOX (box), stock, FALSE, FALSE, 0);

  frame = gtk_frame_new (NULL);
  gtk_widget_show (frame);
  gtk_box_pack_start (GTK_BOX (box), frame, TRUE, TRUE, 0);

  radiobutton = gtk_radio_button_new_with_mnemonic (group, _("Unix Socket"));
  gtk_widget_show (radiobutton);
  group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (radiobutton));
  gtk_frame_set_label_widget (GTK_FRAME (frame), radiobutton);

  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radiobutton), TRUE);

  box_unix = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (box_unix);
  gtk_container_add (GTK_CONTAINER (frame), box_unix);

  daemon_e.u = box_unix;
  g_signal_connect ((gpointer) radiobutton, "toggled",
		    G_CALLBACK (o_daemon_unix), NULL);

  label = gtk_label_new (_("Socket File: "));
  gtk_widget_show (label);
  gtk_box_pack_start (GTK_BOX (box_unix), label, FALSE, FALSE, 0);

  socket = gtk_entry_new ();
  gtk_widget_show (socket);
  gtk_box_pack_start (GTK_BOX (box_unix), socket, TRUE, TRUE, 0);
  snprintf (buf, SIZE_BUFFER, "AUTO");
  gtk_entry_set_text (GTK_ENTRY (socket), buf);

  frame = gtk_frame_new (NULL);
  gtk_widget_show (frame);
  gtk_box_pack_start (GTK_BOX (box), frame, TRUE, TRUE, 0);

  radiobutton = gtk_radio_button_new_with_mnemonic (group, _("Tcp Socket"));
  gtk_widget_show (radiobutton);
  group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (radiobutton));
  gtk_frame_set_label_widget (GTK_FRAME (frame), radiobutton);

  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radiobutton), FALSE);

  table_tcp = gtk_table_new (0, 0, FALSE);
  gtk_widget_show (table_tcp);
  gtk_container_add (GTK_CONTAINER (frame), table_tcp);

  daemon_e.t = table_tcp;
  g_signal_connect ((gpointer) radiobutton, "toggled",
		    G_CALLBACK (o_daemon_tcp), NULL);

  label = gtk_label_new (_("Server: "));
  gtk_widget_show (label);
  gtk_table_attach (GTK_TABLE (table_tcp), label, 0, 1, 0, 1, GTK_FILL,
		    GTK_FILL, 0, 0);

  server = gtk_entry_new ();
  gtk_widget_show (server);
  gtk_table_attach (GTK_TABLE (table_tcp), server, 1, 2, 0, 1,
		    GTK_FILL | GTK_EXPAND, GTK_FILL, 0, 0);
  gtk_entry_set_text (GTK_ENTRY (server), "localhost");

  label = gtk_label_new (_("Port: "));
  gtk_widget_show (label);
  gtk_table_attach (GTK_TABLE (table_tcp), label, 0, 1, 1, 2, GTK_FILL,
		    GTK_FILL, 0, 0);

  port_adj =
    (GtkAdjustment *) gtk_adjustment_new (SDS_PORT, 0, 65536, 1, 10, 10);
  port = gtk_spin_button_new (port_adj, 1, 0);
  gtk_widget_show (port);
  gtk_table_attach (GTK_TABLE (table_tcp), port, 1, 2, 1, 2,
		    GTK_FILL | GTK_EXPAND, GTK_FILL, 0, 0);

  gtk_widget_show_all (box);

  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radiobutton), TRUE);
  gtk_widget_set_sensitive (daemon_e.u, FALSE);
  gtk_widget_set_sensitive (daemon_e.t, TRUE);

  while (1)
    {

      if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_OK)
	{
	  char s[SIZE_BUFFER];

	  if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (radiobutton))
	      == TRUE)
	    {

	      if (!strlen (gtk_entry_get_text (GTK_ENTRY (server))))
		{
		  gtk_dialog_msg (_("No server?"));
		  continue;
		}

	      snprintf (s, SIZE_BUFFER, "tcp://%s:%d",
			gtk_entry_get_text (GTK_ENTRY (server)),
			(int)
			gtk_spin_button_get_value (GTK_SPIN_BUTTON (port)));

	    }
	  else
	    {

	      if (!strlen (gtk_entry_get_text (GTK_ENTRY (socket)))
		  || !strcasecmp (gtk_entry_get_text (GTK_ENTRY (socket)),
				  "AUTO"))
		snprintf (s, SIZE_BUFFER, "unix");
	      else
		snprintf (s, SIZE_BUFFER, "unix://%s",
			  gtk_entry_get_text (GTK_ENTRY (socket)));
	    }


	  if (!(tmp = (audio *) malloc (sizeof (audio))))
	    fatal (_("Error: memory."));

	  tmp->audio_type = USE_DAEMON;

	  tmp->realtime = 0;

	  tmp->open = daemon_output_init;
	  tmp->write = daemon_output_write;
	  tmp->close = daemon_output_close;
	  tmp->check = NULL;
	  tmp->info = daemon_output_show;
	  tmp->data = NULL;
	  tmp->next = NULL;
	  tmp->status = OUTPUT_DONE;

	  tmp->stop = 0;

	  if (!(tmp->audio_dev = strdup (s)))
	    fatal (_("Error: memory."));

	  if (pthread_cond_init (&tmp->cond, NULL))
	    fatal (_("Error: Cond init."));
	  if (pthread_mutex_init (&tmp->mutex, NULL))
	    fatal (_("Error: Mutex init."));
	  if (pthread_create (&tmp->th, NULL, output_thread, tmp))
	    fatal (_("Thread error."));

	  if (play->ao_rate && play->ao_channels && play->ao_bitrate)
	    {
	      if (tmp->
		  open (tmp, play->ao_rate, play->ao_channels,
			play->ao_bitrate))
		{
		  free (tmp->audio_dev);
		  free (tmp);
		}
	      else
		{

		  tmp->info (tmp);

		  output_lock ();

		  tmp->next = play->output;
		  play->output = tmp;

		  output_unlock ();

		  output_window_add (tmp, PREPEND);
		}
	    }
	  else
	    {
	      output_lock ();

	      tmp->next = play->output;
	      play->output = tmp;

	      output_unlock ();

	      output_window_add (tmp, PREPEND);

	    }
	}
      break;
    }

  gtk_widget_destroy (dialog);
}

void
o_daemon_unix (GtkWidget * w, gpointer dummy)
{
  if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (w)) == FALSE)
    return;

  gtk_widget_set_sensitive (daemon_e.t, FALSE);
  gtk_widget_set_sensitive (daemon_e.u, TRUE);
}

void
o_daemon_tcp (GtkWidget * w, gpointer dummy)
{
  if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (w)) == FALSE)
    return;

  gtk_widget_set_sensitive (daemon_e.u, FALSE);
  gtk_widget_set_sensitive (daemon_e.t, TRUE);
}

#endif

/* EOF */
