/*
 **************************************************************************
 * NetX XPEC emulation 
 *
 * (C) 2009 Jochen Karrer
 *
 *  This program is free software; you can distribute it and/or modify it
 *  under the terms of the GNU General Public License (Version 2) as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 *  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston MA 02111-1307, USA.
 **************************************************************************
 *
 */
#include <stdint.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <ctype.h>

#include "bus.h"
#include "sgstring.h"

typedef struct XPec {
	BusDevice bdev;
	uint32_t size;
	uint8_t *host_mem;
} XPec;

static void
XPec_Map(void *module_owner,uint32_t base,uint32_t mapsize,uint32_t flags) 
{
	XPec *xpec = module_owner;
	flags &= MEM_FLAG_READABLE|MEM_FLAG_WRITABLE;
	Mem_MapRange(base,xpec->host_mem,xpec->size,mapsize,flags);
}

static void
XPec_UnMap(void *module_owner,uint32_t base,uint32_t mapsize) {
	Mem_UnMapRange(base,mapsize); 
}

/*
 **************************************
 * XPEC New
 **************************************
 */
BusDevice *
XPec_New(const char *name) {
	XPec *xpec;
	xpec = sg_new(XPec);
	xpec->size = 0x4000;
	xpec->host_mem=sg_calloc(xpec->size);
	xpec->bdev.first_mapping=NULL;
	xpec->bdev.Map=XPec_Map;
	xpec->bdev.UnMap=XPec_UnMap;
	xpec->bdev.owner=xpec;
	xpec->bdev.hw_flags=MEM_FLAG_WRITABLE|MEM_FLAG_READABLE;
	fprintf(stderr,"XPEC \"%s\" created\n",name);
	return &xpec->bdev;
}
