/*
 **************************************************************************
 * NetX XMAC emulation 
 *
 * (C) 2009 Jochen Karrer
 *
 *  This program is free software; you can distribute it and/or modify it
 *  under the terms of the GNU General Public License (Version 2) as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 *  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston MA 02111-1307, USA.
 **************************************************************************
 *
 */
#include <stdint.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <ctype.h>

#include "bus.h"
#include "sgstring.h"

typedef struct XMac {
	BusDevice bdev;
	uint32_t size;
	uint8_t *host_mem;
} XMac;

static void
XMac_Map(void *module_owner,uint32_t base,uint32_t mapsize,uint32_t flags) 
{
	XMac *xmac = module_owner;
	flags &= MEM_FLAG_READABLE|MEM_FLAG_WRITABLE;
	Mem_MapRange(base,xmac->host_mem,xmac->size,mapsize,flags);
}

static void
XMac_UnMap(void *module_owner,uint32_t base,uint32_t mapsize) {
	Mem_UnMapRange(base,mapsize); 
}

/*
 **************************************
 * XPEC New
 **************************************
 */
BusDevice *
XMac_New(const char *name) {
	XMac *xmac;
	xmac = sg_new(XMac);
	xmac->size = 0x1000;
	xmac->host_mem=sg_calloc(xmac->size);
	xmac->bdev.first_mapping=NULL;
	xmac->bdev.Map=XMac_Map;
	xmac->bdev.UnMap=XMac_UnMap;
	xmac->bdev.owner=xmac;
	xmac->bdev.hw_flags=MEM_FLAG_WRITABLE|MEM_FLAG_READABLE;
	fprintf(stderr,"XPEC \"%s\" created\n",name);
	return &xmac->bdev;
}
