/*
 * -----------------------------------------------------------------------
 * Emulation of Coldfire Programmable Interrupt Timers 
 *
 * (C) 2008 Jochen Karrer
 *   Author: Jochen Karrer
 *
 * State: not implemented
 *
 *  This program is free software; you can distribute it and/or modify it
 *  under the terms of the GNU General Public License (Version 2) as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 *  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston MA 02111-1307, USA.
 * -----------------------------------------------------------------------
 */


#include <errno.h>
#include <stdint.h>
#include <string.h>
#include <unistd.h>
#include <time.h>
#include <sys/ioctl.h>
#include <sys/fcntl.h>
#include <bus.h>
#include <fio.h>
#include <signode.h>
#include <configfile.h>
#include <clock.h>
#include <cycletimer.h>
#include <sgstring.h>
#include <mcf5282_pit.h>

#define PIT_PSCR(base)	((base) + 0x0)
#define		PSCR_PRE_MASK	(0xf<<8)
#define		PSCR_PRE_SHIFT	(8)
#define 	PSCR_DOZE	(1<<6)
#define		PSCR_HALTED	(1<<5)
#define 	PSCR_OVW	(1<<4)
#define		PSCR_PIE	(1<<3)
#define		PSCR_PIF	(1<<2)
#define		PSCR_RLD	(1<<1)
#define		PSCR_EN		(1<<0)

#define PIT_PMR(base)	((base) + 0x2)
#define PIT_PCNTR(base)	((base) + 0x4)

typedef struct Pit {
	BusDevice bdev;
	Clock_t *clockIn;
	CycleCounter_t last_counter_update;
	CycleCounter_t remainder;
	uint16_t pcsr;	
	uint16_t pmr;
	uint16_t pcntr;
} Pit;


static void
actualize_counter(Pit *pit)
{
	int pre;
	uint32_t prediv;
//	uint32_t cycles_per_period;
//	Frequency_t freq = Clock_Freq(pit->clockIn); 
	pit->remainder += CycleCounter_Get() - pit->last_counter_update;	
	pre = (pit->pcsr >> 12) & 0xf;
	prediv = (4 << pre);
//	cycles_per_period = 
}

static uint32_t
pcsr_read(void *clientData,uint32_t address,int rqlen)
{
        fprintf(stderr,"PIT pcsr not implented\n");
        return 0;
}

static void
pcsr_write(void *clientData,uint32_t value,uint32_t address,int rqlen)
{
	Pit *pit = (Pit *) clientData;
	pit->pcsr = value;
	// update 
        fprintf(stderr,"PIT pcsr not implented\n");
}

static uint32_t
pmr_read(void *clientData,uint32_t address,int rqlen)
{
        fprintf(stderr,"PIT pmr not implented\n");
        return 0;
}

static void
pmr_write(void *clientData,uint32_t value,uint32_t address,int rqlen)
{
        fprintf(stderr,"PIT pmr not implented\n");
}

static uint32_t
pcntr_read(void *clientData,uint32_t address,int rqlen)
{
	Pit *pit = (Pit *) clientData;
	actualize_counter(pit);
        return pit->pcntr;
}

static void
pcntr_write(void *clientData,uint32_t value,uint32_t address,int rqlen)
{
        fprintf(stderr,"PIT pcntr not implented\n");
}

static void
Pit_Unmap(void *owner,uint32_t base,uint32_t mask)
{
        IOH_Delete16(PIT_PSCR(base));
        IOH_Delete16(PIT_PMR(base));
        IOH_Delete16(PIT_PCNTR(base));
}

static void
Pit_Map(void *owner,uint32_t base,uint32_t mask,uint32_t mapflags)
{
        Pit *pit = (Pit *) owner;
        IOH_New16(PIT_PSCR(base),pcsr_read,pcsr_write,pit);
        IOH_New16(PIT_PMR(base),pmr_read,pmr_write,pit);
        IOH_New16(PIT_PCNTR(base),pcntr_read,pcntr_write,pit);
}


BusDevice *
MCF5282_PitNew(const char *name)
{
        Pit *pit = sg_calloc(sizeof(Pit));
	pit->pcsr = 0;
	pit->pmr = 0xffff;
	pit->pcntr = 0xffff;
        pit->bdev.first_mapping=NULL;
        pit->bdev.Map=Pit_Map;
        pit->bdev.UnMap=Pit_Unmap;
        pit->bdev.owner=pit;
        pit->bdev.hw_flags=MEM_FLAG_WRITABLE|MEM_FLAG_READABLE;
        return &pit->bdev;
}

