/* Snownews - A lightweight console RSS newsreader
 * 
 * Copyright 2003 Oliver Feiler <kiza@kcore.de>
 * http://kiza.kcore.de/software/snownews/
 *
 * filters.c
 *
 * Please read the file README.patching before changing any code in this file!
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <errno.h>

#include "config.h"

#include "ui-support.h"

/* Load output of local script. Must be valid RSS. */
int FilterExecURL (struct feed * cur_ptr) {
	int len = 1;
	char *command;
	char *freeme;
	char buf[4096];
	FILE *scriptoutput;
	
	command = strdup (cur_ptr->feedurl);
	freeme = command;
	
	strsep (&command, ":");
	
	snprintf (buf, sizeof(buf), _("Loading \"%s\""), command);
	UIStatus (buf, 0);
	
	/* Make room for new stuff. Ah, how I enjoy freeing null pointers! */
	free (cur_ptr->feed);
	
	cur_ptr->feed = malloc (1);
	cur_ptr->feed[0] = '\0';
	
	scriptoutput = popen (command, "r");
	
	while (!feof(scriptoutput)) {
		if ((fgets (buf, sizeof(buf), scriptoutput)) == NULL)
			break;
		
		len += 4096;
		cur_ptr->feed = realloc (cur_ptr->feed, len);
		
		strcat (cur_ptr->feed, buf);
	}

	/* Set title and link structure to something.
	   To the feedurl in this case so the program shows something
	   as placeholder instead of crash. */
	if (cur_ptr->title == NULL)
		cur_ptr->title = strdup (cur_ptr->feedurl);
	if (cur_ptr->link == NULL)
		cur_ptr->link = strdup (cur_ptr->feedurl);
			
	pclose (scriptoutput);
	free (freeme);
	return 0;
}

/* Replaces content in cur_ptr->feed with output of script in
 * cur_ptr->pipethrough.
 * This should probably use pipes, but I couldn't get it to work.
 */
int FilterPipe (struct feed * cur_ptr) {
	int len = 0;
	int retval;
	int fd;
	char tmp[512];
	char command[512];
	char buf[4096];
	char tmpfile[] = "/tmp/.snownews.tmp";
	FILE *file;
		
	snprintf (command, sizeof(command), "%s < %s", cur_ptr->perfeedfilter, tmpfile);
	
	/* Make sure there is no file with the name we're going to write to. */
	unlink (tmpfile);
	
	/* Write contents we're going to process to a temp file.
	   Now use O_EXCL to avoid any tmpfile/symlink attacks. */
	fd = open (tmpfile, O_WRONLY | O_CREAT | O_EXCL, 0600);
	if (fd == -1) {
		snprintf (tmp, sizeof(tmp), _("Could not write temp file for filter: %s"), strerror(errno));
		UIStatus (tmp, 2);
		return 1;
	}
	file = fdopen (fd, "w");
		
	fwrite (cur_ptr->feed, cur_ptr->contentlength, 1, file);
	fclose (file);
	
	free (cur_ptr->feed);
	
	cur_ptr->feed = malloc (1);
	cur_ptr->feed[0] = '\0';
	
	/* Pipe temp file contents to process and popen it. */
	file = popen (command, "r");
	
	while (!feof(file)) {
		/* Strange, valgrind blows up if I use the usual fgets() read here. */
		retval = fread (buf, 1, sizeof(buf), file);
		if (retval == 0)
			break;
		cur_ptr->feed = realloc (cur_ptr->feed, len+retval + 1);
		memcpy (cur_ptr->feed+len, buf, retval);
		len += retval;
		if (retval != 4096)
			break;
	}
	cur_ptr->feed[len] = '\0';
	
	pclose (file);
	
	/* Clean up. */
	unlink (tmpfile);
	
	return 0;
}
