/* Snownews - A lightweight console RSS newsreader
 * 
 * Copyright 2003-2004 Oliver Feiler <kiza@kcore.de>
 * http://kiza.kcore.de/software/snownews/
 *
 * about.c
 *
 * Please read the file README.patching before changing any code in this file!
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
 
#include <ncurses.h>

#include <time.h>
#include <stdlib.h>
#include <string.h>

#include "config.h"

extern struct color color;

/* Snowflake for the xmas about box. */
struct snowflake {
	int x;
	int y;
	int oldx;
	int oldy;
	char oldchar;
	char oldchar2;
	int visible;		/* Don't draw flakes over text. */
	int vspeed;			/* Vertical speed of the flake */
	int hspeed;			/* Horizontal speed */
	struct snowflake * next;
	struct snowflake * prev;
};

/* This draws the colored parts of the christmas tree.
   Called everytime during SnowFall to avoid to much duplicate code.
   Use sparsly as snowflakes will vanish behind this elements. */
void ChristmasTree (void) {
	attron (COLOR_PAIR(13));
	mvaddch (6, 13, '&');
	mvaddch (16, 5, '&');
	attroff (COLOR_PAIR(13));
	attron (COLOR_PAIR(10));
	mvaddch (9, 10, '&');
	mvaddch (19, 12, '&');
	attroff (COLOR_PAIR(10));
	attron (COLOR_PAIR(15));
	mvaddch (12, 14, '&');
	mvaddch (18, 6, '&');
	attroff (COLOR_PAIR(15));
	attron (COLOR_PAIR(14));
	mvaddch (16, 15, '&');
	mvaddch (13, 10, '&');
	attroff (COLOR_PAIR(14));
}

/* This function sometimes deletes characters. Maybe oldchar doesn't
   get saved correctly everytime... But who cares!? :P */
void Snowfall (int christmastree) {
	struct snowflake *cur;
	struct snowflake *first = NULL;
	struct snowflake *new;
	struct snowflake *curnext;
	/* The idea behind wind:
	   Determine windtimer and wait that many rounds before we initially
	   select any windspeed. If we've waited enough rounds (windtimer==0)
	   select a windspeed and windtimer (which should be much less than
	   between the storms). Use (slightly randomly offset) windspeed to
	   blow snowflakes around (to left or right). If windtimer drops to 0
	   again select new windtimer, wait, repeat. */
	int windspeed = 0;
	int windtimer = 0;
	int wind = 1;			/* 1: wind active, 0: inactive 
							   set to 1 here so the first loop run clears it. */
	int newflake = 0;		/* Time until a new flake appears. */
	
	/* Set ncurses halfdelay mode. */
		halfdelay (3);
	
	/* White snowflakes! */
	/* Doesn't work on white terminal background... obviously.
	attron (COLOR_PAIR(16));
	attron (WA_BOLD); */
	
	while (1) {
		/* Set up the storm. */
		if (windtimer == 0) {
			if (wind) {
				/* Entering silence */
				windtimer = 10 + ((float)rand() / (float)RAND_MAX * 50);
				wind = 0;
				windspeed = 0;
			} else {
				/* Entering storm. */
				windtimer = 10 + ((float)rand() / (float)RAND_MAX * 20);
				wind = 1;
				windspeed = (1+(float)rand() / (float)RAND_MAX * 11)-6;
			}
		}
		//mvaddstr(2,1,     "                              ");
		//if (wind)
		//	mvprintw (2,1,"Windspeed: %d; rounds left: %d",windspeed,windtimer);
		//else
		//	mvprintw (2,1,"No wind; rounds left: %d",windtimer);

		/* Add new snowflakes. */
		if (newflake == 0) {
			/* Add new flake to pointer chain with random x offset. */
			new = malloc (sizeof (struct snowflake));
			new->y = 0;
			new->x = (float)rand() / (float)RAND_MAX * COLS;
			new->oldx = new->x;
			new->oldy = new->y;
			new->visible = 1;
			new->oldchar = new->oldchar2 = ' ';
			new->vspeed = 1+(float)rand() / (float)RAND_MAX * 2;
			new->hspeed = (1+(float)rand() / (float)RAND_MAX * 7)-4;
			
			/* Add our new snowflake to the pointer chain. */
			new->next = NULL;
			if (first == NULL) {
				new->prev = NULL;
				first = new;
			} else {
				new->prev = first;
				while (new->prev->next != NULL)
					new->prev = new->prev->next;
				new->prev->next = new;
			}
			
			/* Set new counter until next snowflake. */
			newflake = 1+(float)rand() / (float)RAND_MAX * 2;
			//mvaddstr (1,1,"      ");
			//mvprintw (1,1,"New flake in %d rounds.", newflake);
		}
		
		for (cur = first; cur != NULL; cur = curnext) {
			curnext = cur->next;
			/* Draw every snowflake at its coordinates to the screen. */
			if (cur->visible) {
				/* Only draw if y<=LINES. This makes some snow lie on bottom of screen. */
				if (cur->y <= LINES) {
					/* Restore old char with proper color.
					   See also ChristmasTree() above. */
					if (((cur->oldx < 25) && (cur->oldy > 5)) ||
						(cur->oldx < 20))
						attron (COLOR_PAIR(11));
					if ((cur->oldx < 14) && (cur->oldx > 9) && (cur->oldy < 24) && (cur->oldy > 20)) {
						attroff (COLOR_PAIR(11));
						attron (COLOR_PAIR(12));
					}
					mvaddch (cur->oldy, cur->oldx, cur->oldchar2);
					if (((cur->oldx < 25) && (cur->oldy > 5)) ||
						(cur->oldx < 20))
						attroff (COLOR_PAIR(11));
					if ((cur->oldx < 14) && (cur->oldx > 9) && (cur->oldy < 24) && (cur->oldy > 20)) {
						attroff (COLOR_PAIR(12));
					}
					
					if (christmastree)
						ChristmasTree();
				}
				mvaddch (cur->y, cur->x, '*');
				cur->oldx = cur->x;
				cur->oldy = cur->y;
			}
			/* Set new hspeed for flake */
			cur->hspeed = (1+(float)rand() / (float)RAND_MAX * 7)-4;
			
			/* Advance every flake downwards by a random amount and to
			   the left or right.
			   Check if the next position would obscure a character on the screen
			   and set visible to 0 in this case. Clear visible flag as needed. */
			cur->y += cur->vspeed;
			if (wind)
				cur->hspeed += windspeed;
			cur->x += cur->hspeed;
			
			if (cur->y > LINES) {
				if (cur == first) {
					first = first->next;
					first->prev = NULL;
				} else if (cur->next == NULL) {
					cur->prev->next = NULL;
				} else {
					cur->prev->next = cur->next;
					cur->next->prev = cur->prev;
				}
				free (cur);
				continue;
			}
			
			/* Only draw if we're still inside the window. */
			if (cur->y <= LINES) {
				//mvaddstr (3,1,"                ");
				//mvprintw (3,1,"Flake hspeed: %d",cur->hspeed);
				cur->oldchar2 = cur->oldchar;
				/* Reset to ' ' if we accidently set it to *. */
				if (cur->oldchar2 == '*')
					cur->oldchar2 = ' ';
				if ((cur->x <= COLS) && (cur->y <= LINES))
					cur->oldchar = mvinch (cur->y, cur->x);
				else
					cur->oldchar = ' ';
			}
		}
	
		windtimer--;
		newflake--;
		
		refresh();
		
		/* Leave loop if anykey(tm) was pressed. */
		if (getch() != ERR)
			break;
	}
	/* Leave halfdelay mode. */
	cbreak();
}

void UIAbout (void) {
	struct tm *t;
	time_t tunix;
	int xpos;
	
	clear();				/* Get the crap off the screen to make room
							   for our wonderful ASCII logo. :) */

	xpos = COLS/2 - 40;
	
	if (COLS < 80) {
		mvprintw (0, 0, _("Need at least 80 COLS terminal, sorry!"));
		refresh();
		getch();
		return;
	}
	
	/* Save unix time and pass pointer to localtime for conversion into struct tm.*/
	tunix = time(0);
	t = localtime(&tunix);
	
	/* Use Merry Christmas about screen on Dec 24th-26th. :) */
	
	/* Careful with tm_mon==(0-11) vs. tm_mday==(1-31)  STUPID! */
	if ((t->tm_mon == 11) && (t->tm_mday >= 24) && (t->tm_mday <= 26)) {
		/* Logo */
		mvaddstr (1,  0, "                      _____ _____    ____ _______ _____   ____ _______   _____");
		mvaddstr (2,  0, "                     /  __/ \\    \\  / __ \\\\ |  | \\\\    \\ /  _/ \\ |  | \\ /  __/");
		mvaddstr (3,  0, "                     \\___ \\  \\ |  \\ \\ \\/ / \\     / \\ |  \\\\ __\\  \\     / \\___ \\");
		mvaddstr (4,  0, "                     /____/  /_|__/  \\__/  /__|_/  /_|__/ \\___\\ /__|_/  /____/");
		/* Christmas tree. */
		attron (COLOR_PAIR(11));
		mvaddstr (1,  0, "");
		mvaddstr (2,  0, "");
		mvaddstr (3,  0, "          _\\/_");
		mvaddstr (4,  0, "           /\\");
		mvaddstr (5,  0, "          /  \\");
		mvaddstr (6,  0, "         /   &\\");
		mvaddstr (7,  0, "        /      \\");
		mvaddstr (8,  0, "       /        \\");
		mvaddstr (9,  0, "      /   &      \\");
		mvaddstr (10, 0, "     /            \\");
		mvaddstr (11, 0, "    /              \\");
		mvaddstr (12, 0, "   /   /      &     \\");
		mvaddstr (13, 0, "  /___/   &      \\___\\");
		mvaddstr (14, 0, "     /            \\");
		mvaddstr (15, 0, "    /              \\");
		mvaddstr (16, 0, "   / &         &    \\");
		mvaddstr (17, 0, "  /                  \\");
		mvaddstr (18, 0, " /    &               \\");
		mvaddstr (19, 0, "/____/      &      \\___\\");
		mvaddstr (20, 0, "    /         \\     \\");
		mvaddstr (21, 0, "   /______####_\\_____\\");
		mvaddstr (22, 0, "         |####|");
		mvaddstr (23, 0, "         |####|");
		attroff (COLOR_PAIR(11));
		attron (COLOR_PAIR(12));
		mvaddstr (21, 10, "####");
		mvaddstr (22, 10, "####");
		mvaddstr (23, 10, "####");
		attroff (COLOR_PAIR(12));
		ChristmasTree();
		/* Credits. */
		mvprintw (5, 21, "Version %s", VERSION);
		mvprintw (8, 29, _("Merry Christmas from the Snownews developers."));
		mvaddstr (10, 29, _("Main code"));
		mvaddstr (11, 29, "Oliver Feiler");
		mvaddstr (13, 29, _("Additional code"));
		mvaddstr (14, 29, "Rene Puls");
		mvaddstr (16, 29, _("Translation team"));
		mvaddstr (17, 29, "Oliver Feiler, Frank van der Loo,");
		mvaddstr (18, 29, "Pascal Varet, Simon Isakovic");
		mvaddstr (19, 29, "Fernando J. Pereda, Marco Cova");
		mvaddstr (20, 29, "Cheng-Lung Sung, Dmitry Petukhov");
		
		Snowfall(1);
	} else {
		/* 80 COLS logo */
		mvaddstr (2,   xpos, "  ________ _______     ____ __________ _______     ______ __________   ________");
		mvaddstr (3, xpos, " /  _____/ \\      \\   /    \\\\  |    | \\\\      \\   /  ___/ \\  |    | \\ / ______/");
		mvaddstr (4, xpos, " \\____  \\   \\   |  \\ /  /\\  \\\\   |    / \\   |  \\ /     /   \\   |    / \\____  \\");
		mvaddstr (5, xpos, " /       \\  /   |   \\\\  \\/  / \\  |   /  /   |   \\\\  ___\\    \\  |   /  /       \\");
		mvaddstr (6, xpos, "/______  / / ___|___/ \\____/  /__|__/  / ___|___/ \\____ \\   /__|__/  /______  /");
		mvaddstr (7, xpos, "       \\/  \\/                          \\/              \\/                   \\/");
		mvprintw (9, COLS/2-(strlen("Version")+strlen(VERSION)+1)/2, "Version %s", VERSION);
	
		mvaddstr (12, COLS/2-(strlen(_("Brought to you by:")))/2, _("Brought to you by:"));
		mvaddstr (14, COLS/2-(strlen(_("Main code")))/2, _("Main code"));
		mvaddstr (15, COLS/2-6, "Oliver Feiler");
		mvaddstr (17, COLS/2-(strlen(_("Additional code")))/2, _("Additional code"));
		mvaddstr (18, COLS/2-4, "Rene Puls");
		mvaddstr (20, COLS/2-(strlen(_("Translation team")))/2, _("Translation team"));
		mvaddstr (21, COLS/2-31, "Oliver Feiler, Frank van der Loo, Pascal Varet, Simon Isakovic,");
		mvaddstr (22, COLS/2-32, "Fernando J. Pereda, Marco Cova, Cheng-Lung Sung, Dmitry Petukhov");

		refresh();
		getch();
	}
}

