/*
 * log.c
 *
 * Generic log module.
 *
 * Usage: loginit(ProcessName, NameOfLogFile, LogLevel, appendMode);
 *        logging(level, msg, ...);
 *
 */

/* --- include section --- */
#include "log.h"

#include <stdarg.h>
#include <stdlib.h>
#include <time.h>
#include <stdio.h>
#include <errno.h>
#include <string.h>
#include <unistd.h>

/* --- private variables --- */
static char    *fp_pname;
static char    *fp_fname;
static int      fp_level;
static int      fp_appmode;
static FILE    *fp_log = NULL;

/* --- public functions --- */

void
loginit (char *pname, char *fname, int loglevel, int appendMode)
{
  fp_pname = pname;
  fp_fname = fname;
  fp_level = loglevel;
  fp_appmode = appendMode;
}

void
logging (int level, char *fmt, ...)
{
  va_list         ap;
  char            tbuf[24];
  time_t          curtime;


  /* level of current message too high ? */
  if (level > fp_level)
  {
    return;
  }

  /* open the log file, if necessary */
  if (!fp_log)
  {
    fp_log = fopen (fp_fname, (fp_appmode ? "a" : "w"));

    if (fp_log == NULL)
    {
      fprintf (stderr,
               "Cannot open log file '%s' [%s]\n", fp_fname,
               strerror (errno));
      exit (1);
    }
  }

  /* construct the log entry */
  time (&curtime);
  strftime (tbuf, sizeof (tbuf), "%Y%m%d.%H%M%S", localtime (&curtime));
  fprintf (fp_log, "%s (%s-%d): ", tbuf, fp_pname, getpid ());

  va_start (ap, fmt);
  vfprintf (fp_log, fmt, ap);
  va_end (ap);

  fprintf (fp_log, "\n");
  fflush (fp_log);
}
