/*
 * really simple sound configuration hack
 *
 * Copyright 1997-2000 Red Hat, Inc.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * Additions:
 *  1998-09-22 - i18n - Arnaldo Carvalho de Melo <acme@conectiva.com.br>
 */

/* 	$Id: sndconfig.c,v 1.164 2003/01/01 02:59:55 notting Exp $	 */

#ifndef lint
static char vcid[] =
    "$Id: sndconfig.c,v 1.164 2003/01/01 02:59:55 notting Exp $";
#endif				/* lint */

#include <ftw.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <malloc.h>
#include <string.h>
#include <strings.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/utsname.h>
#include <sys/wait.h>
#include <newt.h>
#include <ctype.h>
#include <libintl.h>
#include <locale.h>

#define _(String) gettext((String))
#define N_(String) (String)

#define _ISAPNP_ 1

#include <kudzu/kudzu.h>
#include <kudzu/isapnp.h>

#include "sndconfig.h"
#include "messages.h"

/* This one should be defined in the Makefile ... */
#ifndef VERSION
#define VERSION "$Revision: 1.164 $"
#endif

/* Typing all this out is a pain... */
#define STANDARD_IRQ    {5,7,9,10,11,-1}
#define LOW_DMA         {0,1,3,-1}
#define SB16_IO         {0x220,0x240,0x260,0x280,-1}
#define WSS_IO          {0x530,0x534,0x604,0xE80,0xF40,-1}
#define MPU401_IO       {0x330,0x300,-1}

static struct settings cards[] = {
    {ACERNB, {5, 7, 9, 10, -1}, SB16_IO, LOW_DMA,
     {-1}, MPU401_IO, {-1}, {-1},
     HAS_OPL3 | ACER, "sb", N_("ACER Notebook sound"), 0, isa, 0},
    {AD1816, {5, 7, 9, 10, -1}, WSS_IO, LOW_DMA,
     LOW_DMA, {-1}, {-1}, {-1},
     HAS_OPL3, "ad1816", N_("AD1816 (Acer FX-3D, HP Kayak)"), 0, isa, 0},
    {ADLIB, {-1}, {-1}, {-1}, {-1}, {-1}, {-1}, {-1},
     NO_INPUT_REQ, "adlib_card", N_("AdLib"), 0, isa, 0},
#ifdef kernel_got_fixed
    {ALIM15XX, {-1}, {-1}, {-1}, {-1}, {-1}, {-1}, {-1},
     NEEDS_SOX | JOYSTICK | NO_INPUT_REQ, "ali_m1553",
     N_("ALI M15xx Chipset Audio"), 0, pci, 0},
#endif	
    {ALS007, STANDARD_IRQ, SB16_IO, LOW_DMA,
     {0, 1, 3, 5, 6, 7, -1}, MPU401_IO, STANDARD_IRQ, {-1},
     HAS_OPL3, "sb", N_("Advance Logic ALS-007"), 0, isa, 0},
    {ALS100, STANDARD_IRQ, SB16_IO, LOW_DMA,
     LOW_DMA, MPU401_IO, STANDARD_IRQ, {-1},
     HAS_OPL3, "sb", N_("Advance Logic ALS-100/110"), 0, isa, 0},
    {SGALAXY, STANDARD_IRQ, WSS_IO, LOW_DMA,
     LOW_DMA, MPU401_IO, STANDARD_IRQ, SB16_IO,
     HAS_OPL3, "sgalaxy",
     N_("Aztech Sound Galaxy Waverider Pro 32-3D, Washington 16"), 0, isa,
     0},
    {CMI8330, {5, 7, 9, 10, 11, -1}, WSS_IO, LOW_DMA,
     {-1}, MPU401_IO, STANDARD_IRQ, {-1},
     HAS_MPU401 | HAS_OPL3 | SOUNDPRO, "ad1848",
     N_("CMI8330 sound chip (many motherboards)"), 0, isa, 0},
    {CMI8X38, {-1}, {-1}, {-1}, {-1}, {-1}, {-1}, {-1},
     NO_INPUT_REQ | NEEDS_SOX, "cmpci", N_("C-Media PCI Audio (8338, 8738)"), 0, pci,
     0},
    {DESKPROXL, {7, 9, 10, 11, -1}, WSS_IO, LOW_DMA,
     LOW_DMA, {-1}, {-1}, {-1},
     HAS_OPL3 | COMPAQ, "ad1848", N_("Compaq Deskpro XL Sound"), 0, isa,
     0},
    {CS4232, STANDARD_IRQ, WSS_IO, LOW_DMA,
     LOW_DMA, MPU401_IO, STANDARD_IRQ, {-1},
     HAS_OPL3, "cs4232", N_("Crystal CS423x sound chip"), 0, isa, 0},
    {CS46XX, {-1}, {-1}, {-1}, {-1}, {-1}, {-1}, {-1},
     NEEDS_SOX | JOYSTICK | NO_INPUT_REQ, "cs46xx",
     N_("Crystal SoundFusion CS46xx"), 0, pci, 0},
    {CS4281, {-1}, {-1}, {-1}, {-1}, {-1}, {-1}, {-1},
     NEEDS_SOX | NO_INPUT_REQ, "cs4281",
     N_("Crystal CS4281"), 0, pci, 0},
    {ES1370, {-1}, {-1}, {-1}, {-1}, {-1}, {-1}, {-1},
     NEEDS_SOX | JOYSTICK | NO_INPUT_REQ, "es1370",
     N_("Ensoniq AudioPCI 1370 (SoundBlaster 64/128 PCI)"), 0, pci, 0},
    {ES1371, {-1}, {-1}, {-1}, {-1}, {-1}, {-1}, {-1},
     NEEDS_SOX | JOYSTICK | NO_INPUT_REQ, "es1371",
     N_("Creative/Ensoniq AudioPCI 1371"), 0, pci, 0},
    {SOUNDSCAPE, {5, 7, 9, 10, 15, -1}, WSS_IO, LOW_DMA,
     {-1}, MPU401_IO, STANDARD_IRQ, {-1},
     0, "sscape", N_("Ensoniq SoundScape"), 0, isa, 0},
    {SSVIVO, STANDARD_IRQ, WSS_IO, LOW_DMA,
     LOW_DMA, MPU401_IO, STANDARD_IRQ, {-1},
     HAS_MPU401, "ad1848", N_("Ensoniq SoundScape VIVO"), 0, isa, 0},
    {ESS688, {5, 7, 9, 10, -1}, SB16_IO, LOW_DMA,
     {-1}, {-1}, {-1}, {-1},
     HAS_OPL3, "sb", N_("ESS688 AudioDrive"), 0, isa, 0},
    {ESS1688, {5, 7, 9, 10, -1}, {0x220, 0x230, 0x240, 0x250, -1}, LOW_DMA,
     {-1}, MPU401_IO, {-1}, {-1},
     HAS_OPL3, "sb", N_("ESS1688 AudioDrive"), 0, isa, 0},
    {ESS1868, {5, 7, 9, 10, -1}, {0x220, 0x230, 0x240, 0x250, -1}, LOW_DMA,
     {-1}, MPU401_IO, {-1}, {-1},
     HAS_OPL3, "sb", N_("ESS1868 AudioDrive"), 0, isa, 0},
    {ESSMAESTRO, {-1}, {-1}, {-1}, {-1}, {-1}, {-1}, {-1},
     NEEDS_SOX | NO_INPUT_REQ, "maestro", N_("ESS Maestro 1/2/2E"), 0, pci, 0},
    {ESSMAESTRO3, {-1}, {-1}, {-1}, {-1}, {-1}, {-1}, {-1},
     NEEDS_SOX | NO_INPUT_REQ, "maestro3", N_("ESS Maestro 3/Allegro"), 0, pci, 0},
    {ESSSOLO1, {-1}, {-1}, {-1}, {-1}, {-1}, {-1}, {-1},
     NEEDS_SOX | NO_INPUT_REQ, "esssolo1", N_("ESS Solo 1"), 0, pci, 0},
    {GUS, {3, 5, 7, 9, 11, 12, 15, -1},
     {0x210, 0x220, 0x230, 0x240, 0x250, 0x260, -1}, {1, 3, 5, 6, 7, -1},
     {-1}, {-1}, {-1}, {-1},
     0, "gus", N_("Gravis UltraSound"), 0, isa, 0},
    {GUSMAX, {3, 5, 7, 9, 11, 12, 15, -1},
     {0x210, 0x220, 0x230, 0x240, 0x250, 0x260, -1}, {1, 3, 5, 6, 7, -1},
     {1, 3, 5, 6, 7, -1}, {-1}, {-1}, {-1},
     0, "gus", N_("Gravis UltraSound MAX"), 0, isa, 0},
    {GUSPNP, {3, 5, 7, 9, 11, 12, 15, -1},
     {0x210, 0x220, 0x230, 0x240, 0x250, 0x260, -1}, {1, 3, 5, 6, 7, -1},
      {1, 3, 5, 6, 7, -1}, {-1}, {-1}, {-1},
      0, "gus", N_("Gravis UltraSound PnP"), 0, isa, 0},
    {I810, {-1}, {-1}, {-1}, {-1}, {-1}, {-1}, {-1},
     NEEDS_SOX | NO_INPUT_REQ, "i810_audio", N_("Intel i810 AC97 Audio"), 0, pci, 0},
    {SMGAMES, STANDARD_IRQ, SB16_IO, LOW_DMA,
     {-1}, {-1}, {-1}, {-1},
     HAS_OPL3 | SM_GAMES, "sb",
     N_("Logitech SoundMan Games (not SM16 or SM Wave!)"), 0, isa, 0},
    {AUDIOTRIX, {5, 7, 9, 10, 11, 12, 15, -1}, WSS_IO, LOW_DMA,
     LOW_DMA, MPU401_IO, {5, 7, 9, 10, 11, 12, 15, -1}, {-1},
     HAS_OPL3 | SB_AS_LIB, "trix", N_("MediaTrix AudioTrix Pro"), 0, isa,
     0},
    {JAZZ16, STANDARD_IRQ, {0x220, 0x240, 0x260, -1}, LOW_DMA,
     {0, 1, 3, 5, 6, 7, -1}, {0x310, 0x320, 0x330, -1}, {-1}, {-1},
     HAS_OPL3, "sb", N_("MediaVision Jazz16 (ProSonic, SoundMan Wave)"), 0,
     isa, 0},
    {MOZART, STANDARD_IRQ, WSS_IO, LOW_DMA,
     LOW_DMA, {-1}, {-1}, {-1},
     HAS_OPL3 | SB_AS_LIB | JOYSTICK, "mad16",
     N_("Mozart/MAD16 (OPTi 82C928)"), 0, isa, 0},
    {MAD16PRO, STANDARD_IRQ, WSS_IO, LOW_DMA,
     {0, 1, 3, 5, 6}, {0x300, 0x310, 0x320, 0x330, -1}, STANDARD_IRQ, {-1},
     HAS_OPL3 | SB_AS_LIB | JOYSTICK, "mad16",
     N_("MAD16 Pro (OPTi 82C929/82C930)"), 0, isa, 0},
    {MIROSOUND, STANDARD_IRQ, WSS_IO, LOW_DMA,
     LOW_DMA, MPU401_IO, STANDARD_IRQ, {-1},
     ACI, "mad16", N_("miroSOUND PCM12"), 0, isa, 0},
    {NEOMAGIC, {-1}, {-1}, {-1}, {-1}, {-1}, {-1}, {-1},
     NO_INPUT_REQ | NEEDS_SOX, "nm256_audio", N_("NeoMagic MagicMedia 256AV"), 0, pci, 0},
    {OPL3_SA, {5, 7, 9, 10, 11, 12, 15, -1}, WSS_IO, LOW_DMA,
     LOW_DMA, MPU401_IO, STANDARD_IRQ, {-1},
     HAS_OPL3, "opl3sa", N_("OPL3-SA1 sound chip"), 0, isa, 0},
    {OPL3_SAX, {5, 7, 9, 10, 11, 12, 15, -1}, WSS_IO, LOW_DMA,
     LOW_DMA, MPU401_IO, {-1}, {0x370, 0x380, -1},
     HAS_OPL3, "opl3sa2", N_("OPL3-SA2/3/x sound chip"), 0, isa, 0},
    {PAS16, {3, 5, 7, 9, 10, 11, 12, -1}, {0x220, 0x230, 0x240, 0x388, -1},
     {0, 1, 2, 3, 5, 6, 7, -1},
	 {-1}, {-1}, {-1}, {-1},
	 SB_AS_LIB | JOYSTICK, "pas2",
	 N_("Pro Audio Spectrum/Studio 16, Logitech SoundMan 16"), 0, isa,
	 0},
    {PSS, {3, 5, 7, 9, 10, 11, 12}, {0x220, 0x230, 0x240, 0x250, -1},
     LOW_DMA,
     {-1}, MPU401_IO, STANDARD_IRQ, {-1},
     0, "pss", N_("PSS (Orchid SW32, Cardinal DSP16)"), 0, isa, 0},
    {SONICVIBES, {-1}, {-1}, {-1}, {-1}, {-1}, {-1}, {-1},
     NEEDS_SOX | JOYSTICK | NO_INPUT_REQ, "sonicvibes",
     N_("S3 SonicVibes"), 0, pci, 0},
    {SBORIG, {3, 5, 7, 9, -1}, {0x220, 0x240, -1}, {1, -1},
     {-1}, {-1}, {-1}, {-1},
     HAS_OPL3, "sb", N_("Sound Blaster"), 0, isa, 0},
    {SBPRO, STANDARD_IRQ, {0x220, 0x240, -1}, LOW_DMA,
     {-1}, {-1}, {-1}, {-1},
     HAS_OPL3, "sb", N_("Sound Blaster Pro"), 0, isa, 0},
    {SB16, STANDARD_IRQ, SB16_IO, LOW_DMA,
     {0, 1, 3, 5, 6, 7, -1}, MPU401_IO, {-1}, {-1},
     HAS_OPL3, "sb", N_("Sound Blaster 16"), 0, isa, 0},
    {SB32, STANDARD_IRQ, SB16_IO, LOW_DMA,
     {0, 1, 3, 5, 6, 7, -1}, MPU401_IO, {-1}, {-1},
     HAS_OPL3 | HAS_AWE, "sb", N_("Sound Blaster AWE32/64"), 0, isa, 0},
    {SBLIVE, {-1}, {-1}, {-1}, {-1}, {-1}, {-1}, {-1},
     NEEDS_SOX | NO_INPUT_REQ, "emu10k1", N_("Sound Blaster Live!"), 0, pci, 0},
    {TRIDENT, {-1}, {-1}, {-1}, {-1}, {-1}, {-1}, {-1},
     NO_INPUT_REQ | NEEDS_SOX, "trident", N_("Trident 4D-Wave NX/DX"), 0, pci, 0},
     {MSND_CLASSIC, {5, 7, 9, 10, 11, 12, -1},
     {0x210, 0x220, 0x230, 0x240, 0x250, 0x260, 0x290, 0x3e0, -1}, {-1},
	 {-1}, {-1}, {-1}, {0xb0000, 0xc8000, 0xd0000, 0xd8000, 0xe0000,
			    0xe8000, -1},
	 0, "msnd_classic",
	 N_("Turtle Beach MultiSound Classic/Monterey/Tahiti"), 1, isa, 0},
    {MSND_PINNACLE, {5, 7, 9, 10, 11, 12, -1},
     {0x210, 0x220, 0x230, 0x240, 0x290, 0x3e0, -1}, {-1},
     {0x250, 0x260, 0x270, -1}, MPU401_IO, STANDARD_IRQ, {0xb0000, 0xc8000,
							  0xd0000, 0xd8000,
							  0xe0000, 0xe8000,
							  -1},
     HAS_MPU401, "msnd_pinnacle",
     N_("Turtle Beach MultiSound Pinnacle/Fiji"), 2, isa, 0},
/* WaveFront doesn't work (in sndconfig) */
#if 0
    {WAVEFRONT, STANDARD_IRQ, WSS_IO, LOW_DMA,
     LOW_DMA, {0x200, 0x210, -1}, STANDARD_IRQ, {-1},
     LOAD_CS4232, "wavefront", N_("Turtle Beach Maui/Tropez/Tropez+"), 3,
     isa, 0},
#endif
    {VIA82CXXX, {-1}, {-1}, {-1}, {-1}, {-1}, {-1}, {-1},
     NO_INPUT_REQ | NEEDS_SOX, "via82cxxx_audio", N_("VIA 82CXXX PCI Audio"), 0, pci, 0},
    {WSS, STANDARD_IRQ, WSS_IO, LOW_DMA,
     LOW_DMA, {-1}, {-1}, {-1},
     HAS_OPL3, "ad1848", N_("Windows Sound System (AD1848/CS4248/CS4231)"),
     0, isa, 0},
    {YMFPCI, {-1}, {-1}, {-1}, {-1}, {-1}, {-1}, {-1},
     NO_INPUT_REQ | NEEDS_SOX|SB_AS_LIB, "ymfpci", N_("Yamaha YMF PCI Audio"),
     0, pci, 0},
    {AMD7930, {-1}, {-1}, {-1},
     {-1}, {-1}, {-1}, {-1},
     NO_INPUT_REQ, "amd7930", N_("AMD7930 (sun4c)"), 0, sbus, 0},
    {CS4231, {-1}, {-1}, {-1},
     {-1}, {-1}, {-1}, {-1},
     NO_INPUT_REQ, "cs4231", N_("CS4231 (some sun4m, sun4u)"), 0, sbus, 0},
    {DBRI, {-1}, {-1}, {-1},
     {-1}, {-1}, {-1}, {-1},
     NO_INPUT_REQ, "dbri", N_("DBRI (SPARCstation 10, 20, LX, Voyager)"),
     0, sbus, 0},
    {UNSPEC, {-1}, {-1}, {-1},
     {-1}, {-1}, {-1}, {-1},
     0, "", "", 0, isa | sbus | pci, 0}
};


/* -1 means no file found, 0 means we're ok */
int RunCmd(char *cmd, char **args, char **out, char **err) {

    int infd, outfd, errfd, resultfd, resulterrfd;
    int i, pid, status;
    int resultSize;
    int outpipe[2],errpipe[2];
    char *result;
    char *resultbuf[200];
    
    infd = open("/dev/null", O_RDONLY);
    /* errfd = open("/dev/null", O_WRONLY); */
    if (out) {
	pipe(outpipe);
	outfd = outpipe[1];
	resultfd = outpipe[0];
    } else {
	outfd = -1;
	resultfd = -1;
    }
    if (err) {
	pipe(errpipe);
	errfd = errpipe[1];
	resulterrfd = errpipe[0];
    } else {
	errfd = -1;
	resulterrfd = -1;
    }

    if (!(pid = fork())) {
	close(0);
	close(1);
	close(2);
	
        dup2(infd, 0);
	
	if (out)
	    dup2(outfd, 1);
	
	if (err)
	  dup2(errfd, 2);

        close(infd);
	if (out)
	    close(outfd);
	
	if (err)
	  close(errfd);
        close(resultfd);
	close(resulterrfd);

        execv(cmd, args);
	printf(_("Something is wrong\n"));
        exit(-1);
    }
     
    close(infd);
    if (out)
      close(outfd);

    if (err)
      close(errfd);

    if (out) {
        resultSize = 0;
        result = NULL;

        do {
            i = read(resultfd, resultbuf, sizeof(resultbuf));

            if (!result) {
                result = malloc(i + 1);
            } else
                result = realloc(result, resultSize + i + 1);
            memcpy(result + resultSize, resultbuf, i);
            resultSize += i;
            result[resultSize] = '\0';
        } while (i > 0);
	
	/* Embedded '\0's are a pain in the ass */
	for (i = 0;i<resultSize-1;i++) {
	    if (!result[i])
	      result[i] = ' ';
	}

        close(resultfd);
        *out = result;
    }
    if (err) {
	resultSize = 0;
	result = NULL;
	
	do {
	    i = read(resulterrfd, resultbuf, sizeof(resultbuf));
	    
	    if (!result) {
		result = malloc(i + 1);
	    } else
	      result = realloc(result, resultSize + i + 1);
	    memcpy(result + resultSize, resultbuf, i);
	    resultSize += i;
	    result[resultSize] = '\0';
	} while (i > 0);
	
	close(resulterrfd);
	*err = result;
    }

    waitpid(pid, &status, 0);

    if (WIFEXITED(status))
        return WEXITSTATUS(status);

    return -1; 
}

static void cleanupmods(struct settings *set)
{
    char *rmargs[] = { "/sbin/rmmod", NULL, NULL, NULL, NULL };
    int rc;

    if (set->flags & HAS_OPL3) {
	rmargs[1] = "opl3";
	rc = RunCmd("/sbin/rmmod", rmargs, NULL, NULL);
    }
    if (set->flags & HAS_MPU401) {
	rmargs[1] = "mpu401";
	rc = RunCmd("/sbin/rmmod", rmargs, NULL, NULL);
    }
    if (set->flags & HAS_AWE) {
	rmargs[1] = "awe_wave";
	rc = RunCmd("/sbin/rmmod", rmargs, NULL, NULL);
    }
    if (set->flags & ACI) {
	rmargs[1] = "aci";
	rc = RunCmd("/sbin/rmmod", rmargs, NULL, NULL);
    }
    rmargs[1] = set->modulename;
    rc = RunCmd("/sbin/rmmod", rmargs, NULL, NULL);
    if (set->flags & LOAD_CS4232) {
	rmargs[1] = "cs4232";
	rc = RunCmd("/sbin/rmmod", rmargs, NULL, NULL);
    }
    if (set->modulename == "cs4232") {
	rmargs[1] = "ad1848";
	rc = RunCmd("/sbin/rmmod", rmargs, NULL, NULL);
    }
    if (set->flags & SB_AS_LIB) {
	rmargs[1] = "sb";
	rc = RunCmd("/sbin/rmmod", rmargs, NULL, NULL);
    }
    rmargs[1] = "uart401";
    rc = RunCmd("/sbin/rmmod", rmargs, NULL, NULL);
    rmargs[1] = "sound";
    rc = RunCmd("/sbin/rmmod", rmargs, NULL, NULL);
    rmargs[1] = "soundcore";
    rc = RunCmd("/sbin/rmmod", rmargs, NULL, NULL);
    rmargs[1] = "soundlow";
    rc = RunCmd("/sbin/rmmod", rmargs, NULL, NULL);
}

static void startsound(struct settings *set)
{
    /* char *args[]={"/etc/rc.d/init.d/sound", "restart", NULL, NULL, NULL}; */
    char *args2[] = { "/sbin/modprobe", NULL, NULL, NULL };

    /* RunCmd("/etc/rc.d/init.d/sound", args, NULL, NULL); */
    args2[1] = "sound-slot-0";
    RunCmd("/sbin/modprobe", args2, NULL, NULL);

    if (set->flags & HAS_OPL3 || set->flags & HAS_MPU401
	|| set->type == SB32) {
	args2[1] = "synth0";
	RunCmd("/sbin/modprobe", args2, NULL, NULL);
    }

}

/* get newt initialized, set help line, etc */
static void NewtStartUp(void)
{
    char roottext[80];

    newtInit();
    newtCls();
    newtPushHelpLine(_("  <Tab>/<Alt-Tab> between elements  |"
		       "  Use <Enter> to edit a selection"));

    snprintf(roottext, 80,
	     _("Sound Configuration Utility %s          "
	       "         (C) 2000 Red Hat, Inc."), VERSION);
    newtDrawRootText(0, 0, roottext);
}

static char *CardTypeToString(enum cards type)
{
    if (type == SBORIG)
	return "SBORIG";
    else if (type == SBPRO)
	return "SBPRO";
    else if (type == SB16)
	return "SB16";
    else if (type == SB32)
	return "SB32";
    else if (type == SBLIVE)
	return "SBLIVE";
    else if (type == AD1816)
	return "AD1816";
    else if (type == ALS007)
	return "ALS007";
    else if (type == ALS100)
	return "ALS100";
    else if (type == SMGAMES)
	return "SMGAMES";
    else if (type == JAZZ16)
	return "JAZZ16";
    else if (type == CMI8330)
	return "CMI8330";
    else if (type == CS4232)
	return "CS4232";
    else if (type == CS46XX)
	return "CS46XX";
    else if (type == CS4281)
	return "CS4281";
#ifdef kernel_got_fixed
    else if (type == ALIM15XX)
	  return "ALIM15XX";
#endif
    else if (type == ESS1868)
	return "ESS1868";
    else if (type == ESS1688)
	return "ESS1688";
    else if (type == ESS688)
	return "ESS688";
    else if (type == MOZART)
	return "MOZART";
    else if (type == MAD16PRO)
	return "MAD16PRO";
    else if (type == MSND_CLASSIC)
	return "MSND_CLASSIC";
    else if (type == MSND_PINNACLE)
	return "MSND_PINNACLE";
    else if (type == OPL3_SA)
	return "OPL3_SA";
    else if (type == OPL3_SAX)
	return "OPL3_SAX";
#if 0
    else if (type == WAVEFRONT)
	return "WAVEFRONT";
#endif
    else if (type == ES1370)
	return "ES1370";
    else if (type == ES1371)
	return "ES1371";
    else if (type == ESSSOLO1)
	return "ESSSOLO1";
    else if (type == SONICVIBES)
	return "SONICVIBES";
    else if (type == GUS)
	return "GUS";
    else if (type == GUSMAX)
	return "GUSMAX";
    else if (type == GUSPNP)
	return "GUSPNP";
    else if (type == PAS16)
	return "PAS16";
    else if (type == WSS)
	return "WSS";
    else if (type == CMI8X38)
	return "CMI8X38";
    else if (type == VIA82CXXX)
	return "VI82CXXX";
    else if (type == SGALAXY)
	return "SGALAXY";
    else if (type == DESKPROXL)
	return "DESKPROXL";
    else if (type == AUDIOTRIX)
	return "AUDIOTRIX";
    else if (type == ADLIB)
	return "ADLIB";
    else if (type == SOUNDSCAPE)
	return "SOUNDSCAPE";
    else if (type == SSVIVO)
	return "SSVIVO";
    else if (type == PSS)
	return "PSS";
    else if (type == MIROSOUND)
	return "MIROSOUND";
    else if (type == I810)
	return "I810";
    else if (type == YMFPCI)
	return "YMFPCI";
    else if (type == TRIDENT)
	return "TRIDENT";
    else if (type == AMD7930)
	return "AMD7930";
    else if (type == CS4231)
	return "CS4231";
    else if (type == DBRI)
	return "DBRI";
    else if (type == UNSPEC)
	return "UNSPEC";
    else
	return "UNSPEC";
}

static int ReadOldCardSettings(struct settings *set)
{
    FILE *f;
    char buf[100], tmpstr[100];
    char *s, *t, *u;
    int x;

    if ((f = fopen(CONFFILE, "r")) == NULL)
	return -1;

    set = memcpy(set, &cards[UNSPEC], sizeof(struct settings));
    while (1) {
	if (!fgets(buf, 100, f))
	    break;

	if (*buf == '#')
	    continue;

	s = strchr(buf, '=');
	if (!s || !*(s + 1))
	    continue;

	*s = 0;
	t = s + 1;
	for (s = t; *s && isspace(*s); s++);
	if (!*s)
	    continue;
	t = s;
	s++;
	for (; *s && !isspace(*s); s++);
	if (!*s)
	    continue;
	*s = 0;

	if (!strcmp(buf, "CARDTYPE")) {
	    for (x = 0; cards[x].type != UNSPEC; x++) {
		if (strstr(t, CardTypeToString(cards[x].type))) {
		    set = memcpy(set, &cards[x], sizeof(struct settings));
		    set->io[0] = -1;
		    set->irq[0] = -1;
		    set->dma[0] = -1;
		    set->dma2[0] = -1;
		    set->mpu_io[0] = -1;
		    set->mpu_irq[0] = -1;
		    set->mem[0] = -1;
		}
	    }
	}
    }

    set->descr[0] = 0;
    fclose(f);

    /* If card is unspecified, don't even bother looking in /etc/modules.conf */
    if (set->type == UNSPEC)
	return 0;

    /* now read io settings from /etc/modules.conf */
    if ((f = fopen("/etc/modules.conf", "r")) == NULL)
	return -1;

    /* scan for line for modulenames */
    while (1) {
	if (!fgets(buf, 100, f))
	    break;

	if (*buf == '#')
	    continue;

	if (!strstr(buf, "options "))
	    continue;

	snprintf(tmpstr, 100, " %s ", set->modulename);
	if (!strstr(buf, tmpstr) && !strstr(buf, tmpstr) &&
	    !strstr(buf, " mpu401 ") && !strstr(buf, " mpu401 "))
	    continue;

	/* find start of options */
	snprintf(tmpstr, 100, "%s ", set->modulename);
	s = strstr(buf, tmpstr);
	if (!s) {
	    snprintf(tmpstr, 100, "mpu401 ");
	    s = strstr(buf, tmpstr);
	    if (!s)
		continue;
	}

	s += strlen(tmpstr);
	while (*s) {
	    u = s;
	    while (*s && *s != '=')
		s++;
	    if (!*s)
		continue;
	    else
		*s++ = '\0';

	    t = s;
	    while (*s && *s != ' ')
		s++;
	    if (!s || !*(s + 1))
		continue;
	    *s++ = 0;

	    if (!strcmp(u, "io")) {
		if (strstr(buf, " mpu401"))
		    set->mpu_io[0] = strtol(t, NULL, 0);
		else if (set->type == OPL3_SAX)
		    set->mem[0] = strtol(t, NULL, 0);
		else
		    set->io[0] = strtol(t, NULL, 0);
	    } else if (!strcmp(u, "irq")) {
		if (strstr(buf, " mpu401"))
		    set->mpu_irq[0] = strtol(t, NULL, 0);
		else
		    set->irq[0] = strtol(t, NULL, 0);
	    } else if (!strcmp(u, "mss_io"))
		set->io[0] = strtol(t, NULL, 0);
	    else if (!strcmp(u, "sgbase"))
		set->mem[0] = strtol(t, NULL, 0);
	    else if (!strcmp(u, "dma16"))
		set->dma2[0] = strtol(t, NULL, 0);
	    else if (!strcmp(u, "dma2"))
		set->dma2[0] = strtol(t, NULL, 0);
	    else if (!strcmp(u, "mpu_io"))
		set->mpu_io[0] = strtol(t, NULL, 0);
	    /* silly CS4232 driver... */
	    else if (!strcmp(u, "mpuio"))
		set->mpu_io[0] = strtol(t, NULL, 0);
	    else if (!strcmp(u, "mpu_base"))
		set->mpu_io[0] = strtol(t, NULL, 0);
	    else if (!strcmp(u, "mpu_irq"))
		set->mpu_irq[0] = strtol(t, NULL, 0);
	    else if (!strcmp(u, "mpuirq"))
		set->mpu_irq[0] = strtol(t, NULL, 0);
	    else if (!strcmp(u, "mem"))
		set->mem[0] = strtol(t, NULL, 0);
	    else if (!strcmp(u, "cfg"))
		set->dma2[0] = strtol(t, NULL, 0);
	    else if (!strcmp(u, "dma")) {
		char *r;
		r = strchr(t, ',');
		if (!r)
		    set->dma[0] = strtol(t, NULL, 0);
		else {
		    *r++ = 0;
		    set->dma[0] = strtol(t, NULL, 0);
		    set->dma2[0] = strtol(r, NULL, 0);
		}
	    }

	}
    }
    fclose(f);

    return 0;
}

static int WriteCardSettings(struct settings *set)
{
    FILE *f;
    char *type;

    if ((f = fopen(CONFFILE, "w")) == NULL)
	return -1;

    type = CardTypeToString(set->type);

    /* file format is pretty static, if you change then */
    /* this program wont read it right.                 */
    fprintf(f, _("# THIS FILE IS WRITTEN BY SNDCONFIG\n"));
    fprintf(f, _("# PLEASE USE SNDCONFIG TO MODIFY\n"));
    fprintf(f, _("# TO CHANGE THIS FILE!\n"));
    fprintf(f, _("# There should be no spaces at the start of a line\n"));
    fprintf(f, _("# or around the '=' sign\n"));
    fprintf(f, "CARDTYPE=%s\n", type);

    fclose(f);
    return 0;
}

static int GetCardType(enum cards *type)
{
    newtComponent tbox, lbox, ok, cancel, answer, form;
    int rc;

    newtCenteredWindow(70, 17, _("Card Type"));
    form = newtForm(NULL, NULL, 0);

    tbox = newtTextbox(5, 1, 30, 2, NEWT_FLAG_WRAP);
    newtTextboxSetText(tbox, _("Please select your card:"));

    lbox = newtListbox(8, 3, 8, NEWT_FLAG_RETURNEXIT | NEWT_FLAG_SCROLL);
    for (rc = 0;; rc++) {
	if (cards[rc].type == UNSPEC)
	    break;
	if (cards[rc].bus &
#ifdef __i386__
	    (isa | pci)
#endif
#ifdef __sparc__
	    sbus
#endif
#ifdef __alpha__
	    (isa | pci)
#endif
#ifdef __ia64__
	    pci
#endif	    
	    && cards[rc].avail)
	    newtListboxAddEntry(lbox, _(cards[rc].descr),
				(void *) cards[rc].type);
    }

    if (*type == UNSPEC)
#ifdef __sparc__
	newtListboxSetCurrent(lbox, AMD7930);
#endif
#ifdef __ia64__	
	newtListboxSetCurrent(lbox, ES1370);
#endif
#if defined(__alpha__) || defined(__i386__)
	newtListboxSetCurrent(lbox, SBORIG);
#endif
    else
	newtListboxSetCurrent(lbox, *type);

    ok = newtButton(6, 12, _("Ok"));
    cancel = newtButton(20, 12, _("Cancel"));

    newtFormAddComponents(form, tbox, lbox, ok, cancel, NULL);

    answer = newtRunForm(form);

    if (answer != cancel) {
	*type = (int) newtListboxGetCurrent(lbox);
	rc = 0;
    } else {
	rc = -1;
    }

    newtPopWindow();
    newtFormDestroy(form);

    return rc;
}

static void mungeList(int list[10], int value)
{
    int x = 0;

    while (list[x] != value && x < 10) {
	x++;
    }
    while (list[x] != -1 && x < 10) {
	list[x] = list[x + 1];
	x++;
    }
}

static char mod_name[100], cmod_name[100]; 

static int isModule(const char *filename, const struct stat *sb, int flag) {
	char *fname = basename(filename);
	/* ugly hack; ignore things under build symlink */
	if ((!strcmp(fname,mod_name) || !strcmp(fname,cmod_name)) && !strstr(filename,"/build/")) {
		return 1;
	}
	return 0;
}

int isAvailable(char *modulename)
{
	struct utsname utsbuf;
	struct stat sbuf;
	char path[512];
	int x;
	char *searchdir[] = {
		"fs",
		"net",
		"scsi",
		"block",
		"cdrom",
		"ipv4",
		"ipv6",
		"sound",
		"fc4",
		"video",
		"misc",
		"pcmcia",
		"atm",
		"usb",
		NULL
	};
	
	uname(&utsbuf);
	snprintf(mod_name,100,"%s.o",modulename);
	snprintf(cmod_name,100,"%s.o.gz",modulename);
	/* First, try the current kernel */
	snprintf(path,512,"/lib/modules/%s",utsbuf.release);
	/* Do not set the third argument of this function to < 6. Blarg. */
	if (ftw(path,isModule,15) == 1) {
		return 1;
	}
	/* If they're running a -BOOT kernel, try the original. */
	if (strstr(utsbuf.release,"BOOT")) {
		char kernelver[64];
		int len;
		
		len = strstr(utsbuf.release,"BOOT")-utsbuf.release;
		strncpy(kernelver,utsbuf.release,len);
		kernelver[len]='\0';
		snprintf(path,512,"/lib/modules/%s",kernelver);
		if (ftw(path,isModule,15) == 1) {
			return 1;
		}
		snprintf(path,512,"/lib/modules/%ssmp",kernelver);
		if (ftw(path,isModule,15) == 1) {
			return 1;
		}
		snprintf(path,512,"/lib/modules/%sbigmem",kernelver);
		if (ftw(path,isModule,15) == 1) {
			return 1;
		}
		snprintf(path,512,"/lib/modules/%ssummit",kernelver);
		if (ftw(path,isModule,15) == 1) {
			return 1;
		}
	}
	/* Finally, try non-version specific directories. */
	for (x = 0; searchdir[x]; x++) {
		snprintf(path,512,"/lib/modules/%s/%s.o",
			 searchdir[x],modulename);
		if (!stat(path,&sbuf))
		  return 1;
	}
	return 0;
}

static int EditSettings(int pnpprobe, struct settings *set,
			struct settings *currset)
{
    newtComponent iobox, irqbox, dmabox, dma2box, mpu_iobox, mpu_irqbox;
    newtComponent membox, ok, cancel, answer, form;
    newtComponent iolab, irqlab, dmalab, dma2lab, mpu_iolab, mpu_irqlab;
    newtComponent memlab, instrbox;
    newtGrid grid, subgrid1, subgrid3;
    int rc;
    int i, dmareq, dma2req, mpu_ioreq, mpu_irqreq, memreq;
    char tmpstr[8];
    char *text;

    int twidth, theight;

    form = newtForm(NULL, NULL, 0);

#ifdef __alpha__
    /* IRQ 7 *bad* */
    mungeList(set->irq, 7);
    mungeList(set->mpu_irq, 7);
#endif

    dmareq = (set->dma[0] != -1);
    dma2req = (set->dma2[0] != -1);
    mpu_ioreq = (set->mpu_io[0] != -1);
    mpu_irqreq = (set->mpu_irq[0] != -1);
    memreq = (set->mem[0] != -1);

    iobox = newtListbox(-1, -1, 4, NEWT_FLAG_RETURNEXIT | NEWT_FLAG_BORDER);
    iolab = newtLabel(-1, -1, _("I/O PORT"));
    for (i = 0; set->io[i] != -1; i++) {
	snprintf(tmpstr, 8, "0x%3x", set->io[i]);
	newtListboxAddEntry(iobox, tmpstr, (void *) set->io[i]);
	if (currset->io[0] < 0) {
	    if (set->io[i] == 0x220)
		newtListboxSetCurrent(iobox, i);
	} else if (currset->io[0] == set->io[i]) {
	    newtListboxSetCurrent(iobox, i);
	}
    }

    irqbox = newtListbox(-1, -1, 4, NEWT_FLAG_RETURNEXIT | NEWT_FLAG_BORDER);
    irqlab = newtLabel(-1, -1, _("IRQ"));
    for (i = 0; set->irq[i] != -1; i++) {
	snprintf(tmpstr, 8, "%2d", set->irq[i]);
	newtListboxAddEntry(irqbox, tmpstr, (void *) set->irq[i]);
	if (currset->irq[0] < 0) {
	    if (set->irq[i] == 5)
		newtListboxSetCurrent(irqbox, i);
	} else if (currset->irq[0] == set->irq[i]) {
	    newtListboxSetCurrent(irqbox, i);
	}
    }

    if (dmareq) {
	dmabox = newtListbox(-1, -1, 4, NEWT_FLAG_RETURNEXIT | NEWT_FLAG_BORDER);
	if ((set->dma2[0] == 5) && (set->dma[0] == 0)) {
	    dmalab = newtLabel(-1, -1, _("8-bit DMA"));
	} else if (dma2req) {
	    dmalab = newtLabel(-1, -1, _("DMA 1"));
	} else {
	    dmalab = newtLabel(-1, -1, _("DMA"));
	}
	for (i = 0; set->dma[i] != -1; i++) {
	    snprintf(tmpstr, 8, "%2d", set->dma[i]);
	    newtListboxAddEntry(dmabox, tmpstr, (void *) set->dma[i]);
	    if (currset->dma[0] < 0) {
		if (set->dma[i] == 1)
		    newtListboxSetCurrent(dmabox, i);
	    } else if (currset->dma[0] == set->dma[i]) {
		newtListboxSetCurrent(dmabox, i);
	    }
	}
    } else {
	dmabox = newtTextbox(-1, -1, 0, 0, 0);
	dmalab = newtLabel(-1, -1, "");
    }

    if (dma2req) {
	if (set->type == MSND_PINNACLE)
	    dma2lab = newtLabel(-1, -1, _("CONFIG I/O"));
	else if (set->dma2[0] == 5)
	    dma2lab = newtLabel(-1, -1, _("16-bit DMA"));
	else
	    dma2lab = newtLabel(-1, -1, _("DMA 2"));
	dma2box = newtListbox(-1, -1, 4, NEWT_FLAG_RETURNEXIT | NEWT_FLAG_BORDER);
	for (i = 0; set->dma2[i] != -1; i++) {
	    if (set->type == MSND_PINNACLE)
		snprintf(tmpstr, 8, "0x%3x", set->io[i]);
	    else
		snprintf(tmpstr, 8, "%2d", set->dma2[i]);
	    newtListboxAddEntry(dma2box, tmpstr, (void *) set->dma2[i]);
	    if (currset->dma2[0] < 0) {
		if (set->dma2[i] == 5)
		    newtListboxSetCurrent(dma2box, i);
	    } else if (currset->dma2[0] == set->dma2[i]) {
		newtListboxSetCurrent(dma2box, i);
	    }
	}
    } else {
	dma2box = newtTextbox(-1, -1, 0, 0, 0);
	dma2lab = newtLabel(-1, -1, "");
    }

    if (mpu_ioreq) {
	mpu_iolab = newtLabel(-1, -1, _("MPU I/O"));
	mpu_iobox = newtListbox(-1, -1, 4, NEWT_FLAG_RETURNEXIT | NEWT_FLAG_BORDER);
	for (i = 0; set->mpu_io[i] != -1; i++) {
	    snprintf(tmpstr, 8, "0x%3x", set->mpu_io[i]);
	    newtListboxAddEntry(mpu_iobox, tmpstr,
				(void *) set->mpu_io[i]);
	    if (currset->mpu_io[0] < 0) {
		if (set->mpu_io[i] == 0x330)
		    newtListboxSetCurrent(mpu_iobox, i);
	    } else if (currset->mpu_io[0] == set->mpu_io[i]) {
		newtListboxSetCurrent(mpu_iobox, i);
	    }
	}
    } else {
	mpu_iobox = newtTextbox(-1, -1, 0, 0, 0);
	mpu_iolab = newtLabel(-1, -1, "");
    }

    if (mpu_irqreq) {
	mpu_irqlab = newtLabel(-1, -1, _("MPU IRQ"));
	mpu_irqbox = newtListbox(-1, -1, 4, NEWT_FLAG_RETURNEXIT | NEWT_FLAG_BORDER);
	for (i = 0; set->mpu_irq[i] != -1; i++) {
	    snprintf(tmpstr, 8, "%2d", set->mpu_irq[i]);
	    newtListboxAddEntry(mpu_irqbox, tmpstr,
				(void *) set->mpu_irq[i]);
	    if (currset->mpu_irq[0] < 0) {
		if (set->mpu_irq[i] == 9)
		    newtListboxSetCurrent(mpu_irqbox, i);
	    } else if (currset->mpu_irq[0] == set->mpu_irq[i]) {
		newtListboxSetCurrent(mpu_irqbox, i);
	    }
	}
    } else {
	mpu_irqbox = newtTextbox(-1, -1, 0, 0, 0);
	mpu_irqlab = newtLabel(-1, -1, "");
    }

    if (memreq) {
	if (set->type == OPL3_SAX)
	    memlab = newtLabel(-1, -1, _("CONTROL I/O"));
	else if (set->type == SGALAXY)
	    memlab = newtLabel(-1, -1, _("SB I/O"));
	else
	    memlab = newtLabel(-1, -1, _("BASE MEMORY"));
	membox = newtListbox(-1, -1, 4, NEWT_FLAG_RETURNEXIT | NEWT_FLAG_BORDER);
	for (i = 0; set->mem[i] != -1; i++) {
	    if (set->type == OPL3_SAX || set->type == SGALAXY)
		snprintf(tmpstr, 8, "0x%3x", set->mem[i]);
	    else
		snprintf(tmpstr, 8, "0x%5x", set->mem[i]);
	    newtListboxAddEntry(membox, tmpstr, (void *) set->mem[i]);
	    if (currset->mem[0] < 0) {
		if (set->mem[i] == 0xd0000)
		    newtListboxSetCurrent(membox, i);
	    } else if (currset->mem[0] == set->mem[i]) {
		newtListboxSetCurrent(membox, i);
	    }
	}
    } else {
	membox = newtTextbox(-1, -1, 0, 0, 0);
	memlab = newtLabel(-1, -1, "");
    }

    /* pack em */
    grid = newtCreateGrid(1, 3);
    subgrid1 = newtCreateGrid(7, 2);
    subgrid3 = newtButtonBar(_("Ok"), &ok, _("Cancel"), &cancel, NULL);

    if (pnpprobe)
	text = newtReflowText(_("Your sound card is a PnP device, so "
				"its settings can be configured w/o "
				"setting any dip switches.  Choose "
				"the values you would like to use "
				"from the menus below."), 40, 30, 30,
			      &twidth, &theight);
    else
	text = newtReflowText(_("Please adjust the settings below to "
				"match the dip switch settings on your "
				"sound card."), 40, 30, 30,
			      &twidth, &theight);

    instrbox = newtTextbox(-1, -1, twidth, theight, NEWT_FLAG_WRAP);
    newtTextboxSetText(instrbox, text);
    /* free(text); */

    newtGridSetField(subgrid1, 0, 0, NEWT_GRID_COMPONENT, iolab,
		     0, 0, 1, 1, NEWT_ANCHOR_TOP, 0);
    newtGridSetField(subgrid1, 0, 1, NEWT_GRID_COMPONENT, iobox,
		     0, 0, 1, 0, NEWT_ANCHOR_TOP, 0);
    newtGridSetField(subgrid1, 1, 0, NEWT_GRID_COMPONENT, irqlab,
		     1, 0, 1, 1, NEWT_ANCHOR_TOP, 0);
    newtGridSetField(subgrid1, 1, 1, NEWT_GRID_COMPONENT, irqbox,
		     1, 0, 1, 0, NEWT_ANCHOR_TOP, 0);
    newtGridSetField(subgrid1, 2, 0, NEWT_GRID_COMPONENT, dmalab,
		     1, 0, 1, 1, NEWT_ANCHOR_TOP, 0);
    newtGridSetField(subgrid1, 2, 1, NEWT_GRID_COMPONENT, dmabox,
		     1, 0, 1, 0, NEWT_ANCHOR_TOP, 0);
    newtGridSetField(subgrid1, 3, 0, NEWT_GRID_COMPONENT, dma2lab,
		     1, 0, 1, 1, NEWT_ANCHOR_TOP, 0);
    newtGridSetField(subgrid1, 3, 1, NEWT_GRID_COMPONENT, dma2box,
		     1, 0, 1, 0, NEWT_ANCHOR_TOP, 0);
    newtGridSetField(subgrid1, 4, 0, NEWT_GRID_COMPONENT, mpu_iolab,
		     1, 0, 1, 1, NEWT_ANCHOR_TOP, 0);
    newtGridSetField(subgrid1, 4, 1, NEWT_GRID_COMPONENT, mpu_iobox,
		     1, 0, 1, 0, NEWT_ANCHOR_TOP, 0);
    newtGridSetField(subgrid1, 5, 0, NEWT_GRID_COMPONENT, mpu_irqlab,
		     1, 0, 1, 1, NEWT_ANCHOR_TOP, 0);
    newtGridSetField(subgrid1, 5, 1, NEWT_GRID_COMPONENT, mpu_irqbox,
		     1, 0, 1, 0, NEWT_ANCHOR_TOP, 0);
    newtGridSetField(subgrid1, 6, 0, NEWT_GRID_COMPONENT, memlab,
		     1, 0, 0, 1, NEWT_ANCHOR_TOP, 0);
    newtGridSetField(subgrid1, 6, 1, NEWT_GRID_COMPONENT, membox,
		     1, 0, 0, 0, NEWT_ANCHOR_TOP, 0);

    newtGridSetField(grid, 0, 0, NEWT_GRID_COMPONENT, instrbox,
		     0, 0, 0, 0, NEWT_ANCHOR_TOP, 0);
    newtGridSetField(grid, 0, 1, NEWT_GRID_SUBGRID, subgrid1,
		     0, 1, 0, 0, 0, NEWT_GRID_FLAG_GROWX);
    newtGridSetField(grid, 0, 2, NEWT_GRID_SUBGRID, subgrid3,
		     0, 1, 0, 0, 0, NEWT_GRID_FLAG_GROWX);

    newtGridWrappedWindow(grid, _("Card Settings"));

    newtFormAddComponents(form, instrbox, NULL);
    newtFormAddComponents(form, iolab, irqlab, dmalab, dma2lab, mpu_iolab,
			  mpu_irqlab, memlab, NULL);
    newtFormAddComponents(form, iobox, irqbox, dmabox, dma2box, mpu_iobox,
			  mpu_irqbox, membox, NULL);
    newtFormAddComponents(form, ok, cancel, NULL);

    answer = newtRunForm(form);

    if (answer != cancel) {
	rc = 0;
	currset->io[0] = (long) newtListboxGetCurrent(iobox);
	currset->irq[0] = (long) newtListboxGetCurrent(irqbox);
	if (dmareq)
	    currset->dma[0] = (long) newtListboxGetCurrent(dmabox);
	if (dma2req)
	    currset->dma2[0] = (long) newtListboxGetCurrent(dma2box);
	else
	    currset->dma2[0] = -1;
	if (mpu_ioreq)
	    currset->mpu_io[0] = (long) newtListboxGetCurrent(mpu_iobox);
	else
	    currset->mpu_io[0] = -1;
	if (mpu_irqreq)
	    currset->mpu_irq[0] = (long) newtListboxGetCurrent(mpu_irqbox);
	else
	    currset->mpu_irq[0] = -1;
	if (memreq)
	    currset->mem[0] = (long) newtListboxGetCurrent(membox);
	else
	    currset->mem[0] = -1;
    } else {
	rc = -1;
    }

    newtPopWindow();
    newtFormDestroy(form);

    return rc;
}

int WriteConfModules(char tmpfile[], struct settings *set, int quiet, struct device **devs)
{
    char tmpstr[200], modulename[200];
    FILE *f, *w, *t;
    struct stat memstat;
    static int madebackup = 0;
    int tfilefd;

    if ((tfilefd = mkstemp(tmpfile)) < 0)
	return -1;
    close(tfilefd);
    if ((t = fopen(tmpfile, "w")) == NULL)
	return -1;

    snprintf(modulename, 200, " %s ", set->modulename);
    if ((f = fopen("/etc/modules.conf", "r")) != NULL) {
	while (1) {
	    if (!fgets(tmpstr, sizeof(tmpstr), f))
		break;

	    /* UGLY - skip these lines since we'll rewrite them */
	    /* Now even uglier */
	    if (strstr(tmpstr, "char-major-14") ||
		strstr(tmpstr, modulename) || strstr(tmpstr, " sound-slot") ||
		strstr(tmpstr, " sound ") || strstr(tmpstr, " midi ") ||
		strstr(tmpstr, " synth0 ") ||
		strstr(tmpstr, " opl3 ") || strstr(tmpstr, " mpu401 ") ||
		strstr(tmpstr, " ad1848 ") || strstr(tmpstr, " sb ") ||
		(strstr(tmpstr, " awe_wave ") && (set->flags & HAS_AWE)) ||
		(strstr(tmpstr, " cs4232 ") && (set->flags & LOAD_CS4232)))
		continue;

	    fputs(tmpstr, t);
	}
	fclose(f);
    }

    if (!madebackup && !access("/etc/modules.conf", F_OK)) {
	if ((f = fopen("/etc/modules.conf", "r")) != NULL &&
	    (w = fopen("/etc/modules.conf.bak", "w")) != NULL) {
		while (1) {
			if (!fgets(tmpstr, sizeof(tmpstr), f))
			  break;
			fputs(tmpstr,w);
		}
		fclose(f);
		fclose(w);
	} else {
		fclose(t);
		unlink(tmpfile);
		return -1;
	}
	madebackup = 1;
    }


    fprintf(t, "alias sound-slot-0 %s\n", set->modulename);
    fprintf(t, "post-install sound-slot-0 /bin/aumix-minimal -f /etc/.aumixrc -L >/dev/null 2>&1 || :\n");
    fprintf(t, "pre-remove sound-slot-0 /bin/aumix-minimal -f /etc/.aumixrc -S >/dev/null 2>&1 || :\n");
    /* If the user has an ISA card and > 16MB of memory,
     * we want to lock ISA dma buffers. */
    if (!stat("/proc/kcore", &memstat))
	if ((set->bus == isa) && (memstat.st_size > 16777216))
	    fprintf(t, "options sound dmabuf=1\n");

    if (set->flags & HAS_OPL3) {
	if (!(set->flags & HAS_AWE))
	    fprintf(t, "alias synth0 opl3\n");
	fprintf(t, "options opl3 io=0x388\n");
    }
    if (set->flags & LOAD_CS4232) {
	fprintf(t, "alias midi %s\n", set->modulename);
	fprintf(t, "options %s io=0x%x irq=%d\n", set->modulename,
		set->mpu_io[0], set->mpu_irq[0]);
	fprintf(t, "pre-install %s /sbin/modprobe \"cs4232\"\n",
		set->modulename);
	snprintf(set->modulename, 32, "cs4232");
    }
    if (set->flags & HAS_MPU401) {
	fprintf(t, "alias midi mpu401\n");
	fprintf(t, "options mpu401 io=0x%x irq=%d\n",
		set->mpu_io[0], set->mpu_irq[0]);
	if (set->type != MSND_PINNACLE) {
	    set->mpu_io[0] = -1;
	    set->mpu_irq[0] = -1;
	}
    }
    if (set->flags & HAS_AWE)
	fprintf(t,
		"alias synth0 awe_wave\npost-install awe_wave /bin/sfxload /etc/midi/GU11-ROM.SF2\n");

    if (set->flags & SB_AS_LIB)
	fprintf(t, "options sb support=1\n");

    if (set->flags & ACI)
	fprintf(t, "post-install %s /sbin/modprobe \"aci\"\n",
		set->modulename);

    if (set->flags & NO_INPUT_REQ) {
	if (set->type == ADLIB) {
	    fprintf(t, "options adlib_card io=0x388\n");
	} else if (set->bus == isa) {
		fprintf(t, "options %s isapnp=1\n",set->modulename);
	}
	if (devs && !strcmp(devs[0]->driver,"i810_audio")) {
		if (
		    ((struct pciDevice *)devs[0])->subVendorId == 0x1028 &&
		    ( ((struct pciDevice *)devs[0])->subDeviceId == 0x00d2 ||
		     /* ((struct pciDevice *)devs[0])->subDeviceId == 0x00d8 || */
		     ((struct pciDevice *)devs[0])->subDeviceId == 0x00be )) {
			fprintf(t, "options i810_audio ftsodell=1\n");
		}
	    
	}
    } else {
	fprintf(t, "options %s", set->modulename);
	if (set->io[0] != -1) {
	    if (set->type == OPL3_SAX)
		fprintf(t, " mss_io=0x%x", set->io[0]);
	    else {
		if (!strcmp(set->modulename, "mad16")) {
		    /* MAD16 cards are now picky about the MSS IO/port */
		    if (set->io[0] % 16)
			set->io[0] -= 4;
		    fprintf(t, " io=0x%x", set->io[0]);
		} else
		    fprintf(t, " io=0x%x", set->io[0]);
	    }
	}
	if (set->irq[0] != -1)
	    fprintf(t, " irq=%d", set->irq[0]);
	if (set->dma[0] != -1)
	    fprintf(t, " dma=%d", set->dma[0]);
	if (set->dma2[0] != -1) {
	    /* The great thing about standards is that there are so many
	     * to choose from.... */
	    if (!strcmp(set->modulename, "sb") ||
		!strcmp(set->modulename, "pas2") ||
		!strcmp(set->modulename, "gus") ||
		!strcmp(set->modulename, "mad16")
		)
		/* Vibra 16X sucks rocks. */  {
		if ((set->type != SB16) || (set->dma2[0] >= 5))
		    fprintf(t, " dma16=%d", set->dma2[0]);
	    } else if (set->type == MSND_PINNACLE)
		fprintf(t, " cfg=0x%x", set->dma2[0]);
	    else
		fprintf(t, " dma2=%d", set->dma2[0]);
	}
	if (set->mpu_io[0] != -1 && set->type != SGALAXY) {
	    if (set->flags & LOAD_CS4232) {
		fprintf(t, " synthio=0x%x", set->mpu_io[0]);
	    } else {
		if (!strcmp(set->modulename, "cs4232"))
		    /* No, we can't use the same name as everyone else! */
		    fprintf(t, " mpuio=0x%x", set->mpu_io[0]);
		else
		    fprintf(t, " mpu_io=0x%x", set->mpu_io[0]);
	    }
	}
	if (set->mpu_irq[0] != -1 && set->type != SGALAXY) {
	    if (set->flags & LOAD_CS4232) {
		fprintf(t, " synthirq=%d", set->mpu_irq[0]);
	    } else {
		if (!strcmp(set->modulename, "cs4232"))
		    fprintf(t, " mpuirq=%d", set->mpu_irq[0]);
		else
		    fprintf(t, " mpu_irq=%d", set->mpu_irq[0]);
	    }
	}
	/* CS4232 requires synth* if WaveFront support is compiled in */
	if (!strcmp(set->modulename, "cs4232")
	    && !(set->flags & LOAD_CS4232) && isAvailable("wavefront.o"))
	    fprintf(t, " synthirq=-1 synthio=-1");
	if (set->mem[0] != -1) {
	    if (set->type == OPL3_SAX) {
		/* This is a stupid hack used to avoid adding another field... */
		fprintf(t, " io=0x%x", set->mem[0]);
	    } else if (set->type == SGALAXY) {
		/* Ditto */
		fprintf(t, " sgbase=0x%x", set->mem[0]);
	    } else {
		fprintf(t, " mem=0x%x", set->mem[0]);
	    }
	}
	if (set->flags & JOYSTICK)
	    fprintf(t, " joystick=1");
	if (set->flags & SM_GAMES)
	    fprintf(t, " sm_games=1");
	if (set->flags & COMPAQ)
	    fprintf(t, " deskpro_xl=1");
	if (set->flags & ACER)
	    fprintf(t, " acer=1");
	if (set->flags & SOUNDPRO)
	    fprintf(t, " soundpro=1");
	fprintf(t, "\n");
    }

    fclose(t);
    chmod(tmpfile, 0644);
    return 0;
}

static int TestSndCard(char tmpfile[], int dopnp, struct settings *set)
{
    char *modargs[] = { "/sbin/modprobe", "-C", NULL, "sound-slot-0", NULL, NULL, NULL };
    char *playargs[] =
	{ "/usr/bin/play", NULL, NULL, NULL,
	    NULL };
    char *err, *errbuf;
    char *sample;
    char *out;
    char buf[8000];
    int fd, od;
    int rc = 0;

    modargs[2] = tmpfile;
    if (set->type != ADLIB) {

	newtWinMessage(_("Sound Card Test"), _("Ok"),
		       _("A sound sample will now be played"
			 " to determine if your sound card has been correctly"
			 " configured."));

	cleanupmods(set);
	newtSuspend();
	rc = RunCmd("/sbin/modprobe", modargs, &out, &err);
	if (rc) {
	    newtResume();
	    errbuf = strdup(_("The following error occurred running the "
			      "modprobe program:\n\n"));
	    errbuf = realloc(errbuf, strlen(errbuf) + strlen(err) + 1);
	    strcat(errbuf, err);
	    newtWinMessage(_("modprobe error"), _("Ok"), errbuf);
	    free(errbuf);
	    free(err);
	    return -1;
	}


	sample = getenv("LANG");
	if (sample && !strncmp(sample,"sv",2))
	      sample = strdup("/usr/share/sndconfig/sample2.au");
	else
	      sample = strdup("/usr/share/sndconfig/sample.au");
	playargs[1] = sample;
	if (set->flags & NEEDS_SOX) {
	    rc = RunCmd("/usr/bin/play", playargs, &out, &err);
	    newtResume();
	    if (rc) {
		errbuf = strdup(_("The following error occurred "
				  "playing the sample:\n\n"));
		errbuf = realloc(errbuf, strlen(errbuf) + strlen(err) + 1);
		strcat(errbuf, err);
		newtWinMessage(_("Unable To Play Audio"), _("Ok"), errbuf);
		free(errbuf);
		free(err);
		return -1;
	    }
	    free(err);
	} else {
	    newtResume();
	    fd = open(sample, O_RDONLY);
	    if (fd < 0) {
		newtWinMessage(_("Sample Not Found"), _("Ok"),
			       _
			       ("The sound sample does not appear to be installed."));
		return -1;
	    }
	    od = open("/dev/audio", O_WRONLY);
	    if (od < 0) {
		newtWinMessage(_("Unable To Play Audio"), _("Ok"),
			       _("An error occurred opening /dev/audio"));
		return -1;
	    }

	    while (1) {
		rc = read(fd, buf, sizeof(buf));
		if (!rc)
		    break;
		write(od, buf, rc);
	    }

	    close(fd);
	    close(od);
	}

	if (strcmp(set->modulename,"sb") && strcmp(set->modulename,"cs4232") && set->flags & HAS_OPL3)
	      cleanupmods(set);

	rc = newtWinChoice(_("Test Result"), _("Yes"), _("No"),
			   _("Were you able to hear the sample?"));

	if (rc == 2)		/* User said No */
	    return -1;
    }
   
    if (set->flags & HAS_AWE) {
        newtWinMessage(_("AWE32/64 Detected"), _("Ok"),
		       _("An AWE32/64 has been detected in your machine. "
			 "If you intend to use the hardware synth, ensure "
			 "the 'awesfx' package is installed."));
    }
	
    return rc;
}

/* this is really, really *evil* */

void mungeisapnp(struct settings *set, struct device **devs) {
	struct isapnpDevice *dev;
	int x;
	
	if (devs[0]->bus != BUS_ISAPNP) {
		return;
	}
	for (x = 0 ; devs[x]; x++) {
		if (devs[x]->bus == BUS_ISAPNP) {
			dev = (struct isapnpDevice *)devs[x];
			if (!strcmp(dev->driver,"awe_wave"))
			  set->flags |= HAS_AWE;
			if (!dev->native) {
				if (!dev->active)
				isapnpActivate(&dev);
			if (!strcmp(dev->driver,set->modulename)) {
				switch (dev->logdev) {
				 case 0:
					/* IRQ */
					switch (set->type) {
					 case SOUNDSCAPE:
						if (dev->irq) {
							set->mpu_irq[0] = dev->irq[0];
							if (dev->irq[1] != -1)
							  set->irq[0] = dev->irq[1];
						}
						break;
					 default:
						if (dev->irq) {
							set->irq[0] = dev->irq[0];
							if (dev->irq[1] != -1) 
							  set->mpu_irq[0] = dev->irq[1];
						}
						break;
					}
					/* DMA */
					if (dev->dma) {
						set->dma[0] = dev->dma[0];
						set->dma[1] = dev->dma[1];
					}
					/* IO ports. Welcome To Hell. */
					switch (set->type) {
					 case OPL3_SAX:
						if (dev->io) {
							set->io[0] = dev->io[1];
							if (dev->io[2] != -1)
							  set->mpu_io[0] = dev->io[3];
							if (dev->io[3] != -1)
							  set->mem[0] = dev->io[4];
						}
						break;
					 case CMI8330:
						if (dev->io) 
						  set->io[0] = dev->io[0];
						break;
					 case CS4232:
						if (dev->io)
						  set->io[0] = dev->io[0];
						break;
					 case SSVIVO:
						if (dev->io) {
							set->mpu_io[0] = dev->io[0];
							set->io[0] = dev->io[1];
						}
						break;
					 case SOUNDSCAPE:
						if (dev->io)
						  set->mpu_io[0] = dev->io[0];
						break;
					 default:
						break;
					}
					break;
				 case 1:
					switch (set->type) {
					 case SGALAXY:
						if (dev->io) {
							set->mem[0] = dev->io[0];
							if (dev->io[1] != -1)
							  set->io[0] = dev->io[2];
						}
						break;
					 case CMI8330:
						if (dev->io)
						  set->mpu_io[0] = dev->io[0];
						break;
					 case MOZART:
						if (dev->io)
						  set->io[0] = dev->io[1];
						break;
					 case MAD16PRO:
						if (dev->io)
						  set->io[0] = dev->io[0];
						break;
					 case SOUNDSCAPE:
						if (dev->io)
						  set->io[0] = dev->io[0];
						break;
					 default:
						break;
					}
					break;
				 case 2:
					if (set->type == SGALAXY) {
						if (dev->io)
						  set->mpu_io[0] = dev->io[0];
					}
					break;
				 case 3:
					switch (set->type) {
					 case CS4232:
					 case MOZART:
					 case MAD16PRO:
						if (dev->io)
						  set->mpu_io[0] = dev->io[0];
						if (dev->irq)
						  set->mpu_irq[0] = dev->irq[0];
						break;
					 default:
						break;
					}
					break;
				 default:
					break;
				}
			}
			} else {
				set->flags |= NO_INPUT_REQ;
			}
		}
	}
}

int main(int argc, char **argv)
{
    char tmpfile[32];
    int pnpprobe = 0;
    int rc;
    int success = 0;
    int quiet = 0;
    char *id, *ansistr;
    enum cards type = UNSPEC;
    struct settings set, tmpset;
    int nm256sucks = 0, noprobe = 0, autoconfig = 1, mungepnp = 0;
    struct device **devs = NULL;

    setlocale(LC_ALL, "");
    bindtextdomain("sndconfig", "/usr/share/locale");
    textdomain("sndconfig");
    setenv("PATH", "/sbin:/usr/sbin:/bin:/usr/bin", 1);

#ifndef DEBUG
    /* make sure we should even be running */
    if (getuid()) {
	fprintf(stderr,
		_("\nERROR - You must be root to run sndconfig.\n"));
	exit(1);
    }
#endif

    if (argc > 1) {
	if (!strcmp(argv[1], "--help")) {
	    fprintf(stderr,
		    _
		    ("Usage: sndconfig [--help] [--noprobe]\n"
		     "     --noprobe    do not probe for PnP sound cards.\n"
		     "     --quiet automatically configure without user input (use with caution)\n\n"));
	    return 0;
	} else if (!strcmp(argv[1], "--noprobe")) {
	    noprobe = 1;
	} else if (!strcmp(argv[1], "--quiet")) {
	    quiet = 1;
	} else if (!strcmp(argv[1], "--mungepnp")) {
		mungepnp = 1;
		quiet = 1;
	}
    }
    if (argc > 2) {
	if (!strcmp(argv[2], "--noprobe")) {
	    noprobe = 1;
	}
    }

    if (!quiet)
	NewtStartUp();

    /* read in old soundcard settings */
    rc = ReadOldCardSettings(&tmpset);

    if (rc)
	memset(&tmpset, 0, sizeof(struct settings));
    else
	type = tmpset.type;

    if (!quiet) {
	rc = newtWinChoice(_("Introduction"), _("Ok"), _("Cancel"),
			   _("sndconfig is a configuration tool for "
			     "legacy sound cards.\n\n%s%s\n\n"
			     "Report bugs at http://bugzilla.redhat.com/bugzilla/")
			   ,
			   (noprobe) ?
			   _("The automatic probing for PnP cards has "
			     "been DISABLED") :
			   _("A probe will now be performed for any PnP "
			     "cards"),
			   "."
	    );
	if (rc == 2) {		/* user said no */
	    newtFinished();
	    exit(0);
	}
#ifdef __i386__
	if (!isAvailable("soundcore")) {
	    newtWinMessage(_("ERROR: No Sound Modules found"), _("Ok"),
			 _("You don't seem to be running a kernel with modular "
			    "sound enabled. (soundcore.o was not found in the module "
			    "search path).\nTo use sndconfig, you must be running "
			    "a kernel with modular sound, such as the "
			    "kernel shipped with Red Hat Linux or a 2.2 or greater "
			    "kernel. "));
	    newtFinished();
	    return -1;
	}
#endif
    }
    /* Find available modules */
    for (rc = 0; cards[rc].type != UNSPEC; rc++) {
	if (quiet || isAvailable(cards[rc].modulename)) {
	    cards[rc].avail = 1;
	}
    }

    if (!noprobe) {
	initializeDeviceList();
	devs = probeDevices(CLASS_AUDIO, BUS_UNSPEC, PROBE_ALL);
	if (mungepnp) {
		if (devs && devs[0]->bus == BUS_ISAPNP && 
		    ((struct isapnpDevice *)devs[0])->native == 0) {
			quiet = 1;
		} else {
			exit(0);
		}
	}
	if (devs) {
	    char *busname;
	    char title[50];
	    int x;
	     
	    for (x=0; buses[x].busType != devs[0]->bus; x++);
	    busname = buses[x].string;
	    snprintf(title, 50, _("%s Probe Results"),
		     busname);
	    if (!quiet)
		newtWinMessage(title, _("Ok"), _("A %s "
						 "sound card was found in your system. The details "
						 "are:\n\n     Model: %s"),
			       busname, devs[0]->desc);
	    if (!strcmp(devs[0]->driver, "unknown")) {
		if (!quiet) {
		    newtWinMessage(title, _("Ok"),
				   _("The %s is not supported."),
				   devs[0]->desc);
		    newtFinished();
		}
		return 1;
	    } else if (!strcmp(devs[0]->driver, "disabled")) {
		if (!quiet) {
		    newtWinMessage(title, _("Ok"),
				   _("The %s is currently supported, but yours is currently disabled. You can possibly fix "
				     "this by setting 'PnP OS' to 'no' in your BIOS."),devs[0]->desc);
		    newtFinished();
		}
	        return 1;
	    } else if (!strcmp(devs[0]->driver, "ac")) {
		if (!quiet) {
		    newtWinMessage(title, _("Ok"),
				   _
				   ("The %s is not currently supported; however, work is progressing on a driver."),
				   devs[0]->desc);
		    newtFinished();
		}
		return 1;
	    } else if (!strcmp(devs[0]->driver, "alsa")) {
		if (!quiet) {
		    newtWinMessage(title, _("Ok"),
				   _
				   ("The %s is not supported currently; however, the ALSA project (http://www.alsa-project.org/) has a driver for this card."),
				   devs[0]->desc);
		    newtFinished();
		}
		return 1;
	    } else if (!strcmp(devs[0]->driver, "cs4231")) {
		type = CS4231;
	    } else if (!strcmp(devs[0]->driver, "amd7930")) {
		type = AMD7930;
	    } else if (!strcmp(devs[0]->driver, "dbri")) {
		type = DBRI;
	    } else if (!strcmp(devs[0]->driver, "es1370")) {
		type = ES1370;
	    } else if (!strcmp(devs[0]->driver, "cs46xx")) {
		type = CS46XX;
	    } else if (!strcmp(devs[0]->driver, "cs4281")) {
		type = CS4281;
#ifdef kernel_got_fixed    
	    } else if (!strcmp(devs[0]->driver, "ali_m1553")) {
		type = ALIM15XX;
#endif
	    } else if (!strcmp(devs[0]->driver, "esssolo1")) {
		type = ESSSOLO1;
	    } else if (!strcmp(devs[0]->driver, "cmpci")) {
		type = CMI8X38;
	    } else if (!strcmp(devs[0]->driver, "via82cxxx_audio")) {
		type = VIA82CXXX;
	    } else if (!strcmp(devs[0]->driver, "es1371")) {
		type = ES1371;
	    } else if (!strcmp(devs[0]->driver, "maestro")) {
		type = ESSMAESTRO;
	    } else if (!strcmp(devs[0]->driver, "maestro3")) {
		type = ESSMAESTRO3;
	    } else if (!strcmp(devs[0]->driver, "nm256_audio")) {
		type = NEOMAGIC;
	    } else if (!strcmp(devs[0]->driver, "ad1848")) {
	        type = WSS;
		autoconfig = 0;
		nm256sucks = 1;
	    } else if (!strcmp(devs[0]->driver, "emu10k1")) {
	        type = SBLIVE;
	    } else if (!strcmp(devs[0]->driver, "trident")) {
	        type = TRIDENT;
	    } else if (!strcmp(devs[0]->driver, "ymfpci")) {
	        type = YMFPCI;
	    } else if (!strcmp(devs[0]->driver, "i810_audio")) {
	        type = I810;
	    } else if (!strcmp(devs[0]->driver, "sonicvibes")) {
		type = SONICVIBES;
	    } else if (devs[0]->bus == BUS_ISAPNP) {
		    if (strstr(((struct isapnpDevice *)devs[0])->pdeviceId, "CTL")) {
			    if (strstr(devs[0]->desc, "16"))
			      type = SB16;
			    else if (strstr(devs[0]->desc, "32"))
			      type = SB32;
			    else if (strstr(devs[0]->desc, "64"))
			      type = SB32;
			    else
			      type = SB16;
		    } else if (strstr(((struct isapnpDevice *)devs[0])->pdeviceId, "ALS")) {
			    type = ALS100;
		    }  else if (strstr(((struct isapnpDevice *)devs[0])->pdeviceId, "GRV")) {
			    type = GUSPNP;
		    } else if (strstr(((struct isapnpDevice *)devs[0])->pdeviceId, "CSC")) {
			    type = CS4232;
		    } else if (strstr(((struct isapnpDevice *)devs[0])->pdeviceId, "TER") || strstr(((struct isapnpDevice *)devs[0])->pdeviceId, "LWC")) {
			    type = AD1816;
		    } else if (strstr(((struct isapnpDevice *)devs[0])->pdeviceId, "OPT")) {
			    if (strstr(((struct isapnpDevice *)devs[0])->pdeviceId, "931")) {
				    type = MAD16PRO;
			    } else if (strstr(((struct isapnpDevice *)devs[0])->pdeviceId, "925")) {
				    type = MOZART;
			    } else {
				    type = MOZART;  /* definitely maybe... */
			    }
		    } else if (strstr(((struct isapnpDevice *)devs[0])->pdeviceId, "AZT")) {
			    type = SGALAXY;
		    } else if (strstr(((struct isapnpDevice *)devs[0])->pdeviceId, "ENS")) {
			    if (strstr(devs[0]->desc, "VIVO"))
			      type = SSVIVO;
			    else
			      type = SOUNDSCAPE;
		    } else if (strstr(((struct isapnpDevice *)devs[0])->pdeviceId, "ESS")) {
			    type = ESS1868;
		    } else if (strstr(((struct isapnpDevice *)devs[0])->pdeviceId, "YMH")) {
			    type = OPL3_SAX;
		    } else if (strstr(((struct isapnpDevice *)devs[0])->pdeviceId, "CMI")) {
			    type = CMI8330;
		    } else if (!quiet) {
			    newtWinMessage(title, _("Ok"),
					   _("The %s is not currently supported."),
					   devs[0]->desc);
			    newtFinished();
		    }
	    } else {
		if (!quiet) {
		    newtWinMessage(title, _("Ok"),
				   _("The %s is not currently supported."),
				   devs[0]->desc);
		    newtFinished();
		}
		return 1;
	    }
	    if (type != WSS)
		pnpprobe++;
	} else {
	    autoconfig = 0;
	}
    } else {
	    autoconfig = 0;
    }
    if (type != UNSPEC && !quiet && !isAvailable(cards[type].modulename)) {
#ifndef __sparc__	    
	if (cards[type].messageno) {
	    if (!quiet) {
		newtWinMessage(_("No driver available"), _("Ok"),
			       strdup(messages[cards[type].messageno]));
		newtFinished();
	    }
	    return 1;
	} else {
#endif
	    if (!quiet) {
		newtWinMessage(_("No driver available"), _("Ok"),
			       _("The module used for your card, %s.o, is not "
			       "currently in your module search path. Please "
			       "verify that your kernel modules are correctly "
			       "installed. "), cards[type].modulename);
		newtFinished();
	    }
	    return 1;
#ifndef __sparc__
	}
#endif
    }

    rc = 1;
    while (rc) {
	if (pnpprobe && !noprobe && autoconfig) {
	    set = cards[type];
	    memcpy(&tmpset, &set, sizeof(struct settings));
	    rc = 0;
	} else {
	    if (quiet)
		return 1;
	    if (!nm256sucks) {
		if (!noprobe && !pnpprobe)
			newtWinMessage(_("Probe Results"), _("Ok"),
			       _("No PnP or PCI sound cards were found in "
				 "your system. Please select your card type "
				 "from the following list."));
	    	rc = GetCardType(&type);
	    	if (rc) {
			newtFinished();
			exit(1);
	    	}
	    }
	    set = cards[type];
	    if (set.type != type)
		pnpprobe = 0;
	    if (tmpset.type != set.type) {
		memcpy(&tmpset, &set, sizeof(struct settings));
		if (set.flags & NO_INPUT_REQ) {
		    tmpset.irq[0] = -1;
		    tmpset.dma[0] = -1;
		    tmpset.dma2[0] = -1;
		    tmpset.mpu_io[0] = -1;
		    tmpset.mpu_irq[0] = -1;
		    tmpset.mem[0] = -1;
		}
	    }
	}
	if (set.messageno && set.messageno <= 3 && !quiet) {
	    newtWinMessage(_("Card Information"), _("Ok"),
			   strdup(messages[set.messageno]));
	}
	if (!(set.flags & NO_INPUT_REQ))
	    if (!autoconfig)
		rc = EditSettings(pnpprobe, &set, &tmpset);
	if (!rc) {
	    WriteCardSettings(&tmpset);
	    if (devs)
		  mungeisapnp(&tmpset,devs);
	    snprintf(tmpfile,31,"/etc/sndconfig-XXXXXX");
	    if (WriteConfModules(tmpfile, &tmpset, quiet, devs) != 0) {
		    unlink(tmpfile);
		    if (!quiet) {
			    newtWinMessage(_("Error"),_("Ok"),
					   _("An error occurred while writing the config file."));
			    break;
		    } else {
			    return 0;
		    }
	    } else {
		    if (quiet) {
			    rename(tmpfile, "/etc/modules.conf");
			    return 0;
		    } else {
			    rc = TestSndCard(tmpfile, pnpprobe && !noprobe, &tmpset);
			    if (rc < 0) {
				    /* If we're in autoconfig, we'll get stuck in a loop if
				     * the sound test fails...
				     */
				    if (autoconfig && pnpprobe) {
					    rc =
					      newtWinChoice(_("Autoconfiguration failed!"),
							    _("Ok"), _("Cancel"),
							    _
							    ("Autoconfiguration of your sound card "
							     "failed. Now proceeding with manual "
							     "configuration."));
					    autoconfig = 0;
					    if (rc == 2)
					      break;
					    unlink(tmpfile);
					    continue;
				    }
				    cleanupmods(&tmpset);
				    unlink(tmpfile);
				    continue;
			    } else {
				    newtWinMessage(_("File Exists"), _("Ok"),
						   ("There is already a file called /etc/modules.conf."
						    " The existing file will be renamed "
						    "/etc/modules.conf.bak and a new file will be "
						    "written."));
				    rename(tmpfile, "/etc/modules.conf");
				    success = 1;
				    break;
			    }
		    }
	    }
	}
    }
    unlink(tmpfile);

    newtFinished();

    cleanupmods(&tmpset);
    if (success) {
	sleep(1);
	startsound(&tmpset);
    }
    return 0;
}
