#ifndef MESSAGES_H
#define MESSAGES_H

char *messages[] =
{
    /* Dummy placeholder */
"",
    /* TB Classic */
"To use the synthesizer on these cards, you need to obtain "
"firmware files.\n"
"\n"
"Obtaining and Creating Firmware Files\n"
"~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n"
"\n"
"Download to /tmp and unzip the following file from Turtle Beach:\n"
"\n"
"  ftp://ftp.tbeach.com/pub/tbs/msndcl/msndvkit.zip\n"
"\n"
"When unzipped, unzip the file named MsndFiles.zip.  Then copy the "
"following firmware files to /etc/sound (note the file renaming):\n"
"\n"
"  cp DSPCODE/MSNDINIT.BIN /etc/sound/msndinit.bin\n"
"  cp DSPCODE/MSNDPERM.REB /etc/sound/msndperm.bin\n"
"\n",
    /* TB Pinnacle */
"To use the synthesizer on these cards,\nyou need to obtain\n"
"firmware files.\n"
"\n"
"Obtaining and Creating Firmware Files\n"
"~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n"
"\n"
"Download to /tmp and unzip the following file from Turtle Beach (be "
"sure to use the entire URL; some have had trouble navigating to the "
"URL):\n"
"\n"
"	ftp://ftp.voyetra.com/pub/tbs/pinn/pnddk100.zip\n"
"\n"
"Put the following lines into a file named conv.l (between the start "
"and end lines):\n"
"\n"
"-- conv.l start --\n"
"%%%%\n"
"[ \\n\\t,\\r]     ;\n"
"\\;.*           ;\n"
"DB             ;\n"
"[0-9A-Fa-f]+H  { int n; sscanf(yytext, \"%xH\", &n); printf(\"%c\", n); }\n"
"-- conv.l end --\n"
"\n"
"Then, compile the conv program with GNU make with the following "
"command:\n"
"\n"
"  make LEX=flex LOADLIBES=-lfl conv\n"
"\n"
"This should give you an executable named conv.  Now, we create the "
"binary firmware files by doing the following conversion (assuming the "
"archive unpacked into a directory named PINNDDK):\n"
"\n"
"  ./conv < PINNDDK/dspcode/pndspini.asm > /etc/sound/pndspini.bin\n"
"  ./conv < PINNDDK/dspcode/pndsperm.asm > /etc/sound/pndsperm.bin\n"
"\n"
"The conv (and conv.l) program is not needed after conversion and can "
"be safely deleted.\n"
"\n",
    /* Wavefront */
"To use the synthesizer on these cards,\nyou need to obtain\n"
"firmware files.\n"
"\n"
"Obtaining and Creating Firmware Files\n"
"~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n"
"\n"
"If you have a WaveFront card, then you "
"almost certainly have the firmware; if not, it is freely available "
"on their website at:\n"
"\n"
"  http://www.tbeach.com/tbs/downloads/scardsdown.htm#tropezplus\n"
"\n"
"The file is called WFOS2001.MOT (for the Tropez+).\n"
"This driver, however, doesn't use the pure firmware as distributed, "
"but instead relies on a somewhat processed form of it. You can "
"generate this very easily. Following an idea from Andrew Veliath's "
"Pinnacle driver, the following flex program will generate the "
"processed version:\n"
"\n"
"---- cut here -------------------------\n"
"%%option main\n"
"%%%%\n"
"^S[28].*\\r$ printf (\"%%c%%.*s\", yyleng-1,yyleng-1,yytext);\n"
"<<EOF>> { fputc ('\\0', stdout); return; }\n"
"\\n {}\n"
".  {}\n"
"---- cut here -------------------------\n"
"\n"
"To use it, put the above in a file (say, ws.l) and compile it like this:\n"
"\n"
"  shell> flex -ows.c ws.l\n"
"  shell> cc -o ws ws.c\n"
"\n"
"and then use it like this:\n"
"\n"
"  ws < my-copy-of-the-oswf.mot-file > /etc/sound/wavefront.os\n"
"\n"
"If you put it somewhere else, you'll always have to use the wf_ospath "
"module parameter (see below) or alter the source code."
};

#endif

