;;; Snd documentation index (generated by make-index.scm)

(provide 'snd-index.scm)

(define html 
  (let ((+documentation+ "(html arg) where arg can be a string, symbol, or procedure looks for a corresponding url 
and if one is found, and the Snd documentation can be found, calls *html-program* with that url")
	(goto-html
	 (lambda (n)
	   ;; look for doc on current dir, then html dir, then global dir
	   ;; snd.html is what we'll search for
	   (when (and (string? n)
		      (> (length n) 0))
	     (let ((dir (cond ((file-exists? "snd.html") (getcwd))
			      ((and (string? *html-dir*)
				    (file-exists? (string-append *html-dir* "/snd.html")))
			       *html-dir*)
			      ((file-exists? "/usr/share/doc/snd-18/snd.html")       "/usr/share/doc/snd-18")
			      ((file-exists? "/usr/local/share/doc/snd-18/snd.html") "/usr/local/share/doc/snd-18")
			      ((file-exists? "/usr/doc/snd-18/snd.html")             "/usr/doc/snd-18")
			      ((file-exists? "/usr/share/doc/snd-17/snd.html")       "/usr/share/doc/snd-17")
			      ((file-exists? "/usr/local/share/doc/snd-17/snd.html") "/usr/local/share/doc/snd-17")
			      (else (and (file-exists? "/usr/doc/snd-17/snd.html")   "/usr/doc/snd-17")))))
	       (if dir
		   (system (string-append *html-program* " file:" dir "/" n))))))))
    (lambda (obj)
      (let ((name (if (string? obj) 
		      obj
		      (if (symbol? obj) 
			  (symbol->string obj)
			  (let ((doc (and (procedure? obj)
					  (documentation obj))))
			    (if (and (string? doc)
				     (char=? (doc 0) #\())
				(let ((pos (char-position ") " doc)))
				  (and pos
				       (substring doc 1 pos)))))))))
	(format *stderr* "name: ~S~%" name)
	(cond ((not (string? name))
	       (snd-print (format #f "no doc for ~A?" name)))   
	      ((snd-url name) => goto-html)
	      (else (snd-print (format #f "no url for ~A?" name))))))))

